/*
 * Decompiled with CFR 0.152.
 */
package com.topisystems.midp.bigblocks;

import com.topisystems.shared.ui.Location;

public final class BlockField {
    public byte[] field;
    public int width;
    public int height;
    public int blockWidth;
    public int blockHeight;

    BlockField() {
    }

    public BlockField(byte[] byArray, int n, int n2, int n3, int n4) {
        if (byArray == null) {
            throw new IllegalArgumentException("field is null");
        }
        if (n * n2 != byArray.length) {
            throw new IllegalArgumentException("incorrect blockfield size");
        }
        this.field = byArray;
        this.width = n;
        this.height = n2;
        this.blockWidth = n3;
        this.blockHeight = n4;
    }

    public Location getPosition(int n) {
        int n2 = 0;
        while (n2 < this.field.length) {
            if (this.field[n2] == (byte)n) {
                return new Location(n2 % this.width, n2 / this.width, n2);
            }
            ++n2;
        }
        return null;
    }

    public int count(int n) {
        int n2 = 0;
        int n3 = this.field.length;
        while (n3 > 0) {
            if (this.field[--n3] != (byte)n) continue;
            ++n2;
        }
        return n2;
    }

    public Location[] getPositions(int n) {
        Location[] locationArray = new Location[this.count(n)];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.field.length) {
            if (this.field[n3] == (byte)n) {
                locationArray[n2++] = new Location(n3 % this.width, n3 / this.width, n3);
            }
            ++n3;
        }
        return locationArray;
    }
}

