/*
 * Decompiled with CFR 0.152.
 */
package com.topisystems.midp.goldrush;

import com.topisystems.midp.bigblocks.BlockField;
import com.topisystems.midp.bigblocks.FieldDisplay;
import com.topisystems.midp.goldrush.Cart;
import com.topisystems.midp.goldrush.Dynamite;
import com.topisystems.midp.goldrush.ExplItem;
import com.topisystems.midp.goldrush.Explosion;
import com.topisystems.midp.goldrush.GoldRushConstants;
import com.topisystems.midp.goldrush.GoldRushMidlet;
import com.topisystems.midp.goldrush.Level;
import com.topisystems.midp.goldrush.Player;
import com.topisystems.midp.goldrush.StatusBar;
import com.topisystems.midp.goldrush.WaterField;
import com.topisystems.midp.goldrush.WaterItem;
import com.topisystems.midp.shared.GameCanvas;
import com.topisystems.shared.ui.Dimension;
import com.topisystems.shared.ui.Location;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GoldRushDisplay
extends GameCanvas
implements GoldRushConstants,
Runnable {
    private int[] f1 = new int[]{52, 54, 53, 51, 54, 52, 54, 51};
    private int f2;
    private Thread f3;
    private FieldDisplay f4;
    private Player f5;
    private Vector f6;
    private Vector f7;
    private Vector f8;
    private Cart f9;
    private Cart f10;
    private long f11;
    private Level f12;
    private BlockField f13;
    private int f14;
    private int f15;
    private GoldRushMidlet f16;
    private Graphics f17;
    private Image f18;
    private boolean f19;
    private int f20;
    private int f21;
    private Location f22;
    private StatusBar f23;
    private Location f24;

    public GoldRushDisplay(Canvas canvas, GoldRushMidlet goldRushMidlet, Image[] imageArray, Image[] imageArray2, long l) {
        super(canvas);
        this.f16 = goldRushMidlet;
        this.f11 = l;
        this.f6 = new Vector(3);
        this.f7 = new Vector(3);
        this.f8 = new Vector(3);
        this.f9 = new Cart();
        this.f10 = new Cart();
        this.f4 = new FieldDisplay(imageArray);
        this.f23 = new StatusBar(imageArray2);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this.f15 == 0) {
            this.f15 = 9;
        }
    }

    public void pointerPressed(int n, int n2) {
        if (this.f15 == 0) {
            int n3 = this.f4.getRow(n2);
            int n4 = this.f4.getColumn(n);
            if (n3 == -1 || n4 == -1) {
                if (this.f23.insideHack(n, n2)) {
                    this.f15 = 7;
                    return;
                }
                if (this.f23.insideDynamite(n, n2)) {
                    this.f15 = 8;
                    return;
                }
            } else {
                this.m1(n3, n4);
            }
        }
    }

    private void m1(int n, int n2) {
        int n3;
        Location location;
        if (this.f5.state == 9) {
            location = this.f9.loc;
            n3 = this.f9.dir;
        } else {
            location = this.f5.loc;
            n3 = this.f5.dir;
        }
        if (n == location.y) {
            if (n2 > location.x) {
                this.f15 = 2;
                return;
            }
            if (n2 < location.x) {
                this.f15 = 1;
                return;
            }
        } else if (n2 == location.x) {
            if (n > location.y) {
                this.f15 = 4;
                return;
            }
            if (n < location.y) {
                this.f15 = 3;
                return;
            }
        } else {
            switch (n3) {
                case 2: {
                    this.f15 = n < location.y ? 3 : 0;
                    return;
                }
                case 1: {
                    this.f15 = n > location.y ? 4 : 0;
                    return;
                }
                case 0: {
                    this.f15 = n2 < location.x ? 1 : 0;
                    return;
                }
                case 3: {
                    this.f15 = n2 > location.x ? 2 : 0;
                }
            }
        }
    }

    public void pointerDragged(int n, int n2) {
        if (this.f15 == 0) {
            int n3 = this.f4.getRow(n2);
            int n4 = this.f4.getColumn(n);
            if (n3 == -1 || n4 == -1) {
                return;
            }
            this.m1(n3, n4);
        }
    }

    public void keyPressed(int n) {
        if (this.f15 == 0) {
            if (n == this.f1[this.f2]) {
                ++this.f2;
                if (this.f2 == this.f1.length) {
                    this.f15 = 6;
                    return;
                }
            } else {
                this.f2 = 0;
            }
            switch (this.key2game(n)) {
                case 1: {
                    this.f15 = 3;
                    return;
                }
                case 6: {
                    this.f15 = 4;
                    return;
                }
                case 2: {
                    this.f15 = 1;
                    return;
                }
                case 5: {
                    this.f15 = 2;
                    return;
                }
                case 8: {
                    this.f15 = 7;
                    return;
                }
                case 9: {
                    this.f15 = 8;
                    return;
                }
                case 10: {
                    this.f15 = 5;
                    return;
                }
                case 11: {
                    this.f15 = 9;
                }
            }
        }
    }

    public void keyRepeated(int n) {
        if (this.f15 == 0) {
            this.f2 = 0;
            switch (this.key2game(n)) {
                case 1: {
                    this.f15 = 3;
                    return;
                }
                case 6: {
                    this.f15 = 4;
                    return;
                }
                case 2: {
                    this.f15 = 1;
                    return;
                }
                case 5: {
                    this.f15 = 2;
                    return;
                }
                case 8: {
                    this.f15 = 7;
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.f12 != null) {
            this.f17.setClip(0, 0, this.getWidth(), this.getHeight());
            this.f4.paint();
            this.m2();
            GoldRushDisplay goldRushDisplay = this;
            goldRushDisplay.m3(goldRushDisplay.f9);
            GoldRushDisplay goldRushDisplay2 = this;
            goldRushDisplay2.m3(goldRushDisplay2.f10);
            if (this.f23.invalid) {
                this.f23.paint(this.f17);
            }
            graphics.drawImage(this.f18, 0, 0, 20);
            this.f19 = false;
        }
    }

    private void m2() {
        if (this.f5.state == 9 || this.f5.image == -1) {
            return;
        }
        this.f4.paintBlock(this.f5.image, this.f5.loc.x, this.f5.loc.y, this.f5.loc.index, this.f5.xOffset, this.f5.yOffset);
    }

    private void m3(Cart cart) {
        if (cart.state == 0 || cart.state == 6) {
            return;
        }
        this.f4.paintBlock(cart.image, cart.loc.x, cart.loc.y, cart.loc.index, cart.xOffset, cart.yOffset);
    }

    public void start() {
        if (this.f3 == null) {
            this.f3 = new Thread(this);
            this.f3.start();
        }
    }

    public void stop() {
        this.f3 = null;
    }

    public boolean setLevel(Level level) {
        this.f12 = level;
        this.f13 = level.field;
        this.f20 = this.f13.blockWidth >> 1;
        this.f21 = this.f13.blockHeight >> 1;
        if (this.f18 == null || this.f18.getWidth() != this.getWidth() || this.f18.getHeight() != this.getHeight()) {
            this.f18 = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.f17 = this.f18.getGraphics();
        }
        this.f17.setColor(0, 0, 0);
        this.f17.fillRect(0, 0, this.getWidth(), this.getHeight());
        return this.m4();
    }

    private boolean m4() {
        Location location;
        this.f15 = 0;
        this.f2 = 0;
        int n = this.getWidth();
        int n2 = this.getHeight() - 32;
        int n3 = Math.min(n / this.f13.blockWidth, this.f13.width);
        int n4 = Math.min(n2 / this.f13.blockHeight, this.f13.height);
        int n5 = Math.max((n >> 1) - (n3 * this.f13.blockWidth >> 1), 0);
        this.f4.init(this.f13, n5, 0, n3, n4, this.f18, this.f17);
        this.f23.init(this.f12.hack, this.f12.dynamite, this.f12.limit, new Dimension(n5, this.f4.displayDim.height, this.f4.displayDim.width, 32));
        this.f14 = 1;
        if (this.f4.blockDim.height >= 10) {
            ++this.f14;
        }
        if ((location = this.f13.getPosition(55)) == null) {
            return false;
        }
        this.f5 = new Player(location, 1, 0, 1000, 55);
        this.f4.set(0, location);
        this.f24 = this.f13.getPosition(87);
        if (this.f24 == null) {
            return false;
        }
        this.f9.state = 0;
        this.f10.state = 0;
        this.f8.removeAllElements();
        Location[] locationArray = this.f13.getPositions(16);
        WaterField waterField = null;
        int n6 = 0;
        while (n6 < locationArray.length) {
            boolean bl = false;
            WaterItem waterItem = new WaterItem(locationArray[n6], 0);
            Enumeration enumeration = this.f8.elements();
            while (enumeration.hasMoreElements()) {
                if (!((WaterField)enumeration.nextElement()).add(waterItem)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                waterField = new WaterField(waterItem);
                this.f8.addElement(waterField);
            }
            this.f4.set(waterField.newImage(), locationArray[n6]);
            ++n6;
        }
        this.f7.removeAllElements();
        this.f6.removeAllElements();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int n = 0;
        int n2 = 0;
        try {
            block4: while (true) {
                int n3;
                if (this.f3 == null) {
                    return;
                }
                long l = System.currentTimeMillis();
                if (n == GoldRushConstants.ACTION_ARRAY.length) {
                    n = 0;
                }
                if (((n3 = GoldRushConstants.ACTION_ARRAY[n++]) & 2) != 0) {
                    n2 = this.f15;
                    this.f15 = 0;
                    this.m22(n2);
                }
                if ((n3 & 1) != 0) {
                    this.m13(n3, n2);
                }
                if ((n3 & 0x10) != 0 && this.f9.state != 0) {
                    GoldRushDisplay goldRushDisplay = this;
                    goldRushDisplay.m7(goldRushDisplay.f10, n3, n2);
                    GoldRushDisplay goldRushDisplay2 = this;
                    goldRushDisplay2.m7(goldRushDisplay2.f9, n3, n2);
                }
                if ((n3 & 0x20) != 0 && this.f8.size() > 0) {
                    this.m5();
                }
                if ((n3 & 4) != 0 && this.f7.size() > 0) {
                    this.m19();
                }
                if ((n3 & 8) != 0 && this.f6.size() > 0) {
                    this.m17();
                }
                this.f19 = true;
                this.repaint();
                try {
                    l = this.f11 - (System.currentTimeMillis() - l);
                    if (l > 0L) {
                        Thread.sleep(l);
                    }
                    if (!this.f19) continue;
                    long l2 = 0L;
                    long l3 = 50L;
                    while (true) {
                        if (this.f3 == null || !this.f19 || l2 >= 2000L) continue block4;
                        Thread.sleep(l3);
                        l2 += l3;
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void m5() {
        int n = 0;
        while (n < this.f8.size()) {
            WaterItem waterItem;
            WaterItem waterItem2;
            boolean bl = false;
            WaterField waterField = (WaterField)this.f8.elementAt(n);
            if (waterField.invalid) {
                if (waterField.first == null) {
                    this.f8.removeElementAt(n);
                    continue;
                }
                int n2 = 0;
                waterItem2 = waterField.first;
                while (waterItem2 != null) {
                    if (n2++ < 3) {
                        if (waterItem2.loc.index == this.f5.loc.index) {
                            this.f5.image = this.f5.state == 7 ? 32 : 33;
                        }
                        this.f4.set(waterItem2.image, waterItem2.loc);
                        waterItem2 = waterField.first = waterField.first.next;
                        continue;
                    }
                    this.f4.set(waterField.nextImage(this.f4.field[waterItem2.loc.index]), waterItem2.loc);
                    waterItem2 = waterItem2.next;
                }
                ++n;
                continue;
            }
            waterItem2 = waterItem = waterField.current;
            while (!waterField.invalid) {
                WaterItem waterItem3;
                this.f4.set(waterField.nextImage(this.f4.field[waterItem2.loc.index]), waterItem2.loc);
                if (!bl && (waterItem3 = this.m6(waterField, waterItem2)) != null) {
                    this.f4.set(waterField.newImage(), waterItem3.loc);
                    waterField.addExpanded(waterItem3);
                    waterField.current = waterItem2;
                    bl = true;
                }
                if ((waterItem2 = waterItem2.next != null ? waterItem2.next : waterField.first) == waterItem) break;
            }
            ++n;
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private WaterItem m6(WaterField waterField, WaterItem waterItem) {
        int n = 0;
        while (n < WaterItem.dir.length) {
            int n2 = waterItem.loc.index;
            int n3 = waterItem.loc.x;
            int n4 = waterItem.loc.y;
            switch (waterItem.getNextDir()) {
                case 2: {
                    n2 = waterItem.loc.index - this.f13.width;
                    --n4;
                    break;
                }
                case 1: {
                    n2 = waterItem.loc.index + this.f13.width;
                    ++n4;
                    break;
                }
                case 0: {
                    n2 = waterItem.loc.index - 1;
                    --n3;
                    break;
                }
                case 3: {
                    n2 = waterItem.loc.index + 1;
                    ++n3;
                    break;
                }
            }
            if (n2 >= 0 && n2 < this.f4.size) {
                int n5 = this.f4.field[n2];
                int n6 = Integer.MIN_VALUE;
                block12: do {
                    switch (n6 == Integer.MIN_VALUE ? n5 : n6) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 11: 
                        case 59: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 69: 
                        case 73: 
                        case 80: {
                            this.m18(n2, 8, -1);
                            n6 = 67;
                            continue block12;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: {
                            n5 = 3;
                            int n7 = this.f7.size();
                            while (n7 > 0) {
                                Dynamite dynamite = (Dynamite)this.f7.elementAt(--n7);
                                if (dynamite.loc.index != n2) continue;
                                dynamite.hide = true;
                                break;
                            }
                        }
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 74: 
                        case 79: 
                        case 81: 
                        case 82: 
                        case 83: 
                        case 84: 
                        case 85: {
                            return new WaterItem(new Location(n3, n4, n2), n5);
                        }
                    }
                    break;
                } while (true);
            }
            ++n;
        }
        return null;
    }

    private void m7(Cart cart, int n, int n2) {
        switch (cart.state) {
            case 1: {
                if (!cart.player || (n & 2) == 0) {
                    return;
                }
                this.m12(cart, n2);
                return;
            }
            case 2: 
            case 3: {
                this.m10(cart);
                return;
            }
            case 7: {
                cart.state = 8;
                cart.xOffset = this.f5.xOffset;
                cart.yOffset = this.f5.yOffset;
                return;
            }
            case 8: {
                this.m11(cart);
                return;
            }
            case 4: {
                this.f4.set(cart.loc);
                cart.state = 6;
                return;
            }
            case 6: {
                this.m8(cart);
            }
        }
    }

    private void m8(Cart cart) {
        int n;
        this.f22 = null;
        if (cart.loc.index == this.f24.index) {
            this.f15 = 6;
            return;
        }
        int n2 = 0;
        while (n2 < this.f12.conn.length) {
            this.f22 = this.f12.conn[n2].getConnLocation(cart.loc);
            if (this.f22 != null) break;
            ++n2;
        }
        if (this.f22 == null) {
            this.f22 = cart.loc;
        }
        int n3 = n = cart.loc.x <= this.f22.x ? 3 : 0;
        if (!this.m26(n, this.f22.x, this.f22.y)) {
            int n4 = n = cart.loc.y <= this.f22.y ? 1 : 2;
            if (!this.m26(n, this.f22.x, this.f22.y)) {
                switch (this.f4.field[this.f22.index]) {
                    case 86: {
                        cart.setMove(0, this.f22.x, this.f22.y, this.f22.index, 0, 0, 2, 88);
                        return;
                    }
                    case 94: {
                        cart.setMove(3, this.f22.x, this.f22.y, this.f22.index, 0, 0, 2, 91);
                        return;
                    }
                    case 93: {
                        cart.setMove(2, this.f22.x, this.f22.y, this.f22.index, 0, 0, 2, 90);
                        return;
                    }
                    case 92: {
                        cart.setMove(1, this.f22.x, this.f22.y, this.f22.index, 0, 0, 2, 89);
                    }
                }
            }
        }
    }

    private boolean m9(Cart cart, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (n2 < 0 || n2 >= this.f13.width || n3 < 0 || n3 >= this.f13.height) {
            return false;
        }
        switch (this.f4.field[n4]) {
            case 69: 
            case 73: 
            case 80: 
            case 86: 
            case 92: 
            case 93: 
            case 94: {
                this.f4.set(cart.loc);
                cart.setMove(n, n2, n3, n4, n5, n6, 3, n7);
                if (this.m26(n, n2, n3)) {
                    cart.xOffset = 0;
                    cart.yOffset = 0;
                }
                return true;
            }
        }
        switch (this.f4.field[cart.loc.index]) {
            case 86: 
            case 92: 
            case 93: 
            case 94: {
                cart.state = 4;
                return true;
            }
        }
        cart.image = n7;
        cart.dir = n;
        cart.state = 1;
        return false;
    }

    private void m10(Cart cart) {
        this.f4.set(cart.prevLoc);
        if (cart.state == 2) {
            switch (cart.dir) {
                case 2: {
                    this.m9(cart, 2, cart.loc.x, cart.loc.y - 1, cart.loc.index - this.f13.width, 0, this.f21, 76);
                    return;
                }
                case 1: {
                    this.m9(cart, 1, cart.loc.x, cart.loc.y + 1, cart.loc.index + this.f13.width, 0, -this.f21, 77);
                    return;
                }
                case 0: {
                    this.m9(cart, 0, cart.loc.x - 1, cart.loc.y, cart.loc.index - 1, this.f20, 0, 78);
                    return;
                }
                case 3: {
                    this.m9(cart, 3, cart.loc.x + 1, cart.loc.y, cart.loc.index + 1, -this.f20, 0, 75);
                    return;
                }
                default: {
                    return;
                }
            }
        }
        switch (this.f4.field[cart.loc.index]) {
            case 93: {
                cart.image = 90;
                cart.state = 4;
                break;
            }
            case 86: {
                cart.image = 88;
                cart.state = 4;
                break;
            }
            case 94: {
                cart.image = 91;
                cart.state = 4;
                break;
            }
            case 92: {
                cart.image = 89;
                cart.state = 4;
                break;
            }
            default: {
                cart.state = 2;
            }
        }
        cart.xOffset = 0;
        cart.yOffset = 0;
    }

    private void m11(Cart cart) {
        int n = cart.image;
        if (this.f4.field[cart.loc.index] == 69) {
            switch (n) {
                case 72: {
                    n = 67;
                    break;
                }
                case 79: {
                    n = 68;
                    break;
                }
                case 74: {
                    n = 70;
                    break;
                }
                case 81: {
                    n = 71;
                }
            }
        }
        cart.state = 0;
        this.f4.set(n, cart.loc.x, cart.loc.y, cart.loc.index);
        cart.xOffset = 0;
        cart.yOffset = 0;
    }

    private void m12(Cart cart, int n) {
        block17: {
            int n2;
            int n3;
            int n4 = this.f4.field[cart.loc.index];
            int n5 = cart.loc.index;
            int n6 = cart.loc.x;
            int n7 = cart.loc.y;
            int n8 = 0;
            int n9 = 0;
            switch (n) {
                case 3: {
                    n3 = 2;
                    n9 = this.f21;
                    if (cart.dir != 2 && cart.dir != 1 || !this.m9(cart, 2, n6, --n7, n5 -= this.f13.width, 0, n9, 76)) {
                        n2 = 53;
                        break;
                    }
                    break block17;
                }
                case 4: {
                    n3 = 1;
                    n9 = -this.f21;
                    if (cart.dir != 2 && cart.dir != 1 || !this.m9(cart, 1, n6, ++n7, n5 += this.f13.width, 0, n9, 77)) {
                        n2 = 55;
                        break;
                    }
                    break block17;
                }
                case 1: {
                    n3 = 0;
                    n8 = this.f20;
                    if (cart.dir != 0 && cart.dir != 3 || !this.m9(cart, 0, --n6, n7, --n5, n8, 0, 78)) {
                        n2 = 57;
                        break;
                    }
                    break block17;
                }
                case 2: {
                    n3 = 3;
                    n8 = -this.f20;
                    if (cart.dir != 0 && cart.dir != 3 || !this.m9(cart, 3, ++n6, n7, ++n5, n8, 0, 75)) {
                        n2 = 51;
                        break;
                    }
                    break block17;
                }
                default: {
                    return;
                }
            }
            if (n5 < 0 || n5 > this.f4.size) {
                return;
            }
            switch (this.f4.field[n5]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 64: 
                case 65: 
                case 66: 
                case 69: 
                case 73: 
                case 80: {
                    break;
                }
                case 59: {
                    if (!this.f23.addPick()) break;
                    this.f4.set(0, n6, n7, n5);
                    break;
                }
                case 11: {
                    if (!this.f23.addDynamite()) break;
                    this.f4.set(1, n6, n7, n5);
                    break;
                }
                default: {
                    return;
                }
            }
            n4 = cart.dir == 2 || cart.dir == 1 ? (n4 == 69 ? 68 : 79) : (n4 == 69 ? 67 : 72);
            cart.state = 0;
            this.f4.set(n4, cart.loc.x, cart.loc.y, cart.loc.index);
            this.f5.loc.x = cart.loc.x;
            this.f5.loc.y = cart.loc.y;
            this.f5.loc.index = cart.loc.index;
            this.f5.image = n2;
            this.f5.setWalk(n3, n6, n7, n5, n8, n9);
            if (this.m26(n3, n6, n7)) {
                this.f5.xOffset = 0;
                this.f5.yOffset = 0;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void m13(int n, int n2) {
        block0 : switch (this.f5.state) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                if ((n & 2) == 0) return;
                switch (n2) {
                    case 3: {
                        this.f5.restore();
                        this.m25(2, 53, this.f5.loc.x, this.f5.loc.y - 1, this.f5.loc.index - this.f13.width, 0, this.f21);
                        break block0;
                    }
                    case 4: {
                        this.f5.restore();
                        this.m25(1, 55, this.f5.loc.x, this.f5.loc.y + 1, this.f5.loc.index + this.f13.width, 0, -this.f21);
                        break block0;
                    }
                    case 1: {
                        this.f5.restore();
                        this.m25(0, 57, this.f5.loc.x - 1, this.f5.loc.y, this.f5.loc.index - 1, this.f20, 0);
                        break block0;
                    }
                    case 2: {
                        this.f5.restore();
                        this.m25(3, 51, this.f5.loc.x + 1, this.f5.loc.y, this.f5.loc.index + 1, -this.f20, 0);
                        break block0;
                    }
                    case 7: {
                        this.f5.restore();
                        if (this.f23.hack <= 0) break block0;
                        this.f5.setHack();
                        break block0;
                    }
                    case 8: {
                        this.f5.restore();
                        if (this.f23.dynamite <= 0) break block0;
                        this.m23();
                        break block0;
                    }
                    default: {
                        if ((n & 0x40) <= 0) return;
                        this.f5.handleRest();
                        return;
                    }
                }
            }
            case 4: 
            case 5: {
                this.m14();
                break;
            }
            case 6: {
                this.m16();
            }
        }
        this.f5.restCount = 0;
    }

    private void m14() {
        this.f4.set(this.f5.prevLoc);
        int n = this.f4.field[this.f5.loc.index];
        block0 : switch (n) {
            case 68: 
            case 79: {
                this.f5.state = 9;
                n = n == 68 ? 69 : 80;
                int n2 = this.f5.dir == 2 ? 2 : 1;
                int n3 = this.f5.dir == 2 ? 76 : 77;
                this.f9.init(n2, this.f5.loc, n3, true);
                break;
            }
            case 67: 
            case 72: {
                this.f5.state = 9;
                n = n == 67 ? 69 : 73;
                int n4 = this.f5.dir == 0 ? 0 : 3;
                int n5 = this.f5.dir == 0 ? 78 : 75;
                this.f9.init(n4, this.f5.loc, n5, true);
                break;
            }
            default: {
                this.f5.state = 0;
                switch (this.f5.image) {
                    case 55: {
                        this.f5.image = 56;
                        break block0;
                    }
                    case 56: {
                        this.f5.image = 55;
                        break block0;
                    }
                    case 53: {
                        this.f5.image = 54;
                        break block0;
                    }
                    case 54: {
                        this.f5.image = 53;
                        break block0;
                    }
                    case 57: {
                        this.f5.image = 58;
                        break block0;
                    }
                    case 58: {
                        this.f5.image = 57;
                        break block0;
                    }
                    case 51: {
                        this.f5.image = 52;
                        break block0;
                    }
                    case 52: {
                        this.f5.image = 51;
                    }
                }
            }
        }
        this.f4.set(n, this.f5.loc.x, this.f5.loc.y, this.f5.loc.index);
        this.f5.xOffset = 0;
        this.f5.yOffset = 0;
    }

    private void m15() {
        this.f23.addScore();
        if (this.f23.score >= this.f12.limit) {
            this.f4.set(86, this.f24);
        }
    }

    private void m16() {
        this.f5.image = this.f5.imageArray[this.f5.pos++];
        if (this.f5.pos >= this.f5.imageArray.length) {
            this.f5.state = 0;
            int n = this.f5.loc.x;
            int n2 = this.f5.loc.y;
            int n3 = this.f5.loc.index;
            switch (this.f5.dir) {
                case 2: {
                    --n2;
                    n3 -= this.f13.width;
                    break;
                }
                case 0: {
                    --n;
                    --n3;
                    break;
                }
                case 3: {
                    ++n;
                    ++n3;
                    break;
                }
                case 1: {
                    ++n2;
                    n3 += this.f13.width;
                }
            }
            if (n < 0 || n > this.f13.width || n2 < 0 || n2 > this.f13.height) {
                return;
            }
            switch (this.f4.field[n3]) {
                case 26: {
                    this.f4.set(2, n, n2, n3);
                    this.m15();
                    break;
                }
                case 27: {
                    this.f4.set(26, n, n2, n3);
                    this.m15();
                    break;
                }
                case 28: {
                    this.f4.set(27, n, n2, n3);
                    this.m15();
                    break;
                }
                case 60: {
                    this.f4.set(1, n, n2, n3);
                    break;
                }
                case 61: {
                    this.f4.set(60, n, n2, n3);
                    break;
                }
                case 62: {
                    this.f4.set(61, n, n2, n3);
                    break;
                }
                case 63: {
                    this.f4.set(26, n, n2, n3);
                    break;
                }
                case 69: {
                    this.f4.set(64, n, n2, n3);
                    break;
                }
                case 4: {
                    this.f4.set(0, n, n2, n3);
                    break;
                }
                case 5: {
                    this.f4.set(1, n, n2, n3);
                    break;
                }
                case 96: {
                    this.f4.set(4, n, n2, n3);
                    break;
                }
                case 97: {
                    this.f4.set(5, n, n2, n3);
                    break;
                }
                case 80: {
                    if (this.f5.dir == 2 || this.f5.dir == 1) {
                        this.f4.set(66, n, n2, n3);
                        break;
                    }
                    return;
                }
                case 73: {
                    if (this.f5.dir == 0 || this.f5.dir == 3) {
                        this.f4.set(65, n, n2, n3);
                        break;
                    }
                }
                default: {
                    return;
                }
            }
            this.f23.notifyHack();
        }
    }

    private void m17() {
        int n = 0;
        while (n < this.f6.size()) {
            Explosion explosion = (Explosion)this.f6.elementAt(n);
            int n2 = Explosion.imgArray.length;
            int n3 = explosion.size;
            while (n3 > 0) {
                ExplItem explItem = explosion.buf[--n3];
                int n4 = explosion.pos == n2 ? explItem.image : Explosion.imgArray[explosion.pos];
                this.f4.set(n4, explItem.loc);
            }
            if (++explosion.pos > Explosion.imgArray.length) {
                this.f6.removeElementAt(n);
                if (!explosion.player) continue;
                this.f5.image = 32;
                continue;
            }
            ++n;
        }
    }

    private boolean m18(int n, int n2, int n3) {
        switch (this.f5.state) {
            case 9: {
                if (this.f9.loc.index != n) {
                    return false;
                }
                this.f9.state = 0;
                this.f5.loc.index = this.f9.loc.index;
                this.f5.loc.x = this.f9.loc.x;
                this.f5.loc.y = this.f9.loc.y;
                this.f5.state = n2;
                this.f5.image = n3;
                return true;
            }
        }
        if (this.f5.loc.index != n) {
            return false;
        }
        if (this.f5.state != 7) {
            this.f5.state = n2;
        }
        this.f5.image = n3;
        return true;
    }

    private void m19() {
        int n = 0;
        while (n < this.f7.size()) {
            Dynamite dynamite = (Dynamite)this.f7.elementAt(n);
            int n2 = dynamite.nextImage();
            if (n2 == -1) {
                if (!dynamite.hide) {
                    this.f4.set(0, dynamite.loc);
                }
                this.f7.removeElementAt(n);
                this.m21(dynamite.loc);
                continue;
            }
            if (!dynamite.hide) {
                this.f4.set(n2, dynamite.loc.x, dynamite.loc.y, dynamite.loc.index);
            }
            ++n;
        }
    }

    private void m20(int n, int n2, int n3, Explosion explosion, int n4) {
        if (n < 0 || n >= this.f4.size) {
            return;
        }
        byte by = this.f4.field[n];
        int n5 = Explosion.getExplImage(by, n, n2, n3, explosion, n4);
        if (n5 != -1) {
            block0 : switch (by) {
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    int n6 = this.f8.size();
                    while (n6 > 0) {
                        if (((WaterField)this.f8.elementAt(--n6)).removeItem(n)) break block0;
                    }
                    break;
                }
            }
            explosion.buf[explosion.size++] = new ExplItem(new Location(n2, n3, n), n5);
            if (!explosion.player) {
                explosion.player = this.m18(n, 7, -1);
            }
        }
    }

    private void m21(Location location) {
        Explosion explosion = new Explosion();
        this.f6.addElement(explosion);
        int n = location.x;
        int n2 = location.y;
        int n3 = location.index;
        this.m20(n3 - 2 * this.f13.width, n, n2 - 2, explosion, 1);
        this.m20(n3 - (this.f13.width + 1), n - 1, n2 - 1, explosion, 2);
        this.m20(n3 - this.f13.width, n, n2 - 1, explosion, 3);
        this.m20(n3 - (this.f13.width - 1), n + 1, n2 - 1, explosion, 2);
        this.m20(n3 - 2, n - 2, n2, explosion, 1);
        this.m20(n3 - 1, n - 1, n2, explosion, 3);
        this.m20(n3, n, n2, explosion, 3);
        this.m20(n3 + 1, n + 1, n2, explosion, 3);
        this.m20(n3 + 2, n + 2, n2, explosion, 1);
        this.m20(n3 + (this.f13.width - 1), n - 1, n2 + 1, explosion, 2);
        this.m20(n3 + this.f13.width, n, n2 + 1, explosion, 3);
        this.m20(n3 + (this.f13.width + 1), n + 1, n2 + 1, explosion, 2);
        this.m20(n3 + 2 * this.f13.width, n, n2 + 2, explosion, 1);
    }

    private void m22(int n) {
        switch (n) {
            case 5: {
                this.m4();
                return;
            }
            case 9: {
                this.f16.notifyFailed();
                return;
            }
            case 6: {
                this.f16.notifyExit(this.f12, this.f23.score);
            }
        }
    }

    private void m23() {
        int n = this.f5.loc.x;
        int n2 = this.f5.loc.y;
        int n3 = this.f5.loc.index;
        switch (this.f5.dir) {
            case 2: {
                --n2;
                n3 -= this.f13.width;
                break;
            }
            case 0: {
                --n;
                --n3;
                break;
            }
            case 3: {
                ++n;
                ++n3;
                break;
            }
            case 1: {
                ++n2;
                n3 += this.f13.width;
            }
        }
        if (n3 < 0 || n3 >= this.f4.size) {
            return;
        }
        switch (this.f4.field[n3]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 64: 
            case 65: 
            case 66: 
            case 69: 
            case 73: 
            case 80: {
                this.f23.notifyDynamite();
                Dynamite dynamite = new Dynamite(new Location(n, n2, n3));
                this.f7.addElement(dynamite);
                this.f4.set(Dynamite.imgArray[0], n, n2, n3);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean m24(Cart cart, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        block27: {
            int n11;
            block26: {
                n10 = n2;
                n9 = n3;
                n8 = n4;
                switch (n) {
                    case 2: {
                        --n9;
                        n8 -= this.f13.width;
                        break;
                    }
                    case 1: {
                        ++n9;
                        n8 += this.f13.width;
                        break;
                    }
                    case 0: {
                        --n10;
                        --n8;
                        break;
                    }
                    case 3: {
                        ++n10;
                        ++n8;
                    }
                }
                n11 = this.f4.getValue(n10, n9);
                if (cart != this.f9) break block26;
                switch (n11) {
                    case 74: {
                        if (n == 2 || n == 1) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 73, 73, 74)) {
                            return false;
                        }
                        break block27;
                    }
                    case 81: {
                        if (n == 3 || n == 0) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 80, 80, 81)) {
                            return false;
                        }
                        break block27;
                    }
                    case 70: {
                        if (n == 2 || n == 1) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 73, 69, 74)) {
                            return false;
                        }
                        break block27;
                    }
                    case 71: {
                        if (n == 3 || n == 0) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 80, 69, 81)) {
                            return false;
                        }
                        break block27;
                    }
                    case 72: {
                        if (n == 2 || n == 1) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 73, 73, 72)) {
                            return false;
                        }
                        break block27;
                    }
                    case 79: {
                        if (n == 3 || n == 0) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 80, 80, 79)) {
                            return false;
                        }
                        break block27;
                    }
                    case 67: {
                        if (n == 2 || n == 1) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 73, 69, 72)) {
                            return false;
                        }
                        break block27;
                    }
                    case 68: {
                        if (n == 3 || n == 0) return false;
                        GoldRushDisplay goldRushDisplay = this;
                        if (!goldRushDisplay.m24(goldRushDisplay.f10, n, n10, n9, n8, 80, 69, 79)) {
                            return false;
                        }
                        break block27;
                    }
                    default: {
                        if (n11 != n5 && n11 != 69) {
                            return false;
                        }
                        break block27;
                    }
                }
            }
            if (n11 != n5 && n11 != 69) {
                return false;
            }
        }
        this.f4.set(n6, n2, n3, n4);
        cart.setMove(n, n10, n9, n8, 0, 0, 7, n7);
        cart.player = false;
        return true;
    }

    private void m25(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.f5.dir != n) {
            this.f5.dir = n;
            this.f5.image = n2;
        }
        if (n3 < 0 || n3 >= this.f13.width || n4 < 0 || n4 >= this.f13.height) {
            return;
        }
        switch (this.f4.field[n5]) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 72: 
            case 73: 
            case 79: 
            case 80: {
                break;
            }
            case 59: {
                if (!this.f23.addPick()) break;
                this.f4.set(0, n3, n4, n5);
                break;
            }
            case 11: {
                if (!this.f23.addDynamite()) break;
                this.f4.set(1, n3, n4, n5);
                break;
            }
            case 74: {
                if (n != 2 && n != 1) {
                    GoldRushDisplay goldRushDisplay = this;
                    if (goldRushDisplay.m24(goldRushDisplay.f9, n, n3, n4, n5, 73, 73, 74)) break;
                }
                return;
            }
            case 81: {
                if (n != 3 && n != 0) {
                    GoldRushDisplay goldRushDisplay = this;
                    if (goldRushDisplay.m24(goldRushDisplay.f9, n, n3, n4, n5, 80, 80, 81)) break;
                }
                return;
            }
            case 70: {
                if (n != 2 && n != 1) {
                    GoldRushDisplay goldRushDisplay = this;
                    if (goldRushDisplay.m24(goldRushDisplay.f9, n, n3, n4, n5, 73, 69, 74)) break;
                }
                return;
            }
            case 71: {
                if (n != 3 && n != 0) {
                    GoldRushDisplay goldRushDisplay = this;
                    if (goldRushDisplay.m24(goldRushDisplay.f9, n, n3, n4, n5, 80, 69, 81)) break;
                }
            }
            default: {
                return;
            }
        }
        this.f4.set(this.f5.loc);
        this.f5.setWalk(n, n3, n4, n5, n6, n7);
        if (this.m26(n, n3, n4)) {
            this.f5.xOffset = 0;
            this.f5.yOffset = 0;
        }
    }

    private boolean m26(int n, int n2, int n3) {
        switch (n) {
            case 3: {
                if (this.f4.blockDim.x >= this.f13.width - this.f4.blockDim.width || this.f14 < this.f4.blockDim.x + this.f4.blockDim.width - (n2 + 1)) break;
                this.f4.scrollX(this.f4.blockDim.x + 1);
                return true;
            }
            case 0: {
                if (this.f4.blockDim.x <= 0 || this.f14 < n2 - this.f4.blockDim.x) break;
                this.f4.scrollX(this.f4.blockDim.x - 1);
                return true;
            }
            case 2: {
                if (this.f4.blockDim.y <= 0 || this.f14 < n3 - this.f4.blockDim.y) break;
                this.f4.scrollY(this.f4.blockDim.y - 1);
                return true;
            }
            case 1: {
                if (this.f4.blockDim.y >= this.f13.height - this.f4.blockDim.height || this.f14 < this.f4.blockDim.y + this.f4.blockDim.height - (n3 + 1)) break;
                this.f4.scrollY(this.f4.blockDim.y + 1);
                return true;
            }
        }
        return false;
    }
}

