/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Mahmatch {
    private static final int[] warntime = new int[]{0, 250, 500, 750, 1000, 1500, 2000, 2500, 3000};
    private static final int[][] tileXOrig = new int[][]{{126, 110, 94, 78, 62, 46, 30, 14, -2, 110, 94, 78, 62, 46, 30, 14, -2, 110, 94, 78, 62, 46, 30, 14, -2, 110, 94, 78, 62, 46, 30, 14, -2, 110, 94, 78, 62, 46, 30, 14, -2, 110, 94, 78, 62, 46, 30, 14, -2, 110, 94, 78, 62, 46, 30, 14, -2, 110, 94, 78, 62, 46, 30, 14, -2, -17, 114, 114, 66, 50, 114, 114, 98, 82, 66, 50, 34, 18, 98, 82, 66, 50, 34, 18, 98, 82, 66, 50, 34, 18, 98, 82, 66, 50, 34, 18, 98, 82, 66, 50, 34, 18, 98, 82, 66, 50, 34, 18, 3, 3, 3, 3, 86, 70, 54, 38, 86, 70, 54, 38, 86, 70, 54, 38, 86, 70, 54, 38, 22, 102, 22, 102, 74, 58, 74, 58, 42, 90, 42, 90, 70, 74, 66, 50}, {116, 100, 84, 68, 52, 36, 20, 4, -11, 116, 100, 84, 68, 52, 36, 20, 4, -11, 116, 100, 84, 68, 52, 36, 20, 4, -11, 116, 100, 84, 68, 52, 36, 20, 4, -11, 120, 104, 88, 72, 56, 40, 24, 8, -7, 120, 104, 88, 72, 56, 40, 24, 8, -7, 120, 104, 88, 72, 56, 40, 24, 8, -7, 120, 104, 88, 72, 56, 40, 24, 8, -7, 124, 108, 92, 76, 60, 44, 28, 12, -3, 124, 108, 92, 76, 60, 44, 28, 12, -3, 124, 108, 92, 76, 60, 44, 28, 12, -3, 124, 108, 92, 76, 60, 44, 28, 12, -3, 128, 112, 96, 80, 64, 48, 32, 16, 0, 128, 112, 96, 80, 64, 48, 32, 16, 0, 128, 112, 96, 80, 64, 48, 32, 16, 0, 128, 112, 96, 80, 64, 48, 32, 16, 0}, {120, 104, 88, 72, 56, 40, 24, 8, -8, 120, 104, 88, 72, 56, 40, 24, 8, -8, 120, 104, 88, 72, 56, 40, 24, 8, -8, 120, 104, 88, 72, 56, 40, 24, 8, -8, 120, 104, 88, 72, 56, 40, 24, 8, -8, 120, 104, 88, 72, 56, 40, 24, 8, -8, 120, 104, 88, 72, 56, 40, 24, 8, -8, 44, 28, 12, -4, 44, 28, 12, -4, 44, 28, 12, -4, 124, 108, 92, 76, 124, 108, 92, 76, 124, 108, 92, 76, 124, 108, 92, 76, 124, 108, 92, 76, 124, 108, 92, 76, 60, 44, 28, 12, -4, 44, 28, 12, -4, 44, 28, 12, -4, 40, 24, 8, 40, 24, 8, 120, 104, 88, 120, 104, 88, 40, 24, 8, 40, 24, 8, 120, 104, 88, 120, 104, 88, 36, 20, 116, 100, 36, 20, 116, 100}};
    private static final int[][] tileYOrig = new int[][]{{70, 4, 4, 4, 4, 4, 4, 4, 4, 24, 24, 24, 24, 24, 24, 24, 24, 44, 44, 44, 44, 44, 44, 44, 44, 64, 64, 64, 64, 64, 64, 64, 64, 84, 84, 84, 84, 84, 84, 84, 84, 104, 104, 104, 104, 104, 104, 104, 104, 124, 124, 124, 124, 124, 124, 124, 124, 144, 144, 144, 144, 144, 144, 144, 144, 70, 0, 140, 0, 0, 60, 80, 20, 20, 20, 20, 20, 20, 40, 40, 40, 40, 40, 40, 60, 60, 60, 60, 60, 60, 80, 80, 80, 80, 80, 80, 100, 100, 100, 100, 100, 100, 120, 120, 120, 120, 120, 120, 0, 140, 60, 80, 36, 36, 36, 36, 56, 56, 56, 56, 76, 76, 76, 76, 96, 96, 96, 96, 16, 16, 116, 116, 52, 52, 72, 72, 32, 32, 92, 92, 58, 54, 140, 140}, {50, 50, 50, 50, 50, 50, 50, 50, 50, 70, 70, 70, 70, 70, 70, 70, 70, 70, 90, 90, 90, 90, 90, 90, 90, 90, 90, 110, 110, 110, 110, 110, 110, 110, 110, 110, 46, 46, 46, 46, 46, 46, 46, 46, 46, 66, 66, 66, 66, 66, 66, 66, 66, 66, 86, 86, 86, 86, 86, 86, 86, 86, 86, 106, 106, 106, 106, 106, 106, 106, 106, 106, 42, 42, 42, 42, 42, 42, 42, 42, 42, 62, 62, 62, 62, 62, 62, 62, 62, 62, 82, 82, 82, 82, 82, 82, 82, 82, 82, 102, 102, 102, 102, 102, 102, 102, 102, 102, 38, 38, 38, 38, 38, 38, 38, 38, 38, 58, 58, 58, 58, 58, 58, 58, 58, 58, 78, 78, 78, 78, 78, 78, 78, 78, 78, 98, 98, 98, 98, 98, 98, 98, 98, 98}, {16, 16, 16, 16, 16, 16, 16, 16, 16, 36, 36, 36, 36, 36, 36, 36, 36, 36, 56, 56, 56, 56, 56, 56, 56, 56, 56, 76, 76, 76, 76, 76, 76, 76, 76, 76, 96, 96, 96, 96, 96, 96, 96, 96, 96, 116, 116, 116, 116, 116, 116, 116, 116, 116, 136, 136, 136, 136, 136, 136, 136, 136, 136, 12, 12, 12, 12, 32, 32, 32, 32, 52, 52, 52, 52, 12, 12, 12, 12, 32, 32, 32, 32, 52, 52, 52, 52, 92, 92, 92, 92, 112, 112, 112, 112, 132, 132, 132, 132, 72, 92, 92, 92, 92, 112, 112, 112, 112, 132, 132, 132, 132, 18, 18, 18, 38, 38, 38, 18, 18, 18, 38, 38, 38, 98, 98, 98, 118, 118, 118, 98, 98, 98, 118, 118, 118, 24, 24, 24, 24, 104, 104, 104, 104}};
    private static final int[][] tileLayerOrig = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 5, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3}};
    private final int tsTriangle;
    private final int tsRectangle;
    private final int tsDiamond;
    private final int tsHex;
    private int tileSizeX;
    private int tileSizeY;
    private int frameOffX;
    private int frameOffY;
    private int layerDifX;
    private int layerDifY;
    private int shadowOffX;
    private int shadowOffY;
    private int areaSizeX;
    private int areaSizeY;
    private int dashboardX;
    private int dashboardY;
    private int dashboardSizeY;
    private int nearOffX;
    private int nearOffY;
    private int screenSizeX;
    private int screenSizeY;
    private int farOffX;
    private int farOffY;
    private int backOffX;
    private int backOffY;
    private int leftNeighShift;
    private int rightNeighShift;
    private int botNeighShift;
    private int topNeighShift;
    private int leftNeighMask;
    private int rightNeighMask;
    private int botNeighMask;
    private int frameLeftX1;
    private int frameLeftY1;
    private int frameLeftW;
    private int frameLeftH;
    private int frameLeftCW;
    private int frameLeftCH;
    private int frameCornerX1;
    private int frameCornerY1;
    private int frameCornerW;
    private int frameCornerH;
    private int frameBotX1;
    private int frameBotY1;
    private int frameBotW;
    private int frameBotH;
    private int frameSelDifX;
    private int frameSelDifY;
    private int shdTopX1;
    private int shdTopY1;
    private int shdTopW;
    private int shdTopH;
    private int shdTopCW;
    private int shdTopCH;
    private int shdCornerW;
    private int shdCornerH;
    private int shdRightX1;
    private int shdRightY1;
    private int shdRightW;
    private int shdRightH;
    private int frameSelTopX1;
    private int frameSelTopY1;
    private int frameSelTopW;
    private int frameSelTopH;
    private int tileAtMouse;
    private int needUpdateParam1;
    private int needUpdateParam2;
    private int globalInt1;
    private int globalInt2;
    private int tileShape;
    private int tileTypeCount;
    private int[] tileTypePair;
    private int[] tileTypeGroup;
    private int[] tileTypeX;
    private int[] tileTypeY;
    private int tileCount;
    private int[] tileX;
    private int[] tileY;
    private int[] tileLayer;
    private int[][] tileLeft;
    private int[][] tileRight;
    private int[][] tileTop;
    private int[][] tileBot;
    private int[][] tileUp;
    private int[] tileInitFree;
    private int nTileMaxHorizNeighbors;
    private int nTileMaxVertNeighbors;
    private int[] tileFree;
    private int[] tileType;
    private boolean[] tileVisible;
    private int[] solution;
    private int[] history;
    private int solutionIndex;
    private int historyIndex;
    private boolean followSolution;
    private int visibleTileCount;
    private int tileSelected;
    private boolean[] tileSelectable;
    private int matchTime;
    private int pointsPerMatch;
    private int totalScore;
    private int matchScore;
    private boolean playerWin;
    private boolean playerLose;
    private boolean playerOutOfTime;
    private boolean tileBlocked;
    private boolean readyToPlay;
    private int warnidx;
    private int warnmaxidx;
    private long matchStartTime;
    private long oldMatchStartTime;
    private boolean bDirty;
    private int winBonus;
    private int m_iRelX;
    private int m_iRelY;
    private boolean displayAvailableMatch;
    private long lastAvailableMatchDisplayed;
    private long lastAvailableMatchNotDisplayed;
    private StackMatchCanvas m_pContainer;

    public Mahmatch(int n, StackMatchCanvas stackMatchCanvas, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        this.tsTriangle = 0;
        this.tsRectangle = 1;
        this.tsDiamond = 2;
        this.tsHex = 3;
        this.m_pContainer = stackMatchCanvas;
        this.m_iRelX = n2;
        this.m_iRelY = n3;
        this.Init(n4, n5);
        this.winBonus = n8;
        this.pointsPerMatch = n6;
        this.matchTime = n7;
        this.tileCount = 144;
        this.tileShape = 1;
        this.tileTypeCount = this.tileCount / 2 + 4;
        this.tileTypePair = new int[this.tileTypeCount];
        this.tileTypeGroup = new int[this.tileTypeCount];
        this.tileTypeX = new int[this.tileTypeCount];
        this.tileTypeY = new int[this.tileTypeCount];
        int n10 = this.tileCount / 2 - 4;
        int n11 = 0;
        int n12 = 0;
        for (n9 = 0; n9 < n10; ++n9) {
            this.tileTypePair[n9] = n9;
            this.tileTypeGroup[n9] = n9 / 2;
            this.tileTypeX[n9] = n11;
            this.tileTypeY[n9] = n12;
            if ((n11 += this.tileSizeX) < this.tileSizeX * 12) continue;
            n11 = 0;
            n12 += this.tileSizeY;
        }
        for (n9 = 0; n9 < 2; ++n9) {
            int n13 = n10 + n9 * 4;
            this.tileTypePair[n13] = n13 + 1;
            this.tileTypeGroup[n13] = n10 + n9;
            this.tileTypeX[n13] = n11 + 0 * this.tileSizeX;
            this.tileTypeY[n13] = n12;
            this.tileTypePair[n13 + 1] = n13;
            this.tileTypeGroup[n13 + 1] = n10 + n9;
            this.tileTypeX[n13 + 1] = n11 + 1 * this.tileSizeX;
            this.tileTypeY[n13 + 1] = n12;
            this.tileTypePair[n13 + 2] = n13 + 3;
            this.tileTypeGroup[n13 + 2] = n10 + n9;
            this.tileTypeX[n13 + 2] = n11 + 2 * this.tileSizeX;
            this.tileTypeY[n13 + 2] = n12;
            this.tileTypePair[n13 + 3] = n13 + 2;
            this.tileTypeGroup[n13 + 3] = n10 + n9;
            this.tileTypeX[n13 + 3] = n11 + 3 * this.tileSizeX;
            this.tileTypeY[n13 + 3] = n12;
            n12 += this.tileSizeY;
        }
        this.tileX = new int[this.tileCount];
        this.tileY = new int[this.tileCount];
        this.tileLayer = new int[this.tileCount];
        System.arraycopy(tileXOrig[n], 0, this.tileX, 0, this.tileCount);
        System.arraycopy(tileYOrig[n], 0, this.tileY, 0, this.tileCount);
        System.arraycopy(tileLayerOrig[n], 0, this.tileLayer, 0, this.tileCount);
        n9 = 0;
        while (n9 < this.tileCount) {
            int n14 = n9;
            this.tileX[n14] = this.tileX[n14] + (this.m_iRelX + 25);
            int n15 = n9++;
            this.tileY[n15] = this.tileY[n15] + (this.m_iRelY + 25);
        }
        this.nTileMaxHorizNeighbors = 2;
        this.nTileMaxVertNeighbors = 4;
        this.tileLeft = new int[this.tileCount][];
        this.tileRight = new int[this.tileCount][];
        this.tileTop = new int[this.tileCount][];
        this.tileBot = new int[this.tileCount][];
        this.tileInitFree = new int[this.tileCount];
        for (n9 = 0; n9 < this.tileCount; ++n9) {
            this.tileLeft[n9] = new int[this.nTileMaxHorizNeighbors];
            this.tileRight[n9] = new int[this.nTileMaxHorizNeighbors];
            this.tileTop[n9] = new int[this.nTileMaxVertNeighbors];
            this.tileBot[n9] = new int[this.nTileMaxVertNeighbors];
        }
        this.tileFree = new int[this.tileCount];
        this.tileSelectable = new boolean[this.tileCount];
        this.tileType = new int[this.tileCount];
        this.tileVisible = new boolean[this.tileCount];
        this.solution = new int[this.tileCount];
        this.history = new int[this.tileCount];
        this.CalculateNeighbors();
    }

    public void Init(int n, int n2) {
        this.bDirty = true;
        this.tileSizeX = 16;
        this.tileSizeY = 20;
        this.frameOffX = -4;
        this.frameOffY = 0;
        this.layerDifX = 4;
        this.layerDifY = -4;
        this.shadowOffX = 4;
        this.shadowOffY = -4;
        this.areaSizeX = n;
        this.areaSizeY = n2;
        this.dashboardX = 0;
        this.dashboardY = this.areaSizeY;
        this.dashboardSizeY = 22;
        this.nearOffX = 0;
        this.nearOffY = 0;
        this.screenSizeX = this.areaSizeX;
        this.screenSizeY = this.areaSizeY + this.dashboardSizeY;
        this.farOffX = 0;
        this.farOffY = this.screenSizeY;
        this.backOffX = 0;
        this.backOffY = this.farOffY + this.areaSizeY;
        this.leftNeighShift = 0;
        this.rightNeighShift = 8;
        this.botNeighShift = 16;
        this.topNeighShift = 24;
        this.leftNeighMask = 255;
        this.rightNeighMask = 65280;
        this.botNeighMask = 0xFF0000;
        this.frameLeftX1 = 0;
        this.frameLeftY1 = 0;
        this.frameLeftW = 4;
        this.frameLeftH = 20;
        this.frameLeftCW = 4;
        this.frameLeftCH = 24;
        this.frameCornerX1 = 0;
        this.frameCornerY1 = 20;
        this.frameCornerW = 4;
        this.frameCornerH = 4;
        this.frameBotX1 = 4;
        this.frameBotY1 = 20;
        this.frameBotW = 16;
        this.frameBotH = 4;
        this.frameSelDifX = 20;
        this.frameSelDifY = 0;
        this.shdTopX1 = 40;
        this.shdTopY1 = 0;
        this.shdTopW = 16;
        this.shdTopH = 4;
        this.shdTopCW = 20;
        this.shdTopCH = 4;
        this.shdCornerW = 4;
        this.shdCornerH = 4;
        this.shdRightX1 = 58;
        this.shdRightY1 = 4;
        this.shdRightW = 4;
        this.shdRightH = 20;
        this.frameSelTopX1 = 64;
        this.frameSelTopY1 = 0;
        this.frameSelTopW = 16;
        this.frameSelTopH = 20;
        this.playerWin = false;
        this.playerLose = false;
        this.playerOutOfTime = false;
        this.tileBlocked = false;
    }

    public boolean Reset(int n) {
        int n2;
        int n3 = this.tileCount / 2 - 4;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            this.tileTypePair[n2] = n2;
            this.tileTypeGroup[n2] = n2 / 2;
            this.tileTypeX[n2] = n4;
            this.tileTypeY[n2] = n5;
            if ((n4 += this.tileSizeX) < this.tileSizeX * 12) continue;
            n4 = 0;
            n5 += this.tileSizeY;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            int n6 = n3 + n2 * 4;
            this.tileTypePair[n6] = n6 + 1;
            this.tileTypeGroup[n6] = n3 + n2;
            this.tileTypeX[n6] = n4 + 0 * this.tileSizeX;
            this.tileTypeY[n6] = n5;
            this.tileTypePair[n6 + 1] = n6;
            this.tileTypeGroup[n6 + 1] = n3 + n2;
            this.tileTypeX[n6 + 1] = n4 + 1 * this.tileSizeX;
            this.tileTypeY[n6 + 1] = n5;
            this.tileTypePair[n6 + 2] = n6 + 3;
            this.tileTypeGroup[n6 + 2] = n3 + n2;
            this.tileTypeX[n6 + 2] = n4 + 2 * this.tileSizeX;
            this.tileTypeY[n6 + 2] = n5;
            this.tileTypePair[n6 + 3] = n6 + 2;
            this.tileTypeGroup[n6 + 3] = n3 + n2;
            this.tileTypeX[n6 + 3] = n4 + 3 * this.tileSizeX;
            this.tileTypeY[n6 + 3] = n5;
            n5 += this.tileSizeY;
        }
        System.arraycopy(tileXOrig[n], 0, this.tileX, 0, this.tileCount);
        System.arraycopy(tileYOrig[n], 0, this.tileY, 0, this.tileCount);
        System.arraycopy(tileLayerOrig[n], 0, this.tileLayer, 0, this.tileCount);
        n2 = 0;
        while (n2 < this.tileCount) {
            int n7 = n2;
            this.tileX[n7] = this.tileX[n7] + (this.m_iRelX + 25);
            int n8 = n2++;
            this.tileY[n8] = this.tileY[n8] + (this.m_iRelY + 25);
        }
        this.CalculateNeighbors();
        return true;
    }

    public int GetNumTiles() {
        return this.tileCount;
    }

    public int GetTilesRemaining() {
        return this.visibleTileCount;
    }

    public int GetTotalScore() {
        return this.totalScore;
    }

    public boolean DoesPlayerWin() {
        return this.playerWin;
    }

    public boolean DoesPlayerLose() {
        return this.playerLose;
    }

    public boolean DoesPlayerOutOfTime() {
        return this.playerOutOfTime;
    }

    public boolean IsTileBlocked() {
        return this.tileBlocked;
    }

    public void CalculateNeighbors() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.tileCount; ++n2) {
            for (n = 0; n < this.nTileMaxHorizNeighbors; ++n) {
                this.tileLeft[n2][n] = -1;
                this.tileRight[n2][n] = -1;
            }
            for (n = 0; n < this.nTileMaxVertNeighbors; ++n) {
                this.tileTop[n2][n] = -1;
                this.tileBot[n2][n] = -1;
            }
        }
        for (n2 = 0; n2 < this.tileCount - 1; ++n2) {
            for (n = n2 + 1; n < this.tileCount; ++n) {
                int n3;
                int n4 = this.tileX[n2] - this.layerDifX * this.tileLayer[n2];
                int n5 = this.tileY[n2] - this.layerDifY * this.tileLayer[n2];
                int n6 = this.tileX[n] - this.layerDifX * this.tileLayer[n];
                int n7 = this.tileY[n] - this.layerDifY * this.tileLayer[n];
                int n8 = n4 + this.tileSizeX - 1;
                int n9 = n5 + this.tileSizeY - 1;
                int n10 = n6 + this.tileSizeX - 1;
                int n11 = n7 + this.tileSizeY - 1;
                if (n2 != n && this.tileLayer[n2] == this.tileLayer[n] && n4 == n6 + this.tileSizeX && (n7 >= n5 && n7 <= n9 || n11 >= n5 && n11 <= n9)) {
                    for (n3 = 0; n3 < this.nTileMaxHorizNeighbors && this.tileLeft[n2][n3] != -1; ++n3) {
                    }
                    if (n3 >= this.nTileMaxHorizNeighbors) {
                        return;
                    }
                    this.tileLeft[n2][n3] = n;
                    for (n3 = 0; n3 < this.nTileMaxHorizNeighbors && this.tileRight[n][n3] != -1; ++n3) {
                    }
                    if (n3 >= this.nTileMaxHorizNeighbors) {
                        return;
                    }
                    this.tileRight[n][n3] = n2;
                }
                if (n2 == n || this.tileLayer[n2] != this.tileLayer[n] - 1 || n8 < n6 || n10 < n4 || n9 < n7 || n11 < n5) continue;
                for (n3 = 0; n3 < this.nTileMaxVertNeighbors && this.tileTop[n2][n3] != -1; ++n3) {
                }
                if (n3 >= this.nTileMaxVertNeighbors) {
                    return;
                }
                this.tileTop[n2][n3] = n;
                for (n3 = 0; n3 < this.nTileMaxVertNeighbors && this.tileBot[n][n3] != -1; ++n3) {
                }
                if (n3 >= this.nTileMaxVertNeighbors) {
                    return;
                }
                this.tileBot[n][n3] = n2;
            }
        }
        for (n2 = 0; n2 < this.tileCount; ++n2) {
            this.tileInitFree[n2] = 0;
            for (n = 0; n < this.nTileMaxVertNeighbors; ++n) {
                if (this.tileBot[n2][n] == -1) continue;
                int n12 = n2;
                this.tileInitFree[n12] = this.tileInitFree[n12] | 1 << this.botNeighShift + n;
            }
        }
    }

    public void Play() {
        this.bDirty = true;
        this.readyToPlay = false;
        this.matchScore = this.pointsPerMatch;
        this.warnmaxidx = this.warnidx = 8;
        this.tileBlocked = false;
        this.playerWin = false;
        this.playerLose = false;
        this.playerOutOfTime = false;
        this.totalScore = 0;
        this.visibleTileCount = this.tileCount;
        this.tileSelected = -1;
        for (int i = 0; i < this.tileCount; ++i) {
            this.tileVisible[i] = true;
        }
        this.ShuffleTiles();
        this.followSolution = true;
        this.historyIndex = 0;
        this.RefreshSelectableTiles();
    }

    public boolean FindMatch() {
        for (int i = 0; i < this.tileCount - 1; ++i) {
            if (!this.tileSelectable[i]) continue;
            for (int j = i + 1; j < this.tileCount; ++j) {
                if (!this.tileSelectable[j] || this.tileTypeGroup[this.tileType[i]] != this.tileTypeGroup[this.tileType[j]]) continue;
                this.globalInt1 = i;
                this.globalInt2 = j;
                return true;
            }
        }
        return false;
    }

    public void SetFree(int n, int n2, boolean bl, boolean bl2) {
        if (bl) {
            for (int i = 0; i < this.tileLeft[n].length; ++i) {
                if (this.tileLeft[n][i] != n2) continue;
                if (bl2) {
                    int n3 = n;
                    this.tileFree[n3] = this.tileFree[n3] | 1 << this.leftNeighShift + i;
                } else {
                    int n4 = n;
                    this.tileFree[n4] = this.tileFree[n4] & ~(1 << this.leftNeighShift + i);
                }
                return;
            }
        } else {
            for (int i = 0; i < this.tileRight[n].length; ++i) {
                if (this.tileRight[n][i] != n2) continue;
                if (bl2) {
                    int n5 = n;
                    this.tileFree[n5] = this.tileFree[n5] | 1 << this.rightNeighShift + i;
                } else {
                    int n6 = n;
                    this.tileFree[n6] = this.tileFree[n6] & ~(1 << this.rightNeighShift + i);
                }
                return;
            }
        }
    }

    public void SetFreeRecursive(int n, int n2, boolean bl, boolean bl2) {
        if (this.tileType[n] != -1) {
            return;
        }
        this.SetFree(n, n2, bl, bl2);
        if (bl) {
            for (int i = 0; i < this.tileRight[n].length; ++i) {
                if (this.tileRight[n][i] == -1) continue;
                this.SetFreeRecursive(this.tileRight[n][i], n, bl, bl2);
            }
        } else {
            for (int i = 0; i < this.tileLeft[n].length; ++i) {
                if (this.tileLeft[n][i] == -1) continue;
                this.SetFreeRecursive(this.tileLeft[n][i], n, bl, bl2);
            }
        }
    }

    public void PutTile(int n, int n2) {
        int n3;
        this.tileType[n] = n2;
        for (n3 = 0; n3 < this.tileLeft[n].length; ++n3) {
            if (this.tileLeft[n][n3] == -1) continue;
            this.SetFreeRecursive(this.tileLeft[n][n3], n, false, true);
            this.SetFree(this.tileLeft[n][n3], n, false, false);
        }
        for (n3 = 0; n3 < this.tileRight[n].length; ++n3) {
            if (this.tileRight[n][n3] == -1) continue;
            this.SetFreeRecursive(this.tileRight[n][n3], n, true, true);
            this.SetFree(this.tileRight[n][n3], n, true, false);
        }
        for (n3 = 0; n3 < this.tileTop[n].length; ++n3) {
            if (this.tileTop[n][n3] == -1) continue;
            int n4 = this.tileTop[n][n3];
            for (int i = 0; i < this.tileBot[n4].length; ++i) {
                if (this.tileBot[n4][i] != n) continue;
                int n5 = n4;
                this.tileFree[n5] = this.tileFree[n5] & ~(1 << this.botNeighShift + i);
            }
        }
    }

    public boolean IsValidPair(int n, int n2) {
        int n3;
        if (this.tileLayer[n2] - this.tileLayer[n] == 1) {
            for (n3 = 0; n3 < this.tileBot[n2].length; ++n3) {
                if (this.tileBot[n2][n3] != n) continue;
                return false;
            }
        }
        int n4 = this.tileType[n2];
        this.tileType[n2] = 0;
        boolean bl = false;
        for (n3 = 0; n3 < this.tileLeft[n].length; ++n3) {
            if (this.tileLeft[n][n3] == -1 || this.tileType[this.tileLeft[n][n3]] == -1) continue;
            bl = true;
        }
        boolean bl2 = false;
        for (n3 = 0; n3 < this.tileRight[n].length; ++n3) {
            if (this.tileRight[n][n3] == -1 || this.tileType[this.tileRight[n][n3]] == -1) continue;
            bl2 = true;
        }
        this.tileType[n2] = n4;
        return !bl || !bl2;
    }

    /*
     * Unable to fully structure code
     */
    public void ShuffleTiles() {
        block0: while (true) {
            this.solutionIndex = 0;
            for (var1_2 = 0; var1_2 < this.tileCount; ++var1_2) {
                this.tileFree[var1_2] = this.tileInitFree[var1_2];
                this.tileType[var1_2] = -1;
            }
            var1_1 = new int[this.tileTypeCount];
            for (var2_3 = 0; var2_3 < this.tileTypeCount; ++var2_3) {
                var1_1[var2_3] = 0;
            }
            var2_3 = 0;
            for (var3_4 = 0; var3_4 < this.tileCount; ++var3_4) {
                v0 = var2_3++;
                var1_1[v0] = var1_1[v0] + 1;
                if (var2_3 < this.tileTypeCount) continue;
                var2_3 = 0;
            }
            for (var3_4 = this.tileCount; var3_4 > 0; var3_4 -= 2) {
                while (var1_1[var4_5 = this.m_pContainer.getRand(this.tileTypeCount)] == 0 || var1_1[this.tileTypePair[var4_5]] == 0) {
                }
                var5_6 = this.tileTypePair[var4_5];
                v1 = var4_5;
                var1_1[v1] = var1_1[v1] - 1;
                v2 = var5_6;
                var1_1[v2] = var1_1[v2] - 1;
                for (var6_7 = 0; var6_7 < this.tileCount && (this.tileType[var6_7] != -1 || this.tileFree[var6_7] != 0); ++var6_7) {
                }
                if (var6_7 >= this.tileCount) continue block0;
                while (this.tileType[var6_7 = this.m_pContainer.getRand(this.tileCount)] != -1 || this.tileFree[var6_7] != 0) {
                }
                this.solution[var3_4 - 1] = var6_7;
                this.PutTile(var6_7, var4_5);
                for (var7_8 = 0; !(var7_8 >= this.tileCount || this.tileType[var7_8] == -1 && this.tileFree[var7_8] == 0 && this.IsValidPair(var6_7, var7_8)); ++var7_8) {
                }
                if (var7_8 < this.tileCount) ** break;
                continue block0;
                while (this.tileType[var7_8 = this.m_pContainer.getRand(this.tileCount)] != -1 || this.tileFree[var7_8] != 0 || !this.IsValidPair(var6_7, var7_8)) {
                }
                this.solution[var3_4 - 2] = var7_8;
                this.PutTile(var7_8, var5_6);
            }
            break;
        }
    }

    public boolean IsTileSelectable(int n) {
        int n2;
        if (!this.tileVisible[n]) {
            return false;
        }
        for (n2 = 0; n2 < this.tileTop[n].length; ++n2) {
            if (this.tileTop[n][n2] == -1 || !this.tileVisible[this.tileTop[n][n2]]) continue;
            return false;
        }
        boolean bl = false;
        for (n2 = 0; n2 < this.tileLeft[n].length; ++n2) {
            if (this.tileLeft[n][n2] == -1 || !this.tileVisible[this.tileLeft[n][n2]]) continue;
            bl = true;
        }
        boolean bl2 = false;
        for (n2 = 0; n2 < this.tileRight[n].length; ++n2) {
            if (this.tileRight[n][n2] == -1 || !this.tileVisible[this.tileRight[n][n2]]) continue;
            bl2 = true;
        }
        return !bl || !bl2;
    }

    void RefreshSelectableTiles() {
        for (int i = 0; i < this.tileCount; ++i) {
            this.tileSelectable[i] = this.IsTileSelectable(i);
        }
    }

    public void RemovePair(int n, int n2) {
        this.m_pContainer.startMM(this.m_pContainer.m_sndTileMatch);
        this.history[this.historyIndex++] = this.needUpdateParam1 = n;
        this.history[this.historyIndex++] = this.needUpdateParam2 = n2;
        if (this.tileSelected == this.needUpdateParam1 || this.tileSelected == this.needUpdateParam2) {
            this.tileSelected = -1;
        }
        this.tileVisible[this.needUpdateParam1] = false;
        this.tileVisible[this.needUpdateParam2] = false;
        this.RefreshSelectableTiles();
        this.visibleTileCount -= 2;
        this.totalScore += this.matchScore;
        this.matchScore = this.pointsPerMatch;
        this.warnidx = 8;
        this.matchStartTime = System.currentTimeMillis();
        if (this.visibleTileCount <= 0) {
            this.playerWin = true;
            this.totalScore += this.winBonus;
        }
        if (this.visibleTileCount > 0 && !this.FindMatch()) {
            this.playerLose = true;
        }
    }

    void Pause() {
        this.oldMatchStartTime = System.currentTimeMillis();
    }

    void Resume() {
        this.matchStartTime += System.currentTimeMillis() - this.oldMatchStartTime;
    }

    public void Update(Graphics graphics, boolean bl) {
        if (bl) {
            long l;
            if (this.readyToPlay && !this.playerWin && !this.playerLose && !this.playerOutOfTime) {
                this.ShowWarning();
                l = System.currentTimeMillis() - this.matchStartTime;
                long l2 = (long)this.matchTime - l;
                this.matchScore = (int)((long)this.pointsPerMatch * l2 / (long)this.matchTime);
                if (this.matchScore <= 0 || l2 <= 0L) {
                    this.matchScore = 0;
                    this.displayAvailableMatch = true;
                    this.lastAvailableMatchDisplayed = System.currentTimeMillis();
                    this.playerOutOfTime = true;
                    this.FindMatch();
                }
            }
            if (this.playerOutOfTime) {
                this.m_pContainer.m_gOffScreen.drawImage(this.m_pContainer.m_imgBackground, this.m_iRelX + 0, this.m_iRelY + 0, 20);
                l = System.currentTimeMillis();
                if (this.displayAvailableMatch) {
                    this.DrawAllTilesWithAvailableMatch(true);
                    if (l - this.lastAvailableMatchDisplayed > 200L) {
                        this.displayAvailableMatch = false;
                        this.lastAvailableMatchNotDisplayed = l;
                    }
                } else {
                    this.DrawAllTilesWithAvailableMatch(false);
                    if (l - this.lastAvailableMatchNotDisplayed > 200L) {
                        this.displayAvailableMatch = true;
                        this.lastAvailableMatchDisplayed = l;
                    }
                }
            } else if (this.bDirty) {
                this.m_pContainer.m_gOffScreen.drawImage(this.m_pContainer.m_imgBackground, this.m_iRelX + 0, this.m_iRelY + 0, 20);
                this.DrawAllTiles();
                this.bDirty = false;
            }
            graphics.drawImage(this.m_pContainer.m_imgOffScreen, 0, 0, 20);
        } else {
            graphics.drawImage(this.m_pContainer.m_imgOffScreen, 0, 0, 20);
        }
    }

    private void ShowWarning() {
        if (!this.readyToPlay) {
            return;
        }
        long l = System.currentTimeMillis() - this.matchStartTime;
        if ((long)this.matchTime - l < (long)warntime[this.warnidx]) {
            this.m_pContainer.startMM(this.m_pContainer.m_sndWarning);
            --this.warnidx;
        }
    }

    public int GetMatchScore() {
        return this.matchScore <= 0 ? 0 : this.matchScore;
    }

    public void DrawAllTiles() {
        int n = 0;
        while (n < this.tileCount) {
            int n2 = this.tileLayer[n];
            int n3 = n;
            while (n < this.tileCount && this.tileLayer[n] == n2) {
                if (this.tileVisible[n]) {
                    this.DrawTileShadow(n);
                }
                ++n;
            }
            for (n = n3; n < this.tileCount && this.tileLayer[n] == n2; ++n) {
                if (!this.tileVisible[n]) continue;
                this.DrawTile(n);
            }
        }
    }

    void DrawAllTilesWithAvailableMatch(boolean bl) {
        int n = 0;
        while (n < this.tileCount) {
            int n2 = this.tileLayer[n];
            int n3 = n;
            while (n < this.tileCount && this.tileLayer[n] == n2) {
                if (this.tileVisible[n]) {
                    this.DrawTileShadow(n);
                }
                ++n;
            }
            for (n = n3; n < this.tileCount && this.tileLayer[n] == n2; ++n) {
                if (!this.tileVisible[n]) continue;
                if (bl) {
                    this.DrawTileWithAvailableMatch(n);
                    continue;
                }
                this.DrawTileWithNoAvailableMatch(n);
            }
        }
    }

    public void DrawTile(int n) {
        int n2 = this.tileX[n];
        int n3 = this.tileY[n];
        int n4 = this.tileType[n];
        if (n != this.tileSelected) {
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameOffX, n3, this.frameLeftCW, this.frameLeftCH, this.m_pContainer.m_imgFrame, this.frameLeftX1, this.frameLeftY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameCornerW + this.frameOffX, n3 + this.frameLeftH, this.frameBotW, this.frameBotH, this.m_pContainer.m_imgFrame, this.frameBotX1, this.frameBotY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2, n3, this.tileSizeX, this.tileSizeY, this.m_pContainer.m_imgTartsets, this.tileTypeX[n4], this.tileTypeY[n4]);
        } else {
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameOffX, n3, this.frameLeftCW, this.frameLeftCH, this.m_pContainer.m_imgFrame, this.frameSelDifX + this.frameLeftX1, this.frameSelDifY + this.frameLeftY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameCornerW + this.frameOffX, n3 + this.frameLeftH, this.frameBotW, this.frameBotH, this.m_pContainer.m_imgFrame, this.frameSelDifX + this.frameBotX1, this.frameSelDifY + this.frameBotY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2, n3, this.tileSizeX, this.tileSizeY, this.m_pContainer.m_imgTartsets, this.tileTypeX[n4], this.tileTypeY[n4]);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, (n2 += this.frameCornerW) + this.frameOffX, n3 + this.frameOffY, this.frameSelTopW, this.frameSelTopH, this.m_pContainer.m_imgFrame, this.frameSelTopX1, this.frameSelTopY1);
        }
    }

    void DrawTileWithAvailableMatch(int n) {
        int n2 = this.tileX[n];
        int n3 = this.tileY[n];
        int n4 = this.tileType[n];
        if (n != this.globalInt1 && n != this.globalInt2 && n != this.tileSelected) {
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameOffX, n3, this.frameLeftCW, this.frameLeftCH, this.m_pContainer.m_imgFrame, this.frameLeftX1, this.frameLeftY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameCornerW + this.frameOffX, n3 + this.frameLeftH, this.frameBotW, this.frameBotH, this.m_pContainer.m_imgFrame, this.frameBotX1, this.frameBotY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2, n3, this.tileSizeX, this.tileSizeY, this.m_pContainer.m_imgTartsets, this.tileTypeX[n4], this.tileTypeY[n4]);
        } else {
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameOffX, n3, this.frameLeftCW, this.frameLeftCH, this.m_pContainer.m_imgFrame, this.frameSelDifX + this.frameLeftX1, this.frameSelDifY + this.frameLeftY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameCornerW + this.frameOffX, n3 + this.frameLeftH, this.frameBotW, this.frameBotH, this.m_pContainer.m_imgFrame, this.frameSelDifX + this.frameBotX1, this.frameSelDifY + this.frameBotY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2, n3, this.tileSizeX, this.tileSizeY, this.m_pContainer.m_imgTartsets, this.tileTypeX[n4], this.tileTypeY[n4]);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, (n2 += this.frameCornerW) + this.frameOffX, n3 + this.frameOffY, this.frameSelTopW, this.frameSelTopH, this.m_pContainer.m_imgFrame, this.frameSelTopX1, this.frameSelTopY1);
        }
    }

    void DrawTileWithNoAvailableMatch(int n) {
        int n2 = this.tileX[n];
        int n3 = this.tileY[n];
        int n4 = this.tileType[n];
        if (n == this.tileSelected && n != this.globalInt1 && n != this.globalInt2) {
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameOffX, n3, this.frameLeftCW, this.frameLeftCH, this.m_pContainer.m_imgFrame, this.frameSelDifX + this.frameLeftX1, this.frameSelDifY + this.frameLeftY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameCornerW + this.frameOffX, n3 + this.frameLeftH, this.frameBotW, this.frameBotH, this.m_pContainer.m_imgFrame, this.frameSelDifX + this.frameBotX1, this.frameSelDifY + this.frameBotY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2, n3, this.tileSizeX, this.tileSizeY, this.m_pContainer.m_imgTartsets, this.tileTypeX[n4], this.tileTypeY[n4]);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, (n2 += this.frameCornerW) + this.frameOffX, n3 + this.frameOffY, this.frameSelTopW, this.frameSelTopH, this.m_pContainer.m_imgFrame, this.frameSelTopX1, this.frameSelTopY1);
        } else {
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameOffX, n3, this.frameLeftCW, this.frameLeftCH, this.m_pContainer.m_imgFrame, this.frameLeftX1, this.frameLeftY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 + this.frameCornerW + this.frameOffX, n3 + this.frameLeftH, this.frameBotW, this.frameBotH, this.m_pContainer.m_imgFrame, this.frameBotX1, this.frameBotY1);
            this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2, n3, this.tileSizeX, this.tileSizeY, this.m_pContainer.m_imgTartsets, this.tileTypeX[n4], this.tileTypeY[n4]);
        }
    }

    public void DrawTileShadow(int n) {
        int n2 = this.tileX[n];
        int n3 = this.tileY[n] + this.shadowOffY;
        this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2, n3, this.shdTopCW, this.shdTopCH, this.m_pContainer.m_imgFrame, this.shdTopX1, this.shdTopY1);
        this.m_pContainer.bitblt(this.m_pContainer.m_gOffScreen, n2 += this.tileSizeX, n3 += this.shdCornerH, this.shdRightW, this.shdRightH, this.m_pContainer.m_imgFrame, this.shdRightX1, this.shdRightY1);
    }

    public int GetTile(int n, int n2) {
        for (int i = this.tileCount - 1; i >= 0; --i) {
            if (!this.tileVisible[i] || n < this.tileX[i] - this.frameCornerW || n >= this.tileX[i] + this.tileSizeX || n2 < this.tileY[i] || n2 >= this.tileY[i] + this.tileSizeY + this.frameCornerH) continue;
            if (n >= this.tileX[i] && n < this.tileX[i] + this.tileSizeX && n2 >= this.tileY[i] && n2 < this.tileY[i] + this.tileSizeY) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    public void UpdateMousePos(int n, int n2) {
        this.tileAtMouse = this.GetTile(n, n2);
        if (this.tileAtMouse == -1) {
            this.m_pContainer.m_cursor.setImage(this.m_pContainer.m_imgCursorArrow);
        } else if (this.tileSelectable[this.tileAtMouse]) {
            this.m_pContainer.m_cursor.setImage(this.m_pContainer.m_imgCursorHand);
        } else {
            this.m_pContainer.m_cursor.setImage(this.m_pContainer.m_imgCursorStop);
        }
    }

    public void Click(int n, int n2) {
        if (this.playerWin) {
            return;
        }
        if (this.playerLose) {
            return;
        }
        if (this.playerOutOfTime) {
            return;
        }
        this.bDirty = true;
        this.tileAtMouse = this.GetTile(n, n2);
        if (this.tileAtMouse != -1) {
            if (this.tileSelectable[this.tileAtMouse]) {
                this.m_pContainer.startMM(this.m_pContainer.m_sndTileSelect);
                this.tileBlocked = false;
            } else {
                this.m_pContainer.startMM(this.m_pContainer.m_sndTileMiss);
                this.tileBlocked = true;
            }
            if (!this.readyToPlay) {
                this.readyToPlay = true;
                this.matchStartTime = System.currentTimeMillis();
            }
        }
        if (this.tileAtMouse == this.tileSelected) {
            this.needUpdateParam1 = this.tileSelected;
            this.tileSelected = -1;
            return;
        }
        if (this.tileAtMouse != -1 && this.tileSelectable[this.tileAtMouse] && this.tileSelected != -1 && this.tileTypeGroup[this.tileType[this.tileSelected]] == this.tileTypeGroup[this.tileType[this.tileAtMouse]]) {
            this.RemovePair(this.tileSelected, this.tileAtMouse);
            this.followSolution = false;
        } else {
            int n3;
            int n4 = n3 = this.tileAtMouse != -1 && this.tileSelectable[this.tileAtMouse] ? this.tileAtMouse : -1;
            if (n3 != this.tileSelected) {
                this.needUpdateParam1 = this.tileSelected;
                this.tileSelected = n3;
            }
        }
    }

    public void Cheat1() {
        if (this.playerWin) {
            return;
        }
        if (this.playerLose) {
            return;
        }
        if (this.playerOutOfTime) {
            return;
        }
        if (this.FindMatch()) {
            this.RemovePair(this.globalInt1, this.globalInt2);
            this.followSolution = false;
            this.bDirty = true;
        }
    }

    public void Cheat2() {
        if (this.playerWin) {
            return;
        }
        if (this.playerLose) {
            return;
        }
        if (this.playerOutOfTime) {
            return;
        }
        if (this.followSolution && this.solutionIndex < this.tileCount) {
            this.RemovePair(this.solution[this.solutionIndex], this.solution[this.solutionIndex + 1]);
            this.solutionIndex += 2;
            this.bDirty = true;
        }
    }
}

