/*
 * Decompiled with CFR 0.152.
 */
package role;

import java.io.DataInputStream;
import java.io.IOException;

public class ComboBrn {
    public byte skillCode = 0;
    public byte skillIndex = 0;
    public byte comboLayer = 0;
    public byte comboFork = 0;
    public ComboBrn[] nextCombo;

    public ComboBrn(DataInputStream dis, int layer, int fork) {
        this.comboLayer = (byte)layer;
        this.comboFork = (byte)fork;
        this.dataRead(dis);
    }

    public void dataRead(DataInputStream dis) {
        try {
            this.skillCode = dis.readByte();
            this.skillIndex = dis.readByte();
            int nextCount = dis.readByte();
            if (nextCount > 0) {
                this.nextCombo = new ComboBrn[nextCount];
                int i = 0;
                while (i < nextCount) {
                    this.nextCombo[i] = new ComboBrn(dis, this.comboLayer + 1, i);
                    ++i;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setComboLayer(int value) {
        this.comboLayer = (byte)value;
    }

    public void setComboFork(int value) {
        this.comboFork = (byte)value;
    }

    public ComboBrn[] getNextCombo() {
        return this.nextCombo;
    }

    public ComboBrn[] getComboAt(int layer) {
        if (this.nextCombo != null && layer > 0) {
            if (this.nextCombo[0].comboLayer == layer) {
                return this.nextCombo;
            }
            int i = 0;
            while (i < this.nextCombo.length) {
                ComboBrn[] nextComboTemp = this.nextCombo[i].getComboAt(layer);
                if (nextComboTemp != null) {
                    return nextComboTemp;
                }
                ++i;
            }
        }
        return null;
    }

    public ComboBrn getComboAt(int layer, int fork) {
        if (this.comboLayer == layer && fork < this.nextCombo.length) {
            return this.nextCombo[fork];
        }
        if (this.nextCombo != null) {
            int i = 0;
            while (i < this.nextCombo.length) {
                ComboBrn comboTemp = this.nextCombo[i].getComboAt(layer, fork);
                if (comboTemp != null) {
                    return comboTemp;
                }
                ++i;
            }
        }
        return null;
    }

    public void printAllComboTree() {
        System.out.print("L" + this.comboLayer + "-sC:" + this.skillCode + ", sI:" + this.skillIndex + " = ");
        if (this.nextCombo != null) {
            int i = 0;
            while (i < this.nextCombo.length) {
                this.nextCombo[i].printAllComboTree();
                System.out.println("");
                System.out.print("|");
                ++i;
            }
        }
    }
}

