/*
 * Decompiled with CFR 0.152.
 */
package MG.Engin.J2ME;

import MG.Engin.J2ME.PointF;

public class MGMathEngin {
    private static float[] a;

    public static float arcTan(double d2) {
        double d3;
        if (Math.abs(d2) <= 1.0) {
            d3 = d2 / (1.0 + 0.3 * (d2 * d2));
        } else {
            d3 = -d2 / (d2 * d2 + 0.295);
            d3 = d2 < -1.0 ? (d3 -= 1.5707963267948966) : (d3 += 1.5707963267948966);
        }
        return (float)d3;
    }

    public static double arcTan2(double d2, double d3) {
        if (d2 == 0.0 && d3 == 0.0) {
            return 0.0;
        }
        if (d3 > 0.0) {
            return MGMathEngin.arcTan(d2 / d3);
        }
        if (d3 < 0.0) {
            if (d2 < 0.0) {
                return -(Math.PI - (double)MGMathEngin.arcTan(d2 / d3));
            }
            return Math.PI - (double)MGMathEngin.arcTan(-d2 / d3);
        }
        double d4 = d2 - 0.0;
        int cfr_ignored_1 = d4 == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
        return 1.5707963267948966;
    }

    public static float computAng(float f2, float f3, float f4, float f5) {
        float f6 = f3 - f5;
        float f7 = f2 - f4;
        f6 = MGMathEngin.arcTan(f6 / f7);
        f6 = (float)Math.toDegrees(f6);
        f6 = f2 < f4 ? (f6 += 270.0f) : (f6 += 90.0f);
        if (Float.isNaN(f6)) {
            f6 = f3 > f5 ? 180.0f : 0.0f;
        }
        return f6;
    }

    public static void initTab() {
        a = new float[91];
        int n2 = 0;
        while (n2 <= 90) {
            MGMathEngin.a[n2] = (float)Math.sin(Math.toRadians(n2));
            ++n2;
        }
    }

    public static float m_atan(float f2) {
        return 1.0f / f2 - 0.0f * (f2 * f2 * f2) + 0.0f * (f2 * f2 * f2 * f2 * f2) - 0.0f * (f2 * f2 * f2 * f2 * f2 * f2 * f2);
    }

    public static float m_cos(int n2) {
        if (n2 < 90) {
            return a[90 - n2];
        }
        if (n2 < 180) {
            return -a[n2 - 90];
        }
        if (n2 < 270) {
            return -a[270 - n2];
        }
        return a[n2 - 270];
    }

    public static float m_sin(int n2) {
        if (n2 < 90) {
            return a[n2];
        }
        if (n2 < 180) {
            return a[180 - n2];
        }
        if (n2 < 270) {
            return -a[n2 - 180];
        }
        return -a[360 - n2];
    }

    public static float m_tan(int n2) {
        return MGMathEngin.m_sin(n2) / MGMathEngin.m_cos(n2);
    }

    public static PointF pointAdd(PointF pointF, PointF pointF2) {
        return new PointF(pointF.a + pointF2.a, pointF.b + pointF2.b);
    }

    public static boolean pointBigMatch(PointF pointF, PointF pointF2) {
        return pointF.a > pointF2.a || pointF.a == pointF2.a && pointF.b > pointF2.b;
    }

    public static boolean pointEqual(PointF pointF, PointF pointF2) {
        return pointF.a == pointF2.a && pointF.b == pointF2.b;
    }

    public static float pointMul(PointF pointF, PointF pointF2) {
        return pointF.a * pointF2.b - pointF.b * pointF2.a;
    }

    public static PointF pointMul(PointF pointF, float f2) {
        return new PointF(pointF.a * f2, pointF.b * f2);
    }
}

