/*
 * Decompiled with CFR 0.152.
 */
package com.move2008.mj;

import com.move2008.mj.MeldedSet;
import java.util.Vector;

public final class Player {
    public static final byte HUMAN = 0;
    public static final byte HANDHELD = 1;
    private boolean m_bConcealed = true;
    private boolean m_bPicked = false;
    private boolean m_bIssuedTen = false;
    private boolean m_bTen = false;
    private byte m_btDiscardPos = (byte)13;
    private byte m_btFanTileCount = 0;
    private byte m_btKongPos = (byte)-1;
    private int m_nPoint = 100;
    private Vector m_vInHand = new Vector();
    private Vector m_vMelded = new Vector();
    private Vector m_vHouSet = new Vector();
    private Vector m_vDiscarded = new Vector();
    private boolean m_bBanker;
    private byte m_btType;
    private byte m_btPickedTile;
    private byte m_btGoalPos;
    private Vector m_vChances;
    int[] zhuangtai;

    public Player(byte byte0) {
        this.m_btType = byte0;
        this.m_bBanker = this.m_btType == 0;
    }

    public boolean isBig3Yuan() {
        return this.gotChungFan() && this.gotFaFan() && this.gotBaiFan();
    }

    public boolean isSameSuit() {
        boolean flag = true;
        int byte0 = 0;
        int byte2 = -1;
        while (flag && byte0 < this.m_vMelded.size()) {
            int n = byte0;
            byte0 = (byte)(byte0 + 1);
            MeldedSet meldedset = (MeldedSet)this.m_vMelded.elementAt(n);
            byte byte3 = meldedset.getTileOrIndex();
            if (byte2 == -1 && byte3 < 30) {
                byte2 = (byte)(byte3 / 10);
            }
            switch (meldedset.getType()) {
                case 4: 
                case 5: 
                case 6: {
                    flag = byte3 / 10 == byte2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    flag = byte3 < 30 && byte3 / 10 == byte2;
                }
            }
        }
        int byte1 = 0;
        while (flag && byte1 < this.m_vHouSet.size()) {
            int n = byte1;
            byte1 = (byte)(byte1 + 1);
            MeldedSet meldedset1 = (MeldedSet)this.m_vHouSet.elementAt(n);
            byte byte4 = meldedset1.getTileOrIndex();
            if (byte2 == -1 && byte4 < 30) {
                byte2 = (byte)(byte4 / 10);
            }
            switch (meldedset1.getType()) {
                case 10: {
                    flag = byte4 / 10 == byte2;
                    break;
                }
                case 11: 
                case 12: {
                    flag = byte4 < 30 && byte4 / 10 == byte2;
                }
            }
        }
        return flag;
    }

    public boolean isPure19() {
        boolean flag = true;
        flag = this.isPure19(this.m_vMelded);
        if (flag) {
            flag = this.isPure19(this.m_vHouSet);
        }
        return flag;
    }

    private boolean isPure19(Vector vector) {
        boolean flag = true;
        int byte0 = 0;
        while (flag && byte0 < vector.size()) {
            int n = byte0;
            byte0 = (byte)(byte0 + 1);
            MeldedSet meldedset = (MeldedSet)vector.elementAt(n);
            byte byte1 = meldedset.getTileOrIndex();
            byte byte2 = (byte)(byte1 % 10);
            switch (meldedset.getType()) {
                case 4: 
                case 10: {
                    flag = byte2 == 1 || byte2 == 7;
                    break;
                }
                case 5: {
                    flag = byte2 == 2 || byte2 == 8;
                    break;
                }
                case 6: {
                    flag = byte2 == 3 || byte2 == 9;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    flag = byte1 < 30 && (byte2 == 1 || byte2 == 9);
                }
            }
        }
        return flag;
    }

    public boolean isUnpureSameSuit() {
        boolean flag = true;
        int byte0 = 0;
        int byte2 = -1;
        while (flag && byte0 < this.m_vMelded.size()) {
            int n = byte0;
            byte0 = (byte)(byte0 + 1);
            MeldedSet meldedset = (MeldedSet)this.m_vMelded.elementAt(n);
            byte byte3 = meldedset.getTileOrIndex();
            if (byte2 == -1 && byte3 < 30) {
                byte2 = (byte)(byte3 / 10);
            }
            switch (meldedset.getType()) {
                case 4: 
                case 5: 
                case 6: {
                    flag = byte3 / 10 == byte2;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    flag = byte3 > 30 || byte3 / 10 == byte2;
                }
            }
        }
        int byte1 = 0;
        while (flag && byte1 < this.m_vHouSet.size()) {
            int n = byte1;
            byte1 = (byte)(byte1 + 1);
            MeldedSet meldedset1 = (MeldedSet)this.m_vHouSet.elementAt(n);
            byte byte4 = meldedset1.getTileOrIndex();
            if (byte2 == -1 && byte4 < 30) {
                byte2 = (byte)(byte4 / 10);
            }
            switch (meldedset1.getType()) {
                case 10: {
                    flag = byte4 / 10 == byte2;
                    break;
                }
                case 11: 
                case 12: {
                    flag = byte4 > 30 || byte4 / 10 == byte2;
                }
            }
        }
        return flag;
    }

    public boolean is7Pairs() {
        boolean flag = false;
        if (this.m_bConcealed) {
            flag = true;
            for (int byte0 = 0; flag && byte0 < this.m_vHouSet.size(); byte0 = (int)((byte)(byte0 + 1))) {
                int n = byte0;
                flag = ((MeldedSet)this.m_vHouSet.elementAt(n)).getType() == 12;
            }
        }
        return flag;
    }

    public boolean isSmall3Yuan() {
        return this.gotChungFan() && this.gotFaFan() && this.getTileCount(this.m_vInHand, new Byte(37)) == 2 || this.gotChungFan() && this.gotBaiFan() && this.getTileCount(this.m_vInHand, new Byte(36)) == 2 || this.gotFaFan() && this.gotBaiFan() && this.getTileCount(this.m_vInHand, new Byte(35)) == 2;
    }

    public boolean isPongPongHou() {
        boolean flag = true;
        for (int byte0 = 0; flag && byte0 < this.m_vMelded.size(); byte0 = (int)((byte)(byte0 + 1))) {
            int n = byte0;
            byte byte2 = ((MeldedSet)this.m_vMelded.elementAt(n)).getType();
            flag = byte2 == 7 || byte2 == 8 || byte2 == 9;
        }
        if (flag) {
            int byte1 = 0;
            int byte3 = 0;
            while (flag && byte1 < this.m_vHouSet.size()) {
                int n = byte1;
                byte1 = (byte)(byte1 + 1);
                switch (((MeldedSet)this.m_vHouSet.elementAt(n)).getType()) {
                    case 12: {
                        byte3 = (byte)(byte3 + 1);
                        break;
                    }
                    case 10: {
                        flag = false;
                    }
                }
            }
            if (flag && byte3 == 7) {
                flag = false;
            }
        }
        return flag;
    }

    public boolean got3ConcealedTriple() {
        return this.getConcealedTripleCount() == 3;
    }

    private byte getConcealedTripleCount() {
        byte byte0 = 0;
        if (this.m_bConcealed) {
            byte0 = (byte)(byte0 + this.m_vMelded.size());
        }
        for (int byte1 = 0; byte1 < this.m_vHouSet.size(); byte1 = (int)((byte)(byte1 + 1))) {
            if (((MeldedSet)this.m_vHouSet.elementAt(byte1)).getType() != 11) continue;
            byte0 = (byte)(byte0 + 1);
        }
        return byte0;
    }

    public boolean isNonPure19WithWord() {
        boolean flag = true;
        flag = this.isNonPure19WithWord(this.m_vMelded);
        if (flag) {
            flag = this.isNonPure19WithWord(this.m_vHouSet);
        }
        return flag;
    }

    private boolean isNonPure19WithWord(Vector vector) {
        boolean flag = true;
        int byte0 = 0;
        while (flag && byte0 < vector.size()) {
            int n = byte0;
            byte0 = (byte)(byte0 + 1);
            MeldedSet meldedset = (MeldedSet)vector.elementAt(n);
            byte byte1 = meldedset.getTileOrIndex();
            byte byte2 = (byte)(byte1 % 10);
            switch (meldedset.getType()) {
                case 4: 
                case 10: {
                    flag = byte2 == 1 || byte2 == 7;
                    break;
                }
                case 5: {
                    flag = byte2 == 2 || byte2 == 8;
                    break;
                }
                case 6: {
                    flag = byte2 == 3 || byte2 == 9;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: {
                    flag = byte1 > 30 || byte2 == 1 || byte2 == 9;
                }
            }
        }
        return flag;
    }

    public boolean gotDragon() {
        boolean flag = false;
        this.m_vChances = this.sequenceFilter();
        if (this.m_vChances.size() > 2) {
            Vector<Byte> vector = new Vector<Byte>();
            Vector<Byte> vector1 = new Vector<Byte>();
            Vector<Byte> vector2 = new Vector<Byte>();
            block9: for (int byte0 = 0; byte0 < this.m_vChances.size(); byte0 = (int)((byte)(byte0 + 1))) {
                MeldedSet meldedset = (MeldedSet)this.m_vChances.elementAt(byte0);
                byte byte1 = meldedset.getTileOrIndex();
                switch (meldedset.getType()) {
                    case 5: {
                        byte1 = (byte)(byte1 - 1);
                        break;
                    }
                    case 6: {
                        byte1 = (byte)(byte1 - 2);
                    }
                }
                switch (byte1 / 10) {
                    case 0: {
                        vector.addElement(new Byte((byte)(byte1 % 10)));
                        continue block9;
                    }
                    case 1: {
                        vector1.addElement(new Byte((byte)(byte1 % 10)));
                        continue block9;
                    }
                    case 2: {
                        vector2.addElement(new Byte((byte)(byte1 % 10)));
                    }
                }
            }
            if (vector.size() > 2) {
                flag = this.gotDragon(vector);
            }
            if (!flag && vector1.size() > 2) {
                flag = this.gotDragon(vector1);
            }
            if (!flag && vector2.size() > 2) {
                flag = this.gotDragon(vector2);
            }
        }
        return flag;
    }

    private boolean gotDragon(Vector vector) {
        this.sort(vector);
        return vector.contains(new Byte(1)) && vector.contains(new Byte(4)) && vector.contains(new Byte(7));
    }

    public boolean gotSameSequence() {
        this.m_vChances = this.sequenceFilter();
        boolean flag = false;
        if (this.m_vChances.size() > 1) {
            int byte0 = 0;
            while (!flag && byte0 < this.m_vChances.size() - 1) {
                int n = byte0;
                byte0 = (byte)(byte0 + 1);
                MeldedSet meldedset = (MeldedSet)this.m_vChances.elementAt(n);
                byte byte1 = meldedset.getType();
                byte byte2 = meldedset.getTileOrIndex();
                byte2 = meldedset.getType() != 5 ? (meldedset.getType() != 6 ? byte2 : (byte)(byte2 - 2)) : (byte)(byte2 - 1);
                int byte3 = byte0;
                while (!flag && byte3 < this.m_vChances.size()) {
                    int n2 = byte3;
                    byte3 = (byte)(byte3 + 1);
                    MeldedSet meldedset1 = (MeldedSet)this.m_vChances.elementAt(n2);
                    byte byte4 = meldedset1.getType();
                    byte byte5 = meldedset1.getTileOrIndex();
                    byte5 = meldedset1.getType() != 5 ? (meldedset1.getType() != 6 ? byte5 : (byte)(byte5 - 2)) : (byte)(byte5 - 1);
                    flag = byte2 == byte5;
                }
            }
        }
        return flag;
    }

    private Vector sequenceFilter() {
        Vector<MeldedSet> vector = new Vector<MeldedSet>();
        for (int byte0 = 0; byte0 < this.m_vMelded.size(); byte0 = (int)((byte)(byte0 + 1))) {
            MeldedSet meldedset = (MeldedSet)this.m_vMelded.elementAt(byte0);
            if (meldedset.getType() != 4 && meldedset.getType() != 5 && meldedset.getType() != 6) continue;
            vector.addElement(meldedset);
        }
        for (int byte1 = 0; byte1 < this.m_vHouSet.size(); byte1 = (int)((byte)(byte1 + 1))) {
            MeldedSet meldedset1 = (MeldedSet)this.m_vHouSet.elementAt(byte1);
            if (meldedset1.getType() != 10) continue;
            vector.addElement(meldedset1);
        }
        return vector;
    }

    public boolean isNo19() {
        boolean flag = true;
        int byte0 = 0;
        while (flag && byte0 < this.m_vMelded.size()) {
            int n = byte0;
            byte0 = (byte)(byte0 + 1);
            MeldedSet meldedset = (MeldedSet)this.m_vMelded.elementAt(n);
            byte byte2 = meldedset.getTileOrIndex();
            byte byte4 = (byte)(byte2 % 10);
            switch (meldedset.getType()) {
                case 4: {
                    flag &= byte4 != 1 && byte4 != 7;
                    break;
                }
                case 5: {
                    flag &= byte4 != 2 && byte4 != 8;
                    break;
                }
                case 6: {
                    flag &= byte4 != 3 && byte4 != 9;
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    flag &= byte2 < 30 && byte4 != 1 && byte4 != 9;
                }
            }
        }
        if (flag) {
            int byte1 = 0;
            while (flag && byte1 < this.m_vHouSet.size()) {
                int n = byte1;
                byte1 = (byte)(byte1 + 1);
                MeldedSet meldedset1 = (MeldedSet)this.m_vHouSet.elementAt(n);
                byte byte3 = meldedset1.getTileOrIndex();
                byte byte5 = (byte)(byte3 % 10);
                switch (meldedset1.getType()) {
                    case 10: {
                        flag &= byte5 != 1 && byte5 != 7;
                        break;
                    }
                    case 11: 
                    case 12: {
                        flag &= byte3 < 30 && byte5 != 1 && byte5 != 9;
                    }
                }
            }
        }
        return flag;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isPinHou() {
        flag = true;
        {
            ** for (byte0 = 0;
            ; flag && byte0 < this.m_vMelded.size(); byte0 = (int)((byte)(byte0 + 1)), flag &= (byte2 = ((MeldedSet)this.m_vMelded.elementAt((int)byte0)).getType()) == 4 || byte2 == 5 || byte2 == 6)
lbl3:
            // 1 sources

            continue;
        }
lbl4:
        // 1 sources

        if (flag) {
            byte1 = 0;
            byte3 = 0;
            while (flag && byte3 < 2 && byte1 < this.m_vHouSet.size()) {
                v0 = byte1;
                byte1 = (byte)(byte1 + 1);
                byte4 = ((MeldedSet)this.m_vHouSet.elementAt(v0)).getType();
                if (byte4 == 12) {
                    byte3 = (byte)(byte3 + 1);
                    continue;
                }
                flag &= byte4 == 10;
            }
            flag &= byte3 == 1;
        }
        return flag;
    }

    public boolean gotBaiFan() {
        return this.got3WordTiles((byte)37);
    }

    public boolean gotFaFan() {
        return this.got3WordTiles((byte)36);
    }

    public boolean gotChungFan() {
        return this.got3WordTiles((byte)35);
    }

    public boolean gotWindFan(byte byte0) {
        return this.got3WordTiles((byte)(byte0 + 31));
    }

    private boolean got3WordTiles(byte byte0) {
        boolean flag = false;
        flag = this.gotWordPong(byte0);
        if (!flag) {
            byte byte1 = this.getTileCount(this.m_vInHand, new Byte(byte0));
            flag = byte1 == 3 || byte1 == 2 && byte0 == this.m_btPickedTile;
        }
        return flag;
    }

    private boolean gotWordPong(byte byte0) {
        boolean flag = false;
        for (int byte1 = 0; !flag && byte1 < this.m_vMelded.size(); byte1 = (int)((byte)(byte1 + 1))) {
            int n = byte1;
            MeldedSet meldedset = (MeldedSet)this.m_vMelded.elementAt(n);
            if (meldedset.getType() != 7 && meldedset.getType() != 8 && meldedset.getType() != 9) continue;
            flag = meldedset.getTileOrIndex() == byte0;
        }
        return flag;
    }

    public boolean isBanker() {
        return this.m_bBanker;
    }

    public void setBanker(boolean flag) {
        this.m_bBanker = flag;
    }

    public void calPoint(int i) {
        this.m_nPoint += i;
    }

    public int getPoint() {
        return this.m_nPoint;
    }

    public void setPoint(int i) {
        this.m_nPoint = i;
    }

    public void lostLastDiscardedTile() {
        this.m_vDiscarded.removeElementAt(this.m_vDiscarded.size() - 1);
    }

    public byte inHandPos(byte byte0) {
        return (byte)this.m_vInHand.indexOf(new Byte(byte0));
    }

    public boolean gotMeldChance(byte byte0) {
        this.m_vChances = new Vector();
        this.chowFChance(byte0);
        this.chowMChance(byte0);
        this.chowLChance(byte0);
        this.pongChance(byte0);
        this.kongUChance(byte0);
        if (this.m_vChances.size() != 0) {
            this.zhuangtai = new int[this.m_vChances.size()];
            for (int i = 0; i < this.m_vChances.size(); ++i) {
                this.zhuangtai[i] = ((MeldedSet)this.m_vChances.elementAt(i)).getType();
            }
        } else {
            this.zhuangtai = new int[1];
            this.zhuangtai[0] = -1;
        }
        return this.m_vChances.size() != 0;
    }

    private void kongUChance(byte byte0) {
        if (this.getTileCount(this.m_vInHand, new Byte(byte0)) == 3) {
            this.m_vChances.addElement(new MeldedSet(9, byte0));
            System.out.println("m_vChances1");
        }
    }

    private void pongChance(byte byte0) {
        if (this.getTileCount(this.m_vInHand, new Byte(byte0)) > 1) {
            this.m_vChances.addElement(new MeldedSet(7, byte0));
            System.out.println("m_vChances2");
        }
    }

    private void chowLChance(byte byte0) {
        if (byte0 < 30 && byte0 % 10 > 2 && this.m_vInHand.contains(new Byte((byte)(byte0 - 1))) && this.m_vInHand.contains(new Byte((byte)(byte0 - 2)))) {
            this.m_vChances.addElement(new MeldedSet(6, byte0));
            System.out.println("m_vChances3");
        }
    }

    private void chowMChance(byte byte0) {
        if (byte0 < 30 && byte0 % 10 > 1 && byte0 % 10 < 9 && this.m_vInHand.contains(new Byte((byte)(byte0 - 1))) && this.m_vInHand.contains(new Byte((byte)(byte0 + 1)))) {
            this.m_vChances.addElement(new MeldedSet(5, byte0));
            System.out.println("m_vChances4");
        }
    }

    private void chowFChance(byte byte0) {
        if (byte0 < 30 && byte0 % 10 < 8 && this.m_vInHand.contains(new Byte((byte)(byte0 + 1))) && this.m_vInHand.contains(new Byte((byte)(byte0 + 2)))) {
            this.m_vChances.addElement(new MeldedSet(4, byte0));
            System.out.println("m_vChances5");
        }
    }

    public byte lastDiscardedTile() {
        return (Byte)this.m_vDiscarded.lastElement();
    }

    public MeldedSet getMeldedAt(byte byte0) {
        return (MeldedSet)this.m_vMelded.elementAt(byte0);
    }

    public byte getMeldedCount() {
        return (byte)this.m_vMelded.size();
    }

    public void doMelded(MeldedSet meldedset) {
        this.m_bConcealed = this.m_bConcealed && (meldedset.getType() == 0 || meldedset.getType() == 2);
        switch (meldedset.getType()) {
            default: {
                break;
            }
            case 9: {
                for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
                    this.m_vInHand.removeElement(new Byte(meldedset.getTileOrIndex()));
                }
                this.m_vMelded.addElement(meldedset);
                this.m_btDiscardPos = (byte)this.m_vInHand.size();
                break;
            }
            case 7: {
                this.m_vInHand.removeElement(new Byte(meldedset.getTileOrIndex()));
                this.m_vInHand.removeElement(new Byte(meldedset.getTileOrIndex()));
                Byte byte1 = (Byte)this.m_vInHand.lastElement();
                this.m_vInHand.removeElement(byte1);
                this.m_bPicked = true;
                this.m_btPickedTile = byte1;
                this.m_btDiscardPos = (byte)this.m_vInHand.size();
                this.m_vMelded.addElement(meldedset);
                break;
            }
            case 4: {
                this.m_vInHand.removeElement(new Byte((byte)(meldedset.getTileOrIndex() + 1)));
                this.m_vInHand.removeElement(new Byte((byte)(meldedset.getTileOrIndex() + 2)));
                Byte byte2 = (Byte)this.m_vInHand.lastElement();
                this.m_vInHand.removeElement(byte2);
                this.m_bPicked = true;
                this.m_btPickedTile = byte2;
                this.m_btDiscardPos = (byte)this.m_vInHand.size();
                this.m_vMelded.addElement(meldedset);
                break;
            }
            case 5: {
                this.m_vInHand.removeElement(new Byte((byte)(meldedset.getTileOrIndex() - 1)));
                this.m_vInHand.removeElement(new Byte((byte)(meldedset.getTileOrIndex() + 1)));
                Byte byte3 = (Byte)this.m_vInHand.lastElement();
                this.m_vInHand.removeElement(byte3);
                this.m_bPicked = true;
                this.m_btPickedTile = byte3;
                this.m_btDiscardPos = (byte)this.m_vInHand.size();
                this.m_vMelded.addElement(meldedset);
                break;
            }
            case 6: {
                this.m_vInHand.removeElement(new Byte((byte)(meldedset.getTileOrIndex() - 1)));
                this.m_vInHand.removeElement(new Byte((byte)(meldedset.getTileOrIndex() - 2)));
                Byte byte4 = (Byte)this.m_vInHand.lastElement();
                this.m_vInHand.removeElement(byte4);
                this.m_bPicked = true;
                this.m_btPickedTile = byte4;
                this.m_btDiscardPos = (byte)this.m_vInHand.size();
                this.m_vMelded.addElement(meldedset);
                break;
            }
            case 0: {
                this.m_btKongPos = (byte)this.m_vDiscarded.size();
                for (int byte5 = 0; byte5 < 3; byte5 = (int)((byte)(byte5 + 1))) {
                    this.m_vInHand.removeElementAt(meldedset.getTileOrIndex());
                }
                this.m_vMelded.addElement(new MeldedSet(8, this.m_btPickedTile));
                break;
            }
            case 1: {
                this.m_btKongPos = (byte)this.m_vDiscarded.size();
                ((MeldedSet)this.m_vMelded.elementAt(meldedset.getTileOrIndex())).changeTo((byte)9);
                break;
            }
            case 2: {
                this.m_btKongPos = (byte)this.m_vDiscarded.size();
                this.m_vMelded.addElement(new MeldedSet(8, (Byte)this.m_vInHand.elementAt(meldedset.getTileOrIndex())));
                for (int byte6 = 0; byte6 < 4; byte6 = (int)((byte)(byte6 + 1))) {
                    this.m_vInHand.removeElementAt(meldedset.getTileOrIndex());
                }
                this.m_vInHand.addElement(new Byte(this.m_btPickedTile));
                this.sortInHand();
                break;
            }
            case 3: {
                this.m_btKongPos = (byte)this.m_vDiscarded.size();
                ((MeldedSet)this.m_vMelded.elementAt(meldedset.getTileOrIndex())).changeTo((byte)9);
                this.m_vInHand.removeElement(new Byte(((MeldedSet)this.m_vMelded.elementAt(meldedset.getTileOrIndex())).getTileOrIndex()));
                this.m_vInHand.addElement(new Byte(this.m_btPickedTile));
                this.sortInHand();
            }
        }
    }

    public byte getChanceCount() {
        return (byte)this.m_vChances.size();
    }

    public MeldedSet currentChance() {
        return (MeldedSet)this.m_vChances.firstElement();
    }

    public void rightChance() {
        Object obj = this.m_vChances.firstElement();
        this.m_vChances.removeElement(obj);
        this.m_vChances.addElement(obj);
    }

    public void leftChance() {
        Object obj = this.m_vChances.lastElement();
        this.m_vChances.removeElement(obj);
        this.m_vChances.insertElementAt(obj, 0);
    }

    public void calFanTileCount(Vector vector) {
        this.m_btFanTileCount = 0;
        for (int byte0 = 0; byte0 < vector.size(); byte0 = (int)((byte)(byte0 + 1))) {
            this.m_btFanTileCount = (byte)(this.m_btFanTileCount + this.getTileCount(this.m_vInHand, (Byte)vector.elementAt(byte0)));
        }
    }

    public byte getFanTileCount() {
        return this.m_btFanTileCount;
    }

    public void reset() {
        this.m_vInHand.removeAllElements();
        this.m_vMelded.removeAllElements();
        this.m_vHouSet.removeAllElements();
        this.m_vDiscarded.removeAllElements();
        this.m_bConcealed = true;
        this.m_bTen = false;
        this.m_btDiscardPos = (byte)13;
        this.m_btFanTileCount = 0;
    }

    public void cancelIssuedTen() {
        this.m_bIssuedTen = false;
    }

    public boolean isTenIssued() {
        return this.m_bIssuedTen;
    }

    public void issueTen() {
        this.m_bIssuedTen = true;
    }

    public boolean isConcealed() {
        return this.m_bConcealed;
    }

    public byte getGoalPos() {
        return this.m_btGoalPos;
    }

    public void chooseDiscard() {
        Byte byte1;
        Vector vector = this.cloneVector(this.m_vInHand);
        vector.addElement(new Byte(this.m_btPickedTile));
        this.sort(vector);
        this.m_vHouSet.removeAllElements();
        Vector vector1 = new Vector();
        while (vector.size() != 0) {
            if (this.isSequence(vector) || this.isTriple(vector) || this.isPair(vector)) continue;
            Object obj = vector.firstElement();
            vector1.addElement(obj);
            vector.removeElement(obj);
        }
        this.m_btGoalPos = (byte)this.m_vInHand.size();
        if (vector1.size() != 0 && (byte1 = (Byte)vector1.lastElement()) != this.m_btPickedTile) {
            this.m_btGoalPos = (byte)this.m_vInHand.indexOf(byte1);
        }
    }

    public byte getDiscardedTile(byte byte0) {
        return (Byte)this.m_vDiscarded.elementAt(byte0);
    }

    public byte getDiscardedCount() {
        return (byte)this.m_vDiscarded.size();
    }

    public void discard() {
        this.m_bPicked = false;
        Byte byte1 = null;
        if (this.m_btDiscardPos == this.m_vInHand.size()) {
            byte1 = new Byte(this.m_btPickedTile);
        } else {
            byte1 = (Byte)this.m_vInHand.elementAt(this.m_btDiscardPos);
            this.m_vInHand.removeElement(byte1);
            this.m_vInHand.addElement(new Byte(this.m_btPickedTile));
            this.sort(this.m_vInHand);
        }
        this.m_vDiscarded.addElement(byte1);
    }

    public void setTen() {
        this.m_bTen = true;
    }

    public boolean isTen() {
        return this.m_bTen;
    }

    public boolean ten() {
        Vector vector = this.cloneVector(this.m_vInHand);
        return this.checkTenSTP(vector) || this.checkTenTPS(vector) || this.checkTenSTPO(vector) || this.checkTenTPSO(vector);
    }

    private boolean checkTenTPSO(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        Vector vector2 = new Vector();
        byte byte0 = 0;
        while (vector2.size() < 3 && vector1.size() != 0) {
            if (this.isTripleO(vector1)) continue;
            if (this.isPairO(vector1)) {
                byte0 = (byte)(byte0 + 2);
                continue;
            }
            if (this.isSequenceO(vector1)) continue;
            Object obj = vector1.lastElement();
            vector2.addElement(obj);
            vector1.removeElement(obj);
        }
        return this.reachTenCondition(vector2, byte0);
    }

    private boolean checkTenSTPO(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        Vector vector2 = new Vector();
        byte byte0 = 0;
        while (vector2.size() < 3 && vector1.size() != 0) {
            if (this.isSequenceO(vector1) || this.isTripleO(vector1)) continue;
            if (this.isPairO(vector1)) {
                byte0 = (byte)(byte0 + 2);
                continue;
            }
            Object obj = vector1.lastElement();
            vector2.addElement(obj);
            vector1.removeElement(obj);
        }
        return this.reachTenCondition(vector2, byte0);
    }

    private boolean checkTenTPS(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        Vector vector2 = new Vector();
        byte byte0 = 0;
        while (vector2.size() < 3 && vector1.size() != 0) {
            if (this.isTriple(vector1)) continue;
            if (this.isPair(vector1)) {
                byte0 = (byte)(byte0 + 2);
                continue;
            }
            if (this.isSequence(vector1)) continue;
            Object obj = vector1.firstElement();
            vector2.addElement(obj);
            vector1.removeElement(obj);
        }
        return this.reachTenCondition(vector2, byte0);
    }

    private boolean checkTenSTP(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        Vector vector2 = new Vector();
        byte byte0 = 0;
        while (vector2.size() < 3 && vector1.size() != 0) {
            if (this.isSequence(vector1) || this.isTriple(vector1)) continue;
            if (this.isPair(vector1)) {
                byte0 = (byte)(byte0 + 2);
                continue;
            }
            Object obj = vector1.firstElement();
            vector2.addElement(obj);
            vector1.removeElement(obj);
        }
        return this.reachTenCondition(vector2, byte0);
    }

    private boolean reachTenCondition(Vector vector, byte byte0) {
        this.sort(vector);
        boolean flag = false;
        if (byte0 == 12 || byte0 == 4 && vector.size() == 0) {
            flag = true;
        } else if (vector.size() == 2 && byte0 == 2) {
            byte byte1 = (Byte)vector.firstElement();
            byte byte2 = (Byte)vector.lastElement();
            flag = byte1 < 30 && (byte1 % 10 != 9 && byte1 + 1 == byte2 || byte1 % 10 < 8 && byte1 + 2 == byte2);
        } else if (vector.size() == 1 && byte0 == 0) {
            flag = true;
        }
        return flag;
    }

    public boolean isPicked() {
        return this.m_bPicked;
    }

    public void rightDiscardPos() {
        this.m_btDiscardPos = this.m_btDiscardPos != this.m_vInHand.size() ? (byte)(this.m_btDiscardPos + 1) : (byte)0;
    }

    public void leftDiscardPos() {
        this.m_btDiscardPos = this.m_btDiscardPos != 0 ? (byte)(this.m_btDiscardPos - 1) : (byte)this.m_vInHand.size();
    }

    public boolean gotSelfKongChance() {
        this.m_vChances = new Vector();
        this.pickedConcealedSelfKongChance();
        this.pickedUnconcealedSelfKongChance();
        this.inhandConcealedSelfKongChance();
        this.inhandUnconcealedSelfKongChance();
        return this.m_vChances.size() != 0;
    }

    private void inhandUnconcealedSelfKongChance() {
        for (byte byte0 = 0; byte0 < this.m_vMelded.size(); byte0 = (byte)((byte)(byte0 + 1))) {
            MeldedSet meldedset = (MeldedSet)this.m_vMelded.elementAt(byte0);
            if (meldedset.getType() != 7 || !this.m_vInHand.contains(new Byte(meldedset.getTileOrIndex()))) continue;
            this.m_vChances.addElement(new MeldedSet(3, byte0));
        }
    }

    private void inhandConcealedSelfKongChance() {
        Vector vector = this.cloneVector(this.m_vInHand);
        while (vector.size() > 3) {
            Byte byte1 = (Byte)vector.firstElement();
            if (this.getTileCount(vector, byte1) == 4) {
                for (int byte0 = 0; byte0 < 4; byte0 = (int)((byte)(byte0 + 1))) {
                    vector.removeElement(byte1);
                }
                this.m_vChances.addElement(new MeldedSet(2, (byte)this.m_vInHand.indexOf(byte1)));
                continue;
            }
            vector.removeElement(byte1);
        }
    }

    private void pickedUnconcealedSelfKongChance() {
        for (byte byte0 = 0; byte0 < this.m_vMelded.size(); byte0 = (byte)((byte)(byte0 + 1))) {
            MeldedSet meldedset = (MeldedSet)this.m_vMelded.elementAt(byte0);
            if (meldedset.getType() != 7 || meldedset.getTileOrIndex() != this.m_btPickedTile) continue;
            this.m_vChances.addElement(new MeldedSet(1, byte0));
        }
    }

    private void pickedConcealedSelfKongChance() {
        Byte byte1 = new Byte(this.m_btPickedTile);
        if (this.getTileCount(this.m_vInHand, byte1) == 3) {
            this.m_vChances.addElement(new MeldedSet(0, (byte)this.m_vInHand.indexOf(byte1)));
        }
    }

    public boolean isHuman() {
        return this.m_btType == 0;
    }

    public byte getDiscardPos() {
        return this.m_btDiscardPos;
    }

    public byte getPickedTile() {
        return this.m_btPickedTile;
    }

    public boolean pick(byte byte0) {
        this.m_bPicked = true;
        this.m_btPickedTile = byte0;
        this.m_btDiscardPos = (byte)this.m_vInHand.size();
        return this.gotHouChance(this.m_btPickedTile);
    }

    public boolean gotHouChance(byte byte0) {
        Vector vector = this.cloneVector(this.m_vInHand);
        vector.addElement(new Byte(byte0));
        this.sort(vector);
        return this.checkHouSTP(vector) || this.checkHouTPS(vector) || this.checkHouSTPO(vector) || this.checkHouTPSO(vector);
    }

    private boolean checkHouTPSO(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        byte byte0 = 0;
        byte byte1 = 0;
        while (byte0 == 0 && vector1.size() != 0) {
            if (this.isTripleO(vector1)) continue;
            if (this.isPairO(vector1)) {
                byte1 = (byte)(byte1 + 2);
                continue;
            }
            if (this.isSequenceO(vector1)) continue;
            byte0 = (byte)(byte0 + 1);
        }
        return this.reachHouCondition(byte0, byte1);
    }

    private boolean checkHouSTPO(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        byte byte0 = 0;
        byte byte1 = 0;
        while (byte0 == 0 && vector1.size() != 0) {
            if (this.isSequenceO(vector1) || this.isTripleO(vector1)) continue;
            if (this.isPairO(vector1)) {
                byte1 = (byte)(byte1 + 2);
                continue;
            }
            byte0 = (byte)(byte0 + 1);
        }
        return this.reachHouCondition(byte0, byte1);
    }

    private boolean isPairO(Vector vector) {
        Byte byte1 = (Byte)vector.lastElement();
        boolean flag = false;
        if (this.getTileCount(vector, byte1) == 2) {
            flag = true;
            for (int byte0 = 0; byte0 < 2; byte0 = (int)((byte)(byte0 + 1))) {
                vector.removeElement(byte1);
            }
            this.m_vHouSet.addElement(new MeldedSet(12, byte1));
        }
        return flag;
    }

    private boolean isTripleO(Vector vector) {
        Byte byte1 = (Byte)vector.lastElement();
        boolean flag = false;
        if (this.getTileCount(vector, byte1) == 3) {
            flag = true;
            for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
                vector.removeElement(byte1);
            }
            this.m_vHouSet.addElement(new MeldedSet(11, byte1));
        }
        return flag;
    }

    private boolean isSequenceO(Vector vector) {
        Byte byte1 = (Byte)vector.lastElement();
        boolean flag = false;
        if (byte1 <= 30) {
            Byte byte2 = new Byte((byte)(byte1 - 1));
            Byte byte3 = new Byte((byte)(byte1 - 2));
            if (vector.contains(byte2) && vector.contains(byte3)) {
                flag = true;
                vector.removeElement(byte3);
                vector.removeElement(byte2);
                vector.removeElement(byte1);
                this.m_vHouSet.addElement(new MeldedSet(10, byte3));
            }
        }
        return flag;
    }

    private boolean checkHouTPS(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        byte byte0 = 0;
        byte byte1 = 0;
        while (byte0 == 0 && vector1.size() != 0) {
            if (this.isTriple(vector1)) continue;
            if (this.isPair(vector1)) {
                byte1 = (byte)(byte1 + 2);
                continue;
            }
            if (this.isSequence(vector1)) continue;
            byte0 = (byte)(byte0 + 1);
        }
        return this.reachHouCondition(byte0, byte1);
    }

    private boolean checkHouSTP(Vector vector) {
        this.m_vHouSet.removeAllElements();
        Vector vector1 = this.cloneVector(vector);
        byte byte0 = 0;
        byte byte1 = 0;
        while (byte0 == 0 && vector1.size() != 0) {
            if (this.isSequence(vector1) || this.isTriple(vector1)) continue;
            if (this.isPair(vector1)) {
                byte1 = (byte)(byte1 + 2);
                continue;
            }
            byte0 = (byte)(byte0 + 1);
        }
        return this.reachHouCondition(byte0, byte1);
    }

    private boolean reachHouCondition(byte byte0, byte byte1) {
        return byte0 == 0 && (byte1 == 2 || byte1 == 14);
    }

    private boolean isPair(Vector vector) {
        Byte byte1 = (Byte)vector.firstElement();
        boolean flag = false;
        if (this.getTileCount(vector, byte1) == 2) {
            flag = true;
            for (int byte0 = 0; byte0 < 2; byte0 = (int)((byte)(byte0 + 1))) {
                vector.removeElement(byte1);
            }
            this.m_vHouSet.addElement(new MeldedSet(12, byte1));
        }
        return flag;
    }

    private boolean isTriple(Vector vector) {
        Byte byte1 = (Byte)vector.firstElement();
        boolean flag = false;
        if (this.getTileCount(vector, byte1) == 3) {
            flag = true;
            for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
                vector.removeElement(byte1);
            }
            this.m_vHouSet.addElement(new MeldedSet(11, byte1));
        }
        return flag;
    }

    private byte getTileCount(Vector vector, Byte byte1) {
        byte byte0 = 0;
        for (int byte2 = 0; byte2 < vector.size(); byte2 = (int)((byte)(byte2 + 1))) {
            if (((Byte)vector.elementAt(byte2)).byteValue() != byte1.byteValue()) continue;
            byte0 = (byte)(byte0 + 1);
        }
        return byte0;
    }

    private boolean isSequence(Vector vector) {
        Byte byte1 = (Byte)vector.firstElement();
        boolean flag = false;
        if (byte1 <= 30) {
            Byte byte2 = new Byte((byte)(byte1 + 1));
            Byte byte3 = new Byte((byte)(byte1 + 2));
            if (vector.contains(byte2) && vector.contains(byte3)) {
                flag = true;
                vector.removeElement(byte1);
                vector.removeElement(byte2);
                vector.removeElement(byte3);
                this.m_vHouSet.addElement(new MeldedSet(10, byte1));
            }
        }
        return flag;
    }

    private Vector cloneVector(Vector vector) {
        Vector vector1 = new Vector();
        for (int byte0 = 0; byte0 < vector.size(); byte0 = (int)((byte)(byte0 + 1))) {
            vector1.addElement(vector.elementAt(byte0));
        }
        return vector1;
    }

    public void sortInHand() {
        this.sort(this.m_vInHand);
    }

    private void sort(Vector vector) {
        byte[] abyte0 = new byte[vector.size()];
        for (int byte0 = 0; byte0 < abyte0.length; byte0 = (int)((byte)(byte0 + 1))) {
            abyte0[byte0] = (Byte)vector.elementAt(byte0);
        }
        for (int byte1 = 0; byte1 < abyte0.length - 1; byte1 = (int)((byte)(byte1 + 1))) {
            for (byte byte2 = (byte)(byte1 + 1); byte2 < abyte0.length; byte2 = (byte)(byte2 + 1)) {
                if (abyte0[byte1] <= abyte0[byte2]) continue;
                byte byte4 = abyte0[byte1];
                abyte0[byte1] = abyte0[byte2];
                abyte0[byte2] = byte4;
            }
        }
        vector.removeAllElements();
        for (int byte3 = 0; byte3 < abyte0.length; byte3 = (int)((byte)(byte3 + 1))) {
            vector.addElement(new Byte(abyte0[byte3]));
        }
    }

    public void setLastDealtTile(byte byte0) {
        this.m_vInHand.addElement(new Byte(byte0));
    }

    public byte getInHandTile(byte byte0) {
        return (Byte)this.m_vInHand.elementAt(byte0);
    }

    public int getInHandCount() {
        return this.m_vInHand.size();
    }

    public void setDealtTiles(byte[] abyte0) {
        for (int byte0 = 0; byte0 < abyte0.length; byte0 = (int)((byte)(byte0 + 1))) {
            this.m_vInHand.addElement(new Byte(abyte0[byte0]));
        }
    }

    public byte getType() {
        return this.m_btType;
    }
}

