/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class MovingObject {
    public boolean killOnGround = true;
    public boolean isTraversable;
    public boolean hitEnemy;
    public byte type = 0;
    public byte parent_weapon = (byte)-1;
    public int bullet_energy;
    public int bullet_speedX;
    public int bullet_speedY;
    public long bullet_time;
    public long bullet_delay;
    public MovingObject parent;
    public static final byte MO_TYPE_GAME = -1;
    public static final byte MO_TYPE_GENERIC = 0;
    public static final byte MO_TYPE_PLAYER = 1;
    public static final byte MO_TYPE_PARTICLE = 2;
    public static final byte MO_TYPE_BULLET = 3;
    public static final byte MO_TYPE_ARTEFACT = 4;
    public static final byte MO_TYPE_ENEMY = 5;
    public static final byte MO_TYPE_DEBRIS = 6;
    public static final byte MO_TYPE_STATIC = 7;
    public static final byte MO_TYPE_BONUS = 8;
    public static final byte MO_TYPE_SPECIAL_FX = 9;
    public static final byte MO_TYPE_SKIRMISH = 10;
    public static final byte MO_TYPE_WALKER = 11;
    public static final byte MO_TYPE_BOSS = 12;
    public static final byte MO_TYPE_NUMBER = 13;
    public static final byte ARTEFACT_EXPLOSION_RED = 0;
    public static final byte ARTEFACT_EXPLOSION_GREEN = 1;
    public static final byte ARTEFACT_SMOKE = 2;
    public static final byte ARTEFACE_DEBRIS_GREEN = 3;
    public static final byte ARTEFACE_DEBRIS_METAL = 4;
    public static final byte DEBRIS_METAL = 1;
    public static final byte DEBRIS_ALIEN = 2;
    public static final byte DEBRIS_GUN_LEFT = 3;
    public static final byte DEBRIS_GUN_RIGHT = 4;
    public static final byte TEAM_NONE = -1;
    public static final byte TEAM_A = 0;
    public static final byte TEAM_B = 1;
    public static final byte FACING_LEFT = 2;
    public static final byte FACING_RIGHT = 5;
    public static final int BLOCK_0 = 10240;
    public static final int GRAVITY_MAX = -15360;
    public static final int GRAVITY = 1500;
    public static final int DIV_X = 16384;
    public static final int DIV_Y = 16384;
    public static final int smoke_offset = 6144;
    public static final long EGG_ACTIVATION_TIME = 7000L;
    public static final long EGG_ACTIVATION_WARNING = 5000L;
    public static final byte SCORE_BONUS = 50;
    public static final byte SCORE_HIT = 5;
    public static final byte SCORE_STATIC_CRATE = 100;
    public static final short SCORE_STATIC_FREEZER = 250;
    public static final short SCORE_BOT = 500;
    public static final short SCORE_DOM = 200;
    public static final short SCORE_FLAG = 700;
    public static final short SCORE_TOILET = 12000;
    public static final int SCORE_MAITE = 150000;
    public static final byte PLAYER_TYPE_PLAYER = 0;
    public static final byte PLAYER_TYPE_MECH = 1;
    public static final byte PLAYER_TYPE_ENEMY = 2;
    public static final byte PLAYER_TYPE_BOT = 3;
    public static final byte PLAYER_TYPE_BOSS = 4;
    public static final byte WEAPON_TYPE_SINGLE = 0;
    public static final byte WEAPON_TYPE_MACHINEGUN = 1;
    public static final byte WEAPON_TYPE_LASER = 2;
    public static final byte WEAPON_TYPE_FLAMETHROWER = 3;
    public static final byte WEAPON_TYPE_GRENADE = 4;
    public static final byte WEAPON_TYPE_ROCKET = 5;
    public static final byte WEAPON_TYPE_CANNONBALL = 6;
    public static final byte WEAPON_TYPE_MINE = 7;
    public static final byte WEAPON_TYPE_ENEMY_FIRST = 8;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_LOW_SHORT_LONG = 8;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_LOW_SHORT_SMALL = 9;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_LOW_LONG_LONG = 10;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_LOW_LONG_SMALL = 11;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_MED_SHORT_LONG = 12;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_MED_SHORT_SMALL = 13;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_MED_LONG_LONG = 14;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_MED_LONG_SMALL = 15;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_HIGH_LONG_LONG = 16;
    public static final byte WEAPON_TYPE_ENEMY_SINGLE_HIGH_LONG_SMALL = 17;
    public static final byte WEAPON_TYPE_ENEMY_LAST = 17;
    public static final byte WEAPON_TYPE_ENEMY_GRENADE = 18;
    public static final byte WEAPON_TYPE_SATELLITE = 19;
    public static final long SHAKE_DELAY = 25L;
    public static final byte[] static_remap = new byte[]{21, 25, 34, 1, 59};
    public static final byte FRAME_WALK_LEFT = 0;
    public static final byte FRAME_WALK_RIGHT = 1;
    public static final byte FRAME_IDLE_LEFT = 2;
    public static final byte FRAME_IDLE_RIGHT = 3;
    public static final byte FRAME_LAND_LEFT = 4;
    public static final byte FRAME_LAND_RIGHT = 5;
    public static final byte FRAME_AIR_UP_LEFT = 6;
    public static final byte FRAME_AIR_DOWN_LEFT = 7;
    public static final byte FRAME_AIR_UP_RIGHT = 8;
    public static final byte FRAME_AIR_DOWN_RIGHT = 9;
    public static final byte FRAME_HIT_LEFT = 10;
    public static final byte FRAME_HIT_RIGHT = 11;
    public static final byte FRAME_AMOUNT = 12;
    public static final byte GFX_CRATE = 0;
    public static final byte GFX_EGG = 1;
    public static final byte GFX_EGG_DEAD = 2;
    public static final byte GFX_FREEZER = 3;
    public static final byte GFX_EXPLOSION_RED = 4;
    public static final byte GFX_EXPLOSION_GREEN_L = 5;
    public static final byte GFX_EXPLOSION_GREEN_R = 6;
    public static final byte GFX_SMOKE = 7;
    public static final byte GFX_FLYING = 8;
    public static final byte GFX_LIGHTUNIT = 9;
    public static final byte GFX_HEAVYUNIT = 10;
    public static final byte GFX_ROLLING_HIT_LEFT = 11;
    public static final byte GFX_ROLLING_HIT_RIGHT = 12;
    public static final byte GFX_ROLLING_UP_LEFT = 13;
    public static final byte GFX_ROLLING_UP_RIGHT = 14;
    public static final byte GFX_ROLLING_DOWN_LEFT = 15;
    public static final byte GFX_ROLLING_DOWN_RIGHT = 16;
    public static final byte GFX_ROLLING_FIRE_LEFT = 17;
    public static final byte GFX_ROLLING_FIRE_RIGHT = 18;
    public static final byte GFX_ROLLING_ROL_LEFT = 19;
    public static final byte GFX_ROLLING_ROL_RIGHT = 20;
    public static final byte GFX_BULLET_ENEMY1 = 21;
    public static final byte GFX_BULLET_ENEMYGRENADE = 22;
    public static final byte GFX_BULLET_MACHINEGUN = 23;
    public static final byte GFX_BULLET_SINGLE = 24;
    public static final byte GFX_BULLET_LASER = 25;
    public static final byte GFX_BULLET_FLAME = 26;
    public static final byte GFX_BULLET_GRENADE = 27;
    public static final byte GFX_BULLET_EXPLODEFRAME = 28;
    public static final byte GFX_BULLET_ROCKET = 29;
    public static final byte GFX_BULLET_CANNONBALL = 30;
    public static final byte GFX_WALKER = 31;
    public static final byte GFX_PLAYER = 32;
    public static final byte GFX_AMOUNT = 33;
    public static final byte BULLET_TYPE_MACHINE_GUN = 0;
    public static final byte BULLET_TYPE_PLAYER_SINGLE = 1;
    public static final byte BULLET_TYPE_LASER = 2;
    public static final byte BULLET_TYPE_FLAME = 3;
    public static final byte BULLET_TYPE_GRENADE = 4;
    public static final byte BULLET_TYPE_EXPLODEFLAME = 5;
    public static final byte BULLET_TYPE_EXPLODEFLAME_HURT = 6;
    public static final byte BULLET_TYPE_ROCKET = 7;
    public static final byte BULLET_TYPE_CANNONBALL = 8;
    public static final byte BULLET_TYPE_ENEMY = 9;
    public static final byte BULLET_TYPE_ENEMY_LOW_SHORT = 9;
    public static final byte BULLET_TYPE_ENEMY_LOW_LONG = 10;
    public static final byte BULLET_TYPE_ENEMY_MED_SHORT = 11;
    public static final byte BULLET_TYPE_ENEMY_MED_LONG = 12;
    public static final byte BULLET_TYPE_ENEMY_HIGH_LONG = 13;
    public static final byte BULLET_TYPE_ENEMY_GRENADE = 14;
    public static final byte BULLET_TYPE_ENEMY_SATELLITE = 15;
    public static byte[] lut_bullets;
    public static final byte SPECIAL_MODE_NONE = 0;
    public static final byte SPECIAL_MODE_QUADDAMAGE = 1;
    public static final byte SPECIAL_MODE_INVINCIBILITY = 2;
    public static final byte SPECIAL_FRAMES_CNT = 7;
    public static final byte SPECIAL_FRAMES_MAXRADIUS = 20;
    public static final byte SPECIAL_FRAMES_ANGLE_OFFSET = 10;
    public static final short SPECIAL_TIME_INVINCIBILITY = 5000;
    public static final short SPECIAL_TIME_QUAD = 10000;
    public static final int[] bulletsFired;
    public static final int[] bulletsHits;
    public static final int[] GbulletsFired;
    public static final int[] GbulletsHits;
    public static int map_test_x_min;
    public static int map_test_y_min;
    public static int map_test_x_max;
    public static int map_test_y_max;
    public static int MAX_X;
    public static int MAX_Y;
    public static int collision_dist;
    public static int particles_counter;
    public static int artefact_counter;
    public static byte[] remapBonuses;
    public static byte[] remapWeaponToBonus;
    public static byte[] a_list;
    public static byte[][] map;
    public static byte[][][] allFrames;
    public static boolean[] b_list;
    public static boolean[] np_list;
    public static byte[] groundCells;
    public static short[][] scores_for_enemies;
    public static int[][] collision_map;
    public static int[] cos;
    public static MovingObject walker_arrow;
    public static InGame game;
    public static Random rand;
    public boolean isGravityApplicable = true;
    public boolean airing_cycleFrames = true;
    public boolean isHittable = true;
    public boolean isFixed;
    public boolean isOnGround;
    public boolean isMoving;
    public boolean isAnimated;
    public boolean isAiring;
    public boolean isHit;
    public boolean hitHorizontaly;
    public boolean hitBottom;
    public boolean createSmoke;
    public boolean getNodes;
    public boolean mustRecalculateLevelNode = true;
    public boolean egg_isActivated;
    public boolean egg_cannotCreateEnemy;
    public byte mo_type = 0;
    public byte artefact_type;
    public byte facing = (byte)5;
    public byte curFrame;
    public byte static_frame;
    public byte TEAM = 0;
    public byte hit_facing;
    public byte frame;
    public byte anim_offs_y;
    public byte anim_offs_y_dir_skirmish_index = 1;
    public int posX;
    public int posY;
    public int col_oldPosX;
    public int col_oldPosY;
    public int speedX;
    public int speedY;
    public int col_orgSpeedX;
    public int col_orgSpeedY;
    public int width;
    public int height;
    public int width2;
    public int col_sX;
    public int col_sY;
    public int col_eX;
    public int col_eY;
    public int color_part_sR;
    public int color_part_sG;
    public int color_part_sB;
    public int color_fadeR;
    public int color_fadeG;
    public int color_fadeB;
    public int maxLife = 255;
    public int life = 255;
    public int life_adder = -5;
    public int addOffsetY;
    public int GRAVITY_USED = 1500;
    public int col_colX;
    public int col_colY;
    public long OObjectTime;
    public long last_hitTime;
    public long hitDelay = 600L;
    public long lastAnimeTime;
    public long anime_delay = 70L;
    public long egg_activation_time;
    public long egg_lastBlinkTime;
    public int[][] head_offsets;
    public byte[] map_head;
    public byte[] cur_frm;
    public byte[][] myFrames;
    public DeviceImage[] frm_body;
    public DeviceImage[] frm_head;
    public OObject container;
    public OObject levelNode;
    public OObject staticCreator;
    public static short[] players_characteristics;
    public static byte[] bots_behaviours;
    public static long totalScore;
    public static long totalPlayingTime;
    public static long playerScore;
    public static byte[] enemy_explosion_colors;
    public static final byte ENEMY_FLYINGALIEN = 0;
    public static final byte ENEMY_FLYINGROBOT = 1;
    public static final byte ENEMY_LIGHTUNIT = 2;
    public static final byte ENEMY_HEAVYUNIT = 3;
    public static final byte ENEMY_ROLLING = 4;
    public static final byte ENEMY_STATIONARY = 5;
    public static final byte ENEMY_SATELLITE = 6;
    public static final byte ENEMY_BOSS_TOILET = 7;
    public static final byte ENEMY_BOSS_MAITE = 8;
    public static final byte ENEMY_BOSS_HAND = 9;
    public static byte[] enemy_lut_sizes;
    public static final byte TOILET_PATTERN_ATTACK = 2;
    public static final byte TOILET_PATTERN_PREPARE = 1;
    public static final byte TOILET_PATTERN_STAY = 0;
    public static final byte PATTERN_FALL = -1;
    public static final byte MAITE_NORMAL = 0;
    public static final byte MAITE_ATTACK = 1;
    public static final byte MAITE_ANGRY = 2;
    public static final byte MAITE_RANDOM_MOVE = 0;
    public static final byte MAITE_HPREPARE = 1;
    public static final byte MAITE_HPREPARE_2 = 2;
    public static final byte MAITE_HATTACK = 3;
    public static final byte MAITE_HRETREAT = 4;
    public static final short SATELLITE_CLOSE_RANGE = 10000;
    public static final short SATELLITE_CLOSE_XRANGE = 26000;
    public static final int SATELLITE_MIN_DY = 32768;
    public static final short SATELLITE_ACCEL_X = 150;
    public static final short SATELLITE_ACCEL_Y = 100;
    public static final short SATELLITE_MAX_SPEED_X = 2048;
    public static final short SATELLITE_MAX_SPEED_Y = 1024;
    public static int s_deaths;
    public static int s_kills;
    public static int s_hitPointsLost;
    public static int s_hitPointsTaken;
    public static int s_frag_a;
    public static int s_frag_b;
    public static int s_flag_a;
    public static int s_flag_b;
    public static final byte BULLET_TIME_MIN_VALUE_TO_ACTIVATE = 100;
    public static final int BOT_MIN_DISTANCE_TO_FIRE = 133120;
    public static final int BOT_MIN_DISTANCE_TO_CHANGE = 512000;
    public static final int BOT_MIN_DISTAMCE_CLOSE = 5120;
    public static final int BOT_MIN_DISTAMCE_FIRE_MIN = 20480;
    public static short[] HAND_DELAYS;
    public static int[] MAITE_MAX_DURATIONS;
    public static int[] MAITE_MIN_DURATIONS;
    public static short[] stationary_delays;
    public static byte[] bonusFrame_to_weapon;
    public static final int GFX_WEAPON_X = 3;
    public static final int GFX_WEAPON_Y = 3;
    public static final int GFX_HEALTH_X = 3;
    public static final int GFX_HEALTH_Y = 24;
    public static final int GFX_HEALTH_Y2 = 31;
    public static final short GFX_HEALTH_COLOR_BOSS_R = 0;
    public static final short GFX_HEALTH_COLOR_BOSS_G = 0;
    public static final short GFX_HEALTH_COLOR_BOSS_B = 255;
    public static final short GFX_HEALTH_COLOR_DEAD_R = 255;
    public static final short GFX_HEALTH_COLOR_DEAD_G = 0;
    public static final short GFX_HEALTH_COLOR_DEAD_B = 0;
    public static int newIndex;
    public static final byte LIFE_POS_Y = 3;
    public static final byte LIFE_POS_X_END = 15;
    public static byte[] weapon_gfx;
    public static final byte WEAPON_STATUS_IDLE = 0;
    public static final byte WEAPON_STATUS_PRE = 1;
    public static final byte WEAPON_STATUS_FIRE = 2;
    public static final byte WEAPON_STATUS_POST = 3;
    public static byte[][] lut_frames;
    public static byte[] lut_a;
    public static long[] lut_delays;
    public static boolean[] lut_params;
    public static int AIR_STEP_X;
    public static final int AMMO_UNLIMITED = -1;
    public static byte[] player_map_head;
    public static int[][] player_head_offsets_1;
    public static int[][] player_head_offsets_3;
    public static int[][] player_head_offsets_11;
    public static int[][] player_head_offsets_33;
    public static int[] walker_offsets;
    public static byte[] player_map_head2;
    public static byte[] player_frm_die_l2;
    public static byte[] player_frm_die_r2;
    public static byte[] player_frm_die_l;
    public static byte[] player_frm_die_r;
    public static byte[] enemy_anchor;
    public static int[] BG_COLOR;
    public static int[] BG_OFFSETS;
    public static byte[] BG_ADDER;
    public static byte[] SATELLITE_SHOT;
    public static byte[] flamet_fire_l;
    public static byte[] flamet_fire_r;
    public static byte[] flamet_idle_l;
    public static byte[] flamet_idle_r;
    public static byte[] flying_frames;
    public static byte[] b_enemy_energy;
    public static byte[] b_enemy_speed;
    public static byte[] b_enemy_adder;
    public static long ROCKET_TIME;
    public int BOT_TEAMATE_MIN_DISTANCE = 60000;
    public static byte[][][] ai_transitions;
    public static short[][][] ai_commands;
    public static byte[] pre_enemy_createSmokeShadow;
    public static byte[][][] pre_enemy_byteChars;
    public static short[][][] pre_enemy_shortChars;

    public void initFrames(byte by) {
        this.myFrames = allFrames[by];
        this.curFrame = 0;
        this.cur_frm = this.myFrames[0];
    }

    public MovingObject(int n, int n2, int n3, int n4, byte by, byte by2) {
        this.init((byte)8, n, n2, DeviceImage.sprites[71][0].width, DeviceImage.sprites[71][0].height, false);
        this.isAnimated = false;
        this.speedX = n3 << 10;
        this.speedY = n4 << 10;
        this.frame = by;
        this.static_frame = by = remapBonuses[by];
        this.curFrame = 0;
        this.createSmoke = true;
        this.frm_body = DeviceImage.sprites[71];
        this.life = -1;
        this.container = MovingObject.game.bonuses;
        this.TEAM = 1;
        this.container.addElementBefore(this, null);
        this.anim_offs_y = by2;
        this.getNodes = true;
    }

    public MovingObject() {
    }

    public static final int rand(int n) {
        return MovingObject.rand() % n;
    }

    public static final int randAbs(int n) {
        return MovingObject.abs(MovingObject.rand()) % n;
    }

    public static final int rand() {
        return rand.nextInt();
    }

    public static final void createNumber(int n, int n2, int n3, int n4) {
        MovingObject movingObject = new MovingObject();
        movingObject.init((byte)13, n >> 10, n2 >> 10, 0, 0, true);
        movingObject.life_adder = n4;
        movingObject.isGravityApplicable = false;
        movingObject.isHittable = false;
        movingObject.isAnimated = false;
        movingObject.anime_delay = n3;
        movingObject.container = MovingObject.game.particles;
        movingObject.container.addElementBefore(movingObject, null);
        movingObject.speedY = 1024;
    }

    public MovingObject(OObject oObject, byte by, short s) {
        this.frame = by;
        this.staticCreator = oObject;
        this.isAnimated = true;
        this.anime_delay = 150L;
        this.hitDelay = 200L;
        this.frm_body = DeviceImage.sprites[static_remap[by]];
        this.container = MovingObject.game.staticObjects;
        boolean bl = false;
        switch (by) {
            case 0: {
                this.initFrames((byte)0);
                this.createSmoke = true;
                s = (short)38;
                break;
            }
            case 1: {
                this.initFrames((byte)1);
                s = (short)114;
                break;
            }
            case 2: {
                this.initFrames((byte)3);
                s = (short)95;
                break;
            }
            case 3: {
                this.isHittable = false;
                bl = true;
                this.isAnimated = false;
                this.isGravityApplicable = false;
                this.static_frame = 0;
                break;
            }
            case 4: {
                this.container = MovingObject.game.particles;
                this.isHittable = false;
                bl = true;
                this.isAnimated = false;
                this.isGravityApplicable = false;
                this.static_frame = 0;
                this.GRAVITY_USED = 0;
            }
        }
        short s2 = s;
        this.maxLife = s2;
        this.life = s2;
        this.TEAM = 1;
        this.container.addElementBefore(this, null);
        this.init((byte)7, oObject.posX >> 10, oObject.posY >> 10, this.frm_body[0].width, this.frm_body[0].height, bl);
        if (by == 4) {
            this.posX = MovingObject.game.camera_left - this.width;
            this.posY = MovingObject.game.mapHeight << 10;
            if (this.posX < 0) {
                this.posX = 0;
            }
        }
    }

    public static final void initForGame(InGame inGame) {
        game = inGame;
        MAX_X = map_test_x_max = inGame.mapWidth << 10;
        MAX_Y = map_test_y_max = inGame.mapHeight << 10;
        map_test_y_min = 0;
        map_test_x_min = 0;
        map = inGame.currentMap;
        b_list = inGame.tiles_isBlockable;
        a_list = inGame.tiles_angle;
        np_list = inGame.tiles_isNonPassable;
        artefact_counter = 0;
        if (collision_dist != 10240) {
            int n;
            collision_dist = 10240;
            int n2 = 16;
            int n3 = 16;
            collision_map = new int[7][n2];
            int n4 = n3 * 512 / n2;
            for (n = 0; n < 2 * n2; ++n) {
                int n5 = n4 * n + 10240;
                if (n < n2) {
                    MovingObject.collision_map[0][n] = 10240;
                    MovingObject.collision_map[1][n] = n5;
                    MovingObject.collision_map[2][n] = 1024 + n5 - (n3 << 10);
                    continue;
                }
                MovingObject.collision_map[3][n - n2] = n5 - (n3 << 10);
            }
            for (n = 0; n < n2; ++n) {
                MovingObject.collision_map[4][n] = collision_map[1][15 - n];
                MovingObject.collision_map[5][n] = collision_map[2][15 - n];
                MovingObject.collision_map[6][n] = collision_map[3][15 - n];
            }
        }
    }

    public void init(byte by, int n, int n2, int n3, int n4, boolean bl) {
        this.mo_type = by;
        this.posX = this.col_oldPosX = n << 10;
        this.posY = this.col_oldPosY = n2 << 10;
        this.width = n3 << 10;
        this.height = n4 << 10;
        this.width2 = this.width >> 1;
        this.isFixed = bl;
    }

    public void move(int n, int n2, OObject oObject) {
        if (MovingObject.game.bullettime_nonAffectedTeam != -1 && this.TEAM != MovingObject.game.bullettime_nonAffectedTeam) {
            n /= 3;
            n2 /= 3;
        }
        this.col_orgSpeedX = this.speedX;
        this.col_orgSpeedY = this.speedY;
        this.col_oldPosX = this.posX;
        this.col_oldPosY = this.posY;
        this.speedX = n;
        this.speedY = n2;
        this.posX += this.speedX;
        this.posY += this.speedY;
        if (!this.isFixed) {
            byte by;
            int n3;
            int n4;
            int n5;
            int n6 = this.col_oldPosX + this.width2;
            int n7 = this.col_oldPosY;
            int n8 = this.posX + this.width2;
            int n9 = this.speedX;
            int n10 = this.speedY;
            int n11 = 0;
            int n12 = MAX_X;
            if (this.TEAM == 0 && this.mo_type == 1) {
                n11 = map_test_x_min;
                n12 = map_test_x_max;
            }
            if ((n5 = n8 - this.width2 - n11) < 0) {
                n8 -= n5;
                n9 -= n5;
                this.hitHorizontaly = true;
            }
            if ((n5 = n12 - (n8 + this.width2)) < 0) {
                n8 += n5;
                n9 += n5;
                this.hitHorizontaly = true;
            }
            if (n10 > 0) {
                this.isOnGround = false;
            } else if (this.isOnGround) {
                n10 *= 2;
            }
            int n13 = n6;
            int n14 = n7;
            int n15 = MAX_Y;
            int n16 = 8192;
            int n17 = n9 / n16 + 2;
            int n18 = n10 / n16 + 2;
            int n19 = n17;
            if (n18 > n19) {
                n19 = n18;
            }
            int n20 = n9 / n19;
            int n21 = n10 / n19;
            if (n20 != 0) {
                n4 = (n13 + n20) / 16384;
                n3 = n14 / 16384;
                if (n14 < n15 && (by = map[n4][n3]) != -1 && np_list[by]) {
                    n20 = 0;
                    this.hitBottom = true;
                }
            }
            int n22 = n7;
            boolean bl = false;
            boolean bl2 = true;
            if (this.mo_type == 3 && this.type == 3) {
                bl2 = false;
            }
            if (n10 <= 0) {
                for (int i = 0; i < n19 && !bl; ++i) {
                    int n23;
                    byte by2;
                    n4 = (n13 += n20) / 16384;
                    n3 = (n14 += n21) / 16384;
                    int n24 = n4 * 16384;
                    int n25 = n3 * 16384;
                    int n26 = n13 - n24 >> 10;
                    int n27 = n14 - n25;
                    if (n14 >= n15) continue;
                    by = map[n4][n3];
                    byte by3 = groundCells[n4];
                    if (n3 == by3) {
                        by2 = a_list[by];
                        n23 = collision_map[by2][n26];
                        if (n27 > n23 || n10 > 0) continue;
                        n14 = n23 + n25;
                        this.isOnGround = true;
                        if (bl2) continue;
                        bl = true;
                        continue;
                    }
                    if (by != -1) {
                        if (b_list[by] && n10 <= 0) {
                            by2 = a_list[by];
                            n23 = collision_map[by2][n26];
                            if (n27 <= n23 && n10 <= 0 && n22 >= n25 + n23) {
                                n14 = n23 + n25;
                                this.isOnGround = true;
                                if (!bl2) {
                                    bl = true;
                                }
                            }
                        } else {
                            this.isOnGround = false;
                        }
                        if (np_list[by]) {
                            n13 -= n20;
                            n14 -= n21;
                            n20 = 0;
                            this.hitBottom = true;
                            if (!bl2) {
                                bl = true;
                                continue;
                            }
                            n20 = 0;
                            --n19;
                            continue;
                        }
                        if (n3 >= by3) continue;
                        by = map[n4][by3];
                        n14 = collision_map[a_list[by]][n26] + by3 * 16384;
                        this.isOnGround = true;
                        if (bl2) continue;
                        bl = true;
                        continue;
                    }
                    this.isOnGround = false;
                }
            } else {
                for (int i = 0; i < n19 && !bl; ++i) {
                    n4 = (n13 += n20) / 16384;
                    n3 = (n14 += n21) / 16384;
                    if (n14 >= n15 || (by = map[n4][n3]) == -1 || !np_list[by]) continue;
                    n13 -= n20;
                    n14 -= n21;
                    n20 = 0;
                    this.hitBottom = true;
                    if (!bl2) {
                        bl = true;
                        continue;
                    }
                    n20 = 0;
                    --n19;
                }
            }
            n9 = n13 - n6;
            n10 = n14 - n7;
            this.speedX = n9;
            this.speedY = n10;
            this.posX = this.col_oldPosX + n9;
            this.posY = this.col_oldPosY + n10;
            if (this.isHittable) {
                this.col_check_and_move(oObject);
            }
        }
        if (this.mo_type == 12 && this.isHittable && ((Agent)this).agent_type == 9) {
            this.col_check_and_move(oObject);
        }
    }

    public final void col_check_and_move(OObject oObject) {
        MovingObject movingObject;
        OObject oObject2 = new OObject();
        if (oObject == null) {
            return;
        }
        OObject oObject3 = oObject.next;
        this.col_precalcBoundingBox(true);
        this.col_colX = MovingObject.abs(this.speedX);
        this.col_colY = MovingObject.abs(this.speedY);
        boolean bl = false;
        while (oObject3 != null) {
            movingObject = (MovingObject)oObject3.data;
            oObject3 = oObject3.next;
            if (!movingObject.isHittable || movingObject == this || !movingObject.col_hasCollidedWithObject(this)) continue;
            bl = movingObject.col_testMove(this);
            if (bl) {
                oObject2.removeAll();
            }
            oObject2.addElementBefore(movingObject, null);
            this.col_precalcBoundingBox(true);
        }
        oObject3 = oObject2.next;
        if (oObject3 != null) {
            movingObject = (MovingObject)oObject3.data;
            while (oObject3 != null) {
                movingObject = (MovingObject)oObject3.data;
                if (movingObject.col_hasCollidedWithObject(this)) {
                    this.col_feedback(movingObject);
                }
                oObject3 = oObject3.next;
            }
        }
    }

    public void col_feedback(MovingObject movingObject) {
        if (this.mo_type == 3) {
            if (this.bullet_energy == 0) {
                return;
            }
            if ((movingObject.mo_type == 1 || movingObject.mo_type == 5 || movingObject.mo_type == 7 || movingObject.mo_type == 12) && movingObject != this.parent) {
                if (this.TEAM != movingObject.TEAM) {
                    Agent agent;
                    if (!this.hitEnemy && this.parent_weapon != -1) {
                        this.hitEnemy = true;
                        byte by = this.parent_weapon;
                        bulletsHits[by] = bulletsHits[by] + 1;
                        playerScore += 5L;
                    }
                    if (movingObject.mo_type == 5 || movingObject.mo_type == 12) {
                        agent = (Agent)movingObject;
                        if (agent.agent_type == 4) {
                            if (agent.special_mode == 3 || agent.special_mode == 5) {
                                agent.addLife(-this.bullet_energy, true, this);
                            } else {
                                agent.addLife(-this.bullet_energy / 2, false, this);
                            }
                        } else {
                            agent.addLife(-this.bullet_energy, true, this);
                        }
                    } else if (movingObject.mo_type == 1) {
                        agent = (Agent)movingObject;
                        if ((agent.type != 3 || InGame.LEVEL_MODE == 1 || movingObject.TEAM != MovingObject.game.localPlayer.TEAM) && agent.specialMode != 2) {
                            if (agent.useWalker) {
                                agent.walker_object.addLife(-this.bullet_energy, false, this);
                            } else {
                                movingObject.addLife(-this.bullet_energy, true, this);
                            }
                            if (agent.life == 0 && this.parent != null && this.parent.mo_type == 1) {
                                game.addFragFor(this.parent);
                            }
                        }
                    } else {
                        movingObject.addLife(-this.bullet_energy, true, this);
                    }
                    movingObject.hit_facing = (byte)(this.speedX < 0 ? 2 : 5);
                    if (this.parent != null && this.type != 5 && this.type != 6) {
                        int n = 2;
                        if (this.isTraversable) {
                            n = 1;
                        }
                        if (this.parent.TEAM == 0) {
                            MovingObject.game.bullet_time_a = (short)(MovingObject.game.bullet_time_a + n);
                        } else if (this.parent.TEAM == 1) {
                            MovingObject.game.bullet_time_b = (short)(MovingObject.game.bullet_time_b + n);
                        }
                    }
                }
                if (!this.isTraversable) {
                    this.askToKill();
                } else {
                    switch (this.type) {
                        case 3: {
                            MovingObject.createPart(game, this.posX, this.posY, 60, 60, 255, 255, 0, 129, 129, 129, 30);
                        }
                    }
                }
            }
        } else if (this.mo_type == 10) {
            if (this.frame == 3 && movingObject.mo_type == 1) {
                Agent agent = (Agent)movingObject;
                if (this == MovingObject.game.skirmish_flag_moving_b) {
                    MovingObject.game.skirmish_flag_moving_b = null;
                    this.askToKill();
                    if (agent.TEAM == 0) {
                        agent.bot_gotFlag = true;
                        MovingObject.createArtfact(game, (byte)2, this.posX, this.posY + this.height, 0, 1024, 0, 0, 255);
                    } else {
                        MovingObject.game.skirmish_flag_b.life = -1;
                    }
                } else {
                    MovingObject.game.skirmish_flag_moving_a = null;
                    this.askToKill();
                    if (agent.TEAM == 1) {
                        agent.bot_gotFlag = true;
                    } else {
                        MovingObject.game.skirmish_flag_a.life = -1;
                    }
                }
            } else if (this.frame == 2) {
                if (this.life == -1 && movingObject.mo_type == 1) {
                    Agent agent = (Agent)movingObject;
                    if (movingObject.TEAM == 0) {
                        if (this == MovingObject.game.skirmish_flag_b) {
                            this.life = -2;
                            agent.bot_gotFlag = true;
                            for (int i = 0; i < 5; ++i) {
                                MovingObject.createArtfact(game, (byte)2, this.posX, this.posY + this.height, 0, 1024, 5, 5, 255);
                            }
                        } else if (agent.bot_gotFlag) {
                            Agent.updateHud = true;
                            agent.bot_gotFlag = false;
                            ++MovingObject.game.skirmish_flag_cnt_a;
                            Agent.updateHud = true;
                            MovingObject.game.skirm_fragTeam = agent.TEAM;
                            MovingObject.game.skirn_fragTeamTime = InGame.playingTime;
                            MovingObject.game.skirmish_flag_b.life = -1;
                            if (agent == MovingObject.game.localPlayer) {
                                playerScore += 700L;
                            }
                        }
                    } else if (this == MovingObject.game.skirmish_flag_a) {
                        this.life = -2;
                        agent.bot_gotFlag = true;
                        for (int i = 0; i < 5; ++i) {
                            MovingObject.createArtfact(game, (byte)2, this.posX, this.posY + this.height, 0, 1024, 5, 5, 255);
                        }
                    } else if (agent.bot_gotFlag) {
                        agent.bot_gotFlag = false;
                        Agent.updateHud = true;
                        ++MovingObject.game.skirmish_flag_cnt_b;
                        MovingObject.game.skirm_fragTeam = agent.TEAM;
                        MovingObject.game.skirn_fragTeamTime = InGame.playingTime;
                        MovingObject.game.skirmish_flag_a.life = -1;
                    }
                }
            } else if (this.frame == 1 && movingObject.mo_type == 1) {
                this.lastAnimeTime = this.OObjectTime;
                byte by = MovingObject.game.skirmish_ctrls_assignedTeams[this.anim_offs_y_dir_skirmish_index];
                if (by != movingObject.TEAM || by == -1) {
                    if (movingObject.TEAM == 0) {
                        short[] sArray = MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index];
                        sArray[0] = (short)(sArray[0] - 50);
                        if (MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][0] <= 0 && movingObject == MovingObject.game.localPlayer) {
                            playerScore += 200L;
                        }
                    } else {
                        short[] sArray = MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index];
                        sArray[1] = (short)(sArray[1] - 50);
                    }
                } else if (by == 0) {
                    MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][0] = 0;
                    MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][1] = 1000;
                } else {
                    MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][0] = 1000;
                    MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][1] = 0;
                }
            }
        } else if (this.mo_type == 7) {
            if (movingObject.mo_type == 3 && this.frame != 4) {
                movingObject.col_feedback(this);
            }
        } else if (this.mo_type == 8) {
            if (this.isOnGround) {
                Agent agent = (Agent)movingObject;
                if (!(agent.useWalker || this.static_frame == 5 && agent.life == agent.maxLife && agent.type != 3)) {
                    int n = this.anim_offs_y;
                    if (n < 0) {
                        n += 256;
                    }
                    agent.bot_assigned_bonus = null;
                    if (agent == MovingObject.game.localPlayer) {
                        playerScore += 50L;
                    }
                    if (this.static_frame >= 5) {
                        switch (this.static_frame) {
                            case 7: {
                                agent.sm_set((byte)1);
                                break;
                            }
                            case 6: {
                                agent.sm_set((byte)2);
                                break;
                            }
                            case 9: {
                                ++agent.lives;
                                if (agent != MovingObject.game.localPlayer) break;
                                GameStage.PLAYER_LIVES = (byte)(GameStage.PLAYER_LIVES + 1);
                                break;
                            }
                            case 5: {
                                agent.life = agent.maxLife;
                                break;
                            }
                            case 8: {
                                if (agent.TEAM == 0) {
                                    MovingObject.game.bullet_time_a = (short)255;
                                    break;
                                }
                                if (agent.TEAM != 1) break;
                                MovingObject.game.bullet_time_b = (short)255;
                            }
                        }
                    } else {
                        agent.newWeapon(bonusFrame_to_weapon[this.static_frame], n);
                    }
                    this.askToKill();
                    this.life = -2;
                }
            }
        } else if (this.mo_type == 11) {
            if ((movingObject != MovingObject.game.localPlayer && InGame.LEVEL_MODE == 1 || movingObject == MovingObject.game.localPlayer && (DeviceUtils.inputBuffer & 4) != 0) && movingObject.mo_type == 1 && !this.egg_cannotCreateEnemy) {
                DeviceUtils.inputBuffer = 0;
                Agent agent = (Agent)movingObject;
                if (agent.useWalker) {
                    return;
                }
                agent.walker_init();
                agent.walker_object = this;
                if (walker_arrow != null) {
                    walker_arrow.askToKill();
                    walker_arrow = null;
                }
                this.frame = (byte)2;
            }
        } else if (this.mo_type == 12) {
            Agent agent = (Agent)this;
            if (agent.boss_pattern == 3 && agent.boss_fires_remaining > 0 && this.posY > 10000) {
                agent.boss_fires_remaining = 0;
                Agent agent2 = (Agent)movingObject;
                if (agent2.specialMode != 2) {
                    agent2.addLife(-50, true, this);
                }
                if (agent2.life > 0) {
                    agent2.speedX = 2 * this.speedX;
                    agent2.speedY = -2 * this.speedY;
                    agent2.agent_behaviour = (byte)3;
                    agent2.isOnGround = false;
                    MovingObject.createArtfact(game, (byte)0, this.posX, this.posY, 0, 0, 3, 3, 255, false);
                    MovingObject.createArtfact(game, (byte)0, this.posX, this.posY, 0, 0, 3, 3, 255, false);
                    MovingObject.createArtfact(game, (byte)0, this.posX, this.posY, 0, 0, 3, 3, 255, false);
                }
            }
        }
    }

    public boolean col_testMove(MovingObject movingObject) {
        int n = movingObject.posX;
        int n2 = movingObject.posY;
        int n3 = movingObject.col_oldPosX;
        int n4 = movingObject.col_oldPosY;
        int n5 = movingObject.posX;
        int n6 = movingObject.posY;
        int n7 = n5 - n3;
        int n8 = n6 - n4;
        if (n7 > 0) {
            n3 += movingObject.width;
            n5 += movingObject.width;
        }
        int n9 = n3 / 16384;
        int n10 = n5 / 16384;
        int n11 = n4 / 16384;
        int n12 = n6 / 16384;
        int n13 = n9 - n10;
        int n14 = n11 - n12;
        n13 = MovingObject.abs(n13) + 1;
        int n15 = n14 = MovingObject.abs(n14) + 1;
        if (n13 > n14) {
            n15 = n13;
        }
        int n16 = (n5 - n3) / n15;
        int n17 = (n6 - n4) / n15;
        int n18 = n3;
        int n19 = n4;
        boolean bl = false;
        for (int i = 0; i <= n15 && !bl; ++i) {
            movingObject.posX = n18 += n16;
            movingObject.posY = n19 += n17;
            movingObject.col_precalcBoundingBox(false);
            if (!this.col_hasCollidedWithObject(movingObject)) continue;
            bl = true;
        }
        movingObject.posX = n;
        movingObject.posY = n2;
        n7 = n18 - n3 - n16;
        n8 = n19 - n4 - n17;
        n7 = MovingObject.abs(n7);
        n8 = MovingObject.abs(n8);
        if (n7 < movingObject.col_colX || n8 < movingObject.col_colY) {
            movingObject.col_colX = n7;
            movingObject.col_colY = n8;
            return true;
        }
        return false;
    }

    public void col_precalcBoundingBox(boolean bl) {
        if (bl) {
            if (this.col_oldPosX > this.posX) {
                this.col_sX = this.posX;
                this.col_eX = this.col_oldPosX + this.width;
            } else {
                this.col_sX = this.col_oldPosX;
                this.col_eX = this.posX + this.width;
            }
            if (this.col_oldPosY > this.posY) {
                this.col_sY = this.posY;
                this.col_eY = this.col_oldPosY + this.height;
            } else {
                this.col_sY = this.col_oldPosY;
                this.col_eY = this.posY + this.height;
            }
        } else {
            this.col_sX = this.posX;
            this.col_eX = this.posX + this.width;
            this.col_sY = this.posY;
            this.col_eY = this.posY + this.height;
        }
    }

    public boolean col_hasCollidedWithObject(MovingObject movingObject) {
        return movingObject.col_sX < this.posX + this.width && movingObject.col_eX > this.posX && movingObject.col_sY < this.posY + this.height && movingObject.col_eY > this.posY;
    }

    public static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public void tick() {
        try {
            this.OObjectTime = this.TEAM == 0 ? MovingObject.game.curTime_a : MovingObject.game.curTime_b;
            if (this.mo_type == 3) {
                this.OObjectTime = this.TEAM == 0 ? MovingObject.game.curTime_a : MovingObject.game.curTime_b;
                switch (this.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 5: 
                    case 9: 
                    case 15: {
                        this.tick(this.bullet_speedX, this.bullet_speedY);
                        break;
                    }
                    case 3: {
                        if (this.cur_frm[this.curFrame] == 0) {
                            this.anime_delay = 70L;
                            if (this.bullet_speedX > 0) {
                                this.bullet_speedX -= 1700;
                            } else if (this.bullet_speedX < 0) {
                                this.bullet_speedX += 1700;
                            }
                            this.bullet_speedY += 1700;
                        }
                        this.tick(this.bullet_speedX, this.bullet_speedY);
                        this.posY += MovingObject.rand(1024);
                        if (MovingObject.rand(10) != 1) break;
                        MovingObject.createArtfact(game, (byte)2, this.posX, this.posY + 5048, this.speedX >> 1, this.speedY >> 1, 10, 10, 255);
                        break;
                    }
                    case 4: 
                    case 14: {
                        this.tick(this.bullet_speedX, this.speedY);
                        break;
                    }
                    case 6: {
                        this.tick(this.bullet_speedX + (MovingObject.rand(2) << 10), this.bullet_speedY + (MovingObject.rand(2) + 1 << 10));
                        break;
                    }
                    case 7: {
                        this.tick(this.bullet_speedX, this.bullet_speedY);
                        if (MovingObject.game.curTime - this.bullet_time <= ROCKET_TIME) break;
                        this.bullet_time = MovingObject.game.curTime;
                        if (this.speedX > 0) {
                            MovingObject.createArtfact(game, (byte)0, this.posX - this.width - 4096, this.posY + 5120, 0, 0, 2, 2, 200, true);
                            break;
                        }
                        MovingObject.createArtfact(game, (byte)0, this.posX + this.width, this.posY + 5120, 0, 0, 2, 2, 200, true);
                        break;
                    }
                    case 8: {
                        this.tick(this.bullet_speedX, this.speedY);
                        if (this.speedX > 0) {
                            MovingObject.createArtfact(game, (byte)0, this.posX - 6000, this.posY + 6000, 0, 0, 2, 2, 140);
                            break;
                        }
                        MovingObject.createArtfact(game, (byte)0, this.posX + this.width - 11000, this.posY + 6000, 0, 0, 2, 2, 140);
                    }
                }
                this.life += this.life_adder;
                if (this.posX <= 0 || this.posY <= 0 || this.posX + this.width >= MAX_X || this.hitHorizontaly) {
                    this.life = 0;
                }
                if (this.life <= 0 || this.hitBottom) {
                    this.askToKill();
                } else if (this.isOnGround && this.killOnGround) {
                    this.askToKill();
                }
            } else if (this.mo_type == 8) {
                if (InGame.LEVEL_MODE == 1) {
                    this.isGravityApplicable = false;
                    int n = this.speedX;
                    int n2 = this.speedY;
                    this.TEAM = 0;
                    this.tick(0, 0);
                    this.isGravityApplicable = true;
                    this.TEAM = 1;
                    this.tick(n, n2);
                } else {
                    this.tick(this.speedX, this.speedY);
                }
                if (this.isOnGround) {
                    this.speedX = 0;
                }
            } else if (this.mo_type == 10) {
                this.mustRecalculateLevelNode = true;
                if (InGame.LEVEL_MODE == 1) {
                    if (!MovingObject.game.skirmish_ready) {
                        return;
                    }
                    this.isGravityApplicable = false;
                    int n = this.speedX;
                    int n3 = this.speedY;
                    this.TEAM = 0;
                    this.tick(0, 0);
                    this.isGravityApplicable = true;
                    this.TEAM = 1;
                    this.tick(n, n3);
                    this.levelNode = game.level_getNode(this.posX + this.width2, this.posY);
                    if (this.frame == 2) {
                        // empty if block
                    }
                    if (this.frame == 1) {
                        if (MovingObject.game.skirmish_ctrls_timers == null) {
                            return;
                        }
                        if (MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][0] <= 0) {
                            MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][0] = 1000;
                            MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][1] = 1000;
                            MovingObject.game.skirmish_ctrls_assignedTeams[this.anim_offs_y_dir_skirmish_index] = 0;
                            MovingObject.game.skirmish_ctrls_mo[this.anim_offs_y_dir_skirmish_index].static_frame = (byte)3;
                        }
                        if (MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][1] <= 0) {
                            MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][0] = 1000;
                            MovingObject.game.skirmish_ctrls_timers[this.anim_offs_y_dir_skirmish_index][1] = 1000;
                            MovingObject.game.skirmish_ctrls_assignedTeams[this.anim_offs_y_dir_skirmish_index] = 1;
                            MovingObject.game.skirmish_ctrls_mo[this.anim_offs_y_dir_skirmish_index].static_frame = (byte)2;
                        }
                        game.addDomPoints(MovingObject.game.skirmish_ctrls_assignedTeams[this.anim_offs_y_dir_skirmish_index], 200);
                    }
                } else {
                    this.tick(this.speedX, this.speedY);
                }
                if (this.isOnGround) {
                    this.speedX = 0;
                }
            } else if (this.mo_type == 7) {
                if (this.frame == 4) {
                    int n;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = Integer.MAX_VALUE;
                    Agent agent = MovingObject.game.localPlayer;
                    if (agent != null && this.GRAVITY_USED < 2) {
                        n = agent.posY + agent.height;
                        n6 = this.posY - n;
                        n7 = this.posX + this.width2 - (agent.posX + agent.width2);
                        if (MovingObject.getDistanceTo(this, agent) > 10000 || n6 != 32768) {
                            if (n6 < 32768) {
                                n5 = 100;
                            } else if (n6 > 32768) {
                                n5 = -100;
                            }
                            n4 = this.posX < agent.posX ? 150 : -150;
                        }
                    }
                    if (this.GRAVITY_USED >= 2) {
                        n4 = 150;
                        n5 = 100;
                    }
                    n = this.speedX;
                    int n8 = this.speedY;
                    if ((n += n4) < -2048) {
                        n = -2048;
                    }
                    if (n > 2048) {
                        n = 2048;
                    }
                    if ((n8 += n5) < -1024) {
                        n8 = -1024;
                    }
                    if (n8 > 1024) {
                        n8 = 1024;
                    }
                    this.isOnGround = true;
                    this.tick(n, n8);
                    this.speedX = n;
                    this.speedY = n8;
                    if (this.posX >= MovingObject.game.camera_right && this.GRAVITY_USED > 6) {
                        this.askToKill();
                    }
                    if (n6 < 33768 && n6 > 32768 && MovingObject.abs(n7) < 26000) {
                        ++this.GRAVITY_USED;
                        if (this.GRAVITY_USED == 2 && this.staticCreator != null) {
                            this.staticCreator.static_life = 0;
                            this.staticCreator.spawnX = this.posX + this.width2;
                            this.staticCreator.spawnY = this.posY + this.height / 2;
                            this.staticCreator.associatedObject = null;
                            this.staticCreator.fireNextAction();
                            this.staticCreator = null;
                        }
                    }
                    if (this.speedX > 0 && MovingObject.rand(3) == 0) {
                        MovingObject.createArtfact(game, (byte)2, this.posX - 6000, this.posY + (this.height >> 1) + 9000, -1300, 1000, 0, 0, 255);
                    }
                    if (this.OObjectTime - this.lastAnimeTime > 50L) {
                        this.lastAnimeTime = this.OObjectTime;
                        this.createSmoke = !this.createSmoke;
                    }
                    return;
                }
                this.tick(this.speedX, this.speedY);
                if (this.frame == 3) {
                    this.anim_offs_y = (byte)(this.anim_offs_y + this.anim_offs_y_dir_skirmish_index);
                    if (this.anim_offs_y == 0) {
                        this.anim_offs_y_dir_skirmish_index = 1;
                    } else if (this.anim_offs_y == 5) {
                        this.anim_offs_y_dir_skirmish_index = (byte)-1;
                    }
                } else if (this.frame == 1 && !this.egg_cannotCreateEnemy) {
                    if (this.egg_isActivated) {
                        if (this.OObjectTime - this.egg_activation_time > 5000L) {
                            if (this.OObjectTime - this.egg_lastBlinkTime > this.anime_delay * 2L) {
                                this.egg_lastBlinkTime = this.OObjectTime;
                                this.setHit();
                            }
                            if (this.OObjectTime - this.egg_activation_time > 7000L) {
                                this.egg_isActivated = false;
                                this.askToKill();
                            }
                        }
                    } else if (this.posX > MovingObject.game.camera_left && this.posX < MovingObject.game.camera_right) {
                        this.egg_activation_time = this.OObjectTime;
                        this.egg_isActivated = true;
                    }
                }
            } else if (this.mo_type == 6) {
                this.tick(this.speedX, this.speedY);
                if (this.isOnGround || this.speedX == 0 && this.speedY == 0) {
                    this.askToKill();
                }
            } else if (this.mo_type == 2) {
                this.color_part_sR += this.color_fadeR;
                this.color_part_sG += this.color_fadeG;
                this.color_part_sB += this.color_fadeB;
                this.life += this.life_adder;
                if (this.life <= 0) {
                    this.life = 0;
                    this.askToKill();
                }
                this.tick(this.speedX / 2, this.speedY / 2);
            } else if (this.mo_type == 4) {
                this.posX += this.speedX;
                this.posY += this.speedY;
                if (this.artefact_type == 2) {
                    this.speedX /= 4;
                }
                this.animate();
            } else if (this.mo_type == 13) {
                this.tick(0, this.speedY);
                this.life += this.life_adder;
                if (this.life <= 0) {
                    this.askToKill();
                }
            } else if (this.mo_type == 11) {
                if (this.isGravityApplicable) {
                    this.tick(this.speedX, this.speedY);
                    if (this.isOnGround) {
                        this.isGravityApplicable = false;
                        this.speedY = 0;
                        this.speedX = 0;
                        if (!this.egg_cannotCreateEnemy) {
                            if (walker_arrow != null) {
                                walker_arrow.askToKill();
                            }
                            OObject oObject = new OObject();
                            oObject.posX = this.posX + 6000;
                            oObject.posY = this.posY + this.height + 4000;
                            walker_arrow = new MovingObject(oObject, 3, -1);
                            MovingObject.walker_arrow.staticCreator = null;
                            this.frame = 1;
                        }
                    }
                } else {
                    this.tick(0, 0);
                }
                if (this.egg_cannotCreateEnemy) {
                    if (this.OObjectTime - this.egg_lastBlinkTime > 30L) {
                        this.egg_isActivated = !this.egg_isActivated;
                        this.egg_lastBlinkTime = this.OObjectTime;
                        MovingObject.createArtfact(game, (byte)2, this.posX + 4096, this.posY + 10000, this.speedX >> 1, 2048, 15, 15, 255);
                    }
                    this.static_frame = this.egg_isActivated ? (byte)3 : (byte)0;
                    if (this.OObjectTime - this.lastAnimeTime > 2000L) {
                        this.egg_cannotCreateEnemy = false;
                        this.askToKill();
                    }
                }
            } else if (this.mo_type == 9) {
                if (this.artefact_type == 0 || this.artefact_type == 1) {
                    int n;
                    int n9;
                    byte by;
                    this.posX += this.speedX;
                    this.posY += this.speedY;
                    int n10 = this.posX / 16384;
                    int n11 = this.posY / 16384;
                    if (n10 < 0 || this.posX <= 0 || n10 >= MovingObject.game.numCellsX - 1 || n11 <= 0 || this.speedY == 0 || this.posX < MovingObject.game.camera_left) {
                        this.askToKill();
                        return;
                    }
                    if (n11 < MovingObject.game.numCellsY && (by = map[n10][n11]) > 0 && b_list[by] && (n9 = this.posY - n11 * 16384) < collision_map[by = a_list[by]][n = this.posX - n10 * 16384 >> 10]) {
                        if (groundCells[n10] == n11 || this.artefact_type == 0) {
                            this.posY = collision_map[by][n] + n11 * 16384;
                            this.askToKill();
                        }
                        return;
                    }
                } else {
                    this.tick(this.speedX, this.speedY);
                    if (this.isOnGround || this.speedY == 0) {
                        this.askToKill();
                    }
                }
            } else {
                this.tick(0, 0);
            }
        }
        catch (Exception exception) {
            this.askToKill();
        }
    }

    public void tick(int n, int n2) {
        if ((this.posX < 0 || this.posY < 0 || this.posX + this.width > MAX_X) && this.mo_type != 12) {
            this.askToKill();
            return;
        }
        if (this.isGravityApplicable && (n2 -= this.GRAVITY_USED) < -15360) {
            n2 = -15360;
        }
        OObject oObject = null;
        oObject = this.TEAM == 1 ? MovingObject.game.team_a : MovingObject.game.team_b;
        if (this.TEAM == 1 && this.mo_type == 7) {
            oObject = MovingObject.game.bullets_a;
        }
        if (this.TEAM == 1 && this.mo_type == 12 && ((Agent)this).agent_type == 9) {
            oObject = MovingObject.game.team_a;
        }
        boolean bl = n2 > 0 ? false : this.isOnGround;
        this.move(n, n2, oObject);
        boolean bl2 = this.mustRecalculateLevelNode = !bl && this.isOnGround;
        if (this.posX - this.col_oldPosX > 0) {
            this.facing = (byte)5;
            this.isMoving = true;
        } else if (this.col_oldPosX - this.posX > 0) {
            this.facing = (byte)2;
            this.isMoving = true;
        } else {
            this.isMoving = false;
        }
        if (this.isAnimated) {
            this.animate();
        }
        if (this.getNodes) {
            if (this.levelNode == null) {
                this.mustRecalculateLevelNode = true;
            }
            if (this.mustRecalculateLevelNode) {
                this.mustRecalculateLevelNode = false;
                this.levelNode = game.level_getNode(this.posX + this.width2, this.posY);
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3 = this.height >> 10;
        int n4 = this.width >> 10;
        int n5 = this.posX >> 10;
        int n6 = this.posY >> 10;
        int n7 = n + n5;
        if ((n7 > MovingObject.game.viewWidth || n7 + n4 < 0) && this.mo_type != 1 && this.mo_type != 12) {
            return;
        }
        if (this.mo_type == 2) {
            int n8 = (this.color_part_sR & 0xFF00) << 8;
            int n9 = this.color_part_sG & 0xFF00;
            int n10 = (this.color_part_sB & 0xFF00) >> 8;
            graphics.setColor(0xFF000000 | n8 | n9 | n10);
            graphics.fillRect(n + n5, n2 + DeviceUtils.height - n6 - n3, n4, n3);
        } else if (this.mo_type == 13) {
            DeviceImage.drawBitmapString(graphics, "" + this.anime_delay, n + n5 - 7, n2 + DeviceUtils.height - n6, 3);
        } else {
            DeviceImage[] deviceImageArray;
            int n11 = n + n5;
            int n12 = n2 + DeviceUtils.height - n6 - n3;
            if (this.mo_type == 7) {
                if (this.frame == 3) {
                    this.frm_body[0].drawImage(graphics, n11, n12 + this.addOffsetY + this.anim_offs_y - 5);
                    this.frm_body[0].drawImage(graphics, n11, n12 + this.addOffsetY + this.anim_offs_y - 15);
                    return;
                }
                if (this.frame == 4) {
                    DeviceImage.sprites[60][this.createSmoke ? 0 : 1].drawImage(graphics, n11 + 4, n12 - 6);
                }
            }
            byte by = this.isFixed || this.cur_frm == null ? this.static_frame : this.cur_frm[this.curFrame];
            this.preDraw(graphics, n11, n2 + DeviceUtils.height - n6);
            if (this.mo_type == 1 && ((Agent)this).specialMode != 0) {
                deviceImageArray = (DeviceImage[])this;
                int n13 = n2 + DeviceUtils.height - n6;
                int n14 = n + (this.posX + this.width2 >> 10);
                int n15 = n13 - (this.height >> 11) - 6;
                int n16 = deviceImageArray.specialMode_angle;
                int n17 = 51;
                DeviceImage[] deviceImageArray2 = null;
                deviceImageArray2 = deviceImageArray.specialMode == 2 ? DeviceImage.sprites[82] : DeviceImage.sprites[73];
                n14 -= deviceImageArray2[0].width >> 1;
                n15 -= deviceImageArray2[0].height >> 1;
                int n18 = deviceImageArray2.length;
                deviceImageArray.specialMode_startFrame = (byte)(deviceImageArray.specialMode_startFrame % n18);
                int n19 = deviceImageArray.specialMode_startFrame;
                for (int i = 0; i < 7; ++i) {
                    int n20 = MovingObject.cos(n16) * deviceImageArray.specialMode_radius >> 10;
                    int n21 = MovingObject.sin(n16) * deviceImageArray.specialMode_radius >> 10;
                    deviceImageArray2[n19].drawImage(graphics, n14 + n20, n15 + n21);
                    n19 = (n19 + 1) % n18;
                    n16 = (n16 + n17) % 360;
                }
            }
            this.frm_body[by].drawImage(graphics, n11, n12 + this.addOffsetY);
            if (this.frm_head != null) {
                this.frm_head[this.map_head[by]].drawImage(graphics, n11 + this.head_offsets[by][0], n12 + this.head_offsets[by][1]);
            }
            if (this.mo_type == 10 && this.frame == 2 && this.life == -1) {
                deviceImageArray = DeviceImage.sprites[31];
                deviceImageArray[this == MovingObject.game.skirmish_flag_a ? 1 : 0].drawImage(graphics, n11 + 12, n2 - 6 + DeviceUtils.height - n6 - deviceImageArray[0].height);
            }
            this.additionalDraw(graphics, n11, n2 + DeviceUtils.height - n6);
        }
    }

    public void preDraw(Graphics graphics, int n, int n2) {
    }

    public void additionalDraw(Graphics graphics, int n, int n2) {
    }

    public void animate() {
        byte[] byArray = this.cur_frm;
        if (this.isOnGround) {
            this.airing_cycleFrames = true;
            if (this.isAiring && this.createSmoke) {
                MovingObject.createArtfact(game, (byte)2, this.posX - this.speedX + (this.facing == 2 ? this.width2 : this.width2 - 6144), this.posY, -this.speedX / 2, 2048, 1, 1, 255);
            }
            if (this.isAiring && this.myFrames[4] != null && this.speedX == 0) {
                this.isAiring = false;
                this.cur_frm = this.facing == 2 ? this.myFrames[4] : this.myFrames[5];
            } else {
                this.isAiring = false;
                this.cur_frm = this.facing == 2 ? (this.isMoving ? this.myFrames[0] : this.myFrames[2]) : (this.isMoving ? this.myFrames[1] : this.myFrames[3]);
            }
        } else {
            this.airing_cycleFrames = false;
            this.isAiring = true;
            this.cur_frm = this.speedY > 0 ? (this.facing == 2 ? this.myFrames[6] : this.myFrames[8]) : (this.facing == 2 ? this.myFrames[7] : this.myFrames[9]);
        }
        if (this.isHit && this.OObjectTime - this.last_hitTime < this.hitDelay && this.myFrames[10] != null) {
            this.cur_frm = this.facing == 2 ? this.myFrames[10] : this.myFrames[11];
        } else if (this.isHit && this.OObjectTime - this.last_hitTime > this.hitDelay) {
            this.isHit = false;
        }
        if (this.cur_frm != byArray) {
            this.curFrame = 0;
            this.lastAnimeTime = this.OObjectTime;
        } else if (this.OObjectTime - this.lastAnimeTime > this.anime_delay) {
            MovingObject movingObject;
            this.lastAnimeTime = this.OObjectTime;
            this.curFrame = (byte)(this.curFrame + 1);
            if (this.curFrame == this.cur_frm.length) {
                if (this.mo_type == 3) {
                    this.airing_cycleFrames = true;
                }
                if (this.airing_cycleFrames) {
                    this.curFrame = 0;
                    if (this.isAiring) {
                        this.isAiring = false;
                    }
                } else {
                    this.curFrame = (byte)(this.curFrame - 1);
                }
                if (this.mo_type == 4) {
                    this.askToKill();
                }
                if (this.mo_type == 5) {
                    Agent agent = (Agent)this;
                    if (agent.agent_type == 4) {
                        boolean bl = this.facing == 2;
                        switch (agent.special_mode) {
                            case 3: {
                                agent.special_mode = (byte)5;
                                this.initFrames(bl ? (byte)17 : 18);
                                break;
                            }
                            case 4: {
                                agent.special_mode = (byte)2;
                                this.initFrames(bl ? (byte)19 : 20);
                            }
                        }
                    }
                }
                if (this.mo_type == 3 && (this.type == 3 || this.type == 5 || this.type == 6)) {
                    this.askToKill();
                }
            } else if (this.curFrame == this.cur_frm.length - 1 && this.mo_type == 7 && this.frame == 2 && (movingObject = MovingObject.createArtfact(game, (byte)2, this.posX + this.width2 - 2048, this.posY + this.height + 2048, 0, 2048, 5, 5, 255)) != null) {
                movingObject.anime_delay = 250L;
            }
        }
    }

    public void setHit() {
        this.isHit = true;
        this.last_hitTime = this.OObjectTime;
    }

    public static final void createPart(InGame inGame, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        n >>= 10;
        n2 >>= 10;
        int n12 = 2;
        int n13 = 2;
        if (particles_counter != 0) {
            if (n <= 0 || n2 <= 0 || n + n12 >= inGame.mapWidth || n2 + n13 >= inGame.mapHeight) {
                return;
            }
            ++particles_counter;
            MovingObject movingObject = new MovingObject();
            movingObject.init((byte)2, n, n2, n12, n13, false);
            movingObject.color_part_sR = n5 << 8;
            movingObject.color_part_sG = n6 << 8;
            movingObject.color_part_sB = n7 << 8;
            movingObject.color_fadeR = (n8 - n5 << 8) / (255 / n11);
            movingObject.color_fadeG = (n9 - n6 << 8) / (255 / n11);
            movingObject.color_fadeB = (n10 - n7 << 8) / (255 / n11);
            movingObject.life_adder = -n11;
            movingObject.speedX = MovingObject.rand(n3) << 10;
            movingObject.speedY = MovingObject.rand(n4) << 10;
            movingObject.speedY = MovingObject.abs(movingObject.speedY);
            movingObject.container = inGame.particles;
            movingObject.container.addElementBefore(movingObject, null);
            movingObject.mo_type = (byte)2;
            movingObject.isHittable = false;
            movingObject.isFixed = true;
        }
    }

    public void askToKill() {
        MovingObject.game.deleteList.addElementBefore(this, null);
        this.bullet_energy = 0;
    }

    public void delete() {
        if (this.container != null) {
            this.container.removeElement(this.container.contains(this));
        }
        this.container = null;
        switch (this.mo_type) {
            case 11: {
                if (MovingObject.game.localPlayer.useWalker) {
                    this.killBOT(MovingObject.game.localPlayer);
                }
                int n = this.posX + this.width2;
                int n2 = this.posY + (this.height >> 1);
                for (int i = 0; i < 10; ++i) {
                    MovingObject.createArtfact(game, (byte)0, n + MovingObject.rand(this.width2), n2 + MovingObject.rand(this.height >> 1), MovingObject.rand(8000), MovingObject.rand(8000), 0, 0, 255);
                    MovingObject.createArtfact(game, (byte)0, n + MovingObject.rand(this.width2), n2 + MovingObject.rand(this.height >> 1), MovingObject.rand(8000), MovingObject.rand(8000), 0, 0, 255);
                    MovingObject.createDebris(game, 1, n, n2);
                    MovingObject.createDebris(game, 1, n, n2);
                    MovingObject.createDebris(game, 1, n, n2);
                    MovingObject.createDebris(game, 1, n, n2);
                }
                break;
            }
            case 12: {
                int n = this.posX + this.width2;
                int n3 = this.posY + (this.height >> 1);
                this.life = -2;
                Agent agent = (Agent)this;
                agent.boss_pattern = (byte)-1;
                if (this == MovingObject.game.boss_maite) {
                    n = this.posX;
                    this.width *= 2;
                    this.height *= 2;
                    this.width2 *= 2;
                }
                for (int i = 0; i < 10; ++i) {
                    MovingObject.createArtfact(game, (byte)0, n + MovingObject.rand(this.width2), n3 + MovingObject.rand(this.height >> 1), MovingObject.rand(8000), MovingObject.rand(8000), 0, 0, 255);
                    MovingObject.createArtfact(game, (byte)1, n + MovingObject.rand(this.width2), n3 + MovingObject.rand(this.height >> 1), MovingObject.rand(8000), MovingObject.rand(8000), 0, 0, 255);
                    MovingObject.createDebris(game, 2, n, n3);
                    MovingObject.createDebris(game, 2, n, n3);
                    MovingObject.createDebris(game, 2, n, n3);
                    MovingObject.createDebris(game, 2, n, n3);
                }
                game.setToEnd();
                break;
            }
            case 9: {
                if (this.artefact_type == 0) {
                    MovingObject.createSpecialFx(game, 0);
                    if (this.posX < MovingObject.game.camera_left || this.posX > MovingObject.game.camera_right) break;
                    MovingObject.createPart(game, this.posX, this.posY, 20, 30, 255, 255, 255, 30, 30, 128, 30);
                    MovingObject.createPart(game, this.posX, this.posY, 20, 30, 255, 255, 255, 30, 30, 128, 30);
                    MovingObject.createPart(game, this.posX, this.posY, 20, 30, 255, 255, 255, 30, 30, 128, 30);
                    break;
                }
                MovingObject.createSpecialFx(game, 1);
                break;
            }
            case 7: {
                if (this.frame == 4) {
                    return;
                }
                if (this.frame != 3) {
                    int n = this.posX + this.width2;
                    int n4 = this.posY + (this.height >> 1);
                    int n5 = 512;
                    MovingObject.createArtfact(game, (byte)0, n, n4, n5, 1024, 1, 8, 255);
                    MovingObject.createArtfact(game, (byte)0, n, n4, -n5, 1024, 2, 8, 255);
                    MovingObject.createArtfact(game, (byte)0, n, n4, n5, 1024, 3, 8, 200);
                    if (this.frame != 1) {
                        MovingObject.createDebris(game, 1, n, n4);
                        MovingObject.createDebris(game, 1, n, n4);
                    }
                    if (this.frame == 1) {
                        MovingObject.createDebris(game, 2, n, n4);
                        MovingObject.createDebris(game, 2, n, n4);
                        this.egg_cannotCreateEnemy = true;
                        this.initFrames((byte)2);
                        this.isHittable = false;
                        this.container = MovingObject.game.staticObjects;
                        this.container.addElementBefore(this, null);
                        if (!this.egg_isActivated) {
                            if (this.staticCreator != null) {
                                Agent agent = new Agent(this.staticCreator, null, 3, 2, this.posX, this.posY, MovingObject.game.team_b);
                                agent.TEAM = 1;
                                this.staticCreator.static_life = 1;
                                this.staticCreator.associatedObject = null;
                                this.staticCreator = null;
                            }
                            return;
                        }
                    }
                }
                if (this.staticCreator == null) break;
                this.staticCreator.static_life = 0;
                this.staticCreator.am_collision_x1 = this.posX + this.width2;
                this.staticCreator.am_collision_y1 = this.posY + this.height / 2;
                this.staticCreator.associatedObject = null;
                this.staticCreator.fireNextAction();
                this.staticCreator = null;
                break;
            }
            case 2: {
                --particles_counter;
                break;
            }
            case 4: {
                --artefact_counter;
                break;
            }
            case 6: {
                --artefact_counter;
                MovingObject.createArtfact(game, (byte)2, this.posX + 4096, this.posY, this.speedX >> 1, 2048, 0, 0, 255);
                break;
            }
            case 8: {
                if (this.staticCreator == null) break;
                this.staticCreator.static_life = (short)(this.staticCreator.static_life - 1);
                this.staticCreator.fireNextAction();
                this.staticCreator = null;
                break;
            }
            case 3: {
                if (this.life < 0) break;
                switch (this.type) {
                    case 0: 
                    case 1: 
                    case 9: 
                    case 15: {
                        MovingObject.createArtfact(game, (byte)0, this.posX - this.speedX / 2, this.posY, 0, 1024, 3, 3, this.life);
                        MovingObject.createPart(game, this.posX + this.width2, this.posY + this.height / 2, 20, 60, 255, 0, 60, 0, 0, 0, 40);
                        MovingObject.createPart(game, this.posX + this.width2, this.posY + this.height / 2, 20, 60, 255, 0, 60, 0, 0, 0, 40);
                        MovingObject.createPart(game, this.posX + this.width2, this.posY + this.height / 2, 20, 60, 255, 100, 100, 0, 0, 0, 60);
                        break;
                    }
                    case 2: {
                        MovingObject.createArtfact(game, (byte)1, this.posX, this.posY, this.bullet_speedX / 2, 3072, 3, 3, this.life - 30);
                        break;
                    }
                    case 4: 
                    case 14: {
                        MovingObject.createBullet(this.parent, game, (byte)5, this.posX >> 10, this.posY >> 10, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) - 1, (this.posY >> 10) + 1, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) - 1, (this.posY >> 10) - 1, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) + 1, (this.posY >> 10) + 1, 0);
                        if (this.parent != null) break;
                        MovingObject.createDebris(game, 1, this.posX, this.posY + 17000);
                        MovingObject.createDebris(game, 1, this.posX, this.posY + 17000);
                        MovingObject.createDebris(game, 1, this.posX, this.posY + 17000);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) + 1, (this.posY >> 10) + 9, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) + 1, (this.posY >> 10) + 7, 0);
                        break;
                    }
                    case 7: {
                        if (this.parent != null && this.parent.mo_type == 5) {
                            MovingObject.createBullet(this.parent, game, (byte)6, this.posX >> 10, this.posY >> 10, 0);
                            MovingObject.createBullet(this.parent, game, (byte)6, (this.posX >> 10) - 1, (this.posY >> 10) + 1, 0);
                            MovingObject.createBullet(this.parent, game, (byte)6, (this.posX >> 10) - 1, (this.posY >> 10) - 1, 0);
                            MovingObject.createBullet(this.parent, game, (byte)6, (this.posX >> 10) + 1, (this.posY >> 10) + 1, 0);
                            break;
                        }
                        MovingObject.createBullet(this.parent, game, (byte)5, this.posX >> 10, this.posY >> 10, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) - 1, (this.posY >> 10) + 1, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) - 1, (this.posY >> 10) - 1, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) + 1, (this.posY >> 10) + 1, 0);
                        if (this.parent != null) break;
                        MovingObject.game.whiteFlash = true;
                        MovingObject.game.airStrikeRemaining = (byte)(MovingObject.game.airStrikeRemaining - 1);
                        if (MovingObject.game.airStrikeRemaining > 0) break;
                        MovingObject.game.story_mode = true;
                        MovingObject.game.gameStatus = (byte)4;
                        break;
                    }
                    case 8: {
                        MovingObject.createBullet(this.parent, game, (byte)5, this.posX >> 10, this.posY >> 10, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) - 1, (this.posY >> 10) + 1, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) - 1, (this.posY >> 10) - 1, 0);
                        MovingObject.createBullet(this.parent, game, (byte)5, (this.posX >> 10) + 1, (this.posY >> 10) + 1, 0);
                    }
                }
                break;
            }
            case 1: 
            case 5: {
                Agent agent = (Agent)this;
                if (agent.ai_closer_friend != null) {
                    agent.ai_closer_friend.ai_closer_friend_test = true;
                    agent.ai_closer_friend.ai_closer_friend = null;
                    agent.ai_closer_friend = null;
                }
                if (agent.type == 2) {
                    if (agent.agent_enemyObject != null) {
                        agent.agent_enemyObject.spawnX = this.posX + this.width2;
                        agent.agent_enemyObject.spawnY = this.posY + this.height / 2;
                        agent.agent_enemyObject.static_life = (short)(agent.agent_enemyObject.static_life - 1);
                        agent.agent_enemyObject.fireNextAction();
                    } else {
                        agent.agent_spawner.spawnX = this.posX + this.width2;
                        agent.agent_spawner.spawnY = this.posY + this.height / 2;
                    }
                    agent.agent_spawner.static_life = (short)(agent.agent_spawner.static_life - 1);
                    agent.agent_spawner.fireNextAction();
                    break;
                }
                if (agent.type != 0) break;
                game.setToEnd();
            }
        }
    }

    public static final MovingObject createArtfact(InGame inGame, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        return MovingObject.createArtfact(inGame, by, n, n2, n3, n4, n5, n6, n7, false);
    }

    public static final MovingObject createArtfact(InGame inGame, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (artefact_counter == 10 && !bl) {
            return null;
        }
        ++artefact_counter;
        MovingObject movingObject = new MovingObject();
        int n8 = 0;
        int n9 = 0;
        n >>= 10;
        n2 >>= 10;
        if (n5 == 0) {
            n5 = 2;
        }
        if (n6 == 0) {
            n6 = 2;
        }
        n += MovingObject.rand(n5);
        n2 += MovingObject.rand(n6);
        movingObject.isGravityApplicable = false;
        movingObject.isHittable = false;
        movingObject.artefact_type = by;
        movingObject.isAnimated = true;
        movingObject.speedX = n3;
        movingObject.speedY = n4;
        switch (by) {
            case 0: {
                movingObject.anime_delay = 70L;
                movingObject.frm_body = DeviceImage.sprites[29];
                movingObject.initFrames((byte)4);
                n8 = 16;
                n9 = 16;
                break;
            }
            case 1: {
                movingObject.anime_delay = 70L;
                movingObject.frm_body = DeviceImage.sprites[28];
                movingObject.initFrames(n3 > 0 ? (byte)6 : 5);
                n8 = 16;
                n9 = 16;
                break;
            }
            case 2: {
                movingObject.anime_delay = 70L;
                movingObject.frm_body = DeviceImage.sprites[83];
                movingObject.initFrames((byte)7);
                n9 = 6;
                n8 = 8;
            }
        }
        if (n7 > 255) {
            n7 = 255;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        movingObject.curFrame = (byte)((255 - n7) * movingObject.cur_frm.length >> 8);
        movingObject.init((byte)4, n, n2 - n9 / 2, n8, n9, false);
        movingObject.container = inGame.particles;
        movingObject.container.addElementBefore(movingObject, null);
        return movingObject;
    }

    public static final void createSpecialFx(InGame inGame, int n) {
        MovingObject movingObject = new MovingObject();
        int n2 = inGame.camera_right + inGame.camera_left >> 1;
        n2 += MovingObject.rand(inGame.camera_right - inGame.camera_left >> 1);
        int n3 = MAX_Y + (MAX_Y >> 1);
        if ((n2 >>= 10) < 0 || n2 >= MAX_X) {
            MovingObject.createSpecialFx(inGame, n);
            return;
        }
        n3 >>= 10;
        n2 += MovingObject.rand(5);
        if (n == 0) {
            movingObject.isGravityApplicable = false;
            movingObject.isHittable = false;
            movingObject.isAnimated = false;
            movingObject.speedX = 0;
            movingObject.speedY = MovingObject.rand(3000);
            if (movingObject.speedY > 0) {
                movingObject.speedY = -movingObject.speedY;
            }
            movingObject.speedY -= 6000;
            movingObject.GRAVITY_USED = 0;
            movingObject.life_adder = 0;
            movingObject.isFixed = true;
            movingObject.frm_body = DeviceImage.sprites[93];
            movingObject.static_frame = 0;
            movingObject.init((byte)9, n2, n3, 1, 7, false);
        } else {
            n3 = (inGame.camera_real_pos_y >> 10) + inGame.viewHeight;
            movingObject.isGravityApplicable = false;
            movingObject.isHittable = false;
            movingObject.isAnimated = false;
            movingObject.isFixed = true;
            movingObject.speedX = MovingObject.rand(10) << 10;
            movingObject.speedY = MovingObject.rand(3000);
            if (movingObject.speedY > 0) {
                movingObject.speedY = -movingObject.speedY;
            }
            if (movingObject.speedX > 0) {
                movingObject.speedX = -movingObject.speedX;
            }
            movingObject.speedY -= 6000;
            n2 += 1 * inGame.viewWidth / 2;
            movingObject.GRAVITY_USED = 0;
            movingObject.life_adder = 0;
            movingObject.frm_body = DeviceImage.sprites[84];
            if (movingObject.speedX < -5000) {
                movingObject.static_frame = 1;
            }
            movingObject.init((byte)9, n2, n3, 3, 3, false);
        }
        movingObject.container = inGame.specialFX;
        movingObject.container.addElementBefore(movingObject, null);
        movingObject.artefact_type = (byte)n;
    }

    public static final MovingObject createSkirmishObject(InGame inGame, int n, int n2, int n3) {
        MovingObject movingObject = new MovingObject();
        movingObject.isAnimated = false;
        if (n < 3) {
            movingObject.frm_body = DeviceImage.sprites[69];
            movingObject.static_frame = (byte)(n != 0 ? 1 : 0);
            movingObject.init((byte)10, (n2 >> 10) - 10, n3 >> 10, 32, 13, false);
            movingObject.addOffsetY = 4;
        } else {
            movingObject.frm_body = DeviceImage.sprites[31];
            movingObject.static_frame = 0;
            movingObject.init((byte)10, (n2 >> 10) - 10, n3 >> 10, 16, 20, false);
        }
        movingObject.container = inGame.staticObjects;
        movingObject.container.addElementBefore(movingObject, null);
        movingObject.getNodes = true;
        movingObject.frame = (byte)n;
        movingObject.ensureLevelNode();
        movingObject.life = -1;
        return movingObject;
    }

    public static final MovingObject createDebris(InGame inGame, int n, int n2, int n3) {
        if (artefact_counter == 10) {
            return null;
        }
        ++artefact_counter;
        MovingObject movingObject = new MovingObject();
        n2 >>= 10;
        n3 >>= 10;
        n2 += MovingObject.rand(5);
        n3 += MovingObject.rand(5);
        movingObject.isHittable = false;
        movingObject.isAnimated = false;
        movingObject.speedX = MovingObject.rand(6) << 10;
        movingObject.speedY = MovingObject.rand(4) << 10;
        movingObject.life_adder = 0;
        if (movingObject.speedY < 5120) {
            movingObject.speedY = -movingObject.speedY + 5120;
        }
        if (n == 1 || n == 2) {
            movingObject.frm_body = DeviceImage.sprites[23];
            movingObject.static_frame = (byte)MovingObject.randAbs(2);
            if (n != 1) {
                movingObject.static_frame = (byte)(movingObject.static_frame + 2);
            }
        } else {
            movingObject.frm_body = DeviceImage.sprites[37];
            movingObject.static_frame = (byte)(n == 3 ? 1 : 0);
        }
        movingObject.init((byte)6, n2, n3 - 4, 8, 8, false);
        movingObject.container = inGame.particles;
        movingObject.container.addElementBefore(movingObject, null);
        return movingObject;
    }

    public void addLife(int n, boolean bl, MovingObject movingObject) {
        if (this.mo_type == 1) {
            if (GameStage.CHEATMODE_INVINCIBILITY && this == MovingObject.game.localPlayer) {
                return;
            }
            Agent agent = (Agent)this;
            if (n < 0) {
                agent.hitPointsLost -= n;
            }
            if (movingObject != null && movingObject.mo_type == 3 && movingObject.parent != null && movingObject.parent.mo_type == 1) {
                ((Agent)movingObject.parent).hitPointsTaken -= n;
            }
        }
        if (this.life == -1) {
            return;
        }
        int n2 = this.life + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.maxLife) {
            n2 = this.maxLife;
        }
        if (n < 0 && bl) {
            this.setHit();
        }
        if (n2 != this.life) {
            this.life = n2;
            this.statusChangedNotification(movingObject);
        }
    }

    public void statusChangedNotification(MovingObject movingObject) {
        if (this.life == 0) {
            Agent agent;
            if (movingObject != null && movingObject.mo_type == 3 && movingObject.parent == MovingObject.game.localPlayer) {
                if (this.mo_type == 5) {
                    agent = (Agent)this;
                    playerScore += (long)scores_for_enemies[agent.agent_type][agent.agent_behaviour];
                } else if (this.mo_type == 7) {
                    if (this.frame == 0) {
                        playerScore += 100L;
                        MovingObject.createNumber(this.posX + this.width2, this.posY + (this.height >> 1), 100, -10);
                    } else if (this.frame == 2) {
                        playerScore += 250L;
                        MovingObject.createNumber(this.posX + this.width2, this.posY + (this.height >> 1), 250, -10);
                    }
                } else if (this.mo_type == 12) {
                    agent = (Agent)this;
                    if (agent.agent_type == 7) {
                        playerScore += 12000L;
                    } else if (agent.agent_type == 8) {
                        playerScore += 150000L;
                    }
                }
            }
            if (this.mo_type == 11) {
                this.askToKill();
            } else if (this.mo_type == 5) {
                agent = (Agent)this;
                if (agent.type == 3) {
                    this.killBOT(agent);
                    return;
                }
                this.askToKill();
                byte by = enemy_explosion_colors[((Agent)this).agent_type];
                byte by2 = by == 0 || by == 2 ? (byte)0 : 1;
                int n = this.posX + this.width2;
                int n2 = this.posY + (this.height >> 1);
                int n3 = 512;
                if (this.facing == 5) {
                    n3 = -n3;
                }
                MovingObject.createArtfact(game, by2, n, n2, n3, 1024, 1, 8, 255);
                MovingObject.createArtfact(game, by2, n, n2, n3, 1024, 2, 8, 255);
                MovingObject.createArtfact(game, by2, n, n2, n3, 1024, 3, 8, 200);
                if (by > 1) {
                    MovingObject.createDebris(game, by == 2 ? 1 : 2, n, n2);
                    MovingObject.createDebris(game, by == 2 ? 1 : 2, n, n2);
                    MovingObject.createDebris(game, by == 2 ? 1 : 2, n, n2);
                    MovingObject.createDebris(game, by == 2 ? 1 : 2, n, n2);
                    MovingObject.createDebris(game, by == 2 ? 1 : 2, n, n2);
                    MovingObject.createDebris(game, by == 2 ? 1 : 2, n, n2);
                }
            } else if (this.mo_type == 1) {
                agent = (Agent)this;
                this.killBOT(agent);
                ++agent.deaths;
                if (movingObject != null && movingObject.mo_type == 3 && movingObject.parent != null && movingObject.parent.mo_type == 1) {
                    ++((Agent)movingObject.parent).kills;
                }
                if (InGame.LEVEL_MODE == 1 && agent.curWeapon != 0) {
                    new MovingObject(agent.posX >> 10, agent.posY >> 10, -agent.speedX >> 10, agent.speedY >> 11, remapWeaponToBonus[agent.curWeapon], (byte)agent.curAmmo);
                }
            } else if (this.mo_type == 7) {
                this.askToKill();
            } else if (this.mo_type == 12) {
                int n = this.posX + this.width2;
                int n4 = this.posY + (this.height >> 1);
                Agent agent2 = (Agent)this;
                agent2.boss_pattern = (byte)-1;
                for (int i = 0; i < 3; ++i) {
                    MovingObject.createArtfact(game, (byte)0, n + MovingObject.rand(this.width2), n4 + MovingObject.rand(this.height >> 1), MovingObject.rand(2000), MovingObject.rand(2000), 0, 0, 255);
                }
            }
        }
    }

    public void killBOT(Agent agent) {
        if (agent.agent_behaviour != 1) {
            MovingObject movingObject;
            agent.walker_free();
            agent.agent_behaviour = 1;
            agent.cur_frm = this.hit_facing == 2 ? player_frm_die_l : player_frm_die_r;
            this.facing = (byte)(this.hit_facing == 2 ? 5 : 2);
            agent.static_frame = 0;
            agent.isAnimated = false;
            agent.curFrame = 0;
            agent.isHittable = false;
            agent.speedY = agent.player_yMove / 1;
            agent.speedX = (this.hit_facing == 2 ? -1 : 1) * agent.player_xMove / 1;
            game.bulletTime_disable();
            if (agent.bot_gotFlag) {
                agent.bot_gotFlag = false;
                movingObject = MovingObject.createSkirmishObject(game, 3, agent.posX, agent.posY);
                movingObject.speedY = agent.player_yMove / 1;
                movingObject.speedX = (agent.hit_facing == 2 ? -1 : 1) * agent.player_xMove / 2;
                if (agent.TEAM == 0) {
                    MovingObject.game.skirmish_flag_moving_b = movingObject;
                } else {
                    MovingObject.game.skirmish_flag_moving_a = movingObject;
                    movingObject.static_frame = 1;
                }
            }
            agent.weapon_status = 0;
            movingObject = MovingObject.createDebris(game, this.hit_facing == 2 ? 3 : 4, this.posX, this.posY + 3000);
            if (movingObject != null) {
                movingObject.speedX = agent.speedX + (this.hit_facing == 2 ? -1 : 1) * 2000;
                movingObject.speedY = agent.speedY + 2000;
            }
            if (this == MovingObject.game.myEnemy) {
                MovingObject.game.boss_life = 0;
            }
            if (this == MovingObject.game.localPlayer && MovingObject.game.boss_toilet != null) {
                new MovingObject(this.posX >> 10, this.posY >> 10, 0, 0, 3, 30);
            }
        }
    }

    public static int getDistanceTo(MovingObject movingObject, MovingObject movingObject2) {
        return MovingObject.dApprox_optim(movingObject.posX - movingObject2.posX, movingObject.posY - movingObject2.posY);
    }

    public static int dApprox_optim(int n, int n2) {
        int n3;
        int n4;
        if (n < 0) {
            n = -n;
        }
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n < n2) {
            n4 = n;
            n3 = n2;
        } else {
            n4 = n2;
            n3 = n;
        }
        int n5 = n3 * 1007 + n4 * 441;
        if (n3 < n4 << 4) {
            n5 -= n3 * 40;
        }
        return n5 + 512 >> 10;
    }

    public static int sin(int n) {
        if ((n %= 360) < 180) {
            if (n > 90) {
                return cos[n - 90];
            }
            return cos[90 - n];
        }
        if ((n -= 180) > 90) {
            return -cos[n - 90];
        }
        return -cos[90 - n];
    }

    public static int cos(int n) {
        if ((n %= 360) < 180) {
            if (n > 90) {
                return -cos[180 - n];
            }
            return cos[n];
        }
        if ((n -= 180) > 90) {
            return cos[180 - n];
        }
        return -cos[n];
    }

    public void ensureLevelNode() {
        if (this.levelNode == null) {
            this.levelNode = game.level_getNode(this.posX, this.posY);
        }
    }

    public static final void loadEnemies(DataInputStream dataInputStream) throws Exception {
        int n;
        int n2;
        byte by = dataInputStream.readByte();
        players_characteristics = new short[4 * by];
        for (n2 = 0; n2 < by * 4; ++n2) {
            MovingObject.players_characteristics[n2] = dataInputStream.readShort();
        }
        by = dataInputStream.readByte();
        pre_enemy_createSmokeShadow = new byte[by];
        pre_enemy_byteChars = new byte[by][5][5];
        pre_enemy_shortChars = new short[by][5][5];
        for (n2 = 0; n2 < by; ++n2) {
            MovingObject.pre_enemy_createSmokeShadow[n2] = dataInputStream.readByte();
            for (n = 0; n < 5; ++n) {
                MovingObject.pre_enemy_byteChars[n2][n][0] = dataInputStream.readByte();
                MovingObject.pre_enemy_byteChars[n2][n][1] = dataInputStream.readByte();
                MovingObject.pre_enemy_byteChars[n2][n][2] = dataInputStream.readByte();
                MovingObject.pre_enemy_shortChars[n2][n][0] = dataInputStream.readShort();
                MovingObject.pre_enemy_shortChars[n2][n][1] = dataInputStream.readShort();
                MovingObject.pre_enemy_shortChars[n2][n][2] = dataInputStream.readShort();
                MovingObject.pre_enemy_shortChars[n2][n][3] = dataInputStream.readShort();
                MovingObject.pre_enemy_shortChars[n2][n][4] = dataInputStream.readShort();
                MovingObject.pre_enemy_byteChars[n2][n][3] = dataInputStream.readByte();
                MovingObject.pre_enemy_byteChars[n2][n][4] = dataInputStream.readByte();
            }
        }
        by = dataInputStream.readByte();
        for (n2 = 0; n2 < 9; ++n2) {
            MovingObject.bots_behaviours[n2] = dataInputStream.readByte();
        }
        ai_transitions = new byte[by][][];
        ai_commands = new short[by][][];
        for (n2 = 0; n2 < by; ++n2) {
            int n3 = dataInputStream.readByte();
            MovingObject.ai_transitions[n2] = new byte[n3][];
            MovingObject.ai_commands[n2] = new short[n3][5];
            for (n = 0; n < n3; ++n) {
                MovingObject.ai_transitions[n2][n] = OObject.readLUT(dataInputStream);
                for (int i = 0; i < 5; ++i) {
                    MovingObject.ai_commands[n2][n][i] = dataInputStream.readByte();
                    if (ai_commands[n2][n][i] >= 0) continue;
                    short[] sArray = ai_commands[n2][n];
                    int n4 = i;
                    sArray[n4] = (short)(sArray[n4] + 256);
                }
            }
        }
    }

    public static final void resetLevelStatistics(InGame inGame) {
        for (int i = 0; i < 7; ++i) {
            int n = i;
            GbulletsFired[n] = GbulletsFired[n] + bulletsFired[i];
            int n2 = i;
            GbulletsHits[n2] = GbulletsHits[n2] + bulletsHits[i];
            MovingObject.bulletsHits[i] = 0;
            MovingObject.bulletsFired[i] = 0;
        }
        totalScore += playerScore;
        playerScore = 0L;
        totalPlayingTime += InGame.playingTime;
        InGame.playingTime = 0L;
        s_hitPointsLost = inGame.localPlayer.hitPointsLost;
        s_hitPointsTaken = inGame.localPlayer.hitPointsTaken;
        s_kills = inGame.localPlayer.kills;
        s_deaths = inGame.localPlayer.deaths;
        s_frag_a = inGame.frags_team_a;
        s_frag_b = inGame.frags_team_b;
        s_flag_a = inGame.skirmish_flag_cnt_a;
        s_flag_b = inGame.skirmish_flag_cnt_b;
    }

    public static final void resetAllStatistics() {
        for (int i = 0; i < 7; ++i) {
            MovingObject.GbulletsHits[i] = 0;
            MovingObject.GbulletsFired[i] = 0;
        }
        totalScore = 0L;
        totalPlayingTime = 0L;
    }

    public static final long getBulletsCnt(boolean bl) {
        int[] nArray = bl ? bulletsHits : bulletsFired;
        long l = 0L;
        for (int i = 0; i < nArray.length; ++i) {
            l += (long)nArray[i];
        }
        return l;
    }

    public static final void createBullet(MovingObject movingObject, InGame inGame, byte by, int n, int n2, int n3) {
        MovingObject movingObject2 = new MovingObject();
        movingObject2.parent = movingObject;
        movingObject2.type = by;
        movingObject2.isAnimated = true;
        movingObject2.TEAM = movingObject != null ? movingObject.TEAM : (byte)0;
        int n4 = 0;
        int n5 = 0;
        if (movingObject != null && movingObject == inGame.localPlayer) {
            byte by2 = movingObject2.parent_weapon = ((Agent)movingObject).curWeapon;
            bulletsFired[by2] = bulletsFired[by2] + 1;
        }
        switch (by) {
            case 15: {
                movingObject2.bullet_energy = 45;
                movingObject2.frm_body = DeviceImage.sprites[78];
                movingObject2.static_frame = (byte)5;
                n4 = 8;
                n5 = 8;
                movingObject2.life_adder = -1;
                movingObject2.bullet_speedY = -500;
                movingObject2.isAnimated = false;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                int n6 = by - 9;
                movingObject2.isGravityApplicable = false;
                movingObject2.bullet_energy = b_enemy_energy[n6];
                movingObject2.bullet_speedX = b_enemy_speed[n6] << 10;
                movingObject2.bullet_speedY = 0;
                movingObject2.frm_body = DeviceImage.sprites[26];
                movingObject2.initFrames((byte)21);
                n4 = 6;
                n5 = 6;
                movingObject2.life_adder = b_enemy_adder[n6];
                movingObject2.type = (byte)9;
                movingObject2.anime_delay = 100L;
                break;
            }
            case 14: {
                movingObject2.bullet_energy = 15;
                movingObject2.bullet_speedX = 6144;
                movingObject2.bullet_speedY = 10240;
                movingObject2.speedY = 10240;
                if (movingObject != null && movingObject.mo_type == 12) {
                    movingObject2.bullet_speedX = 6144;
                    movingObject2.bullet_speedY = 6144;
                    movingObject2.speedY = 6144;
                    ((Agent)movingObject).boss_fires_remaining = (byte)(((Agent)movingObject).boss_fires_remaining - 1);
                }
                movingObject2.frm_body = DeviceImage.sprites[27];
                movingObject2.initFrames((byte)22);
                n4 = 8;
                n5 = 8;
                movingObject2.life_adder = 0;
                movingObject2.anime_delay = 150L;
                break;
            }
            case 0: {
                movingObject2.isGravityApplicable = false;
                movingObject2.bullet_energy = 30;
                movingObject2.bullet_speedX = 10240;
                movingObject2.bullet_speedY = 0;
                movingObject2.frm_body = DeviceImage.sprites[15];
                movingObject2.initFrames((byte)23);
                n4 = 13;
                n5 = 4;
                movingObject2.life_adder = -20;
                break;
            }
            case 1: {
                movingObject2.isGravityApplicable = false;
                movingObject2.bullet_energy = GameStage.CHEATMODE_MEGAWEAPON ? 900 : 20;
                movingObject2.bullet_speedX = 10240;
                movingObject2.bullet_speedY = 0;
                movingObject2.frm_body = DeviceImage.sprites[16];
                movingObject2.initFrames((byte)24);
                n4 = 13;
                n5 = 4;
                movingObject2.life_adder = -20;
                break;
            }
            case 2: {
                movingObject2.isGravityApplicable = false;
                movingObject2.bullet_energy = 45;
                movingObject2.bullet_speedX = 10240;
                movingObject2.bullet_speedY = 0;
                movingObject2.frm_body = DeviceImage.sprites[17];
                movingObject2.initFrames((byte)25);
                n4 = 13;
                n5 = 4;
                --n2;
                movingObject2.life_adder = -20;
                break;
            }
            case 3: {
                movingObject2.isTraversable = true;
                movingObject2.isGravityApplicable = false;
                movingObject2.bullet_energy = 5;
                movingObject2.bullet_speedX = 7168;
                movingObject2.bullet_speedY = 0;
                movingObject2.frm_body = DeviceImage.sprites[29];
                movingObject2.initFrames((byte)26);
                n4 = 16;
                n5 = 16;
                n2 += 4;
                n = n3 == 1 ? (n += 3) : (n -= 3);
                movingObject2.life_adder = 0;
                movingObject2.anime_delay = 50L;
                movingObject2.killOnGround = false;
                break;
            }
            case 4: {
                movingObject2.bullet_energy = 50;
                movingObject2.bullet_speedX = 6144;
                if (movingObject == null) {
                    movingObject2.bullet_speedX = 2048;
                }
                movingObject2.bullet_speedY = 7168;
                movingObject2.speedY = 7168;
                movingObject2.frm_body = DeviceImage.sprites[36];
                movingObject2.initFrames((byte)27);
                movingObject2.cur_frm = n3 == 1 ? movingObject2.myFrames[0] : movingObject2.myFrames[1];
                n4 = 8;
                n5 = 8;
                movingObject2.life_adder = 0;
                break;
            }
            case 5: 
            case 6: {
                movingObject2.isTraversable = true;
                int n7 = 2;
                int n8 = 2;
                movingObject2.anime_delay = 150L;
                if (by == 6) {
                    movingObject2.anime_delay = movingObject != null ? 50L : 200L;
                    n7 = 5;
                    n8 = 3;
                    MovingObject.createPart(inGame, n << 10, n2 << 10, 60, 60, 255, 255, 0, 129, 129, 129, 30);
                    MovingObject.createPart(inGame, n << 10, n2 << 10, 60, 60, 255, 0, 0, 129, 129, 129, 30);
                } else {
                    MovingObject.createBullet(movingObject, inGame, (byte)6, n, n2, 0);
                }
                movingObject2.isGravityApplicable = false;
                movingObject2.bullet_energy = 1;
                movingObject2.bullet_speedX = MovingObject.rand(n7) << 10;
                movingObject2.bullet_speedY = MovingObject.rand(n8) + n8 / 2 << 10;
                movingObject2.frm_body = DeviceImage.sprites[29];
                movingObject2.initFrames((byte)28);
                n4 = 16;
                n5 = 16;
                movingObject2.life_adder = 0;
                movingObject2.killOnGround = false;
                break;
            }
            case 7: {
                movingObject2.isGravityApplicable = false;
                movingObject2.bullet_energy = movingObject != null && movingObject.mo_type == 5 ? 20 : 50;
                movingObject2.bullet_speedX = 7168;
                movingObject2.bullet_speedY = 0;
                movingObject2.frm_body = DeviceImage.sprites[75];
                movingObject2.initFrames((byte)29);
                n4 = 8;
                n5 = 8;
                movingObject2.life_adder = 0;
                break;
            }
            case 8: {
                movingObject2.bullet_energy = 60;
                movingObject2.bullet_speedX = movingObject != null && movingObject.mo_type == 12 ? MovingObject.randAbs(6) + 4 << 10 : 6144;
                movingObject2.bullet_speedY = 3548;
                movingObject2.speedY = 3548;
                movingObject2.frm_body = DeviceImage.sprites[19];
                movingObject2.initFrames((byte)30);
                n4 = 8;
                n5 = 8;
                movingObject2.life_adder = 0;
            }
        }
        movingObject2.curFrame = 0;
        if (movingObject2.myFrames != null) {
            movingObject2.cur_frm = movingObject2.myFrames[3];
            if (n3 == 1) {
                n -= n4;
                movingObject2.bullet_speedX = -movingObject2.bullet_speedX;
                movingObject2.cur_frm = movingObject2.myFrames[2];
            }
        }
        if (n <= 0 || n2 + n5 / 2 <= 0 || n + n4 >= inGame.mapWidth) {
            movingObject2 = null;
            return;
        }
        movingObject2.init((byte)3, n, n2 - n5 / 2, n4, n5, false);
        movingObject2.container = movingObject != null ? (movingObject.container == inGame.team_a ? inGame.bullets_a : inGame.bullets_b) : inGame.bullets_a;
        movingObject2.container.addElementBefore(movingObject2, null);
        if (movingObject != null && movingObject.mo_type == 1 && ((Agent)movingObject).specialMode == 1) {
            movingObject2.bullet_energy *= 4;
        }
    }

    static {
        bulletsFired = new int[7];
        bulletsHits = new int[7];
        GbulletsFired = new int[7];
        GbulletsHits = new int[7];
        rand = new Random();
        bots_behaviours = new byte[9];
        AIR_STEP_X = 2048;
        ROCKET_TIME = 0L;
    }
}

