/*
 * Decompiled with CFR 0.152.
 */
package subjects;

import com.jarbull.efw.game.EFSprite;
import com.jarbull.efw.game.TimerHolder;
import constants.Data;
import java.util.Timer;
import java.util.TimerTask;
import utilities.ChaoticMove;

public class Enemy
extends EFSprite {
    private boolean flagMoveEnemy = false;
    private int x_point;
    private int y_point;
    private int x_start;
    private int y_start;
    private int x_finish;
    private int y_finish;
    private ChaoticMove chaoticMove;
    private int _vx;
    private int _vy;
    private int id;
    private Timer timer;
    private int i = 1;
    private int number = 0;

    public Enemy(String ImagePath, int x_start, int y_start, int x_finish, int y_finish) {
        super(ImagePath, 24, 24);
        this.x_start = x_start;
        this.y_start = y_start;
        this.x_finish = x_finish;
        this.y_finish = y_finish;
        this.chaoticMove = new ChaoticMove();
        this._vx = 0;
        this._vy = 0;
        this.switchOnEnemyTimer();
    }

    public void setMoveEnemy(boolean flagMove) {
        this.flagMoveEnemy = flagMove;
    }

    public boolean getMoveEnemy() {
        return this.flagMoveEnemy;
    }

    public void setChaoticMovement() {
        this.setXYPosition();
        if (this.getMoveEnemy()) {
            if (this.chaoticMove.getFlagRotate()) {
                this._vx = this.chaoticMove.getX();
                this._vy = this.chaoticMove.getY();
            }
            if (this.x_point < this.x_start + 20) {
                this._vx = -1 * this._vx;
            } else if (this.x_point > this.x_finish - 40) {
                this._vx = -1 * this._vx;
            }
            if (this.y_point < this.y_start + 20) {
                this._vy = -1 * this._vy;
            } else if (this.y_point > this.y_finish - 40) {
                this._vy = -1 * this._vy;
            }
            if (this._vx == 0 && this._vy < 0) {
                this.setFrame(0);
            }
            if (this._vx > 0 && this._vy < 0) {
                this.setFrame(1);
            }
            if (this._vx > 0 && this._vy == 0) {
                this.setFrame(2);
            }
            if (this._vx > 0 && this._vy > 0) {
                this.setFrame(3);
            }
            if (this._vx == 0 && this._vy > 0) {
                this.setFrame(4);
            }
            if (this._vx < 0 && this._vy > 0) {
                this.setFrame(5);
            }
            if (this._vx < 0 && this._vy == 0) {
                this.setFrame(6);
            }
            if (this._vx < 0 && this._vy < 0) {
                this.setFrame(7);
            }
            this.move(this._vx, this._vy);
        }
    }

    private void setXYPosition() {
        this.x_point = this.getX();
        this.y_point = this.getY();
    }

    public void setEnemyPosition(int i, int currentLevel) {
        this.setPosition(Data.X_ENEMIES_POSITION[currentLevel][i] / 24 * 20, Data.Y_ENEMIES_POSITION[currentLevel][i] / 24 * 20);
    }

    public void setChaoticSpeed(int x) {
        this.chaoticMove.setChaoticSpeed(x);
    }

    public int getChaoticSpeed() {
        return this.chaoticMove.getChaoticSpeed();
    }

    public int getXCenterEnemy() {
        return this.getX() + this.getWidth() / 2;
    }

    public int getYCenterEnemy() {
        return this.getY() + this.getHeight() / 2;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getID() {
        return this.id;
    }

    public void setChaoticFlagRotate(boolean flag) {
        this.chaoticMove.setFlagRotate(flag);
    }

    public boolean getChaoticFlagRotate() {
        return this.chaoticMove.getFlagRotate();
    }

    public void setObjectsNumber(int number) {
        this.number = number;
    }

    private void switchOnEnemyTimer() {
        this.timer = new Timer();
        TimerHolder.getInstance().addTimer(this.timer);
        this.timer.schedule(new TimerTask(){

            public void run() {
                if (Enemy.this.i == Enemy.this.getID()) {
                    Enemy.this.setChaoticFlagRotate(true);
                }
                Enemy.this.i++;
                if (Enemy.this.i == Enemy.this.number + 1) {
                    Enemy.this.i = 0;
                }
            }
        }, 0L, 500L);
    }

    public void switchOffEnemyTimer() {
        this.timer.cancel();
    }
}

