/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Enemy
extends GameInterface {
    public static GameEngine engine;
    GameMap map;
    byte type;
    int liftValue;
    int origLiftValue;
    int hurtTime = 1;
    public static byte lastStatus;
    public static byte nextStatus;
    public static final byte DT_MOGUGUAI = 0;
    public static final byte DT_XIAOCHOUGUAI = 1;
    public static final byte DT_BINGGANGUAI = 2;
    public static final byte DT_LANYIGUAI = 3;
    public static final byte DT_HESEXIAOCHOUGUAI = 4;
    public static final byte DT_MAOMAOCHONGGUAI = 5;
    public static final byte DT_DAZHANGYU = 6;
    public static final byte DT_LANSEFEINIAOGUAI = 7;
    public static final byte DT_HONGSEQIANTINGGUAI = 8;
    public static final byte DT_LUOXUANWONIU = 9;
    public static final byte DT_SHUIGUAI = 10;
    public static final byte DT_SHUIMU = 11;
    public static final byte DT_XIAOLVJI = 12;
    public static final byte DT_HUANGSEQIANTING = 13;
    public static final byte DT_QIANSHUIYUAN = 14;
    public static final byte DT_KEDOU = 15;
    public static final byte DT_ZHANGYU = 16;
    public static final byte DT_HEISEQIPAO = 17;
    public static final byte DT_FEIXINGKULOU = 18;
    public static final byte DT_KAIJIABING = 19;
    public static final byte DT_HEISEDAODAN = 20;
    public static final byte DT_LANMAOZIFEINIAO = 21;
    public static final byte DT_ZHIZHU = 22;
    public static final byte DT_TANHUANGREN = 23;
    public static final byte DT_QINGTIANWAWA = 24;
    public static final byte DT_TUDOUREN = 25;
    public static final byte DT_JINBIGUAI = 26;
    public static final byte DT_DUYANGUAI = 27;
    public static final byte DT_LVTOUXIAOGUI = 28;
    public static final byte DT_HUDIE = 29;
    public static final byte DT_SHITOU = 30;
    public static final byte DT_ZHADANWANG = 31;
    public static final byte DT_FEITING = 32;
    int enemyX = -1;
    int enemyY = -1;
    boolean visiable = true;
    int addScore;
    byte curIndex;
    int isAddEffect;
    int firstCurIndex;
    int secondCurIndex;
    int thirdCurIndex;
    public byte sendIndex = 0;
    public static final byte SLOW_SPEED = 4;
    public static final byte MID_SPEED = 6;
    public static final byte QUICK_SPEED = 8;
    public static final byte MORE_QUICK_SPEED = 10;
    public static final int EATE_GLASS = 150;
    public static final byte ADD_GLASS = 50;
    public static final byte THROW_BOMB = 10;
    public static final int PUSH_ROLE = 100;
    public static final int PUT_STONE = 200;
    public int useSkillTime = 0;
    int firstUpCurIndex;
    int firstDownIndex;
    int firstLeftIndex;
    int firstRightIndex;
    int secondUpIndex;
    int secondDownIndex;
    int secondLeftIndex;
    int secondRightIndex;
    int thirdUpIndex;
    int thirdDownIndex;
    int thirdLeftIndex;
    int thirdRightIndex;
    int[][] roleCilpData_fire = new int[][]{{99, 24, 18, 18}, {72, 0, 24, 24}, {96, 0, 24, 24}, {24, 24, 24, 24}, {48, 0, 24, 24}, {48, 48, 24, 24}, {48, 24, 24, 24}, {72, 24, 24, 24}, {96, 48, 24, 24}, {72, 48, 24, 24}, {24, 3, 24, 18}, {22, 60, 24, 12}, {0, 5, 18, 24}, {0, 36, 12, 24}, {13, 29, 10, 24}, {19, 3, 5, 18}, {17, 61, 5, 10}, {23, 49, 24, 10}, {0, 0, 18, 5}, {1, 31, 10, 5}};
    int[][] indent_fire = new int[][]{{-3, -3, -3, -3}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, -3, -3}, {0, 0, -6, -6}, {-3, -3, 0, 0}, {-6, -6, 0, 0}, {-14, 0, 0, 0}, {-19, 0, -3, -3}, {-19, 0, -7, -7}, {0, 0, -14, 0}, {-3, -3, -19, 0}, {-7, -7, -19, 0}};
    int runTime = 0;
    boolean hitOther = false;
    byte firstIndex = 0;
    byte secondIndex = 0;
    byte thirdIndex = 0;
    short addTime = 0;
    boolean beginSkip = true;
    public static final byte maxSound = 7;
    public static final byte maxStone = 7;
    boolean add = true;
    int flySpan = 20;
    int upFlyTime = 0;
    int lineFlySpan = 25;
    Vector dirs = new Vector();
    Utils u1 = new Utils(0);
    Utils u2 = new Utils(2);
    Utils u3 = new Utils(3);
    Utils u4 = new Utils(1);
    short bombSum = 0;
    int fireCount = 0;
    int kind = 0;
    public static final byte putBombRank = 34;
    int putTime = 1;
    int addSpeedTime = 0;
    byte[][] indent_moguguai = new byte[][]{{0, 24, 0, -32}, {1, 26, 0, -34}, {0, 24, 0, -35}, {-5, 20, 0, -33}, {0, 23, 0, -34}};
    int[][] cilpData_maomaochongguai = new int[][]{{17, 0, 32, 52}, {61, 3, 32, 48}, {105, 4, 32, 46}, {17, 64, 31, 52}, {61, 67, 32, 48}, {104, 69, 33, 46}, {10, 132, 63, 32}, {80, 130, 58, 34}, {143, 131, 54, 38}};
    int[][] cilpData_boss = new int[][]{{0, 2, 211, 273}, {228, 3, 211, 273}, {456, 5, 192, 270}, {660, 1, 193, 274}, {872, 1, 194, 274}, {1079, 0, 193, 274}, {1290, 2, 192, 272}, {10, 332, 212, 260}, {249, 383, 202, 210}, {477, 360, 232, 230}, {724, 359, 215, 231}, {965, 353, 193, 237}, {1179, 368, 194, 224}, {1387, 336, 193, 254}, {24, 640, 195, 255}, {240, 641, 194, 254}, {462, 640, 225, 255}, {703, 662, 217, 234}, {927, 667, 217, 229}, {1153, 667, 217, 229}};
    int[][] indent_bingganguai = new int[][]{{0, 27, 0, -42}, {0, 27, 0, -39}, {0, 26, 0, -57}, {0, 27, -1, -67}, {0, 26, 0, -41}, {0, 27, 0, -38}, {0, 26, 0, -56}};
    byte[][] indent_xiaochouguai = new byte[][]{{0, 30, 0, -49}, {2, 33, -3, -54}, {0, 30, 0, -53}, {0, 30, 0, -51}, {0, 31, 0, -53}};
    int[][] indent_huangseqianting = new int[][]{{0, 26, 0, -30}, {0, 26, 0, -32}, {0, 26, 0, -35}, {1, 27, 0, -29}};
    int[][] indent_qianshuiyuan = new int[][]{{0, 34, 0, -32}, {0, 34, 0, -31}, {0, 34, 0, -37}, {-2, 36, 0, -33}};
    int[][] indent_dazhangyu = new int[][]{{48, 72, 86, 48}, {61, 74, 61, 24}, {49, 83, 59, 48}, {50, 87, 58, 59}, {62, 96, 59, 26}};
    int[][] indent_hudie = new int[][]{{36, 91, -18, -100}, {26, 81, -15, -106}, {13, 68, -14, -112}, {26, 81, -15, -106}};
    int[][] indent_shitou = new int[][]{{25, 115, -15, -105}, {36, 126, -7, -107}, {41, 131, 0, -113}};
    int[][] indent_zhadanwang = new int[][]{{0, 74, 0, -67}, {0, 74, -7, -66}, {0, 74, -1, -67}, {0, 74, -7, -61}, {0, 74, 0, -66}, {0, 74, -6, -63}, {0, 74, -2, -66}, {0, 74, -6, -68}, {0, 74, -2, -66}, {0, 66, 0, -71}, {12, 70, 0, -70}, {0, 66, 0, -73}, {-9, 54, 0, -70}, {0, 66, 0, -73}, {0, 74, 0, -67}, {0, 74, 0, -66}, {0, 74, 0, -65}, {7, 74, 0, -67}, {7, 74, 0, -67}, {7, 74, 0, -67}, {14, 87, 6, -69}};
    int[][] indent_feiting = new int[][]{{0, 112, 0, -137}, {0, 112, 0, -137}, {1, 0, 4, 0, -4}, {1, 3, 7, -1, -6}, {4, 10, -5, -7}, {8, 16, -7, -14}, {9, 17, -9, -16}, {11, 19, -11, -18}};
    int[][] roleCilpData_cloud = new int[][]{{0, 2, 46, 28}, {56, 2, 48, 30}, {115, 2, 56, 38}};
    int[][] indent_cloud = new int[][]{{13, 12, -3, -19}, {22, 23, -6, -36}, {25, 28, -7, -31}, {24, 27, -6, -28}};
    boolean putStons = false;
    int[] loca = new int[]{-1, -1};
    boolean skipOver = true;
    int sTime = 0;
    short upSkipTime = 0;
    int vSpan = 30;
    int span = 20;
    boolean indexIsZero = true;
    int stopTime = 0;
    int stopx = 0;
    int stopy = 0;

    public Enemy() {
    }

    public Enemy(GameEngine enginer) {
        engine = enginer;
        Math.abs(0);
    }

    public void init(short[] data) {
        this.type = (byte)data[0];
        this.x = data[1];
        this.y = data[2];
        this.dir = (byte)data[3];
        this.liftValue = data[4];
        if (this.liftValue == 1) {
            this.addScore = 100;
        }
        if (this.liftValue == 2) {
            this.addScore = 200;
        }
        if (this.liftValue == 3) {
            this.addScore = 300;
        }
        if (this.liftValue > 3) {
            this.addScore = 1000;
        }
        this.origLiftValue = this.liftValue;
        switch (data[5]) {
            case 1: {
                this.speed = 4;
                break;
            }
            case 2: {
                this.speed = 6;
                break;
            }
            case 3: {
                this.speed = 8;
                break;
            }
            case 4: {
                this.speed = 10;
            }
        }
        this.curStatus = 1;
        if (this.type == 30) {
            this.curStatus = (byte)5;
        }
        this.index = 0;
        this.w = 24;
        this.h = 24;
        if (this.type == 29) {
            this.w = 96;
            this.h = 24;
        }
        if (this.type == 6) {
            this.w = 168;
            this.h = 48;
        }
        if (this.type == 30) {
            this.w = 168;
            this.h = 48;
        }
        if (this.type == 32) {
            this.w = 120;
            this.h = 48;
        }
    }

    public void move_moGuGuai() {
        switch (this.curStatus) {
            case 0: {
                this.motion = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.curStatus = 1;
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 1, 2, 3};
                switch (this.dir) {
                    case 2: {
                        if (this.type == 26) {
                            this.enemyMove_hesexiaochou(0, this.speed);
                            break;
                        }
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        if (this.type == 26) {
                            this.enemyMove_hesexiaochou(0, -this.speed);
                            break;
                        }
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        if (this.type == 26) {
                            this.enemyMove_hesexiaochou(-this.speed, 0);
                            break;
                        }
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        if (this.type == 26) {
                            this.enemyMove_hesexiaochou(this.speed, 0);
                            break;
                        }
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 2: {
                this.motion = new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 4, 0, 4, 0, 4, 0, 4, 0};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void addSpeed() {
        block7: {
            block6: {
                block5: {
                    if (this.type != 16) break block5;
                    if (GameEngine.nextInt(0, 20) % 2 == 0 && !this.hitOther) break block6;
                }
                if ((this.type == 16 || !this.hitOtherEnemy() || this.runTime != 0) && (!this.hitRole() || this.runTime != 0)) break block7;
            }
            this.hitOther = true;
            this.speed = 10;
        }
        if (this.hitOther && this.type != 16) {
            ++this.runTime;
            if (this.runTime > 40) {
                this.runTime = 0;
                this.hitOther = false;
                this.speed = 6;
            }
        }
    }

    boolean hitOtherEnemy() {
        Vector enemys = Enemy.engine.enemy;
        int i = 0;
        while (i < enemys.size()) {
            int ex = ((Enemy)enemys.elementAt((int)i)).x;
            int ey = ((Enemy)enemys.elementAt((int)i)).y;
            if (enemys.elementAt(i) != this && ex >= this.x && ex <= this.x + this.w && ey <= this.y && ey >= this.y - this.h) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean makeBombMissing(int mx, int my) {
        if (this.useSkillTime >= 10) {
            this.useSkillTime = 0;
            if (my < 0 && this.checkBoun_lansefeiniaoguai(this.x + this.w / 2, this.y - this.h - 1)) {
                this.curStatus = (byte)2;
                Boun bomb = this.getBomb();
                if (bomb != null) {
                    bomb.fly = true;
                }
                return true;
            }
            if (my > 0 && this.checkBoun_lansefeiniaoguai(this.x + this.w / 2, this.y + 1)) {
                this.curStatus = (byte)2;
                Boun bomb = this.getBomb();
                if (bomb != null) {
                    bomb.fly = true;
                }
                return true;
            }
            if (mx < 0 && this.checkBoun_lansefeiniaoguai(this.x - 1, this.y - this.h / 2)) {
                this.curStatus = (byte)2;
                Boun bomb = this.getBomb();
                if (bomb != null) {
                    bomb.fly = true;
                }
                return true;
            }
            if (mx > 0 && this.checkBoun_lansefeiniaoguai(this.x + this.w + 1, this.y - this.h / 2)) {
                this.curStatus = (byte)2;
                Boun bomb = this.getBomb();
                if (bomb != null) {
                    bomb.fly = true;
                }
                return true;
            }
        }
        return false;
    }

    public Boun getBomb() {
        Vector bombs = Enemy.engine.bouns;
        int i = 0;
        while (i < bombs.size()) {
            Boun bomb = (Boun)bombs.elementAt(i);
            if (bomb.state == 0 && bomb.property == 0) {
                return bomb;
            }
            ++i;
        }
        return null;
    }

    public void move_xiaoChouGuai() {
        switch (this.curStatus) {
            case 0: {
                this.motion = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 1: {
                switch (this.dir) {
                    case 2: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 8) {
                            this.enemyMove(0, this.speed);
                        }
                        if (this.type == 1 || this.type == 27) {
                            this.enemyMove_hesexiaochou(0, this.speed);
                        }
                        if (this.type != 27) break;
                        this.makeBombMissing(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 8) {
                            this.enemyMove(0, -this.speed);
                        }
                        if (this.type == 1 || this.type == 27) {
                            this.enemyMove_hesexiaochou(0, -this.speed);
                        }
                        if (this.type != 27) break;
                        this.makeBombMissing(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 8) {
                            this.enemyMove(-this.speed, 0);
                        }
                        if (this.type == 1 || this.type == 27) {
                            this.enemyMove_hesexiaochou(-this.speed, 0);
                        }
                        if (this.type != 27) break;
                        this.makeBombMissing(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 8) {
                            this.enemyMove(this.speed, 0);
                        }
                        if (this.type == 1 || this.type == 27) {
                            this.enemyMove_hesexiaochou(this.speed, 0);
                        }
                        if (this.type != 27) break;
                        this.makeBombMissing(this.speed, 0);
                        break;
                    }
                }
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 4, 0, 4, 0, 4, 0};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 2: {
                this.motion = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_bingganguai() {
        switch (this.curStatus) {
            case 1: {
                switch (this.dir) {
                    case 2: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 23 || this.type == 22) {
                            this.enemyMove_hesexiaochou(0, this.speed);
                        }
                        if (this.type != 2) break;
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 23 || this.type == 22) {
                            this.enemyMove_hesexiaochou(0, -this.speed);
                        }
                        if (this.type != 2) break;
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 23 || this.type == 22) {
                            this.enemyMove_hesexiaochou(-this.speed, 0);
                        }
                        if (this.type != 2) break;
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                        if (this.type == 23 || this.type == 22) {
                            this.enemyMove_hesexiaochou(this.speed, 0);
                        }
                        if (this.type != 2) break;
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{4, 4, 5, 5, 6, 6};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    --this.liftValue;
                    ++this.hurtTime;
                    if (this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_lanyiguai() {
        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 1, 1};
        switch (this.curStatus) {
            case 1: {
                switch (this.dir) {
                    case 2: {
                        if (this.type == 24) {
                            this.enemyMove_hesexiaochou(0, this.speed);
                            break;
                        }
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        if (this.type == 24) {
                            this.enemyMove_hesexiaochou(0, -this.speed);
                            break;
                        }
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        if (this.type == 24) {
                            this.enemyMove_hesexiaochou(-this.speed, 0);
                            break;
                        }
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        if (this.type == 24) {
                            this.enemyMove_hesexiaochou(this.speed, 0);
                            break;
                        }
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 3, 0, 3, 0, 3};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.enemyX = this.x;
                    this.enemyY = this.y;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void produceGlass() {
        GameMap map = Enemy.engine.map;
        int dir1 = this.getDirs(0, this.speed);
        int dir2 = this.getDirs(0, -this.speed);
        int dir3 = this.getDirs(this.speed, 0);
        int dir4 = this.getDirs(-this.speed, 0);
        if (dir1 == -1 && dir2 == -1 && dir3 == -1 && dir4 == -1 || this.x == 0 && this.y == 72 || this.x == 0 && this.y == 96 || this.x == 24 && this.y == 72) {
            return;
        }
        if (this.useSkillTime % 50 == 0 && this.visiable) {
            MyGameCanvas cfr_ignored_0 = Enemy.engine.canvas;
            MyGameCanvas cfr_ignored_1 = Enemy.engine.canvas;
            if (MyGameCanvas.gameStatus == 7 && this.curStatus != 3) {
                this.useSkillTime = 0;
                int gx = this.x / GameMap.tileWidth * GameMap.tileWidth;
                int gy = this.y / GameMap.tileHight * GameMap.tileHight;
                int[] newData = new int[]{1, gx, gy, 0, 24, 24, 0};
                int[][] dexData = map.getNewDexData(GameMap.dexData, newData);
                GameMap.dexData = dexData;
            }
        }
    }

    public void move_lansefeiniaoguai() {
        ++this.useSkillTime;
        switch (this.curStatus) {
            case 1: {
                switch (this.dir) {
                    case 2: {
                        this.motion = new byte[]{0, 0, 1, 1, 0, 0, 2, 2};
                        if (this.type == 7 || this.type == 20) {
                            this.enemyMove_hesexiaochou(0, this.speed);
                            if (this.type != 7) break;
                            this.makeBombMissing(0, this.speed);
                            break;
                        }
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.motion = new byte[]{4, 4, 5, 5, 4, 4, 6, 6};
                        if (this.type == 7 || this.type == 20) {
                            this.enemyMove_hesexiaochou(0, -this.speed);
                            if (this.type != 7) break;
                            this.makeBombMissing(0, -this.speed);
                            break;
                        }
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{7, 7, 8, 8, 7, 7, 9, 9};
                        if (this.type == 7 || this.type == 20) {
                            this.enemyMove_hesexiaochou(-this.speed, 0);
                            if (this.type != 7) break;
                            this.makeBombMissing(-this.speed, 0);
                            break;
                        }
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{7, 7, 8, 8, 7, 7, 9, 9};
                        if (this.type == 7 || this.type == 20) {
                            this.enemyMove_hesexiaochou(this.speed, 0);
                            if (this.type != 7) break;
                            this.makeBombMissing(this.speed, 0);
                            break;
                        }
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 2: {
                switch (this.dir) {
                    case 0: {
                        this.motion = new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
                        break;
                    }
                    case 2: {
                        this.motion = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
                    }
                }
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 3, 0, 3, 0, 3, 0, 3};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    --this.liftValue;
                    ++this.hurtTime;
                    if (this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_hesexiaochouguai() {
        ++this.useSkillTime;
        switch (this.curStatus) {
            case 1: {
                switch (this.dir) {
                    case 2: {
                        this.motion = new byte[]{0, 0, 1, 1, 2, 2, 1, 1};
                        if (this.type == 4 || this.type == 18) {
                            this.enemyMove_hesexiaochou(0, this.speed);
                        }
                        if (this.type != 12) break;
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.motion = new byte[]{7, 7, 8, 8, 9, 9, 8, 8};
                        if (this.type == 4 || this.type == 18) {
                            this.enemyMove_hesexiaochou(0, -this.speed);
                        }
                        if (this.type != 12) break;
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{4, 4, 5, 5, 6, 6, 5, 5};
                        if (this.type == 4 || this.type == 18) {
                            this.enemyMove_hesexiaochou(-this.speed, 0);
                        }
                        if (this.type != 12) break;
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{4, 4, 5, 5, 6, 6, 5, 5};
                        if (this.type == 4 || this.type == 18) {
                            this.enemyMove_hesexiaochou(this.speed, 0);
                        }
                        if (this.type != 12) break;
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{3, 0, 3, 0, 3, 0, 3, 0, 3, 0};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    --this.liftValue;
                    ++this.hurtTime;
                    if (this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                    if (this.type == 4) {
                        this.curStatus = (byte)2;
                    }
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 2: {
                switch (this.dir) {
                    case 2: {
                        this.motion = new byte[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
                        break;
                    }
                    case 0: {
                        this.motion = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9};
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6};
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    if (this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                if (this.type != 4 || this.curIndex != 2 && this.curIndex != 9 && this.curIndex != 6) break;
                this.fireThings(this.dir);
                break;
            }
        }
    }

    public void fireThings(int dir) {
        int checkx = this.x;
        int checky = this.y;
        int minx = this.x / GameMap.tileWidth * GameMap.tileWidth;
        int maxx = this.x / GameMap.tileWidth * GameMap.tileWidth + GameMap.tileWidth;
        int miny = this.y / GameMap.tileHight * GameMap.tileHight;
        int maxy = this.y / GameMap.tileHight * GameMap.tileHight + GameMap.tileHight;
        if (this.x % GameMap.tileWidth != 0) {
            checkx = Math.abs(this.x - minx) <= GameMap.tileWidth / 2 ? minx : maxx;
        }
        if (this.y % GameMap.tileHight != 0) {
            checky = Math.abs(this.y - miny) <= GameMap.tileHight / 2 ? miny : maxy;
        }
        switch (dir) {
            case 0: {
                if (!this.canThrough(checkx + GameMap.tileWidth / 2, checky - GameMap.tileHight - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx, checky - GameMap.tileHight);
                this.drawFire_first(0, checkx, checky - GameMap.tileHight, this.firstUpCurIndex, 1);
                if (this.canThrough(checkx + GameMap.tileWidth / 2, checky - 2 * GameMap.tileHight - GameMap.tileHight / 2)) {
                    this.fireRoleOrBomb(checkx, checky - 2 * GameMap.tileHight);
                    this.drawFire_first(0, checkx, checky - 2 * GameMap.tileHight, this.secondUpIndex, 2);
                }
                if (!this.canThrough(checkx + GameMap.tileWidth / 2, checky - 3 * GameMap.tileHight - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx, checky - 3 * GameMap.tileHight);
                this.drawFire_first(0, checkx, checky - 3 * GameMap.tileHight, this.thirdUpIndex, 3);
                break;
            }
            case 2: {
                if (!this.canThrough(checkx + GameMap.tileWidth / 2, checky + GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx, checky + GameMap.tileHight);
                this.drawFire_first(2, checkx, checky + GameMap.tileHight, this.firstDownIndex, 1);
                if (!this.canThrough(checkx + GameMap.tileWidth / 2, checky + 2 * GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx, checky + 2 * GameMap.tileHight);
                this.drawFire_first(2, checkx, checky + 2 * GameMap.tileHight, this.secondDownIndex, 2);
                if (!this.canThrough(checkx + GameMap.tileWidth / 2, checky + 3 * GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx, checky + 3 * GameMap.tileHight);
                this.drawFire_first(2, checkx, checky + 3 * GameMap.tileHight, this.thirdDownIndex, 3);
                break;
            }
            case 3: {
                if (!this.canThrough(checkx - GameMap.tileWidth / 2, checky - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx - GameMap.tileWidth, checky);
                this.drawFire_first(3, checkx - GameMap.tileWidth, checky, this.firstLeftIndex, 1);
                if (!this.canThrough(checkx - GameMap.tileWidth - GameMap.tileWidth / 2, checky - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx - 2 * GameMap.tileWidth, checky);
                this.drawFire_first(3, checkx - 2 * GameMap.tileWidth, checky, this.secondLeftIndex, 2);
                if (!this.canThrough(checkx - 2 * GameMap.tileWidth - GameMap.tileWidth / 2, checky - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx - 3 * GameMap.tileWidth, checky);
                this.drawFire_first(3, checkx - 3 * GameMap.tileWidth, checky, this.thirdLeftIndex, 3);
                break;
            }
            case 1: {
                if (!this.canThrough(checkx + GameMap.tileWidth + GameMap.tileWidth / 2, checky - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx + GameMap.tileWidth, checky);
                this.drawFire_first(1, checkx + GameMap.tileWidth, checky, this.firstRightIndex, 1);
                if (!this.canThrough(checkx + 2 * GameMap.tileWidth + GameMap.tileWidth / 2, checky - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx + 2 * GameMap.tileWidth, checky);
                this.drawFire_first(1, checkx + 2 * GameMap.tileWidth, checky, this.secondRightIndex, 2);
                if (!this.canThrough(checkx + 3 * GameMap.tileWidth + GameMap.tileWidth / 2, checky - GameMap.tileHight / 2)) break;
                this.fireRoleOrBomb(checkx + 3 * GameMap.tileWidth, checky);
                this.drawFire_first(1, checkx + 3 * GameMap.tileWidth, checky, this.thirdRightIndex, 3);
            }
        }
    }

    public boolean canThrough(int x, int y) {
        GameMap map = Enemy.engine.map;
        boolean canMove = map.canMove(x + 1, y - 1);
        int row = map.checkDEC(x, y);
        return canMove && row == -1;
    }

    public boolean fireRoleOrBomb(int x, int y) {
        GameRole role = Enemy.engine.role;
        if (role.x >= x) {
            if (role.x < x + GameMap.tileWidth && role.y <= y) {
                if (role.y > y - GameMap.tileHight && role.roleBeing) {
                    role.curStatus = (byte)3;
                    if (role.booldValue == 1) {
                        role.curStatus = (byte)6;
                        --role.booldValue;
                    }
                    role.index = 0;
                    role.roleBeing = false;
                    return true;
                }
            }
        }
        Vector bombs = Enemy.engine.bouns;
        int i = 0;
        while (i < bombs.size()) {
            Boun bomb = (Boun)bombs.elementAt(i);
            int bx = bomb.x;
            int by = bomb.y;
            if (bx == x && by == y && bomb.state != -1) {
                bomb.paintTime = GameEngine.bTime + 1;
                bomb.beFired = true;
                return true;
            }
            ++i;
        }
        Vector gameTools = Enemy.engine.gameTools;
        int i2 = 0;
        while (i2 < gameTools.size()) {
            GameTool tool = (GameTool)gameTools.elementAt(i2);
            int tx = tool.x;
            int ty = tool.y;
            if (tx == x && ty == y && tool.type != 0) {
                tool.type = 0;
            }
            ++i2;
        }
        return false;
    }

    public void drawFire_first(int dir, int x, int y, int firstIndex, int whichOne) {
        switch (dir) {
            case 2: {
                this.motion = new byte[]{-1, -1, -1, -1, 8, 9, 8, 9, 8, 12, 13};
                if (++firstIndex >= this.motion.length) {
                    firstIndex = 0;
                }
                this.firstCurIndex = this.motion[firstIndex];
                switch (whichOne) {
                    case 1: {
                        this.firstDownIndex = firstIndex;
                        break;
                    }
                    case 2: {
                        this.secondDownIndex = firstIndex;
                        break;
                    }
                    case 3: {
                        this.thirdDownIndex = firstIndex;
                    }
                }
                break;
            }
            case 0: {
                this.motion = new byte[]{-1, -1, -1, -1, 8, 9, 8, 9, 8, 12, 13};
                if (++firstIndex >= this.motion.length) {
                    firstIndex = 0;
                }
                this.firstCurIndex = this.motion[firstIndex];
                switch (whichOne) {
                    case 1: {
                        this.firstUpCurIndex = firstIndex;
                        break;
                    }
                    case 2: {
                        this.secondUpIndex = firstIndex;
                        break;
                    }
                    case 3: {
                        this.thirdUpIndex = firstIndex;
                    }
                }
                break;
            }
            case 3: {
                this.motion = new byte[]{-1, -1, -1, -1, 6, 7, 6, 7, 6, 10, 11};
                if (++firstIndex >= this.motion.length) {
                    firstIndex = 0;
                }
                this.firstCurIndex = this.motion[firstIndex];
                switch (whichOne) {
                    case 1: {
                        this.firstLeftIndex = firstIndex;
                        break;
                    }
                    case 2: {
                        this.secondLeftIndex = firstIndex;
                        break;
                    }
                    case 3: {
                        this.thirdLeftIndex = firstIndex;
                    }
                }
                break;
            }
            case 1: {
                this.motion = new byte[]{-1, -1, -1, -1, 6, 7, 6, 7, 6, 10, 11};
                if (++firstIndex >= this.motion.length) {
                    firstIndex = 0;
                }
                this.firstCurIndex = this.motion[firstIndex];
                switch (whichOne) {
                    case 1: {
                        this.firstRightIndex = firstIndex;
                        break;
                    }
                    case 2: {
                        this.secondRightIndex = firstIndex;
                        break;
                    }
                    case 3: {
                        this.thirdRightIndex = firstIndex;
                    }
                }
                break;
            }
        }
        if (this.firstCurIndex != -1) {
            this.rx = x - this.indent_fire[this.firstCurIndex][this.isMir ? 1 : 0];
            this.ry = y + this.indent_fire[this.firstCurIndex][3];
            if (dir == 1) {
                Tools.addImage(72, this.rx, this.ry + GameEngine.topHeight, this.roleCilpData_fire[this.firstCurIndex], 36, (byte)1, 1);
                return;
            }
            if (dir == 2) {
                Tools.addImage(72, this.rx, this.ry + GameEngine.topHeight, this.roleCilpData_fire[this.firstCurIndex], 36, (byte)2, 1);
                return;
            }
            Tools.addImage(72, this.rx, this.ry + GameEngine.topHeight, this.roleCilpData_fire[this.firstCurIndex], 36, (byte)0, 1);
        }
    }

    public void move_maomaochongguai() {
        switch (this.curStatus) {
            case 2: {
                this.motion = new byte[]{0, 0, 1, 2, 3, 0, 1, 2, 3};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 1: {
                this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
                switch (this.dir) {
                    case 2: {
                        if (this.type == 5) {
                            this.enemyMove_maomaochong(0, this.speed);
                            break;
                        }
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        if (this.type == 5) {
                            this.enemyMove_maomaochong(0, -this.speed);
                            break;
                        }
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        if (this.type == 5) {
                            this.enemyMove_maomaochong(-this.speed, 0);
                            break;
                        }
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        if (this.type == 5) {
                            this.enemyMove_maomaochong(this.speed, 0);
                            break;
                        }
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 4, 0, 4, 0, 4, 0, 4};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void addSpeedOfBomb() {
        if (this.speed == 10 && (this.addTime = (short)(this.addTime + 1)) > 100) {
            this.speed = 4;
            this.addTime = 0;
        }
    }

    public void move_huangseqianting() {
        switch (this.curStatus) {
            case 1: {
                this.motion = new byte[]{0, 0, 1, 1, 2, 2, 1, 1};
                switch (this.dir) {
                    case 2: {
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 3, 0, 3, 0, 3, 0, 3};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                    --this.liftValue;
                    ++this.hurtTime;
                    if (this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                    }
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_qianshuiyuan() {
        switch (this.curStatus) {
            case 1: {
                this.motion = new byte[]{0, 0, 1, 1, 2, 2};
                switch (this.dir) {
                    case 2: {
                        this.enemyMove(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.enemyMove(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.enemyMove(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.enemyMove(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 3, 0, 3, 0, 3, 0, 3};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_feiting() {
        this.motion = new byte[]{0, 0, 1, 1};
        switch (this.curStatus) {
            case 1: {
                switch (this.dir) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.enemyMove_dazhangyu(70, 156, 168, 4);
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{1, 1, -1, 1, -1, 1, -1, 1, -1, 1};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_zhadanwang() {
        switch (this.curStatus) {
            case 1: {
                switch (this.dir) {
                    case 2: {
                        this.motion = new byte[]{1, 1, 2, 2, 3, 3, 2, 2};
                        this.enemyMove_hesexiaochou(0, this.speed);
                        break;
                    }
                    case 0: {
                        this.motion = new byte[]{5, 5, 6, 6, 7, 7, 8, 8};
                        this.enemyMove_hesexiaochou(0, -this.speed);
                        break;
                    }
                    case 3: {
                        this.motion = new byte[]{10, 10, 11, 11, 12, 12, 13, 13};
                        this.enemyMove_hesexiaochou(-this.speed, 0);
                        break;
                    }
                    case 1: {
                        this.motion = new byte[]{10, 10, 11, 11, 12, 12, 13, 13};
                        this.enemyMove_hesexiaochou(this.speed, 0);
                        break;
                    }
                }
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 2: {
                this.motion = new byte[]{14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 0, 20, 20, 0, 0, 20, 20};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_shitou() {
        ++this.useSkillTime;
        switch (this.curStatus) {
            case 1: {
                this.motion = new byte[]{0, 0};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 5: {
                this.motion = new byte[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 0, 0, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 0, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1, 0, 0, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1};
                this.beginSkip = false;
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                    this.beginSkip = true;
                }
                this.curIndex = this.motion[this.index];
                if (!this.putStons || this.curIndex != 2) break;
                this.throwStones();
                this.putStons = false;
                break;
            }
            case 3: {
                this.motion = new byte[]{2, 2, 2, -1, 2, -1, 2, -1, -1, 2, -1, 2};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                    this.beginSkip = true;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_hudie() {
        switch (this.curStatus) {
            case 1: {
                this.motion = new byte[]{0, 1, 2, 1};
                this.enemyMove_hudie();
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 7: {
                this.motion = new byte[]{0, 1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1, 0, 1, 2, 1};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 5: {
                this.motion = new byte[]{0, 0, 1, 2, 0, 0, 1, 2, 0, 0, 1, 2, 0, 0, 1, 2};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                    this.indexIsZero = true;
                    this.stopTime = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 3: {
                this.motion = new byte[]{0, 0, -1, 0, -1, 0, -1, 0, -1, 0, -1, 0};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    if (this.liftValue <= 4) {
                        this.lineFlySpan = 30;
                    }
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void move_dazhangyu() {
        ++this.useSkillTime;
        switch (this.curStatus) {
            case 1: {
                this.createSounds();
                this.motion = new byte[]{0, 0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
                this.enemyMove_dazhangyu(70, 156, 144, 16);
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                }
                if (this.useSkillTime >= 100) {
                    this.curStatus = (byte)7;
                    this.index = 0;
                    this.useSkillTime = 0;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 7: {
                this.motion = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.bossHitRole();
                }
                this.curIndex = this.motion[this.index];
                break;
            }
            case 5: {
                this.indexIsZero = false;
                this.motion = new byte[]{1, 1, 0, 2, 3, 4, 0, 2, 3, 4};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    this.curStatus = 1;
                    this.indexIsZero = true;
                    this.stopTime = 0;
                    return;
                }
                this.curIndex = this.motion[this.index];
                if (this.curIndex != 1) break;
                Effect.addEffect(this.x - 75, this.y + 51, 25, 0, this.y + 100);
                break;
            }
            case 3: {
                this.motion = new byte[]{1, 1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1, -1, 1};
                if (this.motion == null) break;
                if (++this.index >= this.motion.length) {
                    this.index = 0;
                    ++this.hurtTime;
                    if (--this.liftValue == 0) {
                        this.enemyX = this.x;
                        this.enemyY = this.y;
                        return;
                    }
                    this.curStatus = 1;
                }
                this.curIndex = this.motion[this.index];
                break;
            }
        }
    }

    public void throwStones() {
        this.map = Enemy.engine.map;
        if (this.canPutStone()) {
            int i = 0;
            while (i < 7) {
                ((Stone)Enemy.engine.stones.elementAt(GameEngine.stoneCount)).init(i * 2 * GameMap.tileWidth, 3 * GameMap.tileHight, 0);
                GameEngine.shakeTime = (byte)20;
                if (++GameEngine.stoneCount >= Enemy.engine.stones.size()) {
                    GameEngine.stoneCount = 0;
                }
                ++i;
            }
        }
    }

    public boolean canPutStone() {
        Vector stones = Enemy.engine.stones;
        int sCount = 0;
        int i = 0;
        while (i < stones.size()) {
            if (((Stone)Enemy.engine.stones.elementAt((int)i)).type != -1) {
                sCount = (byte)(sCount + 1);
            }
            ++i;
        }
        return sCount < 7;
    }

    public void createSounds() {
        int random = GameEngine.nextInt(0, 100);
        if (random % 10 == 0 && this.canPutSound()) {
            this.map = Enemy.engine.map;
            int x1 = GameEngine.nextInt(1, 11) * GameMap.tileWidth;
            int y1 = GameEngine.nextInt(6, 9) * GameMap.tileHight;
            int type = GameEngine.nextInt(0, 3);
            while (!this.map.canMove(x1 + 1, y1 - 1) || !this.map.beLayTwo(x1 + 1, y1 - 1, 1)) {
                x1 = GameEngine.nextInt(1, 11) * GameMap.tileWidth;
                y1 = GameEngine.nextInt(6, 9) * GameMap.tileHight;
            }
            ((EnemySound)Enemy.engine.enemySounds.elementAt(GameEngine.soundCount)).init(x1, y1, type);
            System.out.println("\u4ea7\u751f\u4e00\u4e2a\u97f3\u7b26");
            if (++GameEngine.soundCount >= Enemy.engine.enemySounds.size()) {
                GameEngine.soundCount = 0;
            }
            System.out.println("engine.soundCount:" + GameEngine.soundCount);
        }
    }

    public boolean canPutSound() {
        Vector eSound = Enemy.engine.enemySounds;
        int sCount = 0;
        int i = 0;
        while (i < eSound.size()) {
            if (((EnemySound)eSound.elementAt((int)i)).type != -1) {
                sCount = (byte)(sCount + 1);
            }
            ++i;
        }
        return sCount < 7;
    }

    public void bossHitRole() {
        GameRole role = Enemy.engine.role;
        if (this.curStatus == 7 && this.y < role.y) {
            this.curStatus = (byte)5;
            this.y = role.y;
        } else {
            this.curStatus = 1;
        }
    }

    public void enemyMove_dazhangyu(int r, int circleX, int circleY, int speed) {
        GameRole role = Enemy.engine.role;
        if (role.x > circleX + r) {
            ++circleX;
        }
        if (role.x < circleX - r) {
            --circleX;
        }
        if (this.x >= circleX - r && this.add) {
            this.x += speed;
            if (this.x >= circleX + r) {
                this.x = circleX + r;
                this.add = false;
            }
            this.y = (int)Tools.sqrt(r * r - (this.x - circleX) * (this.x - circleX)) / 100 + circleY;
            return;
        }
        if (!this.add) {
            this.x -= speed;
            if (this.x <= circleX - r) {
                this.x = circleX - r;
                this.add = true;
            }
            this.y = -1 * (int)Tools.sqrt(r * r - (this.x - circleX) * (this.x - circleX)) / 100 + circleY;
        }
    }

    public void enemyMove_hudie() {
        this.map = Enemy.engine.map;
        int rightX = (GameMap.mapSize[0] - 3) * GameMap.tileWidth;
        byte leftX = GameMap.tileWidth;
        int upY = 5 * GameMap.tileHight;
        int downY = (GameMap.mapSize[0] - 1) * GameMap.tileHight;
        if (this.upFlyTime > 50) {
            if (this.x > rightX) {
                this.x = rightX;
            }
            if (this.x < leftX) {
                this.x = leftX;
            }
            this.lineFlySpan = -1 * this.lineFlySpan;
            this.upFlyTime = 0;
        }
        if (this.x >= leftX && this.x <= rightX) {
            if (this.x == leftX || this.x == rightX) {
                if (this.curStatus == 1) {
                    this.curStatus = (byte)7;
                    this.x += this.lineFlySpan;
                }
            } else {
                this.x += this.lineFlySpan;
            }
        } else if (this.y >= upY && this.y <= downY) {
            this.y += this.flySpan;
            ++this.upFlyTime;
        } else {
            this.y = this.flySpan > 0 ? downY : upY;
            this.flySpan = -1 * this.flySpan;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void enemyMove_maomaochong(int mx, int my) {
        block25: {
            block24: {
                block23: {
                    block22: {
                        map = Enemy.engine.map;
                        newDir = -1;
                        if (my >= 0) break block22;
                        if (!map.canMove(this.x + this.w / 2, this.y - this.h + my) || this.hitUpEdge(this.x, this.y) || this.checkBoun(this.x + this.w / 2, this.y - this.h - 1)) ** GOTO lbl-1000
                        if (map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y - this.h + my, 1)) {
                            this.y += my;
                            if (this.type == 5) {
                                this.eatGlass(this.x, this.y);
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            if (this.y > this.h) {
                                this.y = (this.y - this.h + my) / GameMap.tileHight * GameMap.tileHight + GameMap.tileHight + this.h;
                            }
                            newDir = this.getDirs_maomaochong(mx, my);
                        }
                    }
                    if (my <= 0) break block23;
                    if (!map.canMove(this.x + this.w / 2, this.y + this.speed) || this.hitDownEdge(this.x, this.y) || this.checkBoun(this.x + this.w / 2, this.y + 1)) ** GOTO lbl-1000
                    if (map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y + this.speed, 2)) {
                        this.y += my;
                        if (this.type == 5) {
                            this.eatGlass(this.x, this.y);
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        this.y = (this.y + my) / GameMap.tileHight * GameMap.tileHight;
                        newDir = this.getDirs_maomaochong(mx, my);
                    }
                }
                if (mx >= 0) break block24;
                if (!map.canMove(this.x - this.speed, this.y - this.h / 2) || this.hitLeftEdge(this.x, this.y) || this.checkBoun(this.x - 1, this.y - this.h / 2)) ** GOTO lbl-1000
                if (map.canContinue(this.x + 1, this.y - 1, this.x - this.speed, this.y - this.h / 2, 2)) {
                    this.x += mx;
                    if (this.type == 5) {
                        this.eatGlass(this.x, this.y);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    if (this.x + mx < 0) {
                        this.x = 0;
                    }
                    if (this.x > 0) {
                        this.x = (this.x + mx) / GameMap.tileWidth * GameMap.tileWidth + GameMap.tileWidth;
                    }
                    newDir = this.getDirs_maomaochong(mx, my);
                }
            }
            if (mx <= 0) break block25;
            if (!map.canMove(this.x + this.speed + this.w, this.y - this.h / 2) || this.hitRightEdge(this.x, this.y) || this.checkBoun(this.x + this.w + 1, this.y - this.h / 2)) ** GOTO lbl-1000
            if (map.canContinue(this.x + 1, this.y - 1, this.x + this.speed + this.w, this.y - this.h / 2, 2)) {
                this.x += mx;
                if (this.type == 5) {
                    this.hitOther = false;
                    this.eatGlass(this.x, this.y);
                }
            } else lbl-1000:
            // 2 sources

            {
                if (this.x < GameMap.mapSize[0] * GameMap.tileWidth - this.w) {
                    this.x = (this.x + mx + this.w) / GameMap.tileWidth * GameMap.tileWidth - this.w;
                }
                newDir = this.getDirs_maomaochong(mx, my);
            }
        }
        switch (newDir) {
            case 0: {
                this.dir = 0;
                break;
            }
            case 1: {
                this.dir = 1;
                break;
            }
            case 2: {
                this.dir = (byte)2;
                break;
            }
            case 3: {
                this.dir = (byte)3;
                break;
            }
        }
        this.x = Math.max(0, this.x);
        this.x = Math.min(GameMap.mapSize[0] * GameMap.tileWidth - this.w, this.x);
        this.y = Math.max(this.h, this.y);
        this.y = Math.min((GameMap.mapSize[1] - 1) * GameMap.tileHight, this.y);
    }

    public void eatGlass(int x, int y) {
        GameMap map = Enemy.engine.map;
        int decState = 6;
        int length = GameMap.dexData.length;
        int i = 0;
        while (i < length) {
            if (this.canEat(GameMap.dexData[i][0])) {
                if (x >= GameMap.dexData[i][1]) {
                    if (x < GameMap.dexData[i][1] + GameMap.tileWidth) {
                        if (y <= GameMap.dexData[i][2]) {
                            if (y >= GameMap.dexData[i][2] - GameMap.tileHight / 2) {
                                if (GameMap.dexData[i][decState] != map.maxState) {
                                    GameMap.dexData[i][decState] = map.maxState;
                                }
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public boolean canEat(int prop) {
        block3: {
            block2: {
                GameMap map = Enemy.engine.map;
                if (prop == 1) break block2;
                if (prop == 5) break block2;
                if (prop == 7) break block2;
                if (prop == 6) break block2;
                if (prop == 8) break block2;
                if (prop != 9) break block3;
            }
            return true;
        }
        return false;
    }

    public int getDirs_maomaochong(int mx, int my) {
        GameMap map = Enemy.engine.map;
        int before = -1;
        if (mx > 0) {
            before = 3;
        }
        if (mx < 0) {
            before = 1;
        }
        if (my > 0) {
            before = 0;
        }
        if (my < 0) {
            before = 2;
        }
        if (!this.dirs.isEmpty()) {
            this.dirs.removeAllElements();
        }
        if (map.canMove(this.x + this.w / 2, this.y - this.h - this.speed) && !this.hitUpEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y - this.h - 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y - this.h - this.speed, 1)) {
            this.dirs.addElement(this.u1);
        }
        if (map.canMove(this.x + this.w / 2, this.y + this.speed) && !this.hitDownEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y + 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y + this.speed, 1)) {
            this.dirs.addElement(this.u2);
        }
        if (map.canMove(this.x - this.speed, this.y - this.h / 2) && !this.hitLeftEdge(this.x, this.y) && !this.checkBoun(this.x - 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x - this.speed, this.y - this.h / 2, 1)) {
            this.dirs.addElement(this.u3);
        }
        if (map.canMove(this.x + this.speed + this.w, this.y - this.h / 2) && !this.hitRightEdge(this.x, this.y) && !this.checkBoun(this.x + this.w + 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x + this.speed + this.w, this.y - this.h / 2, 1)) {
            this.dirs.addElement(this.u4);
        }
        int random = GameEngine.nextInt(0, this.dirs.size() - 1);
        int dir = 0;
        if (this.dirs.size() == 0) {
            return -1;
        }
        dir = ((Utils)this.dirs.elementAt((int)random)).i;
        while (dir == before && this.dirs.size() != 1 || this.dirs.size() == 0) {
            random = GameEngine.nextInt(0, this.dirs.size() - 1);
            dir = ((Utils)this.dirs.elementAt((int)random)).i;
        }
        return dir;
    }

    public void drawScore(int addScore, int x, int y) {
        int ge = addScore % 10;
        int shi = addScore % 100 / 10;
        int bai = addScore % 1000 / 100;
        int qian = addScore % 10000 / 1000;
        if (shi != 0) {
            this.drawScoreNumber(x, y, shi);
            this.drawScoreNumber(x + 12, y, ge);
        }
        if (bai != 0) {
            this.drawScoreNumber(x, y, bai);
            this.drawScoreNumber(x + 12, y, shi);
            this.drawScoreNumber(x + 24, y, ge);
        }
        if (qian != 0) {
            this.drawScoreNumber(x, y, qian);
            this.drawScoreNumber(x + 12, y, bai);
            this.drawScoreNumber(x + 24, y, shi);
            this.drawScoreNumber(x + 36, y, ge);
        }
    }

    public void drawScoreNumber(int x, int y, int number) {
        Tools.addImage(92, x, y, Enemy.engine.canvas.array_shuzi1[number], 36, (byte)0, 510);
    }

    public boolean bombBossHitRole() {
        GameRole role = Enemy.engine.role;
        GameMap cfr_ignored_0 = Enemy.engine.map;
        int roleRow = role.y / GameMap.tileHight;
        GameMap cfr_ignored_1 = Enemy.engine.map;
        int roleColum = role.x / GameMap.tileWidth;
        GameMap cfr_ignored_2 = Enemy.engine.map;
        int enemyRow = this.y / GameMap.tileHight;
        GameMap cfr_ignored_3 = Enemy.engine.map;
        int enemyColum = this.x / GameMap.tileWidth;
        return Math.abs(roleRow - enemyRow) < 2 && Math.abs(roleColum - enemyColum) < 2;
    }

    public int cannotThroughDirs(int dir, Vector dirs) {
        Vector bombs = Enemy.engine.bouns;
        this.map = Enemy.engine.map;
        int row = this.y / GameMap.tileHight;
        int colum = this.x / GameMap.tileWidth;
        int i = 0;
        while (i < bombs.size()) {
            Boun bomb = (Boun)bombs.elementAt(i);
            if (bomb.state == 0) {
                int bRow = bomb.y / GameMap.tileHight;
                int bColum = bomb.x / GameMap.tileWidth;
                if (row == bRow && (dir == 3 || dir == 1)) {
                    if (dirs.contains(this.u2)) {
                        return 2;
                    }
                    if (dirs.contains(this.u1)) {
                        return 0;
                    }
                }
                if (colum == bColum && (dir == 0 || dir == 2)) {
                    if (dirs.contains(this.u4)) {
                        return 1;
                    }
                    if (dirs.contains(this.u3)) {
                        return 3;
                    }
                }
                if ((row + 1 == bRow || row + 2 == bRow) && dir == 2 && dirs.contains(this.u1)) {
                    return 0;
                }
                if ((row - 1 == bRow || row - 2 == bRow) && dir == 0 && dirs.contains(this.u2)) {
                    return 2;
                }
                if ((colum + 1 == bColum || colum + 2 == bColum) && dir == 1 && dirs.contains(this.u3)) {
                    return 3;
                }
                if ((colum - 1 == bColum || colum - 2 == bColum) && dir == 3 && dirs.contains(this.u4)) {
                    return 1;
                }
            }
            ++i;
        }
        return -1;
    }

    public void putBomb(int type, int sum) {
        if (this.bounIsZero(0, sum)) {
            int bounx = this.x;
            int bouny = this.y;
            int minx = this.x / GameMap.tileWidth * GameMap.tileWidth;
            int maxx = this.x / GameMap.tileWidth * GameMap.tileWidth + GameMap.tileWidth;
            int miny = this.y / GameMap.tileHight * GameMap.tileHight;
            int maxy = this.y / GameMap.tileHight * GameMap.tileHight + GameMap.tileHight;
            if (this.x % GameMap.tileWidth != 0) {
                bounx = Math.abs(this.x - minx) <= GameMap.tileWidth / 2 ? minx : maxx;
            }
            if (this.y % GameMap.tileHight != 0) {
                bouny = Math.abs(this.y - miny) <= GameMap.tileHight / 2 ? miny : maxy;
            }
            if (!this.putOnBomb(bounx, bouny)) {
                ((Boun)Enemy.engine.bouns.elementAt(Enemy.engine.role.bounCount)).init(bounx, bouny, 0, 0, true);
                this.curStatus = (byte)2;
                ++Enemy.engine.role.bounCount;
                if (Enemy.engine.role.bounCount >= Enemy.engine.bouns.size()) {
                    Enemy.engine.role.bounCount = 0;
                }
            }
        }
    }

    public boolean bounIsZero(int type, int sum) {
        Vector bouns = Enemy.engine.bouns;
        int i = 0;
        while (i < bouns.size()) {
            if (((Boun)bouns.elementAt((int)i)).state == 0 && ((Boun)bouns.elementAt((int)i)).property == type) {
                this.bombSum = (short)(this.bombSum + 1);
            }
            ++i;
        }
        if (this.bombSum < sum) {
            this.bombSum = 0;
            return true;
        }
        this.bombSum = 0;
        return false;
    }

    public boolean putOnBomb(int bounx, int bouny) {
        GameMap map = Enemy.engine.map;
        int decState = 6;
        Vector bouns = Enemy.engine.bouns;
        int i = 0;
        while (i < bouns.size()) {
            if (((Boun)bouns.elementAt((int)i)).state != -1 && ((Boun)bouns.elementAt((int)i)).x == bounx && ((Boun)bouns.elementAt((int)i)).y == bouny) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean fireIsMiss() {
        Vector fires = Enemy.engine.fires;
        int beingCount = 0;
        int i = 0;
        while (i < fires.size()) {
            Fire fire = (Fire)fires.elementAt(i);
            if (fire.being) {
                ++beingCount;
            }
            ++i;
        }
        return beingCount <= 5;
    }

    public void createFire() {
        if (this.fireIsMiss()) {
            if (++this.kind > 4) {
                this.kind = 0;
            }
            int a2 = 0;
            int b2 = 0;
            switch (this.kind) {
                case 0: 
                case 1: {
                    a2 = this.x - 8;
                    b2 = this.y - 17;
                    break;
                }
                case 2: {
                    a2 = this.x;
                    b2 = this.y;
                    break;
                }
                case 3: 
                case 4: {
                    a2 = this.x + 6;
                    b2 = this.y - 17;
                }
            }
            ((Fire)Enemy.engine.fires.elementAt(this.fireCount)).init(a2, b2, this.kind, true);
            if (++this.fireCount >= 30) {
                this.fireCount = 0;
            }
        }
    }

    public void move() {
        this.isMir = false;
        switch (this.type) {
            case 32: {
                this.move_feiting();
                this.createFire();
                break;
            }
            case 31: {
                this.move_zhadanwang();
                if (++this.putTime > 200) {
                    this.putTime = 1;
                }
                if (Enemy.engine.gameRank == 35 && this.putTime % 100 == 0 || this.putTime % 20 == 0 && this.bombBossHitRole()) {
                    this.putBomb(this.type, 4);
                }
                if (Enemy.engine.gameRank == 35 && this.putTime % 50 == 0) {
                    this.speed = 10;
                    this.addSpeedTime = 0;
                }
                if (this.speed == 10) {
                    ++this.addSpeedTime;
                }
                if (this.addSpeedTime < 30) break;
                this.speed = 6;
                this.addSpeedTime = 0;
                break;
            }
            case 6: {
                this.move_dazhangyu();
                break;
            }
            case 29: {
                this.move_hudie();
                break;
            }
            case 30: {
                this.move_shitou();
                if (!this.beginSkip) break;
                this.enemySkip();
                break;
            }
            case 0: 
            case 9: 
            case 26: {
                this.move_moGuGuai();
                break;
            }
            case 1: 
            case 8: 
            case 27: {
                this.move_xiaoChouGuai();
                break;
            }
            case 2: 
            case 22: 
            case 23: {
                this.move_bingganguai();
                break;
            }
            case 3: 
            case 10: 
            case 21: 
            case 24: {
                this.move_lanyiguai();
                break;
            }
            case 4: 
            case 12: 
            case 18: {
                this.move_hesexiaochouguai();
                if (this.type != 12) break;
                this.addSpeed();
                break;
            }
            case 7: 
            case 15: 
            case 20: {
                this.move_lansefeiniaoguai();
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 25: {
                this.move_maomaochongguai();
                if (this.type != 16) break;
                this.addSpeed();
                break;
            }
            case 13: 
            case 17: 
            case 28: {
                this.move_huangseqianting();
                if (this.type != 28) break;
                this.addSpeedOfBomb();
                break;
            }
            case 14: 
            case 19: {
                this.move_qianshuiyuan();
            }
        }
    }

    public void justAddSpeed() {
        this.speed = 8;
    }

    boolean hitLeftEdge(int x, int y) {
        return x <= 0;
    }

    boolean hitRightEdge(int x, int y) {
        GameMap map = Enemy.engine.map;
        return x >= GameMap.mapSize[0] * GameMap.tileWidth - this.w;
    }

    boolean hitUpEdge(int x, int y) {
        return y <= this.h;
    }

    boolean hitDownEdge(int x, int y) {
        GameMap map = Enemy.engine.map;
        return y >= (GameMap.mapSize[1] - 1) * GameMap.tileHight;
    }

    public boolean hitRole() {
        GameMap map = Enemy.engine.map;
        GameRole role = Enemy.engine.role;
        if (GameEngine.wearCloth) {
            if (GameEngine.wearTime <= GameEngine.wearMaxTime) {
                return false;
            }
        }
        GameEngine.wearCloth = false;
        GameEngine.wearTime = 0;
        if (!this.visiable) {
            return false;
        }
        if (this.type == 6) {
            if (role.x >= this.x - GameMap.tileWidth) {
                if (role.x < this.x + 3 * GameMap.tileWidth) {
                    if (role.y <= this.y + GameMap.tileWidth) {
                        if (role.y > this.y - GameMap.tileHight && role.roleBeing) {
                            role.curStatus = (byte)3;
                            if (role.booldValue == 1) {
                                MyGameCanvas cfr_ignored_0 = Enemy.engine.canvas;
                                if (MyGameCanvas.isFirstPlay != 1) {
                                    role.curStatus = (byte)6;
                                    --role.booldValue;
                                }
                            }
                            role.roleBeing = false;
                            role.index = 0;
                            return true;
                        }
                    }
                }
            }
        }
        if (this.type == 30 && role.x >= this.x - this.w / 2 && role.x < this.x + this.w / 2 && role.y <= this.y) {
            if (role.y > this.y - GameMap.tileHight && role.roleBeing) {
                role.curStatus = (byte)3;
                if (role.booldValue == 1) {
                    MyGameCanvas cfr_ignored_1 = Enemy.engine.canvas;
                    if (MyGameCanvas.isFirstPlay != 1) {
                        role.curStatus = (byte)6;
                        --role.booldValue;
                    }
                }
                role.roleBeing = false;
                role.index = 0;
                return true;
            }
        }
        if (role.x >= this.x) {
            if (role.x < this.x + GameMap.tileWidth && role.y <= this.y) {
                if (role.y > this.y - GameMap.tileHight && role.roleBeing) {
                    role.curStatus = (byte)3;
                    if (role.booldValue == 1) {
                        MyGameCanvas cfr_ignored_2 = Enemy.engine.canvas;
                        if (MyGameCanvas.isFirstPlay != 1) {
                            role.curStatus = (byte)6;
                            --role.booldValue;
                        }
                    }
                    role.index = 0;
                    role.roleBeing = false;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkBoun(int x, int y) {
        Vector bouns = Enemy.engine.bouns;
        int i = 0;
        while (i < bouns.size()) {
            Boun boun = (Boun)bouns.elementAt(i);
            if (boun.being && boun.hitBoun(boun.x, boun.y, x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean checkBoun_lansefeiniaoguai(int x, int y) {
        Vector bouns = Enemy.engine.bouns;
        int i = 0;
        while (i < bouns.size()) {
            Boun boun = (Boun)bouns.elementAt(i);
            if (boun.being && boun.hitBoun(boun.x, boun.y, x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void enemyMove_hesexiaochou(int mx, int my) {
        int rightDir;
        GameMap map = Enemy.engine.map;
        GameRole role = Enemy.engine.role;
        int rolex = role.x;
        int roley = role.y;
        int rowNum = roley / GameMap.tileHight;
        int rowNum2 = this.y / GameMap.tileHight;
        int columnNum = rolex / GameMap.tileWidth;
        int columnNum2 = this.x / GameMap.tileWidth;
        int newDir = -1;
        int random = GameEngine.nextInt(0, 10);
        if (my < 0) {
            int upRow = map.checkDEC(this.x + this.w / 2, this.y - this.h - 1);
            if (this.type == 18 || this.type == 20) {
                upRow = -1;
            }
            if (map.canMove(this.x + this.w / 2, this.y - this.h + my) && upRow == -1 && !this.hitUpEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y - this.h - 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y - this.h + my, 1)) {
                this.y += my;
                if (this.y % GameMap.tileHight == 0) {
                    if (this.type == 1) {
                        this.getDirs(mx, my);
                        if (random % 2 == 0) {
                            newDir = this.getDirs(mx, my);
                        }
                    } else {
                        newDir = this.getDirs(mx, my);
                    }
                    if (rowNum == rowNum2 && (rightDir = this.getRightRowDir()) != -1) {
                        newDir = rightDir;
                    }
                    if (columnNum == columnNum2 && (rightDir = this.getRightColumnDir()) != -1) {
                        newDir = rightDir;
                    }
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        if (my > 0) {
            int downRow = map.checkDEC(this.x + this.w / 2, this.y);
            if (this.type == 18 || this.type == 20) {
                downRow = -1;
            }
            if (map.canMove(this.x + this.w / 2, this.y + this.speed - 1) && downRow == -1 && !this.hitDownEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y + 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y + this.speed - 1, 1)) {
                this.y += my;
                if (this.y % GameMap.tileHight == 0) {
                    if (this.type == 1) {
                        this.getDirs(mx, my);
                        if (random % 2 == 0) {
                            newDir = this.getDirs(mx, my);
                        }
                    } else {
                        newDir = this.getDirs(mx, my);
                    }
                    if (rowNum == rowNum2 && (rightDir = this.getRightRowDir()) != -1) {
                        newDir = rightDir;
                    }
                    if (columnNum == columnNum2 && (rightDir = this.getRightColumnDir()) != -1) {
                        newDir = rightDir;
                    }
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        if (mx < 0) {
            int leftRow = map.checkDEC(this.x - 1, this.y - this.h / 2);
            if (this.type == 18 || this.type == 20) {
                leftRow = -1;
            }
            if (map.canMove(this.x - this.speed, this.y - this.h / 2) && leftRow == -1 && !this.hitLeftEdge(this.x, this.y) && !this.checkBoun(this.x - 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x - this.speed, this.y - this.h / 2, 1)) {
                this.x += mx;
                if (this.x % GameMap.tileWidth == 0) {
                    if (this.type == 1) {
                        this.getDirs(mx, my);
                        if (random % 2 == 0) {
                            newDir = this.getDirs(mx, my);
                        }
                    } else {
                        newDir = this.getDirs(mx, my);
                    }
                    if (rowNum == rowNum2 && (rightDir = this.getRightRowDir()) != -1) {
                        newDir = rightDir;
                    }
                    if (columnNum == columnNum2 && (rightDir = this.getRightColumnDir()) != -1) {
                        newDir = rightDir;
                    }
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        if (mx > 0) {
            int rightRow = map.checkDEC(this.x + this.w + 1, this.y - this.h / 2);
            if (this.type == 18 || this.type == 20) {
                rightRow = -1;
            }
            if (map.canMove(this.x + this.speed + this.w - 1, this.y - this.h / 2) && rightRow == -1 && !this.hitRightEdge(this.x, this.y) && !this.checkBoun(this.x + this.w + 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x + this.speed + this.w - 1, this.y - this.h / 2, 1)) {
                this.x += mx;
                if (this.x % GameMap.tileWidth == 0) {
                    if (this.type == 1) {
                        this.getDirs(mx, my);
                        if (random % 2 == 0) {
                            newDir = this.getDirs(mx, my);
                        }
                    } else {
                        newDir = this.getDirs(mx, my);
                    }
                    if (rowNum == rowNum2 && (rightDir = this.getRightRowDir()) != -1) {
                        newDir = rightDir;
                    }
                    if (columnNum == columnNum2 && (rightDir = this.getRightColumnDir()) != -1) {
                        newDir = rightDir;
                    }
                }
            } else {
                newDir = this.getDirs(mx, my);
            }
        }
        switch (newDir) {
            case 0: {
                this.dir = 0;
                break;
            }
            case 1: {
                this.dir = 1;
                break;
            }
            case 2: {
                this.dir = (byte)2;
                break;
            }
            case 3: {
                this.dir = (byte)3;
            }
        }
        this.x = Math.max(0, this.x);
        this.x = Math.min(GameMap.mapSize[0] * GameMap.tileWidth - this.w, this.x);
        this.y = Math.max(this.h, this.y);
        this.y = Math.min((GameMap.mapSize[1] - 1) * GameMap.tileHight, this.y);
    }

    public void enemyMove(int mx, int my) {
        GameMap map = Enemy.engine.map;
        int newDir = -1;
        if (my < 0) {
            int upRow = map.checkDEC(this.x + this.w / 2, this.y - this.h - 1);
            if (this.type == 17 || this.type == 18 || this.type == 20) {
                upRow = -1;
            }
            if (map.canMove(this.x + this.w / 2, this.y - this.h + my) && upRow == -1 && !this.hitUpEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y - this.h - 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y - this.h + my, 1)) {
                this.y += my;
            } else {
                if (this.y > this.h) {
                    this.y = (this.y - this.h + my) / GameMap.tileHight * GameMap.tileHight + GameMap.tileHight + this.h;
                }
                newDir = this.getDirs(mx, my);
                if (this.type == 16) {
                    this.speed = 4;
                    this.hitOther = false;
                }
            }
        }
        if (my > 0) {
            int downRow = map.checkDEC(this.x + this.w / 2, this.y + 1);
            if (this.type == 17 || this.type == 18 || this.type == 20) {
                downRow = -1;
            }
            if (map.canMove(this.x + this.w / 2, this.y + this.speed) && downRow == -1 && !this.hitDownEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y + 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y + this.speed, 1)) {
                this.y += my;
            } else {
                this.y = (this.y + my) / GameMap.tileHight * GameMap.tileHight;
                newDir = this.getDirs(mx, my);
                if (this.type == 16) {
                    this.speed = 4;
                    this.hitOther = false;
                }
            }
        }
        if (mx < 0) {
            int leftRow = map.checkDEC(this.x - 1, this.y - this.h / 2);
            if (this.type == 17 || this.type == 18 || this.type == 20) {
                leftRow = -1;
            }
            if (map.canMove(this.x - this.speed, this.y - this.h / 2) && leftRow == -1 && !this.hitLeftEdge(this.x, this.y) && !this.checkBoun(this.x - 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x - this.speed, this.y - this.h / 2, 1)) {
                this.x += mx;
            } else {
                if (this.x + mx < 0) {
                    this.x = 0;
                }
                if (this.x > 0) {
                    this.x = (this.x + mx) / GameMap.tileWidth * GameMap.tileWidth + GameMap.tileWidth;
                }
                newDir = this.getDirs(mx, my);
                if (this.type == 16) {
                    this.speed = 4;
                    this.hitOther = false;
                }
            }
        }
        if (mx > 0) {
            int rightRow = map.checkDEC(this.x + this.w + 1, this.y - this.h / 2);
            if (this.type == 17 || this.type == 18 || this.type == 20) {
                rightRow = -1;
            }
            if (map.canMove(this.x + this.speed + this.w, this.y - this.h / 2) && rightRow == -1 && !this.hitRightEdge(this.x, this.y) && !this.checkBoun(this.x + this.w + 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x + this.speed + this.w, this.y - this.h / 2, 1)) {
                this.x += mx;
            } else {
                if (this.x < GameMap.mapSize[0] * GameMap.tileWidth - this.w) {
                    this.x = (this.x + mx + this.w) / GameMap.tileWidth * GameMap.tileWidth - this.w;
                }
                newDir = this.getDirs(mx, my);
                if (this.type == 16) {
                    this.speed = 4;
                    this.hitOther = false;
                }
            }
        }
        switch (newDir) {
            case 0: {
                this.dir = 0;
                break;
            }
            case 1: {
                this.dir = 1;
                break;
            }
            case 2: {
                this.dir = (byte)2;
                break;
            }
            case 3: {
                this.dir = (byte)3;
                break;
            }
        }
        this.x = Math.max(0, this.x);
        this.x = Math.min(GameMap.mapSize[0] * GameMap.tileWidth - this.w, this.x);
        this.y = Math.max(this.h, this.y);
        this.y = Math.min((GameMap.mapSize[1] - 1) * GameMap.tileHight, this.y);
    }

    public int getDirs(int mx, int my) {
        GameMap map = Enemy.engine.map;
        int before = -1;
        if (mx > 0) {
            before = 3;
        }
        if (mx < 0) {
            before = 1;
        }
        if (my > 0) {
            before = 0;
        }
        if (my < 0) {
            before = 2;
        }
        if (!this.dirs.isEmpty()) {
            this.dirs.removeAllElements();
        }
        int upRow = map.checkDEC(this.x + this.w / 2, this.y - this.h - 1);
        if (this.type == 17 || this.type == 18 || this.type == 20) {
            upRow = -1;
        }
        if (map.canMove(this.x + this.w / 2, this.y - this.h - this.speed) && upRow == -1 && !this.hitUpEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y - this.h - 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y - this.h - this.speed, 1)) {
            this.dirs.addElement(this.u1);
        }
        int downRow = map.checkDEC(this.x + this.w / 2, this.y + 1);
        if (this.type == 17 || this.type == 18 || this.type == 20) {
            downRow = -1;
        }
        if (map.canMove(this.x + this.w / 2, this.y + this.speed) && downRow == -1 && !this.hitDownEdge(this.x, this.y) && !this.checkBoun(this.x + this.w / 2, this.y + 1) && map.canContinue(this.x + 1, this.y - 1, this.x + this.w / 2, this.y + this.speed, 1)) {
            this.dirs.addElement(this.u2);
        }
        int leftRow = map.checkDEC(this.x - 1, this.y - this.h / 2);
        if (this.type == 17 || this.type == 18 || this.type == 20) {
            leftRow = -1;
        }
        if (map.canMove(this.x - this.speed, this.y - this.h / 2) && leftRow == -1 && !this.hitLeftEdge(this.x, this.y) && !this.checkBoun(this.x - 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x - this.speed, this.y - this.h / 2, 1)) {
            this.dirs.addElement(this.u3);
        }
        int rightRow = map.checkDEC(this.x + this.w + 1, this.y - this.h / 2);
        if (this.type == 17 || this.type == 18 || this.type == 20) {
            rightRow = -1;
        }
        if (map.canMove(this.x + this.speed + this.w, this.y - this.h / 2) && rightRow == -1 && !this.hitRightEdge(this.x, this.y) && !this.checkBoun(this.x + this.w + 1, this.y - this.h / 2) && map.canContinue(this.x + 1, this.y - 1, this.x + this.speed + this.w, this.y - this.h / 2, 1)) {
            this.dirs.addElement(this.u4);
        }
        int random = GameEngine.nextInt(0, this.dirs.size() - 1);
        int dir = 0;
        if (this.dirs.size() == 0) {
            return -1;
        }
        dir = ((Utils)this.dirs.elementAt((int)random)).i;
        while (dir == before && this.dirs.size() != 1) {
            if (this.type == 0 || this.type == 25) {
                this.curStatus = (byte)2;
                this.index = 0;
            }
            random = GameEngine.nextInt(0, this.dirs.size() - 1);
            dir = ((Utils)this.dirs.elementAt((int)random)).i;
        }
        if ((this.type == 31 || Enemy.engine.gameRank == 27) && this.cannotThroughDirs(dir, this.dirs) != -1) {
            dir = this.cannotThroughDirs(dir, this.dirs);
        }
        return dir;
    }

    public int getRightRowDir() {
        GameRole role = Enemy.engine.role;
        int rolex = role.x;
        int newDir = -1;
        if (rolex < this.x) {
            newDir = 3;
        }
        if (rolex > this.x) {
            newDir = 1;
        }
        int i = 0;
        while (i < this.dirs.size()) {
            int oldDir = ((Utils)this.dirs.elementAt((int)i)).i;
            if (oldDir == newDir) {
                return newDir;
            }
            ++i;
        }
        return -1;
    }

    public int getRightColumnDir() {
        GameRole role = Enemy.engine.role;
        int roley = role.y;
        int newDir = -1;
        if (roley < this.y) {
            newDir = 0;
        }
        if (roley > this.y) {
            newDir = 2;
        }
        int i = 0;
        while (i < this.dirs.size()) {
            int oldDir = ((Utils)this.dirs.elementAt((int)i)).i;
            if (oldDir == newDir) {
                return newDir;
            }
            ++i;
        }
        return -1;
    }

    public void paint() {
        this.drawDieCloud();
        if (this.curIndex == -1) {
            return;
        }
        if (!this.visiable) {
            return;
        }
        switch (this.type) {
            case 6: {
                this.rx = this.x - this.indent_dazhangyu[this.curIndex][this.isMir ? 1 : 0];
                this.ry = this.y + this.indent_dazhangyu[this.curIndex][3];
                Tools.addFrame(147, Enemy.engine.frameData_zhangyu, Enemy.engine.cilpData_zhangyu, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 96);
                break;
            }
            case 29: {
                this.rx = this.x - this.indent_hudie[this.curIndex][this.isMir ? 1 : 0];
                this.ry = this.y + this.indent_hudie[this.curIndex][2];
                Tools.addFrame(148, Enemy.engine.frameData_hudie, Enemy.engine.cilpData_hudie, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 100);
                break;
            }
            case 30: {
                this.rx = this.x - this.indent_shitou[this.curIndex][this.isMir ? 1 : 0] - 24;
                this.ry = this.y + this.indent_shitou[this.curIndex][2];
                Tools.addFrame(149, Enemy.engine.frameData_shitou, Enemy.engine.cilpData_shitou, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 6);
                break;
            }
            case 31: {
                this.rx = this.x - this.indent_zhadanwang[this.curIndex][this.isMir ? 1 : 0] - 24;
                this.ry = this.y + this.indent_zhadanwang[this.curIndex][2] - 10;
                this.isMir = this.dir == 1;
                Tools.addFrame(150, Enemy.engine.frameData_zhadanwang, Enemy.engine.cilpData_zhadanwang, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y);
                break;
            }
            case 32: {
                this.rx = this.x - this.indent_feiting[this.curIndex][this.isMir ? 1 : 0] - 56;
                this.ry = this.y + this.indent_feiting[this.curIndex][2];
                Tools.addFrame(151, Enemy.engine.frameData_feiting, Enemy.engine.cilpData_feiting, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 0: 
            case 9: 
            case 26: {
                this.rx = this.x - this.indent_moguguai[this.curIndex][this.isMir ? 1 : 0];
                this.ry = this.y + this.indent_moguguai[this.curIndex][2];
                Tools.addFrame(6, Enemy.engine.frameData_moguguai, Enemy.engine.cilpData_moguguai, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 1: 
            case 8: 
            case 27: {
                this.rx = this.x - this.indent_xiaochouguai[this.curIndex][this.isMir ? 1 : 0] - 3;
                this.ry = this.y + this.indent_xiaochouguai[this.curIndex][2] - 6;
                Tools.addFrame(10, Enemy.engine.frameData_xiaochouguai, Enemy.engine.cilpData_xiaochouguai, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 2: 
            case 22: 
            case 23: {
                this.rx = this.x - this.indent_bingganguai[this.curIndex][this.isMir ? 1 : 0];
                this.ry = this.y + this.indent_bingganguai[this.curIndex][2];
                Tools.addFrame(15, Enemy.engine.frameData_bingganguai, Enemy.engine.cilpData_bingganguai, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 3: 
            case 10: 
            case 21: 
            case 24: {
                this.rx = this.x - Enemy.engine.indent_lanyiguai[this.curIndex][this.isMir ? 1 : 0] - 6;
                this.ry = this.y + Enemy.engine.indent_lanyiguai[this.curIndex][2];
                Tools.addFrame(16, Enemy.engine.frameData_lanyiguai, Enemy.engine.cilpData_lanyiguai, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 4: 
            case 12: 
            case 18: {
                this.rx = this.x - Enemy.engine.indent_hesexiaochouguai[this.curIndex][this.isMir ? 1 : 0] - 9;
                this.ry = this.y + Enemy.engine.indent_hesexiaochouguai[this.curIndex][2];
                this.isMir = this.dir == 3;
                Tools.addFrame(17, Enemy.engine.frameData_hesexiaochouguai, Enemy.engine.cilpData_hesexiaochouguai, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 5: 
            case 11: 
            case 16: 
            case 25: {
                this.rx = this.x - GameEngine.indent_maomaochongguai[this.curIndex][this.isMir ? 1 : 0] - 5;
                this.ry = this.y + GameEngine.indent_maomaochongguai[this.curIndex][2];
                Tools.addFrame(18, Enemy.engine.frameData_maomaochongguai, Enemy.engine.cilpData_maomaochongguai, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 7: 
            case 15: 
            case 20: {
                this.rx = this.x - Enemy.engine.indent_lansefeiniaoguai[this.curIndex][this.isMir ? 1 : 0] - 4;
                this.ry = this.y + Enemy.engine.indent_lansefeiniaoguai[this.curIndex][2];
                this.isMir = this.dir == 3;
                Tools.addFrame(39, Enemy.engine.frameData_lansefeiniaoguai, Enemy.engine.cilpData_lansefeiniaoguai, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 13: 
            case 17: 
            case 28: {
                this.rx = this.x - this.indent_huangseqianting[this.curIndex][this.isMir ? 1 : 0];
                this.ry = this.y + this.indent_huangseqianting[this.curIndex][2];
                Tools.addFrame(28, Enemy.engine.frameData_huangseqianting, Enemy.engine.cilpData_huangseqianting, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
            case 14: 
            case 19: {
                this.rx = this.x - this.indent_qianshuiyuan[this.curIndex][this.isMir ? 1 : 0] - 6;
                this.ry = this.y + this.indent_qianshuiyuan[this.curIndex][2];
                Tools.addFrame(29, Enemy.engine.frameData_qianshuiyuan, Enemy.engine.cilpData_qianshuiyuan, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
                break;
            }
        }
        if (this.type == 3) {
            ++this.useSkillTime;
            this.produceGlass();
        }
        this.hitRole();
    }

    public void drawDieCloud() {
        if (this.enemyX != -1 && this.enemyY != -1) {
            this.visiable = false;
            this.curStatus = 0;
            this.motion = new byte[]{0, 0, 1, 1, 2, 2, 3, 3};
            if (++this.index >= this.motion.length) {
                Enemy.engine.enemy.removeElement(this);
                return;
            }
            this.curIndex = this.motion[this.index];
            this.rx = this.enemyX - this.indent_cloud[this.curIndex][this.isMir ? 1 : 0] + 12;
            this.ry = this.enemyY + this.indent_cloud[this.curIndex][2];
            Tools.addFrame(12, Enemy.engine.frameData_yanwu, Enemy.engine.cilpData_yanwu, this.rx, this.ry, this.curIndex, this.isMir, (byte)36, this.y + 2);
            this.drawScore(this.addScore, this.enemyX, this.enemyY);
        }
    }

    public int[] getSkipLoca() {
        this.map = Enemy.engine.map;
        int[] loca = new int[]{-1, -1};
        loca[0] = Enemy.engine.role.x / GameMap.tileWidth * GameMap.tileWidth;
        loca[1] = Enemy.engine.role.y / GameMap.tileHight * GameMap.tileHight;
        if (this.useSkillTime >= 200) {
            System.out.println("\u4f7f\u7528\u6280\u80fd");
            this.useSkillTime = 0;
            GameMap cfr_ignored_0 = Enemy.engine.map;
            loca[0] = GameMap.tileWidth * 4;
            GameMap cfr_ignored_1 = Enemy.engine.map;
            loca[1] = GameMap.tileHight * 4;
            this.putStons = true;
        }
        return loca;
    }

    public void enemySkip() {
        if (++this.sTime > 100) {
            this.sTime = 0;
        }
        if (this.skipOver) {
            this.loca = this.getSkipLoca();
        }
        int locaX = this.loca[0];
        int locaY = this.loca[1];
        if (this.x == locaX && this.y == locaY) {
            return;
        }
        this.upDownSkip(this.y, locaY);
        this.herizonSkip(this.x, locaX);
    }

    public void upDownSkip(int y, int locaY) {
        this.skipOver = false;
        this.curStatus = 1;
        this.upSkipTime = (short)(this.upSkipTime + 1);
        if (this.upSkipTime < 5) {
            this.y = y - this.vSpan;
        } else {
            if (locaY - this.y <= 2 * this.vSpan) {
                this.y = locaY;
                this.skipOver = true;
                this.curStatus = (byte)5;
                this.upSkipTime = 0;
                return;
            }
            this.y = y + this.vSpan * 2;
        }
    }

    public void herizonSkip(int x, int locaX) {
        this.span = x > locaX ? -20 : 20;
        if (x != locaX) {
            this.x = x + this.span;
        }
    }

    public void setStatus(byte status) {
        this.index = 0;
        lastStatus = this.curStatus;
        this.curStatus = status;
    }
}

