/*
 * Decompiled with CFR 0.152.
 */
package com.mroad.engine.act;

import com.mroad.engine.act.Animation;
import com.mroad.engine.act.Map;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ResourceHandle {
    private static String[] RFileName;
    private static int[] B_Block;
    private static int[] L_Block;
    private static byte[] ResFile;
    private static String MapImageName;
    private static String TileFileName;
    private static String MobFileName;
    private static byte PixelWidth;
    private static int ResFileLenght;
    private static Object obj;
    private static InputStream file;
    private static int RecentStartBlock;
    private static int RecentLenOfBlock;

    public static void OpenResFile(String string) {
        try {
            ResourceHandle.LoadResFile("/" + string);
            ResFileLenght = B_Block[RFileName.length - 1] + L_Block[RFileName.length - 1];
            file = obj.getClass().getResourceAsStream("/" + string);
            ResFile = new byte[ResFileLenght];
            file.read(ResFile, 0, ResFileLenght);
            file.close();
            file = null;
        }
        catch (Exception exception) {
            System.out.println("res init err: " + exception.toString());
        }
    }

    protected static void LoadMap(String string) {
        byte[] byArray = new byte[20];
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        try {
            if (ResourceHandle.GetFileIndex(string)) {
                int n;
                int n2;
                PixelWidth = ResFile[RecentStartBlock += 2];
                System.arraycopy(ResFile, ++RecentStartBlock, byArray, 0, 20);
                TileFileName = ResourceHandle.readString(byArray);
                System.arraycopy(ResFile, RecentStartBlock += 20, byArray, 0, 20);
                MobFileName = ResourceHandle.readString(byArray);
                s3 = ResFile[RecentStartBlock += 20];
                s = (short)(ResFile[++RecentStartBlock + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                s2 = (short)(ResFile[(RecentStartBlock += 2) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                Map.StartRow = ResFile[RecentStartBlock += 2];
                Map.StartCol = ResFile[++RecentStartBlock];
                ++RecentStartBlock;
                Map.Layers = new byte[s3][s][s2];
                Map.TileType = new byte[s][s2];
                for (n2 = 0; n2 < Map.Layers.length; ++n2) {
                    for (n = 0; n < Map.Layers[0].length; ++n) {
                        for (int i = 0; i < Map.Layers[0][0].length; ++i) {
                            Map.Layers[n2][n][i] = ResFile[RecentStartBlock];
                            ++RecentStartBlock;
                        }
                    }
                }
                for (n2 = 0; n2 < Map.Layers[0].length; ++n2) {
                    for (n = 0; n < Map.Layers[0][0].length; ++n) {
                        Map.TileType[n2][n] = ResFile[RecentStartBlock];
                        ++RecentStartBlock;
                    }
                }
            }
            byArray = null;
            System.gc();
        }
        catch (Exception exception) {
            System.out.println("Load map err: " + exception.toString() + " MapName:" + string);
        }
    }

    protected static void LoadTiles() {
        byte[] byArray = new byte[20];
        try {
            if (ResourceHandle.GetFileIndex(TileFileName)) {
                System.arraycopy(ResFile, RecentStartBlock, byArray, 0, 20);
                MapImageName = ResourceHandle.readString(byArray);
                MapImageName = MapImageName.substring(0, MapImageName.length() - 4) + ".png";
                short s = (short)(ResFile[(RecentStartBlock += 20) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                RecentStartBlock += 2;
                Map.TileIdPx = new short[s + 1];
                Map.TileIdPy = new short[s + 1];
                for (int i = 1; i < s + 1; ++i) {
                    Map.TileIdPx[i] = (short)(ResFile[++RecentStartBlock + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                    Map.TileIdPy[i] = (short)(ResFile[(RecentStartBlock += 2) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                    RecentStartBlock += 2;
                    RecentStartBlock += 4;
                }
            }
            byArray = null;
        }
        catch (Exception exception) {
            System.out.println("Load Tile Err:" + exception.toString());
        }
    }

    protected static Image LoadMapImage() {
        Image image = null;
        image = ResourceHandle.LoadImage(MapImageName);
        return image;
    }

    protected static final void LoadOblFile(String string) {
        byte[] byArray = new byte[20];
        try {
            if (ResourceHandle.GetFileIndex(string)) {
                int n = ResFile[RecentStartBlock];
                ++RecentStartBlock;
                Animation.NewSpriteObjectList(n);
                for (int i = 0; i < n; ++i) {
                    short s = (short)(ResFile[RecentStartBlock + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                    short s2 = (short)(ResFile[(RecentStartBlock += 2) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                    byte by = ResFile[RecentStartBlock += 2];
                    byte by2 = ResFile[++RecentStartBlock];
                    System.arraycopy(ResFile, ++RecentStartBlock, byArray, 0, 20);
                    String string2 = ResourceHandle.readString(byArray);
                    byte by3 = ResFile[RecentStartBlock += 20];
                    ++RecentStartBlock;
                    Animation.InsertSpriteObjdetList(i, s, (byte)s2, by, by2, by3, string2);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("load LoadOblFile error" + exception.toString());
        }
    }

    protected static final byte[] LoadSpriteInMap() {
        byte[] byArray = new byte[6];
        try {
            if (ResourceHandle.GetFileIndex(MobFileName)) {
                System.arraycopy(ResFile, RecentStartBlock += 2, byArray, 0, 6);
                RecentStartBlock += 6;
            }
        }
        catch (Exception exception) {
            System.out.println("LoadSpriteInMap error" + exception.toString());
        }
        return byArray;
    }

    protected static final byte[] Get_NextSprite() {
        byte[] byArray = new byte[44];
        try {
            System.arraycopy(ResFile, RecentStartBlock, byArray, 0, 44);
            RecentStartBlock += 44;
        }
        catch (Exception exception) {
            System.out.println("Get_NextSprite error" + exception.toString());
        }
        return byArray;
    }

    public static Image LoadImage(String string) {
        Image image = null;
        if (ResourceHandle.GetFileIndex(string)) {
            image = Image.createImage((byte[])ResFile, (int)RecentStartBlock, (int)RecentLenOfBlock);
        }
        return image;
    }

    protected static short[] LoadModule(String string) {
        short[] sArray = null;
        try {
            if (ResourceHandle.GetFileIndex(string)) {
                short s = (short)(ResFile[(RecentStartBlock += 20) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                RecentStartBlock += 2;
                sArray = new short[s * 4];
                for (int i = 0; i < s * 4; ++i) {
                    sArray[i] = (short)(ResFile[RecentStartBlock + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                    RecentStartBlock += 2;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("LoadModule Err: " + exception.toString() + string);
        }
        return sArray;
    }

    protected static byte[] LoadFrames(String string) {
        byte[] byArray = null;
        try {
            if (ResourceHandle.GetFileIndex(string)) {
                short s;
                int n;
                int n2 = ResFile[(RecentStartBlock += 20) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF;
                RecentStartBlock += 2;
                short s2 = (short)(n2 * 3 + 2);
                for (n = 0; n < n2; ++n) {
                    s = ResFile[RecentStartBlock];
                    ++RecentStartBlock;
                    s2 = (short)(s2 + s * 6);
                    RecentStartBlock += s * 6;
                }
                ResourceHandle.GetFileIndex(string);
                byArray = new byte[s2];
                n2 = (short)(ResFile[(RecentStartBlock += 20) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                byArray[0] = ResFile[RecentStartBlock];
                byArray[1] = ResFile[RecentStartBlock + 1];
                RecentStartBlock += 2;
                short s3 = (short)(n2 * 3 + 2);
                for (n = 0; n < n2; ++n) {
                    s = ResFile[RecentStartBlock];
                    byArray[n * 3 + 2] = (byte)(s3 << 8 >> 8 & 0xFF);
                    byArray[n * 3 + 3] = (byte)(s3 >> 8 & 0xFF);
                    byArray[n * 3 + 4] = (byte)s;
                    System.arraycopy(ResFile, ++RecentStartBlock, byArray, s3, s * 6);
                    RecentStartBlock += s * 6;
                    s3 = (short)(s3 + s * 6);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("LoadFrames Err: " + exception.toString() + string);
        }
        return byArray;
    }

    protected static byte[] LoadActions(String string) {
        byte[] byArray = null;
        try {
            if (ResourceHandle.GetFileIndex(string)) {
                int n;
                int n2;
                int n3 = ResFile[(RecentStartBlock += 20) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF;
                RecentStartBlock += 2;
                short s = (short)(n3 * 8 + 2);
                for (n2 = 0; n2 < n3; ++n2) {
                    n = ResFile[RecentStartBlock += 20];
                    ++RecentStartBlock;
                    s = (short)(s + n * 12);
                    RecentStartBlock += n * 22 + 5;
                }
                ResourceHandle.GetFileIndex(string);
                byArray = new byte[s];
                n3 = (short)(ResFile[(RecentStartBlock += 20) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                byArray[0] = ResFile[RecentStartBlock];
                byArray[1] = ResFile[RecentStartBlock + 1];
                RecentStartBlock += 2;
                short s2 = (short)(n3 * 8 + 2);
                for (n2 = 0; n2 < n3; ++n2) {
                    n = ResFile[RecentStartBlock += 20];
                    byArray[n2 * 8 + 2] = (byte)(s2 << 8 >> 8 & 0xFF);
                    byArray[n2 * 8 + 3] = (byte)(s2 >> 8 & 0xFF);
                    System.arraycopy(ResFile, ++RecentStartBlock, byArray, n2 * 8 + 4, 5);
                    RecentStartBlock += 5;
                    byArray[n2 * 8 + 9] = (byte)n;
                    for (int i = 0; i < n; ++i) {
                        byArray[s2 + i * 12] = ResFile[RecentStartBlock];
                        byArray[s2 + i * 12 + 1] = ResFile[++RecentStartBlock];
                        byArray[s2 + i * 12 + 2] = ResFile[++RecentStartBlock];
                        byArray[s2 + i * 12 + 3] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 4] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 5] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 6] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 7] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 8] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 9] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 10] = ResFile[RecentStartBlock += 2];
                        byArray[s2 + i * 12 + 11] = ResFile[RecentStartBlock += 2];
                        RecentStartBlock += 2;
                    }
                    s2 = (short)(s2 + n * 12);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("LoadAction Err: " + exception.toString() + string);
        }
        return byArray;
    }

    public static final void LoadSpriteExtentionProperties(String string) {
        int n = 0;
        int n2 = 0;
        if (ResourceHandle.GetFileIndex(string)) {
            try {
                n = ResFile[(RecentStartBlock += 20) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF;
                n2 = ResFile[(RecentStartBlock += 2) + 1] << 8 | ResFile[RecentStartBlock] & 0xFF;
                RecentStartBlock += 2;
                Animation.Extention_Properties = null;
                Animation.Extention_Properties = new short[n][n2];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        Animation.Extention_Properties[i][j] = (short)(ResFile[RecentStartBlock + 1] << 8 | ResFile[RecentStartBlock] & 0xFF);
                        RecentStartBlock += 2;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("LoadSpriteExtentionProperties: " + exception.toString());
            }
        }
    }

    private static final boolean GetFileIndex(String string) {
        boolean bl = false;
        for (int i = 0; i < RFileName.length; ++i) {
            if (!RFileName[i].equals(string)) continue;
            RecentStartBlock = B_Block[i];
            RecentLenOfBlock = L_Block[i];
            bl = true;
            break;
        }
        if (!bl) {
            System.out.println("Get File Error: " + string + " Not Found.");
        }
        return bl;
    }

    private static final void LoadResFile(String string) {
        try {
            Object object = new Object();
            InputStream inputStream = object.getClass().getResourceAsStream(string);
            int n = inputStream.read();
            RFileName = new String[n];
            B_Block = new int[n];
            L_Block = new int[n];
            for (int i = 0; i < n; ++i) {
                ResourceHandle.RFileName[i] = ResourceHandle.readString(inputStream, (byte)20);
                ResourceHandle.B_Block[i] = ResourceHandle.readInt(inputStream);
                ResourceHandle.L_Block[i] = ResourceHandle.readInt(inputStream);
            }
            inputStream.close();
            inputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            System.out.println("LoadResFile: " + exception.toString() + string);
        }
    }

    protected static byte GetPixelWidth() {
        return PixelWidth;
    }

    private static String readString(InputStream inputStream, byte n) throws IOException {
        byte[] byArray = new byte[n];
        StringBuffer stringBuffer = new StringBuffer();
        inputStream.read(byArray);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString().trim();
    }

    private static int readInt(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        inputStream.read(byArray);
        return (byArray[3] & 0xFF) << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
    }

    private static String readString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString().trim();
    }

    public static void Destroy() {
        RFileName = null;
        B_Block = null;
        L_Block = null;
        MapImageName = null;
        TileFileName = null;
        MobFileName = null;
        ResFile = null;
        try {
            System.gc();
            Thread.yield();
            Thread.sleep(500L);
        }
        catch (Exception exception) {
            System.out.println("FreeRes Err: " + exception.toString());
        }
    }

    static {
        PixelWidth = 0;
        obj = new Object();
        RecentStartBlock = 0;
        RecentLenOfBlock = 0;
    }
}

