import java.util.*;

/**
 * <p>Title: ű</p>
 * <p>Description: ű ¼</p>
 * <p>Copyright: Copyright (c) 2009</p>
 * <p>Company: SG</p>
 * @version 1.0
 */

public class Event {

  /*------------------------------ű---------------------------------------*/

//  ָ | () | () | ()
//  000 00000 00000000
//  ָṹһshort , (ǰ8λ)ָ,(8λ)
//  ṹ: ÿռһshort, (ǰ3λ),(13λ)ֵ
//  ֵΪ8191
//  ֵΧ,ΪbigIntݽṹ

  /*------------------------------ָ------------------------------*/
  //ű
  static final byte up = 0;
  static final byte right = 1;
  static final byte down = 2;
  static final byte left = 3;

  static final byte add = 9;

  //ϵͳָ
  static final short S_IF = 0xFF;
  static final short S_ENDIF = 0xFE;
  static final short S_LOOP = 0xFD;
  static final short S_ENDLOOP = 0xFC;
  static final short S_LEFT = 0xFB; //
  static final short S_RIGHT = 0xFA; //Ҵ
  static final short S_SYNC = 0xEF;
  static final short S_ENDSYNC = 0xEE;
  static final short S_ELSE = 0xED;

  //ָͨ
//  static final short O_SHOWTEXT = 0x00;

  /*-------------------------------------------------------------------*/

  static final short T_IEXP = 0; //ֵΪʽбindex(Int)
  static final short T_BEXP = 1; //ֵΪʽбindex(Boolean)
  static final short T_STR = 2; //ֵΪַбindex
  static final short T_ARRAY = 3; //ֵΪ鳤
  static final short T_INT_B = 4; //ֵΪֵбindex
  static final short T_INT = 5; //ֵΪһֵ
  static final short T_INT_M = 6; //ֵΪһֵ
  static final short T_BOOL = 7; //ֵΪһboolͶֵ

  /*
    type commonEvent
   id -1
   condition area,160,560,64,16
   keyOK false
    type commonEvent
   id 0
   condition null
   keyOK false
   */

  /*--------------------------------ű-----------------------------------*/
  static String[] exp; //ַ
  static int[] bInt; //ֵ
  static short[][] array; //鼯
  /*---------------------------------ָṹ----------------------------------*/

  int getOrder(short order) {
//    return (order >> 8) & 0xff;
    return order;
  }

  int getOrderLen(short order) {
    return order & 0xff;
  }

  /*---------------------------------ȡ----------------------------------*/
  static int getInt(short param) {
    int type = getParamType(param);
    int value = getParamValue(param);
    switch (type) {
      case T_INT:
        return value;
      case T_INT_M:
        return -value;
      case T_INT_B:
        return bInt[value];
      case T_IEXP:
        return getIntValue(exp[value]);
      default:
        return Integer.MAX_VALUE;
    }
  }

  static boolean getBool(short param) {
    int type = getParamType(param);
    int value = getParamValue(param);
    switch (type) {
      case T_BOOL:
        return value == 0;
      case T_BEXP:
        return conditionIsTrue(exp[value]);
      default:
        return false;
    }
  }

  static String getString(short param) {
    int index = getParamValue(param);
    if (index == 8191) {
      return "null";
    }

    return parseStr(exp[index]);
  }

  static short[] getArray(short param) {
    int index = getParamValue(param);
    if (index == -1) {
      return null;
    }
    return array[index];
  }

  static int getParamType(short param) { //ȡ
    return (param >> 13) & 0x07;
  }

  static int getParamValue(short param) { //ȡֵ
    return param & 0x1fff;
  }

  /*---------------------------------ָ״̬----------------------------------*/
  static final byte ORDER_READY = 0;
  static final byte ORDER_GO = 1;
  static final byte ORDER_END = 2;

  /*-------------------------------------------------------------------*/
  static Vector path = new Vector(); //·
  static void free() {
    path.removeAllElements();
    exp = null;
    bInt = null;
    array = null;
  }

  /*-------------------------------------------------------------------*/

  /*-------------------------------------------------------------------*/

  /*-------------------------------------------------------------------*/

//  static final String COMMAND_IF = "if";
//  static final String COMMAND_ELSE = "else";
//  static final String COMMAND_ENDIF = "endIf"; //IF
//  static final String COMMAND_SYNC = "sync"; //ͬ,ͬʱ
//  static final String COMMAND_ENDSYNC = "endSync"; //ͬ
//  static final String COMMAND_LOOP = "loop"; //ѭ
//  static final String COMMAND_ENDLOOP = "endLoop"; //ѭ

//  static final String ORDER_STATUS_READY = "ready";
//  static final String ORDER_STATUS_GO = "go";
//  static final String ORDER_STATUS_END = "end";

  static final int BLOCK_SYNC = 0;
  static final int BLOCK_STEP = 1;

  /*------------------------------ָṹ-----------------------------*/
  //

  private Vector vRoot = new Vector(); //0 type,1 status ,2 curLine,3 ... dat
  public String typeName;
  public int id;
  static int waitTime; //ȴʱ

  public Event() {
//    v = new Vector();
  }

  public void init(short[][] contents) {
//    if (v.size() == 0) {
//      System.out.println("script error!!!");
//      return;
//    }
//    short[][] contents = new short[v.size()][];
//    v.copyInto(contents);
//    v.removeAllElements();
//    v = null;

    vRoot = parseOrderGroup(contents, 0, contents.length, "", BLOCK_STEP);
  }

  short[] prop; //¼
  public void endInit() {
    for (int i = 0; i < prop.length; i++) {
      int type = getParamType(prop[i]);
      int value = getParamValue(prop[i]);
//      System.out.println("prop  "+prop[i]+"    "+type+"  "+value);
    }

    id = getInt(prop[1]);
    setCondition(getString(prop[2]));
    isKeyAlive = getBool(prop[3]);
    prop = null;
  }

  boolean isReturn = false;
  boolean isSave = false;

  public void run() {
    if (id >= 0 && (Script.scriptVar[id] != 0)) {
      return;
    }
    if (!eventIsAlive) {
      checkEventCondition();
    }
    if (eventIsAlive) {
      runOrder(vRoot);
      if (sToi( (String) vRoot.elementAt(1)) == ORDER_END) {

        eventIsAlive = false;
        if (id < 0 || Script.scriptVar[id] == 0) {
          initVector(vRoot);

//          Script.isUserCtrl = true;
        }

        GameEngine.noStop();
      }
    }

    if (isReturn) {
      if (id < 0 || Script.scriptVar[id] == 0) {
        initVector(vRoot);
      }
      Script.isUserCtrl = true;
      isReturn = false;
    }
  }

  public void runBattle() {
    if (id >= 0 && Script.scriptVar[id] != 0) {
      return;
    }
    runOrder(vRoot);
    if (sToi( (String) vRoot.elementAt(1)) == ORDER_END) {
      eventIsAlive = false;
      if (id < 0 || Script.scriptVar[id] == 0) {
        initVector(vRoot);
      }
    }

  }

  /*---------------------------------¼-----------------------------*/
  public static final int OCCUR_ERROR = -1; //
  public static final int OCCUR_AREA = 0; //򴥷
  public static final int OCCUR_SPRITE = 1; //NPC
  public static final int OCCUR_NULL = 2; //
  public static final int OCCUR_NEXT_AREA = 3; //򴥷(ǰ)
  public static final int OCCUR_EXPRESSION = 4; //ʽ

  private int occurType; //¼
  private int[] occurNpcs;
  private int[] area;
  private String expression;
  private void setCondition(String str) { //¼Ĵ
    String condition = str.substring(str.indexOf(' ') + 1, str.length());
    String[] param = getParams(condition, ",");

    String type = param[0];
    if (type.equals("area")) {
      occurType = OCCUR_AREA;
      area = new int[] {
          sToi(param[1]) - 1, sToi(param[2]),
          sToi(param[3]), sToi(param[4])};
    }
    else if (type.equals("nextArea")) {
      occurType = OCCUR_NEXT_AREA;
      area = new int[] {
          sToi(param[1]) - 1, sToi(param[2]),
          sToi(param[3]), sToi(param[4])};
    }
    else if (type.equals("sprite")) {
      occurNpcs = new int[param.length - 1];
      for (int i = 0; i < occurNpcs.length; i++) {
        occurNpcs[i] = sToi(param[i + 1]);
      }
      occurType = OCCUR_SPRITE;
      isKeyAlive = false;
    }
    else if (type.equals("null")) {
      occurType = OCCUR_NULL;
    }
    else if (type.equals("expression")) {
      occurType = OCCUR_EXPRESSION;
      expression = param[1];
    }
    else {
      occurType = OCCUR_ERROR;
    }
  }

  boolean eventIsAlive;
  boolean inEventArea = true;
  public boolean isKeyAlive;
  private void checkEventCondition() {
    if (!Script.isUserCtrl) {
      return;
    }
    int posX = GameEngine.sprite[GameEngine.spriteIndex].ax;
    int posY = GameEngine.sprite[GameEngine.spriteIndex].ay;
    if (GameEngine.sprite[GameEngine.spriteIndex].x != posX ||
        GameEngine.sprite[GameEngine.spriteIndex].y != posY + GameSprite.offY) {
      return;
    }
    if (occurType == OCCUR_SPRITE || occurType == OCCUR_NEXT_AREA) {
      switch (GameEngine.sprite[GameEngine.spriteIndex].dir) {
        case GameSprite.DIR_DOWN:
          posX += 8;
          posY += 8;
          break;
        case GameSprite.DIR_UP:
          posX += 8;
          posY += -16 - 8;
          break;
        case GameSprite.DIR_RIGHT:
          posX += 16 + 8;
          posY += -8;
          break;
        case GameSprite.DIR_LEFT:
          posX += -8;
          posY += -8;
          break;
      }
    }
    switch (occurType) {
      case OCCUR_EXPRESSION:
        if (conditionIsTrue(expression)) {
          eventIsAlive = true;
        }
        break;
      case OCCUR_NULL:
        eventIsAlive = true;
        break;
      case OCCUR_AREA:
      case OCCUR_NEXT_AREA:
        if (inEventArea) {
          if (!Tools.hit(posX, posY, 0, 0, area[0], area[1], area[2], area[3])) {
            inEventArea = false;
          }
        }
        else {
          if (Tools.hit(posX, posY, 0, 0, area[0], area[1], area[2], area[3])) {
            if (!isKeyAlive) {
              inEventArea = true;
              eventIsAlive = true;
            }
            else {
              if (MyGameCanvas.confirmKey) {
                eventIsAlive = true;
              }
            }
          }
        }
        break;
      case OCCUR_SPRITE:
        if (occurNpcs == null) {
          return;
        }
        if (!MyGameCanvas.confirmKey) {
          return;
        }
        for (int i = 0; i < occurNpcs.length; i++) {
//          if (GameEngine.sprite[occurNpcs[i]].modle == 36) {
//            GameEngine.sprite[occurNpcs[i]].curStates = (GameSprite.ST_MAGIC1);
//          }
          if (GameEngine.sprite[occurNpcs[i]].visible &&
              Tools.hit(posX, posY, 0, 0,
                        GameEngine.sprite[occurNpcs[i]].x,
                        GameEngine.sprite[occurNpcs[i]].y,
                        16, 16)) {
            eventIsAlive = true;
            if (GameEngine.sprite[occurNpcs[i]].modle != 36) {
              GameEngine.sprite[occurNpcs[i]].isStop = true;
            }
            stopCurSprite();

//            GameEngine.sprite[GameEngine.spriteIndex].isStop = true;

            break;
          }

        }

        break;
    }

  }

//  Vector v = null;
//  public void init(String str) {
//    String command = getCommand(str);
//    if (command.equals("type")) {
//      typeName = getParams(str, " ")[1].trim();
//    }
//    else if (command.equals("id")) {
//      id = sToi(getParams(str, " ")[1]);
//    }
//    else if (command.equals("condition")) {
//      setCondition(getParams(str, " ")[1]);
//    }
//    else if (command.equals("keyOK")) {
//      isKeyAlive = getParams(str, " ")[1].equals("true");
//    }
//    else if (command.indexOf(".") != -1) {
//      int start = str.indexOf(" ") + 1;
//      String s = str.substring(start, str.length()).trim();
//      if (!s.equals("")) {
//        v.addElement(s);
//      }
//    }
//  }

  private static String trim(String str) {
    StringBuffer sb = new StringBuffer();
    for (int i = 0; i < str.length(); i++) {
      char c = str.charAt(i);
      if (c != ' ') {
        sb.append(c);
      }
    }
    return sb.toString();
  }

//  private Vector parseOrderGroup(String[] s, int start, int end,
//                                 String parentName, int type) {
//
//    //{ָ  Ƿ,ID}
//    int count = 3;
//    Vector v = new Vector();
//    v.addElement("" + type);
//    v.addElement(ORDER_STATUS_READY);
//    v.addElement("3");
//    if (start > 0) {
//      v.addElement(new String[] {s[start - 1], ORDER_STATUS_READY,
//                   parentName + "|" + (count++)});
//    }
//    for (int i = start; i < end; i++) {
//      String name = parentName + "|" + (count++);
//      String command = getCommand(s[i]);
//      if (strCmp(command, "{") == 0) { //{
//        int endIndex = getEndIndex(s, i, "{", "}");
//        v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_STEP));
//        i = endIndex;
//      }
//      else if (strCmp(command, COMMAND_IF) == 0) { //if
//        int endIndex = getEndIndex(s, i, COMMAND_IF, COMMAND_ENDIF);
//        v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_STEP));
//        i = endIndex;
//      }
//      else if (strCmp(command, COMMAND_LOOP) == 0) { //loop
//        int endIndex = getEndIndex(s, i, COMMAND_LOOP, COMMAND_ENDLOOP);
//        v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_STEP));
//        i = endIndex;
//      }
//      else if (strCmp(command, COMMAND_SYNC) == 0) { //sync
//        int endIndex = getEndIndex(s, i, COMMAND_SYNC, COMMAND_ENDSYNC);
//        v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_SYNC));
//        i = endIndex;
//      }
//      else {
//        //ͨ
//        v.addElement(new String[] {s[i], ORDER_STATUS_READY, name});
//      }
//    }
//    return v;
//  }

  short setPath(String orderPath) {
    path.addElement(orderPath);
//    System.out.println("path  " + orderPath + "  " + (path.size() - 1));
    return (short) (path.size() - 1);
  }

  void addElement(Vector v, short state, String path, short[] s) {
    short[] temp = new short[s.length + 2];
    temp[0] = state;
    temp[1] = setPath(path);
    System.arraycopy(s, 0, temp, 2, s.length);
    v.addElement(temp);
  }

  private Vector parseOrderGroup(short[][] s, int start, int end,
                                 String parentName, int type) {

    //{ָ  Ƿ,ID}
    int count = 3;
    Vector v = new Vector();
    v.addElement("" + type);
    v.addElement("" + ORDER_READY);
    v.addElement("3");
    if (start > 0) {
      addElement(v, ORDER_READY, parentName + "|" + (count++), s[start - 1]);
    }
    for (int i = start; i < end; i++) {
      String name = parentName + "|" + (count++);
      int command = getOrder(s[i][0]);
      switch (command) {
        case S_LEFT:
          int endIndex = getEndIndex(s, i, S_LEFT, S_RIGHT);
          v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_STEP));
          i = endIndex;
          break;
        case S_IF:
          endIndex = getEndIndex(s, i, S_IF, S_ENDIF);
          v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_STEP));
          i = endIndex;
          break;
        case S_LOOP:
          endIndex = getEndIndex(s, i, S_LOOP, S_ENDLOOP);
          v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_STEP));
          i = endIndex;

          break;
        case S_SYNC:
          endIndex = getEndIndex(s, i, S_SYNC, S_ENDSYNC);
          v.addElement(parseOrderGroup(s, i + 1, endIndex + 1, name, BLOCK_SYNC));
          i = endIndex;

          break;
        default: //ͨ
          addElement(v, ORDER_READY, name, s[i]);
          break;
      }
    }
    return v;
  }

  private int getElseIndex(Vector v) {
    for (int i = 3; i < v.size(); i++) {
      Object obj = v.elementAt(i);
      if (obj instanceof Vector) { //ָ
        continue;
      }
      else {
        int command = getCommand( (short[]) obj);
        if (command == S_ELSE) {
          return i;
        }
      }
    }
    return -1;
  }

  private int getEndIndex(short[][] str, int cLine, final short begin,
                          final short end) {
    int level = 0;
    for (int i = cLine; i < str.length; i++) {
//      short[] script = str[i];
      int command = getOrder(str[i][0]); // getCommand(str[i]);
      if (command == begin) {
        level++;
      }
      else if (command == end) {
        if (--level == 0) {
          return i;
        }
      }
    }
    return -1;
  }

//  public void setEnd(String command) {
//    getOrderEnd(vRoot, command);
//  }

  public void setEnd(int pathIndex) {
    String orderPath = (String) path.elementAt(pathIndex);
    getOrderEnd(vRoot, orderPath);
  }

  private short getOrderEnd(Vector vector, String orderPath) {
    int len = vector.size();
    if (len <= 0) {
      return ORDER_END;
    }
    int end = orderPath.indexOf('|', 1);
    if (end == -1) {
      end = orderPath.length();
    }
    int type = sToi( (String) vector.elementAt(0));
    int curLine = sToi(orderPath.substring(1, end));
    switch (type) {
      case BLOCK_STEP:
        Object obj = vector.elementAt(curLine);
        if (obj instanceof Vector) {
          Vector subclass = (Vector) obj;
          String subName = orderPath.substring(end, orderPath.length());
          short state = getOrderEnd(subclass, subName);
          if (state == ORDER_END) {
            String sCurLine = "" +
                (sToi( (String) (vector.elementAt(2))) + 1);
            vector.setElementAt(sCurLine, 2); //curLine++a
            if (curLine == vector.size() - 1) {
              vector.setElementAt("" + ORDER_END, 1);
              return ORDER_END;
            }
            else {
              return ORDER_READY;
            }
          }
          else {
            return ORDER_READY;
          }
        }
        else {
          String sCurLine = "" +
              (sToi( (String) (vector.elementAt(2))) + 1);
          vector.setElementAt(sCurLine, 2); //curLine++
          short[] tmp = (short[]) vector.elementAt(curLine);
          tmp[0] = ORDER_END;
          if (curLine == vector.size() - 1) {
            vector.setElementAt("" + ORDER_END, 1);
            return ORDER_END;
          }
          else {
            return ORDER_READY;
          }
        }
      case BLOCK_SYNC:
        short result = ORDER_END;
        for (int i = 4; i < vector.size() - 1; i++) { //3-sync
          obj = vector.elementAt(i);
          if (obj instanceof Vector) {
            Vector subclass = (Vector) obj;
            if (i == curLine) {
              String subName = orderPath.substring(end, orderPath.length());
              int state = getOrderEnd(subclass, subName);
              if (state != ORDER_END) {
                result = ORDER_READY;
              }
            }
            else {
              int state = sToi( (String) (subclass.elementAt(1)));
              if (state != ORDER_END) {
                result = ORDER_READY;
              }
            }
          }
          else {
            short[] tmp = (short[]) obj;
            if (i == curLine) {
              tmp[0] = ORDER_END;
            }
            if (tmp[0] != ORDER_END) { //
              result = ORDER_READY;
            }
          }
        }
        vector.setElementAt("" + result, 1);
        return result;
    }
    return ORDER_END;
  }

  private void runOrder(Vector vector) {
    if (vector.size() <= 0) {
      return;
    }
    if (sToi( (String) vector.elementAt(1)) == ORDER_END) {
      return;
    }
    int type = sToi( (String) vector.elementAt(0));
    switch (type) {
      case BLOCK_STEP:
        int curLine = sToi( (String) vector.elementAt(2));
        Object obj = vector.elementAt(curLine);
        if (obj instanceof Vector) { //ָ
          Vector subclass = (Vector) obj;
          runOrder(subclass);
        }
        else { //һָ
          short[] order = (short[]) obj;
          int command = getCommand(order);
          switch (command) {
            case S_LOOP:
              String condition = getCondition(exp[getParamValue(order[3])]);
              if (conditionIsTrue(trim(condition))) {
                initVector(vector);
                curLine = curLine + 1;
              }
              else {
                curLine = vector.size() - 1;
                vector.setElementAt("" + curLine, 2); //curLine++
                obj = vector.elementAt(curLine);
                setEnd( ( (short[]) obj)[1]); //          Ӧ
                return;
              }
              vector.setElementAt("" + curLine, 2); //curLine++
              runOrder(vector);
              break;
            case S_IF:
              condition = getCondition(exp[getParamValue(order[3])]);
              String sCurLine = "";
              if (conditionIsTrue(trim(condition))) {
                curLine = curLine + 1;
              }
              else {
                int elseIndex = getElseIndex(vector);
                if (elseIndex != -1) {
                  curLine = elseIndex + 1;
                }
                else {
                  curLine = vector.size() - 1;
                  sCurLine = "" + curLine;
                  vector.setElementAt(sCurLine, 2); //curLine++
                  obj = vector.elementAt(curLine);
                  setEnd( ( (short[]) obj)[1]); //          Ӧ
                  return;
                }
              }
              vector.setElementAt("" + curLine, 2); //curLine++
              runOrder(vector);
              break;
            case S_SYNC:
            case S_LEFT:
              sCurLine = "" + (sToi( (String) (vector.elementAt(2))) + 1);
              vector.setElementAt(sCurLine, 2); //curLine++
              runOrder(vector);
              break;
            case S_ELSE:
              curLine = vector.size() - 1;
              vector.setElementAt("" + curLine, 2); //curLine++
              obj = vector.elementAt(curLine);
              setEnd( ( (short[]) obj)[1]); //          Ӧ
              break;
            case S_ENDSYNC:
            case S_ENDIF:
            case S_RIGHT:
              sCurLine = "" + (sToi( (String) (vector.elementAt(2))) + 1);
              vector.setElementAt(sCurLine, 2); //curLine++
              setEnd( ( (short[]) obj)[1]); //          Ӧ
              break;
            case S_ENDLOOP:
              curLine = 3; //3 head
              vector.setElementAt("" + curLine, 2); //curLine++
              runOrder(vector);
              break;
            default:
              parseOrder( (short[]) obj);
              break;
          }
        }
        break;
      case BLOCK_SYNC:
        for (int i = 4; i < vector.size() - 1; i++) { //sync-endSync
          obj = vector.elementAt(i);

          if (obj instanceof Vector) { //ָ
            Vector subclass = (Vector) obj;
            runOrder(subclass);
          }
          else {
            parseOrder( (short[]) obj);
          }
        }
        break;
    }
  }

  private void initVector(Vector v) { //ʼloop¼
    for (int i = 0; i < v.size(); i++) {
      Object obj = v.elementAt(i);
      switch (i) {
        case 0:
          break;
        case 1:
          v.setElementAt("" + ORDER_READY, 1);
          break;
        case 2:
          v.setElementAt("3", 2);
          break;
        default:
          if (obj instanceof Vector) { //ָ
            initVector( (Vector) obj);
          }
          else {
            short[] order = (short[]) obj;
            order[0] = ORDER_READY;
          }
          break;
      }
    }
  }

  static final short o_complete = 0x01;
  static final short o_setScene = 0x02;
  static final short o_changeItem = 0x03;
  static final short o_showText = 0x04;
  static final short o_ctrl = 0x05;
  static final short o_set = 0x06;
  static final short o_break = 0x07;
  static final short o_move = 0x08;
  static final short o_wait = 0x09;
  static final short o_npcAppear = 0x0A;
  static final short o_npcDisappear = 0x0B;
  static final short o_setDir = 0x0C;
  static final short o_setFace = 0x0D;
  static final short o_step = 0x0E;
  static final short o_showAction = 0x0F;
  static final short o_showChoice = 0x10;
  static final short o_setCamera = 0x11;
  static final short o_gameOver = 0x12;
  static final short o_setTeam = 0x13;
  static final short o_initEmy = 0x14;
  static final short o_setBattle = 0x15;
  static final short o_breakBattle = 0x16;
  static final short o_addLog = 0x17;
  static final short o_delLog = 0x18;
  static final short o_changeSkill = 0x19;
  static final short o_changeEquip = 0x1A;
  static final short o_changeTaskItem = 0x1B;
  static final short o_changeGod = 0x1C;
  static final short o_getSoul = 0x1D;
  static final short o_changeExp = 0x1E;
  static final short o_changeMoney = 0x1F;
  static final short o_showEffect = 0x20;
  static final short o_showEffectEx = 0x21;
  static final short o_removeEffectEx = 0x22;
  static final short o_random = 0x23;
  static final short o_showCG = 0x24;
  static final short o_aside = 0x25;
  static final short o_changeSpeed = 0x26;
  static final short o_changeFrequency = 0x27;
  static final short o_buyEquip = 0x28;
  static final short o_buyItem = 0x29;
  static final short o_sellItem = 0x2A;
  static final short o_sellEquip = 0x2B;
  static final short o_rest = 0x2C;
  static final short o_save = 0x2D;
  static final short o_changeLevel = 0x2E;
  static final short o_changeBGM = 0x2F;
  static final short o_chargePoint = 0x30;
  static final short o_showGame = 0x31;
  static final short o_screenFlash = 0x32;
  static final short o_setStatus = 0x33;
  static final short o_changeBomb = 0x34;
  static final short o_screenWhite = 0x35;
  static final short o_shake = 0x36;
  static final short o_stopBattle = 0x37;
  static final short o_fullHp = 0x38;
  static final short o_setRunXY = 0x39;
  static final short o_changeModle = 0x3A;
  static final short o_filmStart = 0x3B;
  static final short o_filmEnd = 0x3C;
  static final short o_setNpcStatus = 0x3D;
  static final short o_taskFlag = 0x3E;
  static final short o_refresh = 0x3F;
  static final short o_stop = 0x40;
  static final short o_flash = 0x41;
  static final short o_refine = 0x42;
  static final short o_blackBG = 0x43;
  static final short o_lookMode = 0x44;
  static final short o_showHead = 0x45;
  static final short o_setWeather = 0x46;
  static final short o_showLight = 0x47;
  static final short o_closeLight = 0x48;
  static final short o_showHole = 0x49;
  static final short o_setIsMotion = 0x4A;
  static final short o_savePos = 0x4B;
  static final short o_loadPos = 0x4C;
  static final short o_setEquips = 0x4D;
  static final short o_soulRefine = 0x4E;
  static final short o_teach = 0x4F;
  static final short o_getNpcStatus = 0x50;
  static final short o_showNoMap = 0x51;
  static final short o_ismove = 0x52;
  static final short o_on = 0x53;

  static final short o_down = 0x54;
  static final short o_checkPillar = 0x55;
  static final short o_blackHole = 0x56;
  static final short o_sellSoul = 0x57;
  static final short o_buySoul = 0x58;
  static final short o_erupt = 0x59;
  static final short o_specialSave = 0x60;


  static final short p_0 = 3;
  static final short p_1 = 4;
  static final short p_2 = 5;
  static final short p_3 = 6;
  static final short p_4 = 7;
  static final short p_5 = 8;

  private void parseOrder(short[] order) { //ָ
    if (order[0] != ORDER_READY) {
      return;
    }
//    for (int i = 0; i < order.length; i++) {
//      System.out.print("" + order[i] + ",");
//    }
//    System.out.println("");
    order[0] = ORDER_GO;
    int command = getCommand(order);
    System.out.println("command====="+command);
    if(command==o_specialSave){
      System.out.println("jjjjjjjjjjjjjjjjjjjjjjjj");
    }
    switch (command) {
      case o_complete:
        int result = getInt(order[p_0]);
        if (id >= 0) {
          Script.scriptVar[id] = (byte) result;
          if (result > 0) {
            eventIsAlive = false;
          }
        }
        if (isChangeMap) {
          changeMap();
        }
        if (isBreakBattle) {
          isBreakBattle = false;
        }
        System.out.println("isSave==="+isSave);
        if (isSave) {
          MyGameCanvas.setST(MyGameCanvas.ST_SAVE);
          isSave = false;
        }
        break;
      case o_setScene:
        int mapID = getInt(order[p_0]);
        int x = getInt(order[p_1]);
        int y = getInt(order[p_2]);
        int dir = getInt(order[p_3]); //GameSprite.getDir(getString(order[p_3]))
        boolean visible = getBool(order[p_4]);
        toMap(mapID, x, y, dir, visible);
        stopCurSprite();
        break;

      case o_changeItem: //Ʒ

        boolean isAdd = getInt(order[p_0]) == add;
        int itemId = getInt(order[p_1]);
        int val = getInt(order[p_2]);
        if (isAdd) {
          GameEngine.getItem(GameEngine.items, GameEngine.item, itemId, val, true);
          MyGameCanvas.sender(this, order[1]);
          return;
        }
        else {
          GameEngine.dropItem(GameEngine.items, itemId, val);
        }
        break;
      case o_down:
        MyGameCanvas.me.initLineData();
        MyGameCanvas.isJump = true;
        MyGameCanvas.sender(this, order[1]);
        return;
//        break;
      case o_blackHole:
        if (MyGameCanvas.showBlackHole) {
          MyGameCanvas.showBlackHole = false;
          MyGameCanvas.me.freeBlackHole();
        }
        else {
          MyGameCanvas.me.initBlackHole();
          MyGameCanvas.showBlackHole = true;
        }
        break;
      case o_showText:
        int iconID = getInt(order[p_0]);
        int derection = getInt(order[p_1]);
        String title = getString(order[p_2]);
        String text = getString(order[p_3]);
        MyGameCanvas.initTalk( (byte) iconID, (byte) derection, title,
                              text, false);
        stopCurSprite();
        break;
      case o_ctrl:
        Script.isUserCtrl = getBool(order[p_0]);
        stopCurSprite();

//        if (Script.isUserCtrl) {
//          GameEngine.noStop();
//        }
        break;
      case o_set:
        String str1 = getString(order[p_0]);
        String str2 = getString(order[p_1]);
        set(str1, str2);
        break;
      case o_break:
        result = getInt(order[p_0]);
        if (id >= 0) {
          Script.scriptVar[id] = (byte) result;
        }
        eventIsAlive = false;
        isReturn = true;
        if (isChangeMap) {
          changeMap();
        }
        if (isBreakBattle) {
          isBreakBattle = false;
        }
        GameEngine.noStop();
        break;
      case o_move:
        System.out.println("enter move");
        int npcId = getInt(order[p_0]);
        x = getInt(order[p_1]);
        y = getInt(order[p_2]);
        System.out.println("npcId = " + npcId);
        System.out.println("x = " + x);
        System.out.println("y = " + y);
        GameEngine.sprite[npcId].setNextPoint(x, y);
        GameEngine.sprite[npcId].sender(this, order[1]);
        return;
      case o_wait:
        System.out.println("enter wait");
        waitTime = getInt(order[p_0]);
        break;
      case o_npcAppear:
        npcId = getInt(order[p_0]);
        x = getInt(order[p_2]);
        y = getInt(order[p_3]);
        dir = getInt(order[p_4]);
        GameEngine.sprite[npcId].setStates(GameSprite.ST_STOP);
        GameEngine.sprite[npcId].setVisible(x, y, dir);
        break;
      case o_npcDisappear:
        npcId = getInt(order[p_0]);
        GameEngine.sprite[npcId].setUnVisible();
        break;
      case o_setDir:
        npcId = getInt(order[p_0]);
        dir = getInt(order[p_1]);
        GameEngine.sprite[npcId].setDir(dir);
        break;
      case o_setFace:
        npcId = getInt(order[p_0]);
        int face = getInt(order[p_1]);
        GameEngine.sprite[npcId].showFace(face);
        GameEngine.sprite[npcId].sender(this, order[1]);
        return;
      case o_step:
        npcId = getInt(order[p_0]);
        boolean isBack = getBool(order[p_1]);
        int steps = getInt(order[p_2]);
        boolean isCurSprite = getBool(order[p_3]);
        npcId = isCurSprite ? GameEngine.spriteIndex : npcId;
        GameEngine.sprite[npcId].step(isBack, steps);
        GameEngine.sprite[npcId].sender(this, order[1]);
        return;
      case o_showAction:
        npcId = getInt(order[p_0]);
        byte statusID = (byte) getInt(order[p_1]);
        byte[] states = {
            GameSprite.ST_JUMP, GameSprite.ST_INCURE, GameSprite.ST_DEAD,
            GameSprite.ST_MAGIC1, GameSprite.ST_STOP};
        GameEngine.sprite[npcId].showAction(states[statusID]);
        GameEngine.sprite[npcId].sender(this, order[1]);
        return;
      case o_showChoice:
        isBack = getBool(order[p_0]);
        title = getString(order[p_1]);
        String[] options = getParams(getString(order[p_2]), ",");
        GameEngine.toChooseStatus(title, options, isBack);
        stopCurSprite();
        break;
      case o_setCamera:
        GameEngine.isToPoint = false;
        String[] params = getParams(getString(order[p_0]), ",");
        if (params.length == 1) { //ֻ1ʾspriteID
          int spriteID = sToi(params[0]);
          GameEngine.spriteIndex = (byte) spriteID;
        }
        else {
          x = sToi(params[0]);
          y = sToi(params[1]);
          GameEngine.posX = x;
          GameEngine.posY = y;
          GameEngine.isToPoint = true;
        }
        GameEngine.map.sender(this, order[1]);
        GameMap.isMoveScreen = true;
        stopCurSprite();
        return;
      case o_gameOver:
        GameEngine.setGameFinish();
        break;
      case o_setTeam:
        short[] team = getArray(order[p_0]);
        GameEngine.roleTeam = new byte[team.length];
        for (int i = 0; i < team.length; i++) {
          GameEngine.roleTeam[i] = (byte) team[i];
        }
        break;
      case o_initEmy:

//        System.out.println("~~~~~~~~~~ = ");
        int type = getInt(order[p_0]);
        GameEngine.addEnemy(type);
        break;
      case o_setBattle:

//        System.out.println("~~~~~~~~~~ = ");
        boolean isBoss = getBool(order[p_0]);
        boolean isLost = getBool(order[p_1]); //Ƿذս
        String str = getString(order[p_2]);
        Battle.curBattleEvent = (byte) getInt(order[p_2]);

//        System.out.println("~~~~~~~~~~ = ");
        GameEngine.toBattle(isBoss, isLost);
        stopCurSprite();
        break;
      case o_breakBattle:
        breakBattle();
        break;
      case o_addLog:
        int key = getInt(order[p_0]);
        boolean isMain = getBool(order[p_1]);
        GameEngine.addTask(key, isMain);
        break;
      case o_delLog:
        key = getInt(order[p_0]);
        isMain = getBool(order[p_1]);
        GameEngine.delTask(key, isMain);
        break;
      case o_changeSkill:
        isAdd = getInt(order[p_0]) == add;
        int roleId = getInt(order[p_1]);
        int skillId = getInt(order[p_2]);
        if (isAdd) {
          GameEngine.role[roleId].addSkill( (byte) skillId);
        }
        else {
          GameEngine.role[roleId].reduceAllSkill();
        }
        break;
      case o_changeEquip:
        isAdd = getInt(order[p_0]) == add;
        itemId = getInt(order[p_1]);
        int num = getInt(order[p_2]);
        if (isAdd) {
          GameEngine.getEquip(itemId, true);
        }
        MyGameCanvas.sender(this, order[1]);
        return;
      case o_changeTaskItem:
        isAdd = getInt(order[p_0]) == add;
        itemId = getInt(order[p_1]);
        num = getInt(order[p_2]);
        if (isAdd) {
          GameEngine.getItem(GameEngine.others, GameEngine.other, itemId, num, true);
          MyGameCanvas.sender(this, order[1]);
          return;
        }
        else {
          GameEngine.dropItem(GameEngine.others, itemId, num);
        }
        break;
      case o_changeGod:
        isAdd = getInt(order[p_0]) == add;
        itemId = getInt(order[p_1]);
        num = getInt(order[p_2]);
        if (isAdd) {
          God.getGod(itemId);
          MyGameCanvas.setInfo("#B" + God.name[itemId]);
        }
        MyGameCanvas.sender(this, order[1]);
        return;
      case o_getSoul:
        itemId = getInt(order[p_0]);
        int qua = getInt(order[p_1]);
        int lev = getInt(order[p_2]);
        num = getInt(order[p_3]);
        GameEngine.getSoul(itemId, qua, lev, num, true);
        MyGameCanvas.sender(this, order[1]);
        return;
      case o_changeExp:
        isAdd = getInt(order[p_0]) == add;

//        roleId = getInt(order[p_1]);
        int exp = getInt(order[p_2]);
        if (isAdd) {
          for (int i = 0; i < GameEngine.roleTeam.length; i++) {
            Fighter f = GameEngine.role[GameEngine.roleTeam[i]];
            f.exp = Math.min(f.exp + exp, f.exp_max);
          }
          MyGameCanvas.setInfo("þ#B" + exp + "#A");
          MyGameCanvas.sender(this, order[1]);
          return;
        }
        break;
      case o_changeMoney:
        isAdd = getInt(order[p_0]) == add;
        num = getInt(order[p_1]);
        GameEngine.getMoney(isAdd ? num : -num);
        MyGameCanvas.setInfo( (isAdd ? "õ" : "ʧȥ") + "Ǯ" + Math.abs(num));
        MyGameCanvas.sender(this, order[1]);
        return;
      case o_showEffect:
        type = getInt(order[p_0]);
        x = getInt(order[p_1]) + GameMap.tileWidth / 2;
        y = getInt(order[p_2]) - GameMap.tileWidth / 2;
        int isMirror = getInt(order[p_3]) == 0 ? 0 : 1;
        int temp = 0;

//        switch (type) {
//          case 22:
//            temp = 700;
//            break;
//          case 27:
//          case 28:
//          case 31:
//            temp = -100;
//            break;
//          case 29:
//            temp = 1000;
//            break;
//          case 44:
//            temp = 500;
//            break;
//        }
        Effect.AddEffectList(x, y, type, isMirror, y + 40 + temp);
        break;
      case o_showEffectEx:
        type = getInt(order[p_0]);
        x = getInt(order[p_1]) + GameMap.tileWidth / 2;
        y = getInt(order[p_2]) - GameMap.tileWidth / 2;

//        System.out.println("x  "+getInt(order[p_1])+"  y  "+getInt(order[p_2]));

        isMirror = getInt(order[p_3]) == 0 ? 0 : 1;
        temp = 0;
        int count = getInt(order[p_4]);
        int flag = getInt(order[p_5]);

//        switch (type) {
//          case 22:
//            temp = 700;
//            break;
//          case 27:
//          case 28:
//          case 31:
//            temp = -100;
//            break;
//          case 29:
//            temp = 1000;
//            break;
//          case 44:
//            temp = 500;
//            break;
//        }
        Effect.AddEffectList(x, y, type, isMirror, y + 40 + temp, count, flag);
        break;
      case o_removeEffectEx:
        flag = getInt(order[p_0]);
        Effect.removeEff(flag);
        break;
      case o_random:
        int value = GameEngine.nextInt(getInt(order[p_1]), getInt(order[p_2]));
        set(getString(order[p_0]), value + "");
        break;
      case o_showCG:
        int cgName = getInt(order[p_0]);
        text = getString(order[p_1]);

//        System.out.println("cgName=============="+cgName);
        GameEngine.toBlackStatus(cgName, text);
        break;
      case o_aside:
        text = getString(order[p_0]);
        MyGameCanvas.setInfo(text);
        MyGameCanvas.sender(this, order[1]);
        return;
      case o_changeSpeed:
        System.out.println("enter changeSpeed");
        npcId = getInt(order[p_0]);
        int speedLev = getInt(order[p_1]);
        GameEngine.sprite[npcId].changeSpeed(speedLev);
        break;
      case o_changeFrequency:
        npcId = getInt(order[p_0]);
        int freqLev = getInt(order[p_1]);
        GameEngine.sprite[npcId].changeFreq(freqLev);
        break;
      case o_buyEquip:
        short[] gods = getArray(order[p_0]);
        MyGameCanvas.me.initBuyEquip(gods);
        MyGameCanvas.setST(MyGameCanvas.ST_BUY);
        stopCurSprite();
        break;
      case o_buySoul:
        gods = getArray(order[p_0]);
        MyGameCanvas.me.initBuySoul(gods);
        MyGameCanvas.setST(MyGameCanvas.ST_BUY);
        stopCurSprite();
        break;
      case o_erupt:
        GameEngine.erupt = !GameEngine.erupt;
        break;
      case o_buyItem:
        gods = getArray(order[p_0]);
        MyGameCanvas.me.initBuyItem(gods);
        MyGameCanvas.setST(MyGameCanvas.ST_BUY);
        stopCurSprite();
        break;
      case o_sellSoul:
        MyGameCanvas.me.initSellSoul();
        stopCurSprite();
        break;
      case o_sellItem:
        MyGameCanvas.me.initSellItem();
        stopCurSprite();
        break;
      case o_sellEquip:
        MyGameCanvas.me.initSellEquip();
        stopCurSprite();
        break;
      case o_rest:
        GameEngine.fullHp();
        break;
      case o_specialSave:
        System.out.println("innnnnnnnnnnnnnnn");
        isSave = true;
        break;
      case o_save:
        MyGameCanvas.setST(MyGameCanvas.ST_SAVE);
        break;
      case o_changeLevel:
        roleId = getInt(order[p_0]);
        lev = getInt(order[p_1]);
        GameEngine.role[roleId].setLevel(lev);
        break;
      case o_changeBGM:
        int music = getInt(order[p_0]);
        int loop = getInt(order[p_1]);
        if (loop == 0) {
          Sound.stopCurMusic();
        }
        else {
          Sound.playmusic(music, loop);
          GameMap.BGM = (short) music;
        }
        break;
      case o_chargePoint:
        int point = getInt(order[p_0]);
        if (MyGameCanvas.msg.canSendAgian(point)) {
          MyGameCanvas.toPayState(point);
          stopCurSprite();
        }
        break;
      case o_showGame:
        GameEngine.isShowGame = getBool(order[p_0]);
        break;
      case o_showNoMap:
        GameEngine.isNoMap = getBool(order[p_0]);
        break;
      case o_ismove:
        GameEngine.ismove = getBool(order[p_0]);
        break;
      case o_on:
        GameEngine.on = getBool(order[p_0]);
        break;
      case o_checkPillar:
        short[] pollar = getArray(order[p_0]);
        GameEngine.Pillars = pollar;

//        if (pollar == null) {
//          GameEngine.isOpen = GameEngine.isAllOpen();
//        }
//        else {
//          GameEngine.isOpen = GameEngine.isAllOpen(pollar);
//        }
        break;
      case o_screenFlash:
        GameEngine.isScreenFlash = getBool(order[p_0]);
        break;
      case o_setStatus:
        npcId = getInt(order[p_0]);
        statusID = (byte) getInt(order[p_1]);
        GameEngine.sprite[npcId].setStates(statusID);
        break;
      case o_changeBomb:
        GameEngine.showBomb = getBool(order[p_0]);
        break;
      case o_screenWhite:
        int time = getInt(order[p_0]);
        int color = getInt(order[p_1]);
        GameEngine.setScreenFlash(time, color == 0 ? 0xffffff : 0xff0000);
        break;
      case o_shake:
        GameEngine.shakeTime = getInt(order[p_0]);
        break;
      case o_stopBattle:
        Battle.stopBattle = getBool(order[p_0]);
        break;
      case o_fullHp:
        GameEngine.fullHp();
        break;
      case o_setRunXY:
        npcId = getInt(order[p_0]);
        GameEngine.sprite[npcId].setRunXY(getArray(order[p_1]));
        break;
      case o_changeModle:
        npcId = getInt(order[p_0]);
        int modle = getInt(order[p_1]);
        GameEngine.sprite[npcId].changeModle(modle);
        break;
      case o_filmStart:
        GameEngine.filmSwitch = 1;
        Script.isUserCtrl = false;
        stopCurSprite();
        GameEngine.sender(this, order[1]);
        return;
      case o_filmEnd:
        GameEngine.filmSwitch = -1;
        GameEngine.sender(this, order[1]);
        return;
      case o_setNpcStatus:
        npcId = getInt(order[p_0]);
        statusID = (byte) getInt(order[p_1]);

//        System.out.println("npc  " + npcId + "  " + statusID);

        states = new byte[] {
            GameSprite.ST_STOPDOWN, GameSprite.ST_MAGIC1, GameSprite.ST_INCURE,
            GameSprite.ST_DEAD, GameSprite.ST_WAKEUP, GameSprite.ST_JUMP};

//0 8 6 7 10 13
        GameEngine.sprite[npcId].curStates = GameEngine.sprite[npcId].
            nextStates = states[statusID];
        GameEngine.sprite[npcId].index = 0;
        break;
      case o_taskFlag:
        params = getParams(getString(order[p_0]), ",");
        if (params[0].equals("null")) {
          GameMap.flagMap = -1;
        }
        else {
          GameMap.flagMap = sToi(params[0]);
          GameMap.flagX = sToi(params[1]);
          GameMap.flagY = sToi(params[2]);
        }
        break;
      case o_refresh:
        GameEngine.isRefresh = getBool(order[p_0]) ? 1 : -1;
        GameEngine.refreshIndex = 0;
        GameEngine.sender(this, order[1]); //
        return;
      case o_stop:
        npcId = getInt(order[p_0]);
        time = getInt(order[p_1]);
        GameEngine.sprite[npcId].sender(this, order[1]);
        GameEngine.sprite[npcId].roleWait(time);
        return;
      case o_flash:
        GameEngine.flashTime = getInt(order[p_0]);
        GameEngine.flashMode = getInt(order[p_1]);
        break;
      case o_refine:
        MyGameCanvas.initRefine();
        GameEngine.init();
        break;
      case o_blackBG:
        GameMap.blackBG = getBool(order[p_0]);
        break;
      case o_lookMode:

//        GameMap.isLookMode = getBool(order[p_0]);
        break;
      case o_showHead:
        int icon = getInt(order[p_0]);
        GameEngine.showIcon(icon);
        GameEngine.sender(this, order[1]);
        return;
      case o_setWeather:
        int weather = getInt(order[p_0]);
        GameMap.setWeather(weather);
        break;
      case o_showLight:
        x = getInt(order[p_0]);
        y = getInt(order[p_1]);
        boolean beSamll = getBool(order[p_2]);
        GameEngine.showLight(x, y, beSamll);
        GameEngine.sender(this, order[1]);
        return;
      case o_closeLight:
        GameEngine.showLight = false;
        break;
      case o_showHole:
        x = getInt(order[p_0]);
        y = getInt(order[p_1]);
        beSamll = getBool(order[p_2]);
        GameEngine.showHole(x, y, beSamll);
        GameEngine.sender(this, order[2]);
        return;
      case o_setIsMotion:
        npcId = getInt(order[p_0]);
        int isMotion = getInt(order[p_1]);
        GameEngine.sprite[npcId].isMotion = (byte) isMotion;
        break;
      case o_savePos:
        lastMap = GameEngine.gameRank;
        lastX = GameEngine.sprite[GameEngine.spriteIndex].x;
        lastY = GameEngine.sprite[GameEngine.spriteIndex].y;
        lastDir = GameEngine.sprite[GameEngine.spriteIndex].dir;
        break;
      case o_loadPos:
        mapID = lastMap;
        x = lastX;
        y = lastY;
        dir = lastDir;
        visible = true;
        toMap(mapID, x, y, dir, visible);
        stopCurSprite();
        break;
      case o_setEquips:
        npcId = getInt(order[p_0]);
        short[] array = getArray(order[p_1]);
        for (int i = 0; i < GameEngine.role[npcId].equips.length; i++) {
          type = array[i];
          if (type == -1) {
            continue;
          }
          Equipment eq = GameEngine.equip[type];
          short[] equip = new short[] {
              (short) type, eq.prop1, 0, 0, 0, 0, eq.power};
          GameEngine.role[npcId].equip(equip, i);
        }
        break;
      case o_soulRefine: //Ǻϳ
        MyGameCanvas.me.packIndex = 0;
        MyGameCanvas.me.firstIndex = 0;
        MyGameCanvas.setST(MyGameCanvas.ST_Ǻϳ);
        break;
      case o_teach: //ѧ
        int teachType = getInt(order[p_0]);
        MyGameCanvas.me.initTeachEvent(teachType);
        break;
      case o_getNpcStatus:
        npcId = getInt(order[p_0]);
        statusID = (byte) getInt(order[p_1]);

//        System.out.println("npc  " + npcId + "  " + statusID);
        states = new byte[] {
            GameSprite.ST_JUMP, GameSprite.ST_INCURE, GameSprite.ST_DEAD,
            GameSprite.ST_MAGIC1, GameSprite.ST_STOP};
        GameEngine.sprite[npcId].curStates = GameEngine.sprite[npcId].
            nextStates = states[statusID];
        GameEngine.sprite[npcId].index = 0;

//        MyGameCanvas.sender(this, GameEngine.sprite[npcId].curStates);

        break;
    }
    setEnd(order[1]);
  }

  public static void stopCurSprite() {
    //    if (GameEngine.sprite[GameEngine.spriteIndex].curStates ==
    //        GameSprite.ST_MOVE) {
    //      GameEngine.sprite[GameEngine.spriteIndex].setStates(GameSprite.ST_STOP);
    //      GameEngine.sprite[GameEngine.spriteIndex].index = 0;
    //    }


    if (GameEngine.sprite[GameEngine.spriteIndex].curStates ==
        GameSprite.ST_MOVE || GameEngine.sprite[GameEngine.spriteIndex].nextStates ==
        GameSprite.ST_MOVE) {
      GameEngine.sprite[GameEngine.spriteIndex].curStates =
          GameEngine.sprite[GameEngine.spriteIndex].nextStates =
          GameSprite.ST_STOP;
      GameEngine.sprite[GameEngine.spriteIndex].index = 0;
    }
  }

  static int lastMap, lastX, lastY, lastDir; //þ֮ǰ
  static int mapID, posX, posY, dir;
  static boolean isChangeMap, isVisible;
  public static void toMap(int id, int x, int y, int direct, boolean visible) {
    mapID = id;
    posX = x;
    posY = y;
    dir = direct;
    isChangeMap = true;
    isVisible = visible;
  }

  public static void changeMap() {
    GameEngine.setPlayXY(posX, posY, dir, isVisible);
    GameEngine.setRankEnd(mapID);
  }

  static boolean isBreakBattle;

  public static void breakBattle() {
    isBreakBattle = true;
    Battle.battleResult = 1;
  }

  /*------------------------------------------------------------------*/
  public static String[] splitString(String src, String key) {
    Vector vt = new Vector();
    int w = 0;
    boolean end = false;
    while (!end) {
      int pos = src.indexOf(key, w);
      if (pos == -1) {
        pos = src.length();
        end = true;
      }
      int endIndex = pos;
      if (pos > 0 && src.charAt(pos - 1) == '\r') {
        endIndex = pos - 1;
      }
      String s = src.substring(w, endIndex).trim();
      if (!s.equals("")) {
        vt.addElement(s);
      }
      w = pos + 1;
    }
    String[] cs = new String[vt.size()];
    vt.copyInto(cs);
    vt = null;
    return cs;
  }

  private String getCommand(String script) {
    String s;
    if (script.indexOf(' ') != -1) {
      s = script.substring(0, script.indexOf(' '));
    }
    else {
      s = script.substring(0, script.length());
    }
    return s;
  }

  private int getCommand(short[] script) {
    return getOrder(script[2]);
  }

  public static String[] getParams(String order, String key) {
    String[] s = splitString(order, key);
    return s;
  }

  public boolean runInitEvent() {
    runOrder(vRoot);
    if (sToi( (String) vRoot.elementAt(1)) == ORDER_END) {
//      Script.initEvent = null;
      return true;
    }
    return false;
  }

  public static int sToi(String s) {
    return getIntValue(s);
  }

  public static short sTos(String s) {
    return Short.parseShort(s);
  }

//  private int strCmp(String s1, String s2) {
//    return s1.equals(s2) ? 0 : 1;
//  }

  /*-----------------------------Ƚ---------------------------------*/
  private String getCondition(String script) { //ȡif
    return script;
//    int start = script.indexOf(' ');
//    int end = script.indexOf('\r');
//    if (end == -1) {
//      end = script.length();
//    }
//    return script.substring(start, end);
  }

  private static int getFlagIndex(String string) { //øòĵһλ(&,|)
    int level = 0;
    for (int i = 0; i < string.length(); i++) {
      int tempChar = string.charAt(i);
      if (tempChar == '(') {
        level++;
      }
      else if (tempChar == ')') {
        level--;
      }
      if (i > 0 && level == 0 && (tempChar == '&' || tempChar == '@')) {
        return i;
      }
    }
    return -1;
  }

  private static boolean getCompValue(String string) { //òֵboolean
    int flagIndex = -1;
    for (int i = 0; i < string.length(); i++) {
      int tempChar = string.charAt(i);
      if (tempChar == '>' || tempChar == '<' || tempChar == '=' ||
          tempChar == '~') {
        flagIndex = i;
      }
    }

    if (flagIndex == -1) {
      boolean notIsExist = string.indexOf('!') != -1;
      return notIsExist ? !getBoolValue(string.substring(1, string.length())) :
          getBoolValue(string);
    }
    else {
      String first = string.substring(0, flagIndex);
      String second = string.substring(flagIndex + 1, string.length());
      boolean result = false;
      // System.out.println("òֵ");
      switch (string.charAt(flagIndex)) {
        case '>':
          result = getIntValue(first) > getIntValue(second);

          // System.out.println("òֵ >");
          break;
        case '<':
          result = getIntValue(first) < getIntValue(second);

          //  System.out.println("òֵ <");
          break;
        case '=':
          result = getIntValue(first) == getIntValue(second);

          //  System.out.println("òֵ= ");
          break;
        case '~':
          result = getIntValue(first) != getIntValue(second);

          // System.out.println("òֵ ~");
          break;
      }
      return result;
    }
  }

  private static boolean isNot = false;
  private static String getSubString(String string, int start, int end) { //ȡַ!()ֻȥ!;!()ȥ()
    String tempString = string.substring(start, end);
    int level = 0;
    isNot = false;
    int flagStart = 0;
    for (int i = 0; i < tempString.length(); i++) {
      if (tempString.charAt(i) == '!' && i == flagStart) {
        flagStart++;
      }
      else {
        break;
      }
    }
    if (tempString.charAt(flagStart) == '(') {
      level++;
      for (int i = flagStart + 1; i < tempString.length(); i++) {
        int tempChar = tempString.charAt(i);
        if (tempChar == '(') {
          level++;
        }
        else if (tempChar == ')') {
          level--;
        }
        if (level == 0 && i < tempString.length() - 1) {
          return tempString;
        }
      }
      isNot = flagStart % 2 != 0;
      if (isNot) {
        return tempString.substring(flagStart, tempString.length());
      }
      else {
        return tempString.substring(flagStart + 1, tempString.length() - 1);
      }
    }
    else {
      return tempString;
    }
  }

  public synchronized static boolean conditionIsTrue(String condition) { //(,),&,|(@),!,>,<,=,~()
    int operator = 0;
    boolean first;
    boolean second;
    boolean result = false;
    int flag = 'x';
    boolean isTmpNot = false; //Ƿò!
    String allSub = condition;
    allSub = getSubString(allSub, 0, allSub.length()); //ʣַ
    isTmpNot = isNot;
    operator = getFlagIndex(allSub);
    if (operator == -1) {
      boolean isExpression = false;
      for (int i = 0; i < allSub.length(); i++) {
        int tempChar = allSub.charAt(i);
        if (tempChar == '&' || tempChar == '@' || tempChar == '(') {
          isExpression = true;
          break;
        }
      }
      if (isExpression) {
        if (isTmpNot) {
          return!conditionIsTrue(allSub);
        }
        else {
          return conditionIsTrue(allSub);
        }
      }
      else {
        if (isTmpNot) {
          return!getCompValue(allSub);
        }
        else {
          return getCompValue(allSub);
        }
      }
    }
    else {
      first = conditionIsTrue(allSub.substring(0, operator));
      flag = allSub.charAt(operator);
      second = conditionIsTrue(allSub.substring(operator + 1, allSub.length()));
      switch (flag) {
        case '&':
          result = first && second;
          break;
        case '@':
          result = first || second;
          break;
      }
      return result;
    }
  }

  /*----------------------------------------------------------------*/
  private static boolean minus = false; //
  private static String getSubString_Var(String string, int start, int end) { //ȡַ^()ֻȥ^;^()ȥ()
    String tempString = string.substring(start, end);
    int level = 0;
    minus = false;
    int flagStart = 0;
    for (int i = 0; i < tempString.length(); i++) {
      if (tempString.charAt(i) == '^' && i == flagStart) {
        flagStart++;
        minus = true;
      }
      else {
        break;
      }
    }
    if (tempString.charAt(flagStart) == '(') {
      level++;
      for (int i = flagStart + 1; i < tempString.length(); i++) {
        int tempChar = tempString.charAt(i);
        if (tempChar == '(') {
          level++;
        }
        else if (tempChar == ')') {
          level--;
        }
        if (level == 0 && i < tempString.length() - 1) {
          return tempString;
        }
      }
      if (minus) {
        return tempString.substring(flagStart, tempString.length());
      }
      else {
        return tempString.substring(flagStart + 1, tempString.length() - 1);
      }
    }
    else {
      if (minus) {
        return tempString.substring(flagStart, tempString.length());
      }
      else {
        return tempString;
      }
    }
  }

  private static int getFlag4Index(String string) { //øòĵһλ(&,|)
    int level = 0;
    for (int i = 0; i < string.length(); i++) {
      int tempChar = string.charAt(i);
      if (tempChar == '(') {
        level++;
      }
      else if (tempChar == ')') {
        level--;
      }
      if (level == 0 &&
          (tempChar == '+' || tempChar == '-' || tempChar == '*' ||
           tempChar == '/' || tempChar == '%')) {
        return i;
      }
    }
    return -1;
  }

  private synchronized static int arithValue(String expression) { //(,),+,-,*,/,^()
    int operator = 0;
    int first = 0;
    int second = 0;
    int result = 0;
    int flag = 'x';
    boolean isTmpminus = false; //Ƿòи
    String allSub = expression;
    allSub = getSubString_Var(allSub, 0, allSub.length()); //ʣַ
    isTmpminus = minus;
    operator = getFlag4Index(allSub);
    if (operator == -1) {
      boolean isExpression = false;
      for (int i = 0; i < allSub.length(); i++) {
        int tempChar = allSub.charAt(i);
        if (tempChar == '+' || tempChar == '-' || tempChar == '*' ||
            tempChar == '/' || tempChar == '%' || tempChar == '^' ||
            tempChar == '(') {
          isExpression = true;
          break;
        }
      }
      if (isExpression) {
        if (isTmpminus) {
          return -arithValue(allSub);
        }
        else {
          return arithValue(allSub);
        }
      }
      else {
        if (isTmpminus) {
          //  System.out.println(" allSub");
          return -getIntValue(allSub);
        }
        else {
          //  System.out.println(" !isTmpminus allSub");
          return getIntValue(allSub);
        }
      }
    }
    else {
      first = arithValue(allSub.substring(0, operator));
      flag = allSub.charAt(operator);
      second = arithValue(allSub.substring(operator + 1, allSub.length()));
    }
    switch (flag) {
      case '+':
        result = first + second;
        break;
      case '-':
        result = first - second;
        break;
      case '*':
        result = first * second;
        break;
      case '/':
        result = first / second;
        break;
      case '%':
        result = first % second;
        break;
    }
    return result;
  }

  /*----------------------------order----------------------------------------*/

  static boolean getBoolValue(String paramName) { //boolean 
    String param = paramName.trim();
    if (param.equals("true")) { //
      return true;
    }
    else if (param.equals("false")) { //
      return false;
    }
    else if (param.equals("KEY_OK")) {
      return MyGameCanvas.confirmKey;
    }
    else if (param.equals("isWin")) {
      return Battle.battleResult == 1;
    }
    else if (param.equals("open")) { ////////////////////////
      return GameEngine.isOpen;
    }

    return false;
  }

  public static String getStrValue(String paramName) { //int 
    String param = paramName.trim();
//    if (param.equals("ac")) { //
//      return "str1";
//    }
    return "!!!error string!!!";
  }

  public static String[] parseArray(String paramName) {
    int index = paramName.indexOf("[");
    if (index == -1) {
      return null;
    }
    String[] buff = new String[2];
    buff[0] = paramName.substring(0, index);
    buff[1] = paramName.substring(index + 1, paramName.indexOf("]"));
//     buff[1] = paramName.substring(index + 1, paramName.length()-1);
    return buff;
  }

  private static int getArrayValue(String[] param) {
    String name = param[0];
    int id = sToi(param[1]);
    if (name.equals("event")) {
      return Tools.bToi(Script.scriptVar[id]);
    }
    else if (name.equals("level")) {
      return GameEngine.role[id].level;
    }
    else if (name.equals("taskItem")) { ////////////////////////
      return getNum(GameEngine.others, id);
    }
    else if (name.equals("item")) { ////////////////////////
      return getNum(GameEngine.items, id);
    }
    else if (name.equals("soul")) { ////////////////////////
      return getNum(GameEngine.souls, id);
    }
    else if (name.equals("god")) { ////////////////////////
      return God.gods[id] > 1 ? 1 : 0;
    }
    else if (name.equals("point")) { ////////////////////////
      return MyMessage.PPData[id];
    }

    System.out.println("get array value error !!!   " + name);
    return Integer.MAX_VALUE;
  }

  public static int getNum(Vector v, int id) {
    if (v == null) {
      return 0;
    }
    for (int i = 0; i < v.size(); i++) {
      short[] temp = (short[]) v.elementAt(i);
      if (temp[0] == id) {
        return temp[1];
      }
    }
    return 0;
  }

  private void setArrayValue(String[] param, int val) {
    String name = param[0];
    int id = sToi(param[1]);
    if (name.equals("event")) {
      Script.scriptVar[id] = (byte) val;
    }
//    else if (name.equals("mp")) {
//      GameEngine.fighters[id].mp = Math.max(val, 0);
//    }
    else {
      System.out.println("set array value error !!!    " + name);
    }
  }

  private static int getIntValue(String paramName) { //int 
    String param = paramName.trim();
    try {
      return Integer.parseInt(paramName);
    }
    catch (NumberFormatException e) {
    }

    String[] array = parseArray(param);
    if (array != null) {
      return getArrayValue(array);
    }
    if (param.equals("temp")) { //
      return Script.temp;
    }
    else if (param.toLowerCase().equals("choice")) { //
      return MyGameCanvas.choice;
    }
    else if (param.equals("battleResult")) { //
      return Battle.battleResult;
    }
    else if (param.equals("money")) { //
      return GameEngine.money;
    }
    //
    System.out.println("get int value error !!!     " + paramName);
    return Integer.MAX_VALUE;

  }

  private void set(String varName, String expression) {
    String[] array = parseArray(varName);
    int val = arithValue(expression);
    if (array != null) {
      setArrayValue(array, val);
      return;
    }
    if (varName.equals("temp")) { //
      Script.temp = arithValue(expression);
    }
    else if (varName.equals("mode")) { //ϳģʽ0-ͨϳɣ50%1-ȫΪ100%
      MyGameCanvas.soulRifineMode = arithValue(expression);
    }

  }

  public static String parseStr(String str) {
    StringBuffer buff = new StringBuffer();
    boolean isTxt = true;
    StringBuffer varName = new StringBuffer();
    for (int i = 0; i < str.length(); i++) {
      char c = str.charAt(i);
      if (c == '<') {
        isTxt = false;
        continue;
      }
      if (c == '>') { //<int a>
        isTxt = true;
        String[] s = getParams(varName.toString(), " ");
        if (s[0].equals("int")) {
          // System.out.println("int");
          buff.append(getIntValue(s[1]));
        }
        else if (s[0].equals("str")) {
          buff.append(getStrValue(s[1]));
        }
        varName = new StringBuffer();
        continue;
      }
      if (isTxt) {
        buff.append(c);
      }
      else {
        varName.append(c);
      }
    }
    return buff.toString();
  }

}
