import javax.microedition.lcdui.*;
import java.util.Random;
import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;
import java.io.*;

/**
 * <p>Title: GameEngine</p>
 * <p>Description: GameEngine</p>
 * <p>Copyright: Copyright (c) 2009-12-09</p>
 * <p>Company: songge</p>
 * @version 1.0
 */

public final class GameEngine {
  MyGameCanvas canvas;
  static Battle battle;
  public static GameEngine me;
  public static Equipment equip[];
  public static Item item[];
  public static Soul soul[];
  public static Other other[];
  public static Talent talent[];

  static Skill skill[];
//  static Effect eft;
  static GameSprite[] sprite; //
  public static GameMap map; //ͼ
  static Random rnd = new Random();
  public static byte spriteIndex; //ƵĽɫ
  static byte gameRank = 0; //Ϸؿ
  public static boolean gameFinish = false; //Ϸ

  public static int money; //Ǯ

  static byte[] taskMain; //
  static byte[] taskSub; //֧

  public static Vector equips = new Vector(); //id,126  װ
  public static Vector items = new Vector(); //id,num   ҩƷ
  public static Vector souls = new Vector(); //id,num,Ʒʣȼ       
  public static Vector others = new Vector(); //id,num     

//  static byte bagMax = 48; //
//  static final byte REPEATMAX = 99; //
//  public static byte bagData[][] = new byte[48][3]; //飺0 1 2id
  public static Fighter[] role; //
  public static final byte ROLEMAX = 3; //
  public static final byte FIGHTERMAX = 36; //ս
  public static byte roleTeam[] = new byte[] {
      0}; //Ĺɣ
  public static byte[] enemyTeam;
  public static byte roleIndex = 0; //ǰƵĽɫ
  static int injueTime; //޵ʱ
  static boolean isBattle;
  static boolean isShowGame = true;
  static boolean isNoMap = true;
  static boolean ismove = false;
  static boolean on = true;
  static boolean erupt = false;

//  public static final byte B_ = 0;
//  public static final byte B_ = 1;
//  public static final byte B_ = 2;
  //bagData 1.
//  public static final byte BT_װ = 0;
//  public static final byte BT_ = 1;
  public GameEngine() {
    me = this;
    canvas = MyGameCanvas.me;
    map = new GameMap(this, MyGameCanvas.SCREEN_WIDTH,
                      MyGameCanvas.SCREEN_HEIGHT);
    battle = new Battle(this);

  }

  /**---------------------------------־------------------------------*/

  public static void loadTasks() { //־ļ
    String[] str = Event.splitString(Script.loadTxt("/task.txt"), "\n");
    int len = str.length;
    GameData.tasks = new String[len][2];
    for (int i = 0; i < len; i++) {
      GameData.tasks[i] = Event.splitString(str[i], " ");
//      System.out.println("task  " + GameData.tasks[i][0]);
    }
  }

  public static int getTaskIndex(String key) {
    for (int i = 0; i < GameData.tasks.length; i++) {
      if (key.equals(GameData.tasks[i][0])) {
        return i;
      }
    }
    return -1;
  }

  public static void addTask(int id, boolean isMain) {
//    byte id = (byte) getTaskIndex(key);
    if (id != -1) {
      if (isMain) {
        taskMain = addData(taskMain, (byte) id);
      }
      else {
        taskSub = addData(taskSub, (byte) id);
      }
    }
  }

  public static void delTask(int id, boolean isMain) {
//    byte id = (byte) getTaskIndex(key);
    if (isMain) {
      taskMain = removeData(taskMain, (byte) id);
    }
    else {
      taskSub = removeData(taskSub, (byte) id);
    }
  }

  /**----------------------------------Ϸ--------------------------------*/
  public static void setGameFinish() {
    MyGameCanvas.setST(MyGameCanvas.ST_PASS_EFFECT);
    gameFinish = true;
  }

  /**----------------------------------ͷŰ--------------------------------*/
  public void ctrlReleased(int keyCode) {
    sprite[spriteIndex].ctrlRelease();
  }

  /**----------------------------------Ϸ--------------------------------*/

  public void ctrlPlay(int keyCode) {
    sprite[spriteIndex].ctrl(keyCode);
  }

  /**----------------------------------ײ--------------------------------*/
  boolean canTouch = false;
  byte touchID = -1;
  public int hitSprite(int x, int y) {
    if (sprite.length <= 1) {
      return -1;
    }
    for (int i = 0; i < sprite.length; i++) {
      if (i == spriteIndex || !sprite[i].visible || sprite[i].isPass) {
        continue;
      }
      switch (sprite[i].modle) {
        case 39: //ʯ
          if ( (x == sprite[i].ax || x == sprite[i].ax - 16) &&
              (y == sprite[i].ay || y == sprite[i].ay - 16)) {
            return i;
          }
          break;
        case 41: //ʯ̨
        case 44: //
          if ( (x == sprite[i].ax) &&
              (y == sprite[i].ay || y == sprite[i].ay - 16)) {
            return i;
          }
          break;
        case 45:
          if ( (x == sprite[i].ax || x == sprite[i].ax + 16 || x == sprite[i].ax - 16) &&
              (y == sprite[i].ay || y == sprite[i].ay - 32 || y == sprite[i].ay - 16)) {
            return i;
          }
          break;
        case 34: //ţ
          if ( (x == sprite[i].ax - 32 || x == sprite[i].ax ||
                x == sprite[i].ax - 16 || x == sprite[i].ax + 16) &&
              (y == sprite[i].ay || y == sprite[i].ay - 32)) {
            return i;
          }
          break;
        case 43: //
          if ( (x == sprite[i].ax - 32 || x == sprite[i].ax ||
                x == sprite[i].ax - 16 || x == sprite[i].ax + 16 ||
                x == sprite[i].ax + 16 || x == sprite[i].ax + 32 ||
                x == sprite[i].ax + 48 || x == sprite[i].ax - 48) &&
              (y == sprite[i].ay || y == sprite[i].ay - 32 || y == sprite[i].ay - 16)) {
            return i;
          }
          break;
        case 37: //

//          if (sprite[spriteIndex].curStates == GameSprite.ST_STOP) {
          canTouch = false;

//          }

          int posX = sprite[i].x;
          int posY = sprite[i].y;

          switch (GameEngine.sprite[GameEngine.spriteIndex].dir) {
            case GameSprite.DIR_DOWN:
              posX += 0;
              posY += -16;
              break;
            case GameSprite.DIR_UP:
              posX += 0;
              posY += 16;
              break;
            case GameSprite.DIR_RIGHT:
              posX += -16;
              posY += 0;
              break;
            case GameSprite.DIR_LEFT:
              posX += 16;
              posY += 0;
              break;
          }

          if ( (sprite[spriteIndex].x >= posX &&
                sprite[spriteIndex].x <= posX + 16) &&
              (sprite[spriteIndex].y <= posY && sprite[spriteIndex].y >= posY - 16)) {
            canTouch = true;
            touchID = (byte) i;
          }

//          Tools.addRect(Tools.TYPE_RECT, posX, posY, 32,32, true, Tools.BOTTOM, 0xFF0000, 9999);
//
//
//          Tools.addRect(Tools.TYPE_RECT, x, y, 16, 16, true, Tools.BOTTOM, 0x00FF00, 9999);
//          Tools.addRect(Tools.TYPE_RECT, sprite[spriteIndex].x, sprite[spriteIndex].y, 16, 16, true, Tools.BOTTOM, 0x0000FF, 9999);

//          if (canTouch) {
//            System.out.println("ײ"+i);
//          }
//          if (i==6) {
//                      System.out.println("========================" + i);
//          System.out.println("posX = " + posX + "======" + "posY = " + posY);
//          System.out.println("x = " + x + "======" + "y = " + y);
//          }

          if ( (x == sprite[i].ax ||
                x == sprite[i].ax + 16) &&
              (y == sprite[i].ay || y == sprite[i].ay - 16)) {
            return i;
          }
          break;

        case 38: //ʯ
          if ( (x == sprite[i].ax + 32 || x == sprite[i].ax ||
                x == sprite[i].ax - 32 || x == sprite[i].ax - 16 ||
                x == sprite[i].ax + 16) &&
              (y == sprite[i].ay || y == sprite[i].ay - 16)) {
            return i;
          }
          break;
        default:
          if (x == sprite[i].ax && y == sprite[i].ay) {
            return i;
          }
          break;
      }
    }
    return -1;
  }

  /**----------------------------------ʼλ//ɼ--------------------------------*/

  static short playX = -1, playY = -1, playDir = -1;
  static boolean isVisible; //Ƿɼ
  public void initSpirateXY() {
    if (playX == -1 || playY == -1 || playDir == -1) {
      return;
    }
    sprite[spriteIndex].x = playX;
    sprite[spriteIndex].y = playY;
    sprite[spriteIndex].nextDir = sprite[spriteIndex].dir = sprite[spriteIndex].
        faceDir = sprite[spriteIndex].nextFaceDir = playDir;
    sprite[spriteIndex].visible = isVisible;
    sprite[spriteIndex].setAXY();
  }

  /**----------------------------------λ//ɼ--------------------------------*/

  public static void setPlayXY(int x, int y, int dir, boolean visible) {
    playX = (short) x;
    playY = (short) y;
    playDir = (short) dir;
    isVisible = visible;
  }

  /**----------------------------------ʼ--------------------------------*/

  public static void initSprite(short[][] npc) {
    sprite = null;
    if (npc == null) {
      System.out.println("Load npc Data Fail");
      return;
    }
    sprite = new GameSprite[npc.length];
    for (int i = 0; i < sprite.length; i++) {
      sprite[i] = new GameSprite(me, i);
      sprite[i].init(npc[i]);
    }
  }

  /**----------------------------------ƶ--------------------------------*/

  public void moveSprite() {
    if (sprite != null) {
      for (int i = 0; i < sprite.length; i++) {
        sprite[i].run();
      }
    }
  }

  //
  public void drawSprite(Graphics g) {
    if (sprite != null) {
      for (int i = 0; i < sprite.length; i++) {
        sprite[i].paint();
      }
    }
  }

  //
  static boolean stopBomb; //׿
  static boolean isElite; //ǷӢս
  public void bomb(boolean elite) { //
    isElite = elite;
    getEnemyTeam();
    sprite[spriteIndex].setStates(GameSprite.ST_STOP);
    Battle.canEscape = true;
    Battle.canLose = false;
    Battle.curBattleEvent = -1;
    Battle.stopBattle = false;
    MyGameCanvas.setST(MyGameCanvas.ST_INITBATTLE);
//    Sound.playmusic(Sound.Music_ս, -1);
  }

  /**---------------------------------------------------------------------*/
  void getEnemyTeam() {
    enemyTeam = null;
    int totalEnemy = getEnemyTeamLen();
    enemyTeam = new byte[totalEnemy];
    short[] emys = Event.getArray(map.enemys);
    for (int i = 0; i < totalEnemy; i++) {
      enemyTeam[i] = (byte) emys[nextInt(emys.length - 1)];
    }
    //66
//    enemyTeam[0] = 23;
//    enemyTeam[1] = 61;
//    enemyTeam[2] = 62;
//    enemyTeam[2] = 5;
    if (totalEnemy == 3) {
      if (enemyTeam[0] == enemyTeam[1]) {
        byte temp = enemyTeam[1];
        enemyTeam[1] = enemyTeam[2];
        enemyTeam[2] = temp;
      }
      else if (enemyTeam[1] == enemyTeam[2]) {
        byte temp = enemyTeam[0];
        enemyTeam[0] = enemyTeam[1];
        enemyTeam[1] = temp;
      }
    }

  }

  int getEnemyTeamLen() {
//    return 3;
    switch (roleTeam.length) {
      case 1:
        return nextInt(1, 2);
      default:
        return nextInt(2, 3);
    }
  }

  static int filmSwitch;
  int filmH;
  static final int filmHight_Max = 60; //ӰЧ߶
  public void drawFilm() {
    filmH += filmSwitch * 5;
    if (filmH < 0) {
      filmH = 0;
      filmSwitch = 0;
      finish();
    }
    else if (filmH > filmHight_Max) {
      filmH = filmHight_Max;
      filmSwitch = 0;
      finish();
    }
    Tools.addImage(Tools.IMG_BFRAME, map.setOffX, map.setOffY + filmH - 73,
                   Tools.TOP, Tools.TRANS_CENTER, 4999);
    Tools.addImage(Tools.IMG_BFRAME, map.setOffX,
                   map.setOffY + MyGameCanvas.SCREEN_HEIGHT + 73 - filmH,
                   Tools.BOTTOM, Tools.TRANS_NONE, 4999);
//    Tools.addRect(Tools.TYPE_RECT, map.setOffX, map.setOffY+filmH,
//                  MyGameCanvas.SCREEN_WIDTH, filmH, true, Tools.TOP, 0, 4999);
//    Tools.addRect(Tools.TYPE_RECT, map.setOffX,
//                  map.setOffY + MyGameCanvas.SCREEN_HEIGHT,
//                  MyGameCanvas.SCREEN_WIDTH, filmH, true, Tools.BOTTOM, 0,
//                  4999);
  }

  static int flashTime;
  static int flashMode;
  //Ϸ
  public void drawGame(Graphics g) {

    if (flashTime != 0) {
      if (flashTime > 0) {
        flashTime--;
      }
      int col = 0;
      switch (flashMode) {
        case 0:
          col = GameMIDlet.gameIndex % 2 == 0 ? 0 : 0xffffff;
          break;
        case 1:
          col = GameMIDlet.gameIndex % 2 == 0 ? -1 : 0xff0000;
          break;
      }
      if (col != -1) {
        Tools.addRect(Tools.TYPE_RECT, map.setOffX, map.setOffY,
                      MyGameCanvas.SCREEN_WIDTH, MyGameCanvas.SCREEN_HEIGHT, true,
                      Tools.TOP, col, 5000);
        return;
      }
    }
    if (isNoMap) {
      map.setMap(g);
    }
    else {
      drawColorScreenBG(0, 0);
    }
    drawHole();
    drawSprite(g);
    if (erupt) {
      drawRoleFire(sprite[spriteIndex].x - 8, sprite[spriteIndex].y - 84,
                   sprite[spriteIndex].y);
    }
    drawBomb();
    drawLight();

    if (!GameMap.blackBG && isNoMap) {
      map.drawWeather(2000);
    }
//    map.drawLookArea(posX, posY - 20);

    drawInterFace(g, map.setOffX, map.setOffY, 5000);

    drawIcon(map.setOffX, map.setOffY + 80, 2000);

    if (isScreenFlash) {
      MyGameCanvas.drawOpenEft();
    }

    drawFilm();
    if (!isShowGame) {
      Tools.addRect(Tools.TYPE_RECT, map.setOffX, map.setOffY,
                    MyGameCanvas.SCREEN_WIDTH, MyGameCanvas.SCREEN_HEIGHT, true,
                    Tools.TOP, 0, 5000);
    }
    switch (isRefresh) {
      case -1:
        drawPassEffect(5000);
        break;
      case 1:
        drawStartEffect(5000);
        break;
      case 2:
        Tools.addRect(Tools.TYPE_RECT, map.setOffX, map.setOffY,
                      MyGameCanvas.SCREEN_WIDTH, MyGameCanvas.SCREEN_HEIGHT, true,
                      Tools.TOP, 0, 5000);
        break;
    }

  }

  static byte size = 15; //߅L
  static int refreshIndex;
  static int isRefresh; //-1 close  1--opne  0--null  2--fullScreen

  static void drawStartEffect(int lev) {

    byte hyp = (byte) (MyGameCanvas.SCREEN_WIDTH / size + 1);
    byte speed = 3;
    int col = GameEngine.gameRank == 26 ? 0xffffff : 0;
    if (refreshIndex <= hyp + size / speed) {
      for (int i = 0; i < hyp; i++) {
        if (refreshIndex >= i) {
          Tools.addRect(Tools.TYPE_RECT,
                        GameMap.setOffX + speed * (refreshIndex - i) +
                        i * size, GameMap.setOffY,
                        Math.max(0, 12 - (refreshIndex - i) * speed),
                        MyGameCanvas.SCREEN_HEIGHT, true, Tools.TOP, col,
                        lev);
        }
        else {
          Tools.addRect(Tools.TYPE_RECT, GameMap.setOffX + i * size,
                        GameMap.setOffY, size,
                        MyGameCanvas.SCREEN_HEIGHT, true, Tools.TOP, col,
                        lev);
        }
      }
      ++refreshIndex;
    }
    else {
      isRefresh = 0;
      finish();
    }

  }

  static void drawPassEffect(int lev) {

    byte hyp = (byte) (MyGameCanvas.SCREEN_WIDTH / size + 1);
    byte speed = 3;

    for (int i = 0; i < hyp; i++) {

      Tools.addRect(Tools.TYPE_RECT,
                    GameMap.setOffX + i * size,
                    GameMap.setOffY,
                    Math.max(0, Math.min(size, (refreshIndex - i) * speed)),
                    MyGameCanvas.SCREEN_HEIGHT, true, Tools.TOP, 0, lev);
    }
    if (++refreshIndex > hyp + size / speed) {
      isRefresh = 2;
      finish();
    }
  }

  public static int getItemNum(Vector myPack, ItemInterface[] items, int type) {
    for (int i = myPack.size() - 1; i >= 0; i--) {
      short[] temp = (short[]) myPack.elementAt(i);
      if (temp[0] == type) {
        return temp[1];
      }
    }
    return 0;
  }

  public static int getSoulNum(Vector myPack, ItemInterface[] items, int type) {
    for (int i = myPack.size() - 1; i >= 0; i--) {
      short[] temp = (short[]) myPack.elementAt(i);
      if (temp[0] == type && temp[2] == 0) {
        return temp[1];
      }
    }
    return 0;
  }

//ýǮ
  public static void getMoney(int num) {
    money += num;
    money = Math.max(0, money);
//    MyGameCanvas.setInfo( (num >= 0 ? "õ" : "ʧȥ") + "Ǯ" +
//                         Math.abs(num) + "");
  }

  //лͼ
  static boolean isChangMap;
  public static void setRankEnd(int id) {
    MyGameCanvas.setST(MyGameCanvas.ST_PASS_EFFECT);
    isChangMap = true;
    gameRank = (byte) id;
    Event.isChangeMap = false;
  }

  //
  static boolean isScreenFlash;
  static byte screenFlashTime = 0;
  static int screenFlashColor = 0;
  public void drawScreenFlash() {
    if (screenFlashTime != 0) {
      screenFlashTime--;
      if (screenFlashTime % 2 != 0) {
        Tools.addRect(Tools.TYPE_RECT, GameMap.setOffX, GameMap.setOffY,
                      GameMap.screenWidth, GameMap.screenHeight, true,
                      Tools.TOP, screenFlashColor, GameMap.L_MAX);
      }
    }
  }

  static void setScreenFlash(int time, int color) {
    screenFlashTime = (byte) (time * 2);
    screenFlashColor = color;
  }

  //Ϸ
  public static int posX, posY;
  static boolean isToPoint = false;
  public void runGame() {
    if (MyGameCanvas.chargeDelay == 0) {
      Script.runScript();
    }

    moveBomb();
    run();
//    Fighter.levelMax = (byte) (MyGameCanvas.chargeData[MyGameCanvas.CHARGE_ȼ] ==
//                               1 ? 40 : 20);
    if (!MyGameCanvas.isJump) {
      runSpecialEvent();
    }

  }

  public void run() {
    moveSprite();
    if (!isToPoint) {
      posX = sprite[spriteIndex].sx + GameMap.tileWidth / 2;
      posY = sprite[spriteIndex].sy - GameMap.tileWidth / 2;
    }
    map.moveSrceen(posX, posY);
    screenShake();
  }

  static boolean isShowBox = true; //жǷϷеĻϽʾͼƬ
  static boolean isToTime; //жϱǷԴ򿪵ʱ
  int nextEventTime = 1500; //´¼ʱ
  int eventTime; //¼ʱ
  void runSpecialEvent() { //ͻ¼
    if ( /*canvas.isInfo ||*/!Script.isUserCtrl) {
      return;
    }
    //0-õ飬1-õǮ2-õҩ3-õǱܵ㣬4-ع
    if (eventTime > nextEventTime) {
      eventTime = 0;
    }
    if (++eventTime == nextEventTime) { //10,10,1,4,10,10,4,2
//      canvas.showGift();
//      getGift();
//      nextEventTime = 3000;
      nextEventTime = 3000 + role[0].level / 10 * 600;
      eventTime = 0;
    }
    if (isShowBox) {
      int sec = GameMIDlet.sleepTime * (nextEventTime - eventTime) / 1000;
      String secStr1 = (sec / 60 > 9 ? (sec / 60 + "") : ("0" + sec / 60));
      String secStr2 = (sec % 60 > 9 ? (sec % 60 + "") : ("0" + sec % 60));
      if (!isToTime && secStr1.equals("00") && secStr2.equals("00")) {
        isToTime = true;
        MyGameCanvas.setInfo("3żȡ");
      }
      if (sprite[spriteIndex].ax > GameMap.setOffX + GameMap.screenWidth / 2 + 20) {
        drawBox(GameMap.setOffX - 160, GameMap.setOffY);
        if (!isToTime) { //8
          drawTime(sec, GameMap.setOffX + MyGameCanvas.SCREEN_WIDTH - 48 - 160,
                   GameMap.setOffY + 22);
//        Tools.addImage(Tools.IMG_POINT, GameMap.setOffX + MyGameCanvas.SCREEN_WIDTH - 24, //ð
//                       GameMap.setOffY + 22, 26, 4, 4, 9, Tools.BOTTOM,
//                       Tools.TRANS_NONE,9999);
        }
      }
      else {
        drawBox(GameMap.setOffX, GameMap.setOffY);
        if (!isToTime) { //8
          drawTime(sec, GameMap.setOffX + MyGameCanvas.SCREEN_WIDTH - 48,
                   GameMap.setOffY + 22);
//        Tools.addImage(Tools.IMG_POINT, GameMap.setOffX + MyGameCanvas.SCREEN_WIDTH - 24, //ð
//                       GameMap.setOffY + 22, 26, 4, 4, 9, Tools.BOTTOM,
//                       Tools.TRANS_NONE,9999);
        }
      }

    }
  }

  byte[][] boxClip = {
      {
      0, 0, 13, 21}
      ,
      /*ر*/
      {
      40, 0, 14, 23}
      ,
      /*ر*/
      {
      14, 0, 25, 23}
  }; /**/

  void drawBox(int x, int y) { //
    byte motion1[] = new byte[] {
        0, 0, 1, 1};
    Tools.addImage(Tools.IMG_24, x + MyGameCanvas.SCREEN_WIDTH - 88,
                   y + 3, //ĺɫͼ
                   0, 0, 88, 26, Tools.TOP, Tools.TRANS_NONE, 9999);

    if (isToTime) { //
      byte var = (byte) (GameMIDlet.gameIndex % 60);
      if (var < 3) {
        Tools.addImage(Tools.IMG_GIFT_6,
                       x + MyGameCanvas.SCREEN_WIDTH - 69,
                       y + 30, boxClip[1],
                       Tools.BOTTOM, Tools.TRANS_NONE, 9999);
        Tools.addImage(Tools.IMG_GIFT_6,
                       x + MyGameCanvas.SCREEN_WIDTH - 69 + 14,
                       y + 30, boxClip[1],
                       Tools.BOTTOM, Tools.TRANS_HORIZONTAL, 9999);
      }
      else {
        Tools.addImage(Tools.IMG_GIFT_6,
                       x + MyGameCanvas.SCREEN_WIDTH - 68,
                       y + 30, boxClip[2],
                       Tools.BOTTOM, Tools.TRANS_NONE, 9999);
        Tools.addImage(Tools.IMG_STAR, //
                       x + MyGameCanvas.SCREEN_WIDTH - 71,
                       y + 28, 36 * (GameMIDlet.gameIndex % 3), 0, 33, 28,
                       Tools.BOTTOM, Tools.TRANS_NONE, 9999);
      }
      drawButton(x + MyGameCanvas.SCREEN_WIDTH - 35,
                 y + 28, GameMIDlet.gameIndex % 2 == 0 ? true : false, 3,
                 9999);
    }
    else { //ر
      byte var = motion1[GameMIDlet.gameIndex % 4];
      Tools.addImage(Tools.IMG_GIFT_6,
                     x + MyGameCanvas.SCREEN_WIDTH - 68 -
                     (var == 0 ? 0 : 1),
                     y + 30, boxClip[var],
                     Tools.BOTTOM, Tools.TRANS_NONE, 9999);
      Tools.addImage(Tools.IMG_GIFT_6,
                     x + MyGameCanvas.SCREEN_WIDTH - 68 -
                     (var == 0 ? 0 : 1) + (var == 0 ? 13 : 14),
                     y + 30, boxClip[var],
                     Tools.BOTTOM, Tools.TRANS_HORIZONTAL, 9999);
    }
  }

  void drawTime(int sec, int x, int y) {
//          String secStr1 = (sec / 60 > 9 ? (sec / 60 + "") : ("0" + sec / 60));
//      String secStr2 = (sec % 60 > 9 ? (sec % 60 + "") : ("0" + sec % 60));
//        Tools.addImage(Tools.IMG_POINT, x + MyGameCanvas.SCREEN_WIDTH - 24, //ð
//                       GameMap.setOffY + 22, 26, 4, 4, 9, Tools.BOTTOM,
//                       Tools.TRANS_NONE,9999);
    if (sec / 60 > 9) {
      Tools.addImage(Tools.IMG_NUM2, x + 8, y, sec / 60 / 10 * 7, 0, 7, 10, Tools.BOTTOM,
                     Tools.TRANS_NONE, 9999);
      Tools.addImage(Tools.IMG_NUM2, x + 8 * 2, y, sec / 60 % 10 * 7, 0, 7, 10,
                     Tools.BOTTOM, Tools.TRANS_NONE, 9999);
    }
    else {
      Tools.addImage(Tools.IMG_NUM2, x + 8, y, 0 * 7, 0, 7, 10, Tools.BOTTOM,
                     Tools.TRANS_NONE, 9999);
      Tools.addImage(Tools.IMG_NUM2, x + 8 * 2, y, sec / 60 * 7, 0, 7, 10,
                     Tools.BOTTOM, Tools.TRANS_NONE, 9999);
    }
//ð
    Tools.addImage(Tools.IMG_POINT, x + 8 * 3, y, 26, 4, 4, 9, Tools.BOTTOM,
                   Tools.TRANS_NONE, 9999);

    if (sec % 60 > 9) {
      Tools.addImage(Tools.IMG_NUM2, x + 8 * 4, y, sec % 60 / 10 * 7, 0, 7, 10,
                     Tools.BOTTOM, Tools.TRANS_NONE, 9999);
      Tools.addImage(Tools.IMG_NUM2, x + 8 * 5, y, sec % 60 % 10 * 7, 0, 7, 10,
                     Tools.BOTTOM, Tools.TRANS_NONE, 9999);
    }
    else {
      Tools.addImage(Tools.IMG_NUM2, x + 8 * 4, y, 0 * 7, 0, 7, 10, Tools.BOTTOM,
                     Tools.TRANS_NONE, 9999);
      Tools.addImage(Tools.IMG_NUM2, x + 8 * 5, y, sec % 60 * 7, 0, 7, 10,
                     Tools.BOTTOM, Tools.TRANS_NONE, 9999);
    }

  }

  void getGift() {
    int rand = nextInt(81); //51
    if (rand < 30) { //0
      int num = role[0].level * 10;
//      canvas.setInfo("ýǮ#B" + num);
      canvas.setGiftAbout("ýǮ" + num);
      getMoney(num);
    }
    else if (rand < 60) { //1
      int num = role[0].level * 10;
//      canvas.setInfo("þ#B" + num + "#A");
      canvas.setGiftAbout("þ" + num + "");
      for (int i = 0; i < role.length; i++) {
        role[i].exp = Math.min(role[i].exp_max - 1, role[i].exp + num);
      }
    }
    else if (rand < 75) { //2
      int type = 0;
      if (role[0].level < 10) {
        type = Tools.percent(50) ? 0 : 5;
      }
      else if (role[0].level < 20) {
        type = Tools.percent(50) ? 1 : 6;
      }
      else if (role[0].level < 20) {
        type = Tools.percent(50) ? 2 : 7;
      }
      else {
        type = Tools.percent(50) ? 3 : 8;
      }
      getItem(items, item, type, 2, true);
    }
    else if (rand < 78) { //3
      getItem(items, item, 10, 1, true);
    }
    else { //4
      getItem(items, item, 8, 1, true);
    }

  }

//лѡ״̬
  static void toChooseStatus(String chooseTitle, String[] options, boolean rs) {
    MyGameCanvas.title = chooseTitle;
    MyGameCanvas.option = options;
    MyGameCanvas.choice = 0;
    MyGameCanvas.setST(MyGameCanvas.ST_CHOOSE);
    MyGameCanvas.canUseRS = rs;
  }

//л״̬
//  public static void toBlackStatus(String content) {
//    MyGameCanvas.index = 0;
//    MyGameCanvas.gameStatus = MyGameCanvas.ST_BLACKWORD;
//    MyGameCanvas.blackWord = content;
//  }
  public static void toBlackStatus(int cgName, String content) {
    MyGameCanvas.canPass = false;
    MyGameCanvas.index = 0;
//    MyGameCanvas.gameStatus = MyGameCanvas.ST_;
    MyGameCanvas.setST(MyGameCanvas.ST_BLACKWORD);
    if (content.equals("null")) {
      MyGameCanvas.blackWord = null;
    }
    else {
      if (cgName != 0) {
        MyGameCanvas.blackWord = MyGameCanvas.changeString(content, 7);
      }
      else {
        MyGameCanvas.blackWord = MyGameCanvas.changeString(content, 11);
      }
    }
    MyGameCanvas.cgImgID = -1;

    short img[] = new short[] {
        Tools.IMG_GOD8, Tools.IMG_GOD5, Tools.IMG_GOD9, Tools.IMG_GOD10, Tools.IMG_GOD1,
        Tools.IMG_GOD3, Tools.IMG_GOD7, Tools.IMG_GOD2, Tools.IMG_GOD4, Tools.IMG_GOD6,
        Tools.IMG_GOD0, Tools.IMG_GOD11};
    if (cgName - 1 < 0) {
      cgName = 0;
    }
    if (cgName != 0) {

      MyGameCanvas.cgImgID = img[cgName - 1];
    }

  }

//
  static int shakeTime; //ζʱ  -1-0-ֹͣ,>0-ʱ
  static int shakeWave = 3; //ζ
  public static void screenShake() {
    if (shakeTime == 0) {
      return;
    }
    if (shakeTime > 0) {
      shakeTime--;
    }
    map.setOffY = MyGameCanvas.gameTime % 2 == 0 ? map.setOffY + shakeWave :
        map.setOffY - shakeWave;
  }

//
  public static int nextInt(int n) {
    return (int) (Math.abs(rnd.nextInt()) % (n + 1));
  }

  public static int nextInt(int n, int m) {
    if (n == m) {
      return n;
    }
    if (n > m) {
      int temp = n;
      n = m;
      m = temp;
    }
    return (int) ( (Math.abs(rnd.nextInt()) % (m - n + 1)) + n);
  }

//ͼ
  byte areaIndex;
  boolean isAreaName;
  void drawAreaName(int x, int y, int lev) {
    byte areaNameY[] = {
        -30, -24, -20, -16, -12, -8, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0,
        -4, -8, -12, -16, -20, -24, -30
    };
    String mapName = Event.getString(map.mapName);
    byte len = (byte) mapName.length();
    canvas.drawFrame_3(Tools.IMG_UI_BAR1, GameData.imgDatFr0,
                       x, y + areaNameY[areaIndex],
                       len * 20 + 16, 24, canvas.COL_BAR, lev);
    Tools.addString(Tools.TYPE_STRING, mapName,
                    x + (len * 20 + 16) / 2,
                    y + 2 + 10 + areaNameY[areaIndex],
                    Tools.CENTER, canvas.COL_INFO, lev);
    if (++areaIndex >= areaNameY.length) {
      areaIndex = 0;
      isAreaName = false;
    }
  }

//ϷUI
  byte[][] buttonData = {
      {
      0, 1, 22, 22}
      ,
      /*ǰ*/
      {
      22, 0, 24, 24}
      ,
      /**/
      {
      46, 10, 10, 14}
      ,
      /*3*/
      {
      57, 10, 10, 14}
  }; /*5*/

  public void drawButton(int x, int y, boolean on, int num, int lev) {
    if (on) {
      Tools.addImage(Tools.IMG_BUTTON2, x, y, buttonData[1], Tools.BOTTOM,
                     Tools.TRANS_NONE, lev);
      Tools.addImage(Tools.IMG_BUTTON2, x + 1, y - 1, buttonData[0],
                     Tools.BOTTOM,
                     Tools.TRANS_NONE, lev);
      switch (num) {
        case 3:
          Tools.addImage(Tools.IMG_BUTTON2, x + 7, y - 5, buttonData[2],
                         Tools.BOTTOM,
                         Tools.TRANS_NONE, lev);
          break;
        case 5:
          Tools.addImage(Tools.IMG_BUTTON2, x + 7, y - 5, buttonData[3],
                         Tools.BOTTOM,
                         Tools.TRANS_NONE, lev);
          break;
      }
    }
    else {
      Tools.addImage(Tools.IMG_BUTTON2, x, y, buttonData[1], Tools.BOTTOM,
                     Tools.TRANS_NONE, lev);
      Tools.addImage(Tools.IMG_BUTTON2, x + 1, y - 3, buttonData[0],
                     Tools.BOTTOM,
                     Tools.TRANS_NONE, lev);
      switch (num) {
        case 3:
          Tools.addImage(Tools.IMG_BUTTON2, x + 7, y - 7, buttonData[2],
                         Tools.BOTTOM,
                         Tools.TRANS_NONE, lev);
          break;
        case 5:
          Tools.addImage(Tools.IMG_BUTTON2, x + 7, y - 7, buttonData[3],
                         Tools.BOTTOM,
                         Tools.TRANS_NONE, lev);
          break;
      }
    }
  }

  final void drawInterFace(Graphics g, int x, int y, int lev) {
    if (MyGameCanvas.isJump) {
      canvas.drawJump();
    }
    else if (MyGameCanvas.showBlackHole) {
      canvas.drawBlackHole();
    }
    else {
      if (isAreaName) {
        drawAreaName(x, y, lev);
      }

//      if (MyGameCanvas.gameStatus == MyGameCanvas.ST_PLAY && Script.isUserCtrl) {
//        Tools.addImage(Tools.IMG_UI_WORD, x + 1, y + GameMap.screenHeight,
//                       0, 0, 19, 20, Tools.BOTTOM, Tools.TRANS_NONE, lev);
//        if (Script.scriptVar[287] == 1) {
//          Tools.addImage(Tools.IMG_UI_WORD, x + GameMap.screenWidth - 1,
//                         y + GameMap.screenHeight, 20, 0, 17, 20,
//                         Graphics.BOTTOM | Graphics.RIGHT, Tools.TRANS_NONE, lev);
//        }
//
//      }

      if (canTouch &&
          (sprite[touchID].curStates == GameSprite.ST_STOP)) {
        drawButton(sprite[spriteIndex].ax - 2, sprite[spriteIndex].ay - 48,
                   GameMIDlet.gameIndex % 6 == 0, 5, 1000);
      }
    }
  }

  int BHIndex = 0; //74  54
  public void drawBlackHole(int x, int y) {
    int w = 13;
    int h = 10;
    BHIndex++;
    Tools.addARC(Tools.TYPE_ARC, x - w / 2, y - h / 2, w, h, 0, 360, true,
                 Tools.TOP, 0, GameMap.L_ROLESD);
  }

//ͷԴ
  void free() {
    sprite = null;
    Tools.removeAllSinleImage(new int[] {});
    Tools.removeAllGroupImage(new int[] {});
    enemyTeam = null;
    battle.free();
    map.free();
    Script.free();
    Effect.EffectV.removeAllElements();
    System.gc();
  }

//ؿʼ
  int initIndex = 0;
  public boolean initGame() {
    switch (initIndex) {
      case 1:
        free();
        break;
      case 10:
        showLight = false;
        showHole = false;

//        map.isLookMode = false;
        filmSwitch = 0;
        gameFinish = false;
        map.setOff(0, 0);
        roleIndex = 0;
        isToPoint = false;
        Battle.canLose = false;
        GameMap.SCEEN_MOVE = 10;
        Battle.canEscape = true;
        MyGameCanvas.gameTime = 0;
        spriteIndex = 0;
        isBattle = false;
        if (!God.canMissBomb) {
          stopBomb = false;
        }

        Battle.stopBattle = false;
        isShowGame = true;
        isNoMap = true;

        break;
      case 15:
        break;
      case 20:
        if (isChangMap) {
          try {
            Script.loadScript(gameRank);
          }
          catch (Exception ex) {
            ex.printStackTrace();
          }
          isChangMap = false;
        }

//        System.gc();
        break;
      case 25:

//        System.out.println("############   initSpriteXY");
        initSpirateXY();

//        System.gc();
        break;
      case 30:

        //ʼͼ
        map.initMap();
        Sound.playmusic(map.BGM, -1);

//        System.gc();
        break;
      case 35:

        initBomb();
        isChangMap = false;
        break;
      case 38:
        System.gc();

//        for (int i = 0; i < equip.length; i++) {
//          getEquip(i, false);
//          equips.addElement(new short[] { (short) i, 1, 0, 0, 0, 5, 200});
//        }
//        for (int i = 0; i < item.length; i++) {
//          getItem(items, item, i, 5, false);
//          items.addElement(new short[] { (short) i, 2});
//        }

//        souls.addElement(new short[] { (short) 0, 50, 0, 2});
//        souls.addElement(new short[] { (short) 1, 10, 1, 1});
//        souls.addElement(new short[] { (short) 2, 15, 2, 0});
//        for (int i = 0; i < soul.length; i++) {
//          getSoul(i, 1, 2, 100, false);
//          souls.addElement(new short[] { (short) i, 3, 0, 1});
//        }
//        for (int i = 0; i < other.length; i++) {
//          getItem(others, other, i, 5, false);
//          others.addElement(new short[] { (short) i, 1});
//        }

//        money = 30000;
        break;
      case 40:

//        sprite[0].visible = true;
//        System.out.println("OK");
        return Script.runInitEvent();
    }
    initIndex++;
//    System.out.println("ʧ" + initIndex);
    return false;
  }

  //ȫֳԻ
  static byte initRank = 0;
  public void allInit() {
    playX = -1;
    playY = -1;
    playDir = -1;
    gameRank = initRank;
    gameFinish = false;
    stopBomb = false;

    taskMain = null;
    taskSub = null;

    Script.scriptVar = new byte[Script.SCRIPTVARMAX]; //ű
//    for (int i = 0; i < Script.SCRIPTVARMAX; i++) {
//      Script.scriptVar[i] = 1;
//    }
    money = 0;
    roleTeam = new byte[] {
        0};
//        0, 1, 2};
    spriteIndex = roleTeam[0];
    Battle.stopBattle = false;

    for (int i = 0; i < role.length; i++) {
      role[i].initFighter( (byte) i, false);
    }
    items.removeAllElements();
    equips.removeAllElements();
    souls.removeAllElements();
    others.removeAllElements();

    for (int i = 0; i < God.disc.length; i++) {
      God.removeGod(i);
    }
    for (int i = 0; i < God.gods.length; i++) {
      God.gods[i] = God.bGods[i];
    }
    God.orders = null;

//    role[0].setLevel(120);
//
//    role[0].addSkill( (byte) 3);
//    role[0].addSkill( (byte) 4);
//    role[0].addSkill( (byte) 5);
//    role[0].addSkill( (byte) 6);
//    role[0].addSkill( (byte) 7);
//    role[0].addSkill( (byte) 8);
//    role[0].addSkill( (byte) 9);
//
//    role[1].setLevel(120);
//    role[1].addSkill( (byte) 17);
//    role[1].addSkill( (byte) 18);
//    role[1].addSkill( (byte) 19);
//    role[1].addSkill( (byte) 20);
//    role[1].addSkill( (byte) 21);
//    role[1].addSkill( (byte) 22);
//    role[1].addSkill( (byte) 23);
//
//    role[2].setLevel(120);
//    role[2].addSkill( (byte) 10);
//    role[2].addSkill( (byte) 11);
//    role[2].addSkill( (byte) 12);
//    role[2].addSkill( (byte) 13);
//    role[2].addSkill( (byte) 14);
//    role[2].addSkill( (byte) 15);
//    role[2].addSkill( (byte) 16);

//    for (int i = 0; i < 12; i++) {
//      God.getGod(i);
//    }

//    getSoul(0, 0, 0, 9, false);
//    getSoul(1, 0, 0, 9, false);
//    getSoul(2, 0, 0, 9, false);
//    getSoul(3, 0, 0, 9, false);

//    if (!MyMessage.canSendAgian(6)) {
//      God.gods[God.G_Ⱥ] = 1;
//    }
//    if (!MyMessage.canSendAgian(7)) {
//      God.gods[God.G_Ѫ] = 1;
//    }
//    if (!MyMessage.canSendAgian(8)) {
//      God.gods[God.G_] = 1;
//    }
//    if (!MyMessage.canSendAgian(9)) {
//      God.gods[God.G_ܵ] = 1;
//    }

//    System.out.println("OK");
  }

  public void testAll() {

//    me.role[0].setLevel(50);
//    canvas.setInfo("ɹ");
  }

  //Ӱ
  public void drawShandow(int x, int y, int w, int h, int color,
                          int drawLevel) {
    Tools.addARC(Tools.TYPE_ARC, x - w / 2, y - h / 2, w, h, 0, 360, true,
                 Tools.TOP, color, drawLevel);
  }

  //ʼս
  public void initBattle() {
    setPlayXY(sprite[spriteIndex].x, sprite[spriteIndex].y,
              sprite[spriteIndex].dir, sprite[spriteIndex].visible);
//    Tools.removeAllSinleImage(new int[] {});
    map.initBattleMap();
    battle.initBattle(roleTeam, enemyTeam, isElite);
    battle.wait = 0;
    battle.index = 0;
    battle.setBattleST(Battle.B_WAIT);
  }

  public static void getItem(Vector myPack, ItemInterface[] items, int type,
                             int num, boolean isInfo) {
    boolean isNew = true;
    for (int i = myPack.size() - 1; i >= 0; i--) {
      short[] temp = (short[]) myPack.elementAt(i);
      if (temp[0] == type) {
        temp[1] = (short) Math.min(99, temp[1] + num);
        isNew = false;
        break;
      }
    }
    if (isNew) {
      myPack.addElement(new short[] { (short) type, (short) num});
    }
    if (MyGameCanvas.showGift) {
      MyGameCanvas.setGiftAbout("" + items[type].name + "x" + num);
      return;
    }

    if (isInfo) {
      if (myPack.equals(others)) {
        MyGameCanvas.setInfo(" þ#G" + items[type].name);
      }
      else {
        MyGameCanvas.setInfo("#G" + items[type].name + "#Ax" + num);
      }

    }
  }

  public static boolean dropItem(Vector myPack, int type, int num) {
    for (int i = myPack.size() - 1; i >= 0; i--) {
      short[] temp = (short[]) myPack.elementAt(i);
      if (temp[0] == type) {
        if (temp[1] <= num) {
          myPack.removeElementAt(i);
          return true;
        }
        else {
          temp[1] = (short) Math.max(0, temp[1] - num);
          return false;
        }
      }
    }
    return true;
  }

  public static void getEquip(int type, boolean isInfo) {
    Equipment eq = equip[type];
    switch (eq.type) {
      case Equipment.ET_:
      case Equipment.ET_:
      case Equipment.ET_:
      case Equipment.ET_Ů:
      case Equipment.ET_:
        equips.addElement(new short[] { (short) type, eq.prop1, 0, 0, 0, 0,
                          eq.power});
        break;
      case Equipment.ET_Ʒ:
        equips.addElement(new short[] { (short) type, (short) eq.prop1,
                          eq.prop2, 0, 0, eq.prop3, eq.power});
        break;
    }

    if (isInfo) {
      MyGameCanvas.setInfo("#G" + eq.name);
    }
  }

  public static void getEquip(short[] equip) {
    equips.addElement(equip);
  }

  public static void dropEqip(short[] equip) {
    equips.removeElement(equip);
  }

  public static void getSoul(int type, int quality, int lev, int num,
                             boolean isInfo) { //type,Ʒʣȼ
    boolean isNew = true;
    for (int i = souls.size() - 1; i >= 0; i--) {
      short[] temp = (short[]) souls.elementAt(i);
      if (temp[0] == type && temp[2] == quality && temp[3] == lev) {
        temp[1] = (short) Math.min(99, temp[1] + num);
        isNew = false;
        break;
      }
    }
    if (isNew) {
      souls.addElement(new short[] { (short) type, (short) num, (short) quality,
                       (short) lev});
    }
    if (isInfo) {
      String[] col = {
          "#W", "#G", "#Y"};
      if (quality == 0) {
        MyGameCanvas.setInfo("" + "#A" + num + "" + col[lev] + soul[type].name);
      }
      else {
        MyGameCanvas.setInfo("" + "#A" + num + "" + col[lev] + soul[type].name + "+" +
                             quality);
      }

    }
  }

  public static void dropSoul(int index, int num) {
    short[] temp = (short[]) souls.elementAt(index);
    if (temp[1] > num) {
      temp[1] -= num;
    }
    else {
      souls.removeElementAt(index);
    }
  }

  public static byte[] addData(byte data[], byte id) {
    byte[] temp;
    if (data == null) {
      temp = new byte[1];
      temp[0] = id;
    }
    else {
      int len = data.length;
      temp = new byte[len + 1];
      System.arraycopy(data, 0, temp, 0, len);
      temp[len] = id;
    }
    return temp;
  }

  public static byte[] removeData(byte data[], byte id) {
    byte[] temp;
    if (data == null) {
      return data;
    }
    else {
      temp = new byte[data.length];
      int len = 0;
      for (int i = 0; i < data.length; i++) {
        if (data[i] != id) {
          len++;
        }
      }
      if (len == 0) {
        return null;
      }
      else {
        temp = new byte[len];
        len = 0;
        for (int i = 0; i < data.length; i++) {
          if (data[i] != id) {
            temp[len] = data[i];
            len++;
          }
        }
      }
    }
    return temp;
  }

//лս״̬
  public static void toBattle(boolean boss, boolean lost) {
    isElite = false;
    byte len = (byte) vEnemys.size();
    enemyTeam = new byte[len];
    for (int i = 0; i < len; i++) {
      byte[] dat = (byte[]) vEnemys.elementAt(i);
      enemyTeam[i] = dat[0];
    }
    vEnemys.removeAllElements();
    Battle.canEscape = !boss;
    Battle.canLose = lost;
    MyGameCanvas.setST(MyGameCanvas.ST_INITBATTLE);
//    Sound.playmusic(Sound.Music_ս, -1);
  }

//ʼ
  public void initRole() {
    role = new Fighter[ROLEMAX];
    for (int i = 0; i < ROLEMAX; i++) {
      role[i] = new Fighter(this);
      role[i].initFighter( (byte) i, false);
    }
//    int max = 0;
//    for (int i = 1; i < 99; i++) {
//      max = role[0].getStandardExpMax(0, i);
//      System.out.println(i + "  :   " + max);
//      int bnum=(i+1)/2+1;
//      int roleNum;//*2
//      if(i<5){
//        roleNum=3;
//      }else if(i<20){
//        roleNum=5;
//      }else{
//        roleNum=6;
//      }
//       System.out.println(i+"  :   "+(max*2/bnum/roleNum));
//    }
  }

//ɫ
  static void drawColorScreenBG(int color, int drawLevel) {
    Tools.addRect(Tools.TYPE_RECT, GameMap.setOffX, GameMap.setOffY,
                  GameMap.screenWidth, GameMap.screenHeight, true,
                  Tools.TOP, color, drawLevel);
  }

  /**---------------------------ЧЧ----------------------------------*/

  public static final byte SK_Զս = 1;
//  public static final byte SK_Ҷ = 2;
  public static final byte SK_Ǿ = 3;
  public static final byte SK_ = 4;
  public static final byte SK_ս = 5;
  public static final byte SK_ս = 6;
  public static final byte SK_Ѫ = 7;
  public static final byte SK_Ԫ = 8;
  public static final byte SK_ = 9;
  public static final byte SK_ = 10;
  public static final byte SK_ = 11;
  public static final byte SK_ڤ = 12;
  public static final byte SK_а = 13;
  public static final byte SK_С = 14;
  public static final byte SK_ = 15;
  public static final byte SK_ڤ÷ = 16;
  public static final byte SK_Ʊ = 17;
  public static final byte SK_Ѫ = 18;
  public static final byte SK_ = 19;
  public static final byte SK_׺䶥 = 20;

  public static final byte SK_ǧ = 21;
  public static final byte SK_ʥ = 22;
  public static final byte SK_ = 23;

  public static final byte SK_ = 24;

  public static final byte SK_ʬ = 26; //
  public static final byte SK_а = 27;
//  public static final byte SK_ = 28;
//  public static final byte SK_ƻ = 29;
//  public static final byte SK_Ѫ = 30;

  public static final byte SK_Ѫħʴ = 31;

  public static final byte SK_Ԫ = 32;
  public static final byte SK_» = 33;

  public static final byte SK_ = 34;
  public static final byte SK_ = 35;
  public static final byte SK_צ = 36;
  public static final byte SK_ӡ = 37;

  public static final byte SK_Զս2 = 38;
  public static final byte SK_Զս3 = 39;
  public static final byte SK_Զս4 = 40;
  public static final byte SK_Զս5 = 41;
  public static final byte SK_Զս6 = 42;

  int skillFinshTime;
  int skillTime;
  public void drawSkillEft(int type, int isMir) {
    switch (type) {
      case SK_Ԫ:
        skillFinshTime = 60;
        int x = battle.S2;
        short h1 = battle.H1;
        short h2 = battle.H2;
        short h3 = battle.H3;
        h1 -= 10;
        h3 += 10;
        short tempxy[][] = new short[][] {
            {
            -50, h1}
            , {
            0, h2}
            , {
            50, h3}
            , {
            50, h1}
            , {
            10, h2}
            , {
            -50, h3}
            , {
            0, h2}
        };
        skillEvent(20, x + tempxy[0][0], tempxy[0][1],
                   46, isMir, 999);
        skillEvent(24, x + tempxy[0][0], tempxy[0][1],
                   46, isMir, 999);

        skillEvent(24, x + tempxy[1][0], tempxy[1][1],
                   46, isMir, 999);
        skillEvent(28, x + tempxy[1][0], tempxy[1][1],
                   46, isMir, 999);

        skillEvent(28, x + tempxy[2][0], tempxy[2][1],
                   46, isMir, 999);
        skillEvent(32, x + tempxy[2][0], tempxy[2][1],
                   46, isMir, 999);

        skillEvent(32, x + tempxy[3][0], tempxy[3][1],
                   46, isMir, 999);
        skillEvent(36, x + tempxy[3][0], tempxy[3][1],
                   46, isMir, 999);

        skillEvent(36, x + tempxy[4][0], tempxy[4][1],
                   46, isMir, 999);
        skillEvent(40, x + tempxy[4][0], tempxy[4][1],
                   46, isMir, 999);

        skillEvent(40, x + tempxy[5][0], tempxy[5][1],
                   46, isMir, 999);
        skillEvent(44, x + tempxy[5][0], tempxy[5][1],
                   46, isMir, 999);

        skillEvent(44, x + tempxy[6][0] - 40, tempxy[6][1],
                   46, isMir, 999);
        skillEvent(48, x + tempxy[6][0] - 40, tempxy[6][1],
                   46, isMir, 999);

        skillEvent(44, x + tempxy[6][0], tempxy[6][1],
                   46, isMir, 999);
        skillEvent(48, x + tempxy[6][0], tempxy[6][1],
                   46, isMir, 999);

        skillEvent(44, x + tempxy[6][0] + 40, tempxy[6][1],
                   5, isMir, 999);
        skillEvent(48, x + tempxy[6][0] + 40, tempxy[6][1],
                   46, isMir, 999);

        break;

      case SK_Ʊ:
        skillFinshTime = 46;
        skillEvent(10, GameMap.setOffX + 40, GameMap.setOffY + 166,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(12, GameMap.setOffX + 70, GameMap.setOffY + 190,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(14, GameMap.setOffX + 40, GameMap.setOffY + 240,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(16, GameMap.setOffX + 40, GameMap.setOffY + 166,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(18, GameMap.setOffX + 70, GameMap.setOffY + 190,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(20, GameMap.setOffX + 40, GameMap.setOffY + 240,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(22, GameMap.setOffX + 40, GameMap.setOffY + 166,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(24, GameMap.setOffX + 70, GameMap.setOffY + 190,
                   Effect.EFFECT_WIND, isMir, 202 + 31);
        skillEvent(26, GameMap.setOffX + 40, GameMap.setOffY + 240,
                   Effect.EFFECT_WIND, isMir, 202 + 31);

        skillEvent(28, GameMap.setOffX + 40, GameMap.setOffY + 166,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(29, GameMap.setOffX + 70, GameMap.setOffY + 190,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(30, GameMap.setOffX + 40, GameMap.setOffY + 240,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);

        skillEvent(32, GameMap.setOffX + 40, GameMap.setOffY + 166,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(33, GameMap.setOffX + 70, GameMap.setOffY + 190,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(34, GameMap.setOffX + 40, GameMap.setOffY + 240,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);

        skillEvent(36, GameMap.setOffX + 40, GameMap.setOffY + 166,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(37, GameMap.setOffX + 70, GameMap.setOffY + 190,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(38, GameMap.setOffX + 40, GameMap.setOffY + 240,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);

        skillEvent(40, GameMap.setOffX + 40, GameMap.setOffY + 166,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(41, GameMap.setOffX + 70, GameMap.setOffY + 190,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);
        skillEvent(42, GameMap.setOffX + 40, GameMap.setOffY + 240,
                   Effect.EFFECT_SPRAY, isMir, 202 + 31);

        break;

      case SK_а:
        skillFinshTime = 70;
        int tempx = GameMap.setOffX;
        int tempy = GameMap.setOffY + 30;

        if (skillTime == 60) {
          shakeTime = 4;
        }
        if (skillTime > 7 && skillTime < 35) {
          Tools.addRect(Tools.TYPE_RECT, GameMap.setOffX, GameMap.setOffY,
                        GameMap.screenWidth, GameMap.screenHeight, true,
                        Tools.TOP, 0, GameMap.L_HIGH);
        }

        skillEvent(10, tempx + 150, tempy + 90, 34, isMir, GameMap.L_HIGH);
        skillEvent(11, tempx + 90, tempy + 12, 35, isMir, GameMap.L_HIGH);
        skillEvent(12, tempx + 45, tempy + 50, 35, isMir, GameMap.L_HIGH);
        skillEvent(14, tempx + 135, tempy + 50, 35, isMir, GameMap.L_HIGH);
        skillEvent(15, tempx + 163, tempy + 17, 35, isMir, GameMap.L_HIGH);
        skillEvent(16, tempx + 16, tempy + 20, 35, 1, GameMap.L_HIGH);
        skillEvent(21, tempx + 135, tempy + 50, 35, isMir, GameMap.L_HIGH);
        skillEvent(22, tempx + 16, tempy + 20, 35, 1, GameMap.L_HIGH);
        skillEvent(23, tempx + 88, tempy + 12, 35, isMir, GameMap.L_HIGH);
        skillEvent(25, tempx + 70, tempy + 76, 35, isMir, GameMap.L_HIGH);
        skillEvent(27, tempx + 12, tempy + 80, 35, 1, GameMap.L_HIGH);
        skillEvent(27, tempx + 70, tempy + 58, 35, isMir, GameMap.L_HIGH);

        if (skillTime == 33 || skillTime == 34) {
          Tools.addRect(Tools.TYPE_RECT, GameMap.setOffX, GameMap.setOffY,
                        GameMap.screenWidth, GameMap.screenHeight, true,
                        Tools.TOP, 0xFFFFFF, GameMap.L_HIGH + 1);
        }
        skillEvent(30, tempx, tempy, 37, isMir, GameMap.L_HIGH);
        skillEvent(35, tempx, tempy, 36, isMir, GameMap.L_HIGH);

        break;

      case SK_ǧ:

        skillFinshTime = 80;
        drawColorScreenBG(0, GameMap.L_OVERBBG);

        tempx = isMir == 1 ? GameMap.screenWidth - Battle.S2 : Battle.S2;
        tempy = Battle.H2;

        if (skillTime == 21) {
          shakeTime = 58;
        }

        for (int j = 0; j < 31; j += 30) {

          skillEvent(20 + j, tempx - 40, Battle.H2, 23, isMir, GameMap.L_ROLESD);
          skillEvent(26 + j, tempx - 40, Battle.H2, 50, isMir, GameMap.L_ROLESD);

          skillEvent(25 + j, tempx, Battle.H1, 23, isMir, GameMap.L_ROLESD);
          skillEvent(31 + j, tempx, Battle.H1, 50, isMir, GameMap.L_ROLESD);

          skillEvent(30 + j, tempx - 40, Battle.H3 + 10, 23, isMir,
                     GameMap.L_ROLESD);
          skillEvent(36 + j, tempx - 40, Battle.H3 + 10, 50, isMir,
                     GameMap.L_ROLESD);

          skillEvent(35 + j, tempx, Battle.H2, 23, isMir, GameMap.L_ROLESD);
          skillEvent(41 + j, tempx, Battle.H2, 50, isMir, GameMap.L_ROLESD);

          skillEvent(40 + j, tempx - 60, Battle.H1, 23, isMir, GameMap.L_ROLESD);
          skillEvent(46 + j, tempx - 60, Battle.H1, 50, isMir, GameMap.L_ROLESD);

        }

        break;

      case SK_Ѫ:
        skillFinshTime = 60;
        skillEvent(15, GameMap.setOffX + 56, GameMap.setOffY + 188,
                   Effect.EFFECT_BIGFIRE, isMir, 202 + 31);

        skillEvent(36, GameMap.setOffX + 126, GameMap.setOffY + 213,
                   Effect.EFFECT_MOON, isMir, 202 + 31);
        skillEvent(37, GameMap.setOffX + 126 - 33, GameMap.setOffY + 213 - 35,
                   Effect.EFFECT_MOON, isMir, 202 + 31);
        skillEvent(38, GameMap.setOffX + 60, GameMap.setOffY + 213,
                   Effect.EFFECT_MOON, isMir, 202 + 31);
        skillEvent(38, GameMap.setOffX + 152, GameMap.setOffY + 213 + 10,
                   Effect.EFFECT_MOON, isMir, 202 + 31);
        skillEvent(40, GameMap.setOffX + 80, GameMap.setOffY + 243,
                   Effect.EFFECT_MOON, isMir, 202 + 31);
        skillEvent(43, GameMap.setOffX + 100, GameMap.setOffY + 210,
                   Effect.EFFECT_MOON, isMir, 202 + 31);
        skillEvent(46, GameMap.setOffX + 130, GameMap.setOffY + 250,
                   Effect.EFFECT_MOON, isMir, 202 + 31);
        skillEvent(50, GameMap.setOffX + 65, GameMap.setOffY + 230,
                   Effect.EFFECT_MOON, isMir, 202 + 31);

        skillEvent(40, GameMap.setOffX + 80, GameMap.setOffY + 10,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);
        skillEvent(40, GameMap.setOffX + 30, GameMap.setOffY,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);
        skillEvent(45, GameMap.setOffX + 30, GameMap.setOffY - 35,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);
        skillEvent(50, GameMap.setOffX + 55, GameMap.setOffY - 20,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);
        skillEvent(50, GameMap.setOffX + 75, GameMap.setOffY - 40,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);
        skillEvent(55, GameMap.setOffX + 30, GameMap.setOffY,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);
        skillEvent(55, GameMap.setOffX + 10, GameMap.setOffY - 40,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);
        skillEvent(55, GameMap.setOffX + 60, GameMap.setOffY - 60,
                   Effect.EFFECT_SHANOW, isMir, 202 + 31);

        break;
    }
    if (++skillTime >= skillFinshTime) {

      skillFinshTime = 0;
      skillTime = 0;
      if (isOver) {
        actionOver();
      }
      isOver = true;
      return;
    }
  }

  public void drawRect(int x, int y, int h, int drawLev) {

    Tools.addRect(Tools.TYPE_RECT, x, y, 60, h, true,
                  Graphics.LEFT | Graphics.TOP, 0xF8D058, drawLev);
    Tools.addRect(Tools.TYPE_RECT, x + 1, y, 58, h, true,
                  Graphics.LEFT | Graphics.TOP, 0xF8E890, drawLev);
    Tools.addRect(Tools.TYPE_RECT, x + 2, y, 56, h, true,
                  Graphics.LEFT | Graphics.TOP, 0xF8F0A0, drawLev);
    Tools.addRect(Tools.TYPE_RECT, x + 3, y, 54, h, true,
                  Graphics.LEFT | Graphics.TOP, 0xF8F8C8, drawLev);
    Tools.addRect(Tools.TYPE_RECT, x + 6, y, 48, h, true,
                  Graphics.LEFT | Graphics.TOP, 0xffffff, drawLev);

  }

  short ex, ey;
  boolean isOver = true;
  int h;
  int qilinx = 0;

  public void drawSkillEft(int type, Fighter[] f, Fighter role, int isMir) {
    for (int i = 0; i < f.length; i++) {
      switch (type) {
        case SK_Ǿ:
          skillFinshTime = 160;

//          System.out.println("skillTime = " + skillTime);
//          if (skillTime == 0) {
//            drawColorScreenBG(0, GameMap.L_OVERBBG);
//          }
//          if (skillTime == 2) {
//            drawColorScreenBG(0xff0000, GameMap.L_OVERBBG);
//            shakeTime = 4;
//          }
          skillEvent(0, role.x + 10, role.y - 35, 16, 0, role.y + 30);
          if (skillTime >= 11 && skillTime <= 17) {
            f[i].move(f[i].bx - (skillTime - 10) * 15, f[i].by);
            role.move(role.bx - 80 - (skillTime - 10) * 15, role.y);
          }
          int tx = 0; //
          if (skillTime >= 36 && skillTime <= 71) {
            tx = - (skillTime - 36) * 2;
          }
          else if (skillTime > 71) {
            tx = -70;
          }

          //볡
          if (skillTime >= 18 && skillTime <= 20) {
            drawColorScreenBG(skillTime % 2 == 0 ? 0 : 0xFFFFFF, GameMap.L_MAX);
            Battle.cleanFighter();
          }
          if (skillTime == 20) {
            passInit(true);
            f[i].move(175 + 10 - skillTime * 2, Battle.H2);
            role.move(160 + 80 + 10 - skillTime * 2, Battle.H2);
          }
          if (skillTime > 36) {
            f[i].move(175 + 10 - 40 + tx, Battle.H2);
            role.move(160 + 80 + 10 - 40 + tx, Battle.H2);
          }
          if (skillTime > 20 && skillTime < 40) {
            drawPass(0xFFFFFF, true);
          }

          //

          //
          if (skillTime >= 20 && skillTime <= 130) {
            drawColorScreenBG(0, GameMap.L_OVERBBG);
            drawSpace(GameMap.setOffX, GameMap.setOffY + 90, GameMap.L_OVERBBG);
          }

          for (int j = 0; j < 10; j += 5) {
            skillEvent(80 + j, role.x, role.y - 33, 10, 0,
                       role.y + GameMap.L_ROLESD + 1000);
          }
          skillEvent(98, role.x - 21, role.y - 57, 16, 0,
                     role.y + GameMap.L_ROLESD + 1000);
          skillEvent(101, role.x - 21 - 4, role.y - 57 - 8, 16, 0,
                     role.y + GameMap.L_ROLESD + 1000);
          skillEvent(104, role.x - 21 - 4 - 2, role.y - 57 - 8 - 7, 16, 0,
                     role.y + GameMap.L_ROLESD + 1000);
          skillEvent(107, role.x - 21 - 4 - 2 - 2, role.y - 57 - 8 - 7 - 8, 16, 0,
                     role.y + GameMap.L_ROLESD + 1000);
          skillEvent(110, role.x - 21 - 4 - 2 - 2 - 2, role.y - 57 - 8 - 7 - 8 - 7, 16, 0,
                     role.y + GameMap.L_ROLESD + 1000);
          skillEvent(103, role.x - 21 - 4 - 2 - 2 - 2 - 2,
                     role.y - 57 - 8 - 7 - 8 - 7 - 8, 16, 0,
                     role.y + GameMap.L_ROLESD + 1000);

          //
          //
          if (skillTime == 120) {
            GameEngine.showLight(GameMap.setOffX + 63 + 6, GameMap.setOffY + 199 - 27, false);
          }
          if (skillTime > 120 && skillTime < 140) {
            drawLight();
          }
          if (skillTime == 125) {
            passInit(true);
            Battle.getFighter();
//            System.out.println("f[i]x=====" + f[i].bx);
//            System.out.println("f[i]y=====" + f[i].by);
          }
          if (skillTime == 140) {
            showLight = false;
          }
          if (skillTime >= 140 && skillTime <= 160) {
            f[i].move(f[i].bx, f[i].by);
            drawPass(0xFFFFFF, true);
          }

          //

//          skillEvent(16, f[i].x, f[i].y, Effect.EFFECT_Ready, 0,
//                     f[i].y + GameMap.L_ROLESD - 1);

//          if (skillTime == 26) {
//            drawColorScreenBG(0xff0000, GameMap.L_OVERBBG);
//            shakeTime = 12;
//          }

//          skillEvent(65, f[i].x , f[i].y, Effect.EFFECT_Ready, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(68, f[i].x, f[i].y - 5, Effect.EFFECT_Ready, 0,
                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(71, f[i].x , f[i].y, Effect.EFFECT_Ready, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(74, f[i].x, f[i].y - 5, Effect.EFFECT_Ready, 0,
                     f[i].y + GameMap.L_ROLESD + 1);

          break;
        case SK_Ѫħʴ:
          skillFinshTime = 50;
          skillEvent(10, f[i].x + 5, f[i].y - 40, 16, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          for (int j = 0; j < 24; j += 3) {
            skillEvent(20 + j, f[i].x + 10, f[i].y, 26, 0,
                       f[i].y + GameMap.L_ROLESD + 1);
          }
          break;
        case SK_:
          skillFinshTime = 50;

//          drawColorScreenBG(0, GameMap.L_OVERBBG);

//          int tempx = isMir == 1 ? GameMap.screenWidth - Battle.S2 : Battle.S2;
//          int tempy = Battle.H2;
          if (skillTime == 34) {
            shakeTime = 5;
          }

//          for (int j = 0; j < 7; j += 6) {
          skillEvent(28, f[i].x, f[i].y, 23, isMir,
                     GameMap.L_HIGH);
          skillEvent(34, f[i].x, f[i].y, 50, isMir,
                     GameMap.L_HIGH);

//          }
          break;
        case SK_:
          skillFinshTime = 55;
          skillEvent(22, f[i].x + 5, f[i].y - 10, 25, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(24, f[i].x, f[i].y - 10, 25, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(30, f[i].x + 10, f[i].y - 10, 22, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

          break;
        case SK_צ:
          skillFinshTime = 25;
          skillEvent(8, f[i].x, f[i].y, 45, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(11, f[i].x, f[i].y, 46, 1,
                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(11, f[i].x, f[i].y, 17, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);

          skillEvent(14, f[i].x, f[i].y, 47, 0,
                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(17, f[i].x, f[i].y - 10, 48, 1,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(17, f[i].x, f[i].y, 17, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
          break;
        case SK_ӡ:
          skillFinshTime = 35;
          skillEvent(20, GameMap.setOffX + 115, GameMap.setOffY + 195, 24, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          break;

        case SK_»:

          skillFinshTime = 85;
          drawColorScreenBG(0, GameMap.L_OVERBBG);
          if (skillTime == 0) {
            qilinx = 0;
          }

          if (qilinx < 30) {
            if (skillTime < 30) {
              qilinx += 3;
            }
          }

          if (skillTime > 78) {
            qilinx -= 5;
          }
          Tools.drawFrame(Tools.IMG_F23, GameData.fighterFrameData[23],
                          GameData.fighterClipData[23],
                          GameMap.setOffX + MyGameCanvas.SCREEN_WIDTH - qilinx - 80,
                          GameMap.setOffY + 120, 4, false, 9999);

//          skillEvent(10, GameMap.setOffX + MyGameCanvas.SCREEN_WIDTH - qilinx + 22
//                     , GameMap.setOffY + 40, 43, isMir,
//                     GameMap.L_HIGH);

          for (int j = 0; j < 43; j += 6) {
            skillEvent(28 + j, f[i].x, f[i].y, 23, isMir,
                       GameMap.L_HIGH);
            skillEvent(34 + j, f[i].x, f[i].y, 50, isMir,
                       GameMap.L_HIGH);
          }
          break;

        case SK_Զս:
          skillFinshTime = 25;

//          if (f[i].model == 2) {
          skillEvent(14, f[i].x, f[i].y - 15, 62, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

//          }

          break;
        case SK_Զս2:
          skillFinshTime = 11;
          skillEvent(7, f[i].x, f[i].y, 28, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(8, f[i].x + 5, f[i].y - 20, 27, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(9, f[i].x + 10, f[i].y - 25, 22, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(10, f[i].x, f[i].y - 25, 22, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);

          break;
        case SK_Զս3:
          skillFinshTime = 18;
          skillEvent(10, f[i].x, f[i].y, 50, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

          break;
        case SK_Զս4:
          skillFinshTime = 17;
          skillEvent(10, f[i].x + 5, f[i].y, 51, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

          break;
        case SK_Զս5:
          skillFinshTime = 18;
          skillEvent(10, f[i].x, f[i].y, 13, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

          break;
        case SK_Զս6:
          skillFinshTime = 18;
          skillEvent(10, f[i].x, f[i].y, 40, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);

          break;

        case SK_׺䶥:
          skillFinshTime = 60;

//          if (skillTime < 42) {
//            drawColorScreenBG(0, GameMap.L_OVERBBG);
//          }
          skillEvent(43, f[i].x, f[i].y - 25, 27, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(49, f[i].x, f[i].y - 25, 27, 0,
                     f[i].y + GameMap.L_ROLESD + 1);

          skillEvent(21, f[i].x, f[i].y - 25, 22, 0,
                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(42, f[i].x - 10, f[i].y, 50, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(48, f[i].x + 10, f[i].y, 50, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(46, f[i].x + 18, f[i].y, 40, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);

          break;

//        case SK_ʬ:
//          skillFinshTime = 10;
//          skillEvent(22, f[i].x - 10, f[i].y - 20, 42, 1,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(24, f[i].x + 5, f[i].y - 5, 42, 1,
//                     f[i].y + GameMap.L_ROLESD + 1);
//
//          break;

        case SK_а:
          skillFinshTime = 55;
          skillEvent(10, f[i].x, f[i].y - 20, 8, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(25, f[i].x, f[i].y - 20, 8, 1,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(40, f[i].x, f[i].y - 20, 8, isMir,
                     f[i].y + GameMap.L_ROLESD + 1);
          break;

        case SK_ս:
          skillFinshTime = 30;

//          skillEvent(13, f[i].x, f[i].y, Effect.EFFECT_FIRE, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(15, f[i].x + 18, f[i].y, Effect.EFFECT_FIRE, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(11, f[i].x + 36, f[i].y, Effect.EFFECT_FIRE, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(11, Battle.S1 + 24, Battle.H2,
//                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);
          skillEvent(15, Battle.S1, Battle.H2,
                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);
          skillEvent(17, Battle.S1 - 24, Battle.H2,
                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);
          skillEvent(15, Battle.S2 + 24, Battle.H1,
                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);
          skillEvent(17, Battle.S2 + 0, Battle.H1,
                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);

          skillEvent(15, Battle.S2 + 24, Battle.H3,
                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);
          skillEvent(17, Battle.S2 + 0, Battle.H3,
                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);

//          skillEvent(19, Battle.S2 - 24, Battle.H3,
//                     Effect.EFFECT_GAS, 0, GameMap.L_BFLASH);

          break;
        case SK_:
          skillFinshTime = 30;
          skillEvent(22, f[i].x - 36, f[i].y, Effect.EFFECT_FIRE, 1,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(24, f[i].x - 18, f[i].y, Effect.EFFECT_FIRE, 1,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(26, f[i].x, f[i].y, Effect.EFFECT_FIRE, 1,
                     f[i].y + GameMap.L_ROLESD + 1);

          break;

        case SK_:
          skillFinshTime = 45;

//          skillEvent(20, f[i].x + 3, f[i].y + 20, 26, 0,
//                     f[i].y + GameMap.L_ROLESD + 1);

          for (int j = 0; j < 18; j += 3) {
//            skillEvent(20 + j, f[i].x + 8, f[i].y - 20, 18, 0,
//                       f[i].y + GameMap.L_ROLESD + 1000);
            skillEvent(20 + j, f[i].x, f[i].y, 26, 0,
                       f[i].y + GameMap.L_ROLESD + 1);
          }

          break;
        case SK_:
          skillFinshTime = 90;
          if (skillTime >= 0 && skillTime <= 7) {
            drawSword(f[i].x, f[i].y - 98 + (skillTime % 2 * 2),
                      f[i].y + GameMap.L_ROLESD + 1, 4);
          }
          skillEvent(6, f[i].x, f[i].y - 80, 16, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          if (skillTime >= 8 && skillTime <= 18) {
            drawSword(f[i].x, f[i].y - 130, f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }
          if (skillTime >= 18 && skillTime <= 20) {
            drawColorScreenBG(0xFFFFFF, GameMap.L_OVERBBG);
          }
          if (skillTime >= 20 && skillTime < 40) {
            drawSword(f[i].x - 20, f[i].y - 150, f[i].y + GameMap.L_ROLESD + 1, true,
                      (byte) 0);
            drawSword(f[i].x - 20 + 23, f[i].y - 150 - 4, f[i].y + GameMap.L_ROLESD + 1, false,
                      (byte) 0);
            drawSword(f[i].x - 20 - 11, f[i].y - 150 + 16, f[i].y + GameMap.L_ROLESD + 1, false,
                      (byte) 0);
            drawSword(f[i].x - 20 + 8, f[i].y - 150 + 30, f[i].y + GameMap.L_ROLESD + 1, false,
                      (byte) 0);
            drawSword(f[i].x - 20 + 40, f[i].y - 150 + 11, f[i].y + GameMap.L_ROLESD + 1, true,
                      (byte) 0);
            drawSword(f[i].x - 20 + 30, f[i].y - 150 + 30, f[i].y + GameMap.L_ROLESD + 1, true,
                      (byte) 0);
          }
          if (skillTime >= 40 && skillTime < 42) {
            drawSword(f[i].x - 20 - 3, f[i].y - 150 - 3,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            drawSword(f[i].x - 20 + 23 + 3, f[i].y - 150 - 4 - 3,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 - 11 - 6, f[i].y - 150 + 16,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 + 8, f[i].y - 150 + 30 + 6,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 + 40 + 6, f[i].y - 150 + 11,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            drawSword(f[i].x - 20 + 30, f[i].y - 150 + 30 + 6,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }
          if (skillTime >= 42 && skillTime < 60) {
            drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            drawSword(f[i].x - 20 + 23 + 6, f[i].y - 150 - 4 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }

          //ʼ
          if (skillTime >= 60) {
            drawColorScreenBG(0, GameMap.L_OVERBBG);
          }
          if (skillTime >= 60 && skillTime < 64) {
            drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            //2
            drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }
          if (skillTime == 60) {
            drawSword(f[i].x - 20 + 23 + 6, f[i].y - 150 - 4 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 1);
          }
          if (skillTime >= 61 && skillTime <= 62) {
            drawSword(f[i].x - 20 + 23 + 6, f[i].y - 150 - 4 - 6 - 20,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 1);
          }
          skillEvent(63, f[i].x - 30, f[i].y, 45, 0, GameMap.L_OVERBBG);

          if (skillTime >= 64 && skillTime < 68) {
            drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            //2
            drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            //4
            drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }
          if (skillTime == 64) {
            drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 1);
          }
          if (skillTime >= 65 && skillTime <= 66) {
            drawSword(f[i].x - 20 + 8 - 3, f[i].y - 150 + 30 + 12 - 20,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 1);
          }
          skillEvent(67, f[i].x, f[i].y - 30, 48, 0, GameMap.L_OVERBBG);

          if (skillTime >= 68 && skillTime < 72) {
            drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            //2
            drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 0);
            //4
            //5
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }
          if (skillTime == 68) {
            drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 1);
          }
          if (skillTime >= 69 && skillTime <= 70) {
            drawSword(f[i].x - 20 + 40 + 12, f[i].y - 150 + 11 - 20,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 1);
          }
          skillEvent(71, f[i].x - 30, f[i].y, 45, 0, GameMap.L_OVERBBG);

          if (skillTime >= 72 && skillTime < 76) {
            drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
            //2
            //3
            //4
            //5
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }
          if (skillTime == 72) {
            drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 1);
          }
          if (skillTime >= 73 && skillTime <= 74) {
            drawSword(f[i].x - 20 - 11 - 12, f[i].y - 150 + 16 - 20,
                      f[i].y + GameMap.L_ROLESD + 1, false, (byte) 1);
          }
          skillEvent(75, f[i].x, f[i].y - 40, 46, 0, GameMap.L_OVERBBG);

          if (skillTime >= 76 && skillTime < 80) {
            //1
            //2
            //3
            //4
            //5
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 0);
          }
          if (skillTime == 76) {
            drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 1);
          }
          if (skillTime >= 77 && skillTime <= 78) {
            drawSword(f[i].x - 20 - 6, f[i].y - 150 - 6 - 20,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 1);
          }
          skillEvent(79, f[i].x - 20, f[i].y - 40, 48, 0, GameMap.L_OVERBBG);

          if (skillTime >= 80 && skillTime < 84) {
            //1
            //2
            //3
            //4
            //5
            //6
          }
          if (skillTime == 80) {
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 1);
          }
          if (skillTime >= 81 && skillTime <= 82) {
            drawSword(f[i].x - 20 + 30 + 3, f[i].y - 150 + 30 + 12 - 20,
                      f[i].y + GameMap.L_ROLESD + 1, true, (byte) 1);
          }
          skillEvent(83, f[i].x - 10, f[i].y - 40, 47, 0, GameMap.L_OVERBBG);
          break;

        case SK_ڤ÷:
          skillFinshTime = 65;
          if (skillTime > 34 && skillTime < 40) {
            h += 50;
          }

          if (skillTime > 46) {
            h = 0;
          }

//          if (skillTime == 41 || skillTime == 43 || skillTime == 45) {
//            Tools.addRect(Tools.TYPE_RECT, f[i].x - 30 + 3, GameMap.setOffY,
//                          60, Math.min(f[i].y + 5, h), true,
//                          Graphics.LEFT | Graphics.TOP, 0x783000, f[i].y + 31);
//          }
//          drawRect(f[i].x + 3 - 30, GameMap.setOffY, Math.min(f[i].y + 5, h),
//                   f[i].y + 30);
          skillEvent(21, GameMap.setOffX + GameMap.screenWidth / 2 + 20,
                     GameMap.setOffY + GameMap.screenHeight / 2 + 35,
                     24, 0, GameMap.L_OVERBBG);
          for (int j = 0; j < 21; j += 3) {
            skillEvent(41 + j, f[i].x + 3, f[i].y + 5, 26, 0,
                       f[i].y - 20);
          }

          break;

        case SK_:
          skillFinshTime = 11;

          skillEvent(1, f[i].x - 15, f[i].y - 10, Effect.EFFECT_GAS, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(4, f[i].x + 5, f[i].y - 5, Effect.EFFECT_GAS, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(6, f[i].x - 3, f[i].y + 2, Effect.EFFECT_GAS, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          break;
        case SK_С:
          skillFinshTime = 10;
          skillEvent(1, f[i].x - 24, f[i].y, Effect.EFFECT_FIRE, 1,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(3, f[i].x, f[i].y, Effect.EFFECT_FIRE, 1,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(5, f[i].x + 24, f[i].y, Effect.EFFECT_FIRE, 1,
                     f[i].y + GameMap.L_ROLESD + 1);
          skillEvent(1, 8);
          break;

        case SK_ڤ:
          skillFinshTime = 80;
          drawColorScreenBG(0, GameMap.L_OVERBBG);
          int tempx = GameMap.setOffX;
          int tempy = GameMap.setOffY;

          skillEvent(21, tempx + GameMap.screenWidth / 2 - 50,
                     tempy + GameMap.screenHeight / 2 + 35,
                     24, 0, GameMap.L_OVERBBG);

//          skillEvent(21, GameMap.setOffX + GameMap.screenWidth / 2 + 20,
//                     GameMap.setOffY + GameMap.screenHeight / 2 - 50,
//                     47, 0, GameMap.L_OVERBBG);

          skillFlash(105, 2, 1);
          skillFlash(109, 2, 1);
          skillFlash(113, 2, 1);
          skillFlash(117, 2, 1);
          skillFlash(121, 2, 1);

          skillEvent(51, tempx + 60, tempy + 160, 25, 0, GameMap.L_HIGH);
          skillEvent(51, tempx + 40, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(51, tempx + 80, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(51, tempx + 60, tempy + 220, 25, 0, GameMap.L_HIGH);

          skillEvent(56, tempx + 60, tempy + 130, 25, 0, GameMap.L_HIGH);
          skillEvent(56, tempx + 60, tempy + 250, 25, 0, GameMap.L_HIGH);
          skillEvent(56, tempx + 20, tempy + 160, 25, 0, GameMap.L_HIGH);
          skillEvent(56, tempx + 0, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(56, tempx + 20, tempy + 220, 25, 0, GameMap.L_HIGH);
          skillEvent(56, tempx + 100, tempy + 160, 25, 0, GameMap.L_HIGH);
          skillEvent(56, tempx + 120, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(56, tempx + 100, tempy + 220, 25, 0, GameMap.L_HIGH);

          skillEvent(61, tempx + 60, tempy + 160, 25, 0, GameMap.L_HIGH);
          skillEvent(61, tempx + 40, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(61, tempx + 80, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(61, tempx + 60, tempy + 220, 25, 0, GameMap.L_HIGH);

          skillEvent(66, tempx + 60, tempy + 130, 25, 0, GameMap.L_HIGH);
          skillEvent(66, tempx + 60, tempy + 250, 25, 0, GameMap.L_HIGH);
          skillEvent(66, tempx + 20, tempy + 160, 25, 0, GameMap.L_HIGH);
          skillEvent(66, tempx + 0, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(66, tempx + 20, tempy + 220, 25, 0, GameMap.L_HIGH);
          skillEvent(66, tempx + 100, tempy + 160, 25, 0, GameMap.L_HIGH);
          skillEvent(66, tempx + 120, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(66, tempx + 100, tempy + 220, 25, 0, GameMap.L_HIGH);

          skillEvent(71, tempx + 60, tempy + 160, 25, 0, GameMap.L_HIGH);
          skillEvent(71, tempx + 40, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(71, tempx + 80, tempy + 190, 25, 0, GameMap.L_HIGH);
          skillEvent(71, tempx + 60, tempy + 220, 25, 0, GameMap.L_HIGH);
          break;

        case SK_:
          skillFinshTime = 45;
          skillEvent(20, f[i].x, f[i].y, 22, 0,
                     f[i].y + GameMap.L_ROLESD);
          break;

        case SK_:
          skillFinshTime = 60;

//          System.out.println("skillTime:" + skillTime);
//          skillEvent(20, f[i].x, f[i].y, 9, isMir,
//                     GameMap.L_LEV + 10);

          skillEvent(23, f[i].x - 30, f[i].y, 45, 0, GameMap.L_OVERBBG);
          skillEvent(27, f[i].x, f[i].y - 30, 48, 0, GameMap.L_OVERBBG);
          skillEvent(31, f[i].x - 30, f[i].y, 45, 0, GameMap.L_OVERBBG);
          skillEvent(35, f[i].x, f[i].y - 40, 46, 0, GameMap.L_OVERBBG);
          skillEvent(39, f[i].x - 20, f[i].y - 40, 48, 0, GameMap.L_OVERBBG);
          skillEvent(43, f[i].x - 10, f[i].y - 40, 47, 0, GameMap.L_OVERBBG);

          break;

        case SK_:
          skillFinshTime = 38;

//          drawColorScreenBG(0, GameMap.L_OVERBBG);
//          skillEvent(16, f[i].x, f[i].y,
//                     19, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//
//          skillEvent(21, f[i].x, f[i].y,
//                     19, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//
//          skillEvent(26, f[i].x, f[i].y,
//                     19, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(31, f[i].x, f[i].y,
//                     19, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//          skillEvent(36, f[i].x, f[i].y,
//                     19, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);

//          skillEvent(63, f[i].x, f[i].y,
//                     46, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//
//          skillEvent(67, f[i].x, f[i].y,
//                     46, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);
//
//          skillEvent(71, f[i].x, f[i].y,
//                     46, isMir,
//                     f[i].y + GameMap.L_ROLESD + 1);

          break;
        case SK_ս:
          skillFinshTime = 80;

//          if(skillTime>0){
//               drawColorScreenBG(0, GameMap.L_OVERBBG);EFFECT_SHANOW
//          }
//
          skillEvent(10, role.x, role.y, Effect.EFFECT_MOVE, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(16, role.x, role.y, Effect.EFFECT_MOVE, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(22, role.x, role.y, Effect.EFFECT_MOVE, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(28, role.x, role.y, Effect.EFFECT_MOVE, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(34, role.x, role.y, Effect.EFFECT_MOVE, 0, f[i].y + GameMap.L_ROLESD);

//
          skillEvent(16, role.x, role.y, 39, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(22, role.x, role.y, 39, 0, f[i].y + GameMap.L_ROLESD);

//
          skillEvent(20, role.x - 25, role.y + 10, 42, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(30, role.x - 15, role.y - 70, 3, 0, f[i].y + GameMap.L_ROLESD);

          skillEvent(20, role.x - 5, role.y + 46, 42, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(30, role.x + 5, role.y + 34, 3, 0, f[i].y + GameMap.L_ROLESD);

          skillEvent(20, role.x + 9, role.y - 22, 42, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(30, role.x + 15, role.y - 92, 3, 0, f[i].y + GameMap.L_ROLESD);

          skillEvent(20, role.x + 29, role.y + 32, 42, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(30, role.x + 39, role.y + 48, 3, 0, f[i].y + GameMap.L_ROLESD);

//µĽ
          skillEvent(40, GameMap.setOffX + 90 - 80, GameMap.setOffY + 165, 43,
                     0, f[i].y + GameMap.L_ROLESD);

//          skillEvent(40, GameMap.setOffX + 90 + 30 - 80, GameMap.setOffY + 165 - 8, 43,
//                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(40, GameMap.setOffX + 90 + 60 - 80, GameMap.setOffY + 165, 43,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(40, GameMap.setOffX + 90 + 30 - 80, GameMap.setOffY + 165 + 42, 43,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(40, GameMap.setOffX + 90 - 80, GameMap.setOffY + 165 + 84, 43,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(40, GameMap.setOffX + 90 + 60 - 80, GameMap.setOffY + 165 + 84, 43,
                     0, f[i].y + GameMap.L_ROLESD);

//׵
          skillEvent(46, GameMap.setOffX + 120 - 35, GameMap.setOffY + 150 + 20, 20,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(47, GameMap.setOffX + 120 + 30 - 35, GameMap.setOffY + 150 + 20 + 20,
                     20,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(48, GameMap.setOffX + 120 - 35, GameMap.setOffY + 150 + 50 + 20, 20,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(49, GameMap.setOffX + 120 - 25 - 35, GameMap.setOffY + 150 + 30 + 20,
                     20,
                     0, f[i].y + GameMap.L_ROLESD);

          skillEvent(50, GameMap.setOffX + 40 - 35, GameMap.setOffY + 190, 20,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(52, GameMap.setOffX + 60 - 35, GameMap.setOffY + 250, 20,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(54, GameMap.setOffX + 100 - 35, GameMap.setOffY + 170, 20,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(56, GameMap.setOffX + 60 - 35, GameMap.setOffY + 95, 20,
                     0, f[i].y + GameMap.L_ROLESD);

          skillEvent(46, GameMap.setOffX + 120 - 35, GameMap.setOffY + 150 + 20, 30,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(47, GameMap.setOffX + 120 + 30 - 35, GameMap.setOffY + 150 + 20 + 20,
                     30, 0, f[i].y + GameMap.L_ROLESD);
          skillEvent(48, GameMap.setOffX + 120 - 35, GameMap.setOffY + 150 + 50 + 20, 30,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(49, GameMap.setOffX + 120 - 25 - 35, GameMap.setOffY + 150 + 30 + 20,
                     30, 0, f[i].y + GameMap.L_ROLESD);

          skillEvent(50, GameMap.setOffX + 40 - 35, GameMap.setOffY + 190, 30,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(52, GameMap.setOffX + 60 - 35, GameMap.setOffY + 250, 30,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(54, GameMap.setOffX + 100 - 35, GameMap.setOffY + 170, 30,
                     0, f[i].y + GameMap.L_ROLESD);
          skillEvent(56, GameMap.setOffX + 60 - 35, GameMap.setOffY + 95, 30,
                     0, f[i].y + GameMap.L_ROLESD);

//          skillEvent(30, f[i].x, f[i].y, 39, 0,
//                     f[i].y + GameMap.L_ROLESD + 10);
//          skillEvent(37, f[i].x, f[i].y, 40, 0,
//                     GameMap.L_ROLESD - 10);

          break;
        case SK_Ѫ:
          skillFinshTime = 40;
          skillEvent(1, f[i].x, f[i].y, Effect.EFFECT_CURE, 0,
                     f[i].y + GameMap.L_ROLESD + 1);
          break;
        case SK_Ԫ:
          skillFinshTime = 30;
          skillEvent(20, f[i].x + 5, f[i].y - 20, 36, 0,
                     f[i].y + GameMap.L_ROLESD + 200);
          skillEvent(24, f[i].x + 5, f[i].y, 37, 0,
                     f[i].y + GameMap.L_ROLESD + 20);

          break;
        case SK_ʥ:
          skillFinshTime = 40;

          skillEvent(10, f[i].x + 5, f[i].y, 60, 0,
                     f[i].y + GameMap.L_ROLESD + 200);

          break;

        case SK_:
          skillFinshTime = 55;
          if (skillTime > 20) {
            f[i].isShowRole = false;
          }
          if (skillTime == 26) {
            shakeTime = 22;
          }
          skillFlash(26, 4, 1);
          for (int j = 0; j < 31; j += 3) {
            skillEvent(20 + j, f[i].x + 8, f[i].y - 20, 18, 0,
                       f[i].y + GameMap.L_ROLESD + 1000);
            skillEvent(20 + j, f[i].x, f[i].y, 17, 0,
                       f[i].y + GameMap.L_ROLESD + 1);
          }

          break;

      }
    }
    if (++skillTime >= skillFinshTime) {
//      System.out.println("isover:" + isOver);
      skillFinshTime = 0;
      skillTime = 0;
      h = 0;
      if (isOver) {
        actionOver();
      }
      isOver = true;
      return;
    }
  }

  void skillFlash(int time, int fTime, int fMode) {

    if (skillTime == time) {
      flashTime = (byte) fTime;
      flashMode = fMode;

    }
  }

  void skillEvent(int time, int x, int y, int type, int isMir, int drawLevel) {
    if (skillTime == time) {
      Effect.AddEffectList(x, y, type, isMir, drawLevel);
    }
  }

  void skillEvent(int time, int st) {
    if (skillTime == time) {
      shakeTime = (byte) st;
    }
  }

  /**-------------------------------------ƮѩЧ--------------------------------------*/
//  short snowData[][] = new short[40][3];
//  public void initSnowsData() {
//    for (int i = 0; i < snowData.length; i++) {
//      snowData[i][0] = (short) (GameMap.setOffX + nextInt(GameMap.screenWidth));
//      snowData[i][1] = (short) (GameMap.setOffY + nextInt(GameMap.screenHeight));
//      snowData[i][2] = (short) (nextInt(2));
//    }
//  }
//
//  byte imgRianData[][] = {
//      {
//      0, 0, 19, 19}
//      , {
//      19, 0, 13, 13}
//      , {
//      19, 13, 5, 5}
//  };
//  public void drawSnows() {
//    for (int i = 0; i < snowData.length; i++) {
//      snowData[i][0] += -6;
//      snowData[i][1] += 12;
//      if (snowData[i][0] <= GameMap.setOffX - 10 ||
//          snowData[i][1] >= GameMap.setOffY + GameMap.screenHeight + 20) {
//        snowData[i][0] = (short) (GameMap.setOffX + nextInt(GameMap.screenWidth));
//        snowData[i][1] = (short) (GameMap.setOffY +
//                                  nextInt(GameMap.screenHeight));
//        snowData[i][2] = (short) (nextInt(2));
//      }
//      Tools.addImage(Tools.IMG_SNOWS, snowData[i][0], snowData[i][1],
//                     imgRianData[snowData[i][2]],
//                     Tools.BOTTOM, Tools.TRANS_NONE, 600);
//    }
//  }

  /**-------------------------------------׶ж--------------------------------------*/

  void actionOver() {
    Battle.wait++;
  }

  /**-------------------------------------ӵ--------------------------------------*/

  private static Vector vEnemys = new Vector();
  public static void addEnemy(int type) {
    vEnemys.addElement(new byte[] { (byte) type});
  }

      /**-------------------------------------ǵ״ֵ̬--------------------------------------*/
  static void fullHp() {
    for (int i = 0; i < role.length; i++) {
      role[i].hp = role[i].hp_max;
      role[i].mp = role[i].mp_max;
    }
  }

  /**-------------------------------------Index--------------------------------------*/
  public static byte getIndex(byte id, byte data[]) {
    for (int i = 0; i < data.length; i++) {
      if (id == data[i]) {
        return (byte) i;
      }
    }
    return -1;
  }

      /**-------------------------------------ͼƬIndex--------------------------------------*/
  public static short getImageIndex(String name) {
    for (int i = 0; i < Tools.FILESNAME.length; i++) {
      if (name.equals(Tools.FILESNAME[i])) {
        return (short) i;
      }
    }
    return -1;
  }

  /**-------------------------------------ʼͼƬ--------------------------------------*/
  public void initImageData(int index) {
    Tools.getBuffDat("/datPackage.dat");
    /*--------------------------ͼ------------------------------*/
    switch (index) {
      case 3:
        GameData.spriteClipData = new byte[GameData.SPRITEMAX][][];
        GameData.spriteFrameData = new byte[GameData.SPRITEMAX][][];
        GameData.spriteMotionData = new byte[GameData.SPRITEMAX][][][];
        break;
      case 4:
        for (int i = 0; i < GameData.SPRITEMAX; i++) {
//          GameData.spriteClipData[i] = readClipData("/sprite/s" + i + "_c.bin");
          GameData.spriteClipData[i] = readClipData("s" + i + "_c");
          Tools.removeDatBuff("s" + i + "_c");
        }
        break;
      case 5:
        for (int i = 0; i < GameData.SPRITEMAX; i++) {
//          GameData.spriteFrameData[i] = readFrameData("/sprite/s" + i + "_f.bin");
          GameData.spriteFrameData[i] = readFrameData("s" + i + "_f");
          Tools.removeDatBuff("s" + i + "_f");
        }
        break;
      case 6:
        for (int i = 0; i < GameData.SPRITEMAX; i++) {
//          GameData.spriteMotionData[i] = readMotionData("/sprite/s" + i +"_m.bin");
          GameData.spriteMotionData[i] = readMotionData("s" + i + "_m");
          Tools.removeDatBuff("s" + i + "_m");
        }
        break;
      case 8:
        GameData.fighterClipData = new byte[FIGHTERMAX][][];
        GameData.fighterFrameData = new byte[FIGHTERMAX][][];
        GameData.fighterMotionData = new byte[FIGHTERMAX][][][];

        break;
      case 9:
        for (int i = 0; i < FIGHTERMAX; i++) {
//          GameData.fighterClipData[i] = readClipData("/fighter/f" + i + "_c.bin");
          GameData.fighterClipData[i] = readClipData("f" + i + "_c");
          Tools.removeDatBuff("f" + i + "_c");
        }
        break;
      case 10:
        for (int i = 0; i < FIGHTERMAX; i++) {
//          GameData.fighterFrameData[i] = readFrameData("/fighter/f" + i + "_f.bin");
          GameData.fighterFrameData[i] = readFrameData("f" + i + "_f");
          Tools.removeDatBuff("f" + i + "_f");
        }
        break;
      case 11:
        for (int i = 0; i < FIGHTERMAX; i++) {
//          GameData.fighterMotionData[i] = readMotionData("/fighter/f" + i + "_m.bin");
          GameData.fighterMotionData[i] = readMotionData("f" + i + "_m");
          Tools.removeDatBuff("f" + i + "_m");
        }
        break;
      case 12:
        Effect.effectClipData = new short[GameData.EFFECTMAX][][];
        Effect.effectFrameData = new short[GameData.EFFECTMAX][][];
        Effect.effectMotionData = new short[GameData.EFFECTMAX][1][][];

        GameData.effectClipData = new byte[GameData.EFFECTMAX][][];
        GameData.effectFrameData = new byte[GameData.EFFECTMAX][][];
        GameData.effectMotionData = new byte[GameData.EFFECTMAX][][][];
        break;
      case 13:
        for (int i = 0; i < GameData.EFFECTMAX; i++) {
//          GameData.effectClipData[i] = readClipData("/effect/e" + i +"_c.bin");
          GameData.effectClipData[i] = readClipData("e" + i + "_c");
          Tools.removeDatBuff("e" + i + "_c");
        }
        break;
      case 14:
        for (int i = 0; i < GameData.EFFECTMAX; i++) {
//          GameData.effectFrameData[i] = readFrameData("/effect/e" + i +"_f.bin");
          GameData.effectFrameData[i] = readFrameData("e" + i + "_f");
          Tools.removeDatBuff("e" + i + "_f");
        }
        break;
      case 15:
        for (int i = 0; i < GameData.EFFECTMAX; i++) {
//          GameData.effectMotionData[i] = readMotionData("/effect/e" + i +"_m.bin");
          GameData.effectMotionData[i] = readMotionData("e" + i + "_m");
          Tools.removeDatBuff("e" + i + "_m");
        }
        break;
      case 16:
        canvas.msg = new MyMessage();
        break;
      case 17:
        canvas.initDB();
        break;
      case 18:
        canvas.readDB(0, false);
        canvas.readDB(1, false);
        break;
      case 19:
        canvas.readSmsDB();
        canvas.initSmsDat();
        break;
    }
  }

  /**-------------------------------------ʼװ--------------------------------------*/
  public void initEquipment() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "equip.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      String[] params;
      equip = new Equipment[len];
      for (int i = 0; i < equip.length; i++) {
        equip[i] = new Equipment();
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        equip[i].name = new String(strBuff, "UTF-8");
//        System.out.println("---" + equip[i].name);
        equip[i].lev = dis.readByte();
        equip[i].type = dis.readByte();

        equip[i].prop1 = dis.readShort();
        equip[i].prop2 = dis.readShort();
        equip[i].prop3 = dis.readByte();

        equip[i].price = dis.readShort();
        equip[i].power = dis.readShort();
      }
      dis.close();
    }
    catch (Exception e) {
      System.out.println("equipment data error!");
    }
  }

  boolean isGodEquip(int type) {
    if (type == 6 || type == 13 || type == 25 || type == 32) {
      return true;
    }
    else {
      return false;
    }
  }

  /**-------------------------------------ʼƷ--------------------------------------*/
  String[] tings = {
      "ָ200㼰20%Ķֵ",
      "ָ1000㼰60%Ķֵ",
      "ָ150㼰20%Ķֵ",
      "ָ800㼰60%Ķֵ",
      "Ⱥָ1000㼰50%Ķֵ",
      "Ⱥָ1000㼰50%Ķֵ",
      "ָ800ֵ600ֵ",
      "ָ60%ֵ50%ֵ",
      "в״̬ȫָ",
      "ɫָ200㼰20%",
      "в״̬",
      "ʹú1Ǳ",
  };

  public void initItem() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "item.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      item = new Item[len];
      for (int i = 0; i < item.length; i++) {
        item[i] = new Item();
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        item[i].name = new String(strBuff, "UTF-8");

        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        item[i].dis = tings[i];

        item[i].range = dis.readByte();
        item[i].limit = dis.readByte();
        item[i].hp1 = dis.readShort();
        item[i].hp2 = dis.readByte();
        item[i].mp1 = dis.readShort();
        item[i].mp2 = dis.readByte();
        item[i].removeBuff = dis.readByte();
        item[i].price = dis.readShort();

      }
      dis.close();
//      System.out.println("item data load success!");
    }
    catch (Exception e) {
      System.out.println("item data error!!!!!!!!!!!!!!!!!!!!!!");
    }
  }

  public void initSoul() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "soul.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      soul = new Soul[len];
      for (int i = 0; i < soul.length; i++) {
        soul[i] = new Soul();
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        soul[i].name = new String(strBuff, "UTF-8");
        soul[i].type = dis.readByte();
        soul[i].value = dis.readByte();
        soul[i].price = dis.readShort();
        soul[i].dis = "";
      }
      dis.close();
//      System.out.println("soul data load success!");
    }
    catch (Exception e) {
      System.out.println("soul data error!!!!!!!!!!!!!!!!!!!!!!");
    }
  }

  public void initTalent() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "talent.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      talent = new Talent[len];
      for (int i = 0; i < talent.length; i++) {
        talent[i] = new Talent();
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        talent[i].name = new String(strBuff, "UTF-8");
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        talent[i].dis = new String(strBuff, "UTF-8");

        talent[i].type = dis.readByte();
        talent[i].skill = dis.readByte();
        talent[i].value = dis.readByte();
        talent[i].max = dis.readByte();
        talent[i].needSkill = dis.readByte();
        talent[i].icon = dis.readByte();
      }
      dis.close();
//      System.out.println("talent data load success!");
    }
    catch (Exception e) {
      System.out.println("talent data error!!!!!!!!!!!!!!!!!!!!!!");
    }
  }

  public void initOther() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "other.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      other = new Other[len];
      for (int i = 0; i < other.length; i++) {
        other[i] = new Other();
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        other[i].name = new String(strBuff, "UTF-8");
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        other[i].dis = new String(strBuff, "UTF-8");
      }
      dis.close();
//      System.out.println("other data load success!");
    }
    catch (Exception e) {
      System.out.println("other data error!!!!!!!!!!!!!!!!!!!!!!");
    }
  }


  public void initGod() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "god.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      God.name = new String[len];
      God.dis = new String[len];
      God.gods = new byte[len];
      God.power = new byte[len];
      for (int i = 0; i < len; i++) {
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        God.name[i] = new String(strBuff, "UTF-8");
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        if (i != 6 && i != 10) {
          God.dis[i] = new String(strBuff, "UTF-8");

        }
        else if (i == 10) {
          God.dis[i] = "սÿغԶָһ";
        }
        else if (i == 6) {
          God.dis[i] = "սʹã˺˻ָȼء";
        }

        System.out.println(" God.dis[i]======" + God.dis[i]);
        God.gods[i] = dis.readByte();
        God.power[i] = dis.readByte();
//        God.power[i] = 0;
//        God.gods[i] = 2; /////////////////////////////////////
      }
      God.bGods = new byte[len];
      for (int i = 0; i < len; i++) {
        God.bGods[i] = God.gods[i];
      }
      dis.close();
//      System.out.println("god data load success!");
    }
    catch (Exception e) {
      System.out.println("god data error!!!!!!!!!!!!!!!!!!!!!!");
    }
  }

      /**-------------------------------------ʼս--------------------------------------*/
  public void initFighterData() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "fighter.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      String[] params;

      GameData.fighterName = new String[len];
      GameData.hps = new int[len];
      GameData.props = new short[len][13];
      GameData.actions = new byte[len][];

      for (int i = 0; i < len; i++) {
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        GameData.fighterName[i] = new String(strBuff, "UTF-8");

        GameData.props[i][0] = dis.readByte(); //AI

        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        String skill = new String(strBuff, "UTF-8");

        if (skill.equals("null")) {
          GameData.actions[i] = null;
        }
        else {
          params = Event.splitString(skill, ",");
          GameData.actions[i] = new byte[params.length];
          for (int j = 0; j < params.length; j++) {
            GameData.actions[i][j] = (byte) (Event.sToi(params[j]));
          }
        }

// AI=0;ģ = 1;ȼ =2; = 3;Ǯ = 4; = 5;ٶ = 6; = 7; = 8;=9;=10;Ѫ=11;=12;

        GameData.props[i][1] = dis.readByte(); //ģ
        GameData.props[i][2] = dis.readByte(); //ȼ
        GameData.hps[i] = dis.readInt(); //Ѫ
        GameData.props[i][3] = dis.readShort(); //
        GameData.props[i][4] = dis.readShort(); //Ǯ
        GameData.props[i][5] = dis.readShort(); //
        GameData.props[i][6] = dis.readByte(); //ٶ
        GameData.props[i][7] = dis.readByte(); //
        GameData.props[i][8] = dis.readByte(); //
        GameData.props[i][9] = dis.readByte(); //
        GameData.props[i][10] = dis.readByte(); //
        GameData.props[i][11] = dis.readByte(); //Ѫ
        GameData.props[i][12] = dis.readByte(); //
      }
      dis.close();
//      System.out.println("fighter data load success!");
    }
    catch (Exception e) {
      e.printStackTrace();
      System.out.println("fighter data error!!!!!!!!!!!!!!!!!");
    }
  }

  /**-------------------------------------ʼ--------------------------------------*/
  public void initSkill() {
    DataInputStream dis = new DataInputStream(getClass().getResourceAsStream(
        "skill.dat"));
    try {
      short len = dis.readShort();
      byte[] strBuff = null;
      String[] params;
      skill = new Skill[len];
      for (int i = 0; i < skill.length; i++) {
        skill[i] = new Skill();

        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        skill[i].name = new String(strBuff, "UTF-8");

        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        skill[i].dis = new String(strBuff, "UTF-8");

        skill[i].formula = dis.readByte();
        skill[i].limit = dis.readByte();
        skill[i].range = dis.readByte();
        skill[i].attMode = dis.readByte();
        skill[i].effectType = dis.readByte();

        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        String buff = new String(strBuff, "UTF-8");

        if (buff.equals("null")) {
          skill[i].buff = null;
        }
        else {
          params = Event.splitString(buff, ",");
          skill[i].buff = new short[params.length];
          for (int j = 0; j < params.length; j++) {
            skill[i].buff[j] = (short) (Event.sToi(params[j]));
          }
        }
        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        String hits = new String(strBuff, "UTF-8");

        if (hits.equals("null")) {
          skill[i].hitIndex = null;
        }
        else {
          params = Event.splitString(hits, ",");
          skill[i].hitIndex = new byte[params.length];
          for (int j = 0; j < params.length; j++) {
            skill[i].hitIndex[j] = (byte) (Event.sToi(params[j]));
          }
        }

        strBuff = new byte[dis.readShort()];
        dis.read(strBuff);
        String perHurts = new String(strBuff, "UTF-8");

        if (perHurts.equals("null")) {
          skill[i].perHurt = null;
        }
        else {
          params = Event.splitString(perHurts, ",");
          skill[i].perHurt = new short[params.length];
          for (int j = 0; j < params.length; j++) {
            skill[i].perHurt[j] = (short) (Event.sToi(params[j]));
          }
        }

        skill[i].incureTime = dis.readByte();
        skill[i].removeBuff = dis.readByte();
//        skill[i].lossHP = dis.readShort();
        skill[i].lossMP = dis.readShort();
        skill[i].skillIcon = dis.readByte();
        skill[i].cd = dis.readByte();
      }
      dis.close();
//      System.out.println("skill data load success!");
    }
    catch (Exception e) {
      System.out.println("skill data error!!!!!!!!!!!!!!!!!!!!");
    }
  }

  byte jn = 1;
      /**-------------------------------------ֽܷ׶ʹü--------------------------------------*/
  public boolean canUseSkill(Fighter r, Skill skill, boolean isBattle) {
    if (skill.limit != Skill.UC_ && r.mp >= skill.lossMP / jn) {
      if (skill.limit == Skill.UC_) {
        return true;
      }
      else {
        return isBattle ? skill.limit == Skill.UC_ս :
            skill.limit == Skill.UC_ս;
      }
    }
    return false;
  }

  /**---------------------------------------------------------------------------*/
  void skillReduce(Fighter r, Skill sk, int tType, int tValue) {
    int perLoss = 100;
    if (tType == Talent.TY_) {
      perLoss = 100 - tValue;
    }
    r.mp -= sk.lossMP * perLoss / 100;
    r.mp = Math.max(0, r.mp);

  }

  /**-------------------------------------ƳBUFF--------------------------------------*/
  void removeBuff(byte type, Fighter f) {
    switch (type) {
      case Skill.B_ж:
        f.actionTime++;

//        if(f.skills!=null){//ռcdʱ
//          for (int i = 0; i < f.skills.length; i++) {
//            f.skills[i][1]=0;
//          }
//        }
        break;
      case Skill.B_ս:
        f.reBorn(false);
        break;
      case Skill.B_ȫ쳣:
        for (int i = 0; i < f.buff.length; i++) { //
          switch (i) {
            case Fighter.B_䶯:
            case Fighter.B_䶯:
              if (f.buff[i][0] > 0 && f.buff[i][1] < 0) {
                f.buff[i][0] = 0;
                f.buff[i][1] = 0;
              }
              break;
            default:
              f.buff[i][0] = 0;
              break;
          }
        }
        break;
      case Skill.B_ȫ:
        f.reBorn(false);
        for (int i = 0; i < f.buff.length; i++) { //
          switch (i) {
            case Fighter.B_䶯:
            case Fighter.B_䶯:
              if (f.buff[i][0] > 0 && f.buff[i][1] < 0) {
                f.buff[i][0] = 0;
                f.buff[i][1] = 0;
              }
              break;
            default:
              f.buff[i][0] = 0;
              break;
          }
        }
        break;
    }
  }

  /**-------------------------------------------------------------*/
  short[][] bombs; //x,y,dir(-1-ֹ0-ң2-),state0-ֹ1-ƶ2-,rank,index,count(׷)
  static boolean showBomb; //ʾ

  public static final int RANK_MOVE = 12; //֡
  public static final int RANK_ATTACK = 31; //
  public static final int BOMB_SPEED = 4; //
  public static final byte FOLLOW_MAX = 10;

  public static final byte BOMB_X = 0;
  public static final byte BOMB_Y = 1;
  public static final byte BOMB_DIR = 2;
  public static final byte BOMB_ST = 3;
  public static final byte BOMB_RANK = 4;
  public static final byte BOMB_INDEX = 5;
  public static final byte BOMB_COUNT = 6;
  public static final byte BOMB_TYPE = 7;

  public static final byte BST_STOP = 0;
  public static final byte BST_MOVE = 1;
  public static final byte BST_FOLLOW = 2;
  public static final byte BST_ATTACK = 3;
  public static final byte BST_DEAD = 4;

  public static final byte DIR_RIGHT = 0;
  public static final byte DIR_LEFT = 1;
  public static final byte DIR_DOWN = 2;
  public static final byte DIR_UP = 3;

  public void initBomb() {
    showBomb = true;
    bombs = null;
//    short temp[][] = readItemData("/bomb/" + (map.mapID < 10 ? "0" : "") +
//                                  map.mapID + ".bin");
    short temp[][] = readItemData( (map.mapID < 10 ? "0" : "") + map.mapID);

    if (temp == null) {
      return;
    }
    bombs = new short[temp.length][8];
    for (int i = 0; i < bombs.length; i++) {
      bombs[i][BOMB_TYPE] = temp[i][0];
      bombs[i][BOMB_X] = (short) (temp[i][1] + 8);
      bombs[i][BOMB_Y] = temp[i][2];
      if (temp[i][4] == -1) {
        bombs[i][BOMB_DIR] = 0;
        bombs[i][BOMB_ST] = BST_STOP;
      }
      else {
        bombs[i][BOMB_DIR] = temp[i][4];
//        switch (bombs[i][BOMB_DIR]) {
//          case 0:
//            bombs[i][BOMB_DIR] = 3;
//            break;
//          case 1:
//            bombs[i][BOMB_DIR] = 0;
//            break;
//
//          case 3:
//            bombs[i][BOMB_DIR] = 1;
//            break;
//        }
        bombs[i][BOMB_ST] = BST_MOVE;
        bombs[i][BOMB_RANK] = (short) nextInt(RANK_MOVE);

        switch (bombs[i][BOMB_DIR]) {
          case 0:
            bombs[i][BOMB_X] += bombs[i][BOMB_RANK] * BOMB_SPEED;
            break;
          case 2:
            bombs[i][BOMB_Y] += bombs[i][BOMB_RANK] * BOMB_SPEED;
            break;
        }
      }
      bombs[i][BOMB_INDEX] = (short) nextInt(2);
    }
  }

  public static short[] getSpeed(int sx, int sy, int ex, int ey, int lot) { //õӵй켣,׷ӵ
    short[] values = new short[2];
    values[0] = (short) ( (ex - sx) / lot);
    values[1] = (short) ( (ey - sy) / lot);
    if (values[0] == 0 && values[1] == 0) { //ֹ־ֹӵ
      values[0] = 1;
      values[1] = 1;
    }
    return values;
  }

  public void moveBomb() {
    if (bombs == null || !showBomb) {
      return;
    }
    if (!Script.isUserCtrl || Event.isChangeMap) {
      return;
    }
    int objX = sprite[spriteIndex].x + 8;
    int objY = sprite[spriteIndex].y - 8;
    for (int i = 0; i < bombs.length; i++) {
      if (bombs[i][BOMB_ST] == BST_DEAD) {
        continue;
      }
      switch (bombs[i][BOMB_ST]) {
        case BST_STOP:
          if (!stopBomb && Math.abs(bombs[i][BOMB_X] - objX) < RANK_ATTACK &&
              Math.abs(bombs[i][BOMB_Y] - objY) < RANK_ATTACK) {
            bombs[i][BOMB_ST] = BST_FOLLOW;
            bombs[i][BOMB_COUNT] = FOLLOW_MAX;
          }
          break;
        case BST_MOVE:
          int mx = bombs[i][BOMB_DIR] == DIR_RIGHT ? 1 :
              (bombs[i][BOMB_DIR] == DIR_LEFT ? (byte) - 1 : 0);
          int my = bombs[i][BOMB_DIR] == DIR_DOWN ? 1 :
              (bombs[i][BOMB_DIR] == DIR_UP ? (byte) - 1 : 0);
          bombs[i][BOMB_X] += BOMB_SPEED * mx;
          bombs[i][BOMB_Y] += BOMB_SPEED * my;
          if (++bombs[i][BOMB_RANK] > RANK_MOVE) {
            bombs[i][BOMB_RANK] = 0;
            bombs[i][BOMB_DIR] ^= 1;
          }
          if (!stopBomb && Math.abs(bombs[i][BOMB_X] - objX) < RANK_ATTACK &&
              Math.abs(bombs[i][BOMB_Y] - objY) < RANK_ATTACK) {
            bombs[i][BOMB_ST] = BST_FOLLOW;
            bombs[i][BOMB_COUNT] = FOLLOW_MAX;
          }
          break;
        case BST_FOLLOW:
          if (Math.abs(bombs[i][BOMB_X] - objX) >= RANK_ATTACK ||
              Math.abs(bombs[i][BOMB_Y] - objY) >= RANK_ATTACK) {
            bombs[i][BOMB_ST] = BST_STOP;
          }
          else {
            short[] speed = getSpeed(bombs[i][BOMB_X], bombs[i][BOMB_Y], objX,
                                     objY, bombs[i][BOMB_COUNT]);
            if (bombs[i][BOMB_COUNT] > 1) {
              bombs[i][BOMB_COUNT]--;
            }
            bombs[i][BOMB_X] += speed[0];
            bombs[i][BOMB_Y] += speed[1];
            if (Math.abs(bombs[i][BOMB_X] - objX) < 5 &&
                Math.abs(bombs[i][BOMB_Y] - objY) < 5) {
              if (MyGameCanvas.gameStatus == MyGameCanvas.ST_PLAY &&
                  sprite[spriteIndex].x == sprite[spriteIndex].ax &&
                  sprite[spriteIndex].y ==
                  sprite[spriteIndex].ay + GameSprite.offY) {
                bombs[i][BOMB_ST] = BST_ATTACK;
                bomb(bombs[i][BOMB_TYPE] == 1);
              }
            }
          }
          break;
        case BST_ATTACK:
          bombs[i][BOMB_ST] = BST_DEAD;
          break;
      }
      if (++bombs[i][BOMB_INDEX] >= 3) {
        bombs[i][BOMB_INDEX] = 0;
      }
    }
  }

  public void drawBomb() {
    if (bombs == null || !showBomb) {
      return;
    }
    for (int i = 0; i < bombs.length; i++) {
      if (bombs[i][BOMB_ST] == BST_DEAD) {
        continue;
      }
      drawShandow(bombs[i][BOMB_X], bombs[i][BOMB_Y], 14, 6, 0, 30);
      short img;
      if (stopBomb) {
        img = Tools.IMG_BOMB2;
      }
      else {
        img = bombs[i][BOMB_TYPE] == 0 ? Tools.IMG_BOMB : Tools.IMG_BOMB1;
      }
      Tools.addImage(img, bombs[i][BOMB_X] - 8, bombs[i][BOMB_Y] - 4,
                     20 * bombs[i][BOMB_INDEX], 0, 20, 41, Tools.BOTTOM,
                     Tools.TRANS_NONE, bombs[i][BOMB_Y] + GameMap.L_ROLESD);
    }
  }

  /**---------------------------------------------------------------------------*/

//  public short[][] readItemData(String name) {
//    InputStream in = getClass().getResourceAsStream(name);
//    if (in == null) {
//      return null;
//    }
//    DataInputStream is = new DataInputStream(in);
//    short[][] dat = null;
//    try {
//      int len = is.readShort();
//      dat = new short[len][];
//      for (int i = 0; i < len; i++) {
//        int gLen = is.readByte();
//        dat[i] = new short[gLen];
//        for (int j = 0; j < gLen; j++) {
//          dat[i][j] = is.readShort();
//        }
//      }
//      is.close();
//    }
//    catch (Exception e) {
//      e.printStackTrace();
//    }
//    return dat;
//  }

  public short[][] readItemData(String name) {
//    InputStream in = getClass().getResourceAsStream(name);
//    if (in == null) {
//      return null;
//    }

    byte[] array = Tools.getDat("/bomb.dat", name);
    if (array == null) {
      System.out.println("bomb file is null!");
      return null;
    }
    ByteArrayInputStream bais = new ByteArrayInputStream(array);
    DataInputStream is = new DataInputStream(bais);
    short[][] dat = null;
    try {
      int len = is.readShort();
      dat = new short[len][];
      for (int i = 0; i < len; i++) {
        int gLen = is.readByte();
        dat[i] = new short[gLen];
        for (int j = 0; j < gLen; j++) {
          dat[i][j] = is.readShort();
        }
      }
      is.close();
      bais.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    return dat;
  }

  public short[][] readItemData2(String name) {
    byte[] buff = Tools.getMapDataEX(name);
    if (buff == null) {
      return null;
    }
    DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
    short[][] dat = null;
    try {
      int len = is.readShort();
      dat = new short[len][];
      for (int i = 0; i < len; i++) {
        int gLen = is.readByte();
        dat[i] = new short[gLen];
        for (int j = 0; j < gLen; j++) {
          dat[i][j] = is.readShort();
        }
      }
      is.close();
    }
    catch (Exception e) {
      e.printStackTrace();
    }
    return dat;
  }

//  public byte[][][] readMotionData(String name) {
//    InputStream in = getClass().getResourceAsStream(name);
//    if (in == null) {
//      return null;
//    }
//    DataInputStream is = new DataInputStream(in);
//    byte[][][] motion = null;
//    int motionLen = 0;
//    try {
//      motionLen = is.readByte();
//      motion = new byte[15][][];
//      for (int i = 0; i < motionLen; i++) {
//        byte st = is.readByte();
//        byte zs = is.readByte();
//        motion[st] = new byte[zs][7];
//        for (int j = 0; j < zs; j++) {
//          for (int m = 0; m < 7; m++) {
//            motion[st][j][m] = is.readByte();
//          }
//        }
//      }
//      is.close();
//    }
//    catch (Exception e) {
//      System.out.println("not find file:" + name);
//      e.printStackTrace();
//    }
//    return motion;
//  }

  public byte[][][] readMotionData(String name) {
    byte[] buff = Tools.getGameDat(name);
    if (buff == null) {
      return null;
    }

    DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));

    byte[][][] motion = null;
    int motionLen = 0;
    try {
      motionLen = is.readByte();
      motion = new byte[15][][];
      for (int i = 0; i < motionLen; i++) {
        byte st = is.readByte();
        byte zs = is.readByte();
        motion[st] = new byte[zs][7];
        for (int j = 0; j < zs; j++) {
          for (int m = 0; m < 7; m++) {
            motion[st][j][m] = is.readByte();
          }
        }
      }
      is.close();
    }
    catch (Exception e) {
      System.out.println("not find file:" + name);
      e.printStackTrace();
    }
    return motion;
  }

//  public byte[][] readClipData(String name) {
//    InputStream in = getClass().getResourceAsStream(name);
//    if (in == null) {
//      return null;
//    }
//    DataInputStream is = new DataInputStream(in);
//    byte[][] clip = null;
//    int clipLen = 0;
//    try {
//      clipLen = is.readShort();
//      clip = new byte[clipLen][4];
//      for (int i = 0; i < clipLen; i++) {
//        clip[i][0] = is.readByte();
//        clip[i][1] = is.readByte();
//        clip[i][2] = is.readByte();
//        clip[i][3] = is.readByte();
//      }
//      is.close();
//    }
//    catch (Exception e) {
//      System.out.println("not find file:" + name);
//      e.printStackTrace();
//    }
//    return clip;
//  }

  public byte[][] readClipData(String name) {
    byte[] buff = Tools.getGameDat(name);
    if (buff == null) {
      return null;
    }
    DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));
    byte[][] clip = null;
    int clipLen = 0;
    try {
      clipLen = is.readShort();
      clip = new byte[clipLen][4];
      for (int i = 0; i < clipLen; i++) {
        clip[i][0] = is.readByte();
        clip[i][1] = is.readByte();
        clip[i][2] = is.readByte();
        clip[i][3] = is.readByte();
      }
      is.close();
    }
    catch (Exception e) {
      System.out.println("not find file:" + name);
      e.printStackTrace();
    }
    return clip;
  }

//  public byte[][] readFrameData(String name) {
//    InputStream in = getClass().getResourceAsStream(name);
//    if (in == null) {
//      return null;
//    }
//    DataInputStream is = new DataInputStream(in);
//    byte[][] frame = null;
//    try {
//      int len = is.readByte();
//      frame = new byte[len][];
//      for (int i = 0; i < len; i++) {
//        int gLen = is.readByte() * 5;
//        frame[i] = new byte[gLen];
//        for (int j = 0; j < gLen; j++) {
//          frame[i][j] = is.readByte();
//        }
//      }
//      is.close();
//    }
//    catch (Exception e) {
//      System.out.println("not find file:" + name);
//      e.printStackTrace();
//    }
//    return frame;
//  }

  public byte[][] readFrameData(String name) {
    byte[] buff = Tools.getGameDat(name);
    if (buff == null) {
      return null;
    }

    DataInputStream is = new DataInputStream(new ByteArrayInputStream(buff));

    byte[][] frame = null;
    try {
      int len = is.readByte();
      frame = new byte[len][];
      for (int i = 0; i < len; i++) {
        int gLen = is.readByte() * 5;
        frame[i] = new byte[gLen];
        for (int j = 0; j < gLen; j++) {
          frame[i][j] = is.readByte();
        }
      }
      is.close();
    }
    catch (Exception e) {
      System.out.println("not find file:" + name);
      e.printStackTrace();
    }
    return frame;
  }

  static void noStop() {
    for (int i = 0; i < sprite.length; i++) {
      sprite[i].isStop = false;
    }
  }

  static int iconIndex;
  static boolean showIcon;
  static int iconID;
  public static void showIcon(int icon) {
    showIcon = true;
    iconIndex = 0;
    iconID = icon;
//    battle.superTime = 24;
  }

  public void hideIcon() {
    showIcon = false;
  }

  public void drawIcon(int x, int y, int lev) {
    if (!showIcon) {
      return;
    }
    short height = 97;
    Tools.addRect(Tools.TYPE_RECT, x, y, MyGameCanvas.SCREEN_WIDTH,
                  height, true, Tools.TOP, 0, lev);
    Tools.addRect(Tools.TYPE_RECT, x - 1, y, MyGameCanvas.SCREEN_WIDTH + 2,
                  height - 1, false, Tools.TOP, 0xffffff, lev);

    int startX, startY;
    int num = 176 / MyGameCanvas.SCREEN_WIDTH + 1 +
        (176 % MyGameCanvas.SCREEN_WIDTH == 0 ? 0 : 1); //ˮƽ

    int len = 2;
    for (int i = 0; i < len; i++) {
      startX = - ( (GameMIDlet.gameIndex * 10 + 58 * i) % 176) +
          GameMap.setOffX;
      startY = 52 * i + y;
      for (int j = 0; j < num; j++) {
        Tools.addImage(Tools.IMG_SUPER, startX + j * 176, startY, Tools.TOP,
                       Tools.TRANS_NONE, lev);
      }
    }

    short[] img = new short[] {
        Tools.IMG_TALK0, -1, -1, -1,
        -1, };

    if (iconIndex < 18) {
      Tools.addImage(img[iconID], x - 120 + 40 * Math.min(3, iconIndex), y + 5,
                     Tools.TOP, Tools.TRANS_NONE, lev);
    }
    else {
      Tools.addImage(img[iconID], x - 120 + 40 * Math.max(4, iconIndex - 14),
                     y + 5, Tools.TOP, Tools.TRANS_NONE, lev);
    }

    if (++iconIndex >= 24) {
      hideIcon();
      finish();
    }
  }

  static byte lightIndex;
  static boolean showLight;
  static short lightX, lightY;
  static boolean beSmall;
  static void showLight(int x, int y, boolean smaller) {
    beSmall = smaller;
    showLight = true;
    lightIndex = (byte) (beSmall ? 10 : 0);
    lightX = (short) x;
    lightY = (short) y;
  }

  void drawLight() {
    if (!showLight) {
      return;
    }
//    int angle=1+10*(lightIndex);
    for (int i = 0; i < 3; i++) {
      Tools.addARC(Tools.TYPE_ARC, lightX - 320, lightY - 320, 640, 640,
                   30 + 120 * i + lightIndex * 75, 30, true, Tools.TOP,
                   0xffffff, GameMap.L_LOOK);
    }
    int r = 1 + 50 * Math.max(0, lightIndex - 3);
//    int r=1 + 50 * Math.min(10, 10-lightIndex);
    Tools.addARC(Tools.TYPE_ARC, lightX - r,
                 lightY - r, r + r, r + r, 0, 360, true, Tools.TOP, 0xffffff,
                 GameMap.L_LOOK);
//    if (lightIndex > 6 && lightIndex < 10 && lightIndex % 2 == 1) {
//      Tools.addRect(Tools.TYPE_RECT, map.setOffX, map.setOffY, map.screenWidth,
//                    map.screenHeight, true, Tools.TOP, 0, GameMap.L_LOOK);
//    }

    if (beSmall) {
      if (--lightIndex <= 0) {
        showLight = false;
        lightIndex = 0;
        finish();
      }
    }
    else {
      if (lightIndex < 10) {
        if (++lightIndex == 10) {
          finish();
          lightIndex = 15;
        }
//        showLight = false;
//        lightIndex = 0;

      }
    }
  }

  static byte holeIndex;
  static boolean showHole;
  static short holeX, holeY;
  static boolean smallHole;
  static void showHole(int x, int y, boolean smaller) {
    smallHole = smaller;
    showHole = true;
    holeIndex = (byte) (smaller ? 15 : 0);
    holeX = (short) x;
    holeY = (short) y;
  }

  void drawHole() {
    if (!showHole) {
      return;
    }
    int r = 1 + 20 * Math.max(0, holeIndex);
    Tools.addARC(Tools.TYPE_ARC, holeX - r * 2,
                 holeY - r, r * 4, r * 2, 0, 360, true, Tools.TOP, 0, 1);
//    Tools.addARC(Tools.TYPE_ARC, holeX - r,
//                 holeY - r, r *2, r*2, 0, 360, true, Tools.TOP, 0,1);
    if (smallHole) {
      if (--holeIndex <= 0) {
        showHole = false;
        holeIndex = 0;
        finish();
      }
    }
    else {
      if (holeIndex < 15) {
        if (++holeIndex == 15) {
          finish();
        }
      }
    }
  }

  //####################################

  final static short COUNT = 150;
  final static short DEPTH = 100;

  static int centerX = MyGameCanvas.SCREEN_WIDTH / 2;
  static int centerY = MyGameCanvas.SCREEN_HEIGHT / 2;

  static short[] x;
  static short[] y;
  static short[] z;

// static int meteorTime;

  public void drawStar(Graphics g) {
    g.setColor(0x000000);
    g.fillRect(0, 0, MyGameCanvas.SCREEN_WIDTH, MyGameCanvas.SCREEN_HEIGHT);
    draw(g);
  }

  static void init() {
//   meteorTime = 0;
    x = new short[COUNT];
    y = new short[COUNT];
    z = new short[COUNT];

    for (int i = 0; i < COUNT; i++) {
      x[i] = (short) ( ( (rnd.nextInt() >>> 1) % MyGameCanvas.SCREEN_WIDTH) -
                      centerX);

      y[i] = (short) ( ( (rnd.nextInt() >>> 1) % MyGameCanvas.SCREEN_HEIGHT) -
                      centerY);

      z[i] = (short) ( (rnd.nextInt() >>> 1) % DEPTH);

      if ( (x[i] == 0) && (y[i] == 0)) {
        x[i] = 10;
      }
    }
  }

  void draw(Graphics g) {
    for (int i = 0; i < COUNT; i++) {
      int h, v, hh, vv;
      int d;
      z[i] -= 4;
      if (z[i] < -31) {
        z[i] = DEPTH;
      }
      hh = (x[i] * 64) / (32 + z[i]);
      vv = (y[i] * 64) / (32 + z[i]);
      h = (int) hh + centerX;
      v = (int) vv + centerY;
      if ( (h < 0) || (h > (2 * centerX))) {
        z[i] = DEPTH;
      }
      if ( (v < 0) || (v > (2 * centerY))) {
        z[i] = DEPTH;
      }
      if (z[i] > 50) {
        g.setColor(0x808080);
      }
      else if (z[i] > 25) {
        g.setColor(0xC0C0C0);
      }
      else {
        g.setColor(0xffffff);
      }

      d = (DEPTH - z[i]) / 50;
      if (d == 0) {
        d = 1;
      }
      g.fillRect(h, v, d, d);
    }
//   if (++meteorTime >= 100) {
//     if (meteorTime >= 117) {
//       g.setColor(meteorTime % 2 == 0 ? 0xffffff : 0);
//     }
//     else {
//       g.setColor(0xffffff);
//     }
//     int r = (meteorTime - 100) * 10;
//     g.fillArc(centerX - r, centerY - r, r * 2, r * 2, 0, 360);
//   }
  }

  /**------------------------------˺ʽһͣ---------------------------*/
//  public static int commonFormula(Fighter role, Fighter enemy, Skill sk,
//                                  int skIndex, boolean isPhurt) {
//
//    int attack = role.getATT_MAX();
//    int defend = role.getDEF_MAX();
//    int perHurt = sk.perHurt[skIndex];
//
//    return 1;
//  }

  public static boolean isAllOpen() {
    for (int i = 0; i < sprite.length; i++) {
      if ( (sprite[i].curStates != GameSprite.ST_DEAD) && sprite[i].modle == 37) {
        return false;
      }
    }
    return true;
  }

  static boolean isOpen = false;
  public static boolean isOpen(int id) {
    if ( (sprite[id].curStates == GameSprite.ST_DEAD) && sprite[id].modle == 37) {
      return true;
    }
    return false;
  }

  static short[] Pillars;

  public static boolean isAllOpen(short[] data) {
    for (int i = 0; i < data.length; i++) {
      if (!isOpen(data[i])) {
        return false;
      }
    }
    return true;
  }

  static Event event;
  static int path;
  static public void sender(Event event1, int pathIndex) {
    finish();
    event = event1;
    path = pathIndex;
  }

  static public void finish() {
    if (event == null) {
      return;
    }
    event.setEnd(path);
    event = null;
  }

  /***************ƻ***************/
  byte[][] FlameArray = {
      {
      0, 103, 18, 28}
      ,
      /**/
      {
      19, 103, 19, 27}
      ,
      /**/
      {
      39, 103, 18, 27}
      ,
      /**/
      {
      62, 110, 13, 20}
      ,
      /*С*/
      {
      76, 110, 14, 20}
      ,
      /*С*/
      {
      91, 110, 13, 20}
  }; /*С*/
  public void drawFlame(int x, int y, int size0_1, int drawLevel) {
    byte indent[] = {
        0, -1, 0, 0, -1, 0};
    byte motion[];
    if (size0_1 == 0) {
      motion = new byte[] {
          0, 0, 1, 1, 2, 2};
    }
    else {
      motion = new byte[] {
          3, 3, 4, 4, 5, 5};
    }
    Tools.addImage(Tools.IMG_S37, x + indent[motion[MyGameCanvas.gameTime % motion.length]],
                   y,
                   FlameArray[motion[MyGameCanvas.gameTime % motion.length]],
                   Tools.BOTTOM, Tools.TRANS_NONE, drawLevel);
  }

  /***************ɺ***************/
  byte[][] birdClip = { //ɺ׵ͼ
      {
      0, 0, 32, 17}
      ,
      /*ͼƬ˵*/
      {
      0, 18, 40, 11}
      ,
      /*ͼƬ˵*/
      {
      0, 30, 38, 17}
  }; /*ͼƬ˵*/
  byte[][] birdIndent = {
      {
      0, 0, 2, 9, 23, 2, -19} /*frame :2*/
      , {
      1, 0, 2, 13, 27, 2, -13} /*frame :2*/
      , {
      2, 0, 2, 13, 25, -3, -14} /*frame :2*/
      , {
      1, 0, 2, 13, 27, 2, -13} /*frame :2*/
  };
  int birds[][];
  void initBirds() {
    birds = new int[2][4];
    for (int i = 0; i < birds.length; i++) {
      birds[i][0] = -nextInt(40, 60);
      birds[i][1] = nextInt(70, 100);
      birds[i][2] = nextInt(3, 4);
      birds[i][3] = -1;
    }
  }

  void drawBird(int x, int y, boolean isMirror, int drawLevel) {
    byte birdMotion[] = new byte[] {
        0, 0, 0, 1, 1, 1, 2, 2, 2, 1, 1, 1};
    byte birdIndex = birdMotion[GameMIDlet.gameIndex % birdMotion.length];

    Tools.addImage(Tools.IMG_BBG2_2, x - birdIndent[birdIndex][isMirror ? 4 : 3],
                   y - birdIndent[birdIndex][5],
                   birdClip[birdIndex],
                   Tools.BOTTOM, Tools.TRANS_NONE, drawLevel);
  }

  void drawFly1(int drawLevel) {
    for (int i = 0; i < birds.length; i++) {
      drawBird(birds[i][0], birds[i][1], false, drawLevel);
      birds[i][0] += birds[i][2];
      birds[i][1] += birds[i][3];
      if (birds[i][0] > 260 || birds[i][1] < -20) {
        birds[i][0] = -nextInt(40, 60);
        birds[i][1] = nextInt(70, 100);
        birds[i][2] = nextInt(3, 4);
        birds[i][3] = -1;
      }
    }
  }

//
  byte[][] swordData = {
      {
      30, 0, 11, 22}
      ,
      /*ͼƬ˵*/
      {
      25, 0, 5, 61}
      ,
      /*ͼƬ˵*/
      {
      10, 0, 15, 61}
      ,
      /*ͼƬ˵*/
      {
      0, 0, 10, 61}
  }; /*ͼƬ˵*/
  public void drawSword(int x, int y, int drawLevel, int state) {
    switch (state) {
      case 0:
        Tools.addImage(Tools.IMG_JIAN, x - 9, y, swordData[3], Tools.TOP,
                       Tools.TRANS_NONE,
                       drawLevel);
        Tools.addImage(Tools.IMG_JIAN, x, y, swordData[3], Tools.TOP,
                       Tools.TRANS_HORIZONTAL,
                       drawLevel);
        break;
      case 1:
        Tools.addImage(Tools.IMG_JIAN, x - 6, y, swordData[2], Tools.TOP,
                       Tools.TRANS_HORIZONTAL,
                       drawLevel);
        break;
      case 2:
        Tools.addImage(Tools.IMG_JIAN, x - 1, y, swordData[1], Tools.TOP,
                       Tools.TRANS_HORIZONTAL,
                       drawLevel);
        break;
      case 3:
        Tools.addImage(Tools.IMG_JIAN, x - 8, y, swordData[2], Tools.TOP,
                       Tools.TRANS_NONE,
                       drawLevel);
        break;
      default:
        Tools.addImage(Tools.IMG_JIAN, x - 5, y, swordData[0], Tools.TOP,
                       Tools.TRANS_NONE, drawLevel);
        break;
    }
  }

  public void drawSword(int x, int y, int drawLevel, boolean isDeasil, byte state) {
    byte motion[] = {
        0, 1, 2, 3};
    switch (state) {
      case 0:
        if (isDeasil) {
          motion = new byte[] {
              0, 1, 2, 3};
        }
        else {
          motion = new byte[] {
              0, 3, 2, 1};
        }
        drawSword(x, y, drawLevel, motion[MyGameCanvas.gameTime % 8 / 2]);
        break;
      case 1:
        drawSword(x, y, drawLevel, 0);
        break;
      default:
        break;
    }
  }

  public void drawStar(int x, int y, int drawLevel) {
    byte[][] clipdata = {
        {
        0, 0, 9, 9}
        , {
        0, 10, 10, 11}
        , {
        0, 22, 11, 11}
    };
    byte[] motion = {
        0, 1, 2};
    switch (MyGameCanvas.gameTime % 6 / 2) {
      case 0:
        Tools.addImage(Tools.IMG_P, x, y, clipdata[motion[0]],
                       Tools.TOP, Tools.TRANS_NONE, drawLevel);
        break;
      case 1:
        Tools.addImage(Tools.IMG_P, x, y, clipdata[motion[1]],
                       Tools.TOP, Tools.TRANS_NONE, drawLevel);
        break;
      case 2:
        Tools.addImage(Tools.IMG_P, x - 1, y, clipdata[motion[2]],
                       Tools.TOP, Tools.TRANS_NONE, drawLevel);
        break;
    }
  }

  static void passInit(boolean isopen) {
    passIndex = 14;
    if (isopen) {
      passIndex = 0;
    }

  }

  static int passIndex = 0;
  public static boolean drawPass(int col, boolean isopen) { //0xFFFFFF  0x55FFFFFF
//    int al[] = {
//        0XFF << 24, 0XDD << 24, 0XBB << 24, 0X99 << 24, 0X77 << 24, 0X55 << 24,
//        0X33 << 24, 0X11 << 24};
    int al[] = {
        0XFF << 24, 0XEE << 24, 0XDD << 24, 0XCC << 24, 0XBB << 24, 0XAA << 24,
        0X99 << 24, 0X88 << 24, 0X77 << 24, 0X66 << 24, 0X55 << 24, 0X44 << 24,
        0X33 << 24, 0X22 << 24, 0X11 << 24};
    Tools.addMASK(GameMap.setOffX, GameMap.setOffY, GameMap.screenWidth,
                  GameMap.screenHeight, col | al[passIndex], 9999);
    if (MyGameCanvas.gameTime % 2 == 0) {
      if (isopen) {
        if (passIndex < 14) {
          passIndex++;
        }
      }
      else {
        if (passIndex > 0) {
          passIndex--;
        }
      }
    }
    return false;
  }

  int runIndex = 0;
  int bglen = 240;
  public void drawSpace(int x, int y, int drawLevel) {
    runIndex += 30;
    if (runIndex >= 240) {
      runIndex = 0;
    }
    Tools.addImage(Tools.IMG_GODSHOW, x + runIndex, y, Tools.TOP, Tools.TRANS_NONE,
                   drawLevel);
    Tools.addImage(Tools.IMG_GODSHOW, x - bglen + runIndex, y, Tools.TOP,
                   Tools.TRANS_NONE, drawLevel);

  }

  public void drawRoleFire(int x, int y, int drawLevel) {
    int[][] array = {
        {
        0, 93, 37, 102 - 20}
        ,
        /*ͼƬ˵*/ {
        38, 93, 32, 104 - 20}
        ,
        /*ͼƬ˵*/ {
        71, 93, 36, 98 - 20}
    }; /*ͼƬ˵*/
    byte addXY[][] = {
        {
        -2, 0}
        , {
        0, 0}
        , {
        -2, 0}
    };
    byte motion[] = {
        0, 0, 1, 1, 2, 2};
    int index = motion[GameMIDlet.gameIndex % motion.length];
    Tools.addImage(Tools.IMG_S40, x + addXY[index][0], y + addXY[index][1], array[index],
                   Tools.TOP, Tools.TRANS_NONE, drawLevel);

  }

}
