/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class Multilines
implements _Config {
    public static String[] content = null;
    public static int step;
    public static int lenMax;
    public static int space;
    public static int moveOffsetY;
    public static int isMoveMode;
    public static byte speed;
    public static int scrollBarX;
    public static Font font;
    public static int BAR_COLOR_BOTTOM;
    public static int BAR_COLOR_FLAG;
    public static int BAR_COLOR_HIGHLIGHT;
    public static int BAR_COLOR_RECT;
    public static boolean drawLine;
    public static int FONT_COLOR_STROKE;
    public static int FONT_COLOR_MAIN;

    static {
        space = 25;
        isMoveMode = 1;
        speed = (byte)2;
        scrollBarX = 0;
        font = Util.font;
        BAR_COLOR_BOTTOM = 0xFFFFFF;
        BAR_COLOR_FLAG = 16773598;
        BAR_COLOR_HIGHLIGHT = 15010443;
        BAR_COLOR_RECT = 15276284;
        drawLine = true;
        FONT_COLOR_STROKE = 16750833;
        FONT_COLOR_MAIN = 0xFFFFFF;
    }

    public static final void setDefault() {
        step = 0;
        moveOffsetY = 0;
    }

    public static final void keyRepeated(int keyCode) {
        if (isMoveMode != 0) {
            return;
        }
        switch (keyCode) {
            case -1: 
            case 50: {
                if (step == 0 && moveOffsetY == 0) {
                    return;
                }
                if (Math.abs(moveOffsetY += speed * 2) < space) break;
                if (--step < 0) {
                    step = content.length - lenMax;
                    break;
                }
                if (step < 1) {
                    moveOffsetY = 0;
                    break;
                }
                moveOffsetY = Math.abs(moveOffsetY) - space;
                break;
            }
            case -2: 
            case 56: {
                if (step + lenMax == content.length && moveOffsetY == 0) {
                    return;
                }
                if (Math.abs(moveOffsetY -= speed * 2) < space) break;
                if (++step + lenMax > content.length) {
                    step = 0;
                    break;
                }
                moveOffsetY = step + lenMax + 1 > content.length ? 0 : space - Math.abs(moveOffsetY);
            }
        }
    }

    public static final void keyPressed(int keyCode) {
        switch (keyCode) {
            case -1: 
            case 50: {
                if (isMoveMode == 0) {
                    return;
                }
                if (content.length <= lenMax) break;
                step = --step < 0 ? content.length - lenMax : step;
                break;
            }
            case -2: 
            case 56: {
                if (isMoveMode == 0) {
                    return;
                }
                if (content.length <= lenMax) break;
                step = ++step + lenMax > content.length ? 0 : step;
                break;
            }
            case -3: 
            case 52: {
                step = 0;
                moveOffsetY = 0;
                break;
            }
            case -4: 
            case 54: {
                step = 0;
                moveOffsetY = 0;
                break;
            }
            case 49: {
                if (speed >= 5) break;
                speed = (byte)(speed + 1);
                break;
            }
            case 51: {
                if (speed <= 1) break;
                speed = (byte)(speed - 1);
                break;
            }
            case 48: {
                isMoveMode = isMoveMode == 0 ? 1 : 0;
                moveOffsetY = 0;
                break;
            }
        }
    }

    public static final void drawMultilines(Graphics g, int x, int y, int hAnc, int vAnc) {
        g.setClip(0, 0, 240, 320);
        int sLen = lenMax;
        if (sLen > content.length) {
            sLen = content.length;
        }
        int[] nArray = new int[3];
        nArray[1] = -space * sLen >> 1;
        nArray[2] = -space * sLen;
        int[] V_ANCHOR = nArray;
        int i = 0;
        if (isMoveMode == 0) {
            g.setClip(0, y + V_ANCHOR[vAnc], 240, space * sLen + 1);
            ++sLen;
            i = -1;
        }
        while (i < sLen) {
            if (i + step >= 0 && i + step < content.length) {
                Util.drawStroke(g, content[i + step], x, y + space * i + V_ANCHOR[vAnc] + moveOffsetY, FONT_COLOR_STROKE, FONT_COLOR_MAIN, hAnc);
                if (drawLine) {
                    int lx = x - font.stringWidth(content[i + step]) * hAnc / 2;
                    int ly = y + font.getHeight() + 1 + space * i + V_ANCHOR[vAnc] + moveOffsetY;
                    int w = font.stringWidth(content[i + step]);
                    Multilines.drawLine(g, lx, ly, lx + w, ly, 0xFFF1EF);
                }
            }
            ++i;
        }
        if (isMoveMode == 0) {
            --sLen;
        }
        if (content.length > sLen) {
            int sBarHight = sLen * space - (space - font.getHeight()) - 2;
            Multilines.drawScrollBar(g, scrollBarX, y + V_ANCHOR[vAnc], sBarHight, sLen, content.length, step);
        }
    }

    public static final void drawLine(Graphics g, int sx, int sy, int ex, int ey, int color) {
        g.setColor(color);
        g.drawLine(sx, sy, ex, ey);
    }

    public static final void setBarColor(int bottom, int flag, int highlight, int rect) {
        BAR_COLOR_BOTTOM = bottom;
        BAR_COLOR_FLAG = flag;
        BAR_COLOR_HIGHLIGHT = highlight;
        BAR_COLOR_RECT = rect;
    }

    public static final void drawScrollBar(Graphics g, int sBarX, int sBarY, int sBarHight, int len, int linesLength, int step) {
        g.setColor(BAR_COLOR_BOTTOM);
        g.fillRect(sBarX, sBarY + 2, 4, sBarHight);
        int offset_y = -moveOffsetY * sBarHight / linesLength / space;
        int start_y = sBarY + 2 + step * sBarHight / linesLength + offset_y;
        int end_y = sBarHight - (linesLength - len) * sBarHight / linesLength;
        g.setColor(BAR_COLOR_FLAG);
        g.fillRect(sBarX + 1, start_y, 3, end_y);
        g.setColor(BAR_COLOR_HIGHLIGHT);
        g.fillRect(sBarX + 2, start_y, 1, end_y);
        g.setColor(BAR_COLOR_RECT);
        g.drawRect(sBarX, sBarY + 2 - 1, 4, sBarHight + 1);
    }
}

