/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public final class CAnimation {
    private boolean m_isGli;
    private short[] m_modules;
    public byte[] m_frameData;
    private byte[] m_frameSpritesCount;
    private short[] m_frameSpritesOffset;
    private byte[] m_sprites;
    public byte[] m_numFrame;
    public byte[][] m_actionData;
    public byte[] mechModelID;
    public short[] mechModel;
    public CGLI m_gli;
    public static int[] AnimationFlags;
    public static long[] s_AnimationInUsedFlag;
    public int Flags;

    public final void Load$175c9085(DataInputStream is) throws Exception {
        int num;
        this.Flags = CGame.readInt(is);
        CGame.readUnsignedShort(is);
        int count = CGame.readUnsignedShort(is);
        this.m_modules = new short[count << 1];
        this.m_isGli = true;
        int modulePar = this.m_isGli ? 2 : 4;
        int i2 = 0;
        while (i2 < count) {
            int j2 = 0;
            while (j2 < modulePar) {
                this.m_modules[i2 * modulePar + j2] = CGame.readShort(is);
                ++j2;
            }
            ++i2;
        }
        count = CGame.readUnsignedShort(is);
        this.m_frameData = new byte[count * 12];
        this.m_frameSpritesCount = new byte[count];
        this.m_frameSpritesOffset = new short[count];
        short sprites_offset = 0;
        int size = CGame.readUnsignedShort(is);
        this.m_sprites = new byte[size << 2];
        int i3 = 0;
        while (i3 < count) {
            byte bytes = CGame.readUnsignedByte(is);
            num = CGame.readUnsignedByte(is);
            this.m_frameSpritesCount[i3] = (byte)num;
            this.m_frameSpritesOffset[i3] = sprites_offset;
            int offset = sprites_offset << 2;
            sprites_offset = (short)(sprites_offset + num);
            num <<= 2;
            while (--num >= 0) {
                this.m_sprites[offset++] = CGame.readByte(is);
            }
            if ((bytes & 0x80) != 0) {
                this.m_frameData[i3 * 12] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 1] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 2] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 3] = CGame.readByte(is);
            }
            if ((bytes & 0x40) != 0) {
                this.m_frameData[i3 * 12 + 4] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 5] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 6] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 7] = CGame.readByte(is);
            }
            if ((bytes & 0x20) != 0) {
                this.m_frameData[i3 * 12 + 8] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 9] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 10] = CGame.readByte(is);
                this.m_frameData[i3 * 12 + 11] = CGame.readByte(is);
            }
            ++i3;
        }
        count = CGame.readUnsignedShort(is);
        this.m_numFrame = new byte[count];
        this.m_actionData = new byte[count][];
        this.mechModelID = new byte[count];
        i3 = 0;
        while (i3 < count) {
            num = CGame.readUnsignedByte(is);
            this.m_numFrame[i3] = (byte)num;
            this.m_actionData[i3] = new byte[num << 1];
            try {
                CGame.read(is, this.m_actionData[i3], 0, num << 1);
                this.mechModelID[i3] = CGame.readUnsignedByte(is);
            }
            catch (Exception exception) {}
            ++i3;
        }
        count = CGame.readUnsignedByte(is);
        this.mechModel = new short[++count << 2];
        i3 = 0;
        while (i3 < count) {
            this.mechModel[i3 << 2] = CGame.readShort(is);
            this.mechModel[(i3 << 2) + 1] = CGame.readShort(is);
            this.mechModel[(i3 << 2) + 2] = CGame.readShort(is);
            this.mechModel[(i3 << 2) + 3] = CGame.readShort(is);
            ++i3;
        }
    }

    public final void DrawFrame(int palette, int frameIndex, int screenX, int screenY, boolean flipX, boolean flipY) {
        byte[] s2 = this.m_sprites;
        int start = this.m_frameSpritesOffset[frameIndex] << 2;
        int end = start + (this.m_frameSpritesCount[frameIndex] << 2);
        int i2 = start;
        while (i2 < end) {
            int posY;
            int posX;
            short modH;
            short modW;
            short modY;
            short modX;
            int modID;
            int flag = (s2[i2 + 1] & 0xFF) >> 6;
            if (this.m_isGli) {
                modID = (s2[i2] & 0xFF) + ((s2[i2 + 1] & 0x3F) << 8) << 1;
                modX = 0;
                modY = 0;
                modW = this.m_modules[modID];
                modH = this.m_modules[modID + 1];
            } else {
                modID = (s2[i2] & 0xFF) << 2;
                modX = this.m_modules[modID];
                modY = this.m_modules[modID + 1];
                modW = this.m_modules[modID + 2];
                modH = this.m_modules[modID + 3];
            }
            if (flipX) {
                posX = screenX - s2[i2 + 2];
                flag ^= 2;
            } else {
                posX = screenX + s2[i2 + 2];
            }
            if (flipY) {
                posY = screenY - s2[i2 + 3];
                flag ^= 1;
            } else {
                posY = screenY + s2[i2 + 3];
            }
            if ((flag & 2) != 0) {
                posX -= modW;
            }
            if ((flag & 1) != 0) {
                posY -= modH;
            }
            int x0 = posX;
            int y0 = posY;
            int x1 = posX + modW;
            int y1 = posY + modH;
            if (x1 > 240) {
                x1 = 240;
            }
            if (y1 > 320) {
                y1 = 320;
            }
            if (x1 > 0 && y1 > 0 && x1 - x0 > 0 && y1 - y0 > 0) {
                CGame.s_g.setClip(x0, y0, x1 - x0, y1 - y0);
                if (this.m_gli != null) {
                    this.m_gli.SetPalette(palette);
                    if (this.m_isGli) {
                        this.m_gli.Draw$75a39d14(CGame.s_g, modID >> 1, posX, posY, flag);
                    } else {
                        this.m_gli.Draw$75a39d14(CGame.s_g, modID >> 2, posX, posY, flag);
                    }
                } else {
                    try {
                        CGame.drawRegion(null, modX, modY, modW, modH, flag, posX, posY, 20);
                    }
                    catch (Exception exception) {
                        Exception ex = exception;
                        exception.printStackTrace();
                    }
                }
                CGame.s_g.setClip(0, 0, 240, 320);
            }
            i2 += 4;
        }
    }
}

