/*
 * Decompiled with CFR 0.152.
 */
package YXFY;

import YXFY.ConfigView;
import YXFY.DangAnScreen;
import YXFY.Declare;
import YXFY.LoadView;
import YXFY.MainMID;
import YXFY.MainView;
import YXFY.Screens;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Util {
    public static final void scrollBar(Graphics gh, int x, int y, int scrollWidth, int scrollHeight, int contentHeight, int contentMoveLength, int colorScrollBar, int colorScrollBlock) {
        gh.setClip(x, y, scrollWidth, scrollHeight);
        gh.setColor(colorScrollBar);
        gh.fillRoundRect(x, y, scrollWidth, scrollHeight, 5, 5);
        int scrollBlockY = 0;
        int scrollBlockH = 0;
        scrollBlockH = scrollHeight * scrollHeight / contentHeight;
        scrollBlockY = scrollHeight * contentMoveLength / contentHeight;
        if (scrollBlockY + scrollBlockH > scrollHeight) {
            scrollBlockY = scrollHeight - scrollBlockH;
        }
        gh.setColor(colorScrollBlock);
        gh.fillRoundRect(x, y + scrollBlockY, scrollWidth, scrollBlockH, 5, 5);
    }

    public static final void scrollBarWithImage(Graphics gh, int x, int y, int topHeight, int bottomHeight, int currMoveNum, int allMoveNum, Image bar, Image block) {
        int bar_w = bar.getWidth();
        int bar_h = bar.getHeight();
        int block_w = block.getWidth();
        int block_h = block.getHeight();
        gh.setClip(x, y, bar_w, bar_h);
        gh.drawImage(bar, x, y, 0x10 | 4);
        int scrollBlockY = 0;
        int scrollHeight = bar_h - topHeight - bottomHeight;
        scrollBlockY = currMoveNum * (scrollHeight / allMoveNum) + topHeight;
        if (scrollBlockY > bar_h - bottomHeight - block_h) {
            scrollBlockY = bar_h - bottomHeight - block_h;
        }
        gh.setClip(0, 0, Declare.screen_Width, Declare.screen_Height);
        gh.drawImage(block, x + (bar_w - block_w) / 2, y + scrollBlockY, 0x10 | 4);
    }

    public static final int[] imgFadeInOut(int[] sourRGB, int alpha) {
        int[] sour = new int[sourRGB.length];
        System.arraycopy(sourRGB, 0, sour, 0, sour.length);
        for (int i = 0; i < sour.length; ++i) {
            int oldAlpha = (sourRGB[i] & 0xFF000000) >>> 24;
            if (alpha >= oldAlpha) continue;
            sour[i] = alpha << 24 | sour[i] & 0xFFFFFF;
        }
        return sour;
    }

    public static final int[] getImgRGBWithNotAlpha(Image simg) {
        int[] r = null;
        int imgW = simg.getWidth();
        int imgH = simg.getHeight();
        r = new int[imgW * imgH];
        simg.getRGB(r, 0, imgW, 0, 0, imgW, imgH);
        int i = 0;
        while (i < r.length) {
            int n = i++;
            r[n] = r[n] & 0xFFFFFF;
        }
        return r;
    }

    public static final int[] getImgRGB(Image simg) {
        int[] r = null;
        int imgW = simg.getWidth();
        int imgH = simg.getHeight();
        r = new int[imgW * imgH];
        simg.getRGB(r, 0, imgW, 0, 0, imgW, imgH);
        return r;
    }

    public static final int[] getRoundXY(int[] roundCenter, int radius, int angle) {
        int[] r = new int[2];
        int[][] cos_sin = new int[][]{{-984, 173}, {-940, 342}, {-866, 500}, {-766, 643}, {-643, 766}, {-500, 866}, {-342, 940}, {-173, 984}, {0, 1000}, {173, 984}, {342, 940}, {500, 866}, {643, 766}, {766, 643}, {866, 500}, {940, 342}, {984, 173}, {1000, 0}, {984, -173}, {940, -342}, {866, -500}, {766, -643}, {643, -766}, {500, -866}, {342, -940}, {173, -984}, {0, -1000}, {-173, -984}, {-342, -940}, {-500, -866}, {-643, -766}, {-766, -643}, {-866, -500}, {-940, -342}, {-984, -173}, {-1000, 0}};
        int id = angle / 10 - 1;
        if (id >= 0 && id < cos_sin.length) {
            r[0] = roundCenter[0] + (radius * cos_sin[id][1] + 500) / 1000;
            r[1] = roundCenter[1] + (radius * cos_sin[id][0] + 500) / 1000;
        }
        return r;
    }

    public static final boolean HitCircleAndRect(int centralX, int centralY, int radius, int rectX, int rectY, int rectW, int rectH) {
        if (radius < 0 || rectW < 0 || rectH < 0) {
            return false;
        }
        int innerBoundaryX = rectW / 2;
        int innerBoundaryY = rectH / 2;
        int outerBoundaryX = innerBoundaryX + radius;
        int outerBoundaryY = innerBoundaryY + radius;
        int distanceX = Util.abs(rectX + innerBoundaryX - centralX);
        int distanceY = Util.abs(rectY + innerBoundaryY - centralY);
        if (distanceX <= innerBoundaryX) {
            return distanceY <= outerBoundaryY;
        }
        if (distanceX <= outerBoundaryX) {
            if (distanceY <= innerBoundaryY) {
                return true;
            }
            if (distanceY <= outerBoundaryY) {
                int tempDisX = distanceX - innerBoundaryX;
                int tempDisY = distanceY - innerBoundaryY;
                return tempDisX * tempDisX + tempDisY * tempDisY <= radius * radius;
            }
            return false;
        }
        return false;
    }

    private static int abs(int v) {
        if (v < 0) {
            return -v;
        }
        return v;
    }

    public static final boolean HitRectAndRect(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        return Util.abs(x1 + w1 / 2 - (x2 + w2 / 2)) < Util.abs((w1 + w2) / 2) && Util.abs(y1 + h1 / 2 - (y2 + h2 / 2)) < Util.abs((h1 + h2) / 2);
    }

    public static final boolean HitCircleAndCircle(int x1, int y1, int r1, int x2, int y2, int r2) {
        return (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) < (r2 + r1) * (r2 + r1);
    }

    public static final boolean isArcRectCollides(int arcX, int arcY, int arcR, int rectX, int rectY, int rectW, int rectH) {
        int arcOx = arcX + arcR;
        int arcOy = arcY + arcR;
        if ((rectX - arcOx) * (rectX - arcOx) + (rectY - arcOy) * (rectY - arcOy) <= arcR * arcR) {
            return true;
        }
        if ((rectX + rectW - arcOx) * (rectX + rectW - arcOx) + (rectY - arcOy) * (rectY - arcOy) <= arcR * arcR) {
            return true;
        }
        if ((rectX - arcOx) * (rectX - arcOx) + (rectY + rectH - arcOy) * (rectY + rectH - arcOy) <= arcR * arcR) {
            return true;
        }
        if ((rectX + rectW - arcOx) * (rectX + rectW - arcOx) + (rectY + rectH - arcOy) * (rectY + rectH - arcOy) <= arcR * arcR) {
            return true;
        }
        int minDisX = 0;
        if (arcOy >= rectY && arcOy <= rectY + rectH) {
            if (arcOx < rectX) {
                minDisX = rectX - arcOx;
            } else if (arcOx > rectX + rectW) {
                minDisX = arcOx - rectX - rectW;
            } else {
                return true;
            }
            if (minDisX <= arcR) {
                return true;
            }
        }
        int minDisY = 0;
        if (arcOx >= rectX && arcOx <= rectX + rectW) {
            if (arcOy < rectY) {
                minDisY = rectY - arcOy;
            } else if (arcOy > rectY + rectH) {
                minDisY = arcOy - rectY - rectH;
            } else {
                return true;
            }
            if (minDisY <= arcR) {
                return true;
            }
        }
        return false;
    }

    public static Image transImage(Image src, int w, int h) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        int dstW = w;
        int dstH = h;
        Image tmp = Image.createImage((int)dstW, (int)srcH);
        Graphics g = tmp.getGraphics();
        int scale = 16;
        int delta = (srcW << scale) / dstW;
        int pos = delta / 2;
        for (int x = 0; x < dstW; ++x) {
            g.setClip(x, 0, 1, srcH);
            g.drawImage(src, x - (pos >> scale), 0, 20);
            pos += delta;
        }
        Image dst = Image.createImage((int)dstW, (int)dstH);
        g = dst.getGraphics();
        delta = (srcH << scale) / dstH;
        pos = delta / 2;
        for (int y = 0; y < dstH; ++y) {
            g.setClip(0, y, dstW, 1);
            g.drawImage(tmp, 0, y - (pos >> scale), 20);
            pos += delta;
        }
        return dst;
    }

    public static int[] parseGate(String gate) {
        int[] r = null;
        if (gate.indexOf("#") > -1) {
            String[] ts2;
            String s1 = gate.substring(0, gate.indexOf("#"));
            String s2 = gate.substring(gate.indexOf("#") + 1);
            if (s1 != null && s2 != null && (ts2 = Util.split(s2, ":")) != null) {
                r = new int[4 + 5 * ts2.length];
                String[] ts1 = Util.split(s1, ",");
                if (ts1 != null && ts1.length == 4) {
                    r[0] = Integer.parseInt(ts1[0]);
                    r[1] = Integer.parseInt(ts1[1]);
                    r[2] = Integer.parseInt(ts1[2]);
                    r[3] = Integer.parseInt(ts1[3]);
                    for (int i = 0; i < ts2.length; ++i) {
                        String[] tts2 = Util.split(ts2[i], ",");
                        if (tts2 == null || tts2.length != 5) continue;
                        r[4 + i * 5] = Integer.parseInt(tts2[0]);
                        r[4 + i * 5 + 1] = Integer.parseInt(tts2[1]);
                        r[4 + i * 5 + 2] = Integer.parseInt(tts2[2]);
                        r[4 + i * 5 + 3] = Integer.parseInt(tts2[3]);
                        r[4 + i * 5 + 4] = Integer.parseInt(tts2[4]);
                    }
                }
            }
        }
        return r;
    }

    public static String[] split(String sour, String fg) {
        Vector<String> ts = new Vector<String>();
        String s1 = sour;
        while (s1.indexOf(fg) > -1) {
            String tts = s1.substring(0, s1.indexOf(fg));
            ts.addElement(tts);
            s1 = s1.substring(s1.indexOf(fg) + 1);
        }
        ts.addElement(s1);
        String[] r = null;
        if (ts.size() > 0) {
            r = new String[ts.size()];
            for (int i = 0; i < ts.size(); ++i) {
                r[i] = (String)ts.elementAt(i);
            }
        }
        ts.removeAllElements();
        ts = null;
        return r;
    }

    public static int[] rotate_Plumb(Image _img) {
        int x = _img.getWidth();
        int y = _img.getHeight();
        int[] r = new int[x * y];
        _img.getRGB(r, 0, x, 0, 0, x, y);
        for (int i = 0; i < y / 2; ++i) {
            for (int j = 0; j < x; ++j) {
                int t = r[i * x + j];
                r[i * x + j] = r[(y - i - 1) * x + j];
                r[(y - i - 1) * x + j] = t;
            }
        }
        return r;
    }

    public static int[] rotate_Plumb(int[] rgb, int w, int h) {
        int x = w;
        int y = h;
        int[] r = new int[w * h];
        System.arraycopy(rgb, 0, r, 0, rgb.length);
        for (int i = 0; i < y / 2; ++i) {
            for (int j = 0; j < x; ++j) {
                int t = r[i * x + j];
                r[i * x + j] = r[(y - i - 1) * x + j];
                r[(y - i - 1) * x + j] = t;
            }
        }
        return r;
    }

    public static int[] rotate_Level(Image _img) {
        int x = _img.getWidth();
        int y = _img.getHeight();
        int[] r = new int[x * y];
        _img.getRGB(r, 0, x, 0, 0, x, y);
        for (int i = 0; i < x / 2; ++i) {
            for (int j = 0; j < y; ++j) {
                int t = r[j * x + i];
                r[j * x + i] = r[j * x + (x - i - 1)];
                r[j * x + (x - i - 1)] = t;
            }
        }
        return r;
    }

    public static int[] rotate_Level(int[] rgb, int w, int h) {
        int x = w;
        int y = h;
        int[] r = new int[w * h];
        System.arraycopy(rgb, 0, r, 0, rgb.length);
        for (int i = 0; i < x / 2; ++i) {
            for (int j = 0; j < y; ++j) {
                int t = r[j * x + i];
                r[j * x + i] = r[j * x + (x - i - 1)];
                r[j * x + (x - i - 1)] = t;
            }
        }
        return r;
    }

    public static void rotate_Level(Graphics g, Image img, int x, int y) {
        if (img == null) {
            return;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        for (int i = 0; i < w; ++i) {
            g.setClip(x + i, y, 1, h);
            g.drawImage(img, x - w + 2 * i, y, 20);
        }
    }

    public static void rotate_Plumb(Graphics g, Image img, int x, int y) {
        if (img == null) {
            return;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        for (int i = 0; i < h; ++i) {
            g.setClip(x, y + i, w, 1);
            g.drawImage(img, x, y - h + 2 * i, 20);
        }
    }

    public static void newGame(Graphics gh, MainView mainView) {
        String[] fn = new String[]{"wz_p1.png", "wz_p11.png", "wz_p2.png", "wz_p21.png", "wz_p3.png", "wz_p31.png", "wz_p4.png", "wz_p41.png", "wz_p5.png", "wz_p51.png", "pz_d.png", "bs.png", "pz_k_4.png", "sj_1.png", "u_l1.png", "sz1.png", "sz2.png", "pz_wz.png", "wz_p6.png", "b1.png", "bt_2.png", "gd_1.png", "gd_2.png", "b2.png", "m_1.png", "an_1.png", "mj_cl.png", "mj_cr.png", "mj_cm.png", "wz_p7.png", "g0_s.png", "g1_s.png", "g2_s.png", "g3_s.png", "g4_s.png", "g5_s.png", "g6_s.png", "g7_s.png", "g8_s.png", "g9_s.png", "gai.png", "wz_p12.png", "b3.png", "bjt.png", "sj_2.png", "sj_3.png", "an_3.png", "g0_s_h.png", "g1_s_h.png", "g2_s_h.png", "g3_s_h.png", "g4_s_h.png", "g5_s_h.png", "g6_s_h.png", "g7_s_h.png", "g8_s_h.png", "g9_s_h.png", "pz_k_41.png", "fd0.png"};
        ConfigView cv = new ConfigView();
        LoadView lv = new LoadView(fn, "ConfigView", null, 0, false);
        Screens.switchScreen(MainView.currScreen, lv, gh, mainView, true);
    }

    public static void skipMenuScreen(Graphics gh, MainView mainView) {
        String[] fn = new String[]{"w_31.png", "w_3.png", "gd_2.png", "gd_1.png", "w_5.png", "bt_1.png", "w_41.png", "w_4.png", "b1.png", "w_1.png", "fm.png", "w_2.png", "ws_1.png", "ws_2.png", "ws_3.png", "ws_4.png", "ws_5.png", "an_1.png", "an_2.png", "sy_1.png", "sy_2.png", "w_7.png", "ws_7.png", "wz11_1.png", "ms.png", "ms_1.png", "ms_11.png", "ms_2.png", "ms_21.png", "an_3.png", "tg.png"};
        LoadView lv = new LoadView(fn, "MenuView", null, 0, false);
        Screens.switchScreen(MainView.currScreen, lv, gh, mainView, true);
    }

    public static void skipPlayScreen(Graphics gh, MainView mainView, int currMJ, int[][] guai) {
        int i;
        Vector<String> zy = new Vector<String>();
        int curr_mujian = currMJ;
        int curr_bj = Integer.parseInt(MainMID.DB.readParm("gk_curr")[0]) / 5 + 1;
        int[] curr_guai = new int[guai.length];
        for (int i2 = 0; i2 < curr_guai.length; ++i2) {
            curr_guai[i2] = guai[i2][0];
        }
        int currGate = Integer.parseInt(MainMID.DB.readParm("gk_curr")[0]);
        System.out.println("\u5f53\u524d\u5173\u5361\uff1a" + currGate);
        int[] gate = null;
        gate = Declare.gateMode ? Util.parseGate(Declare.guanka[currGate / 5][currGate % 5]) : Util.parseGate("7,0,80,80#30,20,20,80,20:31,30,30,150,200:33,20,20,140,20:34,10,20,140,40:36,20,30,180,20:39,10,20,150,60");
        int[] curr_die = new int[(gate.length - 4) / 5];
        for (int i3 = 0; i3 < curr_die.length; ++i3) {
            curr_die[i3] = gate[i3 * 5 + 4];
        }
        int lv = 0;
        int[] exps = null;
        if (currMJ == 1) {
            exps = Declare.mujian_athena_exp;
        } else if (currMJ == 2) {
            exps = Declare.mujian_dionysvs_exp;
        } else if (currMJ == 3) {
            exps = Declare.mujian_zeus_exp;
        }
        if (exps != null) {
            int i4 = 0;
            while (i4 < exps.length && Integer.parseInt(MainMID.DB.readParm("exp")[0]) > exps[i4]) {
                lv = i4++;
            }
        }
        int ld = 0;
        if (currMJ == 1) {
            ld = Declare.mujian_athena_radar[lv];
        } else if (currMJ == 2) {
            ld = Declare.mujian_dionysvs_radar[lv];
        } else if (currMJ == 3) {
            ld = Declare.mujian_zeus_radar[lv];
        }
        int curr_leida = ld;
        zy.addElement("hg.png");
        zy.addElement("ca_1.png");
        zy.addElement("ca_2.png");
        zy.addElement("ysd_1.png");
        zy.addElement("ysd_2.png");
        zy.addElement("ysx_1.png");
        zy.addElement("ysx_2.png");
        zy.addElement("ysx_3.png");
        zy.addElement("ysx_4.png");
        zy.addElement("t.png");
        zy.addElement("d.png");
        zy.addElement("lv_1.png");
        zy.addElement("hp_l.png");
        zy.addElement("d_j.png");
        zy.addElement("d_x.png");
        zy.addElement("nl_1.png");
        zy.addElement("nl_2.png");
        zy.addElement("nl_3.png");
        zy.addElement("an_1.png");
        zy.addElement("an_3.png");
        zy.addElement("gai.png");
        zy.addElement("w_6.png");
        zy.addElement("dhk.png");
        zy.addElement("rentou.png");
        zy.addElement("bos.png");
        zy.addElement("bboss0.png");
        zy.addElement("bboss1.png");
        zy.addElement("bboss2.png");
        zy.addElement("bboss3.png");
        zy.addElement("bboss4.png");
        zy.addElement("bboss5.png");
        zy.addElement("bboss6.png");
        zy.addElement("bboss7.png");
        zy.addElement("shengli.png");
        zy.addElement("shibai.png");
        zy.addElement("queren.png");
        zy.addElement("fd0.png");
        zy.addElement("bzz1.png");
        zy.addElement("bzz2.png");
        zy.addElement("bzz3.png");
        zy.addElement("bzz4.png");
        zy.addElement("bzz5.png");
        zy.addElement("bzz6.png");
        zy.addElement("jieshu.png");
        zy.addElement("sj_3.png");
        zy.addElement("bg4.png");
        if (curr_mujian == 1) {
            zy.addElement("r1.png");
            zy.addElement("r2.png");
            zy.addElement("r3.png");
            zy.addElement("rg1.png");
            zy.addElement("rg2.png");
            zy.addElement("rg3.png");
            zy.addElement("zjishan.png");
        } else if (curr_mujian == 2) {
            zy.addElement("l1.png");
            zy.addElement("l2.png");
            zy.addElement("l3.png");
            zy.addElement("lg1.png");
            zy.addElement("lg2.png");
            zy.addElement("lg3.png");
            zy.addElement("zji_lan.png");
        } else if (curr_mujian == 3) {
            zy.addElement("m1.png");
            zy.addElement("m2.png");
            zy.addElement("m3.png");
            zy.addElement("mg1.png");
            zy.addElement("mg2.png");
            zy.addElement("mg3.png");
            zy.addElement("mmuji.png");
        }
        for (i = 0; i < curr_guai.length; ++i) {
            if (curr_guai[i] < 0) continue;
            if (curr_guai[i] / 2 == 0) {
                zy.addElement("g0_s.png");
                zy.addElement("g0_g_1.png");
                zy.addElement("g0_g_2.png");
                zy.addElement("g0_g_3.png");
                zy.addElement("g0_m_1.png");
                zy.addElement("g0_m_2.png");
                zy.addElement("g0_m_3.png");
                zy.addElement("g0_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 3) {
                zy.addElement("g1_s.png");
                zy.addElement("g1_g_1.png");
                zy.addElement("g1_g_2.png");
                zy.addElement("g1_g_3.png");
                zy.addElement("g1_m_1.png");
                zy.addElement("g1_m_2.png");
                zy.addElement("g1_m_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 5) {
                zy.addElement("g2_s.png");
                zy.addElement("g2_m_g_1.png");
                zy.addElement("g2_m_g_2.png");
                zy.addElement("g2_m_g_3.png");
                zy.addElement("g2_m_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 6) {
                zy.addElement("g3_s.png");
                zy.addElement("g3_g_1.png");
                zy.addElement("g3_g_2.png");
                zy.addElement("g3_g_3.png");
                zy.addElement("g3_g_4.png");
                zy.addElement("g3_g_5.png");
                zy.addElement("g3_g_6.png");
                zy.addElement("g3_g_7.png");
                zy.addElement("g3_m_1.png");
                zy.addElement("g3_m_2.png");
                continue;
            }
            if (curr_guai[i] / 2 == 4) {
                zy.addElement("g4_s.png");
                zy.addElement("g4_g_1.png");
                zy.addElement("g4_g_2.png");
                zy.addElement("g4_g_3.png");
                zy.addElement("g4_g_4.png");
                zy.addElement("g4_g_5.png");
                zy.addElement("g4_m_1.png");
                zy.addElement("g4_m_2.png");
                zy.addElement("g4_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 7) {
                zy.addElement("g5_s.png");
                zy.addElement("g5_g_1.png");
                zy.addElement("g5_g_2.png");
                zy.addElement("g5_g_3.png");
                zy.addElement("g5_m_1.png");
                zy.addElement("g5_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 2) {
                zy.addElement("g6_s.png");
                zy.addElement("g6_g_1.png");
                zy.addElement("g6_g_2.png");
                zy.addElement("g6_g_3.png");
                zy.addElement("g6_g_4.png");
                zy.addElement("g6_m_1.png");
                zy.addElement("g6_m_2.png");
                zy.addElement("g6_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 8) {
                zy.addElement("g7_s.png");
                zy.addElement("g7_m_1.png");
                zy.addElement("g7_m_2.png");
                zy.addElement("g7_m_3.png");
                zy.addElement("g7_m_g_1.png");
                zy.addElement("g7_m_g_2.png");
                zy.addElement("g7_m_g_3.png");
                zy.addElement("g7_m_g_1_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 1) {
                zy.addElement("g8_s.png");
                zy.addElement("g8_g_1.png");
                zy.addElement("g8_g_2.png");
                zy.addElement("g8_g_3.png");
                zy.addElement("g8_m_1.png");
                zy.addElement("g8_m_2.png");
                zy.addElement("g8_m_3.png");
                zy.addElement("g8_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 != 9) continue;
            zy.addElement("g9_s.png");
            zy.addElement("g9_m_1.png");
            zy.addElement("g9_m_2.png");
            zy.addElement("g9_m_g_1.png");
            zy.addElement("g9_m_g_2.png");
            zy.addElement("g9_m_g_3.png");
            zy.addElement("g9_m_g_a.png");
        }
        for (i = 0; i < curr_die.length; ++i) {
            if ((curr_die[i] - 30) / 3 == 0) {
                zy.addElement("fd1_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd1.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd1_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd1_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 1) {
                zy.addElement("fd0_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd0_1.png");
                    zy.addElement("fd0_2.png");
                    zy.addElement("fd0_3.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd0_1_b.png");
                    zy.addElement("fd0_2_b.png");
                    zy.addElement("fd0_3_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd0_1_c.png");
                zy.addElement("fd0_2_c.png");
                zy.addElement("fd0_3_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 2) {
                zy.addElement("fd4_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd4.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd4_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd4_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 3) {
                zy.addElement("fd5_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd5.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd5_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd5_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 4) {
                zy.addElement("fd3_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd3.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd3_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd3_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 != 5) continue;
            zy.addElement("fd2_a.png");
            if ((curr_die[i] - 30) % 3 == 0) {
                zy.addElement("fd2.png");
                continue;
            }
            if ((curr_die[i] - 30) % 3 == 1) {
                zy.addElement("fd2_b.png");
                continue;
            }
            if ((curr_die[i] - 30) % 3 != 2) continue;
            zy.addElement("fd2_c.png");
        }
        zy.addElement("sz1.png");
        zy.addElement("sz2.png");
        if (curr_leida == 150) {
            zy.addElement("ld_150.png");
        } else if (curr_leida == 160) {
            zy.addElement("ld_160.png");
        } else if (curr_leida == 170) {
            zy.addElement("ld_170.png");
        } else if (curr_leida == 180) {
            zy.addElement("ld_180.png");
        } else if (curr_leida == 190) {
            zy.addElement("ld_190.png");
        } else if (curr_leida == 200) {
            zy.addElement("ld_200.png");
        }
        zy.addElement("sj_0.png");
        zy.addElement("sj_30.png");
        zy.addElement("sj_60.png");
        zy.addElement("sj_90.png");
        zy.addElement("sj_120.png");
        zy.addElement("sj_150.png");
        zy.addElement("sj_180.png");
        zy.addElement("sj_210.png");
        zy.addElement("sj_240.png");
        zy.addElement("sj_270.png");
        zy.addElement("sj_300.png");
        zy.addElement("sj_330.png");
        zy.addElement("b3.png");
        zy.addElement("zd_sl.png");
        zy.addElement("zd_sb.png");
        zy.addElement("yy.png");
        zy.addElement("yy_c.png");
        zy.addElement("yy_o.png");
        zy.addElement("w_2.png");
        zy.addElement("sj_1.png");
        zy.addElement("jb.png");
        zy.addElement("jy.png");
        String[] pn = new String[zy.size()];
        for (int i5 = 0; i5 < zy.size(); ++i5) {
            pn[i5] = (String)zy.elementAt(i5);
        }
        LoadView lvc = new LoadView(pn, "PlayGame", new Object[]{new Integer(currMJ), guai}, curr_mujian, false);
        Screens.switchScreen(MainView.currScreen, lvc, gh, mainView, true);
    }

    public static void jiaoXueConfig(Graphics gh, MainView mainView) {
        String[] fn = new String[]{"b1.png", "bt_2.png", "an_3.png", "wz_p4.png", "mj_cr.png", "mj_cl.png", "mj_cm.png", "pz_k_4.png", "wz_p6.png", "wz_p7.png", "b2.png", "sz1.png", "sz2.png", "g0_s.png", "g8_s.png", "g6_s_h.png", "g1_s_h.png", "g4_s_h.png", "b4.png", "sj_1.png", "an_1.png", "pz_k_41.png"};
        LoadView lv = new LoadView(fn, "JiaoXueView", null, 0, false);
        Screens.switchScreen(MainView.currScreen, lv, gh, mainView, true);
    }

    public static void jiaoXuePlay(Graphics gh, MainView mainView, int currMJ, int[][] guai) {
        int i;
        Vector<String> zy = new Vector<String>();
        int curr_mujian = currMJ;
        int curr_bj = Integer.parseInt(MainMID.DB.readParm("gk_curr")[0]) / 5 + 1;
        int[] curr_guai = new int[guai.length];
        for (int i2 = 0; i2 < curr_guai.length; ++i2) {
            curr_guai[i2] = guai[i2][0];
        }
        int currGate = Integer.parseInt(MainMID.DB.readParm("gk_curr")[0]);
        System.out.println("\u5f53\u524d\u5173\u5361\uff1a" + currGate);
        int[] gate = null;
        gate = Declare.gateMode ? Util.parseGate(Declare.guanka[currGate / 5][currGate % 5]) : Util.parseGate("7,0,80,80#30,20,20,80,20:31,30,30,150,200:33,20,20,140,20:34,10,20,140,40:36,20,30,180,20:39,10,20,150,60");
        int[] curr_die = new int[1];
        for (int i3 = 0; i3 < curr_die.length; ++i3) {
            curr_die[i3] = gate[i3 * 5 + 4];
        }
        int lv = 0;
        int[] exps = null;
        if (currMJ == 1) {
            exps = Declare.mujian_athena_exp;
        } else if (currMJ == 2) {
            exps = Declare.mujian_dionysvs_exp;
        } else if (currMJ == 3) {
            exps = Declare.mujian_zeus_exp;
        }
        if (exps != null) {
            int i4 = 0;
            while (i4 < exps.length && Integer.parseInt(MainMID.DB.readParm("exp")[0]) > exps[i4]) {
                lv = i4++;
            }
        }
        int ld = 0;
        if (currMJ == 1) {
            ld = Declare.mujian_athena_radar[lv];
        } else if (currMJ == 2) {
            ld = Declare.mujian_dionysvs_radar[lv];
        } else if (currMJ == 3) {
            ld = Declare.mujian_zeus_radar[lv];
        }
        int curr_leida = ld;
        zy.addElement("t.png");
        zy.addElement("d.png");
        zy.addElement("lv_1.png");
        zy.addElement("hp_l.png");
        zy.addElement("d_j.png");
        zy.addElement("d_x.png");
        zy.addElement("nl_1.png");
        zy.addElement("nl_2.png");
        zy.addElement("nl_3.png");
        zy.addElement("bzz1.png");
        zy.addElement("bzz2.png");
        zy.addElement("bzz3.png");
        zy.addElement("bzz4.png");
        zy.addElement("bzz5.png");
        zy.addElement("bzz6.png");
        zy.addElement("an_3.png");
        zy.addElement("bg4.png");
        if (curr_mujian == 1) {
            zy.addElement("r1.png");
            zy.addElement("r2.png");
            zy.addElement("r3.png");
            zy.addElement("rg1.png");
            zy.addElement("rg2.png");
            zy.addElement("rg3.png");
            zy.addElement("zjishan.png");
        } else if (curr_mujian == 2) {
            zy.addElement("l1.png");
            zy.addElement("l2.png");
            zy.addElement("l3.png");
            zy.addElement("lg1.png");
            zy.addElement("lg2.png");
            zy.addElement("lg3.png");
            zy.addElement("zji_lan.png");
        } else if (curr_mujian == 3) {
            zy.addElement("m1.png");
            zy.addElement("m2.png");
            zy.addElement("m3.png");
            zy.addElement("mg1.png");
            zy.addElement("mg2.png");
            zy.addElement("mg3.png");
            zy.addElement("mmuji.png");
        }
        for (i = 0; i < curr_guai.length; ++i) {
            if (curr_guai[i] < 0) continue;
            if (curr_guai[i] / 2 == 0) {
                zy.addElement("g0_s.png");
                zy.addElement("g0_g_1.png");
                zy.addElement("g0_g_2.png");
                zy.addElement("g0_g_3.png");
                zy.addElement("g0_m_1.png");
                zy.addElement("g0_m_2.png");
                zy.addElement("g0_m_3.png");
                zy.addElement("g0_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 3) {
                zy.addElement("g1_s.png");
                zy.addElement("g1_g_1.png");
                zy.addElement("g1_g_2.png");
                zy.addElement("g1_g_3.png");
                zy.addElement("g1_m_1.png");
                zy.addElement("g1_m_2.png");
                zy.addElement("g1_m_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 5) {
                zy.addElement("g2_s.png");
                zy.addElement("g2_m_g_1.png");
                zy.addElement("g2_m_g_2.png");
                zy.addElement("g2_m_g_3.png");
                zy.addElement("g2_m_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 6) {
                zy.addElement("g3_s.png");
                zy.addElement("g3_g_1.png");
                zy.addElement("g3_g_2.png");
                zy.addElement("g3_g_3.png");
                zy.addElement("g3_g_4.png");
                zy.addElement("g3_g_5.png");
                zy.addElement("g3_g_6.png");
                zy.addElement("g3_g_7.png");
                zy.addElement("g3_m_1.png");
                zy.addElement("g3_m_2.png");
                continue;
            }
            if (curr_guai[i] / 2 == 4) {
                zy.addElement("g4_s.png");
                zy.addElement("g4_g_1.png");
                zy.addElement("g4_g_2.png");
                zy.addElement("g4_g_3.png");
                zy.addElement("g4_g_4.png");
                zy.addElement("g4_g_5.png");
                zy.addElement("g4_m_1.png");
                zy.addElement("g4_m_2.png");
                zy.addElement("g4_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 7) {
                zy.addElement("g5_s.png");
                zy.addElement("g5_g_1.png");
                zy.addElement("g5_g_2.png");
                zy.addElement("g5_g_3.png");
                zy.addElement("g5_m_1.png");
                zy.addElement("g5_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 2) {
                zy.addElement("g6_s.png");
                zy.addElement("g6_g_1.png");
                zy.addElement("g6_g_2.png");
                zy.addElement("g6_g_3.png");
                zy.addElement("g6_g_4.png");
                zy.addElement("g6_m_1.png");
                zy.addElement("g6_m_2.png");
                zy.addElement("g6_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 8) {
                zy.addElement("g7_s.png");
                zy.addElement("g7_m_1.png");
                zy.addElement("g7_m_2.png");
                zy.addElement("g7_m_3.png");
                zy.addElement("g7_m_g_1.png");
                zy.addElement("g7_m_g_2.png");
                zy.addElement("g7_m_g_3.png");
                zy.addElement("g7_m_g_1_a.png");
                continue;
            }
            if (curr_guai[i] / 2 == 1) {
                zy.addElement("g8_s.png");
                zy.addElement("g8_g_1.png");
                zy.addElement("g8_g_2.png");
                zy.addElement("g8_g_3.png");
                zy.addElement("g8_m_1.png");
                zy.addElement("g8_m_2.png");
                zy.addElement("g8_m_3.png");
                zy.addElement("g8_g_a.png");
                continue;
            }
            if (curr_guai[i] / 2 != 9) continue;
            zy.addElement("g9_s.png");
            zy.addElement("g9_m_1.png");
            zy.addElement("g9_m_2.png");
            zy.addElement("g9_m_g_1.png");
            zy.addElement("g9_m_g_2.png");
            zy.addElement("g9_m_g_3.png");
            zy.addElement("g9_m_g_a.png");
        }
        for (i = 0; i < curr_die.length; ++i) {
            if ((curr_die[i] - 30) / 3 == 0) {
                zy.addElement("fd1_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd1.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd1_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd1_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 1) {
                zy.addElement("fd0_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd0_1.png");
                    zy.addElement("fd0_2.png");
                    zy.addElement("fd0_3.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd0_1_b.png");
                    zy.addElement("fd0_2_b.png");
                    zy.addElement("fd0_3_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd0_1_c.png");
                zy.addElement("fd0_2_c.png");
                zy.addElement("fd0_3_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 2) {
                zy.addElement("fd4_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd4.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd4_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd4_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 3) {
                zy.addElement("fd5_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd5.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd5_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd5_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 == 4) {
                zy.addElement("fd3_a.png");
                if ((curr_die[i] - 30) % 3 == 0) {
                    zy.addElement("fd3.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 == 1) {
                    zy.addElement("fd3_b.png");
                    continue;
                }
                if ((curr_die[i] - 30) % 3 != 2) continue;
                zy.addElement("fd3_c.png");
                continue;
            }
            if ((curr_die[i] - 30) / 3 != 5) continue;
            zy.addElement("fd2_a.png");
            if ((curr_die[i] - 30) % 3 == 0) {
                zy.addElement("fd2.png");
                continue;
            }
            if ((curr_die[i] - 30) % 3 == 1) {
                zy.addElement("fd2_b.png");
                continue;
            }
            if ((curr_die[i] - 30) % 3 != 2) continue;
            zy.addElement("fd2_c.png");
        }
        zy.addElement("sz1.png");
        zy.addElement("sz2.png");
        if (curr_leida == 150) {
            zy.addElement("ld_150.png");
            System.out.println("\u96f7\u8fbe");
        } else if (curr_leida == 160) {
            zy.addElement("ld_160.png");
        } else if (curr_leida == 170) {
            zy.addElement("ld_170.png");
        } else if (curr_leida == 180) {
            zy.addElement("ld_180.png");
        } else if (curr_leida == 190) {
            zy.addElement("ld_190.png");
        } else if (curr_leida == 200) {
            zy.addElement("ld_200.png");
        }
        zy.addElement("sj_0.png");
        zy.addElement("sj_30.png");
        zy.addElement("sj_60.png");
        zy.addElement("sj_90.png");
        zy.addElement("sj_120.png");
        zy.addElement("sj_150.png");
        zy.addElement("sj_180.png");
        zy.addElement("sj_210.png");
        zy.addElement("sj_240.png");
        zy.addElement("sj_270.png");
        zy.addElement("sj_300.png");
        zy.addElement("sj_330.png");
        zy.addElement("b4.png");
        zy.addElement("sj_1.png");
        zy.addElement("jb.png");
        zy.addElement("jy.png");
        String[] pn = new String[zy.size()];
        for (int i5 = 0; i5 < zy.size(); ++i5) {
            pn[i5] = (String)zy.elementAt(i5);
        }
        LoadView lvv = new LoadView(pn, "JiaoXuePlay", new Object[]{new Integer(currMJ), guai}, currMJ, false);
        Screens.switchScreen(MainView.currScreen, lvv, gh, mainView, true);
    }

    public static void skipDangAn(Graphics gh, MainView mainView) {
        String[] fn = new String[]{"bt_3.png", "b1.png", "wz_p8.png", "wz_p9.png", "wz_p10.png", "an_1.png", "k2.png", "gd_1.png", "gd_2.png", "da_kd1.png", "da_kd2.png", "da_kd3.png", "pz_k_5.png", "r1.png", "r2.png", "r3.png", "l1.png", "l2.png", "l3.png", "m1.png", "m2.png", "m3.png", "g0_g_1.png", "g0_g_2.png", "g0_g_3.png", "g1_g_1.png", "g1_g_2.png", "g1_g_3.png", "g2_m_g_1.png", "g2_m_g_2.png", "g2_m_g_3.png", "g3_g_1.png", "g3_g_2.png", "g3_g_3.png", "g3_g_4.png", "g3_g_5.png", "g3_g_6.png", "g3_g_7.png", "g4_g_1.png", "g4_g_2.png", "g4_g_3.png", "g4_g_4.png", "g4_g_5.png", "g5_g_1.png", "g5_g_2.png", "g5_g_3.png", "g6_g_1.png", "g6_g_2.png", "g6_g_3.png", "g6_g_4.png", "g7_m_g_1.png", "g7_m_g_2.png", "g7_m_g_3.png", "g8_g_1.png", "g8_g_2.png", "g8_g_3.png", "g9_m_g_1.png", "g9_m_g_2.png", "g9_m_g_3.png", "fd1.png", "fd1_b.png", "fd1_c.png", "fd0_1.png", "fd0_1_b.png", "fd0_1_c.png", "fd0_2_b.png", "fd0_2_c.png", "fd0_2.png", "fd0_3.png", "fd0_3_b.png", "fd0_3_c.png", "fd4.png", "fd4_b.png", "fd4_c.png", "fd5.png", "fd5_b.png", "fd5_c.png", "fd3.png", "fd3_b.png", "fd3_c.png", "fd2.png", "fd2_b.png", "fd2_c.png", "bt_1.png", "mj_cr.png", "mj_cl.png", "mj_cm.png"};
        DangAnScreen da = new DangAnScreen();
        LoadView lv = new LoadView(fn, "DangAnScreen", null, 0, false);
        Screens.switchScreen(MainView.currScreen, lv, gh, mainView, true);
    }
}

