/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class EnemyTeam
extends Team {
    public static final int MAX_ENEMY = 5;
    public static final int[] POS = new int[]{0, 0, 5, 5, 10, 10, 15, 15, 20, 20};
    public static EnemyTeam[] enemyteam = new EnemyTeam[0];
    public static final int POS_X = 20;
    public static final int POS_Y = 20;
    private static byte[] m_data = null;
    public static short[][] TeamData = new short[0][0];
    public static final int TD_ID = 0;
    public static final int TD_COUNT = 1;
    public static final int TD_MATEID = 2;

    public EnemyTeam() {
        this.mates = new Monster[5];
        for (int i = 0; i < this.mates.length; ++i) {
            this.mates[i] = new Monster();
        }
    }

    public EnemyTeam(int etid) {
        String file = "/EnemyTeam.bin";
        DataInputStream dis = new DataInputStream(file.getClass().getResourceAsStream(file));
        try {
            int i;
            dis.skip(Tool.ETIndex[etid]);
            this.id = dis.readShort();
            this.teamcount = dis.readShort();
            this.mateid = new short[this.teamcount];
            for (i = 0; i < this.teamcount; ++i) {
                this.mateid[i] = dis.readShort();
            }
            this.mates = new Monster[5];
            for (i = 0; i < this.mates.length; ++i) {
                this.mates[i] = new Monster();
            }
            dis.close();
            dis = null;
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void copy(Team team) {
        super.copy(team);
        for (int i = 0; i < this.teamcount; ++i) {
            this.mates[i] = (Monster)team.mates[i].clone();
            this.mates[i].posx = (short)20;
            this.mates[i].posy = (short)(20 + 30 * i);
        }
    }

    public void addMate(Monster role) {
        this.mates[this.teamcount] = role;
        ++this.teamcount;
    }

    public void delMate(Monster role) {
        for (int i = 0; i < this.teamcount; ++i) {
            if (role != this.mates[i]) continue;
            this.delMate(i);
            return;
        }
    }

    public void delMate(int index) {
        for (int i = index; i < this.teamcount - 1; ++i) {
            this.mates[i] = this.mates[i + 1];
        }
        --this.teamcount;
    }

    private void alterMate(Monster oldRole, Monster role) {
        for (int i = 0; i < this.teamcount; ++i) {
            if (oldRole != this.mates[i]) continue;
            this.mates[i] = role;
            return;
        }
    }

    public void unload() {
    }

    public Object clone() {
        EnemyTeam team = new EnemyTeam();
        team.copy(this);
        return team;
    }

    public void refreshMate() {
        int i;
        int count = -1;
        for (i = 0; i < this.teamcount; ++i) {
            if (this.mates[i].isLive) continue;
            count = i;
            break;
        }
        if (count != -1) {
            for (i = count; i < this.teamcount - 1; ++i) {
                this.mates[i] = this.mates[i + 1];
            }
            --this.teamcount;
        }
    }
}

