/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GMap {
    public GCanvas gameCanvas;
    private Graphics g;
    String[] texts;
    public boolean updateTile = true;
    long loadAnimationMask = 0L;
    long loadAnimationMaskExtra = 0L;
    int idTileImage;
    int mapWidth;
    int mapHeight;
    int tileWidth;
    int tileHeight;
    byte[] phyBuffer;
    int camLimitX;
    int camLimitW;
    int mapLimitW;
    int mapLimitH;
    int camLimitH;
    int camX;
    int camY;
    int idTileImage2;
    private short[][] mapBuffer;
    byte[][] bindata = new byte[100][];
    DataInputStream dis;
    public static final int tileBit = 4;
    private int[] tileCountPerLine = new int[2];
    Image[] tileImage;
    int bgImageWidth;
    int bgImageHeight;
    public Image bgImage;
    private Graphics s_g_bgImage;
    boolean ifUpdateBg;
    boolean forceCam;
    int prevX0;
    int prevY0;
    int prevX1;
    int prevY1;
    int destCamX;
    int destCamY;
    int camSpeed = 8;
    boolean isScrolling;
    boolean focusCam;
    public static Actor centerPlayer = null;

    public GMap(GCanvas gameCanvas, String[] texts) {
        this.gameCanvas = gameCanvas;
        this.g = gameCanvas.g;
        this.texts = texts;
    }

    public void load(String fileName, int level) throws Exception {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(fileName);
        sb.append(level);
        String file = sb.toString();
        this.dis = new DataInputStream(file.getClass().getResourceAsStream(file));
        this.loadAnimationMask = this.dis.readLong();
        this.loadAnimationMaskExtra = this.dis.readLong();
        this.idTileImage = this.dis.readUnsignedByte();
        this.idTileImage2 = this.dis.readUnsignedByte();
        this.mapWidth = this.dis.readUnsignedShort();
        this.mapHeight = this.dis.readUnsignedShort();
        this.tileWidth = this.dis.readUnsignedByte();
        this.tileHeight = this.dis.readUnsignedByte();
        this.mapBuffer = new short[2][this.mapWidth * this.mapHeight];
        for (i = 0; i < this.mapBuffer[0].length; ++i) {
            this.mapBuffer[0][i] = this.dis.readShort();
        }
        for (i = 0; i < this.mapBuffer[1].length; ++i) {
            this.mapBuffer[1][i] = this.dis.readShort();
        }
        this.phyBuffer = new byte[this.mapWidth * this.mapHeight];
        for (i = 0; i < this.phyBuffer.length; ++i) {
            this.phyBuffer[i] = this.dis.readByte();
        }
        this.camLimitX = 0;
        this.mapLimitW = this.camLimitW = this.mapWidth * this.tileWidth;
        this.camLimitH = 0;
        this.mapLimitH = this.mapHeight * this.tileHeight;
        this.camLimitH = this.mapLimitH - 320 - 1;
        this.camLimitH = Math.max(0, this.camLimitH);
        this.dis.close();
        this.dis = null;
    }

    public void initializeBg(boolean load) {
        if (load) {
            this.bgImageWidth = (240 + (this.tileWidth << 1) - 1) / this.tileWidth * this.tileWidth;
            this.bgImageHeight = (320 + (this.tileHeight << 1) - 1) / this.tileHeight * this.tileHeight;
            this.bgImage = null;
            this.bgImage = Image.createImage((int)this.bgImageWidth, (int)this.bgImageHeight);
            this.s_g_bgImage = this.bgImage.getGraphics();
        }
        try {
            if (this.updateTile) {
                this.tileImage = new Image[2];
                this.tileImage[0] = Image.createImage((String)("/" + this.texts[this.idTileImage]));
                this.tileImage[1] = this.idTileImage2 == this.idTileImage ? this.tileImage[0] : Image.createImage((String)("/" + this.texts[this.idTileImage2]));
                this.tileCountPerLine[0] = this.tileImage[0].getWidth() / this.tileWidth;
                this.tileCountPerLine[1] = this.tileImage[1].getWidth() / this.tileWidth;
            }
            this.updateTile = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ifUpdateBg = true;
        this.forceCam = true;
    }

    public void drawBgFast() {
        int currX0 = this.camX >> 4;
        int currY0 = this.camY >> 4;
        int currX1 = this.camX + 240 >> 4;
        int currY1 = this.camY + 320 >> 4;
        if (currX1 >= this.mapWidth) {
            currX1 = this.mapWidth - 1;
            this.ifUpdateBg = true;
        }
        if (currY1 >= this.mapHeight) {
            currY1 = this.mapHeight - 1;
            this.ifUpdateBg = true;
        }
        if (currX0 < 0) {
            currX0 = 0;
            this.ifUpdateBg = true;
        }
        if (currY0 < 0) {
            currY0 = 0;
            this.ifUpdateBg = true;
        }
        if (this.ifUpdateBg) {
            this.ifUpdateBg = false;
            this.drawBgPart(currX0, currY0, currX1, currY1);
            this.prevX0 = currX0;
            this.prevY0 = currY0;
            this.prevX1 = currX1;
            this.prevY1 = currY1;
        } else {
            int end;
            int start;
            if (this.prevX0 != currX0 || this.prevX1 != currX1) {
                if (this.prevX0 < currX0 || this.prevX1 < currX1) {
                    start = this.prevX1 + 1;
                    end = currX1;
                } else {
                    start = currX0;
                    end = this.prevX0 - 1;
                }
                this.drawBgPart(start, currY0, end, currY1);
                this.prevX0 = currX0;
                this.prevX1 = currX1;
            }
            if (this.prevY0 != currY0 || this.prevY1 != currY1) {
                if (this.prevY0 < currY0 || this.prevY1 < currY1) {
                    start = this.prevY1 + 1;
                    end = currY1;
                } else {
                    start = currY0;
                    end = this.prevY0 - 1;
                }
                this.drawBgPart(currX0, start, currX1, end);
                this.prevY0 = currY0;
                this.prevY1 = currY1;
            }
        }
        int modX0 = this.camX % this.bgImageWidth;
        int modY0 = this.camY % this.bgImageHeight;
        int modX1 = (this.camX + 240) % this.bgImageWidth;
        int modY1 = (this.camY + 320) % this.bgImageHeight;
        if (modX1 > modX0) {
            if (modY1 > modY0) {
                this.copyFromBgImage(modX0, modY0, 240, 320, 0, 0);
            } else {
                this.copyFromBgImage(modX0, modY0, 240, 320 - modY1, 0, 0);
                this.copyFromBgImage(modX0, 0, 240, modY1, 0, 320 - modY1);
            }
        } else if (modY1 > modY0) {
            this.copyFromBgImage(modX0, modY0, 240 - modX1, 320, 0, 0);
            this.copyFromBgImage(0, modY0, modX1, 320, 240 - modX1, 0);
        } else {
            this.copyFromBgImage(modX0, modY0, 240 - modX1, 320 - modY1, 0, 0);
            this.copyFromBgImage(modX0, 0, 240 - modX1, modY1, 0, 320 - modY1);
            this.copyFromBgImage(0, modY0, modX1, 320 - modY1, 240 - modX1, 0);
            this.copyFromBgImage(0, 0, modX1, modY1, 240 - modX1, 320 - modY1);
        }
        this.g.setClip(0, 0, 240, 320);
        this.g.clipRect(0, 0, 240, 320);
    }

    private void drawBgPart(int tileX0, int tileY0, int tileX1, int tileY1) {
        int originDestX = (tileX0 << 4) % this.bgImageWidth;
        for (int k = 0; k < this.mapBuffer.length; ++k) {
            for (int j = tileY0; j <= tileY1; ++j) {
                if (j >= this.mapHeight) continue;
                int destX = originDestX;
                int destY = (j << 4) % this.bgImageHeight;
                if (destY >= this.bgImageHeight) {
                    destY -= this.bgImageHeight;
                }
                for (int i = tileX0; i <= tileX1; ++i) {
                    short data1 = this.mapBuffer[k][j * this.mapWidth + i];
                    if (data1 != -1) {
                        int flag = Animation.trans((data1 & 0x8000) != 0, (data1 & 0x4000) != 0);
                        data1 = (short)(data1 & 0x3FF);
                        int srcX = data1 % this.tileCountPerLine[k] << 4;
                        int srcY = data1 / this.tileCountPerLine[k] << 4;
                        this.s_g_bgImage.setClip(destX, destY, this.tileWidth, this.tileHeight);
                        this.s_g_bgImage.clipRect(destX, destY, this.tileWidth, this.tileHeight);
                        if (flag == 0) {
                            this.s_g_bgImage.drawImage(this.tileImage[k], destX - srcX, destY - srcY, 20);
                        } else {
                            this.s_g_bgImage.drawRegion(this.tileImage[k], srcX, srcY, this.tileWidth, this.tileHeight, flag, destX, destY, 0);
                        }
                    }
                    if ((destX += this.tileWidth) < this.bgImageWidth) continue;
                    destX -= this.bgImageWidth;
                }
            }
        }
    }

    private void copyFromBgImage(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.g.setClip(destX, destY, width, height);
        this.g.clipRect(destX, destY, width, height);
        this.g.drawImage(this.bgImage, destX - srcX, destY - srcY, 0);
    }

    public void updateCamera(boolean isCenterPlayer) {
        if (isCenterPlayer) {
            Actor player = centerPlayer;
            int focusX = player.m_posX + (player.m_flipX ? -1 : 1) * 30;
            int focusY = player.m_posY;
            this.destCamX = focusX - 120;
            this.destCamY = focusY - 160;
            this.destCamX = Tool.limit(this.destCamX, this.camLimitX, this.camLimitW - 240 - 1);
            this.destCamY = Tool.limit(this.destCamY, 0, this.camLimitH);
        }
        if (this.camX < this.destCamX) {
            this.camX += this.camSpeed;
            if (this.camX > this.destCamX) {
                this.camX = this.destCamX;
            }
        }
        if (this.camX > this.destCamX) {
            this.camX -= this.camSpeed;
            if (this.camX < this.destCamX) {
                this.camX = this.destCamX;
            }
        }
        if (this.camY < this.destCamY) {
            this.camY += this.camSpeed;
            if (this.camY > this.destCamY) {
                this.camY = this.destCamY;
            }
        }
        if (this.camY > this.destCamY) {
            this.camY -= this.camSpeed;
            if (this.camY < this.destCamY) {
                this.camY = this.destCamY;
            }
        }
        if (this.camX == this.destCamX && this.camY == this.destCamY) {
            this.isScrolling = false;
        }
        if (this.forceCam) {
            this.camX = this.destCamX;
            this.camY = this.destCamY;
            this.forceCam = false;
        }
    }

    public void releaseMap(boolean unload) {
        if (unload) {
            this.s_g_bgImage = null;
            this.bgImage = null;
        }
        if (this.mapBuffer != null) {
            for (int i = 0; i < this.mapBuffer.length; ++i) {
                this.mapBuffer[i] = null;
            }
            this.mapBuffer = null;
        }
        this.phyBuffer = null;
        if (this.updateTile && this.tileImage != null) {
            this.tileImage[0] = null;
            this.tileImage[1] = null;
            this.tileImage = null;
        }
    }
}

