/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Vector;

public class GScript {
    static final byte RESERVE_IF_ID = -1;
    static final byte RESERVE_CALL_ID = -2;
    static final byte RESERVE_RETURN_ID = -3;
    static final byte RESERVE_BREAK_ID = -4;
    static final byte RESERVE_LOADSCRIPT_ID = -5;
    static final byte RESERVE_UNLOADSCRIPT_ID = -6;
    static final byte RESERVE_ASSIGN_ID = -7;
    static final byte T_IDENTIFER = 10;
    static final byte T_INTEGER = 11;
    static final byte T_FLOAT = 12;
    static final byte T_CHAR = 13;
    static final byte T_STRING = 14;
    static final byte T_TRUE = 15;
    static final byte T_FALSE = 16;
    static final byte T_SCRIPT = 17;
    static final byte T_OPERATOR = 18;
    static final byte O_PLUS = 6;
    static final byte O_MINUS = 7;
    static final byte O_STAR = 8;
    static final byte O_SLASH = 9;
    static final byte O_EQ = 10;
    static final byte O_NE = 11;
    static final byte O_LT = 12;
    static final byte O_GT = 13;
    static final byte O_LE = 14;
    static final byte O_GE = 15;
    public static byte[] m_variable;
    public static Vector m_string;
    public static short[][][] m_script;
    public static short[] m_param;
    static short[][] m_recursion;
    static byte m_recursionLevel;
    static short m_curScript;
    static short m_curIns;
    static short m_curID;
    static boolean b_running;
    static boolean b_cycling;
    static String m_file;
    static String m_head;
    private static final int SC_NUM = 4;
    private static final int[] SC_INDEX;
    static int s_backStatus;

    static void init(String file) {
        GScript.dispose();
        try {
            m_file = file;
            m_recursion = new short[8][2];
            m_recursionLevel = 0;
            m_curScript = 0;
            m_curIns = 0;
            GScript.LoadScript(m_curScript, false);
            m_param = new short[8];
            b_running = true;
            b_cycling = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void readHead(DataInputStream in, boolean isSkip) {
        try {
            int count = in.readShort();
            if (isSkip) {
                in.skip(count + 2);
            } else {
                m_variable = new byte[count];
                for (int i = 0; i < count; ++i) {
                    GScript.m_variable[i] = in.readByte();
                }
                count = in.readShort();
                m_script = new short[count][][];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void LoadScript(int sNo, boolean isSkip) {
        try {
            if (isSkip && m_script[sNo] != null) {
                return;
            }
            DataInputStream in = new DataInputStream(m_file.getClass().getResourceAsStream(m_file));
            GScript.readHead(in, isSkip);
            in.skip(sNo * 4);
            int off = in.readInt();
            in.skip(off);
            int count = in.readShort();
            GScript.m_script[sNo] = new short[count][];
            for (int i = 0; i < count; ++i) {
                int index = 0;
                short id = in.readShort();
                int paramCount = in.readByte();
                GScript.m_script[sNo][i] = id == -1 ? new short[2 + paramCount * 5 + 1] : new short[2 + paramCount * 2];
                GScript.m_script[sNo][i][index++] = id;
                GScript.m_script[sNo][i][index++] = paramCount;
                for (int j = 0; j < paramCount; ++j) {
                    if (id == -1) {
                        GScript.readTeminal(in, m_script[sNo][i], index);
                        index += 2;
                        GScript.m_script[sNo][i][index++] = in.readByte();
                        GScript.readTeminal(in, m_script[sNo][i], index);
                        index += 2;
                        continue;
                    }
                    GScript.readTeminal(in, m_script[sNo][i], index);
                    index += 2;
                }
                if (id != -1) continue;
                GScript.m_script[sNo][i][index++] = in.readShort();
            }
            in.close();
            in = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void UnLoadScript(int sNo) {
        try {
            if (m_script[sNo] == null) {
                return;
            }
            for (int i = 0; i < m_script[sNo].length; ++i) {
                short id = m_script[sNo][i][0];
                if (id < 0) continue;
                int count = m_script[sNo][i][1];
                for (int j = 0; j < count; ++j) {
                    short type = m_script[sNo][i][2 + j * 2];
                    if (type != 13 && type != 14) continue;
                    short value = m_script[sNo][i][3 + j * 2];
                    m_string.setElementAt("", value);
                }
            }
            GScript.m_script[sNo] = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void dispose() {
        int i;
        if (m_script != null) {
            for (i = 0; i < m_script.length; ++i) {
                if (m_script[i] == null) continue;
                for (int j = 0; j < m_script[i].length; ++j) {
                    GScript.m_script[i][j] = null;
                }
            }
        }
        m_string.removeAllElements();
        m_param = null;
        m_variable = null;
        if (m_recursion != null) {
            for (i = 0; i < m_recursion.length; ++i) {
                GScript.m_recursion[i] = null;
            }
            m_recursion = null;
        }
    }

    private static void readTeminal(DataInputStream in, short[] ins, int index) {
        try {
            byte type = in.readByte();
            short value = 0;
            switch (type) {
                case 10: 
                case 11: 
                case 12: 
                case 17: {
                    value = in.readShort();
                    break;
                }
                case 13: 
                case 14: {
                    StringBuffer str = new StringBuffer("");
                    int count = in.readShort();
                    for (int i = 0; i < count; ++i) {
                        str.append(in.readChar());
                    }
                    String test = null;
                    for (int i = 0; i < m_string.size(); ++i) {
                        test = (String)m_string.elementAt(i);
                        if (test == null || !test.equals("")) continue;
                        m_string.setElementAt(str.toString(), i);
                        value = (short)i;
                        test = null;
                        str = null;
                        ins[index++] = type;
                        ins[index++] = value;
                        return;
                    }
                    m_string.addElement(str.toString());
                    value = (short)(m_string.size() - 1);
                    test = null;
                    str = null;
                    break;
                }
                case 15: 
                case 16: {
                    value = in.readByte();
                    break;
                }
                case 18: {
                    value = in.readByte();
                }
            }
            ins[index++] = type;
            ins[index++] = value;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void assignStatement() {
        short paramCount = m_script[m_curScript][m_curIns][1];
        if (paramCount < 2 || paramCount > 4) {
            return;
        }
        short targetValue = m_script[m_curScript][m_curIns][3];
        if (paramCount == 2) {
            short param1Type = m_script[m_curScript][m_curIns][4];
            short param1Value = param1Type == 10 ? m_variable[m_script[m_curScript][m_curIns][5]] : m_script[m_curScript][m_curIns][5];
            GScript.m_variable[targetValue] = (byte)param1Value;
        } else if (paramCount == 4) {
            short param1Type = m_script[m_curScript][m_curIns][4];
            short param1Value = param1Type == 10 ? m_variable[m_script[m_curScript][m_curIns][5]] : m_script[m_curScript][m_curIns][5];
            short opType = m_script[m_curScript][m_curIns][7];
            short param2Type = m_script[m_curScript][m_curIns][8];
            short param2Value = param2Type == 10 ? m_variable[m_script[m_curScript][m_curIns][9]] : m_script[m_curScript][m_curIns][9];
            switch (opType) {
                case 6: {
                    GScript.m_variable[targetValue] = (byte)(param1Value + param2Value);
                    break;
                }
                case 7: {
                    GScript.m_variable[targetValue] = (byte)(param1Value - param2Value);
                    break;
                }
                case 8: {
                    GScript.m_variable[targetValue] = (byte)(param1Value * param2Value);
                    break;
                }
                case 9: {
                    GScript.m_variable[targetValue] = (byte)(param1Value / param2Value);
                }
            }
        }
    }

    private static void ifStatement() {
        int paramCount = m_script[m_curScript][m_curIns][1];
        for (int i = 0; i < paramCount; ++i) {
            short t_leftType = m_script[m_curScript][m_curIns][2 + i * 5];
            short t_leftValue = m_script[m_curScript][m_curIns][2 + i * 5 + 1];
            short o_type = m_script[m_curScript][m_curIns][2 + i * 5 + 2];
            short t_rightType = m_script[m_curScript][m_curIns][2 + i * 5 + 3];
            short t_rightValue = m_script[m_curScript][m_curIns][2 + i * 5 + 4];
            if (GScript.isConditionTrue(t_leftType, t_leftValue, o_type, t_rightType, t_rightValue)) continue;
            int skip_pos = m_script[m_curScript][m_curIns].length - 1;
            short skip = m_script[m_curScript][m_curIns][skip_pos];
            m_curIns = (short)(m_curIns + skip);
            return;
        }
    }

    private static boolean isConditionTrue(int l_type, int l_value, int o_type, int r_type, int r_value) {
        if (l_type == 10) {
            l_value = m_variable[l_value];
        }
        if (r_type == 10) {
            r_value = m_variable[r_value];
        }
        switch (o_type) {
            case 10: {
                return l_value == r_value;
            }
            case 11: {
                return l_value != r_value;
            }
            case 12: {
                return l_value < r_value;
            }
            case 13: {
                return l_value > r_value;
            }
            case 14: {
                return l_value <= r_value;
            }
            case 15: {
                return l_value >= r_value;
            }
        }
        return false;
    }

    static void runScript(int sNo) {
        if (sNo == 18) {
            // empty if block
        }
        b_running = true;
        b_cycling = true;
        m_curScript = (short)sNo;
        m_curIns = 0;
        if (m_script[m_curScript] == null) {
            GScript.LoadScript(m_curScript, true);
        }
    }

    static void run() {
        b_cycling = true;
        while (b_running && b_cycling && m_curIns < m_script[m_curScript].length) {
            GScript.runCommand();
        }
    }

    static void stop() {
        b_running = false;
        GameControl.gamecontrol.setGameStatus(s_backStatus);
        s_backStatus = 3;
        Actor.updateMission(0, 0, true);
    }

    static void turnOn() {
        b_running = true;
        b_cycling = true;
    }

    private static void runCommand() {
        try {
            if (m_curIns < 0 || m_curIns >= m_script[m_curScript].length) {
                return;
            }
            short insID = m_script[m_curScript][m_curIns][0];
            if (insID != -1) {
                int count = m_script[m_curScript][m_curIns][1];
                int index = 3;
                for (int i = 0; i < count; ++i) {
                    GScript.m_param[i] = m_script[m_curScript][m_curIns][index];
                    index += 2;
                }
            }
            switch (insID) {
                case -2: {
                    GScript.callCommand();
                    GScript.LoadScript(m_curScript, true);
                    return;
                }
                case -1: {
                    GScript.ifStatement();
                    break;
                }
                case -7: {
                    GScript.assignStatement();
                    break;
                }
                case -5: {
                    GScript.LoadScript(m_param[0], true);
                    break;
                }
                case -6: {
                    GScript.UnLoadScript(m_param[0]);
                    break;
                }
                case -4: {
                    GScript.breakCommand();
                    break;
                }
                case -3: {
                    if (m_recursionLevel > 0) {
                        GScript.returnCommand();
                        break;
                    }
                    GScript.stop();
                    return;
                }
                default: {
                    b_cycling = false;
                    GameControl.gamecontrol.runCommand(insID, m_param);
                }
            }
            GScript.nextCommand();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void nextCommand() {
        m_curIns = (short)(m_curIns + 1);
        while (m_curIns == m_script[m_curScript].length) {
            if (m_recursionLevel > 0) {
                GScript.returnCommand();
                continue;
            }
            GScript.stop();
            return;
        }
    }

    private static void callCommand() {
        try {
            GScript.m_recursion[GScript.m_recursionLevel][0] = m_curScript;
            GScript.m_recursion[GScript.m_recursionLevel][1] = m_curIns;
            m_recursionLevel = (byte)(m_recursionLevel + 1);
            m_curScript = m_param[0];
            m_curIns = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void returnCommand() {
        try {
            m_recursionLevel = (byte)(m_recursionLevel - 1);
            m_curScript = m_recursion[m_recursionLevel][0];
            m_curIns = m_recursion[m_recursionLevel][1];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void breakCommand() {
        try {
            m_recursionLevel = 0;
            m_curIns = (short)m_script[m_curScript].length;
            GScript.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveRecordData(DataOutputStream dos) throws Exception {
        for (int i = 0; i < m_variable.length; ++i) {
            dos.writeByte(m_variable[i]);
        }
    }

    public static void loadRecordData(DataInputStream dis) throws Exception {
        for (int i = 0; i < m_variable.length; ++i) {
            GScript.m_variable[i] = dis.readByte();
        }
    }

    public static void initRecord() {
        for (int i = 0; i < m_variable.length; ++i) {
            GScript.m_variable[i] = 0;
        }
    }

    static {
        m_string = new Vector();
        m_head = "/rh.bin";
        SC_INDEX = new int[]{-1, 32, 65, 88};
        s_backStatus = 3;
    }
}

