/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class Monster
extends Role {
    public short[] artical = new short[0];
    public short[] artodd = new short[0];
    public short[] arm = new short[0];
    public short[] armodd = new short[0];
    public short[] skillodd = new short[0];
    public int gold = 0;
    public int magicodd = 20;
    public static final short[][] POS = new short[][]{{48, 191}, {35, 223}, {22, 255}, {81, 207}, {68, 234}};
    public static Monster[] monster = new Monster[0];

    public int getMaxIndex(int[] array, int start, int len) {
        int max = array[start];
        int index = start;
        for (int i = start + 1; i < start + len; ++i) {
            if (max >= array[i]) continue;
            max = array[i];
            index = i;
        }
        return index;
    }

    public int getMinIndex(int[] array, int start, int len) {
        int min = array[start];
        int index = start;
        for (int i = start + 1; i < start + len; ++i) {
            if (min <= array[i]) continue;
            min = array[i];
            index = i;
        }
        return index;
    }

    public void autoAction(OwnTeam myteam, EnemyTeam enemyteam) {
        int count = 0;
        int[] indexs = new int[myteam.teamcount];
        for (int i = 0; i < myteam.teamcount; ++i) {
            if (!myteam.mates[i].isLive) continue;
            indexs[count] = ((Mate)myteam.mates[i]).c_enmity;
            ++count;
        }
        Role role = myteam.mates[this.getMaxIndex(indexs, 0, count)];
        role.calcHurt(this.calcAtt(role));
        role.setDie();
    }

    public void init() {
        this.getBasic();
        super.init();
    }

    public void copy(Entity entity) {
        super.copy(entity);
        Monster monster = (Monster)entity;
        this.artical = new short[monster.artical.length];
        Tool.arraycopy(monster.artical, 0, this.artical, 0, this.artical.length);
        this.artodd = new short[monster.artodd.length];
        Tool.arraycopy(monster.artodd, 0, this.artodd, 0, this.artodd.length);
        this.arm = new short[monster.arm.length];
        Tool.arraycopy(monster.arm, 0, this.arm, 0, this.arm.length);
        this.armodd = new short[monster.armodd.length];
        Tool.arraycopy(monster.armodd, 0, this.armodd, 0, this.armodd.length);
        this.skillodd = new short[monster.skillodd.length];
        Tool.arraycopy(monster.skillodd, 0, this.skillodd, 0, this.skillodd.length);
        this.gold = monster.gold;
        this.exp = monster.exp;
        this.magicodd = monster.magicodd;
        this.effect = monster.effect;
        this.actor = monster.actor != null ? monster.actor.clone(monster.actor) : null;
    }

    public void manualAction(OwnTeam myteam, EnemyTeam enemyteam) {
        this.autoAction(myteam, enemyteam);
    }

    public Object clone() {
        Monster mate = new Monster();
        mate.copy(this);
        return mate;
    }

    public void load(DataInputStream dis) {
        super.load(dis);
        try {
            int i;
            this.level = this.b_level;
            this.gold = dis.readShort();
            this.magicodd = dis.readShort();
            this.artical = new short[dis.readShort()];
            for (i = 0; i < this.artical.length; ++i) {
                this.artical[i] = dis.readShort();
            }
            this.artodd = new short[dis.readShort()];
            for (i = 0; i < this.artodd.length; ++i) {
                this.artodd[i] = dis.readShort();
            }
            this.arm = new short[dis.readShort()];
            for (i = 0; i < this.arm.length; ++i) {
                this.arm[i] = dis.readShort();
            }
            this.armodd = new short[dis.readShort()];
            for (i = 0; i < this.armodd.length; ++i) {
                this.armodd[i] = dis.readShort();
            }
            this.skillodd = new short[dis.readShort()];
            for (i = 0; i < this.skillodd.length; ++i) {
                this.skillodd[i] = dis.readShort();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

