/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OwnTeam
extends Team {
    private static final int MAX_FRIEND = 2;
    public int[] t_artical = new int[0];
    public int[] t_arm = new int[0];
    public int t_gold = 0;
    public int leveloff = 1;
    public int teamlevel = 1;
    public short[] artical = new short[0];
    public short[] artcount = new short[0];
    public short[] arm = new short[0];
    public short[] armcount = new short[0];
    public static final int[] POS = new int[]{0, 0, 5, 5, 10, 10};
    public int gold = 0;
    public static final int MAX_BATTLE_NUM = 2;
    public int existcount = 0;
    public static OwnTeam myteam;
    public static final int POS_X = 120;
    public static final int POS_Y = 20;
    private short[] initArt = new short[0];
    private short[] initArtCount = new short[0];
    private short[] initArm = new short[0];
    private short[] initArmCount = new short[0];
    public static final int MAX_ITEM_NUM = 99;

    public OwnTeam() {
        this.mates = new Mate[2];
        for (int i = 0; i < this.mates.length; ++i) {
            this.mates[i] = new Mate();
        }
        myteam = this;
    }

    public void copy(Team team) {
        super.copy(team);
        OwnTeam myteam = (OwnTeam)team;
        this.teamlevel = myteam.teamlevel;
        this.leveloff = myteam.leveloff;
        this.artical = new short[myteam.artical.length];
        Tool.arraycopy(myteam.artical, 0, this.artical, 0, myteam.artical.length);
        this.artcount = new short[myteam.artcount.length];
        Tool.arraycopy(myteam.artcount, 0, this.artcount, 0, myteam.artcount.length);
        this.arm = new short[myteam.arm.length];
        Tool.arraycopy(myteam.arm, 0, this.arm, 0, myteam.arm.length);
        this.armcount = new short[myteam.armcount.length];
        Tool.arraycopy(myteam.armcount, 0, this.armcount, 0, myteam.armcount.length);
        for (int i = 0; i < this.teamcount; ++i) {
            this.mates[i] = (Mate)myteam.mates[i].clone();
            this.mates[i].posx = (short)120;
            this.mates[i].posy = (short)(20 + 30 * i);
        }
    }

    public void addMate(Mate role) {
        this.mates[this.teamcount] = role;
        ++this.teamcount;
    }

    public void delMate(Mate role) {
        for (int i = 0; i < this.teamcount; ++i) {
            if (role != this.mates[i]) continue;
            this.delMate(i);
            return;
        }
    }

    public void delMate(int index) {
        for (int i = index; i < this.teamcount - 1; ++i) {
            this.mates[i] = this.mates[i + 1];
        }
        --this.teamcount;
    }

    private void alterMate(Mate oldRole, Mate role) {
        for (int i = 0; i < this.teamcount; ++i) {
            if (oldRole != this.mates[i]) continue;
            this.mates[i] = role;
            return;
        }
    }

    public void adjustTeam() {
        for (int i = 0; i < this.teamcount; ++i) {
            if (this.mates[i].isLive) continue;
            this.delMate(i);
        }
    }

    public void initBattleOther() {
        this.t_artical = new int[0];
        this.t_arm = new int[0];
        this.t_gold = 0;
        this.updateLevel();
    }

    public void updateLevel() {
        this.teamlevel = 0;
        for (int i = 0; i < this.teamcount; ++i) {
            this.teamlevel += this.mates[i].level;
        }
        this.teamlevel /= this.teamcount;
        this.teamlevel += this.leveloff;
    }

    public void addWinPrice(Monster enemy) {
        int[] tmparray = new int[this.t_artical.length + enemy.artical.length];
        Tool.arraycopy(this.t_artical, 0, tmparray, 0, this.t_artical.length);
        int count = 0;
        for (int i = 0; i < enemy.artical.length; ++i) {
            if (Tool.random(0, 99) >= enemy.artodd[i]) continue;
            tmparray[count + this.t_artical.length] = enemy.artical[i];
            ++count;
            if (enemy.artodd[i] != 100) break;
        }
        int len = this.t_artical.length;
        this.t_artical = null;
        this.t_artical = new int[len + count];
        Tool.arraycopy(tmparray, 0, this.t_artical, 0, this.t_artical.length);
        tmparray = null;
        tmparray = new int[this.t_arm.length + enemy.arm.length];
        Tool.arraycopy(this.t_arm, 0, tmparray, 0, this.t_arm.length);
        count = 0;
        for (int i = 0; i < enemy.arm.length; ++i) {
            if (Tool.random(0, 99) >= enemy.armodd[i]) continue;
            tmparray[count + this.t_arm.length] = enemy.arm[i];
            ++count;
            if (enemy.armodd[i] != 100) break;
        }
        len = this.t_arm.length;
        this.t_arm = null;
        this.t_arm = new int[len + count];
        Tool.arraycopy(tmparray, 0, this.t_arm, 0, this.t_arm.length);
        tmparray = null;
        int tmp = enemy.gold + enemy.gold * (enemy.level - this.teamlevel) * Tool.GOLD_ALPHA / 100;
        tmp = Tool.limit(tmp, 0, enemy.gold * Tool.GOLD_BETA);
        this.t_gold += tmp * Tool.GOLD_GAMA;
    }

    public Object clone() {
        OwnTeam team = new OwnTeam();
        team.copy(this);
        return team;
    }

    public void refreshArtical(int index) {
        for (int i = index; i < this.artical.length - 1; ++i) {
            this.artical[i] = this.artical[i + 1];
            this.artcount[i] = this.artcount[i + 1];
        }
        int count = this.artical.length - 1;
        short[] tmparray = new short[count];
        Tool.arraycopy(this.artical, 0, tmparray, 0, tmparray.length);
        this.artical = null;
        this.artical = tmparray;
        Tool.arraycopy(this.artcount, 0, tmparray, 0, tmparray.length);
        this.artcount = null;
        this.artcount = tmparray;
    }

    public void load(DataInputStream dis) {
        super.load(dis);
        try {
            int i;
            this.leveloff = dis.readShort();
            this.artical = new short[dis.readShort()];
            for (i = 0; i < this.artical.length; ++i) {
                this.artical[i] = dis.readShort();
            }
            this.initArt = new short[this.artical.length];
            Tool.arraycopy(this.artical, 0, this.initArt, 0, this.artical.length);
            this.artcount = new short[dis.readShort()];
            for (i = 0; i < this.artcount.length; ++i) {
                this.artcount[i] = dis.readShort();
            }
            this.initArtCount = new short[this.artcount.length];
            Tool.arraycopy(this.artcount, 0, this.initArtCount, 0, this.artcount.length);
            short count = dis.readShort();
            dis.skip(2 * count);
            count = dis.readShort();
            dis.skip(2 * count);
            this.arm = Tool.INIT_ARM;
            this.initArm = new short[this.arm.length];
            Tool.arraycopy(this.arm, 0, this.initArm, 0, this.arm.length);
            this.armcount = Tool.INIT_ARM_COUNT;
            this.initArmCount = new short[this.armcount.length];
            Tool.arraycopy(this.armcount, 0, this.initArmCount, 0, this.armcount.length);
            this.existcount = 1;
            this.teamcount = 1;
            for (int i2 = 0; i2 < this.existcount; ++i2) {
                this.mates[i2] = Mate.mate[this.mateid[i2]];
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void addArm(int armid) {
        this.addArm(armid, 1);
    }

    public void addArm(int armid, int num) {
        if (num <= 0) {
            return;
        }
        for (int i = 0; i < this.arm.length; ++i) {
            if (armid != this.arm[i]) continue;
            int n = i;
            this.armcount[n] = (short)(this.armcount[n] + num);
            this.armcount[i] = (short)Tool.limit(this.armcount[i], 0, 99);
            return;
        }
        short[] newarm = new short[this.arm.length + 1];
        short[] newarmcount = new short[newarm.length];
        Tool.arraycopy(this.armcount, 0, newarmcount, 0, this.armcount.length);
        newarmcount[newarm.length - 1] = (short)num;
        newarmcount[newarm.length - 1] = (short)Tool.limit(newarmcount[newarm.length - 1], 0, 99);
        Tool.arraycopy(this.arm, 0, newarm, 0, this.arm.length);
        newarm[newarm.length - 1] = (short)armid;
        this.arm = newarm;
        this.armcount = newarmcount;
    }

    public void addItem(int itemid) {
        this.addItem(itemid, 1);
    }

    public void addItem(int itemid, int num) {
        if (num <= 0) {
            return;
        }
        for (int i = 0; i < this.artical.length; ++i) {
            if (itemid != this.artical[i]) continue;
            int n = i;
            this.artcount[n] = (short)(this.artcount[n] + num);
            this.artcount[i] = (short)Tool.limit(this.artcount[i], 0, 99);
            return;
        }
        short[] newart = new short[this.artical.length + 1];
        short[] newartcount = new short[newart.length];
        Tool.arraycopy(this.artcount, 0, newartcount, 0, this.artcount.length);
        newartcount[newart.length - 1] = (short)num;
        newartcount[newart.length - 1] = (short)Tool.limit(newartcount[newart.length - 1], 0, 99);
        Tool.arraycopy(this.artical, 0, newart, 0, this.artical.length);
        newart[newart.length - 1] = (short)itemid;
        this.artical = newart;
        this.artcount = newartcount;
    }

    public void delArm(int armid) {
        for (int i = 0; i < this.arm.length; ++i) {
            if (armid != this.arm[i]) continue;
            int n = i;
            this.armcount[n] = (short)(this.armcount[n] - 1);
            if (this.armcount[i] <= 0) {
                for (int j = i; j < this.arm.length - 1; ++j) {
                    this.arm[j] = this.arm[j + 1];
                    this.armcount[j] = this.armcount[j + 1];
                }
                short[] newarm = new short[this.arm.length - 1];
                short[] newarmcount = new short[newarm.length];
                Tool.arraycopy(this.armcount, 0, newarmcount, 0, newarmcount.length);
                Tool.arraycopy(this.arm, 0, newarm, 0, newarm.length);
                this.arm = newarm;
                this.armcount = newarmcount;
            }
            return;
        }
    }

    public void delItem(int artid) {
        for (int i = 0; i < this.artical.length; ++i) {
            if (artid != this.artical[i]) continue;
            int n = i;
            this.artcount[n] = (short)(this.artcount[n] - 1);
            if (this.artcount[i] <= 0) {
                for (int j = i; j < this.artical.length - 1; ++j) {
                    this.artical[j] = this.artical[j + 1];
                    this.artcount[j] = this.artcount[j + 1];
                }
                short[] newarm = new short[this.artical.length - 1];
                short[] newarmcount = new short[newarm.length];
                Tool.arraycopy(this.artcount, 0, newarmcount, 0, newarmcount.length);
                Tool.arraycopy(this.artical, 0, newarm, 0, newarm.length);
                this.artcount = newarmcount;
                this.artical = newarm;
            }
            return;
        }
    }

    public void addTeamMate(short id) {
        for (int i = 0; i < this.existcount; ++i) {
            if (this.mateid[i] != id) continue;
            return;
        }
        this.mates[this.existcount] = Mate.mate[id];
        ++this.existcount;
        short[] tmp = new short[this.existcount];
        Tool.arraycopy(this.mateid, 0, tmp, 0, this.existcount - 1);
        tmp[this.existcount - 1] = id;
        this.mateid = null;
        this.mateid = tmp;
        for (int i = 0; i < this.mateid.length; ++i) {
            this.mates[i] = Mate.mate[this.mateid[i]];
        }
        if (Mate.mate[id].isallowbattle) {
            this.replaceBatMate(this.teamcount, id);
        }
    }

    public void delTeamMate(short id) {
        for (int i = 0; i < this.existcount; ++i) {
            if (this.mateid[i] != id) continue;
            --this.existcount;
            if (((Mate)this.mates[i]).isallowbattle) {
                --this.teamcount;
            }
            for (int j = i; j < this.existcount; ++j) {
                this.mateid[j] = this.mateid[j + 1];
            }
            short[] tmp = new short[this.existcount];
            Tool.arraycopy(this.mateid, 0, tmp, 0, this.existcount);
            this.mateid = tmp;
            for (int j = 0; j < this.mateid.length; ++j) {
                this.mates[j] = Mate.mate[this.mateid[j]];
            }
            return;
        }
    }

    public void replaceBatMate(int index, int id) {
        int repindex = -1;
        for (int i = 0; i < this.existcount; ++i) {
            if (this.mateid[i] != id) continue;
            repindex = i;
            break;
        }
        if (repindex == -1) {
            return;
        }
        if (index == this.teamcount) {
            ++this.teamcount;
        }
        Role role = this.mates[index];
        this.mates[index] = this.mates[repindex];
        this.mates[repindex] = role;
        short tmp = this.mateid[index];
        this.mateid[index] = this.mateid[repindex];
        this.mateid[repindex] = tmp;
    }

    public int getItemCount(int id, int type) {
        switch (type) {
            case 1: {
                for (int i = 0; i < this.artical.length; ++i) {
                    if (id != this.artical[i]) continue;
                    return 99 - this.artcount[i];
                }
                break;
            }
            case 0: {
                for (int i = 0; i < this.arm.length; ++i) {
                    if (id != this.arm[i]) continue;
                    return 99 - this.armcount[i];
                }
                break;
            }
        }
        return 99;
    }

    public void saveRecordData(DataOutputStream dos) throws Exception {
        int i;
        dos.writeShort(this.artical.length);
        for (i = 0; i < this.artical.length; ++i) {
            dos.writeShort(this.artical[i]);
            dos.writeShort(this.artcount[i]);
        }
        dos.writeShort(this.arm.length);
        for (i = 0; i < this.arm.length; ++i) {
            dos.writeShort(this.arm[i]);
            dos.writeShort(this.armcount[i]);
        }
        dos.writeInt(this.gold);
        dos.writeByte(this.existcount);
        dos.writeByte(this.teamcount);
        for (i = 0; i < this.existcount; ++i) {
            dos.writeByte(this.mateid[i]);
        }
        for (i = 0; i < Mate.mate.length; ++i) {
            Mate.mate[i].saveRecordData(dos);
        }
    }

    public void loadRecordData(DataInputStream dis) throws Exception {
        int i;
        short count = dis.readShort();
        this.artical = new short[count];
        this.artcount = new short[count];
        for (i = 0; i < this.artical.length; ++i) {
            this.artical[i] = dis.readShort();
            this.artcount[i] = dis.readShort();
        }
        count = dis.readShort();
        this.arm = new short[count];
        this.armcount = new short[count];
        for (i = 0; i < this.arm.length; ++i) {
            this.arm[i] = dis.readShort();
            this.armcount[i] = dis.readShort();
        }
        this.gold = dis.readInt();
        this.existcount = dis.readByte();
        this.teamcount = dis.readByte();
        this.teamcount = this.teamcount < this.existcount ? this.teamcount : this.existcount;
        this.mateid = new short[this.existcount];
        for (i = 0; i < this.existcount; ++i) {
            this.mateid[i] = dis.readByte();
            this.mates[i] = Mate.mate[this.mateid[i]];
        }
        for (i = 0; i < Mate.mate.length; ++i) {
            Mate.mate[i].loadRecordData(dis);
        }
    }

    public void initRecord() {
        this.delTeamMate((short)1);
        this.delTeamMate((short)2);
        this.delTeamMate((short)3);
        this.gold = 2000;
        this.artical = new short[this.initArt.length];
        Tool.arraycopy(this.initArt, 0, this.artical, 0, this.initArt.length);
        this.artcount = new short[this.initArtCount.length];
        Tool.arraycopy(this.initArtCount, 0, this.artcount, 0, this.initArtCount.length);
        this.arm = new short[this.initArm.length];
        Tool.arraycopy(this.initArm, 0, this.arm, 0, this.initArm.length);
        this.armcount = new short[this.initArmCount.length];
        Tool.arraycopy(this.initArmCount, 0, this.armcount, 0, this.initArmCount.length);
    }

    public void delArtical(int type, int id, int count) {
        switch (type) {
            case 0: {
                for (int i = 0; i < this.arm.length; ++i) {
                    if (id != this.arm[i]) continue;
                    int n = i;
                    this.armcount[n] = (short)(this.armcount[n] - count);
                    if (this.armcount[i] <= 0) {
                        for (int j = i; j < this.arm.length - 1; ++j) {
                            this.arm[j] = this.arm[j + 1];
                            this.armcount[j] = this.armcount[j + 1];
                        }
                        short[] newarm = new short[this.arm.length - 1];
                        short[] newarmcount = new short[newarm.length];
                        Tool.arraycopy(this.armcount, 0, newarmcount, 0, newarmcount.length);
                        Tool.arraycopy(this.arm, 0, newarm, 0, newarm.length);
                        this.arm = newarm;
                        this.armcount = newarmcount;
                    }
                    return;
                }
                break;
            }
            case 1: 
            case 2: {
                for (int i = 0; i < this.artical.length; ++i) {
                    if (id != this.artical[i]) continue;
                    int n = i;
                    this.artcount[n] = (short)(this.artcount[n] - count);
                    if (this.artcount[i] <= 0) {
                        for (int j = i; j < this.artical.length - 1; ++j) {
                            this.artical[j] = this.artical[j + 1];
                            this.artcount[j] = this.artcount[j + 1];
                        }
                        short[] newarm = new short[this.artical.length - 1];
                        short[] newarmcount = new short[newarm.length];
                        Tool.arraycopy(this.artcount, 0, newarmcount, 0, newarmcount.length);
                        Tool.arraycopy(this.artical, 0, newarm, 0, newarm.length);
                        this.artcount = newarmcount;
                        this.artical = newarm;
                    }
                    return;
                }
                break;
            }
        }
    }
}

