/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.CGraphics;
import custom.Main;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class TextObject {
    public static final String FLAG_START_LEFT = "<c ";
    public static int START_LEFT_LENGTH = "<c ".length();
    public static final String FLAG_START_RIGHT = ">";
    public static int START_RIGHT_LENGTH = ">".length();
    public static final String FLAG_END = "</c>";
    public static int END_LENGTH = "</c>".length();
    public static final int ARRAY_INCREMENT = 5;
    public static final int TEXT_FLAG_NUM = 15;
    private int width;
    public String textData;
    private int[] textLineInfos;
    public int lineCount;
    public static Font s_font;
    private boolean textFlag;
    private short[] textFlagPos = new short[30];
    private int[] textFlagColor = new int[15];
    private int m_color;
    private int flagIndex;
    private int charIndex;
    private int charMaxIndex;
    public static int TEXT_INTERVAL;

    public TextObject() {
        this.setFont(Main.s_fontSmall);
        this.init();
    }

    public void init() {
        this.textData = "";
        this.flagIndex = 0;
    }

    public void setCharIndex(int start, int end) {
        this.charIndex = this.textLineInfos[start << 1];
        end = Math.min(end, this.lineCount - 1);
        this.charMaxIndex = this.textLineInfos[(end << 1) + 1];
    }

    public boolean isShowAll() {
        return this.charIndex >= this.charMaxIndex;
    }

    public void setShowAll() {
        this.charIndex = this.charMaxIndex;
    }

    public int getLineHeight() {
        return TEXT_INTERVAL;
    }

    public void setFont(Font font) {
        s_font = font;
        TEXT_INTERVAL = s_font.getHeight() + 1;
    }

    public void setColor(int color) {
        this.m_color = color;
    }

    public void setText(String text) {
        this.textFlagColor = new int[15];
        this.textFlag = TextObject.hasFlagParse(text);
        if (!this.textFlag) {
            this.textData = text;
            return;
        }
        int length = text.length();
        int searchIndex = 0;
        Vector<String> str = new Vector<String>();
        while (searchIndex < length) {
            int startLeftID = TextObject.getFlagID(text, FLAG_START_LEFT, searchIndex);
            int endID = TextObject.getFlagID(text, FLAG_END, searchIndex);
            if (startLeftID > searchIndex) {
                str.addElement(text.substring(searchIndex, startLeftID));
            }
            if (startLeftID >= 0) {
                str.addElement(text.substring(startLeftID, endID + END_LENGTH));
            }
            if (endID >= 0) {
                searchIndex = endID + END_LENGTH;
                continue;
            }
            if (length <= searchIndex) break;
            str.addElement(text.substring(searchIndex, length));
            break;
        }
        this.textData = "";
        this.flagIndex = 0;
        int elemSize = str.size();
        for (int i = 0; i < elemSize; ++i) {
            String s = (String)str.elementAt(i);
            int startLeftID = TextObject.getFlagID(s, FLAG_START_LEFT, 0);
            if (startLeftID != -1) {
                int startRightID = TextObject.getFlagID(s, FLAG_START_RIGHT, 0);
                int endID = TextObject.getFlagID(s, FLAG_END, 0);
                this.textFlagColor[this.flagIndex] = Integer.parseInt(s.substring(startLeftID + START_LEFT_LENGTH, startRightID).substring(2), 16);
                s = s.substring(startRightID + START_RIGHT_LENGTH, endID);
                int charNum = s.length();
                int curSize = this.textData.length();
                this.textFlagPos[this.flagIndex * 2] = (short)curSize;
                this.textFlagPos[this.flagIndex * 2 + 1] = (short)(curSize + charNum);
                ++this.flagIndex;
            }
            this.textData = this.textData + s;
        }
    }

    public static int getFlagID(String text, String flag, int index) {
        return text.indexOf(flag, index);
    }

    public static boolean hasFlagParse(String text) {
        if (text == null) {
            return false;
        }
        return text.indexOf(FLAG_START_LEFT) != -1;
    }

    public int getLines(int width) {
        this.width = width;
        this.lineCount = 0;
        int widestLine = 0;
        int startOfNextWord = 0;
        int entireTextLength = this.textData.length();
        this.textLineInfos = new int[20];
        while (startOfNextWord < entireTextLength) {
            int availableRowWidth = width;
            int wordsOnRow = 0;
            int lineStartPos = startOfNextWord;
            int lineEndPos = entireTextLength;
            while (startOfNextWord < entireTextLength) {
                int currentWordEndPos = entireTextLength;
                for (int j = startOfNextWord; j < entireTextLength; ++j) {
                    if (this.textData.charAt(j) != '|' && this.textData.charAt(j) != '\n') continue;
                    currentWordEndPos = j;
                    break;
                }
                if (TextObject.getTextWidth(this.textData.substring(lineStartPos, currentWordEndPos)) < availableRowWidth) {
                    lineEndPos = currentWordEndPos;
                    ++wordsOnRow;
                    if (lineEndPos < entireTextLength && (this.textData.charAt(lineEndPos) == '|' || this.textData.charAt(lineEndPos) == '\n')) break;
                    for (startOfNextWord = currentWordEndPos; startOfNextWord < entireTextLength && this.textData.charAt(startOfNextWord) != '|' && this.textData.charAt(startOfNextWord) != '\n'; ++startOfNextWord) {
                    }
                    continue;
                }
                if (wordsOnRow != 0) break;
                int currentChar = lineStartPos;
                while (TextObject.getTextWidth(this.textData.substring(lineStartPos, currentChar + 1)) < availableRowWidth) {
                    ++currentChar;
                }
                lineEndPos = currentChar;
                startOfNextWord = currentChar;
                ++wordsOnRow;
                break;
            }
            int lineWidth = TextObject.getTextWidth(this.textData.substring(lineStartPos, lineEndPos));
            widestLine = Math.max(widestLine, lineWidth);
            this.textLineInfos = this.append(this.textLineInfos, this.lineCount, lineStartPos, lineEndPos);
            ++this.lineCount;
            if (startOfNextWord < entireTextLength && (this.textData.charAt(startOfNextWord) == '\n' || this.textData.charAt(startOfNextWord) == '|')) {
                ++startOfNextWord;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {}
        }
        return widestLine;
    }

    public int getHeight() {
        int contentHeight = this.lineCount * TEXT_INTERVAL;
        return contentHeight;
    }

    public int[] append(int[] array, int currentLength, int offset, int length) {
        if (array.length <= currentLength << 1) {
            int[] temp = new int[array.length + 10];
            System.arraycopy(array, 0, temp, 0, array.length);
            array = temp;
        }
        array[currentLength << 1] = offset;
        array[(currentLength << 1) + 1] = length;
        return array;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void paint(Graphics g, int x, int y) {
        this.paint(g, x, y, 0, this.lineCount, false);
    }

    public void paintLeft(Graphics g, int x, int y) {
        this.paint(g, x, y, 0, this.lineCount, 1, 1, false, true, false);
    }

    public void paintLeftStartEnd(Graphics g, int x, int y, int start, int end, int clipX, int clipY, int clipW, int clipH) {
        g.setClip(clipX, clipY, clipW, clipH);
        this.paint(g, x, y, start, end, 1, 1, false, true, false);
    }

    public void paint(Graphics g, int x, int y, int start, int end, boolean wfw) {
        this.paint(g, x, y, start, end, 1, 0, false, true, wfw);
    }

    public void paint(Graphics g, int x, int y, int start, int end, int spriteAnchorProperty, int textAnchorProperty, boolean selected, boolean enabled, boolean wfw) {
        int addAnchor = 20;
        int addXT = 0;
        boolean spriteOnLeft = spriteAnchorProperty == 1;
        int onWrapTextX = 0;
        switch (textAnchorProperty) {
            case 1: {
                addXT = 0;
                addAnchor = 20;
                onWrapTextX = 0;
                break;
            }
            case 2: {
                addXT = this.width;
                addAnchor = 24;
                onWrapTextX = addXT;
                break;
            }
            case 0: {
                addXT = this.width >> 1;
                addAnchor = 17;
                onWrapTextX = spriteOnLeft ? addXT : addXT;
            }
        }
        int currentLineY = 0;
        int minY = g.getClipY();
        int maxY = minY + g.getClipHeight();
        end = Math.min(end, this.lineCount);
        for (int lineN = start; lineN < end; ++lineN) {
            if (y + currentLineY < minY - TEXT_INTERVAL || y + currentLineY > maxY) {
                currentLineY += TEXT_INTERVAL;
                continue;
            }
            String str = this.textData.substring(this.textLineInfos[lineN << 1], this.textLineInfos[(lineN << 1) + 1]);
            int x2 = x + addXT + TextObject.getTextAnchorWidth(str, addAnchor);
            int y2 = y + currentLineY + TextObject.getTextAnchorHeight(addAnchor);
            if (wfw) {
                if (this.charIndex > this.textLineInfos[lineN << 1]) {
                    this.drawString(g, this.textLineInfos[lineN << 1], Math.min(this.textLineInfos[(lineN << 1) + 1], this.charIndex), x2, y2);
                }
            } else {
                this.drawString(g, this.textLineInfos[lineN << 1], this.textLineInfos[(lineN << 1) + 1], x2, y2);
            }
            currentLineY += TEXT_INTERVAL;
        }
        if (this.charIndex < this.charMaxIndex) {
            ++this.charIndex;
        }
    }

    public void drawString(Graphics g, int start, int end, int x, int y) {
        int offset;
        if (!this.textFlag) {
            CGraphics.drawString(this.textData.substring(start, end), g, x, y, this.m_color, 20);
            return;
        }
        int flagIndex = this.inTextFlag(start);
        for (offset = start + 1; offset < end && flagIndex == this.inTextFlag(offset); ++offset) {
        }
        int color = flagIndex == -1 ? this.m_color : this.textFlagColor[flagIndex];
        g.setColor(color);
        String text = this.textData.substring(start, offset);
        CGraphics.drawString(text, g, x, y, color, 20);
        if (offset < end) {
            this.drawString(g, offset, end, x += TextObject.getTextWidth(text), y);
        }
    }

    public int inTextFlag(int index) {
        for (int i = 0; i < this.textFlagPos.length; i += 2) {
            if (index < this.textFlagPos[i] || index >= this.textFlagPos[i + 1]) continue;
            return i >> 1;
        }
        return -1;
    }

    public static int getTextAnchorWidth(String str, int anchor) {
        int x = 0;
        switch (anchor) {
            case 20: {
                break;
            }
            case 24: {
                x -= TextObject.getTextWidth(str);
                break;
            }
            case 17: {
                x -= TextObject.getTextWidth(str) / 2;
                break;
            }
            case 3: {
                x -= TextObject.getTextWidth(str) / 2;
                break;
            }
            case 36: {
                break;
            }
            case 40: {
                x -= TextObject.getTextWidth(str);
                break;
            }
            case 33: {
                x -= TextObject.getTextWidth(str) / 2;
            }
        }
        return x;
    }

    public static int getTextAnchorHeight(int anchor) {
        int y = 0;
        switch (anchor) {
            case 20: {
                break;
            }
            case 24: {
                break;
            }
            case 17: {
                break;
            }
            case 3: {
                y -= s_font.getHeight() / 2;
                break;
            }
            case 36: {
                y += s_font.getHeight();
                break;
            }
            case 40: {
                y += s_font.getHeight();
                break;
            }
            case 33: {
                y += s_font.getHeight();
            }
        }
        return y;
    }

    public static int getTextWidth(String text) {
        return s_font.stringWidth(text);
    }
}

