/*
 * Decompiled with CFR 0.152.
 */
package custom;

import custom.Animation;
import custom.Main;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Utils {
    private static Random random = new Random();
    public static final int MAX_VALUE = 0x7FFFFF;
    public static final int MIN_VALUE = -8388607;
    public static final int NAN = Integer.MAX_VALUE;
    public static final int[] SIN = new int[]{0, 4, 9, 13, 18, 22, 27, 31, 36, 40, 44, 49, 53, 58, 62, 66, 71, 75, 79, 83, 88, 92, 96, 100, 104, 108, 112, 116, 120, 124, 128, 132, 136, 139, 143, 147, 150, 154, 158, 161, 165, 168, 171, 175, 178, 181, 184, 187, 190, 193, 196, 199, 202, 204, 207, 210, 212, 215, 217, 219, 222, 224, 226, 228, 230, 232, 234, 236, 237, 239, 241, 242, 243, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 254, 255, 255, 255, 256, 256, 256, 256, 256, 256, 256, 255, 255, 255, 254, 254, 253, 252, 251, 250, 249, 248, 247, 246, 245, 243, 242, 241, 239, 237, 236, 234, 232, 230, 228, 226, 224, 222, 219, 217, 215, 212, 210, 207, 204, 202, 199, 196, 193, 190, 187, 184, 181, 178, 175, 171, 168, 165, 161, 158, 154, 150, 147, 143, 139, 136, 132, 128, 124, 120, 116, 112, 108, 104, 100, 96, 92, 88, 83, 79, 75, 71, 66, 62, 58, 53, 49, 44, 40, 36, 31, 27, 22, 18, 13, 9, 4, 0};
    public static final byte[] ACOS = new byte[]{90, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 89, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 88, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 87, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 86, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 84, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 83, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 82, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 78, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 77, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 74, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 73, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 69, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 68, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 67, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 63, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 60, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 47, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 37, 37, 37, 37, 37, 37, 37, 37, 37, 37, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 36, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 33, 33, 33, 33, 33, 33, 33, 33, 33, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 31, 31, 31, 31, 31, 31, 31, 31, 31, 30, 30, 30, 30, 30, 30, 30, 30, 30, 29, 29, 29, 29, 29, 29, 29, 29, 28, 28, 28, 28, 28, 28, 28, 28, 27, 27, 27, 27, 27, 27, 27, 27, 27, 26, 26, 26, 26, 26, 26, 26, 25, 25, 25, 25, 25, 25, 25, 25, 24, 24, 24, 24, 24, 24, 24, 23, 23, 23, 23, 23, 23, 23, 22, 22, 22, 22, 22, 22, 22, 21, 21, 21, 21, 21, 21, 20, 20, 20, 20, 20, 20, 19, 19, 19, 19, 19, 19, 18, 18, 18, 18, 18, 18, 17, 17, 17, 17, 17, 16, 16, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 14, 14, 13, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 10, 10, 10, 9, 9, 9, 8, 8, 8, 7, 7, 6, 6, 5, 5, 4, 3, 2, 1, 0};
    public static int index = 0;

    public static int getRandom(int nMin, int nMax) {
        int iRet = Math.abs(random.nextInt());
        iRet = iRet % (nMax + 1 - nMin) + nMin;
        return iRet;
    }

    public static int[] arrayShift(int[] shift, int number) {
        int temp = 0;
        for (int i = 0; i < shift.length; ++i) {
            if (shift[i] != number) continue;
            temp = i;
            ++index;
        }
        for (int j = 0; j < shift.length - 1 - temp; ++j) {
            shift[temp + j] = shift[temp + j + 1];
        }
        shift[shift.length - 1] = shift.length - 1 - index;
        return shift;
    }

    public static short getRandomEx(int minValue, int maxValue) {
        return (short)(minValue + (random.nextInt() >> 1) % (maxValue - minValue) + 1);
    }

    public static int sqrt(int x, int r) {
        if (x <= 0) {
            return 0;
        }
        int s = x + 256 >> 1;
        for (int i = 0; i < r; ++i) {
            s = s + (x << 8) / s >> 1;
        }
        return s >> 4;
    }

    public static int sin(int b) {
        if (Math.abs(b) > 360) {
            b %= 360;
        }
        if (b < 0) {
            b = 360 + b;
        }
        if (b > 180) {
            return -SIN[b -= 180];
        }
        return SIN[b];
    }

    public static int cos(int b) {
        return Utils.sin(90 - b);
    }

    public static int tan(int b) {
        int c = Utils.cos(b);
        return c != 0 ? (Utils.sin(b) << 12) / c : Integer.MAX_VALUE;
    }

    public static int getDistance(int x1, int y1, int x2, int y2) {
        int val1 = (y1 - y2) * (y1 - y2);
        int val2 = (x1 - x2) * (x1 - x2);
        int val3 = val1 + val2;
        int val4 = val1 > val2 ? y1 - y2 : x1 - x2;
        while (val4 * val4 < val3) {
            ++val4;
        }
        return val4;
    }

    public static int getLineY(int x1, int y1, int x2, int y2, int x3) {
        return y1 - (y1 - y2) * (x1 - x3) / (x1 - x2);
    }

    public static int getAngle(int x1, int y1, int x2, int y2) {
        int rotation = 0;
        int distance = 0;
        boolean pm = false;
        distance = Utils.getDistance(x1, y1, x2, y2);
        if (distance != 0) {
            rotation = (x1 - x2) * 1000 / distance;
        }
        if (rotation < 0) {
            rotation = -rotation;
            pm = true;
        }
        if (rotation >= ACOS.length) {
            rotation = ACOS.length - 1;
        }
        rotation = ACOS[rotation];
        if (pm) {
            rotation = 180 - rotation;
        }
        if (y1 - y2 < 0) {
            rotation = 360 - rotation;
        }
        if ((rotation -= 180) < 0) {
            rotation += 360;
        }
        return rotation;
    }

    public static final int readUnsignedInt(byte[] b, int off) {
        int res = 0;
        int i = 0;
        while (i < 4) {
            res <<= 8;
            res += b[off];
            if (b[off] < 0) {
                res += 256;
            }
            ++i;
            ++off;
        }
        return res;
    }

    public static void logger(String Information, Exception e) {
        System.out.println(Information);
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void drawColorString(Graphics g, String colorStr, int x, int y, int beforColor, int backColor) {
        g.setFont(Main.s_fontSmall);
        g.setColor(backColor);
        g.drawString(colorStr, x - 1, y, 17);
        g.drawString(colorStr, x + 1, y, 17);
        g.drawString(colorStr, x, y - 1, 17);
        g.drawString(colorStr, x, y + 1, 17);
        g.setColor(beforColor);
        g.drawString(colorStr, x, y, 17);
    }

    public static void drawRegionAfterString(Graphics g, String str, int x, int y, int color, int anchor) {
        g.setClip(0, 0, 240, 320);
        g.setColor(color);
        g.drawString(str, x, y, anchor);
    }

    public static void drawRectThreeColor(Graphics g, int drawRectX, int drawRectY, int w, int h, int rectColor, int aroundFirstColor, int aroundSeondColor) {
        g.setColor(rectColor);
        g.fillRect(drawRectX, drawRectY, w, h);
        g.setColor(aroundFirstColor);
        g.drawLine(drawRectX, drawRectY, drawRectX + w, drawRectY);
        g.setColor(aroundSeondColor);
        g.drawLine(drawRectX, drawRectY + 1, drawRectX + w, drawRectY + 1);
        g.setColor(aroundFirstColor);
        g.drawLine(drawRectX, drawRectY + h - 1, drawRectX + w, drawRectY + h - 1);
        g.setColor(aroundSeondColor);
        g.drawLine(drawRectX, drawRectY + h - 2, drawRectX + w, drawRectY + h - 2);
    }

    public static void drawRoundRect(Graphics g, int x, int y, int w, int h, int color) {
        g.setColor(color);
        g.drawRoundRect(x, y, w, h, 7, 7);
    }

    public static void drawRoundFillRect(Graphics g, int x, int y, int w, int h, int color) {
        g.setColor(color);
        g.fillRoundRect(x, y, w, h, 20, 20);
    }

    public static void drawTipClipImg(Graphics g, Image img, int dx, int dy, int clipW, int clipH, int clipX, int clipY) {
        Animation.drawRegion(dx, dy, clipW, clipH, clipX, clipY, img, g);
    }

    public static void drawInformationRang(Graphics g, int x, int y, int h, Image imgRang, Image imgRangBody, int rectColor) {
        int height = imgRang.getHeight();
        int width = imgRang.getWidth();
        int heightBody = imgRangBody.getHeight();
        int widthBody = imgRangBody.getWidth();
        int tempH = 0;
        int num = (h - 2 * height) / heightBody;
        if ((h - 2 * height) % heightBody != 0) {
            ++num;
        }
        g.drawImage(imgRang, x, y, 20);
        for (int i = 0; i < num + 1; ++i) {
            g.setClip(x, y, width, height + h);
            g.drawImage(imgRangBody, x, y + height + i * heightBody, 20);
            if (heightBody + i * heightBody > h) {
                tempH = heightBody + i * heightBody - h;
            }
            Animation.drawRegion(x + width - widthBody, y + height + i * heightBody, widthBody, heightBody - tempH, 0, 0, imgRangBody, g, 1);
        }
        Animation.drawRegion(x, y + height + num * heightBody > h ? y + height + h : y + height + num * heightBody, width, height, 0, 0, imgRang, g, 3);
        g.setClip(0, 0, 240, 320);
        g.setColor(rectColor);
        g.fillRect(x + widthBody, y + height, width - 2 * widthBody, heightBody + num * heightBody > h ? h : num * heightBody);
    }

    public static void drawImgFrame(Graphics g, int dx, int dy, Image imgTop, Image imgFrame, int rectColor) {
        int imgTopW = imgTop.getWidth();
        int imgTopH = imgTop.getHeight();
        int imgFrameW = imgFrame.getWidth();
        int imgFrameH = imgFrame.getHeight();
        g.drawImage(imgTop, dx, dy, 20);
        g.drawImage(imgFrame, dx, dy + imgTopH, 20);
        Animation.drawRegion(dx, dy + imgTopH + imgFrameH, imgTopW, imgTopH, 0, 0, imgTop, g, 3);
        Animation.drawRegion(dx + imgTopW - imgFrameW, dy + imgTopH, imgFrameW, imgFrameH, 0, 0, imgFrame, g, 1);
        g.setClip(0, 0, 240, 320);
        g.setColor(rectColor);
        g.fillRect(dx + imgFrameW, dy + imgTopH, imgTopW - 2 * imgFrameW, imgFrameH);
    }
}

