/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Controllable;
import game.GameObject;
import game.Map;
import game.SceneGame;
import javax.microedition.lcdui.Graphics;
import main.MainCanvas;
import util.AniManager;
import util.Animation;
import util.MathTool;
import util.PhysicsTool;

public class Bombs
extends GameObject {
    AniManager am_bomb = null;
    protected boolean bombed = false;
    protected int m_speedup;
    protected int m_angle;
    protected int m_jumpTime = 0;
    protected int m_fallingTime = 0;
    protected byte m_path = 0;

    public Bombs(SceneGame game, Animation ani, int _x, int _y, byte path, boolean facing) {
        super(game, ani);
        this.m_catalog = 3;
        this.setPositionX(_x);
        this.setPositionY(_y);
        if (path == 1 || path == 2) {
            this.distY = -40;
            this.m_path = 0;
        } else if (path == 3) {
            this.distY = -40;
            this.m_path = 1;
        } else if (path == 5) {
            this.distY = -40;
            this.m_path = (byte)3;
        } else if (path == 4) {
            this.m_path = (byte)2;
        }
        if (this.m_path == 1) {
            this.m_angle = facing ? 180 : 0;
        } else if (this.m_path == 2 || this.m_path == 3) {
            this.m_angle = MathTool.getAngle(_x, _y, game.m_player.getX(), game.m_player.getY());
        } else {
            int m_upangle = MathTool.getAngle(_x, _y, game.map.moveleft, game.map.movedown);
            int m_downangle = MathTool.getAngle(_x, _y, game.map.moveleft, game.map.moveup);
            this.m_angle = MathTool.getRandom(m_upangle, m_downangle);
            if (!facing) {
                this.m_angle += 180;
            }
        }
        this.m_jumpTime = 0;
        this.m_fallingTime = 0;
        this.m_speedup = MathTool.getRandom(-40, -20);
        this.am_bomb = new AniManager(game.ani_bombexplore);
        this.getAniManager().setfacingx(facing);
        this.getAniManager().reSetFrame();
        this.am_bomb.reSetFrame();
    }

    public void init(byte type, byte initstate) {
    }

    public void update() {
        try {
            Controllable player = this.m_scene.m_player;
            if (player.canbeattack()) {
                int dist = this.GetVerticalDistance(player.getY());
                int[] attackrect = null;
                if (this.bombed) {
                    int[] data = new int[]{this.getX() + this.am_bomb.get_cBoxAtt_x(), this.getY() + this.am_bomb.get_cBoxAtt_y(), this.am_bomb.get_cBoxAtt_w(), this.am_bomb.get_cBoxAtt_h()};
                    attackrect = data;
                } else {
                    attackrect = this.getAttackBox();
                }
                attackrect[0] = attackrect[0] + this.distX;
                attackrect[1] = attackrect[1] + this.distY;
                int[] hitrect = player.getHittedBox();
                boolean attack = MainCanvas.collision(attackrect, hitrect);
                if (attack && dist < 10) {
                    int damage = 40;
                    player.reduceHealth(damage);
                    player.addMagic(damage << 1);
                    player.getAniManager().setfacingx(player.x_getFacingTo(this));
                    player.setPlayerState((byte)5);
                    player.m_hitted = true;
                    this.bombed = true;
                }
            }
            if (this.bombed) {
                if (this.am_bomb.nextFrame_toEnd()) {
                    this.setdead();
                }
            } else {
                this.loopAnimation();
                if (this.m_path != 2) {
                    boolean up = false;
                    up = this.updateJumping();
                    if (up && this.updateFalling()) {
                        this.bombed = true;
                        this.am_bomb.set_indexAnimate(0);
                    }
                }
                this.move(this.m_angle, 8, 8);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void render(Graphics g) {
        try {
            Map map = this.m_scene.getMap();
            int _x = map.getViewportX() + this.getX() - map.getCameraX() + this.distX;
            int _y = map.getViewportY() + this.getY() - map.getCameraY() + this.distY;
            int shadowx = _x - this.distX;
            int shadowy = _y - this.distY;
            g.drawImage(this.m_scene.img_smallshadow, shadowx, shadowy, 3);
            if (this.bombed) {
                this.am_bomb.draw(g, _x, _y);
            } else {
                this.getAniManager().draw(g, _x, _y);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isDead() {
        return this.m_dead;
    }

    public boolean isDying() {
        return this.m_dying;
    }

    protected boolean updateJumping() {
        if (PhysicsTool.GetCurSpeed(this.m_speedup, 4, this.m_jumpTime) >= 0) {
            return true;
        }
        int tempspeed = PhysicsTool.GetCurSpeed(this.m_speedup, 4, this.m_jumpTime);
        this.distY += PhysicsTool.GetDistPerFrame(tempspeed, 4);
        ++this.m_jumpTime;
        return false;
    }

    protected boolean updateFalling() {
        int tempspeed = PhysicsTool.GetCurSpeed(0, 4, this.m_fallingTime);
        this.distY += PhysicsTool.GetDistPerFrame(tempspeed, 4);
        ++this.m_fallingTime;
        if (this.distY > 0) {
            this.distY = 0;
            return true;
        }
        return false;
    }

    public void move(int angle, int stepx, int stepy) {
        int tempx = this.getX() + MathTool.getRadiusX(angle, stepx);
        int tempy = this.getY() + MathTool.getRadiusY(angle, stepy);
        this.setPositionX(tempx);
        this.setPositionY(tempy);
        if (tempy < this.m_scene.map.moveup || tempy > this.m_scene.map.movedown || tempx < this.m_scene.map.moveleft || tempx > this.m_scene.map.moveright) {
            this.setdead();
        }
    }
}

