/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.AutoPlayManager;
import game.Bombs;
import game.Controllable;
import game.Effect;
import game.Enemy;
import game.GameObject;
import game.Items;
import game.Map;
import game.Weapon;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.MainCanvas;
import menu.SceneMenu;
import util.AniManager;
import util.Animation;
import util.GraphicsTool;
import util.Key;
import util.Load;
import util.MathTool;
import util.RMS;
import util.Scene;
import util.TextUtil;
import util.Utility;

public class SceneGame
extends Scene {
    static boolean is_bTestVersion = false;
    public byte godCounter = 0;
    public static final int[] GOD_CODE = new int[]{32, 128, 32, 2048, 8192, 2048};
    public static final int MAX_GAMEOBJECT = 10;
    public static final int MAX_WEAPON = 2;
    public static final int MAX_ITEMS = 3;
    public static final int MAX_GRENADE = 5;
    public static final byte GAME_LOAD = 0;
    public static final byte GAME_RUN = 1;
    public static final byte GAME_TONEXT = 2;
    public static final byte GAME_WIN = 3;
    public static final byte GAME_FAIL = 4;
    private Image img_rogue = null;
    private Image img_fatman = null;
    private Image img_bitch = null;
    private Image img_motoman = null;
    private Image img_boss = null;
    private Image img_hero = null;
    private Image img_effect = null;
    private Image img_touch = null;
    private Image img_go = null;
    private Image img_item = null;
    private Image img_itemdisappear = null;
    private Image img_bomb = null;
    private Image img_fire = null;
    private Image img_bombexplore = null;
    private Image img_grenade = null;
    private Image img_light0 = null;
    private Image img_light1 = null;
    public Animation ani_light0 = null;
    public Animation ani_light1 = null;
    private Image img_train = null;
    public Image img_tb0 = null;
    public Image img_tb1 = null;
    public Image img_bb0 = null;
    public Image img_bb1 = null;
    public Animation ani_bb0 = null;
    public Animation ani_bb1 = null;
    public Image img_fz = null;
    public Animation ani_fz = null;
    public Image img_win0 = null;
    public Image img_win1 = null;
    public Image img_pai0 = null;
    public Image img_pai1 = null;
    public Image img_pai2 = null;
    public Image img_pai3 = null;
    public Image img_pai4 = null;
    public Image img_pai5 = null;
    public Image img_streetbitch = null;
    public Image img_pip0 = null;
    public Image img_pip1 = null;
    public Image img_pip2 = null;
    public Animation ani_streetbitch = null;
    public Animation ani_pai0 = null;
    public Animation ani_pai1 = null;
    public Animation ani_pai2 = null;
    public Animation ani_pai3 = null;
    public Image img_light = null;
    public Image img_steel = null;
    public Image img_pail = null;
    public Image img_net = null;
    public Image img_man0 = null;
    public Image img_man1 = null;
    public Image img_man2 = null;
    public Image img_man3 = null;
    public Animation ani_man0 = null;
    public Animation ani_man1 = null;
    public Animation ani_man2 = null;
    public Animation ani_man3 = null;
    public Animation ani_light = null;
    public Image img_largeshadow = null;
    public Image img_smallshadow = null;
    private Image img_herohead = null;
    private Image img_coin = null;
    private Image img_coinnum = null;
    private Image img_magicnum = null;
    private Image[] img_hitnum = null;
    private Image img_hit = null;
    private Image img_result = null;
    public Animation ani_rogue1 = null;
    public Animation ani_rogue2 = null;
    public Animation ani_fatman = null;
    public Animation ani_bitch = null;
    public Animation ani_motoman = null;
    public Animation ani_boss = null;
    public Animation ani_hero = null;
    public Animation ani_effect = null;
    public Animation ani_item = null;
    public Animation ani_itemdisappear = null;
    public Animation ani_bomb = null;
    public Animation ani_fire = null;
    public Animation ani_bombexplore = null;
    public Animation ani_grenade = null;
    public Animation ani_train = null;
    public AniManager animan_train = null;
    public Controllable m_player = null;
    public Enemy[] enemy = null;
    public GameObject[] renderlist = null;
    public int renderindex = 0;
    public final int WN;
    public Image[] img_weapon = new Image[5];
    public Animation[] ani_heroweapon = new Animation[5];
    public Animation[] ani_rogueweapon = new Animation[5];
    public Animation[] ani_ongroundweapon = new Animation[5];
    AutoPlayManager m_actionqueue = null;
    public boolean areaclear = false;
    public boolean stageclear = false;
    public boolean missionclear = false;
    public boolean bossappear = false;
    public long waitingforenemy = 0L;
    Map map = null;
    Image img_map = null;
    public int m_screenx = 0;
    public int m_screeny = 0;
    public int m_screenw = 0;
    public int m_screenh = 0;
    public int COLOR_CUTSCREEN = 0;
    public boolean m_cutscreen = false;
    public int m_cutscreenheight = 0;
    public int m_cutscreenspeed = 0;
    public int m_coin = 0;
    public int m_health = 0;
    public int m_magic = 0;
    public final int MAX_EFFECT;
    public Effect[] m_effect = new Effect[6];
    static int[] drawID;
    int ID1 = 0;
    int ID2 = 0;
    int posy1;
    int posy2;
    int tmp;
    public int traintime = 2500;
    public int trainsep = 6000;
    public long flashTime = 0L;
    public long lasttrain = 0L;
    public boolean showtrain = false;
    public int trainindex = 0;
    protected boolean nextstageloaded = false;
    protected int y_black = 0;

    private void cheat() {
        if (Key.IsAnyKeyPressed()) {
            this.godCounter = Key.IsKeyPressed(GOD_CODE[this.godCounter]) ? (byte)(this.godCounter + 1) : (byte)0;
        }
        if (this.godCounter == GOD_CODE.length) {
            is_bTestVersion = !is_bTestVersion;
            this.godCounter = 0;
        }
    }

    public SceneGame(MainCanvas canvas, int state) {
        super(canvas, state);
        this.WN = 5;
        this.MAX_EFFECT = 6;
    }

    public Controllable getPlayer() {
        return this.m_player;
    }

    public Map getMap() {
        return this.map;
    }

    protected void start() {
        try {
            if (this.m_initialState == -1 || this.m_initialState == 0) {
                this.resetScreen();
                this.InitCutScreenData();
                this.renderlist = new GameObject[20];
                this.m_state = 0;
                this.m_canvas.load = new Load();
            } else {
                this.m_state = this.m_initialState;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void pause() {
        Key.ClearKey();
        MainCanvas.allPaused = true;
        MainCanvas.m_music.Suspend();
        if (this.m_state == 1) {
            this.ActivePauseMenu();
            if (this.m_player.m_state == 1) {
                this.m_player.setPlayerState((byte)0);
            }
            MainCanvas.m_GamePaused = true;
        }
    }

    public void ActivePauseMenu() {
        MainCanvas.m_GamePaused = true;
        SceneMenu.height_logo = 10;
        SceneMenu.maxheight_db = 320 - SceneMenu.height_softbar - SceneMenu.height_logo - 6;
        SceneMenu.text_h = SceneMenu.height_softbar = MainCanvas.FontHeight;
        SceneMenu.maxsize_db = (SceneMenu.maxheight_db - (MainCanvas.corner_h << 1)) / SceneMenu.text_h;
        if (SceneMenu.maxsize_db == 0) {
            SceneMenu.maxsize_db = 1;
        }
        SceneMenu.ActiveMenuPage(13);
        if (this.m_player.m_state == 1) {
            this.m_player.setPlayerState((byte)0);
        }
    }

    public void resume() {
        Key.ClearKey();
    }

    public void end() {
    }

    public void render(Graphics g) {
        try {
            if (this.m_state != 0 && !this.IsInited()) {
                return;
            }
            GraphicsTool.FillRect(g, 0, 0, 0, 240, 320);
            if (this.m_state == 1 || this.m_state == 3 || this.m_state == 4 || this.m_state == 2) {
                this.map.render(g);
                this.map.drawback(g);
                if (MainCanvas.missionid == 0) {
                    this.render_train(g);
                }
                this.map.drawfront(g);
                if (this.m_player.checkbombed()) {
                    MainCanvas.drawblack(g);
                }
                this.sort(this.renderlist);
                for (int i = 0; i < this.renderlist.length; ++i) {
                    if (this.renderlist[drawID[i]] == null) continue;
                    if (this.renderlist[drawID[i]].getCatlog() == 1) {
                        ((Weapon)this.renderlist[drawID[i]]).renderweapononground(g);
                        continue;
                    }
                    this.renderlist[drawID[i]].render(g);
                }
                this.drawEffects(g);
                this.rendergonext(g);
                this.rendergameui(g);
                if (is_bTestVersion) {
                    TextUtil.Font_RenderStringsVectorSingle(g, TextUtil.Font_SplitString("\u6d4b\u8bd5\u6a21\u5f0f", MainCanvas.m_font, MainCanvas.contentmax), MainCanvas.m_font, 120, 0, 17, 0xFFFFFF);
                }
                if (!(this.m_state != 3 && this.m_state != 4 || MainCanvas.m_GamePaused)) {
                    MainCanvas.drawblack(g);
                    g.drawImage(this.img_result, 120, 160, 3);
                    String s = "\u4e2d\u5fc3\u952e(\u62165\u952e)\u7ee7\u7eed";
                    TextUtil.Font_RenderStringsVectorSingle(g, TextUtil.Font_SplitString(s, MainCanvas.m_font, MainCanvas.contentmax), MainCanvas.m_font, 120, 320, 33, 0xFFFFFF);
                }
                if (this.m_state == 2) {
                    this.blackscreen(g);
                }
                if (this.m_state == 1) {
                    MainCanvas.drawArrow(g, 1, 0, 320, 36);
                }
                if (this.m_cutscreen) {
                    this.drawCutScreen(g);
                }
                if (MainCanvas.m_GamePaused) {
                    MainCanvas.drawblack(g);
                    SceneMenu.DrawMenuPage(g);
                    return;
                }
            } else if (this.m_state == 0) {
                this.m_canvas.load.draw(g, this.getLoadingProgress());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void processKeys() {
        if (this.m_state != 0 && !this.IsInited()) {
            return;
        }
        if (MainCanvas.m_GamePaused) {
            SceneMenu.ProcessMenuPageKeys();
            return;
        }
        if (this.m_state == 1) {
            if (Key.IsKeyPressed(65536)) {
                this.ActivePauseMenu();
            } else {
                if (this.m_cutscreen) {
                    return;
                }
                this.cheat();
                this.m_player.processkey();
            }
        } else if (this.m_state == 3) {
            if (Key.IsKeyPressed(262144)) {
                Key.ClearKey();
                if (MainCanvas.MissionOpened < 3) {
                    if (MainCanvas.missionid == MainCanvas.MissionOpened - 1) {
                        ++MainCanvas.MissionOpened;
                    }
                    RMS.Save();
                    this.m_canvas.changeScene(2, 5);
                } else if (MainCanvas.missionid == 2) {
                    MainCanvas.m_GamePaused = true;
                    SceneMenu.height_logo = 10;
                    SceneMenu.maxheight_db = 320 - SceneMenu.height_softbar - SceneMenu.height_logo - 6;
                    SceneMenu.text_h = SceneMenu.height_softbar = MainCanvas.FontHeight;
                    SceneMenu.maxsize_db = (SceneMenu.maxheight_db - (MainCanvas.corner_h << 1)) / SceneMenu.text_h;
                    if (SceneMenu.maxsize_db == 0) {
                        SceneMenu.maxsize_db = 1;
                    }
                    SceneMenu.ActiveMenuPage(26);
                } else {
                    this.m_canvas.changeScene(2, 5);
                }
            }
        } else if (this.m_state == 4 && Key.IsKeyPressed(262144)) {
            this.m_canvas.changeScene(2, 4);
        }
    }

    public void update() {
        try {
            if (this.m_state != 0 && !this.IsInited()) {
                return;
            }
            if (MainCanvas.m_GamePaused) {
                return;
            }
            if (this.m_state == 1 || this.m_state == 3 || this.m_state == 4 || this.m_state == 2) {
                ++this.m_iCount;
                if (this.m_cutscreen) {
                    this.CompleteCutScreen();
                }
                this.map.updateMap();
                if (MainCanvas.missionid == 0) {
                    this.update_train();
                }
                if (this.renderlist != null) {
                    for (int i = 0; i < this.renderlist.length; ++i) {
                        if (this.renderlist[i] == null) continue;
                        int cat = this.renderlist[i].getCatlog();
                        if (cat == 1) {
                            Weapon weapon = (Weapon)this.renderlist[i];
                            if (!this.map.disapear(weapon)) continue;
                            this.renderlist[i] = null;
                            continue;
                        }
                        if (cat == 2) {
                            Items item = (Items)this.renderlist[i];
                            if (this.map.disapear(item)) {
                                this.renderlist[i] = null;
                            }
                            if (item.isDead()) {
                                this.renderlist[i] = null;
                            }
                            if (item == null) continue;
                            item.update();
                            continue;
                        }
                        if (cat == 3) {
                            if (this.renderlist[i].isDead()) {
                                this.renderlist[i] = null;
                                continue;
                            }
                            ((Bombs)this.renderlist[i]).update();
                            continue;
                        }
                        if (this.renderlist[i].isDead()) {
                            this.renderlist[i] = null;
                            continue;
                        }
                        this.renderlist[i].update();
                    }
                }
                this.map.updateCamera(this.m_player);
                this.updateEffects();
                this.updategonext();
                this.updatewaitingfor();
                if (this.m_state == 2) {
                    this.nextstage_load();
                }
            } else if (this.m_state == 0) {
                this.updateLoading();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updategonext() {
        if (this.m_state == 1) {
            if (this.stageclear) {
                if (this.m_player.getX() > this.map.mapright) {
                    this.m_state = 2;
                    this.stageclear = false;
                    this.y_black = 0;
                    this.nextstageloaded = false;
                }
            } else if (this.areaclear && this.map.inthearea(this.m_player)) {
                this.areaclear = false;
            }
        }
    }

    private void rendergonext(Graphics g) {
        if ((this.areaclear || this.stageclear) && MathTool.getModInt(this.m_iCount, 10) != 0 && MathTool.getModInt(this.m_iCount, 10) != 1) {
            int _x = 230;
            int _y = 320 - (this.map.getTileHeight() << 2);
            g.drawImage(this.img_go, _x, _y, 40);
        }
    }

    private void rendergameui(Graphics g) {
        try {
            int barw = 0;
            g.drawImage(this.img_herohead, 0, 0, 20);
            int barx = this.img_herohead.getWidth();
            int bary = 6;
            int barh = 5;
            int hb_w = 100;
            int mb_w = 70;
            g.setColor(0x4F4F4F);
            g.fillRect(barx, bary, hb_w + 4, barh + 4);
            if (this.m_player.m_health < this.m_player.m_maxHealth / 6 && MathTool.getModInt(this.m_iCount, 2) == 0) {
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(0);
            }
            g.fillRect(barx + 1, bary + 1, hb_w + 2, barh + 2);
            g.setColor(0xF80000);
            g.fillRect(barx + 2, bary + 2, hb_w, barh);
            barw = this.m_player.m_health * hb_w / this.m_player.m_maxHealth;
            if (this.m_player.m_health > 0 && barw == 0) {
                barw = 1;
            }
            g.setColor(14853376);
            g.fillRect(barx + 2, bary + 1 + 1, barw, 1);
            g.setColor(0xF8F800);
            g.fillRect(barx + 2, bary + 1 + 2, barw, barh - 2);
            g.setColor(14853376);
            g.fillRect(barx + 2, bary + 1 + barh, barw, 1);
            g.setColor(0x4F4F4F);
            g.fillRect(barx, bary += barh + 6, mb_w + 4, barh + 4);
            int magicnum = MathTool.getDiv(this.m_player.m_magic, 200);
            int magic = MathTool.getModInt(this.m_player.m_magic, 200);
            if (this.m_player.m_magic == this.m_player.m_maxMagic && MathTool.getModInt(this.m_iCount, 2) == 0 || this.m_player.m_magicchange) {
                g.setColor(0xFFFFFF);
            } else {
                g.setColor(0);
            }
            g.fillRect(barx + 1, bary + 1, mb_w + 2, barh + 2);
            g.setColor(141948);
            g.fillRect(barx + 2, bary + 2, mb_w, barh);
            barw = magicnum == 9 ? mb_w : magic * mb_w / 200;
            if (magic > 0 && barw == 0) {
                barw = 1;
            }
            g.setColor(40929);
            g.fillRect(barx + 2, bary + 1 + 1, barw, 1);
            g.setColor(2021883);
            g.fillRect(barx + 2, bary + 1 + 2, barw, barh - 2);
            g.setColor(40929);
            g.fillRect(barx + 2, bary + 1 + barh, barw, 1);
            if (magicnum > 0) {
                int perw = this.img_magicnum.getWidth() / 11;
                int perh = this.img_magicnum.getHeight();
                int disth = barh + 6 - perh >> 1;
                String str = Integer.toString(magicnum);
                char num = str.charAt(0);
                int index = num - 48;
                int x = barx + mb_w + 4 + 4;
                int y = bary + disth;
                GraphicsTool.DrawRegion(g, this.img_magicnum, 10 * perw, 0, perw, perh, x, y, 20);
                GraphicsTool.DrawRegion(g, this.img_magicnum, index * perw, 0, perw, perh, x + perw, y, 20);
                GraphicsTool.ClipAll(g);
            }
            this.m_player.m_magicchange = false;
            g.drawImage(this.img_coin, barx, bary += barh + 6, 20);
            int coin_x = barx + this.img_coin.getWidth() + 2;
            int coin_y = bary + (this.img_coin.getHeight() - this.img_coinnum.getHeight()) / 2;
            this.drawnum(g, this.m_coin, this.img_coinnum, coin_x, coin_y, 20);
            barx = 35;
            bary = this.img_herohead.getHeight() + 20;
            if (this.m_player.m_hitnum <= 0) {
                return;
            }
            if (this.m_player.m_hitnum > 99) {
                this.m_player.m_hitnum = 99;
            }
            this.drawattacknum(g, barx, bary);
            g.drawImage(this.img_hit, barx, bary, 6);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void drawattacknum(Graphics _g, int _x, int _y) {
        if (this.m_player.m_hitnum >= 100) {
            return;
        }
        boolean change = this.m_player.m_oldhitnum != this.m_player.m_hitnum;
        int hit = 0;
        int index = 0;
        int nx = 0;
        int ny = 0;
        if (change) {
            hit = 1;
        }
        int[] perw = new int[2];
        int[] perh = new int[2];
        perw[0] = this.img_hitnum[0].getWidth() / 10;
        perh[0] = this.img_hitnum[0].getHeight();
        perw[1] = this.img_hitnum[1].getWidth() / 10;
        perh[1] = this.img_hitnum[1].getHeight();
        String str = Integer.toString(this.m_player.m_hitnum);
        char[] data = str.toCharArray();
        if (this.m_player.m_hitnum < 10) {
            nx = _x - perw[hit];
            ny = _y - (perh[hit] >> 1);
            index = data[0] - 48;
            GraphicsTool.DrawRegion(_g, this.img_hitnum[hit], index * perw[hit], 0, perw[hit], perh[hit], nx, ny, 20);
        } else {
            int on_old;
            int on_now = MathTool.getDiv(this.m_player.m_hitnum, 10);
            if (on_now == (on_old = MathTool.getDiv(this.m_player.m_oldhitnum, 10))) {
                nx = _x - (perw[0] << 1);
                ny = _y - (perh[0] >> 1);
                index = data[0] - 48;
                GraphicsTool.DrawRegion(_g, this.img_hitnum[0], index * perw[0], 0, perw[0], perh[0], nx, ny, 20);
                nx = _x - perw[0] + (perw[0] - perw[1] >> 1);
                ny = _y - (perh[hit] >> 1);
                index = data[1] - 48;
                GraphicsTool.DrawRegion(_g, this.img_hitnum[hit], index * perw[hit], 0, perw[hit], perh[hit], nx, ny, 20);
            } else {
                int w = data.length * perw[hit];
                int h = perh[hit];
                nx = _x - w;
                ny = _y - (h >> 1);
                for (int i = 0; i < data.length; ++i) {
                    index = data[i] - 48;
                    GraphicsTool.DrawRegion(_g, this.img_hitnum[hit], index * perw[hit], 0, perw[hit], perh[hit], nx + perw[hit] * i, ny, 20);
                }
            }
        }
        this.m_player.m_oldhitnum = this.m_player.m_hitnum;
        GraphicsTool.ClipAll(_g);
    }

    public void drawnum(Graphics _g, int _num, Image _img, int _x, int _y, int _flag) {
        if (_num < 0) {
            return;
        }
        String str = Integer.toString(_num);
        int index = 0;
        int perw = _img.getWidth() / 10;
        int perh = _img.getHeight();
        char[] data = str.toCharArray();
        int w = data.length * perw;
        int h = perh;
        if ((_flag & 1) != 0) {
            _x -= w >> 1;
        }
        if ((_flag & 8) != 0) {
            _x -= w;
        }
        if ((_flag & 2) != 0) {
            _y -= h >> 1;
        }
        if ((_flag & 0x20) != 0) {
            _y -= h;
        }
        for (int i = 0; i < data.length; ++i) {
            index = data[i] - 48;
            GraphicsTool.DrawRegion(_g, _img, index * perw, 0, perw, perh, _x + perw * i, _y, 20);
        }
        GraphicsTool.ClipAll(_g);
    }

    public void updateLoading() {
        try {
            int PROGRESS_AFTER_GAMEUI = 10;
            int PROGRESS_AFTER_GAMEIMAGE = 35;
            int PROGRESS_AFTER_MAPIMG = 50;
            int PROGRESS_AFTER_HERO = 60;
            int PROGRESS_AFTER_ENEMY = 70;
            int PROGRESS_AFTER_MAPDATA = 90;
            int PROGRESS_MAX = 100;
            if (this.m_loadingProgress <= 100) {
                if (this.m_loadingProgress < 10) {
                    this.img_go = Image.createImage((String)"/go.png");
                    this.img_coin = Image.createImage((String)"/coin.png");
                    this.img_coinnum = Image.createImage((String)"/num2.png");
                    this.img_herohead = Image.createImage((String)"/head.png");
                    this.img_hitnum = new Image[2];
                    this.img_hitnum[0] = Image.createImage((String)"/num0.png");
                    this.img_hitnum[1] = Image.createImage((String)"/num1.png");
                    this.img_hit = Image.createImage((String)"/a0.png");
                    this.img_magicnum = Image.createImage((String)"/num3.png");
                    this.m_loadingProgress = 10;
                } else if (this.m_loadingProgress < 35) {
                    this.img_effect = Image.createImage((String)"/effect.png");
                    this.ani_effect = new Animation("/e.dat", this.img_effect);
                    this.img_item = Image.createImage((String)"/item.png");
                    this.ani_item = new Animation("/item.dat", this.img_item);
                    this.img_itemdisappear = Image.createImage((String)"/ie.png");
                    this.ani_itemdisappear = new Animation("/ie.dat", this.img_itemdisappear);
                    this.img_largeshadow = Image.createImage((String)"/shadow0.png");
                    this.img_smallshadow = Image.createImage((String)"/shadow1.png");
                    this.img_bomb = Image.createImage((String)"/bomb.png");
                    this.ani_bomb = new Animation("/bomb.dat", this.img_bomb);
                    this.img_fire = Image.createImage((String)"/fire.png");
                    this.ani_fire = new Animation("/fire.dat", this.img_fire);
                    this.img_bombexplore = Image.createImage((String)"/bombexplore.png");
                    this.ani_bombexplore = new Animation("/bombexplore.dat", this.img_bombexplore);
                    this.img_grenade = Image.createImage((String)"/grenade.png");
                    this.ani_grenade = new Animation("/grenade.dat", this.img_grenade);
                    for (int i = 0; i < 5; ++i) {
                        this.img_weapon[i] = Image.createImage((String)("/w" + i + ".png"));
                        this.ani_heroweapon[i] = new Animation(new String("/wh" + i + ".dat"), this.img_weapon[i]);
                        this.ani_rogueweapon[i] = new Animation(new String("/wr" + i + ".dat"), this.img_weapon[i]);
                        this.ani_ongroundweapon[i] = new Animation(new String("/wo" + i + ".dat"), this.img_weapon[i]);
                    }
                    this.m_loadingProgress = 35;
                } else if (this.m_loadingProgress < 50) {
                    switch (MainCanvas.missionid) {
                        case 0: {
                            MainCanvas.max_area = 4;
                            break;
                        }
                        case 1: {
                            MainCanvas.max_area = 4;
                            break;
                        }
                        case 2: {
                            MainCanvas.max_area = 4;
                        }
                    }
                    this.map = new Map(this);
                    String img_mission = new String("/im" + MainCanvas.missionid + ".png");
                    this.img_map = Image.createImage((String)img_mission);
                    this.map.SetMapImage(this.img_map);
                    if (MainCanvas.missionid == 0) {
                        this.img_light0 = Image.createImage((String)"/l0.png");
                        this.ani_light0 = new Animation("/l0.dat", this.img_light0);
                        this.img_light1 = Image.createImage((String)"/l1.png");
                        this.ani_light1 = new Animation("/l1.dat", this.img_light1);
                        this.img_bb0 = Image.createImage((String)"/bb0.png");
                        this.ani_bb0 = new Animation("/bb0.dat", this.img_bb0);
                        this.img_bb1 = Image.createImage((String)"/bb1.png");
                        this.ani_bb1 = new Animation("/bb1.dat", this.img_bb1);
                        this.img_tb0 = Image.createImage((String)"/tb0.png");
                        this.img_tb1 = Image.createImage((String)"/tb1.png");
                        this.img_fz = Image.createImage((String)"/fz.png");
                        this.ani_fz = new Animation("/fz.dat", this.img_fz);
                    } else if (MainCanvas.missionid == 1) {
                        this.img_win0 = Image.createImage((String)"/win0.png");
                        this.img_win1 = Image.createImage((String)"/win1.png");
                        this.img_pai0 = Image.createImage((String)"/p0.png");
                        this.img_pai1 = Image.createImage((String)"/p1.png");
                        this.img_pai2 = Image.createImage((String)"/p3.png");
                        this.img_pai3 = Image.createImage((String)"/pai3.png");
                        this.img_pai4 = Image.createImage((String)"/pai4.png");
                        this.img_pai5 = Image.createImage((String)"/p2.png");
                        this.img_streetbitch = Image.createImage((String)"/street.png");
                        this.img_pip0 = Image.createImage((String)"/pip0.png");
                        this.img_pip1 = Image.createImage((String)"/pip1.png");
                        this.img_pip2 = Image.createImage((String)"/pip2.png");
                        this.ani_streetbitch = new Animation("/street.dat", this.img_streetbitch);
                        this.ani_pai0 = new Animation("/p0.dat", this.img_pai0);
                        this.ani_pai1 = new Animation("/p1.dat", this.img_pai1);
                        this.ani_pai2 = new Animation("/p3.dat", this.img_pai2);
                        this.ani_pai3 = new Animation("/p2.dat", this.img_pai5);
                    } else if (MainCanvas.missionid == 2) {
                        this.img_steel = Image.createImage((String)"/steel.png");
                        this.img_pail = Image.createImage((String)"/pail.png");
                        this.img_net = Image.createImage((String)"/net.png");
                        this.img_man0 = Image.createImage((String)"/npc31.png");
                        this.img_man1 = Image.createImage((String)"/npc32.png");
                        this.img_man2 = Image.createImage((String)"/npc33.png");
                        this.img_man3 = Image.createImage((String)"/npc34.png");
                        this.ani_man0 = new Animation("/npc31.dat", this.img_man0);
                        this.ani_man1 = new Animation("/npc32.dat", this.img_man1);
                        this.ani_man2 = new Animation("/npc33.dat", this.img_man2);
                        this.ani_man3 = new Animation("/npc34.dat", this.img_man3);
                        this.img_light = Image.createImage((String)"/huo.png");
                        this.ani_light = new Animation("/huo.dat", this.img_light);
                    }
                    this.img_train = Image.createImage((String)"/train.png");
                    this.ani_train = new Animation("/train.dat", this.img_train);
                    this.animan_train = new AniManager(this.ani_train);
                    this.m_loadingProgress = 50;
                } else if (this.m_loadingProgress < 60) {
                    this.m_health = 1000;
                    this.m_magic = 0;
                    this.img_hero = Image.createImage((String)"/hero.png");
                    this.ani_hero = new Animation("/hero.dat", this.img_hero);
                    this.m_loadingProgress = 60;
                } else if (this.m_loadingProgress < 70) {
                    this.img_rogue = Image.createImage((String)"/rogue.png");
                    this.ani_rogue1 = new Animation("/r1.dat", this.img_rogue);
                    this.ani_rogue2 = new Animation("/r2.dat", this.img_rogue);
                    this.img_fatman = Image.createImage((String)"/fat.png");
                    this.ani_fatman = new Animation("/fat.dat", this.img_fatman);
                    this.img_bitch = Image.createImage((String)"/bitch.png");
                    this.ani_bitch = new Animation("/bitch.dat", this.img_bitch);
                    this.img_motoman = Image.createImage((String)"/moto.png");
                    this.ani_motoman = new Animation("/moto.dat", this.img_motoman);
                    if (MainCanvas.missionid != 1) {
                        this.img_boss = Image.createImage((String)"/joker.png");
                        this.ani_boss = new Animation("/joker.dat", this.img_boss);
                    }
                    this.m_loadingProgress = 70;
                } else if (this.m_loadingProgress < 90) {
                    MainCanvas.areaid = 0;
                    String data_area = new String("/dm" + MainCanvas.missionid + "0.mdb");
                    this.map.LoadMap(new DataInputStream(this.getClass().getResourceAsStream(data_area)));
                    this.map.setViewport(0, 0, 240, 320);
                    this.map.setUseMapBuffer(false);
                    this.m_loadingProgress = 90;
                } else if (this.m_loadingProgress < 100) {
                    this.m_loadingProgress = 100;
                } else {
                    this.map.setCamera(this.m_player);
                    this.m_iCount = 0;
                    this.lasttrain = Utility.GetTime();
                    this.m_inited = true;
                    this.nextstageloaded = true;
                    this.missionclear = false;
                    this.y_black = 160;
                    this.m_state = 2;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void resetScreen() {
        this.m_screenx = 0;
        this.m_screeny = 0;
        this.m_screenw = 240;
        this.m_screenh = 320;
    }

    public void setScreen(int distx, int disty) {
        this.m_screenx = distx;
        this.m_screeny = disty;
        this.m_screenw = 240 - (distx << 1);
        this.m_screenh = 320 - (disty << 1);
    }

    public void StartCutScreen() {
        Key.ClearKey();
        this.m_cutscreen = true;
    }

    public void ReleaseCutScreen() {
        this.m_cutscreen = false;
        this.resetScreen();
    }

    public void InitCutScreenData() {
        this.m_cutscreenheight = 80;
        this.m_cutscreenspeed = this.m_cutscreenheight / 5;
    }

    public boolean CompleteCutScreen() {
        if (this.m_screeny == this.m_cutscreenheight) {
            return true;
        }
        this.m_screeny += this.m_cutscreenspeed;
        this.setScreen(this.m_screenx, this.m_screeny);
        return false;
    }

    public void drawCutScreen(Graphics g) {
        GraphicsTool.FillRect(g, this.COLOR_CUTSCREEN, 0, 0, 240, this.m_screeny);
        GraphicsTool.FillRect(g, this.COLOR_CUTSCREEN, 0, 320 - this.m_screeny, 240, this.m_screeny);
    }

    public void StartDialog() {
    }

    public boolean CompleteDialog() {
        return false;
    }

    public void drawDialog(Graphics g) {
    }

    public boolean checkmovetonextarea() {
        return false;
    }

    public boolean CheckMove(GameObject go, int tx, int ty) {
        boolean isplayer = go.equals(this.m_player);
        return !(isplayer ? (this.stageclear ? tx < this.map.moveleft || ty < this.map.moveup || ty > this.map.movedown : tx < this.map.moveleft || tx > this.map.moveright || ty < this.map.moveup || ty > this.map.movedown) : ty < this.map.moveup || ty > this.map.movedown);
    }

    public void renewlist(int _area) {
        this.renderindex = 0;
        if (_area < 0) {
            _area = 0;
        }
        int left = 0;
        if (_area > 0) {
            left = this.map.range[_area - 1];
        }
        int right = this.map.mapright;
        if (_area <= this.map.range.length - 1) {
            right = this.map.range[_area];
        }
        int i = 0;
        int enemylength = this.enemy.length;
        Weapon[] weapon = new Weapon[2];
        weapon = this.checkWeapon();
        Items[] items = new Items[3];
        items = this.checkitems();
        this.renderlist = new GameObject[20];
        for (i = 0; i < enemylength; ++i) {
            int _x = this.enemy[i].getX();
            if (_x <= left || _x >= right) continue;
            this.settolist(this.enemy[i]);
            if (this.enemy[i].getObjectType() != 4 && (this.enemy[i].getObjectType() != 3 || MainCanvas.missionid != 1)) continue;
            this.bossappear = true;
        }
        this.settolist(this.m_player);
        for (i = 0; i < 2; ++i) {
            if (weapon[i] == null) continue;
            this.settolist(weapon[i]);
        }
        for (i = 0; i < 3; ++i) {
            if (items[i] == null) continue;
            this.settolist(items[i]);
        }
    }

    public void settolist(GameObject go) {
        int i = 0;
        int length = 20;
        for (i = 0; i < length; ++i) {
            if (this.renderlist[i] != null) continue;
            this.renderlist[i] = go;
            return;
        }
    }

    public boolean checkitemdrop() {
        int ava = this.itemavailable();
        int max = 3;
        return ava > 0 && ava <= max;
    }

    public int itemavailable() {
        int i = 0;
        int length = 20;
        int num = 3;
        for (i = 0; i < length; ++i) {
            if (this.renderlist[i] == null || this.renderlist[i].getCatlog() != 2) continue;
            --num;
        }
        return num;
    }

    public void addItem(Items item) {
        this.settolist(item);
    }

    public Items[] checkitems() {
        Items[] items = new Items[3];
        int index = 0;
        int i = 0;
        int length = 20;
        for (i = 0; i < length; ++i) {
            if (this.renderlist[i] == null || this.renderlist[i].getCatlog() != 2) continue;
            items[index] = (Items)this.renderlist[i];
            ++index;
        }
        return items;
    }

    public boolean checkweapondrop() {
        int ava = this.weaponavailable();
        int maxweapon = 3;
        if (this.m_player.m_keepweapon) {
            maxweapon = 2;
        }
        return ava > 0 && ava <= maxweapon;
    }

    public int weaponavailable() {
        int i = 0;
        int length = 20;
        int num = 2;
        for (i = 0; i < length; ++i) {
            if (this.renderlist[i] == null || this.renderlist[i].getCatlog() != 1) continue;
            --num;
        }
        return num;
    }

    public void addWeapon(int _type, int _x, int _y) {
        Weapon temp_weapon = new Weapon(this, this.ani_ongroundweapon[_type], _type);
        _x = this.map.x_rangeinview(_x);
        _y = this.map.y_rangeinview(_y);
        temp_weapon.setPositionX(_x);
        temp_weapon.setPositionY(_y);
        this.settolist(temp_weapon);
    }

    public Weapon[] checkWeapon() {
        Weapon[] weapon = new Weapon[2];
        int index = 0;
        int i = 0;
        int length = 20;
        for (i = 0; i < length; ++i) {
            if (this.renderlist[i] == null || this.renderlist[i].getCatlog() != 1) continue;
            weapon[index] = (Weapon)this.renderlist[i];
            ++index;
        }
        return weapon;
    }

    public boolean checkareaclear() {
        int i = 0;
        int length = this.renderlist.length;
        for (i = 0; i < length; ++i) {
            if (this.renderlist[i] == null || this.renderlist[i].getCatlog() != 0 || this.renderlist[i].getObjectType() == 4 || this.renderlist[i].getObjectType() == 3 && MainCanvas.missionid == 1 || this.renderlist[i].equals(this.m_player) || this.renderlist[i].isDead()) continue;
            return false;
        }
        return true;
    }

    public int geteffectindex() {
        int i = 0;
        for (i = 0; i < 6; ++i) {
            if (this.m_effect[i] != null) continue;
            return i;
        }
        return 0;
    }

    public void updateEffects() {
        int i = 0;
        for (i = 0; i < 6; ++i) {
            if (this.m_effect[i] == null || !this.m_effect[i].IsOver()) continue;
            this.m_effect[i] = null;
        }
    }

    public void drawEffects(Graphics g) {
        try {
            int i = 0;
            for (i = 0; i < 6; ++i) {
                if (this.m_effect[i] == null) continue;
                this.m_effect[i].render(g);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void sort(GameObject[] array) {
        int i;
        if (drawID == null || drawID.length != array.length) {
            drawID = new int[array.length];
        }
        for (i = 0; i < drawID.length; ++i) {
            SceneGame.drawID[i] = i;
        }
        for (i = 0; i < drawID.length; ++i) {
            for (int j = drawID.length - 1; j > 0; --j) {
                this.ID1 = drawID[j];
                this.ID2 = drawID[j - 1];
                this.posy1 = array[this.ID1] == null ? 0 : array[this.ID1].getY();
                int n = this.posy2 = array[this.ID2] == null ? 0 : array[this.ID2].getY();
                if (this.posy1 >= this.posy2 || this.ID1 <= this.ID2) continue;
                this.swapID(j, j - 1);
            }
        }
    }

    void swapID(int i1, int i2) {
        this.tmp = drawID[i1];
        SceneGame.drawID[i1] = drawID[i2];
        SceneGame.drawID[i2] = this.tmp;
    }

    public void update_train() {
        if (this.showtrain) {
            switch (this.trainindex) {
                case 0: {
                    if (!this.animan_train.nextFrame_toEnd()) break;
                    this.animan_train.set_indexAnimate(1);
                    ++this.trainindex;
                    this.flashTime = Utility.GetTime();
                    break;
                }
                case 1: {
                    this.animan_train.nextFrame_Cyc();
                    if (Utility.GetTime() - this.flashTime < (long)this.traintime) break;
                    this.animan_train.set_indexAnimate(2);
                    ++this.trainindex;
                    break;
                }
                case 2: {
                    if (!this.animan_train.nextFrame_toEnd()) break;
                    this.animan_train.reSetFrame();
                    this.showtrain = false;
                    this.lasttrain = Utility.GetTime();
                }
            }
        } else if (Utility.GetTime() - this.lasttrain > (long)this.trainsep) {
            this.lasttrain = Utility.GetTime();
            this.showtrain = true;
            this.trainindex = 0;
            this.animan_train.reSetFrame();
        }
    }

    public void render_train(Graphics g) {
        if (this.showtrain) {
            int ty = this.map.getViewportHeight() - (this.map.getTileHeight() << 2);
            if (this.trainindex == 0) {
                this.animan_train.draw(g, 240, ty);
            } else if (this.trainindex == 1) {
                this.animan_train.draw(g, 0, ty);
            } else if (this.trainindex == 2) {
                this.animan_train.draw(g, 0, ty);
            }
        }
    }

    public void updatewaitingfor() {
        if (this.m_state == 1 && this.bossappear && this.waitingforenemy != 0L && Utility.GetTime() - this.waitingforenemy >= 5000L) {
            this.waitingforenemy = 0L;
            int rand = 0;
            byte objtype = 0;
            Enemy enemy = null;
            int num = MathTool.getRandom(4, 7);
            for (int i = 0; i < num; ++i) {
                rand = MathTool.getRandom(100);
                if (MainCanvas.missionid == 0) {
                    if (rand < 70) {
                        enemy = this.createRogue((byte)-1, (byte)-1);
                        objtype = 0;
                    } else {
                        objtype = 1;
                        enemy = new Enemy(this, this.ani_fatman);
                    }
                } else if (rand < 50) {
                    enemy = this.createRogue((byte)-1, (byte)-1);
                    objtype = 0;
                } else if (rand <= 80) {
                    objtype = 1;
                    enemy = new Enemy(this, this.ani_fatman);
                } else {
                    objtype = 2;
                    enemy = new Enemy(this, this.ani_bitch);
                }
                enemy.m_maxHealth = MathTool.getRandom(1, 4) * 100;
                enemy.FullHealth();
                enemy.setPositionX(MathTool.getRandom(this.map.moveleft, this.map.moveright));
                enemy.setPositionY(MathTool.getRandom(this.map.moveup, this.map.movedown));
                enemy.init(objtype, (byte)0);
                enemy.needupdate = true;
                this.settolist(enemy);
            }
        }
    }

    public Enemy createRogue(byte type, byte weapon) {
        Enemy rogue = null;
        rogue = MathTool.randRatio(50) ? new Enemy(this, this.ani_rogue1) : new Enemy(this, this.ani_rogue2);
        if (type == -1) {
            type = (byte)MathTool.getRandom(0, 3);
        }
        rogue.init((byte)0, (byte)0);
        rogue.setroguetype(type);
        if (weapon == -1) {
            weapon = (byte)MathTool.getRandom(0, 4);
        } else {
            if (weapon > 4) {
                weapon = (byte)4;
            }
            if (weapon < 0) {
                weapon = 0;
            }
        }
        Weapon weapon_keeped = new Weapon(this, this.ani_rogueweapon[weapon], weapon);
        rogue.setweapon(weapon_keeped);
        return rogue;
    }

    public void blackscreen(Graphics g) {
        GraphicsTool.FillRect(g, 0, 0, 0, 240, this.y_black);
        GraphicsTool.FillRect(g, 0, 0, 320 - this.y_black, 240, this.y_black);
    }

    public void nextstage_load() {
        try {
            if (this.nextstageloaded) {
                this.y_black -= 10;
                if (this.y_black <= 0) {
                    this.m_iCount = 0;
                    this.lasttrain = Utility.GetTime();
                    this.m_inited = true;
                    this.m_state = 1;
                }
            } else {
                this.y_black += 10;
                if (this.y_black >= 160) {
                    this.waitingforenemy = 0L;
                    if (++MainCanvas.areaid >= MainCanvas.max_area) {
                        this.m_state = 1;
                        return;
                    }
                    this.m_health = this.m_player.m_health;
                    this.m_magic = this.m_player.m_magic;
                    String data_area = new String("/dm" + MainCanvas.missionid + MainCanvas.areaid + ".mdb");
                    this.map.LoadMap(new DataInputStream(this.getClass().getResourceAsStream(data_area)));
                    this.map.setViewport(0, 0, 240, 320);
                    this.map.setUseMapBuffer(false);
                    this.map.setCamera(this.m_player);
                    this.nextstageloaded = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void createresultimg(boolean _win) {
        try {
            this.img_result = _win ? Image.createImage((String)"/win.png") : Image.createImage((String)"/fail.png");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean isactiveenemy(int index) {
        if (this.renderlist[index] == null) {
            return false;
        }
        if (this.renderlist[index].equals(this.m_player)) {
            return false;
        }
        if (this.renderlist[index].getCatlog() == 1) {
            return false;
        }
        if (this.renderlist[index].getCatlog() == 2) {
            return false;
        }
        if (this.renderlist[index].getCatlog() == 3) {
            return false;
        }
        return !this.renderlist[index].isDead();
    }
}

