/*
 * Decompiled with CFR 0.152.
 */
package menu;

import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import main.MainCanvas;
import menu.MenuItem;
import menu.SceneMenu;
import util.GraphicsTool;
import util.Key;
import util.MathTool;
import util.TextUtil;

public class MenuPage {
    public static final int PRIORITY_PRIME = 0;
    public static final int PRIORITY_SECOND = 1;
    public static final int PRIORITY_NORMAL = 2;
    public static final byte PT_NOTHING = 0;
    public static final byte PT_BLACKQUERY = 1;
    public static final byte PT_SHOWSPLASH = 2;
    public static final byte PT_CONTENT = 3;
    public static final byte PT_ITEMSELECT = 4;
    public static final byte PT_GMG = 5;
    SceneMenu m_scene = null;
    private byte m_type = 0;
    private Vector m_items = null;
    private int m_length = 0;
    private int SelectIndex = 0;
    private int StartIndex = 0;
    private int MaxSize = 0;
    private MenuItem PrimeItem = null;
    private MenuItem SecondItem = null;
    private int cb_w = 0;
    private int cb_h = 0;
    private int bar_nw = 0;
    private int bar_nh = 0;
    private int bar_x = 0;
    private int bar_y = 0;
    private int arrow_x = 0;
    private int y_arrowup = 0;
    private int y_arrowdown = 0;
    private int content_x = 0;
    private int content_y = 0;
    private int start_x = 0;
    private int start_y = 0;

    public MenuPage(SceneMenu sm) {
        this.m_scene = sm;
        this.m_items = new Vector();
    }

    public void showsplash_create(int _logoy) {
        SceneMenu.y_logo = _logoy;
        this.m_type = (byte)2;
    }

    public void blackquery_create(String _str) {
        this.m_items = TextUtil.Font_SplitString(_str, MainCanvas.m_font, 230);
        this.m_type = 1;
    }

    public void itemselect_create() {
        this.m_type = (byte)4;
        this.checksize();
    }

    public void addMenuItems(MenuItem mi) {
        this.m_items.addElement(mi);
    }

    public int checkItemsMaxWidth() {
        int size = this.m_items.size();
        int wid = 0;
        for (int i = 0; i < size; ++i) {
            String str = ((MenuItem)this.m_items.elementAt(i)).GetString();
            int wid_str = MainCanvas.m_font.stringWidth(str);
            if (wid_str <= wid) continue;
            wid = wid_str;
        }
        return wid;
    }

    public void checksize() {
        this.m_length = this.m_items.size();
        this.MaxSize = this.m_length < SceneMenu.maxsize_db ? this.m_length : SceneMenu.maxsize_db;
        int content_w = 0;
        int content_h = 0;
        content_w = this.m_type == 4 ? this.checkItemsMaxWidth() + 8 : MainCanvas.contentmax;
        content_h = this.MaxSize * SceneMenu.text_h;
        int mod = 0;
        int div = 0;
        this.cb_h = content_h + (MainCanvas.corner_h << 1);
        this.cb_w = content_w + (MainCanvas.corner_w << 1);
        mod = MathTool.getModInt(content_h, MainCanvas.bar_perw);
        div = MathTool.getDiv(content_h, MainCanvas.bar_perw);
        this.bar_nh = mod == 0 ? div : div + 1;
        mod = MathTool.getModInt(content_w, MainCanvas.bar_perw);
        div = MathTool.getDiv(content_w, MainCanvas.bar_perw);
        this.bar_nw = mod == 0 ? div : div + 1;
        this.start_x = (240 - this.cb_w) / 2;
        this.start_y = SceneMenu.height_logo + 4 + (SceneMenu.maxheight_db - this.cb_h) / 2;
        this.bar_x = this.start_x + (this.cb_w - this.bar_nw * MainCanvas.bar_perw) / 2;
        this.bar_y = this.start_y + (this.cb_h - this.bar_nh * MainCanvas.bar_perw) / 2;
        this.content_x = 120;
        this.arrow_x = 120;
        this.y_arrowup = this.start_y + MainCanvas.corner_h;
        this.y_arrowdown = this.start_y + content_h + MainCanvas.corner_h;
        this.content_y = this.start_y + MainCanvas.corner_h;
    }

    public void addMenuContent(Vector v) {
        this.m_type = (byte)3;
        this.m_items = v;
        this.checksize();
    }

    public void addMenuContent_GMG(Vector v) {
        this.m_type = (byte)5;
        this.m_items = v;
        this.checksize();
    }

    public void AddPagePrime(MenuItem mi) {
        if (mi != null) {
            this.PrimeItem = mi;
        }
    }

    public void AddPageSecond(MenuItem mi) {
        if (mi != null) {
            this.SecondItem = mi;
        }
    }

    public void GetItemPriority() {
    }

    public int GetItemAction() {
        return 0;
    }

    public void update() {
    }

    public int GetSelectIndex() {
        return this.SelectIndex;
    }

    public int GetStartIndex() {
        return this.StartIndex;
    }

    public void ChangeItemContent(String str, int index) {
        ((MenuItem)this.m_items.elementAt(index)).SetString(str);
    }

    public void draw(Graphics g) {
        int half_sw = 120;
        int half_sh = 160;
        int center_y = 320 - SceneMenu.height_softbar >> 1;
        try {
            boolean needselect;
            boolean blackback = this.m_type == 1 || this.m_type == 5 || this.m_type == 0;
            boolean imageback = this.m_type == 2 || this.m_type == 3 || this.m_type == 4;
            boolean needbox = this.m_type == 3 || this.m_type == 4;
            boolean bl = needselect = this.m_type == 4;
            if (MainCanvas.m_GamePaused) {
                GraphicsTool.ClipAll(g);
            } else if (blackback) {
                GraphicsTool.FillRect(g, 0, 0, 0, 240, 320);
            } else if (imageback) {
                g.drawImage(SceneMenu.img_back, 120, 160, 3);
                if (this.m_type == 2) {
                    g.drawImage(SceneMenu.img_logo, 120, SceneMenu.y_logo, 17);
                } else {
                    g.drawImage(SceneMenu.img_logo, 120, 2, 17);
                }
            }
            if (this.m_type == 1) {
                TextUtil.Font_RenderStringsVectorSingle(g, this.m_items, MainCanvas.m_font, 120, center_y, 3, 0xFFFFFF);
            } else if (this.m_type == 5) {
                GraphicsTool.FillRect(g, 0, 0, 0, 240, 320);
                if (SceneMenu.img_spLogo == null) {
                    SceneMenu.img_spLogo = Image.createImage((String)"/exit.png");
                }
                g.drawImage(SceneMenu.img_spLogo, 120, 160, 3);
                TextUtil.Font_RenderStringsVectorSingle(g, this.m_items, MainCanvas.m_font, 120, center_y, 3, 0xFFFFFF);
            } else if (this.m_type == 3 || this.m_type == 4) {
                for (int i = 0; i < this.MaxSize; ++i) {
                    int cc;
                    String str = null;
                    str = this.m_type == 4 ? ((MenuItem)this.m_items.elementAt(this.StartIndex + i)).GetString() : (String)this.m_items.elementAt(this.StartIndex + i);
                    int cur_y = this.content_y + SceneMenu.text_h * i;
                    if (needselect && this.SelectIndex == i) {
                        GraphicsTool.FillRect(g, 25600, this.start_x, cur_y, this.cb_w, SceneMenu.text_h);
                    }
                    if (this.m_type == 4) {
                        cc = 0xFFFFFF;
                        if (str.equals("\u66f4\u591a\u6e38\u620f")) {
                            cc = 0xFF0000;
                        }
                        TextUtil.Font_RenderString(g, str, MainCanvas.m_font, this.content_x, cur_y, 17, cc);
                        continue;
                    }
                    cc = 0xFFFFFF;
                    if (str.equals("\u66f4\u591a\u6e38\u620f")) {
                        cc = 0xFF0000;
                    }
                    TextUtil.Font_RenderString(g, str, MainCanvas.m_font, this.content_x, cur_y, 17, cc, 25600);
                }
            }
            if (needbox) {
                boolean up = this.StartIndex > 0;
                boolean down = this.StartIndex + this.MaxSize < this.m_length;
                MainCanvas.drawBox(g, this.bar_nw, this.bar_nh, this.start_x, this.start_y, this.bar_x, this.bar_y, this.cb_w, this.cb_h, up, down, this.arrow_x, this.y_arrowup, this.y_arrowdown);
            }
            GraphicsTool.ClipAll(g);
            if (this.PrimeItem != null) {
                TextUtil.Font_RenderString(g, this.PrimeItem.GetString(), MainCanvas.m_font, this.m_scene.m_canvas.primex, 318, this.m_scene.m_canvas.primeanchor | 0x20, 0xFFFFFF);
            }
            if (this.SecondItem != null) {
                TextUtil.Font_RenderString(g, this.SecondItem.GetString(), MainCanvas.m_font, this.m_scene.m_canvas.secondx, 318, this.m_scene.m_canvas.secondanchor | 0x20, 0xFFFFFF);
            }
            GraphicsTool.ClipAll(g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int ProcessKey() {
        try {
            int act = -1;
            int halfsize = 0;
            halfsize = this.MaxSize >> 1;
            int startmax = this.m_length - this.MaxSize;
            if (Key.IsKeyHold(1)) {
                if (this.m_type == 4) {
                    if (startmax == 0) {
                        if (this.SelectIndex > 0) {
                            --this.SelectIndex;
                        }
                    } else if (this.StartIndex == startmax) {
                        if (this.SelectIndex > halfsize) {
                            if (this.SelectIndex > 0) {
                                --this.SelectIndex;
                            }
                        } else if (this.SelectIndex == halfsize && this.StartIndex > 0) {
                            --this.StartIndex;
                        }
                    } else if (this.StartIndex == 0) {
                        if (this.SelectIndex > 0) {
                            --this.SelectIndex;
                        }
                    } else if (this.StartIndex > 0) {
                        --this.StartIndex;
                    }
                    Key.ClearKey();
                } else if (this.StartIndex > 0) {
                    --this.StartIndex;
                }
            } else if (Key.IsKeyHold(2)) {
                if (this.m_type == 4) {
                    if (this.StartIndex == startmax) {
                        if (this.SelectIndex < this.MaxSize - 1) {
                            ++this.SelectIndex;
                        }
                    } else if (this.StartIndex == 0) {
                        if (this.SelectIndex < halfsize) {
                            ++this.SelectIndex;
                        } else if (this.SelectIndex == halfsize) {
                            ++this.StartIndex;
                        }
                    } else if (this.StartIndex < startmax) {
                        ++this.StartIndex;
                    }
                    Key.ClearKey();
                } else if (this.StartIndex < startmax) {
                    ++this.StartIndex;
                }
            } else if (!Key.IsKeyPressed(4) && !Key.IsKeyPressed(8)) {
                if (Key.IsKeyPressed(262144)) {
                    if (this.m_type == 4) {
                        act = ((MenuItem)this.m_items.elementAt(this.StartIndex + this.SelectIndex)).GetAcion();
                        if (act == -1) {
                            act = this.PrimeItem.GetAcion();
                        }
                    } else if (this.PrimeItem != null) {
                        act = this.PrimeItem.GetAcion();
                        if (act == 31) {
                            boolean temp = !MainCanvas.m_music.GetSwitchStatus();
                            MainCanvas.m_music.SetSwitchStatus(temp);
                            if (temp) {
                                System.out.println("come to play sound....");
                                MainCanvas.m_music.PlaySound(MainCanvas.SND_MENUBACK, -1);
                            } else {
                                MainCanvas.m_music.StopCurrentSound();
                                MainCanvas.m_music.Close();
                            }
                        }
                    } else {
                        act = -1;
                    }
                    Key.ClearKey();
                } else if (Key.IsKeyPressed(65536)) {
                    if (this.m_type == 4) {
                        act = ((MenuItem)this.m_items.elementAt(this.StartIndex + this.SelectIndex)).GetAcion();
                        if (act == -1) {
                            act = this.PrimeItem.GetAcion();
                        }
                    } else if (this.PrimeItem != null) {
                        act = this.PrimeItem.GetAcion();
                        if (act == 31) {
                            boolean temp = !MainCanvas.m_music.GetSwitchStatus();
                            MainCanvas.m_music.SetSwitchStatus(temp);
                            if (temp) {
                                System.out.println("come to play sound....");
                                MainCanvas.m_music.PlaySound(MainCanvas.SND_MENUBACK, -1);
                            } else {
                                MainCanvas.m_music.StopCurrentSound();
                                MainCanvas.m_music.Close();
                            }
                        }
                    } else {
                        act = -1;
                    }
                    Key.ClearKey();
                } else if (Key.IsKeyPressed(131072)) {
                    act = this.SecondItem != null ? this.SecondItem.GetAcion() : -1;
                    Key.ClearKey();
                }
            }
            return act;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return -1;
        }
    }

    public void RemovePrimeSoftKey() {
        this.PrimeItem = null;
    }

    public void RemoveSecondSoftKey() {
        this.SecondItem = null;
    }

    public void Clear() {
        try {
            this.SelectIndex = 0;
            this.StartIndex = 0;
            if (this.m_items != null) {
                this.m_items.removeAllElements();
            }
            this.m_type = 0;
            this.RemovePrimeSoftKey();
            this.RemoveSecondSoftKey();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

