/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import util.GraphicsTool;
import util.Utility;

public class Animation {
    private static final int MASK = 65535;
    private Image m_image = null;
    private short[] Modules;
    public short[][] Frames;
    public short[][] cBoxHit;
    public short[][] cBoxAtt;
    public short[][] Actions;
    public short[][] Delay;

    public Animation(String res, Image img) {
        try {
            int num;
            int i;
            DataInputStream is = new DataInputStream(this.getClass().getResourceAsStream(res));
            if (is == null) {
                return;
            }
            is.readShort();
            short m_imageID = is.readShort();
            is.readInt();
            is.readUTF();
            int count = is.readShort();
            this.Modules = new short[count * 4];
            Animation.readDataShort(is, this.Modules, 0, this.Modules.length);
            count = is.readShort();
            this.Frames = new short[count][];
            for (i = 0; i < count; ++i) {
                num = is.readUnsignedShort();
                this.Frames[i] = new short[num * 4];
                Animation.readDataShort(is, this.Frames[i], 0, this.Frames[i].length);
            }
            this.cBoxHit = new short[count][4];
            this.cBoxAtt = new short[count][4];
            for (i = 0; i < count; ++i) {
                Animation.readDataShort(is, this.cBoxHit[i], 0, 4);
                short[] sArray = this.cBoxHit[i];
                sArray[2] = (short)(sArray[2] - this.cBoxHit[i][0]);
                short[] sArray2 = this.cBoxHit[i];
                sArray2[3] = (short)(sArray2[3] - this.cBoxHit[i][1]);
            }
            for (i = 0; i < count; ++i) {
                Animation.readDataShort(is, this.cBoxAtt[i], 0, 4);
                short[] sArray = this.cBoxAtt[i];
                sArray[2] = (short)(sArray[2] - this.cBoxAtt[i][0]);
                short[] sArray3 = this.cBoxAtt[i];
                sArray3[3] = (short)(sArray3[3] - this.cBoxAtt[i][1]);
            }
            count = is.readUnsignedShort();
            this.Actions = new short[count][];
            this.Delay = new short[count][];
            short[] m_mechModels = new short[count * 4];
            for (i = 0; i < count; ++i) {
                num = is.readUnsignedShort();
                this.Actions[i] = new short[num];
                this.Delay[i] = new short[num];
                for (int ii = 0; ii < num; ++ii) {
                    this.Actions[i][ii] = is.readShort();
                    this.Delay[i][ii] = is.readShort();
                }
            }
            Animation.readDataByte(is, count);
            Animation.readDataShort(is, m_mechModels, 0, m_mechModels.length);
            is.close();
            Utility.doGC();
            this.m_image = img;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getFrameWidth(int indexAnimate, int indexFrame) {
        short frameleft = 0;
        int frameright = 0;
        short frameIndex = this.Actions[indexAnimate][indexFrame];
        int length = this.Frames[frameIndex].length;
        int i = 0;
        for (i = 0; i < length; i += 4) {
            int modID = (this.Frames[frameIndex][i] & 0xFFFF) << 2;
            short modW = this.Modules[modID + 2];
            short curleft = this.Frames[frameIndex][i + 2];
            int curright = this.Frames[frameIndex][i + 2] + modW;
            if (frameleft > curleft) {
                frameleft = curleft;
            }
            if (frameright >= curright) continue;
            frameright = curright;
        }
        return frameright - frameleft;
    }

    public int getFrameHeight(int indexAnimate, int indexFrame) {
        short frametop = 0;
        int framebottom = 0;
        short frameIndex = this.Actions[indexAnimate][indexFrame];
        int length = this.Frames[frameIndex].length;
        int i = 0;
        for (i = 0; i < length; i += 4) {
            int modID = (this.Frames[frameIndex][i] & 0xFFFF) << 2;
            short modH = this.Modules[modID + 3];
            short curtop = this.Frames[frameIndex][i + 3];
            int curbottom = this.Frames[frameIndex][i + 3] + modH;
            if (frametop > curtop) {
                frametop = curtop;
            }
            if (framebottom >= curbottom) continue;
            framebottom = curbottom;
        }
        return framebottom - frametop;
    }

    public void draw(Graphics g, int indexAnimate, int indexFrame, int x, int y, boolean facingX) {
        try {
            short frameIndex = this.Actions[indexAnimate][indexFrame];
            int dgflag = 0;
            int clipx = g.getClipX();
            int clipy = g.getClipY();
            int clipwidth = g.getClipWidth();
            int clipheight = g.getClipHeight();
            int i = 0;
            int length = this.Frames[frameIndex].length;
            for (i = 0; i < length; i += 4) {
                int modID = (this.Frames[frameIndex][i] & 0xFFFF) << 2;
                int flag = this.Frames[frameIndex][i + 1] & 0xFFFF;
                short modX = this.Modules[modID];
                short modY = this.Modules[modID + 1];
                short modW = this.Modules[modID + 2];
                short modH = this.Modules[modID + 3];
                boolean flipXs = facingX ^ (flag & 1) != 0;
                boolean flipYs = false ^ (flag & 2) != 0;
                int posX = x;
                int posY = y;
                posX = facingX ? (posX -= this.Frames[frameIndex][i + 2]) : (posX += this.Frames[frameIndex][i + 2]);
                posY += this.Frames[frameIndex][i + 3];
                short s = flipYs ? modH : (short)0;
                dgflag = Animation.trans(flipXs, flipYs);
                GraphicsTool.DrawRegion(g, this.m_image, modX, modY, modW, modH, posX -= flipXs ? modW : (short)0, posY -= s, dgflag, 20);
            }
            GraphicsTool.ClipArea(g, clipx, clipy, clipwidth, clipheight);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static int trans(boolean flipX, boolean flipY) {
        if (!flipX && !flipY) {
            return 0;
        }
        if (flipX && !flipY) {
            return 2;
        }
        if (!flipX && flipY) {
            return 1;
        }
        return 3;
    }

    public final int GetAniNum() {
        return this.Actions == null ? 0 : this.Actions.length;
    }

    public final boolean OutBounds(int indexAnimate, int indexFrame) {
        if (indexAnimate < 0) {
            return true;
        }
        if (indexAnimate > this.Actions.length) {
            return true;
        }
        if (indexFrame < 0) {
            return true;
        }
        return indexFrame > this.Actions[indexAnimate].length;
    }

    public static final byte[] readDataByte(DataInputStream dis, int length) throws Exception {
        byte[] data = new byte[length];
        dis.read(data, 0, length);
        return data;
    }

    public static final void readDataShort(DataInputStream dis, short[] data, int off, int length) throws Exception {
        for (int i = 0; i < length; ++i) {
            data[i + off] = dis.readShort();
        }
    }

    public void destroy() {
        this.m_image = null;
        this.Modules = null;
        this.Actions = null;
        this.cBoxAtt = null;
        this.cBoxHit = null;
        this.Frames = null;
        Utility.doGC();
    }
}

