/*
 * Decompiled with CFR 0.152.
 */
package com.game.map;

import com.game.cannonball.RectCoordinate;
import com.game.monster.Monster;
import com.game.sprite.SpriteX;
import com.game.util.Graphics2D;
import javax.microedition.lcdui.Image;

public class Barrier
extends SpriteX {
    private RectCoordinate rect = new RectCoordinate();
    public int state = 0;
    private final int BAR_STATE_WAIT;
    private final int BAR_STATE_BOOM;
    private final int BAR_STATE_DEATH;

    public RectCoordinate getRect() {
        return this.rect;
    }

    public void setRect(RectCoordinate rect) {
        this.rect = rect;
    }

    public Barrier(Image img, Image imgSpr, byte[] byteSpr, int x) {
        super(byteSpr, imgSpr);
        this.BAR_STATE_WAIT = 0;
        this.BAR_STATE_BOOM = 1;
        this.BAR_STATE_DEATH = 2;
        this.rect.setWidth(this.getWidth());
        this.rect.setHeight(this.getHeight());
        this.setX(x);
        this.setY(200);
        this.rect.setX(x - this.getWidth() / 2);
        this.rect.setY(200 - this.getHeight());
    }

    public void paint(Graphics2D g) {
        switch (this.state) {
            case 0: {
                super.paint(g);
                break;
            }
            case 1: {
                super.paint(g);
                break;
            }
        }
        this.logic();
    }

    public void logic() {
        switch (this.state) {
            case 0: {
                this.setFrame(0);
                break;
            }
            case 1: {
                if (this.getFrame() != this.getSequenceLength() - 1) break;
                this.changeState(2);
                break;
            }
        }
    }

    public void changeState(int state) {
        switch (state) {
            case 1: {
                break;
            }
        }
        this.state = state;
    }

    public boolean collisionWithBarrier(Monster monster) {
        if (!this.rect.collisionWithMonster(monster.getRect())) {
            return false;
        }
        monster.changeState(4);
        this.changeState(1);
        return true;
    }
}

