/*
 * Decompiled with CFR 0.152.
 */
package com.linkyun.screen;

import com.linkyun.config.DeviceConfig;
import com.linkyun.screen.MainMenuScreen;
import com.linkyun.screen.ScreenManage;
import com.linkyun.screen.StandardScreen;
import com.linkyun.tools.GraphicsTools;
import com.linkyun.tools.MusicPlayer;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LogoScreen
extends StandardScreen {
    private boolean m_bForceScreen;
    private boolean m_bDisplayLHJ;
    private int m_nStartLHJ;
    private Image m_imgGameThumbnail = null;
    private Image m_imgLhjBG = null;
    private Image m_imgLeft = null;
    private Image m_imgMiddle = null;
    private Image m_imgRight = null;
    private Image[] m_imgLhjIcon = null;
    private static final int STATE_THUMBNAIL = 0;
    private static final int STATE_SOUND = 1;
    private static final int STATE_LHJ = 2;

    public LogoScreen() {
        this.initAll();
    }

    protected void click(int x, int y) {
        if (this.m_bIsLoading) {
            return;
        }
        if (this.m_bForceScreen) {
            return;
        }
    }

    protected void input(int key) {
        if (this.m_bIsLoading) {
            return;
        }
        if (this.m_bForceScreen) {
            switch (key) {
                case -6: {
                    this.m_bForceScreen = false;
                }
            }
            return;
        }
        if (this.m_bDisplayLHJ) {
            this.inputLHJ(key);
        }
    }

    protected void logic() {
        if (this.m_bIsLoading) {
            return;
        }
        if (this.m_bForceScreen) {
            return;
        }
        switch (this.m_nStatus) {
            case 0: {
                if (this.m_nFrameCounter > 5) {
                    this.setStatus(1);
                }
                return;
            }
            case 2: {
                int tmp_nFrame = this.m_nFrameCounter - this.m_nStartLHJ;
                boolean tmp_bNextScreen = false;
                if (this.m_bDisplayLHJ) {
                    this.logicLHJ();
                    if (tmp_nFrame > 39) {
                        tmp_bNextScreen = true;
                    }
                } else if (tmp_nFrame > 29) {
                    tmp_bNextScreen = true;
                }
                if (!tmp_bNextScreen) break;
                MusicPlayer.stopMusic();
                this.m_bIsClearRes = true;
                ScreenManage.setCurrentScreen(new MainMenuScreen());
            }
        }
    }

    protected void paint(Graphics g) {
        if (this.m_bIsLoading) {
            return;
        }
        GraphicsTools.fillScreen(g, 0);
        if (this.m_bForceScreen) {
            String tmp_sMsg = "\u672c\u6e38\u620f\u4ec5\u652f\u6301\u7ad6\u5c4f\u4f7f\u7528,\u8bf7\u5207\u6362";
            switch (0) {
                case 2: {
                    tmp_sMsg = "\u672c\u6e38\u620f\u4ec5\u652f\u6301\u6a2a\u5c4f\u4f7f\u7528,\u8bf7\u5207\u6362";
                }
            }
            g.setColor(0xFFFFFF);
            g.drawString(tmp_sMsg, 120, 160, 65);
            g.drawString("\u786e\u5b9a", 0, 320, 36);
            return;
        }
        if (this.m_nStatus != 2) {
            g.drawImage(this.m_imgGameThumbnail, 120, 160, 3);
        }
        switch (this.m_nStatus) {
            case 1: {
                if (!this.m_bDisplayLHJ) break;
                g.setColor(0xFFFFFF);
                g.drawString("\u662f\u5426\u5f00\u542f\u97f3\u6548?", 120, 320 - DeviceConfig.FONT_HEIGHT * 3, 17);
                g.drawString("\u662f", 2, 318, 36);
                g.drawString("\u5426", 238, 318, 40);
                break;
            }
            case 2: {
                if (this.m_bDisplayLHJ) {
                    this.paintLHJ(g);
                    break;
                }
                int tmp_nFrame = this.m_nFrameCounter - this.m_nStartLHJ;
                int tmp_nIndex = (tmp_nFrame - tmp_nFrame % 10) / 10;
                if (tmp_nIndex >= 3) break;
                g.drawImage(this.m_imgLhjIcon[tmp_nIndex], 120, 160, 3);
            }
        }
        ++this.m_nFrameCounter;
    }

    protected void initAll() {
        switch (0) {
            case 0: {
                this.m_bForceScreen = false;
                break;
            }
            case 1: 
            case 2: {
                this.m_bForceScreen = true;
            }
        }
        this.m_bDisplayLHJ = false;
        this.m_bDisplayLHJ = true;
        this.loadRes();
        this.m_bIsLoading = false;
    }

    protected void destroyAll() {
        this.releaseRes();
    }

    protected void loadRes() {
        try {
            this.m_imgGameThumbnail = Image.createImage((String)"/logo/gameThumbnail.png");
            int tmp_nLhjIconCount = 3;
            if (this.m_bDisplayLHJ) {
                tmp_nLhjIconCount = 8;
                this.m_imgLhjBG = Image.createImage((String)"/logo/lhj_bg.png");
            }
            this.m_imgLhjIcon = new Image[tmp_nLhjIconCount];
            for (int i = 0; i < tmp_nLhjIconCount; ++i) {
                this.m_imgLhjIcon[i] = Image.createImage((String)("/logo/lhj_icon" + i + ".png"));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void releaseRes() {
        this.m_imgGameThumbnail = null;
        this.m_imgLhjBG = null;
        this.m_imgLeft = null;
        this.m_imgMiddle = null;
        this.m_imgRight = null;
        this.m_imgLhjIcon = null;
    }

    private void inputLHJ(int key) {
        if (this.m_nStatus != 1) {
            return;
        }
        switch (key) {
            case -6: {
                MusicPlayer.m_bSound = true;
                MusicPlayer.playMusic("/logo/sound.mp3", 1);
                this.m_nStartLHJ = this.m_nFrameCounter;
                this.setStatus(2);
                break;
            }
            case -7: {
                MusicPlayer.m_bSound = false;
                this.m_nStartLHJ = this.m_nFrameCounter;
                this.setStatus(2);
            }
        }
    }

    private void logicLHJ() {
        int tmp_nFrame = this.m_nFrameCounter - this.m_nStartLHJ;
        if (tmp_nFrame < 5) {
            this.m_imgLeft = this.m_imgLhjIcon[0];
            this.m_imgMiddle = this.m_imgLhjIcon[1];
            this.m_imgRight = this.m_imgLhjIcon[2];
        } else if (tmp_nFrame < 20 || tmp_nFrame < 30 && tmp_nFrame % 2 == 1) {
            int tmp_nIndex = tmp_nFrame % 3;
            switch (tmp_nIndex) {
                case 0: {
                    this.m_imgLeft = this.m_imgLhjIcon[4];
                    this.m_imgMiddle = this.m_imgLhjIcon[5];
                    this.m_imgRight = this.m_imgLhjIcon[3];
                    break;
                }
                case 1: {
                    this.m_imgLeft = this.m_imgLhjIcon[3];
                    this.m_imgMiddle = this.m_imgLhjIcon[4];
                    this.m_imgRight = this.m_imgLhjIcon[5];
                    break;
                }
                case 2: {
                    this.m_imgLeft = this.m_imgLhjIcon[5];
                    this.m_imgMiddle = this.m_imgLhjIcon[3];
                    this.m_imgRight = this.m_imgLhjIcon[4];
                }
            }
        } else if (tmp_nFrame > 29 && tmp_nFrame < 40) {
            this.m_imgLeft = this.m_imgLhjIcon[6];
            this.m_imgMiddle = this.m_imgLhjIcon[0];
            this.m_imgRight = this.m_imgLhjIcon[7];
        }
    }

    private void paintLHJ(Graphics g) {
        g.drawImage(this.m_imgLhjBG, 120, 160, 3);
        g.drawImage(this.m_imgLeft, 93, 160, 10);
        g.drawImage(this.m_imgMiddle, 119, 160, 3);
        g.drawImage(this.m_imgRight, 146, 160, 6);
    }

    void clearRes() {
        this.releaseRes();
    }

    void setStatus(int _Status) {
        this.m_nStatus = _Status;
    }
}

