/*
 * Decompiled with CFR 0.152.
 */
package com.linkyun.tools;

import com.linkyun.config.DeviceConfig;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsTools {
    public static final int THV = 65;
    public static final int HCB = 65;
    public static final int LT = 20;
    public static final int LV = 6;
    public static final int LB = 36;
    public static final int HT = 17;
    public static final int HV = 3;
    public static final int HB = 33;
    public static final int RT = 24;
    public static final int RV = 10;
    public static final int RB = 40;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static int[] rgb = null;
    private static String m_sStr = "";
    private static String[] m_asStr;
    public static int m_nTextScrollStep;
    public static int m_nTextScrollSpace;

    public static void drawRegion(Graphics g, Image src, int x_src, int y_src, int width, int height, int transform, int x_dest, int y_dest, int anchor) {
        g.drawRegion(src, x_src, y_src, width, height, transform, x_dest, y_dest, anchor);
    }

    public static void drawAlphaImage(Graphics g, Image img, int opaque) {
        int tmp_nW = img.getWidth();
        int tmp_nH = img.getHeight();
        int[] tmp_anMask = new int[tmp_nW * tmp_nH];
        int tmp_colour = opaque << 24 | 0;
        img.getRGB(tmp_anMask, 0, tmp_nW, 0, 0, tmp_nW, tmp_nH);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tmp_nH; ++i) {
            for (int j = 0; j < tmp_nW; ++j) {
                byte tmp_nPix = (byte)(tmp_anMask[i * tmp_nW + j] >> 24);
                if (tmp_nPix == 0) {
                    sb.append("+" + tmp_nPix);
                    continue;
                }
                if (tmp_nPix == -1) {
                    sb.append(tmp_nPix);
                    continue;
                }
                sb.append(tmp_nPix);
            }
            sb.append("\n");
        }
        System.out.print(sb);
        Image tmp_img = GraphicsTools.createOpaqueImage(img, tmp_nW, tmp_nH, opaque);
        g.drawImage(tmp_img, 0, 0, 20);
    }

    public static Image createOpaqueImage(Image img_src, int width, int height, int opaque) {
        rgb = new int[width * height];
        img_src.getRGB(rgb, 0, width, 0, 0, width, height);
        if (opaque >= 255) {
            opaque = 255;
        } else if (opaque <= 0) {
            opaque = 0;
        }
        int colour = (opaque & 0xFF) << 24 | 0xFFFFFFFF;
        for (int i = 0; i < width * height; ++i) {
            if (rgb[i] != -1) continue;
            int n = i;
            rgb[n] = rgb[n] & colour;
        }
        img_src = Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)true);
        return img_src;
    }

    public static void initOpaqueData(int color, int width, int height) {
        rgb = new int[width * height];
        int i = 0;
        while (i < width * height) {
            GraphicsTools.rgb[i] = -872415232;
            int n = i++;
            rgb[n] = rgb[n] | color;
        }
    }

    public static void clearOpaque() {
        rgb = null;
    }

    public static int[] createOpaqueData(int color, int opaque, int width, int height) {
        int[] data = new int[width * height];
        if (opaque >= 255) {
            opaque = 255;
        } else if (opaque <= 0) {
            opaque = 0;
        }
        color &= 0xFFFFFF;
        int opaque_rgb = (opaque & 0xFF) << 24 | 0;
        int i = 0;
        while (i < width * height) {
            data[i] = opaque_rgb;
            int n = i++;
            data[n] = data[n] | color;
        }
        return data;
    }

    public static void changeOpaqueData(int[] data, int opaque, int width, int height) {
        if (opaque >= 255) {
            opaque = 255;
        } else if (opaque <= 0) {
            opaque = 0;
        }
        int opaque_rgb = (opaque & 0xFF) << 24 | 0;
        int i = 0;
        while (i < width * height) {
            int n = i;
            data[n] = data[n] & 0xFFFFFF;
            int n2 = i++;
            data[n2] = data[n2] | opaque_rgb;
        }
    }

    public static final Image fastScale(Image imgSrc, int scale100) {
        int width = imgSrc.getWidth();
        int height = imgSrc.getHeight();
        width *= scale100;
        height *= scale100;
        return GraphicsTools.fastScale(imgSrc, width /= 100, height /= 100);
    }

    private static final Image fastScale(Image img_src, int dest_w, int dest_h) {
        int src_w = img_src.getWidth();
        int src_h = img_src.getHeight();
        Graphics g = null;
        Image img_temp = Image.createImage((int)dest_w, (int)src_h);
        g = img_temp.getGraphics();
        int delta = (src_w << 16) / dest_w;
        int pos = delta >> 1;
        for (int x = 0; x < dest_w; ++x) {
            g.setClip(x, 0, 1, src_h);
            g.drawImage(img_src, x - (pos >> 16), 0, 20);
            pos += delta;
        }
        img_temp = GraphicsTools.createOpaqueImage(img_temp, dest_w, src_h, 0);
        Image img_dest = Image.createImage((int)dest_w, (int)dest_h);
        g = img_dest.getGraphics();
        delta = (src_h << 16) / dest_h;
        pos = delta >> 1;
        for (int y = 0; y < dest_h; ++y) {
            g.setClip(0, y, dest_w, 1);
            g.drawImage(img_temp, 0, y - (pos >> 16), 20);
            pos += delta;
        }
        img_dest = GraphicsTools.createOpaqueImage(img_dest, dest_w, dest_h, 0);
        img_temp = null;
        return img_dest;
    }

    public static int[] createTranslucentData(int width, int height) {
        int[] data_imgbk = new int[width * height];
        for (int i = 0; i < data_imgbk.length; ++i) {
            data_imgbk[i] = 0xFFFFFF;
        }
        return data_imgbk;
    }

    public static String[] splitString(String s, int w) {
        Vector<String> v = new Vector<String>();
        int tmp_nSlen = s.length();
        int tmp_nIndex = 0;
        boolean tmp_bLineBreak = false;
        for (int i = 0; i < tmp_nSlen; ++i) {
            int tmp_n = i + 1;
            tmp_bLineBreak = s.substring(i, tmp_n).equals("\n");
            if (tmp_bLineBreak) {
                v.addElement(s.substring(tmp_nIndex, i));
                tmp_nIndex = tmp_n;
            }
            if (DeviceConfig.FONT.stringWidth(s.substring(tmp_nIndex, tmp_n)) <= w) continue;
            v.addElement(s.substring(tmp_nIndex, i));
            tmp_nIndex = i;
        }
        if (tmp_nIndex < tmp_nSlen) {
            v.addElement(s.substring(tmp_nIndex, tmp_nSlen));
        }
        int tmp_nVsize = v.size();
        Object[] tmp_aString = new String[tmp_nVsize];
        v.copyInto(tmp_aString);
        return tmp_aString;
    }

    public static String[] splitString(String s, char ch) {
        Vector<String> v = new Vector<String>();
        int tmp_nStartIndex = 0;
        int tmp_nEndIndex = 0;
        while ((tmp_nEndIndex = s.indexOf(ch, tmp_nStartIndex)) > -1) {
            v.addElement(s.substring(tmp_nStartIndex, tmp_nEndIndex));
            tmp_nStartIndex = tmp_nEndIndex + 1;
        }
        int tmp_nVsize = v.size();
        Object[] tmp_aString = new String[tmp_nVsize];
        v.copyInto(tmp_aString);
        return tmp_aString;
    }

    public static void drawText(Graphics g, String s, int x, int y, int w, int h) {
        if (DeviceConfig.FONT.stringWidth(s) < w) {
            g.drawString(s, x, y, 20);
            return;
        }
        if (!m_sStr.equals(s)) {
            m_asStr = GraphicsTools.splitString(s, w);
            m_sStr = s;
        }
        int tmp_nLen = m_asStr.length;
        for (int i = 0; i < tmp_nLen; ++i) {
            g.drawString(m_asStr[i], x, y + i * DeviceConfig.FONT_HEIGHT, 20);
        }
    }

    public static int drawText(Graphics g, String[] aStr, int x, int y, int w, int h, int offSetY, int scrollDirection) {
        int tmp_nAstrLen = aStr.length;
        int tmp_nTextTotalH = DeviceConfig.FONT_HEIGHT * tmp_nAstrLen;
        if (tmp_nTextTotalH < h + 1) {
            offSetY = y + (h - tmp_nTextTotalH >> 1);
        } else if ((offSetY += scrollDirection * m_nTextScrollStep) + tmp_nTextTotalH + m_nTextScrollSpace < y) {
            offSetY = y;
        }
        g.setClip(x, y, w, h);
        for (int i = 0; i < tmp_nAstrLen; ++i) {
            int tmp_nY = offSetY + i * DeviceConfig.FONT_HEIGHT;
            if (tmp_nY + DeviceConfig.FONT_HEIGHT > y) {
                g.drawString(aStr[i], x, tmp_nY, 20);
                continue;
            }
            g.drawString(aStr[i], x, tmp_nY + tmp_nTextTotalH + m_nTextScrollSpace, 20);
        }
        GraphicsTools.resetScreen(g);
        return offSetY;
    }

    public static void resetScreen(Graphics g) {
        g.setClip(0, 0, 240, 320);
    }

    public static void fillScreen(Graphics g, int color) {
        GraphicsTools.resetScreen(g);
        g.setColor(color);
        g.fillRect(0, 0, 240, 320);
    }

    static {
        m_nTextScrollStep = 2;
        m_nTextScrollSpace = DeviceConfig.FONT_HEIGHT * 5;
    }
}

