/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.database.GameDB;
import com.sinaflying.game.GameRoleData;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class RoleTeamData {
    private static final int[] C_INDEX = new int[]{0, 1, 2};
    private static final int[] C_LEVEL = new int[]{1, 5, 5};
    private static final int[] C_EQUIP = new int[]{21, 0, 7, 14, 0, 10, 0};
    private static RoleTeamData _instance;
    private GameRoleData[] _roleData;
    private boolean[] _existFlag;
    private int[] _equipPackage;
    private boolean[] _equipExist;
    private int[] _bombPackage;
    private boolean[] _bombExist;
    private int[] _weaponPackage;
    private boolean[] _weaponExist;
    private int[] _toolPackage;
    private boolean[] _toolExist;
    private boolean[] _taskOpen;
    private boolean[] _taskExist;
    private int[] _killNumber;
    private int[] _killTarget;
    private int _money;
    private int _scenario;
    private int _leaderInx;

    private RoleTeamData() {
    }

    public static RoleTeamData getInstance() {
        return _instance;
    }

    public static void produceInstance() {
        if (_instance == null) {
            _instance = new RoleTeamData();
        }
        _instance.initTeam();
    }

    protected final void initTeam() {
        GameDB gameDB = GameDB.getGameDataBase();
        this._roleData = new GameRoleData[3];
        this._existFlag = new boolean[3];
        int n = 0;
        while (n < 3) {
            this._roleData[n] = new GameRoleData();
            this._existFlag[n] = false;
            ++n;
        }
        int n2 = gameDB.getDataNum(5);
        this._equipExist = new boolean[n2];
        this._equipPackage = new int[n2];
        int n3 = 0;
        while (n3 < this._equipPackage.length) {
            this._equipExist[n3] = false;
            this._equipPackage[n3] = 0;
            ++n3;
        }
        n2 = gameDB.getDataNum(4);
        this._bombExist = new boolean[n2];
        this._bombPackage = new int[n2];
        int n4 = 0;
        while (n4 < this._bombPackage.length) {
            this._bombExist[n4] = false;
            this._bombPackage[n4] = 0;
            ++n4;
        }
        n2 = gameDB.getDataNum(3);
        this._weaponExist = new boolean[n2];
        this._weaponPackage = new int[n2];
        int n5 = 0;
        while (n5 < this._weaponPackage.length) {
            this._weaponExist[n5] = false;
            this._weaponPackage[n5] = 0;
            ++n5;
        }
        n2 = gameDB.getDataNum(2);
        this._toolExist = new boolean[n2];
        this._toolPackage = new int[n2];
        int n6 = 0;
        while (n6 < this._toolPackage.length) {
            this._toolExist[n6] = false;
            this._toolPackage[n6] = 0;
            ++n6;
        }
        n2 = gameDB.getDataNum(6);
        this._taskExist = new boolean[n2];
        this._taskOpen = new boolean[n2];
        int n7 = 0;
        while (n7 < this._taskOpen.length) {
            this._taskExist[n7] = false;
            this._taskOpen[n7] = false;
            ++n7;
        }
        n2 = gameDB.getDataNum(1);
        this._killNumber = new int[n2];
        this._killTarget = new int[n2];
        int n8 = 0;
        while (n8 < this._killNumber.length) {
            this._killNumber[n8] = 0;
            this._killTarget[n8] = 0;
            ++n8;
        }
        this._money = 0;
        this._scenario = 0;
        this.resetPackager();
        this.addMember(0);
    }

    public final void resetPackager() {
        this.consumeBomb(C_EQUIP[5], 99999);
        this.consumeBomb(C_EQUIP[6], 99999);
    }

    public final void addMember(int n) {
        this._existFlag[n] = true;
        this._roleData[n].basicSet(C_INDEX[n], C_LEVEL[n], C_EQUIP);
    }

    public final void addMember(int n, int n2) {
        this._existFlag[n] = true;
        this._roleData[n].basicSet(C_INDEX[n], n2, C_EQUIP);
    }

    public final void delMember(int n) {
        this._existFlag[n] = false;
    }

    public final GameRoleData getRoleData(int n) {
        return this._roleData[n];
    }

    public final boolean getExistFlag(int n) {
        return this._existFlag[n];
    }

    public final int[] getPackageInfo(int n) {
        switch (n) {
            case 0: {
                return this._equipPackage;
            }
            case 1: {
                return this._weaponPackage;
            }
            case 2: {
                return this._bombPackage;
            }
            case 3: {
                return this._toolPackage;
            }
            case 5: {
                return this._killNumber;
            }
            case 6: {
                return this._killTarget;
            }
        }
        return null;
    }

    public final boolean[] getPackageExist(int n) {
        switch (n) {
            case 0: {
                return this._equipExist;
            }
            case 1: {
                return this._weaponExist;
            }
            case 2: {
                return this._bombExist;
            }
            case 3: {
                return this._toolExist;
            }
            case 4: {
                return this._taskExist;
            }
        }
        return null;
    }

    public final void consumeTool(int n, int n2) {
        n2 = this._toolPackage[n] >= 99999 ? 0 : n2;
        int n3 = n;
        this._toolPackage[n3] = this._toolPackage[n3] + n2;
        this._toolPackage[n] = Math.max(this._toolPackage[n], 0);
        this._toolExist[n] = this._toolPackage[n] > 0;
    }

    public final void consumeEquip(int n, int n2) {
        n2 = this._equipPackage[n] >= 99999 ? 0 : n2;
        int n3 = n;
        this._equipPackage[n3] = this._equipPackage[n3] + n2;
        this._equipPackage[n] = Math.max(this._equipPackage[n], 0);
        this._equipExist[n] = this._equipPackage[n] > 0;
    }

    public final void consumeWeapon(int n, int n2) {
        n2 = this._weaponPackage[n] >= 99999 ? 0 : n2;
        int n3 = n;
        this._weaponPackage[n3] = this._weaponPackage[n3] + n2;
        this._weaponPackage[n] = Math.max(this._weaponPackage[n], 0);
        this._weaponExist[n] = this._weaponPackage[n] > 0;
    }

    public final void consumeBomb(int n, int n2) {
        n2 = this._bombPackage[n] >= 99999 ? 0 : n2;
        int n3 = n;
        this._bombPackage[n3] = this._bombPackage[n3] + n2;
        this._bombPackage[n] = Math.max(this._bombPackage[n], 0);
        this._bombExist[n] = this._bombPackage[n] > 0;
    }

    public final void consumeMoney(int n) {
        this._money += n;
        this._money = Math.max(this._money, 0);
        this._money = Math.min(this._money, 999999);
    }

    public final int getMoney() {
        return this._money;
    }

    public final void consumeTask(int n, int n2) {
        this._taskOpen[n] = n2 < 0 ? true : this._taskOpen[n];
        this._taskExist[n] = n2 > 0;
    }

    public final void consumeKill(int n, int n2, int n3) {
        int n4 = n;
        this._killTarget[n4] = this._killTarget[n4] + n3;
        this._killTarget[n] = Math.max(this._killTarget[n], 0);
        this._killNumber[n] = this._killTarget[n] > 0 ? this._killNumber[n] : 0;
        int n5 = n;
        this._killNumber[n5] = this._killNumber[n5] + (this._killNumber[n] > 0 && n3 < 0 ? n3 : n2);
        this._killNumber[n] = Math.max(this._killNumber[n], 0);
        this._killNumber[n] = this._killTarget[n] > 0 ? this._killNumber[n] : 0;
    }

    public final void save(DataOutputStream dataOutputStream) {
        try {
            int n = this._toolPackage.length;
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeBoolean(this._toolExist[n2]);
                dataOutputStream.writeInt(this._toolPackage[n2]);
                ++n2;
            }
            n = this._equipPackage.length;
            int n3 = 0;
            while (n3 < n) {
                dataOutputStream.writeBoolean(this._equipExist[n3]);
                dataOutputStream.writeInt(this._equipPackage[n3]);
                ++n3;
            }
            n = this._weaponPackage.length;
            int n4 = 0;
            while (n4 < n) {
                dataOutputStream.writeBoolean(this._weaponExist[n4]);
                dataOutputStream.writeInt(this._weaponPackage[n4]);
                ++n4;
            }
            n = this._bombPackage.length;
            int n5 = 0;
            while (n5 < n) {
                dataOutputStream.writeBoolean(this._bombExist[n5]);
                dataOutputStream.writeInt(this._bombPackage[n5]);
                ++n5;
            }
            n = this._taskOpen.length;
            int n6 = 0;
            while (n6 < n) {
                dataOutputStream.writeBoolean(this._taskExist[n6]);
                dataOutputStream.writeBoolean(this._taskOpen[n6]);
                ++n6;
            }
            n = this._killNumber.length;
            int n7 = 0;
            while (n7 < n) {
                dataOutputStream.writeInt(this._killTarget[n7]);
                dataOutputStream.writeInt(this._killNumber[n7]);
                ++n7;
            }
            dataOutputStream.writeInt(this._leaderInx);
            dataOutputStream.writeInt(this._scenario);
            dataOutputStream.writeInt(this._money);
            n = this._roleData.length;
            int n8 = 0;
            while (n8 < n) {
                dataOutputStream.writeBoolean(this._existFlag[n8]);
                this._roleData[n8].save(dataOutputStream);
                ++n8;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void load(DataInputStream dataInputStream) {
        try {
            int n = this._toolPackage.length;
            int n2 = 0;
            while (n2 < n) {
                this._toolExist[n2] = dataInputStream.readBoolean();
                this._toolPackage[n2] = dataInputStream.readInt();
                ++n2;
            }
            n = this._equipPackage.length;
            int n3 = 0;
            while (n3 < n) {
                this._equipExist[n3] = dataInputStream.readBoolean();
                this._equipPackage[n3] = dataInputStream.readInt();
                ++n3;
            }
            n = this._weaponPackage.length;
            int n4 = 0;
            while (n4 < n) {
                this._weaponExist[n4] = dataInputStream.readBoolean();
                this._weaponPackage[n4] = dataInputStream.readInt();
                ++n4;
            }
            n = this._bombPackage.length;
            int n5 = 0;
            while (n5 < n) {
                this._bombExist[n5] = dataInputStream.readBoolean();
                this._bombPackage[n5] = dataInputStream.readInt();
                ++n5;
            }
            n = this._taskOpen.length;
            int n6 = 0;
            while (n6 < n) {
                this._taskExist[n6] = dataInputStream.readBoolean();
                this._taskOpen[n6] = dataInputStream.readBoolean();
                ++n6;
            }
            n = this._killNumber.length;
            int n7 = 0;
            while (n7 < n) {
                this._killTarget[n7] = dataInputStream.readInt();
                this._killNumber[n7] = dataInputStream.readInt();
                ++n7;
            }
            this._leaderInx = dataInputStream.readInt();
            this._scenario = dataInputStream.readInt();
            this._money = dataInputStream.readInt();
            n = this._roleData.length;
            int n8 = 0;
            while (n8 < n) {
                this._existFlag[n8] = dataInputStream.readBoolean();
                this._roleData[n8].load(dataInputStream);
                ++n8;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

