/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.customise;

import com.sinaflying.customise.EngineSound;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

class SoundStandard
extends EngineSound {
    SoundStandard(int n) {
        this._soundFileNum = n;
        this._curPlayingSoundId = -1;
        this._sounds = new Player[n];
    }

    protected boolean openSoundsFromResDirMidiFile(String[] stringArray) {
        this._isOpenBinFile = false;
        this._soundFileName = stringArray;
        try {
            int n = 0;
            while (n < this._soundFileNum) {
                InputStream inputStream = this.openSoundFile(n);
                this._sounds[n] = Manager.createPlayer((InputStream)inputStream, (String)(this._soundFileName[n].indexOf(".mid") >= 0 ? "audio/midi" : (this._soundFileName[n].indexOf(".wav") >= 0 ? "audio/x-wav" : (this._soundFileName[n].indexOf(".amr") >= 0 ? "audio/amr" : (this._soundFileName[n].indexOf(".mp3") >= 0 ? "audio/mpeg" : "audio/unknow")))));
                this._sounds[n].realize();
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public void playSound(int n, int n2) {
        try {
            VolumeControl volumeControl;
            if (this._soundVolume <= 0) {
                return;
            }
            if (this._curPlayingSoundId >= 0 && this._curPlayingSoundId != n) {
                this.stopSound();
            }
            if ((volumeControl = (VolumeControl)this._sounds[n].getControl("VolumeControl")) != null) {
                volumeControl.setLevel(this._soundVolume);
            }
            this._sounds[n].setLoopCount(n2);
            this._sounds[n].start();
            this._curPlayingSoundId = n;
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public void stopSound() {
        try {
            if (this.isPlaySound()) {
                this._sounds[this._curPlayingSoundId].stop();
                while (this._sounds[this._curPlayingSoundId].getState() == 400) {
                    System.out.println("wait..");
                }
            }
            this._curPlayingSoundId = -1;
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }
}

