/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.ActorInfo;
import com.sinaflying.customise.R;
import com.sinaflying.engine.Avatar;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.game.Assistant;
import com.sinaflying.game.Bomb;
import com.sinaflying.game.Device;
import com.sinaflying.game.MainActor;
import com.sinaflying.game.Scene;
import javax.microedition.lcdui.Graphics;

public class Actor {
    protected boolean _closeAI;
    protected boolean _active;
    protected boolean _onGround;
    protected boolean _actionEnd;
    protected boolean _loopAction;
    protected boolean _isScriptEnd;
    protected int _type;
    protected int _gravity;
    protected int _palNo;
    protected int _flicker;
    protected int _actionNum;
    protected int _curAction = -1;
    protected int _action;
    protected int _flipFlag;
    protected int _curFrame;
    protected short _actFrmNum;
    protected int _l;
    protected int _r;
    protected int _t;
    protected int _b;
    protected int _vl;
    protected int _vr;
    protected int _vt;
    protected int _vb;
    protected int _al;
    protected int _ar;
    protected int _at;
    protected int _ab;
    protected int _id;
    protected int _x;
    protected int _y;
    protected int _dx;
    protected int _dy;
    protected int _vx;
    protected int _vy;
    protected int _ax;
    protected int _ay;
    protected int _fx;
    protected int _fy;
    protected int _destX;
    protected int _destY;
    protected Avatar _anim;
    protected Scene _scene;
    private ActorInfo _actorInfo;

    public Actor(int n, Avatar avatar) {
        this._type = n;
        this._anim = avatar;
        this._actionNum = avatar.getActionNum();
        this._active = false;
        this._closeAI = false;
    }

    public static final Actor createActor(int n, Avatar avatar) {
        if (Actor.isMainActorType(n)) {
            return new MainActor(n, avatar);
        }
        if (Actor.isBombActorType(n)) {
            return new Bomb(n, avatar);
        }
        if (Actor.isAssistantType(n)) {
            return new Assistant(n, avatar);
        }
        if (Actor.isDeviceType(n)) {
            return new Device(n, avatar);
        }
        return new Actor(n, avatar);
    }

    public static final boolean isMainActorType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return n >= 30 && n <= 59;
    }

    public static final boolean isBombActorType(int n) {
        switch (n) {
            case 61: 
            case 70: 
            case 73: 
            case 74: {
                return true;
            }
        }
        return false;
    }

    public static final boolean isAssistantType(int n) {
        switch (n) {
            case 72: 
            case 75: 
            case 77: 
            case 78: 
            case 79: 
            case 82: 
            case 90: 
            case 91: 
            case 92: {
                return true;
            }
        }
        return n >= 18 && n <= 29;
    }

    public static final boolean isDeviceType(int n) {
        switch (n) {
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return true;
            }
        }
        return false;
    }

    public Actor activate(Scene scene, int n) {
        this._id = n;
        this._active = true;
        this._scene = scene;
        return this;
    }

    public boolean init(byte[] byArray) {
        this._x = R.changeInt(byArray, 1, 2) << 10;
        this._y = R.changeInt(byArray, 3, 2) << 10;
        this._palNo = byArray[6];
        int n = byArray[5] & 0x3F;
        if ((byArray[5] & 0x80) != 0) {
            n |= Integer.MIN_VALUE;
        }
        if ((byArray[5] & 0x40) != 0) {
            n |= 0x40000000;
        }
        this.changeAction(n);
        this._dy = 0;
        this._dx = 0;
        this._vy = 0;
        this._vx = 0;
        this._ay = 0;
        this._ax = 0;
        this._fx = 61440;
        this._fy = 61440;
        this._flicker = 0;
        this._loopAction = true;
        this._gravity = 3072;
        ActorInfo actorInfo = ActorInfo.checkIsHaveCurActor(this._scene.getGameLogic().getLevel(), this._id);
        if (actorInfo != null) {
            this.changeAction(actorInfo.getCurAction());
            this._x = actorInfo.getCurX();
            this._y = actorInfo.getCurY();
        }
        return true;
    }

    public void init(int n, int n2, int n3) {
        this._x = n2;
        this._y = n3;
        this._dy = 0;
        this._dx = 0;
        this._vy = 0;
        this._vx = 0;
        this._ay = 0;
        this._ax = 0;
        this._fx = 61440;
        this._fy = 61440;
        this._palNo = 0;
        this._flicker = 0;
        this._loopAction = true;
        this._gravity = 3072;
        this.changeAction(n);
    }

    public final void changeAction(int n) {
        if (n == this._curAction) {
            return;
        }
        this._curAction = n;
        this._action = n & 0xFFFF;
        if (this._action < 0 || this._action > this._anim.getActionNum()) {
            return;
        }
        this._actionEnd = false;
        this._curFrame = 0;
        this._actFrmNum = this._anim.getActFrmNum(this._action);
        this._flipFlag = this._curAction & 0xF0000000;
        if ((this._flipFlag & Integer.MIN_VALUE) == 0) {
            this._l = this._anim._l[this._action];
            this._r = this._anim._r[this._action];
            this._vl = this._anim._vl;
            this._vr = this._anim._vr;
            this._al = this._anim._al[this._action];
            this._ar = this._anim._ar[this._action];
        } else {
            this._l = -this._anim._r[this._action];
            this._r = -this._anim._l[this._action];
            this._vl = -this._anim._vr;
            this._vr = -this._anim._vl;
            this._al = -this._anim._ar[this._action];
            this._ar = -this._anim._al[this._action];
        }
        if ((this._flipFlag & 0x40000000) == 0) {
            this._t = this._anim._t[this._action];
            this._b = this._anim._b[this._action];
            this._vt = this._anim._vt;
            this._vb = this._anim._vb;
            this._at = this._anim._at[this._action];
            this._ab = this._anim._ab[this._action];
        } else {
            this._t = -this._anim._b[this._action];
            this._b = -this._anim._t[this._action];
            this._vt = this._anim._vb;
            this._vb = -this._anim._vt;
            this._at = -this._anim._ab[this._action];
            this._ab = -this._anim._at[this._action];
        }
    }

    public boolean isFlip() {
        return this._flipFlag != 0;
    }

    public void setAI(boolean bl) {
        this._closeAI = bl;
    }

    public void ai() {
    }

    public void step() {
        if (this.isExecuteStep()) {
            this.nextFrame();
            this._dx = this._vx;
            this._dy = this._vy;
            this._vx += this._ax;
            this._vx = this._ax > 0 && this._vx > this._fx ? this._fx : this._vx;
            this._vx = this._ax < 0 && this._vx < -this._fx ? -this._fx : this._vx;
            this._vy += this._ay;
            this._vy = this._ay > 0 && this._vy > this._fy ? this._fy : this._vy;
            this._vy = this._ay < 0 && this._vy < -this._fy ? -this._fy : this._vy;
            this._x += this._dx;
            this._y += this._dy;
        }
    }

    public final void nextFrame() {
        ++this._curFrame;
        if (this._curFrame >= this._actFrmNum) {
            if (this._loopAction) {
                this._curFrame = 0;
                this._actionEnd = true;
            } else {
                --this._curFrame;
                this._actionEnd = true;
            }
        } else {
            this._actionEnd = false;
        }
    }

    public final boolean isExecuteAI() {
        return !this._closeAI;
    }

    public final boolean isExecuteStep() {
        return true;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (--this._flicker > 0 && (this._flicker & 1) == 0) {
            return;
        }
        int n5 = (this._x >> 10) - n - n3;
        int n6 = (this._y >> 10) - n2 - n4;
        if (n5 + this._vr < 0 || n5 + this._vl > 240) {
            return;
        }
        if (n6 + this._vb < 0 || n6 + this._vt > 320) {
            return;
        }
        this._anim.draw(graphics, n5, n6, this._curAction, this._curFrame, this._palNo);
    }

    public final boolean collide(int n, int n2, int n3, int n4) {
        if (this._l == this._r || this._t == this._b || n == n3 || n2 == n4) {
            return false;
        }
        int n5 = (this._x >> 10) + this._l;
        int n6 = (this._x >> 10) + this._r;
        int n7 = (this._y >> 10) + this._t;
        int n8 = (this._y >> 10) + this._b;
        return n6 >= n && n5 <= n3 && n8 >= n2 && n7 <= n4;
    }

    public final boolean collide(Actor actor) {
        if (this._l == this._r || this._t == this._b || actor._l == actor._r || actor._t == actor._b) {
            return false;
        }
        int n = (this._x >> 10) + this._l;
        int n2 = (this._x >> 10) + this._r;
        int n3 = (this._y >> 10) + this._t;
        int n4 = (this._y >> 10) + this._b;
        int n5 = (actor._x >> 10) + actor._l;
        int n6 = (actor._x >> 10) + actor._r;
        int n7 = (actor._y >> 10) + actor._t;
        int n8 = (actor._y >> 10) + actor._b;
        return n2 >= n5 && n <= n6 && n4 >= n7 && n3 <= n8;
    }

    private final void checkSceneDevice() {
        int n = Scene._activeInsts.length;
        int n2 = 0;
        while (n2 < n) {
            this.checkDeviceTop(Scene._activeInsts[n2]);
            ++n2;
        }
    }

    private final boolean checkDeviceTop(Actor actor) {
        if (actor == null || actor._type != 98 && actor._type != 96 || this._id == actor._id) {
            return false;
        }
        this._x += actor._dx;
        this._y += actor._dy;
        int n = this._x + (this._l << 10);
        int n2 = this._x + (this._r << 10);
        int n3 = this._y + (this._t << 10);
        int n4 = this._y + (this._b << 10);
        int n5 = actor._x + (actor._l << 10);
        int n6 = actor._x + (actor._r << 10);
        int n7 = actor._y + (actor._t << 10);
        int n8 = actor._y + (actor._b << 10);
        if (n2 < n5 || n > n6 || n4 < n7 || n3 > n8) {
            this._x -= actor._dx;
            this._y -= actor._dy;
            return false;
        }
        if (this._dy == 0) {
            return false;
        }
        this._y = n7;
        this._dy = 0;
        this._vy = 0;
        return true;
    }

    public boolean checkGround(int n) {
        int n2 = this._x + n >> 10;
        int n3 = this._y >> 10;
        int n4 = 0;
        while (n4 < 8) {
            if (this._scene.isSolidArea(null, n2, n3 + n4, 8, 1)) break;
            ++n4;
        }
        return n4 <= 4;
    }

    public void fall() {
        this._vy += this._vy < 4096 ? 3072 : 0;
        this._ay = 2048;
        this._fy = 61440;
        this._onGround = false;
        this.checkSceneDevice();
    }

    public boolean checkGround() {
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        byte[] byArray = this._scene._bk.getPhys(n, n2);
        if (byArray == null) {
            this.fall();
            return false;
        }
        int n3 = this._scene._bk.getTileWidth();
        int n4 = this._scene._bk.getTileHeigth();
        int n5 = n % n3;
        int n6 = n2 % n4;
        int n7 = n6 * n3 / 8;
        int n8 = n5 / 8;
        int n9 = n5 % 8;
        int n10 = 0;
        while (n10 < 8 && n6 + n10 < n4) {
            byte by = byArray[n7 + n3 / 8 * n10 + n8];
            if (((by = (byte)(by << n9)) & 0x80) != 0) {
                this._y = n2 / n4 * n4 + n6 + n10 << 10;
                this._vy = 0;
                this._dy = 0;
                this._onGround = true;
                if (n10 > 0) {
                    return true;
                }
                this._y -= 8192;
                this.checkUp();
                return true;
            }
            ++n10;
        }
        return this.checkFall();
    }

    public boolean checkFall() {
        int n = this._x >> 10;
        int n2 = (this._y >> 10) + 2;
        byte[] byArray = this._scene._bk.getPhys(n, n2);
        if (byArray == null) {
            this.fall();
            return false;
        }
        int n3 = this._scene._bk.getSolidGround(byArray, n, n2);
        if (n3 > 0) {
            this._y = n3 << 10;
            this._vy = 0;
            this._dy = 0;
            this._onGround = true;
            return true;
        }
        this.fall();
        return false;
    }

    public boolean checkUp() {
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        byte[] byArray = this._scene._bk.getPhys(n, n2);
        if (byArray == null) {
            this._y += 8192;
            this._dy = 0;
            return true;
        }
        int n3 = this._scene._bk.getSolidGround(byArray, n, n2);
        if (n3 > 0) {
            this._y = n3 << 10;
            this._vy = 0;
            this._dy = 0;
            return true;
        }
        this._y += 8192;
        this._dy = 0;
        return true;
    }

    public boolean checkLeftWall(int n) {
        if (this._dx >= 0) {
            return false;
        }
        int n2 = (this._x + n >> 10) - 6;
        int n3 = (this._y >> 10) - 12;
        if (n2 < 0) {
            this._dx = 0;
            this._vx = 0;
            return true;
        }
        int n4 = 0;
        while (n4 < 4) {
            byte[] byArray = this._scene._bk.getPhys(n2, n3);
            if (byArray != null && this._scene.isSolidPoint(byArray, n2, n3)) {
                this._dx = 0;
                this._vx = 0;
                return true;
            }
            ++n4;
            --n3;
        }
        return false;
    }

    public boolean checkRightWall(int n) {
        if (this._dx <= 0) {
            return false;
        }
        int n2 = (this._x + n >> 10) + 6;
        int n3 = (this._y >> 10) - 12;
        if (n2 > this._scene._bk.getWidth()) {
            this._dx = 0;
            this._vx = 0;
            return true;
        }
        int n4 = 0;
        while (n4 < 4) {
            byte[] byArray = this._scene._bk.getPhys(n2, n3);
            if (byArray != null && this._scene.isSolidPoint(byArray, n2, n3)) {
                this._dx = 0;
                this._vx = 0;
                return true;
            }
            ++n4;
            --n3;
        }
        return false;
    }

    public void moveScreen() {
    }

    public final void lrWalk(int n, int n2) {
        int n3 = (this._x >> 10) / this._scene._bk.tw;
        int n4 = (this._y >> 10) / this._scene._bk.th;
        n3 = n3 * this._scene._bk.tw << 10;
        n4 = n4 * this._scene._bk.tw << 10;
        this._destX = n * this._scene._bk.tw << 10;
        this._destY = n2 * this._scene._bk.tw << 10;
        int n5 = Math.abs((this._destX - n3) / 4096);
        int n6 = Math.abs((this._destY - n4) / 4096);
        int n7 = Math.max(n5, n6);
        this._vx = (this._destX - n3) / n7;
        this._vy = (this._destY - n4) / n7;
        this._destX = n;
        this._destY = n2;
        this.changeToWalk(1 | (this._vx > 0 ? 0 : Integer.MIN_VALUE));
    }

    public boolean isArrivd() {
        int n = (this._x >> 10) / this._scene._bk.tw;
        int n2 = (this._y >> 10) / this._scene._bk.tw;
        if (this._destX == n && this._destY == n2) {
            this.changeToWait();
            return true;
        }
        return false;
    }

    protected boolean isMatchTriggerCondition() {
        return this.isCollideMain() && this.isPressConfirmKey();
    }

    public boolean scriptHandle() {
        if (7 < Scene._actorInitData[this._id].length) {
            byte by = Scene._actorInitData[this._id][7];
            switch (by) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this.isMatchTriggerCondition();
                }
                case 2: {
                    return this.isCollideMain();
                }
            }
        }
        return false;
    }

    public final boolean isPressConfirmKey() {
        return KeyCode.getCurKey() == 16;
    }

    public final boolean isCollideMain() {
        return this.collide(this._scene.getFocusActor());
    }

    public void changeToWait() {
        this._vx = 0;
        this._vy = 0;
        this.changeAction(0 | this._flipFlag);
    }

    protected void changeToWalk(int n) {
        if (this._type != 18) {
            this.changeAction(n);
        }
    }

    protected int getDrawPriority() {
        switch (this._type) {
            case 0: {
                return 11;
            }
            case 1: {
                return 10;
            }
            case 2: {
                return 9;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: {
                return 12;
            }
            case 79: 
            case 91: 
            case 96: 
            case 98: {
                return 0;
            }
        }
        return 8;
    }

    protected int getUpdatePriority() {
        switch (this._type) {
            case 0: {
                return 3;
            }
            case 72: 
            case 96: 
            case 98: {
                return 4;
            }
        }
        return 0;
    }

    protected void disActive() {
        this._active = false;
        this._scene.disActiveInst(this._id);
    }

    public int getXDirLocation(int n) {
        return this._x - n / 2;
    }

    public int getXSceen(int n) {
        return this._x - n;
    }

    public int getYSceen(int n) {
        return this._y - n;
    }

    public int getYDirLocation(int n) {
        return this._y - n * 3 / 5;
    }

    public boolean isActionEnd() {
        return this._actionEnd;
    }

    public int getCurAction() {
        return this._curAction;
    }

    public boolean needDisActive() {
        return false;
    }

    public ActorInfo getCurActorInfo() {
        return this._actorInfo;
    }

    public void setActorInfo(int n, int n2, int n3) {
        if (this._actorInfo == null) {
            this._actorInfo = ActorInfo.checkIsHaveCurActor(this._scene.getGameLogic().getLevel(), this._id);
            if (this._actorInfo == null) {
                this._actorInfo = new ActorInfo();
            }
        }
        this._actorInfo.setCurAction(n);
        this._actorInfo.setCurCoordinate(n2, n3);
    }
}

