/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.Avatar;
import com.sinaflying.game.Actor;
import com.sinaflying.game.Device;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.MainActor;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import javax.microedition.lcdui.Graphics;

public class Bomb
extends Actor {
    private static int[] _collideMainId;
    static boolean ISDEATH;
    static boolean ISDEVICE;
    static Device _deviveBuffer;
    static int[] _deviveId;
    static int _index;
    private static int _curActorExp;
    static int _bombId;
    int _bombType;
    int _fireMode;
    int _step;
    int _traceNum;
    int _delay;
    int _aimX;
    int _aimY;
    int _stepNum;
    static int _counterNum;
    static int _mainId;
    static int _deviceId;
    static int _mainIdBuffer;
    static int _hurtValue;
    int _deday = 0;
    boolean _bombing;
    int[] _aimInfo = new int[7];
    static int[] _isExpfinish;
    public static int[] _globalFireInfo;
    static Actor[] _trace;
    int _once;
    boolean _result;
    public static int[][] PARAM;
    int[] crenelPos;
    static boolean _isBombNull;
    int _newId;

    public Bomb(int n, Avatar avatar) {
        super(n, avatar);
    }

    public static void loadBombDB() {
        try {
            GameDB gameDB = GameDB.getGameDataBase();
            int n = gameDB.getDataNum(4);
            PARAM = new int[n][6];
            int n2 = 0;
            while (n2 < n) {
                DataTable dataTable = gameDB.getData(4, n2);
                Bomb.PARAM[n2][1] = dataTable.getIntItem(4);
                Bomb.PARAM[n2][2] = dataTable.getIntItem(5);
                Bomb.PARAM[n2][3] = dataTable.getIntItem(6);
                Bomb.PARAM[n2][0] = dataTable.getIntItem(8);
                Bomb.PARAM[n2][4] = dataTable.getIntItem(10);
                Bomb.PARAM[n2][5] = dataTable.getIntItem(3);
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void initGlobalData() {
        Bomb._globalFireInfo[0] = 0;
        Bomb._globalFireInfo[1] = 0;
    }

    private void loadCrenelPos(int[] nArray) {
        this.crenelPos = new int[nArray.length];
        System.arraycopy(nArray, 0, this.crenelPos, 0, this.crenelPos.length);
    }

    public void initBomb(int[] nArray) {
        this.loadCrenelPos(nArray);
        this._x = nArray[2];
        this._y = nArray[3];
        this._vx = nArray[4];
        this._vy = nArray[5];
        this._ax = nArray[6];
        this._ay = nArray[7];
        this._fx = nArray[8];
        this._fy = nArray[9];
        this._aimX = nArray[13];
        this._aimY = nArray[14];
        _bombId = nArray[17];
        this._result = false;
        _hurtValue = nArray[15];
        _counterNum = nArray[11];
        this._bombing = false;
        this._loopAction = true;
        _isBombNull = false;
        this._once = 0;
        _deviceId = _mainId = nArray[12];
        if (_deviceId != 99) {
            _globalFireInfo[0] = _globalFireInfo[0] + 1;
        }
        this._traceNum = 0;
        if (_mainId == 99) {
            _mainId = _mainIdBuffer;
            this._bombing = true;
            this.changeAction(this._actionNum - 1);
        } else {
            _mainIdBuffer = _mainId;
            this.changeAction(nArray[1]);
        }
        _trace = PARAM[_bombId][2] > 0 ? new Actor[PARAM[_bombId][2]] : null;
        _index = 0;
    }

    public void initTrace(int[] nArray) {
        this.loadCrenelPos(nArray);
        this._x = nArray[2];
        this._y = nArray[3];
        this._vx = nArray[4];
        this._vy = nArray[5];
        this._ax = nArray[6];
        this._ay = nArray[7];
        this._fx = nArray[8];
        this._fy = nArray[9];
        this._loopAction = true;
        this._bombing = false;
        this.changeAction(PARAM[_bombId][3]);
    }

    public final void initFire(int n, int n2, int n3) {
        this._x = n;
        this._y = n2;
        this._vx = 0;
        this._vy = 0;
        this._step = 0;
        this._delay = 0;
        this._bombing = false;
        this._fireMode = n3;
        int n4 = PARAM[_bombId][0];
        this._curAction = -1;
        this.changeAction(n4);
        this._stepNum = _counterNum > 1 ? 0 : 4;
        if (_deviceId != 99) {
            _globalFireInfo[1] = _globalFireInfo[1] + 1;
        }
        int n5 = 0;
        while (n5 < this._aimInfo.length) {
            this._aimInfo[n5] = 0;
            ++n5;
        }
        this._scene.startUpShake(4, 4);
    }

    public void step() {
        if (this._delay > 0) {
            return;
        }
        this.nextFrame();
        this._dy = this._vy;
        this._dx = this._vx;
        this._vx += this._ax;
        this._vy += this._ay;
        if (this._ay > 0 && this._vy > this._fy) {
            this._vy = this._fy;
        }
        if (this._ay < 0 && this._vy < -this._fy) {
            this._vy = -this._fy;
        }
        if (this._ax > 0 && this._vx > this._fx) {
            this._vx = this._fx;
        } else if (this._ax < 0 && this._ax < -this._fx) {
            this._vx = -this._fx;
        }
        int n = 0;
        while (n < 16) {
            this._x += this._dx / 16;
            this._y += this._dy / 16;
            if (this._type == 61) {
                if (this.checkBombing()) {
                    return;
                }
            } else if (this._type == 73) {
                this.fireStep();
            }
            ++n;
        }
        if (this._type == 61) {
            this.checkBombing1();
        }
    }

    public void ai() {
        switch (this._type) {
            case 61: {
                this.bombAi();
                break;
            }
            case 73: {
                this.fireAi();
                break;
            }
            case 70: {
                if (!_isBombNull) break;
                this._active = false;
                this._scene.disActiveInst(this._id);
                int n = 0;
                while (n < Scene._mainActor[Bomb._mainId]._bombId.length) {
                    if (Scene._mainActor[Bomb._mainId]._bombId[n] >= 0) break;
                    ++n;
                }
                if (n < Scene._mainActor[Bomb._mainId]._bombId.length) break;
                Scene.getInstance().endBombing();
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._delay <= 0) {
            super.draw(graphics, n, n2, 0, 0);
        }
    }

    public void bombAi() {
        if (this._bombing) {
            if (this.toolJump()) {
                return;
            }
            this.disActive();
            _isBombNull = true;
            this.fetchFire();
            Scene._mainActor[_mainId].changeBombId(this._newId, this._id);
        } else {
            this.calcuBombFlyAngle();
            this.fetchTrace();
        }
    }

    public boolean toolJump() {
        this._bombType = PARAM[_bombId][4];
        if (this._bombType == 8 && !this._result) {
            if (this._once == 0) {
                this.changeAction(32);
                Scene._mainActor[_mainId].setPos(this._x, this._y);
                Scene._mainActor[_mainId].fiyEffect();
                ++this._once;
            }
            if (!Scene._mainActor[_mainId].isflyState()) {
                this._once = 0;
                this._result = true;
                this.disActive();
                this._scene.endBombing();
            }
            return true;
        }
        return false;
    }

    public boolean noActorCollide() {
        int n = 0;
        while (n < Scene._tankNum) {
            if (_collideMainId[n] >= 0) {
                if (Scene._actorExistFlag[0][n] > 0) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public void isAllActorFinsih() {
        int n = 0;
        if (this.noActorCollide()) {
            n = 0;
            while (n < Scene._tankNum) {
                if (_collideMainId[n] >= 0 && Scene._mainActor[_collideMainId[n]].isHurtOver()) {
                    this.disActive();
                }
                ++n;
            }
        } else {
            this.disActive();
        }
    }

    public void consumExpLevel() {
        if (Scene._mainActor[_mainId].isDoubleAttach()) {
            _globalFireInfo[1] = _globalFireInfo[1] - 1;
            this._scene.disActiveInst(this._id);
            Scene.changeFocus(Scene._mainActor[_mainId], (byte)0);
            return;
        }
        int n = 0;
        if (ISDEATH) {
            n = 0;
            while (n < Scene._tankOneTeamNum) {
                if (!Scene._mainActor[n].isDeathState()) {
                    if (_isExpfinish[n] == -1 && !Scene.isAllEnd) {
                        if (Scene._state != 4) {
                            int n2 = 0;
                            while (n2 < Scene._mainActor[Bomb._mainId]._bombId.length) {
                                if (Scene._mainActor[Bomb._mainId]._bombId[n2] >= 0) {
                                    return;
                                }
                                ++n2;
                            }
                        }
                        if (Scene._mainActor[Bomb._mainId]._bParam[11] > 0) {
                            return;
                        }
                        RoleTeamData roleTeamData = RoleTeamData.getInstance();
                        GameRoleData gameRoleData = roleTeamData.getRoleData(n);
                        if (gameRoleData.getRoleInx()[1] < 20 && Scene._mainActor[n].consumeExperience(_curActorExp)) {
                            Bomb._isExpfinish[n] = 1;
                            Scene.isAllEnd = true;
                            this._scene.setExpForMainActor(n);
                            Scene._mainActor[n].setUesTool(16);
                            return;
                        }
                        Bomb._isExpfinish[n] = 1;
                    }
                } else {
                    Bomb._isExpfinish[n] = 1;
                }
                ++n;
            }
            n = 0;
            while (n < Scene._tankOneTeamNum) {
                if (_isExpfinish[n] == -1) break;
                ++n;
            }
            if (n == Scene._tankOneTeamNum && !Scene.isAllEnd) {
                ISDEATH = false;
                n = 0;
                while (n < Scene._tankOneTeamNum) {
                    Bomb._isExpfinish[n] = -1;
                    ++n;
                }
                _curActorExp = 0;
                this.isAllActorFinsih();
                return;
            }
        } else {
            ISDEATH = false;
            this.isAllActorFinsih();
        }
    }

    private void isCollideDecice() {
        int n = 0;
        while (n < 3) {
            if (_deviveId[n] != -1) {
                if (Scene._activeInsts[_deviveId[n]] != null) {
                    switch (Scene._activeInsts[Bomb._deviveId[n]]._type) {
                        case 99: {
                            ((Device)Scene._activeInsts[_deviveId[n]]).changeExploderFire();
                        }
                    }
                }
            }
            ++n;
        }
        if (_deviveBuffer != null) {
            switch (Bomb._deviveBuffer._type) {
                case 98: {
                    if (!_deviveBuffer.canBoardMove()) break;
                    this.consumExpLevel();
                    ISDEVICE = false;
                    break;
                }
                case 99: {
                    this._scene.disActiveInst(this._id);
                    _globalFireInfo[1] = _globalFireInfo[1] - 1;
                    ISDEVICE = false;
                    int n2 = 0;
                    while (n2 < 3) {
                        Bomb._deviveId[n2] = -1;
                        ++n2;
                    }
                    break;
                }
            }
        }
    }

    public void fireAi() {
        int n;
        int n2;
        if (this._delay-- > 0) {
            return;
        }
        if (!this._bombing && (this._fireMode & 0xFFFFFF) != 8 && this._scene != null) {
            this._bombing = true;
            n2 = this._x >> 10;
            n = this._y >> 10;
            this._scene._bk.bombAt(n2, n, PARAM[_bombId][1]);
        }
        switch (this._fireMode & 0xFFFFFF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 9: {
                this.attack();
                if (!this.isActionEnd()) break;
                ++this._deday;
                if (this._deday <= this._stepNum) break;
                if (ISDEVICE) {
                    this.isCollideDecice();
                    break;
                }
                this.consumExpLevel();
                break;
            }
            case 5: {
                Bomb bomb;
                this.attack();
                if (this.isActionEnd()) {
                    ++this._deday;
                    if (this._deday <= this._stepNum) break;
                    if (ISDEVICE) {
                        this.isCollideDecice();
                        break;
                    }
                    if (Scene._mainActor[_mainId].isDoubleAttach()) {
                        this.disActive();
                        Scene.changeFocus(Scene._mainActor[_mainId], (byte)0);
                        return;
                    }
                    this.consumExpLevel();
                    break;
                }
                if (this._curFrame != 1 || this._step++ >= 4 || (bomb = (Bomb)Scene.fetchActorForBomb(73)) == null) break;
                n = this._x;
                int n3 = 0;
                n3 = (this._fireMode & Integer.MIN_VALUE) != 0 ? -10240 : 10240;
                bomb.initFire(n += n3, this._y, this._fireMode);
                bomb._step = this._step;
                if (!bomb.checkGround()) {
                    n -= n3;
                    break;
                }
                if (n3 < 0 && bomb.checkLeftWall(0)) {
                    n -= n3;
                    break;
                }
                if (n3 <= 0 || !bomb.checkRightWall(0)) break;
                n += n3;
                break;
            }
            case 10: {
                int n4 = n2 = (this._fireMode & 0x20000000) != 0 ? 1 : 0;
                if (n2 != 0) {
                    this.attack();
                    if (this._curFrame == 2 && this._step < 4) {
                        int[] nArray;
                        n = Scene._camy;
                        int n5 = this._x >> 10;
                        int n6 = Scene._camy + Scene._camh >> 10;
                        int n7 = n5 + (30 - Function.Random(60));
                        if (this._scene.findSolidPoint(n7, 0, n6, nArray = new int[2])) {
                            nArray[0] = nArray[0] << 10;
                            nArray[1] = nArray[1] << 10;
                            this.productRayPole(nArray[0], nArray[1], n, false);
                        } else {
                            this.productRayPole(n7 <<= 10, n + Scene._camh, n, false);
                        }
                        nArray = null;
                    }
                }
                if (!this.isActionEnd()) break;
                ++this._deday;
                if (this._deday <= this._stepNum) break;
                if (ISDEVICE) {
                    this.isCollideDecice();
                    break;
                }
                if (Scene._mainActor[_mainId].isDoubleAttach()) {
                    this.disActive();
                    Scene.changeFocus(Scene._mainActor[_mainId], (byte)0);
                    return;
                }
                this.consumExpLevel();
            }
        }
    }

    public void fireStep() {
        if ((this._fireMode & 0xFFFFFF) == 5) {
            this.checkLeftWall(0);
            this.checkRightWall(0);
            if (!this.checkGround()) {
                this._vx = 0;
            }
        }
    }

    public boolean checkBombing1() {
        if (this._bombing) {
            return false;
        }
        if (!this._bombing) {
            Scene scene = GameMainLogic._scene;
            int n = 51200;
            int n2 = Scene._camx - n;
            int n3 = Scene._camx + Scene._camw + n;
            int n4 = Scene._camy + Scene._camh + n;
            int n5 = this._x >> 10;
            int n6 = this._y >> 10;
            if (this._vx <= 0 && this._x < n2 || this._vx >= 0 && this._x > n3 || this._vy >= 0 && this._y > n4) {
                this.disActive();
                int n7 = 0;
                while (n7 < Scene._mainActor[Bomb._mainId]._bombId.length) {
                    if (Scene._mainActor[Bomb._mainId]._bombId[n7] >= 0) {
                        Scene._mainActor[Bomb._mainId]._bombId[n7] = -1;
                    }
                    ++n7;
                }
                if (_globalFireInfo[0] <= 0 && _globalFireInfo[1] <= 0) {
                    if (Scene._mainActor[Bomb._mainId]._bParam[11] <= 0) {
                        scene.endBombing();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkBombing() {
        if (this._bombing) {
            return false;
        }
        if (!this._bombing) {
            Scene scene = GameMainLogic._scene;
            int n = 51200;
            int n2 = Scene._camx - n;
            int n3 = Scene._camx + Scene._camw + n;
            int n4 = Scene._camy + Scene._camh + n;
            int n5 = this._x >> 10;
            int n6 = this._y >> 10;
            if (scene.isSolidArea(null, n5, n6, 8, 4)) {
                this._bombing = true;
            } else if (this.bombFlyingCollision()) {
                this._bombing = true;
            } else if (this.bombCollisionDevice()) {
                this._bombing = true;
            }
        }
        if (this._bombing) {
            this._vy = 0;
            this._vx = 0;
            this._ay = 0;
            this._ax = 0;
            this._y += 4096;
        }
        return this._bombing;
    }

    private final void attack() {
        Scene scene = this._scene;
        int n = 0;
        while (n < Scene._tankNum) {
            if (Scene._actorExistFlag[0][n] >= 0) {
                int n2 = 0;
                if (this.collide(Scene._mainActor[n]) && this.testHitFlag(n)) {
                    n2 = Scene._mainActor[Bomb._mainId]._type > 2 ? 1 : 0;
                    if (Scene._actorExistFlag[1][n] == n2) {
                        if (!Scene._mainActor[_mainId].isTeaching() && Scene._state != 4) {
                            if (_deviveBuffer != null) {
                                if (ISDEVICE) {
                                    return;
                                }
                            } else {
                                return;
                            }
                        }
                    }
                    Bomb._collideMainId[n] = n;
                    Scene._mainActor[n]._rcInfo[0] = Scene._mainActor[n]._id;
                    if (Scene._state == 4 && Scene._mainActor[n]._type <= 2) {
                        return;
                    }
                    if (Scene._mainActor[_collideMainId[n]].consumeHp(-_hurtValue)) {
                        MainActor mainActor = Scene._mainActor[_collideMainId[n]];
                        if (mainActor._type > 2) {
                            ISDEATH = true;
                            GameDB gameDB = GameDB.getGameDataBase();
                            DataTable dataTable = gameDB.getData(1, mainActor._mainActorInfo[1]);
                            _curActorExp += dataTable.getIntItem(2);
                        } else {
                            _curActorExp = 0;
                        }
                    }
                    Scene._mainActor[_mainId].consumeAngry(5);
                    if (_mainId < 10) {
                        if (Scene._mainActor[_mainId].isLightAttack()) {
                            Scene._mainActor[_collideMainId[n]].setStopIcon();
                        }
                    }
                }
            }
            ++n;
        }
    }

    private final boolean bombFlyingCollision() {
        Scene scene = this._scene;
        int n = 0;
        while (n < Scene._tankNum) {
            if (!Scene._mainActor[n].isDeathState() && Scene._actorExistFlag[0][n] >= 0) {
                MainActor mainActor = Scene._mainActor[n];
                if (this.collide(mainActor) && Scene._actorExistFlag[1][n] != this._scene._lastTeam) {
                    return true;
                }
                if (this.collide(mainActor) && !this._scene.isScriptEnd()) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private final boolean bombCollisionDevice() {
        Scene scene = this._scene;
        int n = 0;
        while (n < Scene._activeInsts.length) {
            if (Scene._activeInsts[n] instanceof Device && this.collide(Scene._activeInsts[n])) {
                if (((Device)Scene._activeInsts[n])._type == 99) {
                    Bomb._deviveId[Bomb._index] = n;
                    ++_index;
                    ISDEVICE = true;
                    _deviveBuffer = (Device)Scene._activeInsts[n];
                    _deviveBuffer.changeAction(Bomb._deviveBuffer._curAction + 1);
                    return true;
                }
                if (((Device)Scene._activeInsts[n])._type == 97) {
                    ((Device)Scene._activeInsts[n]).collideBoxProcess();
                    return false;
                }
                if (((Device)Scene._activeInsts[n])._type == 98) {
                    if (((Device)Scene._activeInsts[n]).canBoardMove()) {
                        ISDEVICE = true;
                        _deviveBuffer = (Device)Scene._activeInsts[n];
                        Scene.changeFocus(_deviveBuffer, (byte)1);
                        ((Device)Scene._activeInsts[n]).changeBoardMove();
                    }
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private final boolean testHitFlag(int n) {
        if (this._aimInfo[n] > 0) {
            return false;
        }
        this._aimInfo[n] = 1;
        return true;
    }

    private void fetchFire() {
        Scene scene = this._scene;
        int n = this._x >> 10;
        int n2 = this._y >> 10;
        this._bombType = PARAM[_bombId][4];
        switch (this._bombType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                Bomb bomb = (Bomb)Scene.fetchActorForBomb(73);
                if (bomb == null) break;
                bomb.initFire(this._x, this._y, this._fireMode);
                this._newId = bomb._id;
                break;
            }
            case 9: 
            case 10: {
                int[] nArray = new int[2];
                int n3 = Scene._camy + Scene._camh >> 10;
                if (scene.findSolidPoint(n, 0, n3, nArray)) {
                    nArray[0] = nArray[0] << 10;
                    nArray[1] = nArray[1] << 10;
                    this.productRayPole(nArray[0], nArray[1], Scene._camy, true);
                } else {
                    this.productRayPole(this._x, Scene._camy + Scene._camh, Scene._camy, true);
                }
                nArray = null;
                break;
            }
            case 5: {
                int n4 = 0;
                while (n4 < 2) {
                    int n5;
                    Bomb bomb = (Bomb)Scene.fetchActorForBomb(73);
                    int n6 = n5 = n4 == 0 ? Integer.MIN_VALUE : 0x40000000;
                    if (bomb != null) {
                        bomb.initFire(this._x, this._y, this._fireMode | n5);
                    }
                    ++n4;
                }
                break;
            }
            case 7: {
                int[] nArray = new int[2];
                int n7 = Scene._camh >> 10;
                int n8 = 0;
                while (n8 < 5) {
                    int n9;
                    Bomb bomb = (Bomb)Scene.fetchActorForBomb(73);
                    int n10 = n8 % 2 == 0 ? -1 : 1;
                    int n11 = n + n8 / 2 * 10 * n10 + (n9 = n10 * 10);
                    if (scene.findSolidPoint(n11, n2 - 40, n2 + 40, nArray)) {
                        nArray[0] = nArray[0] << 10;
                        nArray[1] = nArray[1] << 10;
                        bomb.initFire(nArray[0], nArray[1], this._fireMode);
                    } else {
                        bomb.initFire(this._x, this._y, this._fireMode);
                    }
                    bomb._delay = n8 / 2 * 3;
                    ++n8;
                }
                nArray = null;
            }
        }
    }

    private void productRayPole(int n, int n2, int n3, boolean bl) {
        int n4 = this._fireMode & 0xFFFFFF;
        Bomb bomb = (Bomb)Scene.fetchActorForBomb(73);
        if (bomb != null) {
            bomb.initFire(n, n2, n4 | 0x20000000);
            if (!bl) {
                bomb._step = this._step + 1;
            }
        }
        while (n2 > n3) {
            bomb = (Bomb)Scene.fetchActorForBomb(73);
            if (bomb != null) {
                bomb.initFire(n, n2, n4 | 0x10000000);
            }
            n2 -= 20480;
        }
    }

    private void fetchTrace() {
        if (PARAM[_bombId][2] <= 0 || !this._active) {
            return;
        }
        Bomb bomb = null;
        if (this._traceNum >= PARAM[_bombId][2]) {
            return;
        }
        bomb = (Bomb)Scene.fetchActorForBomb(70);
        if (_trace != null) {
            Bomb._trace[this._traceNum] = bomb;
            ++this._traceNum;
        }
        if (bomb != null) {
            bomb.initTrace(this.crenelPos);
        }
    }

    private int getCurAction(int n) {
        if (n == 10 || n == 11 || n == 22 || n == 23 || n == 24 || n == 25) {
            return 1;
        }
        if (n == 4 || n == 5 || n == 12 || n == 26 || n == 27 || n == 30 || n == 31 || n == 34 || n == 35 || n == 40) {
            return 2;
        }
        return 0;
    }

    public void calcuBombFlyAngle() {
        if (PARAM[_bombId][5] != 18 && PARAM[_bombId][5] != 27) {
            return;
        }
        if (Scene._mainActor[Bomb._mainId]._bParam[11] > 0) {
            return;
        }
        int n = Math.abs(this._vx);
        int n2 = Math.abs(this._vy);
        if (this.getCurAction(Scene._mainActor[Bomb._mainId]._action) == 1 || n < 2048) {
            if (this._vy >= 0) {
                this.changeAction(PARAM[_bombId][5] + 8 | this._flipFlag);
            } else {
                this.changeAction(PARAM[_bombId][5] + 0 | this._flipFlag);
            }
        } else if (this.getCurAction(Scene._mainActor[Bomb._mainId]._action) == 2 && n2 > 2048) {
            if (this._vy < 10240) {
                this.changeAction(PARAM[_bombId][5] + 4 | this._flipFlag);
            } else if (this._vy < 20480) {
                this.changeAction(PARAM[_bombId][5] + 5 | this._flipFlag);
            } else if (this._vy < 30720) {
                this.changeAction(PARAM[_bombId][5] + 6 | this._flipFlag);
            }
        } else if (n2 < 2048) {
            this.changeAction(PARAM[_bombId][5] + 4 | this._flipFlag);
        } else if (this._vy < 0) {
            if (this._vy < this.crenelPos[5] * 2 / 3) {
                this.changeAction(PARAM[_bombId][5] + 1 | this._flipFlag);
            } else if (this._vy < this.crenelPos[5] * 1 / 3) {
                this.changeAction(PARAM[_bombId][5] + 2 | this._flipFlag);
            } else {
                this.changeAction(PARAM[_bombId][5] + 3 | this._flipFlag);
            }
        } else if (this._vy < Math.abs(this.crenelPos[5]) * 1 / 3) {
            this.changeAction(PARAM[_bombId][5] + 5 | this._flipFlag);
        } else if (this._vy < Math.abs(this.crenelPos[5]) * 2 / 3) {
            this.changeAction(PARAM[_bombId][5] + 6 | this._flipFlag);
        } else if (this._vy < Math.abs(this.crenelPos[5]) * 4 / 5) {
            this.changeAction(PARAM[_bombId][5] + 7 | this._flipFlag);
        }
    }

    protected void disActive() {
        if (this._type == 61) {
            _globalFireInfo[0] = _globalFireInfo[0] - 1;
        } else if (this._type == 73) {
            _globalFireInfo[1] = _globalFireInfo[1] - 1;
            if (_globalFireInfo[0] <= 0 && _globalFireInfo[1] <= 0) {
                if (this._scene.getceneTeach()) {
                    Scene._mainActor[_mainId].closeTeach();
                    this._scene.setMainFocus();
                } else if (this._scene.isScriptEnd() && Scene._mainActor[Bomb._mainId]._bParam[11] <= 0) {
                    this._scene.endBombing();
                }
                _deviveBuffer = null;
            }
        }
        this._deday = 0;
        this._scene.disActiveInst(this._id);
        this._vx = 0;
        this._vy = 0;
        int n = 0;
        while (n < 7) {
            Bomb._collideMainId[n] = -1;
            ++n;
        }
    }

    static {
        _deviveId = new int[]{-1, -1, -1};
        _collideMainId = new int[7];
        int n = 0;
        while (n < 7) {
            Bomb._collideMainId[n] = -1;
            ++n;
        }
        _isExpfinish = new int[]{-1, -1, -1};
        _globalFireInfo = new int[2];
    }
}

