/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.game.Actor;
import com.sinaflying.game.Follower;

public class FollowManager {
    private Actor _followTarget;
    private int _followTargetPosX;
    private Follower _follower;
    int _type;
    private int[][] _traceInfo = new int[300][2];
    private int _head;
    private int _rear;
    private boolean _isHeadThrough;

    public FollowManager(Follower follower) {
        this._follower = follower;
    }

    public final void init(Actor actor, int n, int n2, int n3, int n4) {
        this._followTarget = actor;
        this.resetTraceInfo();
        this._type = n;
        this.initTraceInfo(n2, n3, n4);
    }

    public final void followHandle() {
        int n = this.updateTargetTraceInfo();
        if (n == 0) {
            this.waitForTarget();
        } else {
            this.followTarget(n);
        }
    }

    private final void waitForTarget() {
        this._follower.standBy();
    }

    private final int updateTargetTraceInfo() {
        int n = this._followTarget.getXSceen(0);
        if (n > this._followTargetPosX + (this._type * 35 << 10)) {
            int n2 = Math.abs(n - this._followTargetPosX);
            if (n2 > 30720) {
                this._followTargetPosX += 4096;
                n2 = 4096;
            } else {
                this._followTargetPosX = n + (this._type * 35 << 10);
            }
            this.setTrace(2, n2);
            return n2;
        }
        if (n < this._followTargetPosX - (this._type * 35 << 10)) {
            int n3 = Math.abs(this._followTargetPosX - n);
            if (n3 > 30720) {
                this._followTargetPosX -= 4096;
                n3 = 4096;
            } else {
                this._followTargetPosX = n - (this._type * 35 << 10);
            }
            this.setTrace(1, n3);
            return n3;
        }
        return 0;
    }

    private final void followTarget(int n) {
        int n2;
        do {
            int[] nArray;
            if ((nArray = this.getTrace())[1] > n) {
                n2 = n;
                nArray[1] = nArray[1] - n;
            } else {
                n2 = nArray[1];
                this.goToNextRearPos();
            }
            this.moveHandle(nArray[0], n2);
        } while ((n -= n2) > 0);
    }

    private final void moveHandle(int n, int n2) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this._follower.moveToLeft(n2);
                break;
            }
            case 2: {
                this._follower.moveToRight(n2);
                break;
            }
            default: {
                System.out.println("FollowManager::moveHandle error, direction invalid, is : " + n);
            }
        }
    }

    private final void initTraceInfo(int n, int n2, int n3) {
        this._followTargetPosX = n;
    }

    public final void resetTraceInfo() {
        this._head = 0;
        this._rear = 0;
        this._isHeadThrough = false;
    }

    public final void setTrace(int n, int n2) {
        this._traceInfo[this._head][0] = n;
        this._traceInfo[this._head][1] = n2;
        this.goToNextHeadPos();
    }

    private final void goToNextHeadPos() {
        if (++this._head >= 300) {
            this._head = 0;
            this._isHeadThrough = true;
        }
    }

    public final int[] getTrace() {
        return this._traceInfo[this._rear];
    }

    public final void goToNextRearPos() {
        if (++this._rear >= 300) {
            this._rear = 0;
            this._isHeadThrough = false;
        }
    }
}

