/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.ActorInfo;
import com.sinaflying.customise.Function;
import com.sinaflying.customise.GameParameter;
import com.sinaflying.customise.R;
import com.sinaflying.customise.RMSRecord;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.engine.TiledBackground;
import com.sinaflying.game.Bomb;
import com.sinaflying.game.GameMainLogic;
import com.sinaflying.game.GameMessageBox;
import com.sinaflying.game.GameUI;
import com.sinaflying.game.MessageBoxHandler;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.game.SceneUI;
import com.sinaflying.glogo.Logo;
import com.sinaflying.glogo.LogoListener;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameInterface
implements MessageBoxHandler,
LogoListener {
    private static GameInterface _instance;
    private GameMainLogic _mainLogic;
    private GameUI _gameui;
    private byte _state;
    private byte _lastState;
    private int _menuItem;
    public GameMessageBox _messageBox;
    public static int[][] mapPointUD;
    public static boolean[] _mapFlag;
    public int _curPoint;
    static Image _bigMap;
    private Image[] _boot;
    private int _curItemIndex;
    private int _itemStartX;
    private int _itemStartY;
    private int _itemSpace;
    private static int[] _info;
    private int _next;
    private String _text;
    private String _helpAboutTitle;
    public boolean _startDraw;
    private byte _loadSceneProcess;
    private int _point = 0;
    private static int _rightOut;
    private static int _leftOut;
    private static int _upOut;
    private static int _upOut1;
    private static int _downOut;
    private static int _upMenu;
    private static int _step;
    private int _tisk = 0;
    private int[] _sptId = new int[]{4, 3, 0, 2, 8, 5, 6};
    private static boolean _drawMenu;
    private static int _alpha;
    private int _frame;
    private int _progressBar;
    private int _loadProcess;
    private static int _soundLen;
    public static int _soundSize;
    public static int _perLen;
    private int _frame_93;
    private int _titleY;
    private int _curRmsIndex = 0;
    private int _drawStartX;
    private int _drawW;
    private int _drawH;
    private int _space;
    private boolean _inMenu;
    private static String[] _paraInfo;
    public static String[] _paraValue;
    public static boolean _closePartInfo;
    private int _infoItem;
    private int _valueIndex;
    private int _infoX;
    private int _infoY;
    public static boolean _isZuoBi;
    StringBuffer stringBuffer = new StringBuffer();
    private int _gLogoProcess;
    private Logo _gLogo;
    private static final String[] str_exit;
    private static final String[] str_into;
    private static final String[] str_lr_tip;
    Image _img_last;

    public GameInterface(GameMainLogic gameMainLogic) {
        this._mainLogic = gameMainLogic;
        this._itemStartX = 60;
        this._itemStartY = 80;
        this._itemSpace = 30;
        this._boot = new Image[8];
        this.formatRmsPage();
        Scene.loadGlobalAniN97();
        this.initGLogo();
    }

    public static GameInterface getInstance(GameMainLogic gameMainLogic) {
        if (_instance == null) {
            _instance = new GameInterface(gameMainLogic);
            _instance.changeState((byte)0);
        }
        return _instance;
    }

    protected void changeState(byte by) {
        if (this._state != by) {
            this._lastState = this._state;
        }
        this._state = by;
    }

    protected void paint(Graphics graphics) {
        switch (this._state) {
            case 0: {
                this._startDraw = true;
                if (!this._startDraw) break;
                this.gLogo(graphics);
                break;
            }
            case 1: {
                this.gameLoadGlobal(graphics);
                break;
            }
            case 2: {
                this.gameSoundTip(graphics);
                break;
            }
            case 3: {
                this.gameLogo();
                break;
            }
            case 4: {
                this.gameMenu(graphics);
                break;
            }
            case 11: {
                this.gameLoading(graphics);
                break;
            }
            case 5: {
                this.gameMenuLoad();
                break;
            }
            case 6: {
                this.gameMenuSound(graphics);
                this.returnFromSound();
                break;
            }
            case 7: 
            case 8: {
                this.gameHelpAbout(graphics);
                this.returnFromHelpAbout();
                break;
            }
            case 9: {
                this.gameMenuExit(graphics);
                break;
            }
            case 15: {
                this.gameMenuReturnTip();
                break;
            }
            case 16: {
                this.mortGameExit(graphics);
                break;
            }
            case 17: {
                this.mortGameTip(graphics);
                break;
            }
            case 18: {
                this.systemMneu(graphics);
                if (this._messageBox != null) {
                    this._messageBox.draw(graphics);
                    this._messageBox.update();
                }
                this.updateSystemMenu();
                break;
            }
            case 19: {
                this.functionMenu(graphics);
                break;
            }
            case 20: {
                this.drawBigMap(graphics);
                this.updataBigMap();
                break;
            }
            case 10: {
                this.paintRmsPageInfo(graphics);
                this.updateForRmsPage();
                break;
            }
            case 21: {
                this.gameItemSelect(graphics);
            }
        }
    }

    private void gameLoadGlobal(Graphics graphics) {
        ++this._point;
        if (this._point > 6) {
            this._point = 0;
        }
        Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("\u52a0\u8f7d\u6570\u636e\u4e2d", 120, 240, 1 | 0x10);
        int n = 0;
        while (n < this._point) {
            graphics.drawString(".", 120 + Function.C_WORD_W * 5 / 2 + n * Function.C_WORD_W / 2, 240, 4 | 0x10);
            ++n;
        }
        byte by = this._loadSceneProcess;
        this._loadSceneProcess = (byte)(by + 1);
        if (Scene.loadGlobal(this._mainLogic, by)) {
            GameDB.getGameDataBase();
            Scene.loadGlobalAni();
            RoleTeamData.produceInstance();
            TiledBackground.loadDistantData();
            try {
                _bigMap = Image.createImage((String)"/res/L0.png");
                int n2 = 1;
                while (n2 < 9) {
                    this._boot[n2 - 1] = Image.createImage((String)("/res/l" + n2 + ".png"));
                    ++n2;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            RMSRecord.loadRmsUIProperty();
            Bomb.loadBombDB();
            this._gameui = GameUI.getInstance();
            this.changeState((byte)3);
        }
    }

    protected void gameSoundTip(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        Function.draw3DString(graphics, "\u662f\u5426\u5f00\u542f\u58f0\u97f3", 120, 106, 17, 0xFFFFFF, 0);
        Function.draw3DString(graphics, KeyCode.standardKeyCode() ? "\u662f" : "\u5426", 5, 315, 36, 0xFFFFFF, 0);
        Function.draw3DString(graphics, KeyCode.standardKeyCode() ? "\u5426" : "\u662f", 235, 315, 40, 0xFFFFFF, 0);
        if (KeyCode.isPressConfirmKey()) {
            Function.startupSound(true, _soundSize);
            this.changeState((byte)3);
            Function.changeSoundState(0, -1);
        }
        if (KeyCode.isPressCancelKey()) {
            _soundSize = 0;
            Function.startupSound(false, _soundSize);
            this.changeState((byte)3);
        }
    }

    protected void gameLogo() {
        this.changeState((byte)4);
    }

    protected void gameCG(Graphics graphics) {
        if (!_drawMenu) {
            int n = _downOut = _downOut - 40 <= 0 ? 0 : _downOut - 20;
            if (_downOut == 0) {
                _rightOut = _rightOut - 50 <= 0 ? 0 : _rightOut - 50;
                int n2 = _leftOut = _leftOut + 50 >= 0 ? 0 : _leftOut + 50;
            }
            if (_leftOut == 0 && _rightOut == 0) {
                _upOut = _upOut + 50 >= 0 ? 0 : _upOut + 50;
                int n3 = _upOut1 = _upOut1 + 50 >= 0 ? 0 : _upOut1 + 50;
            }
            if (_upOut == 0 && _step < 16) {
                if (_step % 2 == 0) {
                    _upOut -= 16 - _step;
                } else if (_step % 3 == 0) {
                    _upOut += 15 - _step;
                }
                if (++_step >= 16) {
                    _upOut = 0;
                }
            }
        }
        graphics.drawImage(this._boot[6], 0, 0, 20);
        graphics.drawImage(this._boot[5], 100, 165 + _downOut, 17);
        if (_drawMenu) {
            this.drawImageRGB(graphics, this._boot[7], 15, -5, -40);
        } else {
            graphics.drawImage(this._boot[7], 15, -5 + _upOut1, 20);
        }
        graphics.drawImage(this._boot[3], 160 + _leftOut, 150, 20);
        graphics.drawImage(this._boot[2], 72 + _leftOut, 106, 17);
        graphics.drawImage(this._boot[1], 140 + _rightOut, 80, 17);
        graphics.drawImage(this._boot[4], 172, 213 + _upOut, 20);
    }

    protected void gameMenu(Graphics graphics) {
        int n = KeyCode.getCurKey();
        int n2 = 7;
        this.gameCG(graphics);
        if (_drawMenu) {
            _upMenu = _upMenu - 50 <= -225 ? -225 : _upMenu - 50;
            graphics.drawImage(this._boot[0], 120, 225 + _upMenu, 17);
        } else if (_step >= 16) {
            graphics.drawImage(this._boot[0], 120, 225, 17);
            ++this._tisk;
            if (this._tisk <= 4) {
                Function.draw3DString(graphics, "\u63095\u952e\u7ee7\u7eed", 120, 320 - Function.C_WORD_H, 17, 0xFFFFFF, 0);
            } else if (this._tisk > 8) {
                this._tisk = 0;
            }
        }
        if (_drawMenu) {
            ResourceManager._spts[84].draw(graphics, 120, 320 - Function.C_WORD_H * 2, this._sptId[this._menuItem], 0, 0x10 | 1);
            ResourceManager._spts[84].draw(graphics, 48, 320 - Function.C_WORD_H * 2 + 5, 7, 0, 0x10 | 1);
            ResourceManager._spts[84].draw(graphics, 192, 320 - Function.C_WORD_H * 2 + 5, 7, 0, 0x10 | 1);
        }
        if (KeyCode.isPressConfirmKey() && _drawMenu) {
            this.menuConfirmHandle(this._menuItem);
        } else if (KeyCode.isPressConfirmKey() && _upOut == 0) {
            _drawMenu = true;
        }
        if (_drawMenu) {
            KeyCode.resetCurKey();
            switch (n) {
                case 1: {
                    --this._menuItem;
                    if (this._menuItem >= 0) break;
                    this._menuItem = n2 - 1;
                    break;
                }
                case 2: {
                    ++this._menuItem;
                    if (this._menuItem < n2) break;
                    this._menuItem = 0;
                }
            }
        }
    }

    private boolean drawImageRGB(Graphics graphics, Image image, int n, int n2, int n3) {
        int n4 = image.getWidth();
        int n5 = image.getHeight();
        int[] nArray = new int[n4 * n5];
        int[] nArray2 = new int[n4 * n5];
        image.getRGB(nArray, 0, n4, 0, 0, n4, n5);
        int n6 = 0;
        while (n6 < nArray.length) {
            if ((nArray[n6] & 0xFFFFFF) == 0xFF00FF) {
                int n7 = n6;
                nArray[n7] = nArray[n7] & 0xFFFFFF;
            } else {
                int n8 = n6;
                nArray[n8] = nArray[n8] & (0xFFFFFF | _alpha << 24);
            }
            int n9 = n6++;
            nArray[n9] = nArray[n9] & (0xFFFFFF | _alpha << 24);
        }
        nArray2 = nArray;
        graphics.drawRGB(nArray2, 0, n4, n, n2, n4, n5, true);
        if ((_alpha += n3) < 0 || _alpha > 255) {
            n3 = 0;
            _alpha = 0;
            return true;
        }
        return false;
    }

    private void paintFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        if (++this._frame > Scene._resource.getAvatation(n3).getActFrmNum(n4) - 1) {
            this._frame = 0;
        }
        Scene._resource.getAvatation(n3).draw(graphics, n, n2, n4, this._frame, 0);
    }

    protected void gameLoading(Graphics graphics) {
        this._mainLogic.loadLevelData(graphics);
        this.drawProcess(graphics);
    }

    private final void drawProcess(Graphics graphics) {
        this.upDateLoadPrecoss();
        graphics.setClip(0, 0, 240, 320);
        Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        graphics.setColor(0);
        graphics.setClip(0, 0, 240, 320);
        int n = 0;
        while (n < this._progressBar / 30) {
            this.paintFrame(graphics, 25 * n, 230, 70, 0);
            ++n;
        }
        this.paintFrame(graphics, -35 + this._progressBar, 241, 88, 0);
        graphics.drawString(this._loadProcess * 10 + "%", this._progressBar - 2, 187, 20);
    }

    private void upDateLoadPrecoss() {
        ++this._loadProcess;
        if (this._loadProcess >= 10) {
            this._loadProcess = 10;
        }
        this._progressBar += 22;
        if (this._progressBar >= 200) {
            this._progressBar = 200;
        }
    }

    public void resetLoadProcess() {
        this._progressBar = 0;
        this._loadProcess = 0;
    }

    protected void gameMenuLoad() {
    }

    protected void gameMenuSound(Graphics graphics) {
        this.gameDrawBack(graphics);
        graphics.setColor(0);
        graphics.drawString("-", 60, 160, 0x10 | 1);
        graphics.drawString("\u97f3\u91cf", 120, 160, 0x10 | 1);
        graphics.drawString("+", 180, 160, 0x10 | 1);
        graphics.setColor(155, 200, 240);
        graphics.drawRect(67, 187, _soundLen + 6, 15);
        graphics.setColor(200, 136, 88);
        graphics.fillRect(70, 190, _soundLen, 10);
        graphics.setColor(155, 200, 240);
        graphics.fillRect(71, 191, _soundSize * _perLen, 2);
        graphics.setColor(255, 255, 255);
        graphics.fillRect(71, 193, _soundSize * _perLen, 2);
        graphics.setColor(155, 200, 240);
        graphics.fillRect(71, 195, _soundSize * _perLen, 2);
        graphics.setColor(70, 150, 200);
        graphics.fillRect(71, 197, _soundSize * _perLen, 2);
        Function.drawYesNoKey(graphics, false, true);
    }

    private void returnFromSound() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 1: {
                int n2;
                if (_soundSize-- <= 0) {
                    n2 = 0;
                } else {
                    int n3 = _soundSize;
                    n2 = n3;
                    _soundSize = n3 - 1;
                }
                _soundSize = n2;
                Function.setSoundValue(_soundSize);
                break;
            }
            case 2: {
                int n4;
                if (_soundSize++ >= 5) {
                    n4 = 5;
                } else {
                    int n5 = _soundSize;
                    n4 = n5;
                    _soundSize = n5 + 1;
                }
                _soundSize = n4;
                Function.setSoundValue(_soundSize);
            }
        }
        if (KeyCode.isPressCancelKey()) {
            if (this._inMenu) {
                this.changeState((byte)18);
            } else {
                this.changeState((byte)4);
            }
        }
        KeyCode.resetCurKey();
    }

    public void initGameHelp() {
        this._helpAboutTitle = "\u5e2e\u52a9";
        this._text = R.readTextFile("/res/help.xff", -1, _info);
        this._titleY = 20;
        this._next = 0;
    }

    protected void initGameAbout() {
        this._helpAboutTitle = "\u5173\u4e8e";
        this._text = R.readTextFile("/res/about.xff", -1, _info);
        this._next = 0;
        this._titleY = 20;
    }

    protected final void gameHelpAbout(Graphics graphics) {
        int n;
        int n2;
        this.gameDrawBack(graphics);
        Function.draw3DString(graphics, this._helpAboutTitle, 120, this._titleY, 0x10 | 1, 0xFFFFFF, 0);
        if (_info[0] > _info[1]) {
            n2 = this._next / _info[1] + 1;
            n = 1 + _info[0] / _info[1];
            StringBuffer stringBuffer = new StringBuffer().append(n2).append("/").append(n);
            graphics.setClip(0, 0, 240, 320);
            graphics.setColor(0);
            graphics.drawString(stringBuffer.toString(), 120, 320 - Function.C_WORD_H - 13, 0x20 | 1);
        }
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0);
        n2 = Function.drawHelpAboutString(graphics, this._text, this._next, _info[1], 120, _info[3], _info[4], 1 | 0x10) ? 1 : 0;
        n = KeyCode.getCurKey();
        if (n == 2) {
            if (n2 == 0) {
                this._next += _info[1];
            }
        } else if (n == 1 && this._next > 0) {
            this._next -= _info[1];
        }
        Function.drawYesNoKey(graphics, false, true);
    }

    private void returnFromHelpAbout() {
        if (KeyCode.isPressCancelKey()) {
            if (this._inMenu) {
                this.changeState((byte)18);
            } else {
                this.changeState((byte)4);
            }
        }
        KeyCode.resetCurKey();
    }

    public void gameDrawBack(Graphics graphics) {
        Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        Function.drawBackGroud(graphics, 0, 0, 240, 320);
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(200, 136, 88);
        graphics.drawRoundRect(1, 1, 238, 318, 10, 10);
        graphics.drawRoundRect(2, 2, 236, 316, 10, 10);
        Scene._resource.getSptSet(80).draw(graphics, 5, 5, 14, 0, 0);
        Scene._resource.getSptSet(80).draw(graphics, 235, 5, -2147483634, 0, 0);
        Scene._resource.getSptSet(80).draw(graphics, 5, 315, 0x4000000E, 0, 0);
        Scene._resource.getSptSet(80).draw(graphics, 236, 316, -1073741810, 0, 0);
        graphics.setColor(138, 183, 126);
        graphics.drawLine(5, 5, 5, 310);
        graphics.drawLine(235, 5, 235, 310);
        graphics.drawLine(5, 5, 230, 5);
        graphics.drawLine(5, 315, 230, 315);
    }

    protected void gameMenuExit(Graphics graphics) {
        this.gameDrawBack(graphics);
        Function.draw3DString(graphics, "\u662f\u5426\u9000\u51fa", 120, 160, 0x10 | 1, 0xFFFFFF, 0);
        int n = 318;
        Function.draw3DString(graphics, "\u662f", 2, n, 4 | 0x20, 0xFFFFFF, 0);
        Function.draw3DString(graphics, "\u5426", 238, n, 8 | 0x20, 0xFFFFFF, 0);
        if (KeyCode.isPressConfirmSoftKey()) {
            this.changeState((byte)16);
            Function.stopSound();
        } else if (KeyCode.isPressCancelKey()) {
            if (this._inMenu) {
                this.changeState((byte)18);
            } else {
                this.changeState((byte)4);
            }
        }
        KeyCode.resetCurKey();
    }

    protected void gameMenuReturnTip() {
    }

    protected void functionMenu(Graphics graphics) {
        try {
            Scene.getInstance().paint(graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._gameui.update();
        this._gameui.paint(graphics);
    }

    protected void systemMneu(Graphics graphics) {
        int n;
        this.gameDrawBack(graphics);
        int n2 = n = 2;
        while (n2 < GameParameter.C_GAME_INMENU.length) {
            graphics.setClip(0, 0, 240, 320);
            int n3 = n == 0 ? this._itemStartY + 25 + this._itemSpace * (n2 - 1) : this._itemStartY + 25 + this._itemSpace * (n2 - 2);
            if (this._curItemIndex == n2) {
                Function.drawRootMenu(graphics, this._itemStartX + 10, n3 - 22, 70, 20);
                graphics.setColor(16721169);
            } else {
                graphics.setColor(4072721);
            }
            graphics.setClip(0, 0, 240, 320);
            graphics.drawString(GameParameter.C_GAME_INMENU[n2], 120, n3 - 1, 1 | 0x20);
            ++n2;
        }
        Function.drawYesNoKey(graphics, true, true);
    }

    private void updateSystemMenu() {
        if (KeyCode.isPressCancelKey()) {
            if (this._inMenu) {
                this._curItemIndex = 0;
                this.setInMenuState(false);
                GameMainLogic.getInstance().changeState((byte)1);
                Scene.getInstance().changeState((byte)0);
            }
        } else if (KeyCode.isPressConfirmKey()) {
            this.menuConfirm();
        }
        int n = KeyCode.getCurKey();
        switch (n) {
            case 8: {
                KeyCode.resetKeyBuff();
                int n2 = 2;
                ++this._curItemIndex;
                if (this._curItemIndex <= GameParameter.C_GAME_INMENU.length - 1) break;
                this._curItemIndex = n2;
                break;
            }
            case 4: {
                KeyCode.resetKeyBuff();
                int n3 = 2;
                --this._curItemIndex;
                if (this._curItemIndex >= n3) break;
                this._curItemIndex = GameParameter.C_GAME_INMENU.length - 1;
            }
        }
        if (KeyCode.consumeKey(0) == 1 && KeyCode.consumeKey(1) == 128 && KeyCode.consumeKey(2) == 2 && KeyCode.consumeKey(3) == 128) {
            if (Scene._isInCity) {
                return;
            }
            this._curItemIndex = 0;
            this.setInMenuState(false);
            GameMainLogic.getInstance().changeState((byte)1);
            Scene.getInstance().changeState((byte)0);
            GameMainLogic.getInstance();
            GameMainLogic._scene.changeState((byte)4);
            GameMainLogic.getInstance();
            GameMainLogic.getInstance();
            GameMainLogic._scene._nextEnemy = Scene._tankOneTeamNum;
            GameMainLogic.getInstance();
            GameMainLogic._scene._inState = 0;
            KeyCode.resetKeyBuff();
        }
        if (KeyCode.consumeKey(0) == 1 && KeyCode.consumeKey(1) == 256 && KeyCode.consumeKey(2) == 2 && KeyCode.consumeKey(3) == 256) {
            this._curItemIndex = 0;
            this.setInMenuState(false);
            GameMainLogic.getInstance().changeState((byte)1);
            Scene.getInstance().changeState((byte)0);
            RoleTeamData.getInstance().consumeMoney(10000);
            KeyCode.resetKeyBuff();
        }
        KeyCode.resetCurKey();
    }

    private void menuConfirm() {
        switch (this._curItemIndex) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (!this._inMenu) break;
                this.setInMenuState(false);
                GameMainLogic.getInstance().changeState((byte)1);
                break;
            }
            case 3: {
                this.changeState((byte)6);
                break;
            }
            case 4: {
                this.changeState((byte)7);
                this.initGameHelp();
                break;
            }
            case 5: {
                this._messageBox = GameMessageBox.getInstance(this);
                this._messageBox.initShopStyle(1, "\u662f\u5426\u8fd4\u56de\u4e3b\u83dc\u5355");
                break;
            }
            case 6: {
                this.changeState((byte)9);
            }
        }
    }

    private final void menuConfirmHandle(int n) {
        switch (n) {
            case 0: {
                this.startNewGame();
                break;
            }
            case 1: {
                this.formatRmsPage();
                this.changeState((byte)10);
                break;
            }
            case 2: {
                this.mortGame();
                break;
            }
            case 3: {
                this.changeState((byte)6);
                break;
            }
            case 4: {
                this.changeState((byte)7);
                this.initGameHelp();
                break;
            }
            case 5: {
                this.changeState((byte)8);
                this.initGameAbout();
                break;
            }
            case 6: {
                this.changeState((byte)9);
            }
        }
    }

    private final void startNewGame() {
        this.gameDataInit();
    }

    private final void gameDataInit() {
        this._mainLogic._level = (byte)2;
        GameMainLogic._gameScenario = 0;
        this._mainLogic.resetGamePlayingTime();
        this._mainLogic.startRecordGameTime();
        Scene.getInstance().resetPos();
        Scene._isNewGame = true;
        Function.closeBlack();
        int n = 0;
        while (n < _mapFlag.length) {
            GameInterface._mapFlag[n] = n == 0;
            ++n;
        }
        ActorInfo.resetAllRecordSceneActorID();
        this.changeState((byte)11);
        RoleTeamData.getInstance().initTeam();
    }

    public final GameUI getGameUI() {
        return this._gameui;
    }

    public final void drawBigMap(Graphics graphics) {
        int n;
        graphics.drawImage(_bigMap, 0, 0, 20);
        int n2 = 0;
        while (n2 < mapPointUD.length) {
            if (_mapFlag[n2]) {
                ResourceManager._spts[93].draw(graphics, mapPointUD[n2][1] - 10, mapPointUD[n2][2] - 20, 0, 0, 4 | 0x10);
            }
            ++n2;
        }
        if (++this._frame_93 >= 3) {
            n = 0;
        } else {
            int n3 = this._frame_93;
            n = n3;
            this._frame_93 = n3 + 1;
        }
        this._frame_93 = n;
        ResourceManager._avats[93].draw(graphics, mapPointUD[this._curPoint][1] - 2, mapPointUD[this._curPoint][2] - 25, 1, this._frame_93, 0);
        Function.draw3DString(graphics, Scene.getInstance()._nextSceneName[mapPointUD[this._curPoint][3]], 120, 320, 1 | 0x20, 0xFFFFFF, 9047521);
    }

    public final void updataBigMap() {
        int n = KeyCode.getCurKey();
        int n2 = mapPointUD.length - 1;
        switch (n) {
            case 4: {
                if (_mapFlag[25] && this._curPoint == 0) {
                    this._curPoint = 25;
                    break;
                }
                if (this._curPoint >= 25 && this._curPoint <= 33) {
                    this.nextPoint(0, n2);
                    break;
                }
                if (this._curPoint == 1) {
                    this._curPoint = 0;
                    break;
                }
                if (this._curPoint < 1 || this._curPoint > 8) break;
                this.nextPoint(1, n2);
                break;
            }
            case 1: {
                if (_mapFlag[17] && this._curPoint == 0) {
                    this._curPoint = 17;
                    break;
                }
                if (this._curPoint >= 17 && this._curPoint <= 24) {
                    this.nextPoint(0, n2);
                    break;
                }
                if (this._curPoint == 9) {
                    this._curPoint = 0;
                    break;
                }
                if (this._curPoint < 9 || this._curPoint > 16) break;
                this.nextPoint(1, n2);
                break;
            }
            case 8: {
                if (_mapFlag[1] && this._curPoint == 0) {
                    this._curPoint = 1;
                    break;
                }
                if (this._curPoint >= 1 && this._curPoint <= 8) {
                    this.nextPoint(0, n2);
                    break;
                }
                if (this._curPoint == 25) {
                    this._curPoint = 0;
                    break;
                }
                if (this._curPoint < 25 || this._curPoint > 33) break;
                this.nextPoint(1, n2);
                break;
            }
            case 2: {
                if (_mapFlag[9] && this._curPoint == 0) {
                    this._curPoint = 9;
                    break;
                }
                if (this._curPoint >= 9 && this._curPoint <= 16) {
                    this.nextPoint(0, n2);
                    break;
                }
                if (this._curPoint == 17) {
                    this._curPoint = 0;
                    break;
                }
                if (this._curPoint < 17 || this._curPoint > 24) break;
                this.nextPoint(1, n2);
                break;
            }
            case 16: {
                int n3 = -1;
                int n4 = -1;
                if (mapPointUD[this._curPoint][3] == 3) {
                    n3 = 16;
                    n4 = 12;
                }
                this.changeLevel(mapPointUD[this._curPoint][3], n3, n4);
            }
        }
        KeyCode.resetCurKey();
    }

    public void changeLevel(int n, int n2, int n3) {
        this._mainLogic.changeLevel((byte)n);
        this.resetLoadProcess();
        GameMainLogic._scene.changeNextScenePos(n2, n3);
        this._mainLogic.changeState((byte)0);
        GameMainLogic._interface.changeState((byte)11);
    }

    public void nextPoint(int n, int n2) {
        switch (n) {
            case 0: {
                if (++this._curPoint > n2) {
                    this._curPoint = n2;
                    return;
                }
                if (!_mapFlag[this._curPoint]) {
                    --this._curPoint;
                    break;
                }
                if (this._curPoint == 9 || this._curPoint == 17 || this._curPoint == 25 || this._curPoint == 33) {
                    --this._curPoint;
                    break;
                }
                return;
            }
            case 1: {
                if (--this._curPoint < 0) {
                    this._curPoint = 0;
                    return;
                }
                if (_mapFlag[this._curPoint]) {
                    return;
                }
                ++this._curPoint;
            }
        }
    }

    public void setInMenuState(boolean bl) {
        this._inMenu = bl;
        this._curItemIndex = 2;
    }

    public void updateForRmsPage() {
        if (KeyCode.isPressConfirmKey()) {
            if (this._inMenu) {
                if (RMSRecord.isExistRecord(this._curRmsIndex)) {
                    this._messageBox = GameMessageBox.getInstance(this);
                    this._messageBox.initShopStyle(1, "\u662f\u5426\u8986\u76d6\u5b58\u6863");
                } else {
                    this._messageBox = GameMessageBox.getInstance(this);
                    this._messageBox.initShopStyle(1, "\u662f\u5426\u5b58\u6863");
                }
            } else if (RMSRecord.isExistRecord(this._curRmsIndex)) {
                RMSRecord.loadGame(this._curRmsIndex);
                int[] nArray = new int[]{RMSRecord._rmsGameTimeHour[this._curRmsIndex], RMSRecord._rmsGameTimeMinut[this._curRmsIndex]};
                GameMainLogic.getInstance().setContinueGameTime(nArray);
                GameMainLogic.getInstance().changeLevel((byte)RMSRecord._rmsGameSceneID[this._curRmsIndex]);
                GameMainLogic._gameScenario = RMSRecord._rmsGameScenario[this._curRmsIndex];
                Function.closeBlack();
                this.changeState((byte)11);
                SceneUI.getInstance().toolMenuInfo();
            }
            KeyCode.resetCurKey();
            return;
        }
        if (KeyCode.isPressCancelKey()) {
            if (this._inMenu) {
                this.setInMenuState(false);
                GameMainLogic.getInstance().changeState((byte)1);
            } else {
                this.changeState((byte)4);
            }
            KeyCode.resetCurKey();
            return;
        }
        int n = KeyCode.getCurKey();
        KeyCode.resetCurKey();
        switch (n) {
            case 4: {
                if (this._messageBox != null) break;
                this.preRmsIndex();
                break;
            }
            case 8: {
                if (this._messageBox != null) break;
                this.nextRmsIndex();
                break;
            }
            case 1: {
                break;
            }
        }
    }

    public void preRmsIndex() {
        --this._curRmsIndex;
        if (this._curRmsIndex < 0) {
            this._curRmsIndex = 2;
        }
    }

    public void nextRmsIndex() {
        ++this._curRmsIndex;
        if (this._curRmsIndex > 2) {
            this._curRmsIndex = 0;
        }
    }

    private String getString(int n) {
        if (n == 0) {
            return "\u4e00";
        }
        if (n == 1) {
            return "\u4e8c";
        }
        if (n == 2) {
            return "\u4e09";
        }
        return null;
    }

    private String getRMSName(int n) {
        if (n < 60) {
            return "\u7b2c\u4e00\u7ae0";
        }
        if (n >= 60 && n < 95) {
            return "\u7b2c\u4e8c\u7ae0";
        }
        if (n >= 95 && n < 120) {
            return "\u7b2c\u4e09\u7ae0";
        }
        if (n >= 120 && n < 140) {
            return "\u7b2c\u56db\u7ae0";
        }
        if (n >= 140) {
            return "\u7b2c\u4e94\u7ae0";
        }
        return null;
    }

    private void paintRmsPageInfo(Graphics graphics) {
        this.gameDrawBack(graphics);
        if (!this._inMenu) {
            Function.draw3DString(graphics, "\u8bfb\u53d6\u5b58\u6863", 120, 32, 17, 0xFFFFFF, 0);
        } else {
            Function.draw3DString(graphics, "\u4fdd\u5b58\u5b58\u6863", 120, 32, 17, 0xFFFFFF, 0);
        }
        int n = 0;
        while (n < 3) {
            boolean bl = false;
            graphics.setColor(155, 200, 240);
            graphics.drawRoundRect(this._drawStartX + 1, 81 + (this._drawH + this._space) * n, this._drawW - 3, this._drawH - 3, 10, 10);
            graphics.drawRoundRect(this._drawStartX + 2, 82 + (this._drawH + this._space) * n, this._drawW - 5, this._drawH - 5, 10, 10);
            graphics.setClip(0, 0, 240, 320);
            if (this._curRmsIndex == n) {
                Scene._resource.getSptSet(80).draw(graphics, 192, 93 + (this._drawH + this._space) * n, 22, 0, 17);
            }
            graphics.setColor(0);
            graphics.drawString("\u5b58\u6863" + this.getString(n), this._drawStartX, 80 - Function.C_WORD_H + (this._drawH + this._space) * n, 20);
            if (!RMSRecord._existRms[n]) {
                graphics.setColor(0);
                graphics.drawString("\u65e0\u5b58\u6863", 130, 83 + n * (this._drawH + this._space), 17);
            } else {
                graphics.setColor(0);
                graphics.drawString(this.getRMSName(RMSRecord._rmsGameScenario[n]), this._drawStartX + 5, 83 + n * (this._drawH + this._space), 20);
                Function.drawTime(graphics, RMSRecord._rmsGameTimeHour[n], RMSRecord._rmsGameTimeMinut[n], this._drawStartX + 70, 83 + n * (this._drawH + this._space));
            }
            ++n;
        }
        if (this._messageBox != null) {
            this._messageBox.draw(graphics);
            this._messageBox.update();
        }
        Function.drawYesNoKey(graphics, true, true);
    }

    private void formatRmsPage() {
        this._titleY = 42;
        this._drawStartX = 60;
        this._space = 50;
        this._drawW = 130;
        this._drawH = Function.C_WORD_H + 5;
    }

    private void gameItemSelect(Graphics graphics) {
        this.gameDrawBack(graphics);
        int n = 0;
        while (n < _paraInfo.length) {
            if (this._infoItem == n) {
                Function.draw3DString(graphics, _paraInfo[n], this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 4, 0xFFFFFF, 0xFF0000);
                Function.draw3DString(graphics, String.valueOf(_paraValue[n]), 240 - this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 8, 0xFFFFFF, 0xFF0000);
            } else {
                graphics.setColor(0);
                graphics.drawString(_paraInfo[n], this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 4);
                graphics.drawString(String.valueOf(_paraValue[n]), 240 - this._infoX, this._infoY + n * Function.C_WORD_H, 0x10 | 8);
            }
            ++n;
        }
        Function.draw3DString(graphics, "\u4e0b\u4e00\u9879", 2, 318, 0x20 | 4, 0xFFFFFF, 0);
        Function.draw3DString(graphics, "\u7ee7\u7eed", 238, 318, 0x20 | 8, 0xFFFFFF, 0);
        int n2 = KeyCode.getCurKey();
        switch (n2) {
            case 262144: {
                if (++this._infoItem > _paraInfo.length - 1) {
                    this._infoItem = 0;
                }
                this._valueIndex = 0;
                this.stringBuffer.delete(0, this.stringBuffer.length());
                KeyCode.resetCurKey();
                break;
            }
            case 524288: {
                int n3;
                RoleTeamData roleTeamData = RoleTeamData.getInstance();
                if (Integer.parseInt(_paraValue[2]) != 0) {
                    n3 = 0;
                    while (n3 < roleTeamData.getPackageInfo(1).length) {
                        roleTeamData.consumeWeapon(n3, 99);
                        ++n3;
                    }
                    n3 = 0;
                    while (n3 < roleTeamData.getPackageInfo(2).length) {
                        roleTeamData.consumeBomb(n3, 99);
                        ++n3;
                    }
                    n3 = 0;
                    while (n3 < roleTeamData.getPackageInfo(0).length) {
                        roleTeamData.consumeEquip(n3, 99);
                        ++n3;
                    }
                }
                if (Integer.parseInt(_paraValue[4]) != 0) {
                    n3 = 0;
                    while (n3 < roleTeamData.getPackageInfo(3).length) {
                        roleTeamData.consumeTool(n3, 99);
                        ++n3;
                    }
                }
                roleTeamData.addMember(0, Integer.parseInt(_paraValue[3]));
                String[] stringArray = new String[3];
                stringArray = GameInterface.split(_paraValue[5], "~");
                n3 = 0;
                while (n3 < stringArray.length) {
                    roleTeamData.consumeTool(Integer.parseInt(stringArray[n3]), 99);
                    ++n3;
                }
                if (Integer.parseInt(_paraValue[6]) != 0) {
                    if (Integer.parseInt(_paraValue[6]) == 1) {
                        roleTeamData.addMember(1, Integer.parseInt(_paraValue[3]));
                    } else if (Integer.parseInt(_paraValue[6]) == 2) {
                        roleTeamData.addMember(1, Integer.parseInt(_paraValue[3]));
                        roleTeamData.addMember(2, Integer.parseInt(_paraValue[3]));
                    }
                }
                stringArray = GameInterface.split(_paraValue[7], "~");
                n3 = 0;
                while (n3 < stringArray.length) {
                    roleTeamData.consumeTask(Integer.parseInt(stringArray[n3]), 1);
                    DataTable dataTable = GameDB.getGameDataBase().getData(6, Integer.parseInt(stringArray[n3]));
                    int[] nArray = dataTable.getArrayItem(6);
                    int n4 = 1;
                    while (n4 < nArray.length) {
                        roleTeamData.consumeKill(nArray[n4 - 1], 0, nArray[n4]);
                        n4 += 2;
                    }
                    ++n3;
                }
                SceneUI.getInstance().toolMenuInfo();
                this.changeState((byte)11);
                GameMainLogic._gameScenario = Integer.parseInt(_paraValue[1]);
                this.stringBuffer.delete(0, this.stringBuffer.length());
                KeyCode.resetCurKey();
                break;
            }
            default: {
                this.gameParaSet(this.getNumberOfKey(n2));
                KeyCode.resetCurKey();
            }
        }
    }

    private void gameParaSet(String string) {
        if (string.equals("-1")) {
            return;
        }
        this.stringBuffer.append(string);
        GameInterface._paraValue[this._infoItem] = this.stringBuffer.toString();
        ++this._valueIndex;
        if (this._infoItem == 5 || this._infoItem == 7) {
            if (this._valueIndex > 8) {
                this._valueIndex = 0;
                GameInterface._paraValue[this._infoItem] = "0";
                this.stringBuffer.delete(0, this.stringBuffer.length());
            }
        } else if (this._valueIndex > 3) {
            this._valueIndex = 0;
            GameInterface._paraValue[this._infoItem] = "0";
            this.stringBuffer.delete(0, this.stringBuffer.length());
        }
    }

    public static String[] split(String string, String string2) {
        int n = 0;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        int n2 = 0;
        n = string.indexOf(string2);
        while (n < string.length() && n != -1) {
            String string3 = string.substring(n2, n);
            vector.addElement(string3);
            n2 = n + string2.length();
            n = string.indexOf(string2, n + string2.length());
        }
        vector.addElement(string.substring(n2 + 1 - string2.length()));
        stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    private String getNumberOfKey(int n) {
        switch (n) {
            case 1024: {
                return "1";
            }
            case 4: {
                return "2";
            }
            case 4096: {
                return "3";
            }
            case 1: {
                return "4";
            }
            case 16: {
                return "5";
            }
            case 2: {
                return "6";
            }
            case 32768: {
                return "7";
            }
            case 8: {
                return "8";
            }
            case 131072: {
                return "9";
            }
            case 512: {
                return "0";
            }
            case 128: {
                return "~";
            }
        }
        return "-1";
    }

    public void cancelHandle() {
        this._messageBox = null;
    }

    public void finishHandle() {
    }

    public void resultHandle(int n) {
    }

    public void shopResultHandle(int n) {
        if (this._state == 10) {
            RMSRecord.saveGame(this._curRmsIndex);
        } else {
            switch (this._curItemIndex) {
                case 3: {
                    break;
                }
                case 5: {
                    this.setInMenuState(false);
                    Scene.getInstance().resetPos();
                    Function.changeSoundState(Function.getSceneSoundId(0), -1);
                    this.changeState((byte)4);
                    break;
                }
                case 6: {
                    this._mainLogic._midlet.notifyDestroyed();
                }
            }
        }
        this._messageBox = null;
        Scene.getInstance().finishHandle();
    }

    public final void initGLogo() {
        Function.loadSound(Function.C_SOUND_NAME);
        this._gLogoProcess = 0;
    }

    public final void gLogo(Graphics graphics) {
        switch (this._gLogoProcess) {
            case 0: {
                this._gLogo = Logo.createLogos(3, this, Function.getSoundKind(), 240, 320, GameMainLogic.getInstance()._midlet);
                ++this._gLogoProcess;
                break;
            }
            case 1: {
                Function.fillScreen(graphics, 0, 0, 240, 320, 0);
                this._gLogo.paint(graphics);
                if (!this._gLogo.getIfFinish()) break;
                this.finishGLogo();
                this._gLogo = null;
                Function.changeSoundState(0, -1);
            }
        }
    }

    public final void finishGLogo() {
        this._loadProcess = 0;
        this.changeState((byte)1);
    }

    public void mortGame() {
        this.browseWap("http://gamepie.ttsy.org/gamecms/go/jpgd", false);
    }

    public void browseWap(String string, boolean bl) {
        try {
            GameMainLogic.getInstance()._midlet.platformRequest(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void mortGameTip(Graphics graphics) {
        String string;
        String string2;
        Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        if (this._img_last == null) {
            try {
                this._img_last = R.loadPng("/res/logoPng.bin", 13);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        graphics.drawImage(this._img_last, 240 - this._img_last.getWidth() >> 1, 320 - this._img_last.getHeight() >> 1, 0);
        int n = 0;
        while (n < str_into.length) {
            Function.draw3DString(graphics, str_into[n], 120, 160 + (n - 1) * Function.C_WORD_H, 0x10 | 1, 0xFFFFFF, 0);
            ++n;
        }
        int n2 = 312;
        int n3 = 0xFFFFFF;
        int n4 = 0;
        if (KeyCode.getConfirmPos() == 0) {
            string2 = "\u662f";
            string = "\u5426";
        } else {
            string2 = "\u5426";
            string = "\u662f";
        }
        Function.draw3DString(graphics, string2, 10, n2, 4 | 0x20, n3, n4);
        Function.draw3DString(graphics, string, 230, n2, 8 | 0x20, n3, n4);
        boolean bl = false;
        if (KeyCode.isPressConfirmSoftKey()) {
            this.changeState((byte)4);
            this.mortGame();
            bl = true;
        } else if (KeyCode.isPressCancelKey()) {
            this.changeState((byte)4);
            Function.changeSoundState(0, -1);
            bl = true;
        }
        if (bl) {
            KeyCode.resetCurKey();
        }
    }

    public void mortGameExit(Graphics graphics) {
        String string;
        String string2;
        Function.fillScreen(graphics, 0, 0, 240, 320, 0);
        if (this._img_last == null) {
            try {
                this._img_last = R.loadPng("/res/logoPng.bin", 13);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        graphics.drawImage(this._img_last, 240 - this._img_last.getWidth() >> 1, 320 - this._img_last.getHeight() >> 1, 0);
        int n = 0;
        while (n < str_exit.length) {
            Function.draw3DString(graphics, str_exit[n], 120, 130 + n * Function.C_WORD_H, 1 | 0x10, 0xFFFFFF, 0);
            ++n;
        }
        int n2 = 312;
        int n3 = 0xFFFFFF;
        int n4 = 0;
        if (KeyCode.getConfirmPos() == 0) {
            string2 = str_lr_tip[0];
            string = str_lr_tip[1];
        } else {
            string2 = str_lr_tip[1];
            string = str_lr_tip[0];
        }
        Function.draw3DString(graphics, string2, 10, n2, 4 | 0x20, n3, n4);
        Function.draw3DString(graphics, string, 230, n2, 8 | 0x20, n3, n4);
        boolean bl = false;
        if (KeyCode.isPressConfirmSoftKey()) {
            this.browseWap("http://gamepie.ttsy.org/gamecms/go/jpgd", false);
            bl = true;
        } else if (KeyCode.isPressCancelKey()) {
            bl = true;
        }
        if (bl) {
            this._mainLogic._midlet.notifyDestroyed();
        }
    }

    public int getKeyStatus() {
        int n = KeyCode.getCurKey();
        switch (n) {
            case 262144: {
                return 65536;
            }
            case 524288: {
                return 131072;
            }
        }
        return 0;
    }

    static {
        mapPointUD = new int[][]{{0, 72, 171, 3}, {1, 76, 204, 6}, {2, 102, 219, 7}, {3, 132, 227, 8}, {4, 144, 254, 9}, {5, 119, 270, 10}, {6, 96, 268, 11}, {7, 70, 266, 12}, {8, 41, 275, 13}, {9, 122, 181, 14}, {10, 150, 201, 15}, {11, 178, 221, 16}, {12, 206, 232, 17}, {13, 235, 207, 18}, {14, 215, 179, 19}, {15, 198, 137, 20}, {16, 199, 116, 21}, {17, 45, 167, 22}, {18, 22, 160, 23}, {19, 9, 150, 24}, {20, 9, 114, 25}, {21, 9, 94, 26}, {22, 9, 75, 27}, {23, 9, 48, 28}, {24, 34, 39, 29}, {25, 74, 149, 30}, {26, 101, 157, 31}, {27, 141, 154, 32}, {28, 157, 138, 33}, {29, 144, 124, 34}, {30, 119, 108, 35}, {31, 95, 94, 36}, {32, 68, 87, 37}};
        _mapFlag = new boolean[]{true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        _info = new int[5];
        _rightOut = 240;
        _leftOut = -240;
        _upOut = -340;
        _upOut1 = -340;
        _downOut = 155;
        _upMenu = 0;
        _step = 0;
        _drawMenu = false;
        _alpha = 255;
        _soundLen = 102;
        _soundSize = 2;
        _perLen = 20;
        _paraInfo = new String[]{"\u573a\u666f\u5207\u6362", "\u5267\u60c5\u4e4b\u4fee\u6539", "\u5168\u6b66\u5668\u5f39\u836f\u88c5\u590799\u4e2a", "\u89d2\u8272\u7b49\u7ea7", "\u5168\u9053\u517799\u4e2a", "\u6307\u5b9a\u9053\u517799\u4e2a", "\u961f\u5217\u4eba\u7269", "\u4e3b\u89d2\u8eab\u4e0a\u7684\u4efb\u52a1"};
        _isZuoBi = false;
        str_exit = new String[]{"\u66f4\u591a\u7cbe\u5f69\u6e38\u620f", "\u5c3d\u5728\u6e38\u620f\u9891\u9053", "wap.ttsy.org"};
        str_into = new String[]{"\u662f\u5426\u8bbf\u95ee\u9875\u9762", "wap.ttsy.org"};
        str_lr_tip = new String[]{"\u786e\u8ba4", "\u9000\u51fa"};
    }
}

