/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.ResourceManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class GameRoleData {
    private int[] _roleInfo;
    private int[] _equipInfo;

    public GameRoleData() {
        this.init();
    }

    public final void init() {
        this._roleInfo = new int[10];
        this._equipInfo = new int[7];
        int n = 0;
        while (n < this._roleInfo.length) {
            this._roleInfo[n] = 0;
            ++n;
        }
        int n2 = this._equipInfo.length;
        int n3 = 0;
        while (n3 < n2) {
            this._equipInfo[n3] = -1;
            ++n3;
        }
    }

    public final void basicSet(int n, int n2, int[] nArray) {
        this._roleInfo[0] = n;
        this._roleInfo[1] = n2;
        System.arraycopy(nArray, 0, this._equipInfo, 0, nArray.length);
        this.updateRoleInfo();
        this.resetHp(this._roleInfo[3]);
    }

    public final void setCurHp(int n) {
        this._roleInfo[2] = n;
    }

    public final void setCurMove(int n) {
        this._roleInfo[9] = n;
    }

    private final void updateRoleInfo() {
        DataTable dataTable = GameDB.getGameDataBase().getData(1, this._roleInfo[0]);
        this._roleInfo[3] = this.countHp(dataTable.getIntItem(3), this._roleInfo[1]);
        this._roleInfo[4] = this.countHp(dataTable.getIntItem(4), this._roleInfo[1]);
        this._roleInfo[5] = this._roleInfo[4];
        this._roleInfo[6] = this.countHp(dataTable.getIntItem(5), this._roleInfo[1]);
        this._roleInfo[8] = this.countExp(this._roleInfo[1]);
        this.equipAppend();
    }

    private final void resetHp(int n) {
        this._roleInfo[2] = n;
        this._roleInfo[2] = Math.min(this._roleInfo[2], this._roleInfo[3]);
    }

    private final int countHp(int n, int n2) {
        if (n2 <= 1) {
            return n;
        }
        int n3 = this.countHp(n, --n2);
        return ((n3 << 10) * 13 / 100 >> 10) + n3;
    }

    private final int countExp(int n) {
        return n * n * 6 + n * 7;
    }

    private final void equipAppend() {
        DataTable dataTable;
        GameDB gameDB = GameDB.getGameDataBase();
        int n = 0;
        while (n < 4) {
            dataTable = gameDB.getData(5, this._equipInfo[n]);
            this._roleInfo[3] = this._roleInfo[3] + dataTable.getIntItem(3);
            this._roleInfo[6] = this._roleInfo[6] + dataTable.getIntItem(4);
            ++n;
        }
        this._roleInfo[2] = Math.min(this._roleInfo[2], this._roleInfo[3]);
        dataTable = gameDB.getData(3, this._equipInfo[4]);
        this._roleInfo[4] = this._roleInfo[4] + dataTable.getIntItem(5);
        dataTable = gameDB.getData(4, this._equipInfo[5]);
        this._roleInfo[4] = this._roleInfo[4] + dataTable.getIntItem(7);
        dataTable = gameDB.getData(4, this._equipInfo[6]);
        this._roleInfo[5] = this._roleInfo[5] + dataTable.getIntItem(7);
    }

    public final int getIntoEquip(int n, int n2) {
        int n3 = this._equipInfo[n];
        this._equipInfo[n] = n2;
        this.updateRoleInfo();
        this.avatarChanger(n);
        return n3;
    }

    public final void avatarChanger(int n) {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(1, this._roleInfo[0]);
        int n2 = dataTable.getIntItem(13);
        int n3 = 0;
        switch (n) {
            case 4: {
                dataTable = gameDB.getData(3, this._equipInfo[n]);
                n3 = dataTable.getIntItem(8);
                ResourceManager._avats[n2].setCurMouldPart(1, n3);
            }
        }
    }

    public final int[] getEquipInx() {
        return this._equipInfo;
    }

    public final int[] getRoleInx() {
        return this._roleInfo;
    }

    public final boolean obtainExperience(int n) {
        if (this._roleInfo[1] < 20) {
            this._roleInfo[7] = this._roleInfo[7] + n;
        }
        int n2 = 0;
        while (this._roleInfo[1] < 20 && this._roleInfo[7] >= this._roleInfo[8]) {
            this._roleInfo[7] = this._roleInfo[7] - this._roleInfo[8];
            this.obtainLevel();
            ++n2;
        }
        return n2 != 0;
    }

    public final void obtainLevel() {
        this._roleInfo[1] = this._roleInfo[1] + 1;
        this._roleInfo[1] = Math.min(this._roleInfo[1], 20);
        this.updateRoleInfo();
        this._roleInfo[2] = this._roleInfo[3];
        if (this._roleInfo[1] >= 20) {
            this._roleInfo[7] = this._roleInfo[8];
        }
    }

    public final void save(DataOutputStream dataOutputStream) {
        try {
            int n = this._roleInfo.length;
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this._roleInfo[n2]);
                ++n2;
            }
            n = this._equipInfo.length;
            int n3 = 0;
            while (n3 < n) {
                dataOutputStream.writeInt(this._equipInfo[n3]);
                ++n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void load(DataInputStream dataInputStream) {
        try {
            int n = this._roleInfo.length;
            int n2 = 0;
            while (n2 < n) {
                this._roleInfo[n2] = dataInputStream.readInt();
                ++n2;
            }
            n = this._equipInfo.length;
            int n3 = 0;
            while (n3 < n) {
                this._equipInfo[n3] = dataInputStream.readInt();
                ++n3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

