/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.game;

import com.sinaflying.customise.Function;
import com.sinaflying.database.DataTable;
import com.sinaflying.database.GameDB;
import com.sinaflying.engine.Avatar;
import com.sinaflying.engine.KeyCode;
import com.sinaflying.engine.ResourceManager;
import com.sinaflying.game.Actor;
import com.sinaflying.game.Assistant;
import com.sinaflying.game.Bomb;
import com.sinaflying.game.Device;
import com.sinaflying.game.FollowManager;
import com.sinaflying.game.Follower;
import com.sinaflying.game.GameRoleData;
import com.sinaflying.game.GameUI;
import com.sinaflying.game.RoleTeamData;
import com.sinaflying.game.Scene;
import com.sinaflying.game.SceneUI;
import javax.microedition.lcdui.Graphics;

public class MainActor
extends Actor
implements Follower {
    protected static final byte[][] C_ARR_RATE = new byte[][]{{100}, {80, 100}, {70, 90, 100}};
    protected static final byte[][] C_TOOL_RATE = new byte[][]{{100}, {80, 100}, {60, 90, 100}};
    protected static final byte[][] C_TOOL_RATE0 = new byte[][]{{100}, {80, 100}, {30, 70, 100}};
    protected static final byte[] BOMB_ANGRY = new byte[]{18, 24, 25};
    protected int[] _mainActorInfo;
    protected int[] _rcInfo;
    protected int[] _bParam;
    protected int[] _toolInfo;
    protected int[] _numInfo;
    private int[] crenelPos;
    protected int[] _bombId;
    private int _state;
    private int _enemyState;
    private int _enemyKeyCode;
    private int _stopTime;
    private boolean _firing;
    private boolean _fireFinish;
    private boolean _throwing;
    private boolean _recordFire;
    private boolean _recordThrow;
    private boolean _useTool;
    private boolean _useToolFinish;
    private boolean _angrying;
    private boolean _angryEye;
    private boolean _partnerAi;
    private String _name;
    private boolean _teaching;
    private int _teachKind;
    private int _teachTarget;
    private int _teachAngle;
    private int _teachPower;
    private static Avatar _circle = Scene._resource.getAvatation(71);
    public FollowManager _followManager;

    public MainActor(int n, Avatar avatar) {
        super(n, avatar);
    }

    public boolean init(byte[] byArray) {
        super.init(byArray);
        this.initInfo();
        return true;
    }

    public void init(int n, int n2, int n3) {
        super.init(n, n2, n3);
        this.initInfo();
    }

    public void initTeamIndex(int n) {
        this._mainActorInfo[0] = n;
    }

    private void loadCrenelPos(int[] nArray) {
        this.crenelPos = new int[nArray.length];
        System.arraycopy(nArray, 0, this.crenelPos, 0, this.crenelPos.length);
    }

    public void initInfo() {
        GameRoleData gameRoleData;
        this._mainActorInfo = new int[27];
        this._bParam = new int[18];
        this._rcInfo = new int[5];
        this._numInfo = new int[4];
        this._toolInfo = new int[5];
        this._partnerAi = false;
        this._useTool = true;
        int n = 0;
        while (n < this._numInfo.length) {
            this._numInfo[n] = -1;
            ++n;
        }
        int n2 = 0;
        while (n2 < this._rcInfo.length) {
            this._rcInfo[n2] = -1;
            ++n2;
        }
        this._mainActorInfo[1] = Scene._actorInitData[this._id][9];
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(1, this._mainActorInfo[1]);
        this._mainActorInfo[25] = dataTable.getIntItem(15);
        this._name = dataTable.getStringItem(1);
        if (this._mainActorInfo[1] <= 2) {
            if (!RoleTeamData.getInstance().getExistFlag(this._mainActorInfo[1])) {
                return;
            }
            this.updateMainInfo();
            this._partnerAi = true;
            dataTable = gameDB.getData(1, 0);
            this.loadCrenelPos(dataTable.getArrayItem(14));
            gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
            int[] nArray = gameRoleData.getEquipInx();
            this._mainActorInfo[18] = nArray[4];
            dataTable = gameDB.getData(3, this._mainActorInfo[18]);
            this._anim.setCurMouldPart(1, dataTable.getIntItem(8));
        } else {
            this._mainActorInfo[12] = dataTable.getIntItem(3);
            this.updateEnemyInfo();
            dataTable = gameDB.getData(1, this._mainActorInfo[1]);
            this.loadCrenelPos(dataTable.getArrayItem(14));
        }
        this._mainActorInfo[2] = 0;
        this._mainActorInfo[3] = 0;
        this._mainActorInfo[4] = 100;
        this._mainActorInfo[5] = 100;
        this._mainActorInfo[8] = 0;
        this._mainActorInfo[7] = 0;
        this._mainActorInfo[14] = 0;
        this._mainActorInfo[17] = 0;
        this._mainActorInfo[19] = 0;
        this._mainActorInfo[20] = 0;
        this._mainActorInfo[21] = 0;
        this._mainActorInfo[24] = 0;
        this._firing = false;
        this._throwing = false;
        if (this._mainActorInfo[10] == 0) {
            this._mainActorInfo[10] = 1;
            this._mainActorInfo[9] = 1;
            gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
            gameRoleData.setCurHp(1);
        }
        this.checkTerrain(4, this._flipFlag);
        this.changeState((byte)0);
    }

    public void updateMainInfo() {
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
        int[] nArray = gameRoleData.getRoleInx();
        this._mainActorInfo[12] = nArray[3];
        this._mainActorInfo[10] = nArray[2];
        this._mainActorInfo[9] = this._mainActorInfo[10];
        this._mainActorInfo[26] = nArray[6];
    }

    public void updateEnemyInfo() {
        this._mainActorInfo[10] = this._mainActorInfo[12];
        this._mainActorInfo[9] = this._mainActorInfo[10];
    }

    public void updateMainBombInfo() {
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
        int[] nArray = gameRoleData.getEquipInx();
        this._mainActorInfo[19] = nArray[5];
        this._mainActorInfo[18] = nArray[4];
        nArray = gameRoleData.getRoleInx();
        this._bParam[15] = nArray[4];
        this._bParam[15] = this._bParam[15] + ((this._bParam[15] << 10) * this._mainActorInfo[16] / 100 >> 10);
        RoleTeamData.getInstance().consumeBomb(this._mainActorInfo[19], -1);
        boolean[] blArray = RoleTeamData.getInstance().getPackageExist(2);
        if (!blArray[this._mainActorInfo[19]]) {
            gameRoleData.getIntoEquip(5, 10);
        }
    }

    public void updateEnemyBombInfo() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(1, this._mainActorInfo[1]);
        this._bParam[15] = dataTable.getIntItem(4);
        this._bParam[15] = this._bParam[15] + ((this._bParam[15] << 10) * this._mainActorInfo[16] / 100 >> 10);
        dataTable = gameDB.getData(4, this._mainActorInfo[19]);
        this._bParam[15] = this._bParam[15] + dataTable.getIntItem(7);
    }

    public void updateMainThrowInfo() {
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
        int[] nArray = gameRoleData.getEquipInx();
        this._mainActorInfo[20] = nArray[6];
        nArray = gameRoleData.getRoleInx();
        this._bParam[15] = nArray[5];
        this._bParam[15] = this._bParam[15] + ((this._bParam[15] << 10) * this._mainActorInfo[16] / 100 >> 10);
        RoleTeamData.getInstance().consumeBomb(this._mainActorInfo[20], -1);
        boolean[] blArray = RoleTeamData.getInstance().getPackageExist(2);
        if (!blArray[this._mainActorInfo[20]]) {
            gameRoleData.getIntoEquip(6, 0);
        }
    }

    public void updateMainAngryInfo() {
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
        int[] nArray = gameRoleData.getEquipInx();
        this._mainActorInfo[19] = nArray[5];
        this._mainActorInfo[18] = nArray[4];
        nArray = gameRoleData.getRoleInx();
        this._bParam[15] = nArray[4];
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(4, this._mainActorInfo[19]);
        this._bParam[15] = this._bParam[15] - dataTable.getIntItem(7);
        dataTable = gameDB.getData(4, 0);
        this._bParam[15] = this._bParam[15] + dataTable.getIntItem(7);
    }

    public boolean takeFocus() {
        this._mainActorInfo[8] = 0;
        this._mainActorInfo[16] = 0;
        this._rcInfo[1] = -1;
        if (this._toolInfo[4] <= 0) {
            this._mainActorInfo[23] = 0;
        } else {
            this._toolInfo[4] = this._toolInfo[4] - 1;
            if (this._mainActorInfo[23] == 4) {
                return false;
            }
        }
        if (this._state == 9) {
            return false;
        }
        this._firing = false;
        this._fireFinish = false;
        this._throwing = false;
        this._angrying = false;
        this._useTool = true;
        this._useToolFinish = false;
        SceneUI.getInstance().closeSceneUI();
        SceneUI.getInstance().setCloseToolGrid(false);
        GameUI.getInstance().setToolUse(true);
        this._scene._bk.operateBlackScreen(false);
        return true;
    }

    public boolean useTooleFinish() {
        return this._useToolFinish && !this._useTool;
    }

    public void ai() {
        this.keyHandler();
    }

    public void keyHandler() {
        if (!this.isExecuteAI()) {
            return;
        }
        if (this._partnerAi) {
            this.partnerAi();
        } else {
            this.enemyAi();
        }
        this.deathCount();
    }

    public void partnerAi() {
        switch (this._state) {
            case 0: {
                if (Scene._isInCity) {
                    if (this.isFollower()) {
                        this.followHandle();
                        break;
                    }
                    this.cityKeyHandler();
                    break;
                }
                this.battleKeyHandler();
                break;
            }
            case 1: {
                this.fireProcess();
                break;
            }
            case 2: {
                this.firingProcess();
                break;
            }
            case 3: {
                this.throwProcess();
                break;
            }
            case 4: {
                this.throwingProcess();
                break;
            }
            case 5: {
                this.jumpProcess();
                break;
            }
            case 6: {
                this.useProcess();
                break;
            }
            case 7: {
                this.effectProcess();
                break;
            }
            case 8: {
                this.hurtProcess();
                break;
            }
            case 9: {
                this.deathProcess();
                break;
            }
            case 10: {
                this.flyProcess();
                break;
            }
            case 11: {
                this.angryInit();
                break;
            }
            case 12: {
                this.angryFireProcess();
            }
        }
        this.bombChangeFocus();
        if (this._scene.getFocusActor()._id != this._id) {
            return;
        }
        SceneUI.getInstance().changeInfo(this._mainActorInfo);
        SceneUI.getInstance().setRoleName(this._name);
    }

    public void enemyAi() {
        switch (this._enemyState) {
            case 6: {
                this.analyseProcess();
                break;
            }
            case 0: {
                this.adversaryKeyHandler();
                break;
            }
            case 1: {
                this.enemyFireProcess();
                break;
            }
            case 2: {
                this.enemyFiringProcess();
                break;
            }
            case 4: {
                this.enemyUesProcess();
                break;
            }
            case 5: {
                this.enemyEffectProcess();
                break;
            }
            case 7: {
                this.enemyFlyProcess();
                break;
            }
            case 8: {
                this.enemyHurtProcess();
            }
        }
        this.bombChangeFocus();
        if (this._scene.getFocusActor()._id != this._id) {
            return;
        }
        SceneUI.getInstance().setRoleName(this._name);
    }

    public void deathCount() {
        int n = this._y + (this._t - 320 << 10);
        if (n > Scene._maph) {
            this.consumeHp(-this._mainActorInfo[10] - this._mainActorInfo[26]);
            if (this._scene.getFocusActor() == this) {
                Scene.getInstance().updateBattleResult();
                this._scene.endBombing();
            }
        }
    }

    public void step() {
        if (this.isExecuteStep()) {
            this.nextFrame();
            this._dx = this._vx;
            this._dy = this._vy;
            this._vx += this._ax;
            this._vx = this._ax > 0 && this._vx > this._fx ? this._fx : this._vx;
            this._vx = this._ax < 0 && this._vx < this._fx ? this._fx : this._vx;
            this._vy += this._ay;
            this._vy = this._ay > 0 && this._vy > this._fy ? this._fy : this._vy;
            int n = this._vy = this._ay < 0 && this._vy < this._fy ? this._fy : this._vy;
            if (this._x + this._dx <= 0 || this._x + this._dx >= Scene._mapw << 10) {
                this._vx = 0;
                this._dx = 0;
            }
            this.checkLeftWall(0);
            this.checkRightWall(0);
            this._x += this._dx;
            this._y += this._dy;
            this.checkGround();
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._scene.getFocusActor()._id == this._id && !Scene._isInCity && this._mainActorInfo[1] <= 2 && !Scene.getInstance().isHitState(3)) {
            this.drawCircle(graphics, n, n2);
        }
        super.draw(graphics, n, n2, n3, n4);
        graphics.setClip(0, 0, 240, 320);
        this.drawActorInfo(graphics, n, n2);
        graphics.setClip(0, 0, 240, 320);
    }

    private void cityKeyHandler() {
        if (Scene.getInstance()._isChangetoNewScene) {
            return;
        }
        int n = KeyCode.getCurKey();
        switch (n) {
            case 1: {
                this.leftWalk();
                break;
            }
            case 2: {
                this.rightWalk();
                break;
            }
            case 16: {
                break;
            }
            default: {
                this.changeToWait();
            }
        }
    }

    private void teachFront() {
        int n = 0;
        if (this._scene.getceneTeach()) {
            switch (this._scene.getPressKey()) {
                case 1: {
                    n = 4;
                    break;
                }
                case 2: {
                    n = 8;
                    break;
                }
                case 3: {
                    n = 1;
                    break;
                }
                case 4: {
                    n = 2;
                    break;
                }
                case 5: {
                    n = 16;
                    break;
                }
                case 6: {
                    n = 512;
                    break;
                }
                case 7: {
                    n = 131072;
                }
            }
            if (n != KeyCode.getCurKey()) {
                KeyCode.resetCurKey();
                return;
            }
            switch (n) {
                case 1: 
                case 2: {
                    if (this._x >> 10 < this._scene.getMoveValue() - 5 || this._x >> 10 > this._scene.getMoveValue() + 5) break;
                    this.changeToWait();
                    this._scene.closeSceneTeachOne();
                    KeyCode.resetCurKey();
                    break;
                }
                case 512: {
                    this._scene.closeSceneTeachOne();
                }
            }
        }
    }

    private void battleKeyHandler() {
        if (this.noRespondKey()) {
            this.changeToWait();
            return;
        }
        this.teachFront();
        this.teaching();
        int n = KeyCode.getCurKey();
        if (this._firing && n != 16 || this._throwing && n != 32768 || this._angrying && n != 131072) {
            KeyCode.resetCurKey();
            n = KeyCode.getCurKey();
        }
        switch (n) {
            case 4: {
                this.upAngle();
                this.changeToWait();
                break;
            }
            case 8: {
                this.downAngle();
                this.changeToWait();
                break;
            }
            case 1: {
                this.leftWalk();
                break;
            }
            case 2: {
                this.rightWalk();
                break;
            }
            case 16: {
                this.fireOrder();
                this.changeToWait();
                break;
            }
            case 32768: {
                this.throwOrder();
                this.changeToWait();
                break;
            }
            case 1024: {
                this.leftJump();
                break;
            }
            case 4096: {
                this.rightJump();
                break;
            }
            case 131072: {
                this.angryOrder();
                this.changeToWait();
                break;
            }
            case 512: {
                if (!this._scene.isCameraStop() || !this._useTool) break;
                SceneUI.getInstance().changeState();
                KeyCode.resetCurKey();
                this.changeToWait();
                break;
            }
            case 262144: 
            case 524288: {
                break;
            }
            default: {
                if (this.isDoubleAttach() && (this._recordFire || this._recordThrow)) {
                    this._firing = this._recordFire ? this._recordFire : this._firing;
                    this._throwing = this._recordThrow ? this._recordThrow : this._throwing;
                    int n2 = this._mainActorInfo[23] = this._recordFire || this._recordThrow ? 0 : this._mainActorInfo[23];
                    if (this._mainActorInfo[23] == 0) {
                        this._mainActorInfo[8] = this._mainActorInfo[7];
                        KeyCode.resetCurKey();
                    }
                }
                if (this._firing) {
                    this.changeAction(++this._action | this._flipFlag);
                    this.changeState((byte)1);
                    this.creatFireEffectActor();
                    this._recordFire = this.isDoubleAttach();
                } else if (this._throwing) {
                    this.checkTerrain(2, this._flipFlag);
                    this.changeState((byte)3);
                    this._recordThrow = this.isDoubleAttach();
                } else if (this._angrying) {
                    this._scene._bk.operateBlackScreen(true);
                    this._stopTime = 10;
                    this.cteatAngryEffectActor(78, this._type);
                    this.changeState((byte)11);
                } else {
                    this.changeToWait();
                }
                KeyCode.resetCurKey();
            }
        }
    }

    private boolean noRespondKey() {
        boolean bl = Scene.getInstance()._isChangetoNewScene;
        boolean bl2 = SceneUI.getInstance().isOpen();
        boolean bl3 = !this._scene.isHitState(0);
        boolean bl4 = !Scene.getInstance().isCameraStop() && this._dx == 0 || this._scene.getFocusActor()._id != this._id;
        return bl || bl2 || bl3 || bl4;
    }

    private boolean noRespondEnemyKey() {
        boolean bl = Scene.getInstance().isCameraStop() || this._dx != 0;
        boolean bl2 = this._scene.getFocusActor()._id == this._id;
        return !bl || !bl2;
    }

    public void adjustAngle() {
        int n = (this._partnerAi ? 4 : 0) + (this._partnerAi ? this.calAngle() : 0);
        this.changeAction(n | this._flipFlag);
    }

    private void fireProcess() {
        if (this.isActionEnd()) {
            this.fireOrThrow();
            this.changeToWait();
            this.changeState((byte)2);
        }
    }

    private void firingProcess() {
        if (--this._stopTime > 0) {
            return;
        }
        this.initBombfire();
    }

    private void throwProcess() {
        if (this.isActionEnd()) {
            this.fireOrThrow();
            this.changeState((byte)4);
        }
    }

    private void throwingProcess() {
        this.initBombfire();
    }

    private void jumpProcess() {
        this._vy += this._vy < 0 ? this._gravity : 0;
        if (this._dy == 0) {
            this.changeState((byte)0);
            this.checkTerrain(4, this._flipFlag);
        }
    }

    private void useProcess() {
        if (this.canUseTool()) {
            this.setUseInfo();
            this.useTool();
        }
    }

    private void effectProcess() {
        if (--this._stopTime > 0) {
            return;
        }
        if (this._toolInfo[3] == 0) {
            this._useTool = false;
            this.changeState((byte)0);
            SceneUI.getInstance().setCloseToolGrid(true);
            GameUI.getInstance().setToolUse(false);
        } else {
            this._useTool = false;
            this._useToolFinish = true;
            this.changeState((byte)0);
            GameUI.getInstance().setToolUse(false);
        }
        switch (this._toolInfo[0]) {
            case 3: {
                this.changeState((byte)0);
            }
        }
    }

    private void hurtProcess() {
        if (this.isActionEnd()) {
            if (this._bParam[11] > 0) {
                this._bParam[11] = 0;
                this._stopTime = 0;
            }
            this.changeToWait();
            this.changeState((byte)0);
        }
    }

    private void deathProcess() {
        if (this.isActionEnd()) {
            // empty if block
        }
    }

    public void fiyEffect() {
        if (this._type > 2) {
            this.enemyFiyEffect();
            return;
        }
        this.cteatEffectActor(75, this._toolInfo[1]);
        this._stopTime = 6;
        this.changeState((byte)10);
        this.changeAction(43);
    }

    private void flyProcess() {
        if (--this._stopTime > 0) {
            return;
        }
        if (this._action != 43) {
            this.changeState((byte)0);
        } else {
            this._stopTime = 10;
            this._action = 4 | this._flipFlag;
            this.changeToWait();
        }
    }

    private void angryInit() {
        if (--this._stopTime > 0) {
            return;
        }
        if (this._angryEye) {
            this._angryEye = false;
            this.checkTerrain(++this._action, this._flipFlag);
            this.changeState((byte)12);
        } else {
            this._angryEye = true;
            this.consumeAngry(-100);
            this._stopTime = 10;
            Assistant assistant = (Assistant)Scene.fetchActorForBomb(77);
            assistant.init(0, this.takeCrenel(0), this.takeCrenel(1));
        }
    }

    private void angryFireProcess() {
        if (this.isActionEnd()) {
            this.fireAngry();
            this.changeToWait();
            this.changeState((byte)0);
        }
    }

    private void upAngle() {
        this._mainActorInfo[2] = this._mainActorInfo[2] + 1;
        this._mainActorInfo[2] = Math.min(this._mainActorInfo[2], 90);
        this.adjustAngle();
        this.checkTerrain(this._action, this._flipFlag);
    }

    private void downAngle() {
        this._mainActorInfo[2] = this._mainActorInfo[2] - 1;
        this._mainActorInfo[2] = Math.max(this._mainActorInfo[2], 0);
        this.adjustAngle();
        this.checkTerrain(this._action, this._flipFlag);
    }

    private void leftWalk() {
        this.checkTerrain(1, Integer.MIN_VALUE);
        this._mainActorInfo[5] = this._mainActorInfo[5] - (Scene._isInCity ? 0 : 3);
        if (this._mainActorInfo[5] < 0) {
            this._mainActorInfo[5] = this._mainActorInfo[5] + 3;
            this.changeToWait();
            return;
        }
        this._vx = -4096;
    }

    private void rightWalk() {
        this.checkTerrain(1, 0);
        this._mainActorInfo[5] = this._mainActorInfo[5] - (Scene._isInCity ? 0 : 3);
        if (this._mainActorInfo[5] < 0) {
            this._mainActorInfo[5] = this._mainActorInfo[5] + 3;
            this.changeToWait();
            return;
        }
        this._vx = 4096;
    }

    private void fireOrder() {
        this._mainActorInfo[8] = this._mainActorInfo[8] + 3;
        this._mainActorInfo[8] = Math.min(this._mainActorInfo[8], 99);
        this._firing = true;
    }

    private void throwOrder() {
        this._mainActorInfo[8] = this._mainActorInfo[8] + 3;
        this._mainActorInfo[8] = Math.min(this._mainActorInfo[8], 99);
        this._throwing = true;
    }

    private void leftJump() {
        this._mainActorInfo[5] = this._mainActorInfo[5] - 25;
        if (this._mainActorInfo[5] < 0) {
            this._mainActorInfo[5] = this._mainActorInfo[5] + 25;
            this._vx = 0;
            this._vy = 0;
            return;
        }
        this._vx = -8192;
        this._vy = -20480;
        this.checkTerrain(12, Integer.MIN_VALUE);
        this.changeState((byte)5);
    }

    private void rightJump() {
        this._mainActorInfo[5] = this._mainActorInfo[5] - 25;
        if (this._mainActorInfo[5] < 0) {
            this._mainActorInfo[5] = this._mainActorInfo[5] + 25;
            this._vx = 0;
            this._vy = 0;
            return;
        }
        this._vx = 8192;
        this._vy = -20480;
        this.checkTerrain(12, 0);
        this.changeState((byte)5);
    }

    private void angryOrder() {
        if (this._mainActorInfo[14] < 100) {
            return;
        }
        this._mainActorInfo[8] = this._mainActorInfo[8] + 3;
        this._mainActorInfo[8] = Math.min(this._mainActorInfo[8], 99);
        this._angrying = true;
    }

    private void fireOrThrow() {
        if (this._firing) {
            this._firing = false;
            this.updateMainBombInfo();
            this.creatBombInfo();
            if (!this._teaching) {
                SceneUI.getInstance().closeCountDown();
            }
        }
        if (this._throwing) {
            this._throwing = false;
            this.updateMainThrowInfo();
            this.creatThrowInfo();
            if (!this._teaching) {
                SceneUI.getInstance().closeCountDown();
            }
        }
    }

    private void fireAngry() {
        if (this._angrying) {
            this._angrying = false;
            this.updateMainAngryInfo();
            this.creatAngryInfo();
            if (!this._teaching) {
                SceneUI.getInstance().closeCountDown();
            }
        }
    }

    private void enemyFire() {
        if (this._firing) {
            this._firing = false;
            this._fireFinish = true;
            this.updateEnemyBombInfo();
            this.creatEnemyBombInfo();
            if (!this._teaching) {
                SceneUI.getInstance().closeCountDown();
            }
        }
    }

    private boolean canUseTool() {
        switch (this._mainActorInfo[21]) {
            case 6: 
            case 7: {
                return true;
            }
        }
        return this._scene.getFocusActor()._id == this._id && this._scene.isCameraStop();
    }

    public void setUesTool(int n) {
        this._mainActorInfo[21] = n;
        this.changeState((byte)6);
    }

    private void setUseInfo() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(2, this._mainActorInfo[21]);
        this._toolInfo[0] = dataTable.getIntItem(3);
        this._toolInfo[1] = dataTable.getIntItem(7);
        this._toolInfo[2] = dataTable.getIntItem(5);
        this._toolInfo[3] = dataTable.getIntItem(4);
    }

    private void useTool() {
        switch (this._toolInfo[0]) {
            case 1: {
                this.consumeHp(this._toolInfo[2]);
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._numInfo[0] = 1;
                this._stopTime = 20;
                this._toolInfo[4] = 0;
                break;
            }
            case 3: {
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._numInfo[0] = 1;
                this._stopTime = 20;
                this._toolInfo[4] = 0;
                this.changeState((byte)0);
                this.changeToWait();
                this.consumeHp(this._toolInfo[2]);
                break;
            }
            case 2: {
                this.consumeHp(this._toolInfo[2]);
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._numInfo[0] = 1;
                this._stopTime = 20;
                this._toolInfo[4] = 0;
                break;
            }
            case 4: {
                this.consumeAngry(this._toolInfo[2]);
                this._mainActorInfo[15] = this._mainActorInfo[14] - this._mainActorInfo[13];
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._numInfo[0] = 2;
                this._numInfo[1] = this._mainActorInfo[15];
                this._numInfo[2] = 5;
                this._numInfo[3] = 0;
                this._stopTime = 20;
                this._toolInfo[4] = 0;
                break;
            }
            case 5: {
                this.consumeFuel(this._toolInfo[2]);
                this._mainActorInfo[6] = this._mainActorInfo[5] - this._mainActorInfo[4];
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._numInfo[0] = 3;
                this._numInfo[1] = this._mainActorInfo[6];
                this._numInfo[2] = 5;
                this._numInfo[3] = 0;
                this._stopTime = 20;
                this._toolInfo[4] = 0;
                break;
            }
            case 6: {
                this._mainActorInfo[19] = this._toolInfo[2];
                this._mainActorInfo[20] = this._toolInfo[2];
                this.cteatEffectActor(75, 5);
                this._mainActorInfo[23] = 1;
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            case 10: {
                this._mainActorInfo[23] = 2;
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            case 7: {
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._mainActorInfo[17] = this._toolInfo[2];
                this._mainActorInfo[23] = 3;
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            case 8: {
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._mainActorInfo[16] = this._toolInfo[2];
                this._mainActorInfo[23] = this._mainActorInfo[16] == 30 ? 6 : (this._mainActorInfo[16] == 50 ? 7 : 5);
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            case 12: {
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._numInfo[0] = 4;
                this._numInfo[2] = 5;
                this._numInfo[3] = 5;
                this._stopTime = 20;
                this._toolInfo[4] = 0;
                this._toolInfo[3] = 1;
                break;
            }
            default: {
                return;
            }
        }
        this.changeState((byte)7);
    }

    public boolean isLightAttack() {
        return this._mainActorInfo[23] == 2;
    }

    public boolean isDoubleAttach() {
        return this._mainActorInfo[23] == 3;
    }

    public void setStopIcon() {
        this._mainActorInfo[23] = 4;
        this._toolInfo[4] = 1;
    }

    private void cteatEffectActor(int n, int n2) {
        Assistant assistant = (Assistant)Scene.fetchActorForBomb(n);
        assistant.init(n2, this._x, this._y);
    }

    private void creatFireEffectActor() {
        Assistant assistant = (Assistant)Scene.fetchActorForBomb(72);
        int n = this.calAngle() >> 1;
        int n2 = this._action / 14;
        if (n2 == 1) {
            ++n;
            n = Math.min(n, 3);
        } else if (n2 == 2) {
            n = --n < 0 ? 4 : n;
        }
        assistant.init(n | this._flipFlag, this.takeCrenel(0), this.takeCrenel(1));
    }

    private void cteatAngryEffectActor(int n, int n2) {
        Assistant assistant = (Assistant)Scene.fetchActorForBomb(n);
        assistant.init(n2, this._x, this._y);
    }

    public void changeToWait() {
        if (this._action == this._actionNum - 1) {
            return;
        }
        this._vx = 0;
        this.adjustAngle();
        this.checkTerrain(Scene._isInCity ? 0 : this._action, this._flipFlag);
    }

    private final void analyseProcess() {
        if (this.noAnalyse()) {
            return;
        }
        if (this._rcInfo[0] >= 0) {
            this._rcInfo[0] = -1;
            this._rcInfo[2] = 3 + Function.Random(5);
            this.checkTerrain(this._action, this._flipFlag);
            this.changeEnemyState((byte)0);
            this.changeEnemyKey(this._flipFlag != 0 ? 1 : 2);
            return;
        }
        int n = Function.Random(100);
        if (n < 20) {
            this.analyseToolProcess();
        } else {
            this.analyseFireProcess();
        }
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(2, this._mainActorInfo[21]);
        if (dataTable.getIntItem(3) == 1 && this._mainActorInfo[10] >= this._mainActorInfo[12] * 60 / 100) {
            this.analyseFireProcess();
        }
    }

    private void analyseFireProcess() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(1, this._mainActorInfo[1]);
        int[] nArray = dataTable.getArrayItem(10);
        int[] nArray2 = dataTable.getArrayItem(16);
        int n = Function.Random(100);
        int n2 = 0;
        while (n2 < C_ARR_RATE[nArray2.length - 1].length) {
            if (n < C_ARR_RATE[nArray2.length - 1][n2]) {
                this._mainActorInfo[18] = nArray[n2];
                this._mainActorInfo[19] = nArray2[n2];
                break;
            }
            ++n2;
        }
        this._rcInfo[1] = this.calcuAim(Function.Random(2));
        if (Scene._activeInsts[this._rcInfo[1]]._x < this._x) {
            this.changeAction(this._action | Integer.MIN_VALUE);
        } else {
            this.changeAction(this._action);
        }
        this.changeEnemyState((byte)0);
        this.changeEnemyKey(16);
    }

    private void analyseToolProcess() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(1, this._mainActorInfo[1]);
        int[] nArray = dataTable.getArrayItem(11);
        int n = Function.Random(100);
        int n2 = 0;
        while (n2 < C_ARR_RATE[nArray.length - 1].length) {
            if (n < C_ARR_RATE[nArray.length - 1][n2]) {
                this._mainActorInfo[21] = nArray[n2];
                break;
            }
            ++n2;
        }
        this.changeEnemyState((byte)0);
        this.changeEnemyKey(512);
    }

    private boolean noAnalyse() {
        return this._scene.getFocusActor()._id != this._id || !this._scene.isHitState(0) || this._fireFinish;
    }

    private int calcuAim(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = Scene._tankOneTeamNum;
        int n7 = 0;
        while (n7 < n6) {
            if (Scene._actorExistFlag[0][n7] >= 0 && Scene._activeInsts[n2 = Scene._mainActor[n7]._id] != null && Actor.isMainActorType(Scene._activeInsts[n2]._type)) {
                MainActor mainActor = (MainActor)Scene._activeInsts[n2];
                if (mainActor._mainActorInfo[10] != 0) {
                    if (n == 0) {
                        n4 = mainActor._mainActorInfo[10] != 0 ? Math.abs(this._x - mainActor._x) : n4;
                    } else {
                        int n8 = n4 = mainActor._mainActorInfo[10] != 0 ? mainActor._mainActorInfo[10] : n4;
                    }
                    if (n4 < n5 || n5 == -1) {
                        n5 = n4;
                        n3 = Scene._mainActor[n7]._id;
                    }
                }
            }
            ++n7;
        }
        return n3;
    }

    private void enemyFireProcess() {
        if (this.isActionEnd()) {
            this.enemyFire();
            this.changeToWait();
            this.changeEnemyState((byte)2);
            this._stopTime = 0;
        }
    }

    private void enemyFiringProcess() {
        if (--this._stopTime > 0) {
            return;
        }
        this.initEnemyBombfire();
    }

    private void enemyUesProcess() {
        this.enemySetUseInfo();
        this.enemyUseTool();
    }

    private void enemySetUseInfo() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(2, this._mainActorInfo[21]);
        this._toolInfo[0] = dataTable.getIntItem(3);
        this._toolInfo[1] = dataTable.getIntItem(7);
        this._toolInfo[2] = dataTable.getIntItem(5);
        this._toolInfo[3] = dataTable.getIntItem(4);
    }

    private void enemyUseTool() {
        switch (this._toolInfo[0]) {
            case 1: {
                this.consumeHp(this._toolInfo[2]);
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._numInfo[0] = 1;
                this._stopTime = 20;
                this._toolInfo[4] = 0;
                break;
            }
            case 6: {
                this._mainActorInfo[19] = this._toolInfo[2];
                this._mainActorInfo[20] = this._toolInfo[2];
                this.cteatEffectActor(75, 5);
                this._mainActorInfo[23] = 1;
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            case 10: {
                this._mainActorInfo[23] = 2;
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            case 7: {
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._mainActorInfo[17] = this._toolInfo[2];
                this._mainActorInfo[23] = 3;
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            case 8: {
                this.cteatEffectActor(75, this._toolInfo[1]);
                this._mainActorInfo[16] = this._toolInfo[2];
                this._mainActorInfo[23] = this._mainActorInfo[16] == 30 ? 6 : (this._mainActorInfo[16] == 50 ? 7 : 5);
                this._stopTime = 0;
                this._toolInfo[4] = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.changeEnemyState((byte)5);
    }

    private void enemyEffectProcess() {
        if (--this._stopTime > 0) {
            return;
        }
        if (this._toolInfo[3] == 0) {
            this._useTool = false;
            this.analyseFireProcess();
        } else {
            this._useTool = false;
            this._useToolFinish = true;
            this._fireFinish = true;
            this.changeEnemyState((byte)6);
        }
    }

    public void enemyFiyEffect() {
        this.cteatEffectActor(75, this._toolInfo[1]);
        this._stopTime = 6;
        this.changeEnemyState((byte)7);
        this.changeAction(this._actionNum - 1 | this._flipFlag);
    }

    private void enemyFlyProcess() {
        if (--this._stopTime > 0) {
            return;
        }
        if (this._action != this._actionNum - 1) {
            this.changeEnemyState((byte)0);
        } else {
            this._stopTime = 10;
            this.changeAction(0 | this._flipFlag);
            this.changeToWait();
        }
    }

    private void enemyHurtProcess() {
        if (this.isActionEnd()) {
            this.changeToWait();
            this.changeEnemyState((byte)0);
        }
    }

    protected void changeBombId(int n, int n2) {
        if (this._bombId == null) {
            return;
        }
        int n3 = 0;
        while (n3 < this._bombId.length) {
            if (this._bombId[n3] == n2) {
                this._bombId[n3] = n;
                return;
            }
            ++n3;
        }
    }

    private void bombChangeFocus() {
        if (this._bombId == null) {
            return;
        }
        int n = 0;
        while (n < this._bombId.length) {
            if (this._bombId[n] >= 0) {
                Actor actor = Scene._activeInsts[this._bombId[n]];
                if (actor == null) {
                    this._bombId[n] = -1;
                } else {
                    if (actor._type == 73) {
                        if (actor._curFrame == actor._actFrmNum - 3) {
                            this._bombId[n] = -1;
                        }
                    } else if (actor._type == 61) {
                        if (actor._id != Scene.getInstance().getFocusActor()._id) {
                            Scene.changeFocus(actor, (byte)0);
                        }
                    } else {
                        this._bombId[n] = -1;
                    }
                    return;
                }
            }
            ++n;
        }
    }

    private void changeEnemyKey(int n) {
        this._enemyKeyCode = n;
    }

    private void adversaryKeyHandler() {
        if (this.noRespondEnemyKey()) {
            return;
        }
        this.teaching();
        switch (this._enemyKeyCode) {
            case 1: {
                this.enemyLeftWalk();
                break;
            }
            case 2: {
                this.enemyRightWalk();
                break;
            }
            case 16: {
                this.enemyFireOrder();
                break;
            }
            case 512: {
                this.enemyToolOrder();
                break;
            }
            default: {
                if (this.isDoubleAttach() && !this._firing) {
                    this._firing = true;
                    this._mainActorInfo[23] = 0;
                    this._mainActorInfo[8] = this._mainActorInfo[7];
                } else if (this._firing) {
                    this.changeAction(this._action + 2 | this._flipFlag);
                    this.changeEnemyState((byte)1);
                } else {
                    this.changeToWait();
                    this.changeEnemyState((byte)6);
                }
                this._enemyKeyCode = 0;
            }
        }
    }

    private void enemyLeftWalk() {
        this._rcInfo[2] = this._rcInfo[2] - 1;
        if (this._rcInfo[2] > 0 && this.canWalking()) {
            this.checkTerrain(1, Integer.MIN_VALUE);
            this._vx = -4096;
        } else {
            this._vx = 0;
            this._rcInfo[2] = -1;
            this.changeEnemyKey(0);
        }
    }

    private void enemyRightWalk() {
        this._rcInfo[2] = this._rcInfo[2] - 1;
        if (this._rcInfo[2] > 0 && this.canWalking()) {
            this.checkTerrain(1, 0);
            this._vx = 4096;
        } else {
            this._vx = 0;
            this._rcInfo[2] = -1;
            this.changeEnemyKey(0);
        }
    }

    private void enemyFireOrder() {
        if (!this._firing) {
            this.calcuTrajectory(this._rcInfo[1]);
            this._firing = true;
        }
        this.changeEnemyKey(0);
    }

    private void enemyToolOrder() {
        this.changeEnemyState((byte)4);
        this.changeEnemyKey(0);
    }

    private boolean canWalking() {
        boolean bl = false;
        boolean bl2 = false;
        if (this._flipFlag == 0) {
            bl = this.checkRightWall(4096);
            bl2 = this.checkGround(4096);
        } else {
            bl = this.checkLeftWall(-4096);
            bl2 = this.checkGround(-4096);
        }
        return !bl && bl2;
    }

    protected void checkTerrain(int n, int n2) {
        switch (this._action) {
            case 42: 
            case 43: {
                return;
            }
        }
        this._mainActorInfo[3] = this._scene.calcSlope(this._x, this._y, n2);
        int n3 = this._mainActorInfo[3] == 0 ? 0 : this._mainActorInfo[3] / Math.abs(this._mainActorInfo[3]);
        int n4 = this._partnerAi ? 14 : 4;
        int n5 = n % n4;
        switch (n3) {
            case 1: {
                this.changeAction(n4 + n5 | n2);
                break;
            }
            case -1: {
                this.changeAction((n4 << 1) + n5 | n2);
                break;
            }
            default: {
                this.changeAction(n5 | n2);
            }
        }
    }

    public int calAngle() {
        int n = 0;
        if (this._mainActorInfo[2] > 75) {
            n = 6;
        } else if (this._mainActorInfo[2] > 45) {
            n = 4;
        } else if (this._mainActorInfo[2] > 15) {
            n = 2;
        }
        return n;
    }

    private void drawCircle(Graphics graphics, int n, int n2) {
        switch (this._action) {
            case 42: 
            case 43: {
                return;
            }
        }
        int n3 = (this._x >> 10) - n;
        int n4 = (this._y >> 10) - n2;
        int n5 = 19;
        int n6 = 62;
        int n7 = 0;
        int n8 = 0;
        int n9 = this._action / 14;
        int n10 = this._mainActorInfo[2];
        int n11 = this._flipFlag != 0 ? -1 : 1;
        switch (n9) {
            case 1: {
                n10 = this._mainActorInfo[2] + 30;
                n10 = n10 > 90 ? 90 : n10;
                break;
            }
            case 2: {
                n10 = this._mainActorInfo[2] - 30;
            }
        }
        n7 = (n6 - n5) * Function.cos(n10);
        n8 = (n6 - n5) * Function.sin(n10);
        _circle.draw(graphics, n3, n4, n9 | this._flipFlag, 0, 0);
        graphics.setColor(0xFF0000);
        graphics.drawLine(n3 + n11 * n5, n4 - 26, n3 + (n7 >>= 10) * n11 + n11 * n5, n4 - (n8 >>= 10) - 26);
    }

    private void countHpLine() {
        if (this._mainActorInfo[9] < this._mainActorInfo[10]) {
            this._mainActorInfo[9] = this._mainActorInfo[9] + (this._mainActorInfo[11] >> 2 < 1 ? 1 : this._mainActorInfo[11] >> 2);
            this._mainActorInfo[9] = Math.min(this._mainActorInfo[9], this._mainActorInfo[10]);
        } else if (this._mainActorInfo[9] > this._mainActorInfo[10]) {
            this._mainActorInfo[9] = this._mainActorInfo[9] + (this._mainActorInfo[11] >> 2 > -1 ? -1 : this._mainActorInfo[11] >> 2);
            this._mainActorInfo[9] = Math.max(this._mainActorInfo[9], this._mainActorInfo[10]);
        } else if (this._numInfo[2] <= 0) {
            if (this._partnerAi && (this._state == 0 || this._state == 9)) {
                this._numInfo[2] = -1;
            } else if (!(this._partnerAi || this._enemyState != 6 && this._enemyState != 0)) {
                this._numInfo[2] = -1;
            }
        }
    }

    private void countSpLine() {
        if (this._mainActorInfo[13] < this._mainActorInfo[14]) {
            this._mainActorInfo[13] = this._mainActorInfo[13] + (this._mainActorInfo[15] >> 2 < 1 ? 1 : this._mainActorInfo[15] >> 2);
            this._mainActorInfo[13] = Math.min(this._mainActorInfo[13], this._mainActorInfo[14]);
        } else if (this._mainActorInfo[13] > this._mainActorInfo[14]) {
            this._mainActorInfo[13] = this._mainActorInfo[13] + (this._mainActorInfo[15] >> 2 > -1 ? -1 : this._mainActorInfo[15] >> 2);
            this._mainActorInfo[13] = Math.max(this._mainActorInfo[13], this._mainActorInfo[14]);
        }
    }

    private void countFuelLine() {
        if (this._mainActorInfo[4] < this._mainActorInfo[5]) {
            this._mainActorInfo[4] = this._mainActorInfo[4] + (this._mainActorInfo[6] >> 2 < 4 ? 3 : this._mainActorInfo[6] >> 2);
            this._mainActorInfo[4] = Math.min(this._mainActorInfo[4], this._mainActorInfo[5]);
        } else if (this._mainActorInfo[4] > this._mainActorInfo[5]) {
            this._mainActorInfo[4] = this._mainActorInfo[4] + (this._mainActorInfo[6] >> 2 > -4 ? -3 : this._mainActorInfo[6] >> 2);
            this._mainActorInfo[4] = Math.max(this._mainActorInfo[4], this._mainActorInfo[5]);
        }
    }

    private void drawActorInfo(Graphics graphics, int n, int n2) {
        if (this._mainActorInfo[1] <= 2 && !RoleTeamData.getInstance().getExistFlag(this._mainActorInfo[1])) {
            return;
        }
        if (this._action == 43) {
            return;
        }
        this.countHpLine();
        this.countSpLine();
        this.countFuelLine();
        int n3 = (this._x >> 10) - n;
        int n4 = (this._y >> 10) - n2;
        if (this._mainActorInfo[23] > 0) {
            if (this._mainActorInfo[23] == 4 && this._state != 9) {
                ResourceManager._avats[69].draw(graphics, n3, n4, 0, 0, 0);
            } else {
                ResourceManager._spts[81].draw(graphics, n3 - 26, n4 + 2, this._mainActorInfo[23] + 9, 0, 4 | 0x10);
            }
        }
        Function.drawRect(graphics, n3 - 16, n4 + 3, 32, 6, 0x660033);
        Function.fillScreen(graphics, n3 - 15, n4 + 4, 31 * (this._mainActorInfo[9] << 10) / this._mainActorInfo[12] >> 10, 1, 0xFF9999);
        Function.fillScreen(graphics, n3 - 15, n4 + 5, 31 * (this._mainActorInfo[9] << 10) / this._mainActorInfo[12] >> 10, 1, 0xFFCC99);
        Function.fillScreen(graphics, n3 - 15, n4 + 6, 31 * (this._mainActorInfo[9] << 10) / this._mainActorInfo[12] >> 10, 1, 0xFF6666);
        Function.fillScreen(graphics, n3 - 15, n4 + 7, 31 * (this._mainActorInfo[9] << 10) / this._mainActorInfo[12] >> 10, 1, 0xCC0033);
        Function.fillScreen(graphics, n3 - 15, n4 + 8, 31 * (this._mainActorInfo[9] << 10) / this._mainActorInfo[12] >> 10, 1, 0x663333);
        if (this._numInfo[2] <= 0) {
            return;
        }
        graphics.setClip(0, 0, 240, 320);
        int n5 = Function.countOffsetX(Math.abs(this._numInfo[1]), 0, 12) + 12;
        int n6 = 70 + (5 - this._numInfo[2]) * this._numInfo[3];
        switch (this._numInfo[0]) {
            case 0: {
                Function.drawSignNumer(graphics, n3 + n5 / 2, n4 - n6, Math.abs(this._numInfo[1]), 2, 60);
                break;
            }
            case 1: {
                Function.drawSignNumer(graphics, n3 + n5 / 2, n4 - n6, Math.abs(this._numInfo[1]), 3, 71);
                break;
            }
            case 4: {
                ResourceManager._spts[75].draw(graphics, n3 - 22, n4 - n6, 10, 0, 4 | 0x10);
            }
        }
        this._numInfo[2] = this._numInfo[2] - 1;
    }

    public boolean isHurtOver() {
        return this._numInfo[2] < 0;
    }

    public void initBombfire() {
        if (this._bParam[11] <= 0) {
            this.changeToWait();
            this.changeState((byte)0);
            return;
        }
        int n = 0;
        while (n < this._bParam[10]) {
            this.firing(this._bParam, n);
            ++n;
        }
        this._bParam[11] = this._bParam[11] - 1;
        this._stopTime = 10;
    }

    public void initEnemyBombfire() {
        if (this._bParam[11] <= 0) {
            this.changeToWait();
            this.changeEnemyState((byte)0);
            return;
        }
        int n = 0;
        while (n < this._bParam[10]) {
            this.firing(this._bParam, n);
            ++n;
        }
        this._bParam[11] = this._bParam[11] - 1;
        this._stopTime = 10;
    }

    public void initBombInfo(int n, int n2) {
        this._bParam[12] = this._mainActorInfo[0];
        this._bParam[17] = n2;
        this._bParam[0] = 61;
        this._bParam[1] = n | this._flipFlag;
        this._bParam[2] = this.takeCrenel(0);
        this._bParam[3] = this.takeCrenel(1);
        this._bParam[6] = SceneUI.getInstance().getWind() << 5;
        this._bParam[7] = 3072;
        this._bParam[8] = 61440;
        this._bParam[9] = 61440;
        this._bParam[4] = 40 * this._mainActorInfo[8] / 99;
        this._bParam[5] = this._mainActorInfo[2] + this._mainActorInfo[3];
        this._bParam[5] = Math.min(this._bParam[5], 90);
        this._bParam[5] = Math.max(this._bParam[5], -90);
        this._mainActorInfo[7] = this._mainActorInfo[8];
        this._mainActorInfo[8] = 0;
    }

    private void creatEnemyBombInfo() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(4, this._mainActorInfo[19]);
        int n = this._mainActorInfo[18];
        int n2 = dataTable.getIntItem(3);
        int n3 = this._mainActorInfo[19];
        if (this._mainActorInfo[23] == 1) {
            n = 1;
            n2 = 0;
            n3 = 16;
        }
        this.initBombData(n);
        this.initBombInfo(n2, n3);
    }

    private void creatBombInfo() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(3, this._mainActorInfo[18]);
        int n = dataTable.getIntItem(3);
        dataTable = gameDB.getData(4, this._mainActorInfo[19]);
        int n2 = dataTable.getIntItem(3);
        int n3 = this._mainActorInfo[19];
        if (this._mainActorInfo[23] == 1) {
            n = 1;
            n2 = 0;
            n3 = 16;
        }
        this.initBombData(n);
        this.initBombInfo(n2, n3);
    }

    private void creatThrowInfo() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(4, this._mainActorInfo[20]);
        int n = dataTable.getIntItem(10);
        int n2 = dataTable.getIntItem(3);
        int n3 = this._mainActorInfo[20];
        if (this._mainActorInfo[23] == 1) {
            n = 1;
            n2 = 0;
            n3 = 16;
        }
        this.initBombData(n);
        this.initBombInfo(n2, n3);
    }

    private void creatAngryInfo() {
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(4, BOMB_ANGRY[this._type]);
        int n = dataTable.getIntItem(10);
        int n2 = dataTable.getIntItem(3);
        byte by = BOMB_ANGRY[this._type];
        this.initBombData(n);
        this.initBombInfo(n2, by);
        this.initBombfire();
    }

    public void initBombData(int n) {
        switch (n) {
            case 1: 
            case 5: 
            case 7: {
                this._bParam[10] = 1;
                this._bParam[11] = 1;
                break;
            }
            case 2: {
                this._bParam[10] = 1;
                this._bParam[11] = 3;
                break;
            }
            case 3: {
                this._bParam[10] = 3;
                this._bParam[11] = 1;
                break;
            }
            case 6: {
                this._bParam[10] = 5;
                this._bParam[11] = 1;
            }
        }
        this._bombId = new int[this._bParam[11]];
        int n2 = 0;
        while (n2 < this._bombId.length) {
            this._bombId[n2] = -1;
            ++n2;
        }
    }

    public int takeCrenel(int n) {
        int n2 = n == 0 && this._flipFlag != 0 ? -1 : 1;
        int n3 = (n == 0 ? this._x : this._y) >> 10;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this._mainActorInfo[1] <= 2) {
            n5 = this._state == 3 ? 2 : 5;
            n6 = this._action % 14;
            n5 = n6 == 4 || n6 == 1 || n6 == 0 ? 4 : n5;
            n4 = (n6 - n5 >> 1) + this._action / 14 * 5;
            try {
                n3 += this.crenelPos[(n4 << 1) + n] * n2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            n5 = this._mainActorInfo[3] + this._mainActorInfo[2];
            n5 = n == 0 ? Function.cos(n5) : Function.sin(n5);
            n5 = n == 0 && this.isFlip() ? -n5 : n5;
            n3 += this.crenelPos[n4] * n5 >> 10;
            n3 += n == 0 ? 0 : this.crenelPos[n4 + 1];
        }
        return n3 << 10;
    }

    public void firing(int[] nArray, int n) {
        int n2;
        int[] nArray2 = new int[18];
        System.arraycopy(nArray, 0, nArray2, 0, 18);
        int n3 = nArray2[4];
        int n4 = nArray2[5];
        int n5 = nArray2[1] & 0xFF000000;
        int n6 = n2 = n5 == 0 ? 1 : -1;
        if (n4 > 90) {
            n2 = -n2;
            nArray2[1] = nArray2[1] ^ Integer.MIN_VALUE;
        }
        if (nArray2[10] == 3) {
            nArray2[3] = nArray2[3] + (1 - n * 2048);
            nArray2[4] = n != 1 ? (n == 0 ? n3 * Function.cos(n4) * n2 * 4 / 5 : n3 * Function.cos(n4) * n2 * 5 / 4) : n3 * Function.cos(n4 += (n - 1) * 4) * n2;
            nArray2[5] = -n3 * Function.sin(n4);
        } else if (nArray2[10] == 5) {
            nArray2[3] = nArray2[3] + (1 - n * 2048);
            nArray2[4] = n3 * Function.cos(90 - (n4 += (n - 2) * 8)) * n2;
            nArray2[5] = -n3 * Function.sin(n4);
        } else {
            nArray2[4] = n3 * Function.cos(n4) * n2;
            nArray2[5] = -n3 * Function.sin(n4);
        }
        this.generateBomb(nArray2);
        nArray2 = null;
    }

    public void generateBomb(int[] nArray) {
        Bomb bomb = (Bomb)Scene.fetchActorForBomb(nArray[0]);
        bomb.initBomb(nArray);
        this._bombId[this._bombId.length - this._bParam[11]] = bomb._id;
    }

    public boolean consumeHp(int n) {
        if (this.isDeathState()) {
            return true;
        }
        if (n < 0) {
            n = (n += this._mainActorInfo[26]) >= 0 ? -1 : n;
        }
        this._mainActorInfo[10] = this._mainActorInfo[10] + n;
        this._mainActorInfo[10] = Math.max(this._mainActorInfo[10], 0);
        this._mainActorInfo[11] = this._mainActorInfo[10] > 0 ? n : -this._mainActorInfo[9];
        this._mainActorInfo[10] = Math.min(this._mainActorInfo[10], this._mainActorInfo[12]);
        this._mainActorInfo[11] = this._mainActorInfo[10] < this._mainActorInfo[12] ? this._mainActorInfo[11] : this._mainActorInfo[12] - this._mainActorInfo[9];
        this._numInfo[0] = n < 0 ? 0 : this._numInfo[0];
        this._numInfo[1] = this._mainActorInfo[11];
        this._numInfo[2] = 5;
        this._numInfo[3] = 5;
        if (n < 0) {
            if (this._mainActorInfo[10] <= 0) {
                this.death();
                this._mainActorInfo[23] = 0;
                return true;
            }
            this.hurt();
            this.consumeAngry(10);
        }
        if (this._mainActorInfo[1] > 2) {
            return false;
        }
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
        gameRoleData.setCurHp(this._mainActorInfo[10]);
        return false;
    }

    public void fullHp() {
        this._mainActorInfo[10] = this._mainActorInfo[12];
        this._mainActorInfo[9] = this._mainActorInfo[12];
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
        gameRoleData.setCurHp(this._mainActorInfo[10]);
    }

    private void death() {
        switch (this._type) {
            case 0: 
            case 1: 
            case 2: {
                if (this._state == 9) break;
                this.changeAction(0x2A | this._flipFlag);
                this.changeState((byte)9);
                GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
                gameRoleData.setCurHp(this._mainActorInfo[10]);
                break;
            }
            default: {
                Scene._actorExistFlag[0][this._mainActorInfo[0]] = -1;
                this.creatBoxOrMoney();
                this.countKillNumber();
                this.disActive();
                this.cteatAngryEffectActor(79, 0);
            }
        }
    }

    private void creatBoxOrMoney() {
        Device device = (Device)Scene.fetchActorForBomb(97);
        device.init(0, this._x, this._y);
        GameDB gameDB = GameDB.getGameDataBase();
        DataTable dataTable = gameDB.getData(1, this._mainActorInfo[1]);
        int n = Function.Random(10);
        int n2 = 3;
        if (n > n2) {
            device.setMoneyBox(dataTable.getIntItem(8));
            device.collideBoxProcess();
            return;
        }
        int[] nArray = dataTable.getArrayItem(6);
        n = Function.Random(100);
        int n3 = 0;
        while (n3 < C_TOOL_RATE0[nArray.length - 1].length) {
            if (n < C_TOOL_RATE0[nArray.length - 1][n3]) {
                n = n3;
                break;
            }
            ++n3;
        }
        n3 = nArray[n];
        nArray = dataTable.getArrayItem(7);
        int n4 = nArray[n];
        int n5 = 1;
        device.setCommanBox(n3, n4, n5 += Function.Random(2));
        device.collideBoxProcess();
    }

    private void countKillNumber() {
        if (this._mainActorInfo[1] > 2) {
            RoleTeamData roleTeamData = RoleTeamData.getInstance();
            roleTeamData.consumeKill(this._mainActorInfo[1], 1, 0);
        }
    }

    private void hurt() {
        int n = this._partnerAi ? 13 : 3;
        this.checkTerrain(n, this._flipFlag);
        if (this._partnerAi) {
            this.changeState((byte)8);
        } else {
            this.changeEnemyState((byte)8);
        }
    }

    private void calcuTrajectory(int n) {
        if (n < 0) {
            n = this.calcuAim(Function.Random(2));
        }
        MainActor mainActor = (MainActor)Scene._activeInsts[n];
        int n2 = 0;
        int n3 = 90;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 99;
        int n8 = 0;
        boolean bl = true;
        int[] nArray = new int[2];
        if (Math.abs(this._x - mainActor._x >> 10) > 100) {
            n2 = 20;
            n3 = 86;
            n5 = 6;
        }
        while (bl) {
            this._mainActorInfo[2] = n4 = n2;
            this._mainActorInfo[8] = 49 + Function.Random(49);
            while (n5 < n7) {
                n6 = (n5 + n7) / 2;
                n8 = 40 * n6 / 99;
                if (this.innerLoop(mainActor, n4, n8, nArray)) {
                    this._mainActorInfo[8] = n6;
                    bl = false;
                    return;
                }
                if (nArray[0] < 0) {
                    if (this._flipFlag == 0) {
                        n5 = n6 + 1;
                        continue;
                    }
                    n7 = n6 - 1;
                    continue;
                }
                if (this._flipFlag == 0) {
                    n7 = n6 - 1;
                    continue;
                }
                n5 = n6 + 1;
            }
            if (n2 >= n3) {
                bl = false;
                this._mainActorInfo[8] = n6;
                continue;
            }
            ++n2;
            n5 = 6;
            n7 = 99;
        }
        this._bParam[13] = mainActor._x;
        this._bParam[14] = mainActor._y;
    }

    private boolean innerLoop(Actor actor, int n, int n2, int[] nArray) {
        int n3 = this.takeCrenel(0);
        int n4 = this.takeCrenel(1);
        int n5 = SceneUI.getInstance().getWind() << 5;
        int n6 = 3072;
        int n7 = 61440;
        int n8 = 61440;
        int n9 = 1;
        int n10 = this._flipFlag == 0 ? 1 : -1;
        n9 = n < 0 ? -n9 : n9;
        n10 = n > 90 ? -n10 : n10;
        int n11 = n2 * Function.cos(n) * n10;
        int n12 = -n2 * Function.sin(n) * n9;
        int n13;
        int n14;
        int n15;
        int n16;
        while (!actor.collide(n16 = (n3 >> 10) - 8, n15 = (n4 >> 10) - 8, n14 = (n3 >> 10) + 8, n13 = (n4 >> 10) + 8)) {
            if (this._flipFlag == 0 && (n3 > actor._x || n3 <= this._x)) {
                nArray[0] = -1;
                return false;
            }
            if (this._flipFlag != 0 && (n3 < actor._x || n3 >= this._x)) {
                nArray[0] = 1;
                return false;
            }
            n3 += n11;
            n4 += n12;
            n11 += n5;
            if (n6 > 0 && (n12 += n6) > n8) {
                n12 = n8;
            }
            if (n6 < 0 && n12 < -n8) {
                n12 = -n8;
            }
            if (n5 > 0 && n11 > n7) {
                n11 = n7;
            }
            if (n5 >= 0 || n5 >= -n7) continue;
            n11 = -n7;
        }
        return true;
    }

    public void consumeFuel(int n) {
        this._mainActorInfo[5] = this._mainActorInfo[5] + n;
        this._mainActorInfo[5] = Math.max(this._mainActorInfo[5], 0);
        this._mainActorInfo[6] = this._mainActorInfo[5] > 0 ? n : -this._mainActorInfo[4];
        this._mainActorInfo[5] = Math.min(this._mainActorInfo[5], 100);
        int n2 = this._mainActorInfo[6] = this._mainActorInfo[5] < 100 ? this._mainActorInfo[6] : 100 - this._mainActorInfo[4];
        if (this._mainActorInfo[1] > 2) {
            return;
        }
        GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
        gameRoleData.setCurMove(this._mainActorInfo[5]);
    }

    public void consumeAngry(int n) {
        this._mainActorInfo[14] = this._mainActorInfo[14] + n;
        this._mainActorInfo[14] = Math.max(this._mainActorInfo[14], 0);
        this._mainActorInfo[15] = this._mainActorInfo[14] > 0 ? n : -this._mainActorInfo[13];
        this._mainActorInfo[14] = Math.min(this._mainActorInfo[14], 100);
        this._mainActorInfo[15] = this._mainActorInfo[14] < 100 ? this._mainActorInfo[15] : 100 - this._mainActorInfo[13];
    }

    public boolean consumeExperience(int n) {
        boolean bl = false;
        if (this._mainActorInfo[1] <= 2) {
            GameRoleData gameRoleData = RoleTeamData.getInstance().getRoleData(this._mainActorInfo[1]);
            bl = gameRoleData.obtainExperience(n);
            this.updateMainInfo();
        }
        return bl;
    }

    public void setPos(int n, int n2) {
        this._x = n;
        this._y = n2;
        this._vx = 0;
        this._vy = 0;
        this._dx = 0;
        this._dy = 0;
    }

    public void changeState(byte by) {
        this._state = by;
    }

    public boolean isCommonState() {
        return this._state == 0;
    }

    public boolean isflyState() {
        return this._state == 10;
    }

    public boolean isDeathState() {
        return this._state == 9;
    }

    public void changeEnemyState(byte by) {
        this._enemyState = by;
    }

    public boolean needDisActive() {
        return this._type <= 2 ? !RoleTeamData.getInstance().getExistFlag(this._type) : false;
    }

    public void setAI(boolean bl) {
        super.setAI(bl);
        this._vx = 0;
        this._vy = 0;
        this.changeToWait();
    }

    public void teachinfo(int n, int n2) {
        this._teachKind = n;
        this._teachTarget = n2;
        this._teaching = true;
        switch (this._teachTarget) {
            case 0: {
                this._teachAngle = 20;
                this._teachPower = 70;
                break;
            }
            case 1: {
                this._teachAngle = 50;
                this._teachPower = 99;
            }
        }
        switch (this._teachKind) {
            case 0: {
                break;
            }
            case 1: {
                this._firing = true;
                break;
            }
            case 2: {
                this._angrying = true;
                this._mainActorInfo[14] = 100;
                this._mainActorInfo[13] = 100;
            }
        }
        if (!this._partnerAi) {
            this.changeEnemyState((byte)0);
            this._mainActorInfo[18] = 1;
            this._mainActorInfo[19] = 17;
        }
    }

    public void teaching() {
        if (!this.isTeaching()) {
            return;
        }
        if (!this._firing && !this._angrying) {
            return;
        }
        this._mainActorInfo[2] = this._teachAngle;
        this._mainActorInfo[8] = this._teachPower;
        KeyCode.resetCurKey();
    }

    public void closeTeach() {
        this._teaching = false;
        Scene.getInstance().closeSceneTeachOne();
        Scene.getInstance().closeSceneTeachTwo();
    }

    public boolean isTeaching() {
        return this._teaching;
    }

    public final boolean isFollower() {
        return this._followManager != null && this._scene.isScriptEnd();
    }

    public final void changeToFollower(Actor actor, int n) {
        this.initFollowManager(actor, n);
    }

    private final void initFollowManager(Actor actor, int n) {
        if (this._followManager == null) {
            this._followManager = new FollowManager(this);
        }
        this._followManager.init(actor, this._type, this._x, this._y, n);
    }

    public void moveToLeft(int n) {
        this.checkTerrain(1, Integer.MIN_VALUE);
        this._x -= n;
    }

    public void moveToRight(int n) {
        this.checkTerrain(1, 0);
        this._x += n;
    }

    public void standBy() {
        this.changeToWait();
    }

    private final void followHandle() {
        this._followManager.followHandle();
    }
}

