/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.s2nparser;

import com.sinaflying.customise.LittleHashtable;
import com.sinaflying.customise.LittleVector;
import com.sinaflying.customise.R;
import com.sinaflying.s2nparser.IS2nExecutor;
import com.sinaflying.s2nparser.ScenarioBasic;
import com.sinaflying.s2nparser.ScenarioCall;
import com.sinaflying.s2nparser.ScenarioCommand;
import com.sinaflying.s2nparser.ScenarioIfblock;
import com.sinaflying.s2nparser.ScenarioSyncblock;
import java.io.DataInputStream;
import java.io.IOException;

public class S2nParser {
    private static boolean _ondebug = true;
    private boolean _isSimplifiedChinese;
    private int _item;
    private int _itemScrpit;
    private int _idx;
    private boolean _once;
    private int _condition;
    public int _condionOper;
    private String _fileName;
    private LittleHashtable _mems;
    private LittleVector _commands = null;
    private IS2nExecutor _executor;

    public S2nParser(String string, int n, IS2nExecutor iS2nExecutor, LittleHashtable littleHashtable) {
        this._mems = littleHashtable;
        this._fileName = string;
        this._idx = n;
        this._executor = iS2nExecutor;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean buildToTree() {
        var1_1 = null;
        try {
            var1_1 = R.openDataInputStream(this._fileName, this._idx);
            var2_2 = var1_1.readByte();
            this._isSimplifiedChinese = var2_2 == 0;
            this._once = var1_1.readBoolean();
            this._condionOper = var1_1.readByte();
            this._condition = var1_1.readShort();
            var3_4 = var1_1.readShort();
            if (this._commands == null) {
                this._commands = new LittleVector(var3_4, 10);
            }
            if (this._mems == null) {
                this._mems = new LittleHashtable(40);
            }
            var4_6 = -1;
            if (true) ** GOTO lbl27
        }
        catch (Exception var2_3) {
            var2_3.printStackTrace();
            var3_5 = false;
            return var3_5;
        }
        do {
            var4_6 = var1_1.readByte();
            var5_7 = this.pickupCommand(var4_6, (DataInputStream)var1_1);
            this._commands.addElement(var5_7);
lbl27:
            // 2 sources

        } while (var1_1.available() > 0);
        try {
            var1_1.close();
            return true;
        }
        catch (Exception var8_8) {
            var8_8.printStackTrace();
        }
        return true;
    }

    protected ScenarioBasic pickupCommand(int n, DataInputStream dataInputStream) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        ScenarioBasic scenarioBasic = null;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 1: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 2: {
                stringBuffer.append(dataInputStream.readByte());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 3: {
                stringBuffer.append(dataInputStream.readByte());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 4: {
                scenarioBasic = new ScenarioCommand(n, "");
                break;
            }
            case 5: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 6: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 7: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readByte());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 8: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 9: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 10: {
                stringBuffer.append(dataInputStream.readByte());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 11: {
                stringBuffer.append(dataInputStream.readByte());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 12: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 13: {
                byte by;
                ScenarioBasic scenarioBasic2;
                scenarioBasic = new ScenarioSyncblock(n, "");
                ScenarioSyncblock scenarioSyncblock = (ScenarioSyncblock)scenarioBasic;
                while ((scenarioBasic2 = this.pickupCommand(by = dataInputStream.readByte(), dataInputStream)) != null) {
                    scenarioSyncblock.addCommand(scenarioBasic2);
                }
                scenarioSyncblock.init();
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                byte by;
                ScenarioBasic scenarioBasic3;
                stringBuffer.append(this.readStr(dataInputStream));
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readByte());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioIfblock(n, stringBuffer.toString());
                ScenarioIfblock scenarioIfblock = (ScenarioIfblock)scenarioBasic;
                while ((scenarioBasic3 = this.pickupCommand(by = dataInputStream.readByte(), dataInputStream)) != null) {
                    scenarioIfblock.addCommand(scenarioBasic3);
                }
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                stringBuffer.append(dataInputStream.readByte());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 18: {
                stringBuffer.append(dataInputStream.readByte());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 19: {
                scenarioBasic = new ScenarioCommand(n, "");
                break;
            }
            case 20: {
                stringBuffer.append(dataInputStream.readByte());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 21: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 22: {
                stringBuffer.append(dataInputStream.readByte());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 23: {
                stringBuffer.append(dataInputStream.readByte());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 24: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 25: {
                stringBuffer.append(dataInputStream.readShort());
                stringBuffer.append("/#");
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCall(n, stringBuffer.toString());
                break;
            }
            case 26: {
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 27: {
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 28: {
                stringBuffer.append(this.readStr(dataInputStream));
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
                break;
            }
            case 29: {
                stringBuffer.append(this.readStr(dataInputStream));
                stringBuffer.append("/#");
                stringBuffer.append(dataInputStream.readShort());
                scenarioBasic = new ScenarioCommand(n, stringBuffer.toString());
            }
        }
        if (_ondebug) {
            System.out.println(stringBuffer.toString());
        }
        return scenarioBasic;
    }

    public boolean exec() {
        int n;
        block4: {
            n = this._commands.size();
            ScenarioBasic scenarioBasic = null;
            int n2 = 0;
            try {
                n2 = this._item;
                while (n2 < n) {
                    scenarioBasic = (ScenarioBasic)this._commands.elementAt(n2);
                    if (scenarioBasic.exec(this._executor, this._mems)) {
                        ++n2;
                        ++this._item;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                if (!_ondebug) break block4;
                System.out.println("Run Error: type = " + scenarioBasic.getType() + " idx = " + n2);
                exception.printStackTrace();
            }
        }
        return this._item >= n;
    }

    public boolean isScriptEnd() {
        int n = this._commands.size();
        ScenarioBasic scenarioBasic = null;
        int n2 = 0;
        try {
            n2 = this._itemScrpit;
            while (n2 < n) {
                scenarioBasic = (ScenarioBasic)this._commands.elementAt(n2);
                if (!scenarioBasic.isScriptEnd(this._executor) && n2 == n - 1) {
                    return true;
                }
                ++n2;
                ++this._itemScrpit;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._item >= n;
    }

    private String readStr(DataInputStream dataInputStream) {
        String string = null;
        try {
            if (this._isSimplifiedChinese) {
                string = dataInputStream.readUTF();
            } else {
                short s = dataInputStream.readShort();
                byte[] byArray = new byte[s];
                dataInputStream.read(byArray);
                char[] cArray = new char[s / 2];
                int n = 0;
                while (n < s / 2) {
                    cArray[n] = (char)R.reversedReadInt(byArray, n * 2, 2);
                    ++n;
                }
                byArray = null;
                string = new String(cArray);
                cArray = null;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }
}

