/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;

public class Match
extends GameInterface {
    static GameRole[] players = new GameRole[4];
    static int leftTeamNum = 0;
    static int RightTeamNum = 1;
    static GameEngine engine = GameEngine.engine;
    static int[][] areaData = new int[4][2];
    static final byte MATCH_READY = 0;
    static final byte MATCH_START = 1;
    static final byte MATCH_PLAY = 2;
    static final byte MATCH_END = 3;
    static final byte MATCH_STAT = 4;
    static final byte TEAM_MAX = 2;
    static int curRoleIndex;
    static byte matchState;
    static byte startTeam;
    static byte curOwner;
    static byte lastOwner;
    static byte lNear;
    static byte rNear;
    static short[][] basket;
    static final short[] defLine;
    static short[][] left_throwPoint;
    static short[][] right_throwPoint;
    static byte[][] teams;
    static String[] teamName;
    boolean autoRun;
    short[][] heartData = new short[][]{{320, 110}, {390, 110}};
    public static final byte TO_BALL = 0;
    public static final byte TO_POINT = 1;
    public static final byte TO_HELP_ATT = 2;
    public static final byte TO_ATTACK = 3;
    public static final byte TO_WAIT = 4;
    public static final byte TO_SHOOT = 5;
    public static final byte TO_DEFEND = 6;
    public static final byte TO_READY = 7;
    public static final byte TO_START = 8;
    public static final byte TO_ATT_NEAR = 9;
    public static final byte TO_GIRL = 10;
    public static final byte OT_NULL = 0;
    public static final byte OT_TEAM_EMY = 1;
    public static final byte OT_TEAM_SELF = 2;
    public static final byte OT_ENEMY = 3;
    public static final byte OT_SELF = 4;
    static byte[] rdmArray;
    static int matchTime;
    byte skillLeftNum = (byte)3;
    byte skillRightNum = (byte)3;
    static int scoreLeft;
    static int scoreRight;
    static int twoPointLeft;
    static int twoPointRight;
    static int twoPointInLeft;
    static int twoPointInRight;
    static int threePointLeft;
    static int threePointRight;
    static int threePointInLeft;
    static int threePointInRight;
    static int doubleLeft;
    static int doubleRight;
    static int attackLeft;
    static int attackRight;
    static int skillLeft;
    static int skillRight;
    boolean isEnd;
    public static short[][] starPos;
    public static byte[] starSpeed;
    public static final int STARNUM = 20;
    public static int speedOfScroll;
    int mapYPix = 320;
    int topScrollPos = 0;
    int gas;
    byte gasSpeed = (byte)4;

    public Match(GameEngine ge) {
        engine = ge;
        int i = 0;
        while (i < 4) {
            Match.players[i] = new GameRole(engine, 0, "kbz" + i, 50, 10, 25, 4, 10, 10, i, i, i, i, 0, 0, 30);
            Match.players[i].teamID = (byte)2;
            ++i;
        }
    }

    public void setTeamNum(int left, int right) {
        leftTeamNum = left;
        RightTeamNum = right;
    }

    public void init(int leftTeam, int rightTeam, boolean isTwo) {
        int i;
        int i2;
        this.gas = 0;
        this.isEnd = false;
        this.index = 0;
        matchTime = 2400;
        if (MyGameCanvas.chargeData[0] != 1) {
            matchTime = 1200;
        }
        Match.loadTeam();
        byte[] matchRole = null;
        if (isTwo) {
            matchRole = new byte[2];
            i2 = 0;
            while (i2 < 2) {
                matchRole[i2] = teams[rightTeam][i2];
                ++i2;
            }
        } else {
            matchRole = new byte[4];
            i2 = 0;
            while (i2 < 2) {
                matchRole[i2] = teams[leftTeam][i2];
                ++i2;
            }
            i = 2;
            while (i < 4) {
                matchRole[i] = teams[rightTeam][i - 2];
                ++i;
            }
        }
        Match.loadProp(matchRole, isTwo);
        i2 = 0;
        while (i2 < 2) {
            Match.players[i2].teamID = (byte)2;
            Match.players[i2].roleNo = i2;
            System.out.println("players[i===" + i2 + "].speedX====" + Match.players[i2].speedX);
            Match.players[i2].defendNo = i2 + 2;
            Match.players[i2].curStatus = (byte)19;
            Match.players[i2].nextStatus = (byte)19;
            Match.players[i2].index = 0;
            players[i2].setStatus((byte)19);
            Match.players[i2].isAuto = false;
            ++i2;
        }
        i = 2;
        while (i < 4) {
            Match.players[i].teamID = 0;
            Match.players[i].roleNo = i;
            Match.players[i].defendNo = i - 2;
            Match.players[i].curStatus = (byte)19;
            Match.players[i].nextStatus = (byte)19;
            Match.players[i].index = 0;
            players[i].setStatus((byte)19);
            Match.players[i].isAuto = false;
            ++i;
        }
        Match.players[0].isHasBall = true;
        Match.players[1].isHasBall = false;
        Match.players[2].isHasBall = false;
        Match.players[3].isHasBall = false;
        Match.engine.ball.isShow = false;
        Match.engine.ball.setStatus((byte)4);
        curOwner = (byte)-1;
        curRoleIndex = 0;
        startTeam = (byte)2;
        this.setStatus((byte)0);
        Match.initStar();
        try {
            Tools.imgs[105] = Tools.ChangeImage((byte)76, (byte)leftTeamNum);
            Tools.imgs[107] = Tools.ChangeImage((byte)76, (byte)RightTeamNum);
        }
        catch (Exception e) {
            // empty catch block
        }
        scoreLeft = 0;
        scoreRight = 0;
        twoPointLeft = 0;
        twoPointRight = 0;
        twoPointInLeft = 0;
        twoPointInRight = 0;
        threePointLeft = 0;
        threePointRight = 0;
        threePointInLeft = 0;
        threePointInRight = 0;
        doubleLeft = 0;
        doubleRight = 0;
        attackLeft = 0;
        attackRight = 0;
        skillLeft = 0;
        skillRight = 0;
    }

    public void initRound(int teamID) {
        startTeam = (byte)(teamID == 2 ? 0 : 2);
        this.setStatus((byte)0);
        int i = 0;
        while (i < players.length) {
            this.play(players[i]);
            ++i;
        }
    }

    public static void matchTime() {
    }

    public static void matchScore() {
    }

    public void play(GameRole role) {
        if (role.isAuto) {
            return;
        }
        block0 : switch (matchState) {
            case 0: {
                if (role.orders[0] == 8) break;
                this.order(role, 7);
                break;
            }
            case 2: {
                byte ownTeam = Match.sortOwner(role);
                switch (ownTeam) {
                    case 0: {
                        this.order(role, 0);
                        break block0;
                    }
                    case 2: {
                        this.order(role, 2);
                        break block0;
                    }
                    case 1: {
                        this.order(role, 6);
                        break block0;
                    }
                    case 3: {
                        this.order(role, 3);
                        break block0;
                    }
                    case 4: {
                        this.order(role, 1);
                    }
                }
            }
        }
    }

    public static boolean isSuccess(int rate) {
        if (rate > 99) {
            rate = 99;
        }
        if (rate < 1) {
            rate = 0;
        }
        return (GameEngine.rnd.nextInt() >>> 1) % 100 < rate;
    }

    public boolean checkRange(int xPos, int teamID) {
        int off = Math.abs(xPos - basket[teamID == 2 ? 1 : 0][0]);
        if (off < 190) {
            return Match.isSuccess(10);
        }
        return Match.isSuccess(1);
    }

    public boolean isReady() {
        int i = 0;
        while (i < players.length) {
            if (Match.players[i].orders[0] != 8) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void run() {
        lastOwner = curOwner;
        curOwner = (byte)-1;
        int i = 0;
        while (i < players.length) {
            if ((matchState != 3 && matchState != 4 || Match.players[i].index <= 1) && Match.players[i].isHasBall) {
                curOwner = (byte)i;
            }
            ++i;
        }
        if (!Tools.isDraw(Match.players[Match.curRoleIndex].x - 10, Match.players[Match.curRoleIndex].y, Match.players[Match.curRoleIndex].w + 20, Match.players[Match.curRoleIndex].h, 36) && !Match.players[Match.curRoleIndex].isHasBall) {
            if (curRoleIndex == 0 && Tools.isDraw(Match.players[1].x, Match.players[1].y, Match.players[1].w, Match.players[1].h, 36)) {
                curRoleIndex = 1;
            } else if (curRoleIndex == 1 && Tools.isDraw(Match.players[0].x, Match.players[0].y, Match.players[0].w, Match.players[0].h, 36)) {
                curRoleIndex = 0;
            }
        }
        if (this.isReady() && matchState == 0) {
            this.setStatus((byte)1);
        }
        int i2 = 0;
        while (i2 < players.length) {
            if (curOwner != lastOwner) {
                int j = 0;
                while (j < rdmArray.length) {
                    Match.rdmArray[j] = -1;
                    ++j;
                }
                if (i2 < 2) {
                    this.play(players[i2]);
                } else if (!Match.engine.isGirlShow) {
                    this.play(players[i2]);
                }
            }
            if (!(this.isSkill() != -1 || curRoleIndex == i2 && matchState != 0 || Match.players[i2].curStatus != 19 && Match.players[i2].curStatus != 20)) {
                switch (Match.players[i2].orders[0]) {
                    case 0: {
                        this.runToBall(players[i2]);
                        break;
                    }
                    case 1: {
                        this.toRun(players[i2], Match.players[i2].orders[1], Match.players[i2].orders[2]);
                        break;
                    }
                    case 2: {
                        this.helpAtt(players[i2]);
                        break;
                    }
                    case 3: {
                        Match.attack(players[i2], players[Match.players[i2].defendNo]);
                        break;
                    }
                    case 4: {
                        this.waitToRun(players[i2]);
                        break;
                    }
                    case 5: {
                        this.shoot(players[i2]);
                        break;
                    }
                    case 6: {
                        this.defend(players[i2]);
                        break;
                    }
                    case 7: {
                        this.ready(players[i2]);
                        break;
                    }
                    case 8: {
                        this.waitToStart(players[i2]);
                        break;
                    }
                    case 9: {
                        this.attNear(players[i2]);
                        break;
                    }
                    case 10: {
                        this.callToPoint(players[i2], this.heartData[i2 % 2][0], this.heartData[i2 % 2][1]);
                    }
                }
            }
            if (Match.players[i2].roleNo == this.isSkill() || this.isSkill() == -1) {
                players[i2].move();
            }
            ++i2;
        }
    }

    public void order(GameRole role, int orderType) {
        short toX = 0;
        short toY = 0;
        switch (orderType) {
            case 0: {
                role.orders[0] = (short)orderType;
                break;
            }
            case 1: {
                byte temp = Match.getRdmNum(role.roleNo, left_throwPoint.length);
                switch (role.teamID) {
                    case 2: {
                        toX = right_throwPoint[temp][0];
                        toY = right_throwPoint[temp][1];
                        break;
                    }
                    case 0: {
                        toX = left_throwPoint[temp][0];
                        toY = left_throwPoint[temp][1];
                    }
                }
                role.orders[0] = (short)orderType;
                role.orders[1] = toX;
                role.orders[2] = toY;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: {
                role.orders[0] = (short)orderType;
                break;
            }
            case 4: {
                role.orders[0] = (short)orderType;
                role.orders[1] = role.response;
                break;
            }
            case 5: {
                role.orders[0] = (short)orderType;
                break;
            }
            case 7: 
            case 8: {
                role.orders[0] = (short)orderType;
                break;
            }
            case 10: {
                role.orders[0] = (short)orderType;
            }
        }
    }

    public void ready(GameRole role) {
        int startIndex;
        int n = startIndex = startTeam == 2 ? 0 : 4;
        if ((role.roleNo == 0 && startTeam == 2 || role.roleNo == 2 && startTeam == 0) && !role.isHasBall) {
            this.runToBall(role);
        } else {
            this.toWaitReady(role, GameInterface.startPos[role.roleNo + startIndex][0], GameInterface.startPos[role.roleNo + startIndex][1]);
        }
    }

    public void toWaitReady(GameRole role, int x, int y) {
        if (Tools.hit(role.x, role.y, role.w, role.bh, x, y, role.w, role.bh)) {
            role.setStatus((byte)19);
            Match.players[role.roleNo].isLeft = role.roleNo == 0 && startTeam == 2 ? false : (role.roleNo == 2 && startTeam == 0 ? true : startTeam == 2);
            this.order(role, 8);
        } else {
            Match.runToPoint(role, x, y, role.w, role.bh);
        }
    }

    public void waitToStart(GameRole role) {
        if (role.isHasBall) {
            role.ctrl(49);
        }
    }

    public void shoot(GameRole role) {
        if (role.curStatus == 19) {
            role.ctrl(53);
        }
    }

    public void waitToRun(GameRole role) {
        if (role.curStatus != 19) {
            role.setStatus((byte)19);
        }
        if ((role.orders[1] = (short)(role.orders[1] - 1)) <= 0) {
            this.play(role);
        }
    }

    public static void attack(GameRole role, GameRole enemy) {
        int rx = role.x + role.w / 2;
        int ry = role.y - role.bh / 2;
        int ex = enemy.x + enemy.w / 2;
        int ey = enemy.y - enemy.bh / 2;
        if (Math.abs(rx - ex) < 40 && Math.abs(ry - ey) < role.bh) {
            if (rx < ex) {
                role.setDir((byte)3);
            } else {
                role.setDir((byte)2);
            }
            if (role.curStatus != 19) {
                role.setStatus((byte)19);
            } else {
                role.ctrl(53);
            }
        } else {
            int len = Math.min(Math.abs(rx - ex), 35);
            int tempx = enemy.x + (ex < rx ? len : -len);
            if (tempx < 26) {
                tempx = enemy.x + len;
            } else if (tempx > 400) {
                tempx = enemy.x - len;
            }
            Match.runToPoint(role, tempx, enemy.y, enemy.w, enemy.bh);
        }
    }

    public void attNear(GameRole role) {
        int aRole = -1;
        int temp = 2000;
        int i = 0;
        while (i < players.length) {
            int len;
            if (!(role.teamID != 2 ? i >= 2 : i < 2) && (len = Math.abs(Match.players[i].x - role.x) + Math.abs(Match.players[i].y - role.y)) < temp) {
                temp = len;
                aRole = i;
            }
            ++i;
        }
        Match.attack(role, players[aRole]);
    }

    public boolean onLine(GameRole role, int lineID) {
        switch (lineID) {
            case 1: {
                return role.x >= defLine[1];
            }
            case 0: {
                return role.x <= defLine[0];
            }
        }
        return false;
    }

    public int getAttRole(GameRole role, int lineID) {
        byte[] attRole = new byte[2];
        int maxIndex = 0;
        int i = 0;
        while (i < players.length) {
            if (!(role.teamID != 2 ? i >= 2 : i < 2)) {
                if (Match.players[i].injureTime <= 0 && this.onLine(players[i], lineID)) {
                    int n = maxIndex;
                    maxIndex = (byte)(maxIndex + 1);
                    attRole[n] = (byte)i;
                }
            }
            ++i;
        }
        int aRole = -1;
        if (maxIndex > 0) {
            int temp = 2000;
            int i2 = 0;
            while (i2 < maxIndex) {
                int len = Math.abs(Match.players[attRole[i2]].x - role.x) + Math.abs(Match.players[attRole[i2]].y - role.y);
                if (len < temp) {
                    temp = len;
                    aRole = attRole[i2];
                }
                ++i2;
            }
        }
        return aRole;
    }

    public void helpAtt(GameRole role) {
        int lineID;
        int n = lineID = role.teamID == 2 ? 1 : 0;
        if (this.onLine(role, lineID)) {
            byte aRole = (byte)this.getAttRole(role, lineID);
            if (aRole == -1) {
                role.setStatus((byte)19);
            } else {
                Match.attack(role, players[aRole]);
            }
        } else {
            Match.runToPoint(role, defLine[lineID], role.y, role.w, role.bh);
        }
    }

    public void defend(GameRole role) {
        int lineID;
        int n = lineID = role.teamID == 2 ? 0 : 1;
        if (this.onLine(role, lineID)) {
            byte aRole = (byte)this.getAttRole(role, lineID);
            if (aRole == -1) {
                role.setStatus((byte)19);
            } else {
                Match.attack(role, players[aRole]);
            }
        } else {
            Match.runToPoint(role, defLine[lineID], role.y, role.w, role.bh);
        }
    }

    public void toRun(GameRole role, int x, int y) {
        if (Tools.hit(role.x, role.y, role.w, role.bh, x, y, role.w, role.bh)) {
            role.setStatus((byte)19);
            if (role.isHasBall) {
                this.order(role, 5);
            } else {
                this.order(role, 4);
            }
        } else {
            Match.runToPoint(role, x, y, role.w, role.bh);
        }
    }

    public void callToPoint(GameRole role, int x, int y) {
        role.injureTime = (byte)100;
        if (role.isHasBall) {
            role.isHasBall = false;
            Match.engine.ball.x = role.x;
            Match.engine.ball.y = role.y;
            Match.engine.ball.shadowY = role.y;
            Match.engine.ball.speedX = Math.abs(GameEngine.rnd.nextInt()) % 10 - 5;
            Match.engine.ball.shadowSpeedY = Match.engine.ball.speedY = Math.abs(GameEngine.rnd.nextInt()) % 8 - 4;
            Match.engine.ball.isShow = true;
            Match.engine.ball.setStatus((byte)5);
        }
        if (Tools.hit(role.x, role.y, role.w, role.bh, x, y, role.w, role.bh)) {
            role.setStatus((byte)-4);
            this.play(role);
        } else {
            Match.runToPoint(role, x, y, role.w, role.bh);
        }
    }

    public byte getDanger(GameRole role) {
        int start;
        int i = start = role.teamID == 2 ? 2 : 0;
        while (i < start + 2) {
            if (Match.players[i].injureTime <= 0 && Tools.hit(Match.players[i].x, Match.players[i].y, Match.players[i].w, Match.players[i].bh, Match.engine.ball.x - 20, Match.engine.ball.shadowY + 10, Match.engine.ball.w + 40, Match.engine.ball.bh + 20)) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    public void runToBall(GameRole role) {
        byte danger = this.getDanger(role);
        if (danger == -1) {
            if (Tools.hit(role.x, role.y, role.w, role.bh, Match.engine.ball.x - 5, Match.engine.ball.shadowY + 3, Match.engine.ball.w + 10, Match.engine.ball.bh + 6) && role.z == 0 && Match.engine.ball.shadowY - Match.engine.ball.y > 30 && Match.engine.ball.shadowY - Match.engine.ball.y < 50) {
                role.setStatus((byte)24);
            } else if (Tools.hit(role.x, role.y, role.w, role.bh, Match.engine.ball.x, Match.engine.ball.shadowY, Match.engine.ball.w, Match.engine.ball.bh)) {
                role.setStatus((byte)19);
                this.play(role);
            } else {
                Match.runToPoint(role, Match.engine.ball.x, Match.engine.ball.shadowY, Match.engine.ball.w, Match.engine.ball.bh);
            }
        } else {
            Match.attack(role, players[danger]);
        }
    }

    public static void runToPoint(GameRole role, int x, int y, int w, int h) {
        int rx = role.x + role.w / 2;
        int ry = role.y - role.bh / 2;
        int px = x + w / 2;
        int py = y - h / 2;
        if (role.curStatus != 20) {
            role.setStatus((byte)20);
        }
        if (Math.abs(rx - px) > Math.abs(ry - py)) {
            if (rx < px) {
                role.setDir((byte)3);
            } else {
                role.setDir((byte)2);
            }
        } else if (ry < py) {
            role.setDir((byte)1);
        } else {
            role.setDir((byte)0);
        }
    }

    public static byte sortOwner(GameRole role) {
        int i = 0;
        while (i < players.length) {
            if (Match.players[i].isHasBall) {
                if (Match.players[i].roleNo == role.defendNo) {
                    return 3;
                }
                if (Match.players[i].roleNo == role.roleNo) {
                    return 4;
                }
                if (Match.players[i].teamID == role.teamID) {
                    return 2;
                }
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static byte getRdmNum(int index, int maxNum) {
        int temp;
        while (Match.isSameNum(temp = (GameEngine.rnd.nextInt() >>> 1) % maxNum)) {
        }
        Match.rdmArray[index] = (byte)temp;
        return (byte)temp;
    }

    private static boolean isSameNum(int num) {
        int i = 0;
        while (i < rdmArray.length) {
            if (rdmArray[i] == num) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addScore(int teamid, int score, int index) {
        if (teamid == 2) {
            scoreLeft += score;
            if (index < 10) {
                if (score == 2) {
                    ++twoPointInLeft;
                } else {
                    ++threePointInLeft;
                }
            }
        } else {
            scoreRight += score;
            if (index < 10) {
                if (score == 2) {
                    ++twoPointInRight;
                } else {
                    ++threePointInRight;
                }
            }
        }
    }

    public static void drawMatchScore(int x, int y, int score) {
        Tools.addObject(84, x, y, 20, (byte)0, 500);
        Match.drawNumber((byte)60, score, score < 10 ? x + 18 : x + 14, y + 4, 7, 17, 600);
    }

    public static void drawMatchTime(int x, int y, int matchTime) {
        Tools.addObject(97, x, y, 17, (byte)0, 500);
        Match.drawNumber((byte)59, matchTime / 10 / 60, (x -= 20) + 9, y += 3, 6, 20, 600);
        Match.drawNumber((byte)59, -99999, x + 16, y - 1, 6, 20, 600);
        if (matchTime / 10 % 60 == 0) {
            Match.drawNumber((byte)59, 0, x + 20, y, 6, 20, 600);
            Match.drawNumber((byte)59, 0, x + 28, y, 6, 20, 600);
        } else if (matchTime / 10 % 60 < 10) {
            Match.drawNumber((byte)59, 0, x + 20, y, 6, 20, 600);
            Match.drawNumber((byte)59, matchTime / 10 % 60, x + 28, y, 6, 20, 600);
        } else {
            Match.drawNumber((byte)59, matchTime / 10 % 60, x + 20, y, 6, 20, 600);
        }
    }

    public static void drawNumber(byte img, int number, int x, int y, int numWidth, int athor, int layer) {
        int numHeight = 9;
        if (number == -99999) {
            Tools.addObject(img, x, y, numWidth * 10, 0, numWidth, numHeight, athor, (byte)0, layer);
            return;
        }
        int spacing = 7;
        int digitCounter = 0;
        int[] digits = new int[10];
        do {
            digits[digitCounter] = number % 10;
            ++digitCounter;
        } while ((number /= 10) > 0);
        int i = 0;
        while (i < digitCounter) {
            Tools.addObject(img, x + i * spacing, y, digits[digitCounter - 1 - i] * numWidth, 0, numWidth, numHeight, athor, (byte)0, layer);
            ++i;
        }
    }

    public int isSkill() {
        int i = 0;
        while (i < players.length) {
            if (Match.players[i].curStatus > 29) {
                if (Match.players[i].curStatus == 30 && Match.players[i].index > 6 || Match.players[i].curStatus == 41 && Match.players[i].index > 6) {
                    return -1;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void moveMatch() {
        this.run();
        if (matchState == 3 || matchState == 4) {
            return;
        }
        this.moveGas();
        Match.engine.ball.move();
        this.check();
        if (curOwner == -1) {
            if (Match.engine.ball.curStatus == 2) {
                Match.engine.map.AdjustSrceen(Match.engine.ball.x, Match.engine.ball.shadowY);
            } else {
                Match.engine.map.AdjustSrceen(Match.engine.ball.x, Match.engine.ball.y);
            }
        } else {
            Match.engine.map.AdjustSrceen(Match.players[Match.curOwner].x, Match.players[Match.curOwner].sy);
        }
        engine.moveGirlPicture();
        engine.checkPlayerAttack();
        engine.moveItem();
    }

    public void drawMatch(Graphics g) {
        switch (matchState) {
            case 3: {
                GameMap cfr_ignored_0 = Match.engine.map;
                GameMap cfr_ignored_1 = Match.engine.map;
                Match.drawMatchTime(GameMap.setOffX + 120, GameMap.setOffY + 2, matchTime);
                GameMap cfr_ignored_2 = Match.engine.map;
                GameMap cfr_ignored_3 = Match.engine.map;
                Match.drawMatchScore(GameMap.setOffX + 120 - 63, GameMap.setOffY + 2, scoreLeft);
                GameMap cfr_ignored_4 = Match.engine.map;
                GameMap cfr_ignored_5 = Match.engine.map;
                Match.drawMatchScore(GameMap.setOffX + 120 + 28, GameMap.setOffY + 2, scoreRight);
                Match.engine.map.setMap();
                if (++this.index != 50) break;
                this.setStatus((byte)4);
                GameEngine.hitEffectV.removeAllElements();
                break;
            }
            case 4: {
                GameMap cfr_ignored_6 = Match.engine.map;
                GameMap cfr_ignored_7 = Match.engine.map;
                this.drawStat(GameMap.setOffX + 20, GameMap.setOffY + 50, "\u5df1\u961f", "\u654c\u961f");
                ++this.index;
                if (GameEngine.gameRank != 0 || this.index <= 100) break;
                if (scoreLeft > scoreRight) {
                    Match.engine.canvas.toTalkStatus(24);
                    MyGameCanvas cfr_ignored_8 = Match.engine.canvas;
                    MyGameCanvas cfr_ignored_9 = Match.engine.canvas;
                    MyGameCanvas.setST((byte)10);
                    break;
                }
                Match.engine.canvas.toTalkStatus(23);
                MyGameCanvas cfr_ignored_10 = Match.engine.canvas;
                MyGameCanvas cfr_ignored_11 = Match.engine.canvas;
                MyGameCanvas.setST((byte)10);
                break;
            }
            default: {
                if (matchTime > 0) {
                    if (matchState != 0 && matchState != 1) {
                        --matchTime;
                    }
                    GameMap cfr_ignored_12 = Match.engine.map;
                    GameMap cfr_ignored_13 = Match.engine.map;
                    Match.drawMatchTime(GameMap.setOffX + 120, GameMap.setOffY + 2, matchTime);
                    GameMap cfr_ignored_14 = Match.engine.map;
                    GameMap cfr_ignored_15 = Match.engine.map;
                    Match.drawMatchScore(GameMap.setOffX + 120 - 63, GameMap.setOffY + 2, scoreLeft);
                    GameMap cfr_ignored_16 = Match.engine.map;
                    GameMap cfr_ignored_17 = Match.engine.map;
                    Match.drawMatchScore(GameMap.setOffX + 120 + 28, GameMap.setOffY + 2, scoreRight);
                    int i = 0;
                    while (i < players.length) {
                        players[i].paint();
                        ++i;
                    }
                    if (this.isSkill() == -1) {
                        Match.engine.map.setMap();
                    } else {
                        this.moveStar();
                        GameMap cfr_ignored_18 = Match.engine.map;
                        GameMap cfr_ignored_19 = Match.engine.map;
                        this.drawStar(g, GameMap.setOffX, GameMap.setOffY);
                        GameMap cfr_ignored_20 = Match.engine.map;
                        Match.engine.map.drawCarCase(-10, 103 + 83);
                    }
                    Match.engine.ball.paint();
                    int i2 = 0;
                    while (i2 < 3) {
                        Match.engine.balleff[i2].paint();
                        ++i2;
                    }
                    this.drawRoleTag();
                } else {
                    int i = 0;
                    while (i < players.length) {
                        Match.players[i].isAuto = true;
                        ++i;
                    }
                    if (Match.engine.ball.curStatus == 19 || !Match.engine.ball.isShow) {
                        this.setStatus((byte)3);
                        if (scoreLeft <= scoreRight) {
                            int i3 = 0;
                            while (i3 < players.length) {
                                if (Match.players[i3].teamID == 2) {
                                    players[i3].setStatus((byte)13);
                                } else {
                                    players[i3].setStatus((byte)14);
                                }
                                ++i3;
                            }
                        } else {
                            int i4 = 0;
                            while (i4 < players.length) {
                                if (Match.players[i4].roleNo < 2) {
                                    players[i4].setStatus((byte)14);
                                } else {
                                    players[i4].setStatus((byte)13);
                                }
                                ++i4;
                            }
                        }
                    } else {
                        if (matchState != 0 && matchState != 1) {
                            --matchTime;
                        }
                        GameMap cfr_ignored_21 = Match.engine.map;
                        GameMap cfr_ignored_22 = Match.engine.map;
                        Match.drawMatchTime(GameMap.setOffX + 120, GameMap.setOffY + 2, matchTime);
                        GameMap cfr_ignored_23 = Match.engine.map;
                        GameMap cfr_ignored_24 = Match.engine.map;
                        Match.drawMatchScore(GameMap.setOffX + 120 - 63, GameMap.setOffY + 2, scoreLeft);
                        GameMap cfr_ignored_25 = Match.engine.map;
                        GameMap cfr_ignored_26 = Match.engine.map;
                        Match.drawMatchScore(GameMap.setOffX + 120 + 28, GameMap.setOffY + 2, scoreRight);
                        int i5 = 0;
                        while (i5 < players.length) {
                            players[i5].paint();
                            ++i5;
                        }
                        if (this.isSkill() == -1) {
                            Match.engine.map.setMap();
                        } else {
                            this.moveStar();
                            GameMap cfr_ignored_27 = Match.engine.map;
                            GameMap cfr_ignored_28 = Match.engine.map;
                            this.drawStar(g, GameMap.setOffX, GameMap.setOffY);
                            GameMap cfr_ignored_29 = Match.engine.map;
                            Match.engine.map.drawCarCase(-10, 103 + 83);
                        }
                        Match.engine.ball.paint();
                        int i6 = 0;
                        while (i6 < 3) {
                            Match.engine.balleff[i6].paint();
                            ++i6;
                        }
                        this.drawRoleTag();
                    }
                }
                GameMap cfr_ignored_30 = Match.engine.map;
                GameMap cfr_ignored_31 = Match.engine.map;
                this.drawGas(GameMap.setOffX, GameMap.setOffY + 320);
                GameMap cfr_ignored_32 = Match.engine.map;
                GameMap cfr_ignored_33 = Match.engine.map;
                this.drawSingleItem(GameMap.setOffX + 240 - 27, GameMap.setOffY + 320 - 27, Match.engine.canvas.itemIndex);
                engine.drawItem(g);
                engine.drawSuperMan();
            }
        }
    }

    public void drawMatchRoleInterface(int x, int y, int skillNum) {
        byte[][] clip = new byte[][]{{0, 0, 43, 19}, {0, 19, 8, 7}, {9, 20, 37, 5}};
        Tools.addObject(43, x, y, clip[0], 36, (byte)0, 900);
        int i = 1;
        while (i <= skillNum) {
            Tools.addObject(43, x + 4 + (i - 1) * 9, y - 2, clip[1], 36, (byte)0, 900);
            ++i;
        }
    }

    public static void addDouble(int teamID) {
        if (teamID == 2) {
            ++doubleLeft;
        } else {
            ++doubleRight;
        }
    }

    public static void addPoint(int teamID, int score) {
        if (teamID == 2) {
            if (score == 2) {
                ++twoPointLeft;
            } else {
                ++threePointLeft;
            }
        } else if (score == 2) {
            ++twoPointRight;
        } else {
            ++threePointRight;
        }
    }

    public static void addSkillNo(int teamID) {
        if (teamID == 2) {
            ++skillLeft;
        } else {
            ++skillRight;
        }
    }

    public void drawStat(int x, int y, String str1, String str2) {
        String[] str = new String[]{"\u5f97    \u5206", "\u4e24\u5206\u7403", "\u4e09\u5206\u7403", "\u7bee    \u677f", "\u62a2    \u65ad", "\u5931    \u8bef"};
        GameMap cfr_ignored_0 = Match.engine.map;
        GameMap cfr_ignored_1 = Match.engine.map;
        Match.engine.canvas.drawBg(GameMap.setOffX, GameMap.setOffY, 800);
        Tools.addObject((byte)4, str1, x + 70, y + 45, 20, 0, 1001);
        Tools.addObject((byte)4, str2, x + 120, y + 45, 20, 0, 1001);
        int i = 0;
        while (i < str.length) {
            Tools.addObject(92, x + 10, y + 65 + 20 * i, 0, i * 12, 34, 12, 20, (byte)0, 1001);
            ++i;
        }
        int adj = 10;
        Match.drawNumber((byte)62, scoreLeft, x + 70 + adj, y + 65, 7, 17, 1001);
        Match.drawNumber((byte)62, scoreRight, x + 120 + adj, y + 65, 7, 17, 1001);
        int adj2 = 0;
        Match.drawNumber((byte)62, twoPointInLeft, x + 70 + adj2, y + 85, 7, 17, 1001);
        Match.drawNumber((byte)62, -99999, x + 80 + adj2, y + 85, 7, 17, 1001);
        Match.drawNumber((byte)62, twoPointLeft, x + 90 + adj2, y + 85, 7, 17, 1001);
        Match.drawNumber((byte)62, twoPointInRight, x + 120 + adj2, y + 85, 7, 17, 1001);
        Match.drawNumber((byte)62, -99999, x + 130 + adj2, y + 85, 7, 17, 1001);
        Match.drawNumber((byte)62, twoPointRight, x + 140 + adj2, y + 85, 7, 17, 1001);
        Match.drawNumber((byte)62, threePointInLeft, x + 70 + adj2, y + 105, 7, 17, 1001);
        Match.drawNumber((byte)62, -99999, x + 80 + adj2, y + 105, 7, 17, 1001);
        Match.drawNumber((byte)62, threePointLeft, x + 90 + adj2, y + 105, 7, 17, 1001);
        Match.drawNumber((byte)62, threePointInRight, x + 120 + adj2, y + 105, 7, 17, 1001);
        Match.drawNumber((byte)62, -99999, x + 130 + adj2, y + 105, 7, 17, 1001);
        Match.drawNumber((byte)62, threePointRight, x + 140 + adj2, y + 105, 7, 17, 1001);
        Match.drawNumber((byte)62, doubleLeft, x + 70 + adj, y + 125, 7, 17, 1001);
        Match.drawNumber((byte)62, doubleRight, x + 120 + adj, y + 125, 7, 17, 1001);
        Match.drawNumber((byte)62, skillLeft, x + 70 + adj, y + 145, 7, 17, 1001);
        Match.drawNumber((byte)62, skillRight, x + 120 + adj, y + 145, 7, 17, 1001);
        Match.drawNumber((byte)62, attackLeft, x + 70 + adj, y + 165, 7, 17, 1001);
        Match.drawNumber((byte)62, attackRight, x + 120 + adj, y + 165, 7, 17, 1001);
    }

    public static void loadTeam() {
        try {
            DataInputStream dis = new DataInputStream("".getClass().getResourceAsStream("/team.dat"));
            int len = dis.readShort();
            teams = new byte[len][3];
            teamName = new String[len];
            int i = 0;
            while (i < len) {
                byte teamID = dis.readByte();
                short nameLen = dis.readShort();
                byte[] nameBuff = new byte[nameLen];
                dis.read(nameBuff);
                Match.teamName[i] = new String(nameBuff, "UTF-8");
                int j = 0;
                while (j < 3) {
                    Match.teams[i][j] = dis.readByte();
                    ++j;
                }
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {}
    }

    public static void loadProp(byte[] matchRole, boolean isTwo) {
        try {
            DataInputStream dis = new DataInputStream("".getClass().getResourceAsStream("/property.dat"));
            int len = dis.readShort();
            int pIndex = isTwo ? 2 : 0;
            int i = 0;
            while (i < len) {
                short id = dis.readShort();
                short nameLen = dis.readShort();
                byte[] nameBuff = new byte[nameLen];
                dis.read(nameBuff);
                String name = new String(nameBuff, "UTF-8");
                byte twoPoint = dis.readByte();
                byte upPoint = dis.readByte();
                byte strength = dis.readByte();
                byte speed = dis.readByte();
                byte response = dis.readByte();
                byte force = dis.readByte();
                byte hair = dis.readByte();
                byte brow = dis.readByte();
                byte eye = dis.readByte();
                byte mouth = dis.readByte();
                byte skill1 = dis.readByte();
                byte skill2 = dis.readByte();
                byte threePoint = dis.readByte();
                byte temp = Match.isInclude((byte)i, matchRole);
                if (temp != -1) {
                    Match.players[temp + pIndex] = new GameRole(engine, id, name, twoPoint, upPoint, strength, speed, response, force, hair, brow, eye, mouth, skill1, skill2, threePoint);
                }
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {}
    }

    public static byte isInclude(byte num, byte[] array) {
        int i = 0;
        while (i < array.length) {
            if (num == array[i]) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    public void ctrl(int keyCode) {
        players[curRoleIndex].ctrl(keyCode);
        if (matchTime > 0 || this.index < 5) {
            return;
        }
        switch (keyCode) {
            case -6: 
            case -5: {
                this.isEnd = true;
                if (GameEngine.gameRank != 0 || matchState != 4) break;
                if (scoreLeft > scoreRight) {
                    Match.engine.canvas.toTalkStatus(24);
                    MyGameCanvas cfr_ignored_0 = Match.engine.canvas;
                    MyGameCanvas cfr_ignored_1 = Match.engine.canvas;
                    MyGameCanvas.setST((byte)10);
                    break;
                }
                Match.engine.canvas.toTalkStatus(23);
                MyGameCanvas cfr_ignored_2 = Match.engine.canvas;
                MyGameCanvas cfr_ignored_3 = Match.engine.canvas;
                MyGameCanvas.setST((byte)10);
                break;
            }
        }
    }

    public boolean matchEnd() {
        return matchTime < 1 && this.isEnd;
    }

    public void ctrlRelease() {
        players[curRoleIndex].ctrlReleased();
    }

    public void move() {
    }

    public void paint() {
    }

    public void setDir(byte todir) {
    }

    public void setStatus(byte status) {
        matchState = status;
    }

    public void check() {
        this.checkItem();
        int i = 0;
        while (i < players.length) {
            if (!Match.engine.ball.isShow) break;
            if (!(matchState == 0 && (startTeam == 2 && i != 0 || startTeam == 0 && i != 2) || Match.players[i].isHasBall || Match.engine.ball.curStatus != 19 && Match.engine.ball.curStatus != 2 && Match.engine.ball.curStatus != 22 && Match.engine.ball.curStatus != 21 || Match.players[i].curStatus != 19 && Match.players[i].curStatus != 18 && Match.players[i].curStatus != 20 && Match.players[i].curStatus != 24 && Match.players[i].curStatus != 25 || !Tools.hit(Match.players[i].x - (Match.players[i].isLeft ? Match.players[i].rx : Match.players[i].lx), Match.players[i].y, Match.players[i].w + Match.players[i].rx + Match.players[i].lx, 30, Match.engine.ball.x, Match.engine.ball.y, 13, 13) || !Tools.hit(Match.players[i].sx, Match.players[i].sy + Match.players[i].z, Match.players[i].w + Match.players[i].rx + Match.players[i].lx, Match.players[i].bh, Match.engine.ball.x, Match.engine.ball.shadowY, Match.engine.ball.w, Match.engine.ball.bh))) {
                Match.players[i].isHasBall = true;
                Match.engine.ball.isShow = false;
                Match.engine.ball.setStatus((byte)4);
                if (Match.players[i].curStatus != 24 && Match.players[i].curStatus != 25 && Match.players[i].curStatus != 20) {
                    players[i].setStatus((byte)19);
                }
                if (i < 2) {
                    curRoleIndex = i;
                    players[curRoleIndex].setStatus((byte)19);
                }
                return;
            }
            ++i;
        }
    }

    public void checkItem() {
        int size = GameEngine.item.size();
        int i = size - 1;
        while (i >= 0) {
            int[] temp = (int[])GameEngine.item.elementAt(i);
            block0 : switch (temp[2]) {
                case 0: {
                    int j = 0;
                    while (j < players.length) {
                        if (temp[3] != Match.players[j].teamID && Tools.hit(temp[0], temp[1], 26, 4, Match.players[j].x, Match.players[j].y, Match.players[j].w, Match.players[j].bh)) {
                            this.initItemEff(2, Match.players[j].teamID, Match.players[j].isSlow, Match.players[j].isFast);
                            GameEngine.item.removeElementAt(i);
                            break block0;
                        }
                        ++j;
                    }
                    break;
                }
            }
            --i;
        }
    }

    public void initItemEff(int type, int teamID, boolean isSlow, boolean isFast) {
        switch (type) {
            case 1: {
                if (teamID == 2) {
                    Match.players[0].isSlow = false;
                    Match.players[1].isSlow = false;
                    Match.players[0].isFast = true;
                    Match.players[1].isFast = true;
                    Match.players[0].skillTime = 300;
                    Match.players[1].skillTime = 300;
                    return;
                }
                Match.players[2].isSlow = false;
                Match.players[3].isSlow = false;
                Match.players[2].isFast = true;
                Match.players[3].isFast = true;
                Match.players[2].skillTime = 200;
                Match.players[3].skillTime = 200;
                return;
            }
            case 2: {
                if (teamID == 2) {
                    Match.players[0].isFast = false;
                    Match.players[1].isFast = false;
                    Match.players[0].isSlow = true;
                    Match.players[1].isSlow = true;
                    Match.players[0].skillTime = 100;
                    Match.players[1].skillTime = 100;
                    break;
                }
                Match.players[3].isFast = false;
                Match.players[2].isFast = false;
                Match.players[3].isSlow = true;
                Match.players[2].isSlow = true;
                Match.players[3].skillTime = 100;
                Match.players[2].skillTime = 100;
            }
        }
    }

    public void drawRoleTag() {
        int i = 0;
        while (i < 2) {
            if (i == curRoleIndex) {
                Tools.addObject(79, Match.players[i].x - 9, Match.players[i].y + 7, 0, 0, 32, 16, 36, (byte)0, Match.players[i].y - 1);
            } else if (i == this.passNo(curRoleIndex)) {
                Tools.addObject(79, Match.players[i].x - 10, Match.players[i].y + 7, 32, 0, 32, 16, 36, (byte)0, Match.players[i].y - 1);
            }
            ++i;
        }
    }

    public int passNo(int roleIndex) {
        int passRoleNo = 0;
        switch (roleIndex) {
            case 0: {
                passRoleNo = 1;
                break;
            }
            case 1: {
                passRoleNo = 0;
                break;
            }
            case 2: {
                passRoleNo = 3;
                break;
            }
            case 3: {
                passRoleNo = 2;
            }
        }
        return passRoleNo;
    }

    public void initPos(int teamID) {
        int i = 0;
        while (i < 4) {
            Match.players[i].x = GameInterface.startPos[i + (teamID == 2 ? 0 : 4)][0];
            Match.players[i].y = GameInterface.startPos[i + (teamID == 2 ? 0 : 4)][1];
            Match.players[i].sx = GameInterface.startPos[i + (teamID == 2 ? 0 : 4)][0];
            Match.players[i].sy = GameInterface.startPos[i + (teamID == 2 ? 0 : 4)][1];
            Match.players[i].isLeft = i == 0 && teamID == 2 ? false : (i == 2 && teamID == 0 ? true : teamID == 2);
            players[i].setStatus((byte)19);
            ++i;
        }
    }

    public static void initStar() {
        starPos = new short[20][2];
        starSpeed = new byte[20];
        int i = 0;
        while (i < 20) {
            GameMap cfr_ignored_0 = Match.engine.map;
            Match.starPos[i][0] = (short)(Math.abs(GameEngine.rnd.nextInt()) % 240 + GameMap.setOffX);
            GameMap cfr_ignored_1 = Match.engine.map;
            Match.starPos[i][1] = (short)(Math.abs(GameEngine.rnd.nextInt()) % 320 + GameMap.setOffY);
            Match.starSpeed[i] = (byte)(Math.abs(GameEngine.rnd.nextInt()) % 3 + 1 + speedOfScroll);
            ++i;
        }
    }

    public void moveStar() {
        int i = 0;
        while (i < 20) {
            short[] sArray = starPos[i];
            sArray[0] = (short)(sArray[0] - (starSpeed[i] + speedOfScroll * 2));
            if (starPos[i][0] + starSpeed[i] < 0) {
                GameMap cfr_ignored_0 = Match.engine.map;
                Match.starPos[i][0] = (short)(240 + GameMap.setOffX);
                GameMap cfr_ignored_1 = Match.engine.map;
                Match.starPos[i][1] = (short)(Math.abs(GameEngine.rnd.nextInt()) % this.mapYPix + GameMap.setOffY);
                Match.starSpeed[i] = (byte)(Math.abs(GameEngine.rnd.nextInt()) % 3 + 1);
            }
            ++i;
        }
    }

    public void drawStar(Graphics g, int x, int y) {
        g.setColor(0, 0, 0);
        g.fillRect(x, y, 240, 320);
        int offsetY = this.topScrollPos >> 1;
        int i = 0;
        while (i < 20) {
            int len = starSpeed[i] - 1 + speedOfScroll;
            g.setColor(0, 128, 255);
            g.drawLine((int)starPos[i][0], starPos[i][1] + offsetY, starPos[i][0] + len, starPos[i][1] + offsetY);
            if (len > 0) {
                g.setColor(255, 255, 255);
                g.drawLine((int)starPos[i][0], starPos[i][1] + offsetY, starPos[i][0] + (len >> 1) + (len >> 2), starPos[i][1] + offsetY);
            }
            ++i;
        }
    }

    public void moveGas() {
        if (Match.players[Match.curRoleIndex].curStatus == 19 && Match.players[Match.curRoleIndex].isHasBall && matchState != 0 && matchState != 1) {
            if (this.gas < 100) {
                GameMap cfr_ignored_0 = Match.engine.map;
                if (Match.players[Match.curRoleIndex].x >= GameMap.MapW / 2) {
                    this.gas = Match.players[Match.curRoleIndex].x < 340 ? (this.gas += this.gasSpeed / 2) : (this.gas += this.gasSpeed);
                }
            } else {
                this.gas = 100;
            }
        } else {
            this.gas = this.gas > 0 ? (this.gas -= 4) : 0;
        }
    }

    public void drawGas(int x, int y) {
        block5: {
            block4: {
                if (GameRole.gasTime > 0) {
                    this.gas = 100;
                }
                Tools.addObject(70, x + 3, y - 10, 0, 0, 51, 12, 36, (byte)0, 800);
                if (this.gas < 100) break block4;
                if (GameEngine.gameTimes % 2 == 0) break block5;
            }
            Tools.addObject(70, x + 3, y - 10 - 1, 0, 12, 51 * this.gas / 100, 12, 36, (byte)0, 900);
        }
    }

    public void drawItemList(int x, int y, int itemIndex) {
        Tools.addObject(70, x + 3, y - 10 - 1, 0, 12, 51 * this.gas / 100, 12, 36, (byte)0, 900);
    }

    public void drawSingleItem(int x, int y, int itemIndex) {
        MyGameCanvas cfr_ignored_0 = Match.engine.canvas;
        Tools.addObject(86, x, y, MyGameCanvas.roleItem[itemIndex] > 0 ? 0 : 54, 0, 27, 27, 20, (byte)0, 500);
        Tools.addObject(44, x + 3, y + 2, itemIndex % 5 * 21, itemIndex / 5 * 23, 21, 23, 20, (byte)0, 501);
        MyGameCanvas cfr_ignored_1 = Match.engine.canvas;
        Match.drawNumber((byte)62, MyGameCanvas.roleItem[itemIndex], x + 18, y + 2, 7, 20, 502);
    }

    static {
        startTeam = 0;
        basket = new short[][]{{30, 165}, {410, 165}};
        defLine = new short[]{163, 285};
        left_throwPoint = new short[][]{{51, 128}, {88, 162}, {51, 192}, {114, 121}, {85, 233}, {152, 155}, {119, 205}};
        right_throwPoint = new short[][]{{395, 128}, {360, 162}, {395, 192}, {334, 121}, {363, 233}, {296, 155}, {330, 205}};
        rdmArray = new byte[6];
        matchTime = 600;
        scoreLeft = 0;
        scoreRight = 0;
        twoPointLeft = 0;
        twoPointRight = 0;
        twoPointInLeft = 0;
        twoPointInRight = 0;
        threePointLeft = 0;
        threePointRight = 0;
        threePointInLeft = 0;
        threePointInRight = 0;
        doubleLeft = 0;
        doubleRight = 0;
        attackLeft = 0;
        attackRight = 0;
        skillLeft = 0;
        skillRight = 0;
        speedOfScroll = 8;
    }
}

