/*
 * Decompiled with CFR 0.152.
 */
import gcom.SplashCanvas;
import java.io.IOException;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GmodeSystem
extends Canvas
implements Runnable,
CommandListener,
constfileSystem {
    private static final Command cmdNull = new Command("  ", 1, 1);
    private Display devDisp;
    private static final int STATUS_INIT = 0;
    private static final int STATUS_MAIN = 1;
    private static int systemState;
    private static final Font kfont;
    public static Image[] loadImg;
    static int regist0;
    static int regist1;
    private String[] cmdMap = new String[]{"/yes.png", "/no.png", "/menu.png", "/logo/yes.png", "/logo/no.png", ""};
    private static final int CONTINUE_PROGRAM = 1;
    private static final int TERMINATE_PROGRAM = 2;
    public static final int END_OF_SYSTEM = Integer.MIN_VALUE;
    private static final int EXCEPTION_PROGRAM = -2;
    private static volatile int currentMainStatus;
    private static volatile int currentID;
    private static volatile int pastID;
    private static GmodeModel currentClass;
    private static GmodeModel nextClass;
    private static GmodeModel[] appModel;
    private static final int MAX_ADD_CLASS = 2;
    private static boolean enableDelClass;
    private static Exception excpt;
    public static int screenWidth;
    public static int screenHeight;
    public static int phaseNumber;
    public static int offsetWidth;
    public static int offsetHeight;
    private static MIDlet application;
    private static boolean isResume;
    private static int numOfSoftKey;
    private final int[] GAME_KEY_TABLE = new int[]{12, 13, -1, -1, 14, 15, -1, 16};
    private final int[] PHONE_KEY_TABLE;
    private volatile int[] keyBuffer;
    private volatile int keyBufferTop;
    private volatile int keyBufferBottom;
    private volatile int keyBitStatus;
    private static volatile int cmdL;
    private static volatile int cmdR;
    public static boolean IsMute;

    static {
        kfont = Font.getFont((int)64, (int)1, (int)16);
        loadImg = new Image[6];
        regist0 = -1;
        regist1 = -1;
    }

    public void hideNotify() {
        if (currentClass != null && GmodeSystem.currentClass.lintaoStop == 0) {
            GmodeSystem.currentClass.oldMode = GmodeModel.gameMode;
            currentClass.changeGameMode(9);
            GmodeSystem.currentClass.lintaoStop = 1;
            GmodeModel.cmdL1 = cmdL;
            GmodeModel.cmdR1 = cmdR;
            GmodeSoundPlayer.stopTrackSound(0, true);
            this.setSoftkey(cmdNull, cmdNull);
            GmodeSystem.setSoftkeyUse(-1, -1);
        }
    }

    public void showNotify() {
        isResume = true;
        this.clearKey();
    }

    private void setSoftkey(Command cmdnull2, Command cmdnull3) {
    }

    public void devVibrate(int duration) {
        if (GmodeModel.Vib == 0) {
            try {
                this.devDisp.vibrate(duration);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public GmodeSystem(MIDlet app) {
        int[] nArray = new int[23];
        nArray[0] = 11;
        nArray[1] = -1;
        nArray[2] = -1;
        nArray[3] = -1;
        nArray[4] = -1;
        nArray[5] = -1;
        nArray[6] = -1;
        nArray[7] = 10;
        nArray[8] = -1;
        nArray[9] = -1;
        nArray[10] = -1;
        nArray[11] = -1;
        nArray[12] = -1;
        nArray[14] = 1;
        nArray[15] = 2;
        nArray[16] = 3;
        nArray[17] = 4;
        nArray[18] = 5;
        nArray[19] = 6;
        nArray[20] = 7;
        nArray[21] = 8;
        nArray[22] = 9;
        this.PHONE_KEY_TABLE = nArray;
        application = app;
        systemState = 0;
        numOfSoftKey = 2;
        this.devDisp = Display.getDisplay((MIDlet)application);
        phaseNumber = 1;
        this.setFullScreenMode(true);
        this.keyBuffer = new int[32];
        screenWidth = this.getWidth();
        screenHeight = this.getHeight();
        offsetWidth = 0;
        offsetHeight = 0;
        if (screenWidth - 136 > 0) {
            offsetWidth = (screenWidth - 136) / 2;
        }
        if (screenHeight - 160 > 0) {
            offsetHeight = (screenHeight - 160) / 2;
        }
        appModel = new GmodeModel[2];
        currentID = -1;
        pastID = -1;
    }

    public final void paint(Graphics g) {
        if (systemState == 0) {
            return;
        }
        if (currentMainStatus == -2) {
            return;
        }
        try {
            currentClass.paintAll(g);
            this.softKeyView(g);
        }
        catch (Exception e) {
            excpt = e;
            currentMainStatus = -2;
        }
    }

    public final void flushBuffer() {
        this.repaint();
        this.serviceRepaints();
    }

    public final void flushBuffer(int x, int y, int w, int h) {
        this.repaint(x, y, w, h);
        this.serviceRepaints();
    }

    void softKeyView(Graphics g) {
        int vh;
        g.setFont(kfont);
        int vw = 240;
        int soft_y = vh = 320;
        if (kaerutenshiMain_ph3.linEixt) {
            g.setColor(0xFFFFFF);
        } else {
            g.setColor(0);
        }
        if (regist0 >= 0) {
            if (loadImg[regist0] == null) {
                GmodeSystem.loadImg[GmodeSystem.regist0] = this.loadImage(this.cmdMap[regist0]);
            }
            if (loadImg[regist0] != null) {
                g.drawImage(loadImg[regist0], 2, soft_y - 30, 4 | 0x10);
            }
        }
        if (regist1 >= 0) {
            if (loadImg[regist1] == null) {
                GmodeSystem.loadImg[GmodeSystem.regist1] = this.loadImage(this.cmdMap[regist1]);
            }
            if (loadImg[regist1] != null) {
                g.drawImage(loadImg[regist1], vw - 2, soft_y - 30, 8 | 0x10);
            }
        }
    }

    public static void setSoftkeyUse(int cl, int cr) {
        regist0 = cl;
        regist1 = cr;
        cmdL = regist0;
        cmdR = regist1;
    }

    public final synchronized void setSoftkeyL(int cl) {
        GmodeSystem.setSoftkeyUse(cl, cmdR);
    }

    public final synchronized void setSoftkeyR(int cr) {
        GmodeSystem.setSoftkeyUse(cmdL, cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getKey() {
        GmodeModel gmodeModel = currentClass;
        synchronized (gmodeModel) {
            block4: {
                if (this.keyBufferTop != this.keyBufferBottom) break block4;
                return -1;
            }
            int i = this.keyBuffer[this.keyBufferTop];
            this.keyBufferTop = this.keyBufferTop + 1 & 0x1F;
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearKey() {
        GmodeModel gmodeModel = currentClass;
        synchronized (gmodeModel) {
            this.keyBufferTop = this.keyBufferBottom;
            this.keyBitStatus = 0;
        }
    }

    private void addKeyBuffer(int param) {
        int t = this.keyBufferTop & 0x1F;
        int len = this.keyBufferBottom - t & 0x1F;
        if (len < 30) {
            this.keyBuffer[this.keyBufferBottom] = param;
            this.keyBufferBottom = this.keyBufferBottom + 1 & 0x1F;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getKeyBitState() {
        int k = -1;
        if (currentClass != null) {
            GmodeModel gmodeModel = currentClass;
            synchronized (gmodeModel) {
                k = this.keyBitStatus;
                this.keyBitStatus &= 0xFFFDFFFF;
                this.keyBitStatus &= 0xFFFBFFFF;
            }
        }
        return k;
    }

    public final void commandAction(Command cmd, Displayable disp) {
    }

    public final synchronized void keyPressed(int k) {
        int key = this.getKeyNumber(k);
        if (key != -1) {
            this.addKeyBuffer(key);
            this.keyBitStatus |= 1 << key;
        }
    }

    public final synchronized void keyReleased(int k) {
        int key = this.getKeyNumber(k);
        if (key != -1) {
            this.keyBitStatus &= ~(1 << key);
        }
    }

    private int getKeyNumber(int k) {
        if (k == -7) {
            return 18;
        }
        if (k == -6) {
            return 17;
        }
        if (k >= 1 && k <= 12) {
            return this.GAME_KEY_TABLE[k - 1];
        }
        if (k >= 35 && k <= 57) {
            return this.PHONE_KEY_TABLE[k - 35];
        }
        if (8 == (k = this.getGameAction(k))) {
            return 16;
        }
        if (1 == k) {
            return 12;
        }
        if (6 == k) {
            return 15;
        }
        if (2 == k) {
            return 13;
        }
        if (5 == k) {
            return 14;
        }
        return -1;
    }

    public final void setCurrentApplication(int id) {
        currentClass = appModel[id];
        currentClass.entrySystem(this, pastID);
    }

    public final void entryAppModel(GmodeModel v, int id) {
        this.removeAppModel(id);
        GmodeSystem.appModel[id] = v;
    }

    private synchronized void removeAppModel(int id) {
        if (appModel[id] != null) {
            appModel[id].destroy();
            GmodeSystem.appModel[id] = null;
            System.gc();
        }
    }

    public final boolean isRegisteredClass(int id) {
        return appModel[id] != null;
    }

    public final void quitCurrentApplication(int next, boolean isDel) {
        if (next == Integer.MIN_VALUE) {
            currentMainStatus = Integer.MIN_VALUE;
        } else {
            if (next < 0 || next >= 2 || appModel[next] == null) {
                throw new IllegalArgumentException("[ GmodeSystem ]: next ID is Illegal. your nextID is: " + next);
            }
            if (next == currentID) {
                return;
            }
            currentMainStatus = 2;
            pastID = currentID;
            enableDelClass = isDel;
            currentID = next;
        }
    }

    public final void quitCurrentApplication(GmodeModel a, int next, boolean isDel) {
        if (next == Integer.MIN_VALUE) {
            this.quitCurrentApplication(Integer.MIN_VALUE, false);
            return;
        }
        if (a == null || next < 0 || next >= 2) {
            throw new IllegalArgumentException("GmodeSystem: next ID is Illegal or GmodeModel is null. your nextID: " + next);
        }
        currentMainStatus = 2;
        pastID = currentID;
        enableDelClass = isDel;
        currentID = next;
        nextClass = a;
    }

    public final void run() {
        systemState = 1;
        currentID = 0;
        enableDelClass = false;
        SplashCanvas logoCanvas = new SplashCanvas();
        this.devDisp.setCurrent((Displayable)logoCanvas);
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!SplashCanvas.isEnd);
        IsMute = !SplashCanvas.enableSoundEffect;
        logoCanvas = null;
        System.gc();
        this.devDisp.setCurrent((Displayable)this);
        while (true) {
            if (enableDelClass) {
                this.removeAppModel(pastID);
                enableDelClass = false;
            }
            if (nextClass != null) {
                this.entryAppModel(nextClass, currentID);
                nextClass = null;
            }
            this.setCurrentApplication(currentID);
            int rslt = this.runCurrentMain();
            if (rslt == -2) {
                GmodeSystem.setSoftkeyUse(-1, -1);
                currentClass.applicationError(excpt);
                GmodeSystem.errorDisplay(excpt);
                continue;
            }
            if (rslt == Integer.MIN_VALUE) break;
        }
        application.notifyDestroyed();
        while (true) {
            Thread.yield();
        }
    }

    private int runCurrentMain() {
        long now = 0L;
        long past = 0L;
        try {
            this.clearKey();
            currentClass.initProgram();
            currentMainStatus = 1;
            while (currentMainStatus == 1) {
                now = System.currentTimeMillis() + 100L;
                currentClass.mainProgram();
                past = now - System.currentTimeMillis();
                if (past <= 0L || past > 100L) continue;
                Thread.sleep(past);
            }
        }
        catch (Exception e) {
            excpt = e;
            currentMainStatus = -2;
        }
        return currentMainStatus;
    }

    public static final void errorDisplay(Exception e) {
        Alert alert = new Alert("\u9519\u8bef", "\u53d1\u751f\u9519\u8bef\uff0c\u8bf7\u9000\u51fa", null, AlertType.ERROR);
        alert.setTimeout(Integer.MAX_VALUE);
        Display d = Display.getDisplay((MIDlet)application);
        d.setCurrent((Displayable)alert);
        while (true) {
            if (!isResume) {
                continue;
            }
            isResume = false;
            d.setCurrent((Displayable)alert);
        }
    }

    public final void restartSystem() {
        isResume = true;
        this.clearKey();
    }

    public final void suspendSystem() {
        this.hideNotify();
    }

    public final void setIsResumed(boolean b) {
        isResume = b;
    }

    public final boolean isResumed() {
        return isResume;
    }

    public final int getSoftKeyNum() {
        return numOfSoftKey;
    }

    public final Font getFont(int size) {
        if (size == 0) {
            return Font.getDefaultFont();
        }
        if (size == 1) {
            return Font.getFont((int)0, (int)0, (int)8);
        }
        if (size == 2) {
            return Font.getFont((int)0, (int)0, (int)0);
        }
        if (size == 3) {
            return Font.getFont((int)0, (int)0, (int)16);
        }
        return null;
    }

    public final int getColor(int col) {
        return col;
    }

    public final int getColor(int r, int g, int b) {
        return this.getColor((r << 16) + (g << 8) + b);
    }

    public Image loadImage(String imagePath) {
        if (imagePath == null || imagePath.length() < 1) {
            return null;
        }
        try {
            Image img = Image.createImage((String)imagePath);
            return img;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

