/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.vm;

import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.LuaTable;
import se.krka.kahlua.vm.LuaThread;
import se.krka.kahlua.vm.UpValue;

public class LuaCallFrame {
    public LuaThread thread;
    public LuaClosure closure;
    public int pc;
    public int localBase;
    int returnBase;
    public int nArguments;
    boolean fromLua;
    public boolean insideCoroutine;
    boolean restoreTop;

    public LuaCallFrame(LuaThread thread) {
        this.thread = thread;
    }

    public final void set(int index, Object o2) {
        this.thread.objectStack[this.localBase + index] = o2;
    }

    public final Object get(int index) {
        return this.thread.objectStack[this.localBase + index];
    }

    public int push(Object x2) {
        int top = this.getTop();
        this.setTop(top + 1);
        this.set(top, x2);
        return 1;
    }

    public int push(Object x2, Object y) {
        int top = this.getTop();
        this.setTop(top + 2);
        this.set(top, x2);
        this.set(top + 1, y);
        return 2;
    }

    public int pushNil() {
        return this.push(null);
    }

    public final void stackCopy(int startIndex, int destIndex, int len) {
        this.thread.stackCopy(this.localBase + startIndex, this.localBase + destIndex, len);
    }

    public void stackClear(int startIndex, int endIndex) {
        while (startIndex <= endIndex) {
            this.thread.objectStack[this.localBase + startIndex] = null;
            ++startIndex;
        }
    }

    public void clearFromIndex(int index) {
        if (this.getTop() < index) {
            this.setTop(index);
        }
        this.stackClear(index, this.getTop() - 1);
    }

    public final void setTop(int index) {
        this.thread.setTop(this.localBase + index);
    }

    public void closeUpvalues(int a2) {
        this.thread.closeUpvalues(this.localBase + a2);
    }

    public UpValue findUpvalue(int b2) {
        return this.thread.findUpvalue(this.localBase + b2);
    }

    public int getTop() {
        return this.thread.getTop() - this.localBase;
    }

    public void init() {
        if (this.isLua()) {
            this.pc = 0;
            if (this.closure.prototype.isVararg) {
                this.localBase += this.nArguments;
                this.setTop(this.closure.prototype.maxStacksize);
                int toCopy = Math.min(this.nArguments, this.closure.prototype.numParams);
                this.stackCopy(-this.nArguments, 0, toCopy);
            } else {
                this.setTop(this.closure.prototype.maxStacksize);
            }
        }
    }

    public void setPrototypeStacksize() {
        if (this.isLua()) {
            this.setTop(this.closure.prototype.maxStacksize);
        }
    }

    public void pushVarargs(int index, int n2) {
        int nParams = this.closure.prototype.numParams;
        int nVarargs = this.nArguments - nParams;
        if (nVarargs < 0) {
            nVarargs = 0;
        }
        if (n2 == -1) {
            n2 = nVarargs;
            this.setTop(index + n2);
        }
        if (nVarargs > n2) {
            nVarargs = n2;
        }
        this.stackCopy(-this.nArguments + nParams, index, nVarargs);
        int numNils = n2 - nVarargs;
        if (numNils > 0) {
            this.stackClear(index + nVarargs, index + n2 - 1);
        }
    }

    public LuaTable getEnvironment() {
        if (this.isLua()) {
            return this.closure.env;
        }
        return this.thread.environment;
    }

    public boolean isJava() {
        return !this.isLua();
    }

    public boolean isLua() {
        return this.closure != null;
    }
}

