/*
 * Decompiled with CFR 0.152.
 */
package com.downjoy.j2me.smspack.util;

import com.downjoy.j2me.smspack.util.SMSPackInfoVO;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;

public class SMSPackInfoReader {
    private static final String DJ_SMS_DESC3 = "DJSMSDesc3";
    private static final String DJ_SMS_CODE3 = "DJSMSCode3";
    private static final String DJ_SMS_DEST3 = "DJSMSDest3";
    private static final String DJ_SMS_SHORT_CODE3 = "DJSMSShortCode3";
    private static final String DJ_SMS_CHAN3 = "DJSMSChan3";
    private static final String DJ_SMS_FREE3 = "DJSMSFree3";
    private static final int MAX_CODE_INTEGER = 916132831;
    private static final Random rand = new Random();

    private static String[] getFeeSMSInfo(String cpId, String gameId, String actionId, String eqpId, int feeCode) {
        try {
            String packInfo = SMSPackInfoReader.readBinRaw();
            String code3 = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_CODE3);
            boolean finded = false;
            Vector<String> prefixVector = null;
            if (code3 != null && code3.length() != 0) {
                String codeStr = SMSPackInfoReader.decodeInfo(code3);
                String prefix = null;
                String money = null;
                String[] codes = SMSPackInfoReader.split(codeStr, ";");
                prefixVector = new Vector<String>();
                int i2 = 0;
                int count = codes.length;
                while (i2 < count) {
                    int pos = codes[i2].indexOf("|");
                    if (pos > 0) {
                        prefix = codes[i2].substring(0, pos);
                        money = codes[i2].substring(pos + 1);
                        if (feeCode == Integer.parseInt(money)) {
                            finded = true;
                            prefixVector.addElement(prefix);
                        }
                    }
                    ++i2;
                }
            }
            if (!finded) {
                throw new IllegalArgumentException("\u5fc5\u987b\u63d0\u4f9b\u81f3\u5c11\u4e00\u4e2a\u6536\u8d39\u4ee3\u7801\uff01");
            }
            if (finded) {
                String prefix = (String)prefixVector.elementAt(SMSPackInfoReader.random(prefixVector.size()));
                return SMSPackInfoReader.decodeCode3(packInfo, prefix, String.valueOf(feeCode), cpId, gameId, actionId, eqpId);
            }
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("\u672a\u627e\u5230\u6536\u8d39\u4ee3\u7801\uff01");
        }
    }

    private static String[] decodeCode3(String packInfo, String prefix, String money, String cpId, String gameId, String actionId, String eqpId) {
        String dest3 = SMSPackInfoReader.decodeInfo(SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_DEST3));
        String desc3 = SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_DESC3);
        StringBuffer buf = new StringBuffer();
        String tmp = "#MONEY#";
        int pos = desc3.indexOf(tmp);
        if (pos != -1) {
            buf.append(desc3.substring(0, pos));
            buf.append(money);
            buf.append(desc3.substring(pos + tmp.length()));
            desc3 = buf.toString();
        }
        boolean isShortCode3 = "1".equals(SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_SHORT_CODE3));
        String channel = SMSPackInfoReader.decodeInfo(SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_CHAN3));
        String content = isShortCode3 ? prefix + SMSPackInfoReader.getWordsFromNumber(cpId, gameId, channel) : prefix + cpId + gameId + actionId + eqpId + channel;
        String cofm = SMSPackInfoReader.decodeInfo(SMSPackInfoReader.getFieldValue(packInfo, DJ_SMS_FREE3));
        return new String[]{dest3, content, money, desc3, "2", cofm};
    }

    public static SMSPackInfoVO getSMSPackInfo(String cpId, String gameId, String actionId, String eqpId, int feeCode) throws IllegalArgumentException {
        SMSPackInfoReader.verifyParams(cpId, gameId, actionId, eqpId, feeCode);
        SMSPackInfoVO smsPackInfo = new SMSPackInfoVO();
        eqpId = eqpId == null ? "000" : eqpId;
        actionId = actionId == null ? "00" : actionId;
        String[] feeNumInfo = SMSPackInfoReader.getFeeSMSInfo(cpId, gameId, actionId, eqpId, feeCode);
        smsPackInfo.setFeeSMSNum(feeNumInfo[0]);
        smsPackInfo.setFeeSMSContent(feeNumInfo[1]);
        int price = Integer.parseInt(feeNumInfo[2]);
        smsPackInfo.setFeeSMSUnitPrice(price);
        smsPackInfo.setFeeSMSTitle(feeNumInfo[3]);
        smsPackInfo.setFeeSMSCnt(feeCode / price);
        if ("2".equals(feeNumInfo[4])) {
            smsPackInfo.setFreeSMSNum(feeNumInfo[5]);
            smsPackInfo.setFreeSMSContent(smsPackInfo.getFeeSMSContent());
            smsPackInfo.setNeedConfirm(true);
        }
        return smsPackInfo;
    }

    private static boolean isNumeric(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static void verifyParams(String cpId, String gameId, String actionId, String eqpId, int feeCode) throws IllegalArgumentException {
        if (cpId == null || gameId == null || cpId.length() != 3 || gameId.length() != 3 || !SMSPackInfoReader.isNumeric(cpId) || !SMSPackInfoReader.isNumeric(gameId)) {
            throw new IllegalArgumentException("\u65e0\u6548\u5382\u5546\u3001\u6e38\u620fID\uff01");
        }
        if (!(actionId == null || actionId.length() == 2 && SMSPackInfoReader.isNumeric(actionId))) {
            throw new IllegalArgumentException("\u65e0\u6548\u52a8\u4f5cID\uff01");
        }
        if (!(eqpId == null || eqpId.length() == 3 && SMSPackInfoReader.isNumeric(eqpId))) {
            throw new IllegalArgumentException("\u65e0\u6548\u673a\u578bID\uff01");
        }
        if (feeCode <= 0 || feeCode > 30) {
            throw new IllegalArgumentException("\u65e0\u6548\u8ba1\u8d39\u91d1\u989d\uff01");
        }
        if (feeCode % 2 != 0) {
            throw new IllegalArgumentException("\u65e0\u6548\u8ba1\u8d39\u91d1\u989d\uff01");
        }
    }

    private static String readBinRaw() throws IOException {
        StringBuffer sb = new StringBuffer();
        InputStream is = null;
        try {
            is = new Object().getClass().getResourceAsStream("/dcn.bin");
            byte[] bytes = new byte[512];
            int len = 0;
            while ((len = is.read(bytes)) > 0) {
                sb.append(new String(bytes, 0, len, "UTF-8"));
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return sb.toString().replace('\r', ' ');
    }

    private static String getFieldValue(String src, String key) {
        int pos = src.indexOf("\n");
        int prevPos = 0;
        String line = null;
        while (pos > 0) {
            line = src.substring(prevPos, pos).trim();
            if (line.startsWith(key)) {
                return line.substring(line.indexOf(58) + 1);
            }
            prevPos = pos + 1;
            pos = src.indexOf("\n", prevPos);
        }
        return null;
    }

    private static String[] split(String s2, String token) {
        Vector<String> chips = new Vector<String>();
        int len = token.length();
        int form = 0;
        while (s2.indexOf(token, form) >= form) {
            int start = s2.indexOf(token, form);
            if (start == form) {
                chips.addElement("");
            } else {
                chips.addElement(s2.substring(form, start));
            }
            form = start + len;
        }
        if (form < s2.length()) {
            chips.addElement(s2.substring(form));
        } else {
            chips.addElement("");
        }
        Object[] strs = new String[chips.size()];
        chips.copyInto(strs);
        return strs;
    }

    private static String decodeInfo(String info) {
        String nStr = info.substring(0, info.length() - 1);
        byte[] bytes = nStr.getBytes();
        byte[] nbytes = new byte[bytes.length];
        int i2 = 0;
        while (i2 < bytes.length) {
            byte b2 = bytes[i2];
            if (b2 >= 48 && b2 <= 57) {
                b2 = (byte)(b2 + (b2 <= 50 ? 7 : -3));
            } else if (b2 >= 65 && b2 <= 90) {
                b2 = (byte)(b2 + (b2 <= 67 ? 23 : -3));
            }
            nbytes[i2] = b2;
            ++i2;
        }
        return new String(nbytes);
    }

    private static String getWordsFromNumber(String cpId, String gameId, String channelId) {
        int number = Integer.parseInt(cpId + gameId + channelId);
        if (number > 916132831) {
            throw new IllegalArgumentException("cpId:" + cpId + "gameId:" + gameId + "channelId:" + channelId + ", too large! unsupports!@_@");
        }
        byte[] bytes = new byte[200];
        int i2 = 0;
        while (true) {
            int x2;
            byte b2 = (x2 = number % 62) >= 10 && x2 < 36 ? (byte)(x2 - 10 + 65) : (x2 >= 36 && x2 < 62 ? (byte)(x2 - 36 + 97) : (byte)(x2 - 0 + 48));
            bytes[i2++] = b2;
            if (number < 62) break;
            number = (number - x2) / 62;
        }
        String retVal = new String(SMSPackInfoReader.reverseAndTrim(bytes));
        int diff = 5 - retVal.length();
        if (diff == 0) {
            return retVal;
        }
        StringBuffer sb = new StringBuffer();
        int n2 = 0;
        while (n2 < diff) {
            sb.append('0');
            ++n2;
        }
        sb.append(retVal);
        return sb.toString();
    }

    public static int random(int r2) {
        int random = rand.nextInt();
        if (random < 0) {
            random *= -1;
        }
        return random %= r2;
    }

    private static byte[] reverseAndTrim(byte[] bytes) {
        byte[] bytes2 = new byte[bytes.length];
        int length = 0;
        int i2 = 0;
        while (i2 < bytes.length) {
            byte b2 = bytes[i2];
            if (b2 > 0) {
                ++length;
            }
            bytes2[bytes.length - i2 - 1] = b2;
            ++i2;
        }
        byte[] bytes3 = new byte[length];
        int i3 = 0;
        while (i3 < length) {
            bytes3[i3] = bytes2[bytes2.length - length + i3];
            ++i3;
        }
        return bytes3;
    }
}

