/*
 * Decompiled with CFR 0.152.
 */
package bbs.framework.menu;

import bbs.framework.helper.BBSKeys;
import bbs.framework.models.BBSGame;
import bbs.framework.models.BBSMenu;
import javax.microedition.lcdui.Graphics;

public abstract class BBSZoomMenu
extends BBSMenu {
    private int x;
    private int y;
    private int z;
    private int state = 0;
    private int todir = 1;
    private int tosel = 1;
    private int transEffect;
    private int maxWH;
    public boolean active = false;
    public int cr;
    public int cg;
    public int cb;
    protected static final int horizontal = 1;
    protected static final int vertical = 2;
    protected static final int cross = 3;
    protected static final int box = 4;
    protected static final int star = 5;

    public BBSZoomMenu(BBSGame game) {
        super(game);
        this.x = (int)(game.currentTimeMillis % 9731L) % game.w;
        this.y = (int)(game.currentTimeMillis % 11327L) % game.h;
        this.z = this.maxWH = Math.max(game.w, game.h);
    }

    public void slide(int todirecory, int effect) {
        if (this.state == 0) {
            this.tosel = 1;
            this.todir = todirecory;
            this.state = 1;
            this.transEffect = effect;
        }
    }

    public void setColor(int r, int g, int b) {
        this.cr = r;
        this.cg = g;
        this.cb = b;
    }

    public void keyPress(BBSGame game, BBSKeys kcol, int time) {
        if (kcol.down && this.selection < this.menus[this.directory - 1].length) {
            ++this.selection;
        }
        if (kcol.up && this.selection > 1) {
            --this.selection;
        }
        if (kcol.fire || kcol.lfire) {
            this.doMenuAction(game, this.directory, this.selection);
        }
    }

    public void doAnimation(BBSGame game, int time) {
        if (this.active || this.state != 0) {
            int speed = 4;
            switch (this.state) {
                case 1: {
                    this.z = Math.max(0, this.z + Math.min(-3, -this.z / speed));
                    if (this.z != 0) break;
                    if (this.todir > 0) {
                        this.directory = this.todir;
                        this.selection = this.tosel;
                        this.state = 2;
                    } else {
                        this.state = 0;
                    }
                    BBSGame.sleepDelay(240L);
                    break;
                }
                case 2: {
                    this.z = Math.min(this.maxWH, this.z + Math.max(3, this.z / speed));
                    if (this.z != this.maxWH) break;
                    this.state = 0;
                    this.x = (int)(game.currentTimeMillis % 9731L) % game.w;
                    this.y = (int)(game.currentTimeMillis % 11327L) % game.h;
                }
            }
            if (this.state == 0 && this.todir <= 0) {
                this.active = false;
                this.freeResources(game);
                if (this.todir == 0) {
                    this.menuClosed(game);
                } else {
                    game.quitApp();
                }
            }
        }
    }

    public void drawScreen(BBSGame game, Graphics g) {
        if (this.z < Math.max(game.w, game.h)) {
            g.setColor(this.cr, this.cg, this.cb);
            switch (this.transEffect) {
                case 1: {
                    g.fillRect(0, 0, Math.max(0, game.w / 2 - this.z), game.h);
                    g.fillRect(Math.min(game.w, game.w / 2 + this.z), 0, Math.max(0, game.w - Math.min(game.w, game.w / 2 + this.z)), game.h);
                    g.setColor(255, 255, 255);
                    g.drawRect(Math.max(0, game.w / 2 - this.z), 0, 1, game.h);
                    g.drawRect(Math.min(game.w, game.w / 2 + this.z), 0, 1, game.h);
                    break;
                }
                case 2: {
                    g.fillRect(0, 0, game.w, Math.max(0, game.h / 2 - this.z));
                    g.fillRect(0, Math.min(game.h, game.h / 2 + this.z), game.w, Math.max(0, game.h - Math.min(game.h, game.h / 2 + this.z)));
                    g.setColor(255, 255, 255);
                    g.fillRect(0, Math.max(0, game.h / 2 - this.z), game.w, 1);
                    g.fillRect(0, Math.min(game.h, game.h / 2 + this.z), game.w, 1);
                    break;
                }
                case 3: {
                    g.fillTriangle(0, 0 - this.z, game.w, -this.z, 0, game.h - this.z);
                    g.fillTriangle(game.w, game.h + this.z, 0, game.h + this.z, game.w, this.z);
                    g.setColor(255, 255, 255);
                    g.drawLine(game.w, -this.z, 0, game.h - this.z);
                    g.drawLine(0, game.h + this.z, game.w, this.z);
                    break;
                }
                case 4: {
                    g.fillRect(0, 0, Math.max(0, this.x - this.z), game.h);
                    g.fillRect(Math.min(game.w, this.x + this.z), 0, Math.max(0, game.w - Math.min(game.w, this.x + this.z)), game.h);
                    g.fillRect(0, 0, game.w, Math.max(0, this.y - this.z));
                    g.fillRect(0, Math.min(game.h, this.y + this.z), game.w, Math.max(0, game.h - Math.min(game.h, this.y + this.z)));
                    g.setColor(255, 255, 255);
                    g.drawRect(Math.max(0, this.x - this.z), Math.max(0, this.y - this.z), Math.min(game.w, this.x + this.z) - Math.max(0, this.x - this.z), Math.min(game.h, this.y + this.z) - Math.max(0, this.y - this.z));
                    break;
                }
                case 5: {
                    g.fillTriangle(0, -this.z, game.w, -this.z, game.w / 2, game.h / 2 - this.z);
                    g.fillTriangle(0, game.h + this.z, game.w, game.h + this.z, game.w / 2, game.h / 2 + this.z);
                    g.fillTriangle(-this.z, 0, -this.z, game.h, game.w / 2 - this.z, game.h / 2);
                    g.fillTriangle(game.w + this.z, 0, game.w + this.z, game.h, game.w / 2 + this.z, game.h / 2);
                    g.setColor(255, 255, 255);
                    g.drawLine(0, -this.z, game.w / 2, game.h / 2 - this.z);
                    g.drawLine(game.w, -this.z, game.w / 2, game.h / 2 - this.z);
                    g.drawLine(0, game.h + this.z, game.w / 2, game.h / 2 + this.z);
                    g.drawLine(game.w, game.h + this.z, game.w / 2, game.h / 2 + this.z);
                    g.drawLine(-this.z, 0, game.w / 2 - this.z, game.h / 2);
                    g.drawLine(-this.z, game.h, game.w / 2 - this.z, game.h / 2);
                    g.drawLine(game.w + this.z, 0, game.w / 2 + this.z, game.h / 2);
                    g.drawLine(game.w + this.z, game.h, game.w / 2 + this.z, game.h / 2);
                }
            }
        }
    }
}

