/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

import cn.g9.j2me.game.CanvasBase;
import cn.g9.j2me.game.GraphicsBase;
import cn.g9.j2me.util.Debug;
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Background {
    private CanvasBase cb;
    static boolean isUseBuf;
    static short[][][] mapData;
    static Image[] imgTiles;
    static byte[] layersTileColByImage;
    static boolean isFirstPaint;
    static int layerCount;
    short[] layersRow;
    short[] layersCol;
    static byte[] layersTileW;
    static byte[] layersTileH;
    static Image imgMapBuf;
    static Graphics gMapBuf;
    static GraphicsBase gbMapBuf;
    static int mapBufWidth;
    static int mapBufHeight;
    static int mapRow;
    static int mapCol;
    static int tileWidth;
    static int tileHeight;
    static int mapWidht;
    static int mapHeight;
    static int mapDrawRow;
    static int mapDrawCol;
    static int mapDrawWidth;
    static int mapDrawHeight;
    static int CameraWidth;
    static int CameraHeight;
    public int cameraOffseX;
    public int cameraOffseY;
    static int privTX0;
    static int privTX1;
    static int privTY0;
    static int privTY1;

    public Background(CanvasBase cb, boolean isUseBuf) {
        this.cb = cb;
        Background.isUseBuf = isUseBuf;
    }

    public void loadData(DataInputStream is) {
        try {
            layerCount = is.readUnsignedByte();
            this.layersRow = new short[layerCount];
            this.layersCol = new short[layerCount];
            layersTileW = new byte[layerCount];
            layersTileH = new byte[layerCount];
            mapData = new short[layerCount][][];
            int i = 0;
            while (i < layerCount) {
                this.layersCol[i] = is.readShort();
                this.layersRow[i] = is.readShort();
                Background.layersTileW[i] = is.readByte();
                Background.layersTileH[i] = is.readByte();
                Background.mapData[i] = new short[this.layersRow[i]][this.layersCol[i]];
                int j = 0;
                while (j < this.layersRow[i]) {
                    int k = 0;
                    while (k < this.layersCol[i]) {
                        Background.mapData[i][j][k] = is.readShort();
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            is.close();
            is = null;
            System.gc();
        }
        catch (Exception e) {
            Debug.println(e, "plfd");
        }
    }

    public void setTileImages(Image[] imgs) {
    }

    public void init(int cameraWidth, int cameraHeight) {
        mapRow = this.layersRow[0];
        mapCol = this.layersCol[0];
        tileWidth = layersTileW[0];
        tileHeight = layersTileH[0];
        mapWidht = mapCol * tileWidth;
        mapHeight = mapRow * tileHeight;
        CameraWidth = cameraWidth;
        CameraHeight = cameraHeight;
        mapBufWidth = (cameraWidth + cameraWidth % tileWidth) / tileWidth * tileWidth + tileWidth;
        mapBufHeight = (cameraHeight + cameraHeight % tileHeight) / tileHeight * tileHeight + tileHeight;
        mapDrawRow = mapBufHeight / tileHeight;
        mapDrawCol = mapBufWidth / tileWidth;
        if (isUseBuf) {
            imgMapBuf = Image.createImage((int)mapBufWidth, (int)mapBufHeight);
            gMapBuf = imgMapBuf.getGraphics();
        }
        isFirstPaint = true;
    }

    void releaseMap() {
        mapData = null;
        imgTiles = null;
        this.layersRow = null;
        this.layersCol = null;
        layersTileW = null;
        layersTileH = null;
        imgMapBuf = null;
        gMapBuf = null;
        gbMapBuf = null;
        System.gc();
    }

    void drawMap(GraphicsBase gb, Graphics g, int cameraX, int cameraY) {
        int x0 = cameraX / tileWidth;
        int y0 = (cameraX + CameraWidth) / tileWidth;
        int x1 = cameraY / tileHeight;
        int y1 = (cameraY + CameraHeight) / tileHeight;
        if (isUseBuf) {
            if (isFirstPaint) {
                privTX0 = x0;
                privTX1 = y0;
                privTY0 = x1;
                privTY1 = y1;
                this.drawArea(privTX0, privTY0, privTX1, privTY1);
                isFirstPaint = false;
            } else {
                if (x0 != privTX0 || y0 != privTX1) {
                    if (y0 > privTX1) {
                        this.drawArea(privTX1 + 1, x1, y0, y1);
                    } else {
                        this.drawArea(x0, x1, privTX0 - 1, y1);
                    }
                    privTX0 = x0;
                    privTX1 = y0;
                }
                if (x1 != privTY0 || y1 != privTY1) {
                    if (y1 > privTY1) {
                        this.drawArea(x0, privTY1 + 1, y0, y1);
                    } else {
                        this.drawArea(x0, x1, y0, privTY0 - 1);
                    }
                    privTY0 = x1;
                    privTY1 = y1;
                }
            }
            x0 = cameraX % mapBufWidth;
            y0 = cameraY % mapBufHeight;
            x1 = (cameraX + CameraWidth) % mapBufWidth;
            y1 = (cameraY + CameraHeight) % mapBufHeight;
            if (x1 > x0) {
                if (y1 > y0) {
                    gb.drawRegion(imgMapBuf, x0, y0, CameraWidth, CameraHeight, 0, 0, 0, 20);
                } else {
                    gb.drawRegion(imgMapBuf, x0, y0, CameraWidth, CameraHeight - y1, 0, 0, 0, 20);
                    gb.drawRegion(imgMapBuf, x0, 0, CameraWidth, y1, 0, 0, 0 + CameraHeight - y1, 20);
                }
            } else if (y1 > y0) {
                gb.drawRegion(imgMapBuf, x0, y0, CameraWidth - x1, CameraHeight, 0, 0, 0, 20);
                gb.drawRegion(imgMapBuf, 0, y0, x1, CameraHeight, 0, 0 + CameraWidth - x1, 0, 20);
            } else {
                gb.drawRegion(imgMapBuf, x0, y0, CameraWidth - x1, CameraHeight - y1, 0, 0, 0, 20);
                gb.drawRegion(imgMapBuf, x0, 0, CameraWidth - x1, y1, 0, 0, 0 + CameraHeight - y1, 20);
                gb.drawRegion(imgMapBuf, 0, y0, x1, CameraHeight - y1, 0, 0 + CameraWidth - x1, 0, 20);
                gb.drawRegion(imgMapBuf, 0, 0, x1, y1, 0, 0 + CameraWidth - x1, 0 + CameraHeight - y1, 20);
            }
        } else {
            this.drawArea(x1, x0, y1, y0);
        }
        g.setClip(0, 0, CameraWidth, CameraHeight + 20);
    }

    private void drawArea(int colBen, int rowBen, int colEnd, int rowEnd) {
        gbMapBuf = this.cb.getGraphicsBase(gMapBuf);
        if (rowBen < 0) {
            rowBen = 0;
        }
        if (rowEnd >= mapRow) {
            rowEnd = mapRow - 1;
        }
        if (colBen < 0) {
            colBen = 0;
        }
        if (colEnd >= mapCol) {
            colEnd = mapCol - 1;
        }
        gMapBuf.setColor(0);
        int layer = 0;
        while (layer < layerCount - 1) {
            int i = rowBen;
            while (i <= rowEnd) {
                int j = colBen;
                while (j <= colEnd) {
                    int id = (mapData[layer][i][j] & 0xFFF) - 1;
                    int trans = (mapData[layer][i][j] & 0xF000) >> 12;
                    int x = j % mapDrawCol * tileWidth;
                    int y = i % mapDrawRow * tileHeight;
                    int clipX = id % layersTileColByImage[layer] * tileWidth;
                    int clipY = id / layersTileColByImage[layer] * tileHeight;
                    if (id >= 0) {
                        gbMapBuf.drawRegion(imgTiles[layer], clipX, clipY, tileWidth, tileHeight, trans, x, y, 0);
                    }
                    ++j;
                }
                ++i;
            }
            ++layer;
        }
    }
}

