/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

import cn.g9.j2me.game.GraphicsBase;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public abstract class CanvasBase
extends Canvas {
    public static final int GMK_LEFT = 1;
    public static final int GMK_RIGHT = 2;
    public static final int GMK_UP = 4;
    public static final int GMK_DOWN = 8;
    public static final int GMK_FIRE = 16;
    public static final int GMK_SOFT_FIRE = 32;
    public static final int GMK_SOFT_CANCEL = 64;
    public static final int GMK_5 = 128;
    public static final int GMK_2 = 256;
    public static final int GMK_4 = 512;
    public static final int GMK_6 = 1024;
    public static final int GMK_8 = 2048;
    public static final int GMK_1 = 4096;
    public static final int GMK_3 = 8192;
    public static final int GMK_7 = 16384;
    public static final int GMK_9 = 32768;
    public static final int GMK_0 = 65536;
    public static final int GMK_SEND = 131072;
    public static final int GMK_END = 262144;
    public static final int GMK_STAR = 524288;
    public static final int GMK_POUND = 0x100000;
    protected static int KeySoftFireKey = -1;
    protected static int KeySoftCancelKey = -1;
    protected static int keyCurrent;
    protected static int keyPressed;
    protected static int keyReleased;
    protected static int keyDblPressed;
    protected static int lastPressed;
    protected static int keyTick;
    protected static int fastCurrentKey;
    protected static int keytmp;
    protected static boolean IsKeyTmp;
    protected static int KeyDblTickMax;
    protected static boolean IsSeparateNumberKey;
    protected static int GAMEGMK_QUEUE_SIZE;
    protected static int[] gkQueue;
    protected static int queueStart;
    protected static int queueEnd;

    static {
        GAMEGMK_QUEUE_SIZE = 32;
        gkQueue = new int[GAMEGMK_QUEUE_SIZE];
    }

    public CanvasBase() {
        IsSeparateNumberKey = true;
        KeyDblTickMax = 4;
    }

    public CanvasBase(int KeySoftFireCode, int KeySoftCancelCode) {
        IsSeparateNumberKey = true;
        KeyDblTickMax = 4;
        KeySoftFireKey = KeySoftFireCode;
        KeySoftCancelKey = KeySoftCancelCode;
    }

    protected void paint(Graphics g) {
        GraphicsBase gb = this.getGraphicsBase(g);
        this.paint(gb, g);
    }

    protected abstract void paint(GraphicsBase var1, Graphics var2);

    protected abstract GraphicsBase getGraphicsBase(Graphics var1);

    public static void clearKey() {
        keyCurrent = 0;
        keyPressed = 0;
        keyReleased = 0;
        keyDblPressed = 0;
        lastPressed = 0;
        keyTick = 0;
        fastCurrentKey = 0;
        int i = 0;
        while (i < GAMEGMK_QUEUE_SIZE) {
            CanvasBase.gkQueue[i] = 0;
            ++i;
        }
        queueEnd = 0;
        queueStart = 0;
    }

    private static boolean pushQueue(int gameKey) {
        if ((queueStart + 1) % GAMEGMK_QUEUE_SIZE == queueEnd) {
            return false;
        }
        CanvasBase.gkQueue[CanvasBase.queueStart] = gameKey;
        queueStart = (queueStart + 1) % GAMEGMK_QUEUE_SIZE;
        return true;
    }

    private static int popQueue() {
        if (queueStart == queueEnd) {
            return fastCurrentKey;
        }
        int Key = gkQueue[queueEnd];
        queueEnd = (queueEnd + 1) % GAMEGMK_QUEUE_SIZE;
        return Key;
    }

    public static void updateKey() {
        int currentKey = CanvasBase.popQueue();
        keyPressed = ~keyCurrent & currentKey;
        keyReleased = keyCurrent & ~currentKey;
        keyCurrent = currentKey;
        ++keyTick;
        if (IsKeyTmp) {
            currentKey |= keytmp;
        }
        if (keyPressed != 0) {
            if (lastPressed != 0 && keyTick < KeyDblTickMax && lastPressed == keyPressed) {
                keyDblPressed = keyPressed;
                lastPressed = 0;
            } else {
                keyTick = 0;
                keyDblPressed = 0;
                lastPressed = keyPressed;
            }
        } else if (keyDblPressed != 0) {
            keyDblPressed = 0;
        }
    }

    public static boolean isKeyHold(int gameKey) {
        return (keyCurrent & gameKey) != 0;
    }

    public static boolean isAnyKeyPressed() {
        return keyPressed != 0;
    }

    public static boolean isAnyKeyHold() {
        return keyCurrent != 0;
    }

    public static boolean isKeyDblPressed(int gameKey) {
        return (keyDblPressed & gameKey) != 0;
    }

    public static boolean isKeyPressed(int gameKey) {
        return (keyPressed & gameKey) != 0;
    }

    public static boolean isKeyReleased(int gameKey) {
        return (keyReleased & gameKey) != 0;
    }

    public static void clearKeyHold(int gameKey) {
        CanvasBase.pushQueue(fastCurrentKey &= ~gameKey);
    }

    public static void setIsSeparateNumberKey(boolean isSeparateNumberKey) {
        IsSeparateNumberKey = isSeparateNumberKey;
    }

    public static void setDblTickMax(int keyDblTickMax) {
        KeyDblTickMax = keyDblTickMax;
    }

    protected void keyPressed(int keyCode) {
        int key = this.getKey(keyCode);
        CanvasBase.pushQueue(fastCurrentKey |= key);
    }

    protected void keyReleased(int keyCode) {
        CanvasBase.pushQueue(fastCurrentKey &= ~this.getKey(keyCode));
    }

    private int getKey(int keyCode) {
        int r = 0;
        int gameAction = 0;
        try {
            gameAction = this.getGameAction(keyCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        block1 : switch (gameAction) {
            case 1: {
                r = 4;
                break;
            }
            case 6: {
                r = 8;
                break;
            }
            case 2: {
                r = 1;
                break;
            }
            case 5: {
                r = 2;
                break;
            }
            case 8: {
                r = 16;
                break;
            }
            default: {
                keyCode = Math.abs(keyCode);
                if (KeySoftFireKey == -1) {
                    switch (keyCode) {
                        case 6: 
                        case 22: {
                            r = 32;
                            break;
                        }
                        case 7: 
                        case 21: {
                            r = 64;
                            break;
                        }
                        case 48: {
                            r = 65536;
                            break;
                        }
                        case 49: {
                            r = 4096;
                            break;
                        }
                        case 51: {
                            r = 8192;
                            break;
                        }
                        case 55: {
                            r = 16384;
                            break;
                        }
                        case 57: {
                            r = 32768;
                            break;
                        }
                        case 42: {
                            r = 524288;
                            break;
                        }
                        case 35: {
                            r = 0x100000;
                        }
                    }
                    break;
                }
                if (keyCode == KeySoftFireKey) {
                    r = 32;
                    break;
                }
                if (keyCode == KeySoftCancelKey) {
                    r = 64;
                    break;
                }
                switch (keyCode) {
                    case 48: {
                        r = 65536;
                        break block1;
                    }
                    case 49: {
                        r = 4096;
                        break block1;
                    }
                    case 51: {
                        r = 8192;
                        break block1;
                    }
                    case 55: {
                        r = 16384;
                        break block1;
                    }
                    case 57: {
                        r = 32768;
                        break block1;
                    }
                    case 42: {
                        r = 524288;
                        break block1;
                    }
                    case 35: {
                        r = 0x100000;
                    }
                }
            }
        }
        if (IsSeparateNumberKey) {
            switch (keyCode) {
                case 50: {
                    r = 256;
                    break;
                }
                case 52: {
                    r = 512;
                    break;
                }
                case 54: {
                    r = 1024;
                    break;
                }
                case 56: {
                    r = 2048;
                    break;
                }
                case 53: {
                    r = 128;
                }
            }
        }
        return r;
    }
}

