/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.game;

import cn.g9.j2me.game.GameFrameItem;
import cn.g9.j2me.game.GameGraphics;
import cn.g9.j2me.game.GraphicsBase;
import javax.microedition.lcdui.Graphics;

public abstract class GameFrameBase {
    private GameFrameItem gfi;
    private String title = "";
    public int x;
    public int y;
    public int width;
    public int height;
    public int page;
    private int pressed;
    private int pressedCode;
    private int released;
    private int releasedCode;
    private int rePressed;
    private int rePressedDelayMax = 0;
    private int rePressedDelay;
    private int pressedPointX;
    private int pressedPointY;
    private int releasedPointX;
    private int releasedPointY;
    private boolean isHide;
    private boolean isPauseRuning;

    public GameFrameBase(GameFrameItem gfi, String title, boolean isShow, int x, int y, int width, int height) {
        this.gfi = gfi;
        this.setTitle(title);
        this.setLocation(x, y);
        this.setSize(width, height);
        this.setShow(isShow);
    }

    public GameFrameItem getGameFrameItem() {
        return this.gfi;
    }

    public void close() {
        this.gfi.removeFrame(this);
    }

    public abstract void setPage(int var1, Object[] var2);

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    protected void run() {
        if (this.isHide || this.isPauseRuning) {
            return;
        }
        this.tick();
    }

    public abstract void tick();

    protected void paint(GameGraphics gg) {
        if (this.isHide()) {
            return;
        }
        Graphics g = gg.getGraphics();
        g.translate(this.x, this.y);
        this.draw(gg, g);
        g.translate(-this.x, -this.y);
    }

    public abstract void draw(GraphicsBase var1, Graphics var2);

    protected void pressed(int curPressedState, int keyPressed) {
        if (!this.isPauseRuning) {
            this.pressed = keyPressed;
            this.rePressed = curPressedState;
            this.rePressedDelay = 0;
            this.keyDown(this.pressed, keyPressed);
            this.pressed = 0;
        }
    }

    protected abstract void keyDown(int var1, int var2);

    public int getPressed() {
        int t = this.pressed;
        this.pressed = 0;
        return t;
    }

    public int getPressedCode() {
        int t = this.pressedCode;
        this.pressedCode = 0;
        return t;
    }

    public int getRePressed() {
        if (this.rePressedDelay++ > this.rePressedDelayMax) {
            return this.rePressed;
        }
        return 0;
    }

    public void released(int curReleasedState) {
        if (!this.isPauseRuning) {
            this.released = curReleasedState;
            this.rePressed &= ~curReleasedState;
            this.rePressedDelay = 0;
            this.keyUp(this.released);
        }
    }

    protected abstract void keyUp(int var1);

    public int getReleased() {
        int t = this.released;
        this.released = 0;
        return t;
    }

    public int getReleasedCode() {
        int t = this.releasedCode;
        this.releasedCode = 0;
        return t;
    }

    protected void pointerPressed(int x, int y) {
        this.pressedPointX = x;
        this.pressedPointY = y;
    }

    public int getPressedPoint() {
        int t = this.pressedPointX << 16 | this.pressedPointY;
        this.pressedPointY = 0;
        this.pressedPointX = 0;
        return t;
    }

    public void pointerReleased(int x, int y) {
        this.releasedPointX = x;
        this.releasedPointY = y;
    }

    public int getReleasedPoint() {
        int t = this.releasedPointX << 16 | this.releasedPointY;
        this.releasedPointY = 0;
        this.releasedPointX = 0;
        return t;
    }

    public void pointerDragged(int x, int y) {
    }

    public void clearKey() {
        this.pressed = 0;
        this.pressedCode = 0;
        this.released = 0;
        this.releasedCode = 0;
        this.rePressed = 0;
        this.rePressedDelay = 0;
        this.pressedPointX = 0;
        this.pressedPointY = 0;
        this.releasedPointX = 0;
        this.releasedPointY = 0;
    }

    public void setRePressedDelay(int delay) {
        this.rePressedDelayMax = delay;
    }

    public void setShow(boolean isShow) {
        this.isHide = !isShow;
    }

    public boolean isShow() {
        return !this.isHide;
    }

    public boolean isHide() {
        return this.isHide;
    }

    public void setPauseRuning(boolean isRuning) {
        this.isPauseRuning = !isRuning;
    }

    public boolean isRuning() {
        return !this.isPauseRuning;
    }

    public boolean isPauseRuning() {
        return this.isPauseRuning;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    protected abstract void hideNotify();

    protected abstract void showNotify();
}

