/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.util;

import cn.g9.j2me.game.Animation;
import cn.g9.j2me.util.Debug;
import java.io.DataInputStream;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class Resource {
    public static String PNG_ENDS_WITH = "png";
    public static String ANIM_ENDS_WITH = "anim";
    public static String G9I_ENDS_WITH = "g9i";
    private static Hashtable h_res = new Hashtable();

    public static final Object load(Object key, Object[] args) {
        Object obj = h_res.get(key);
        if (obj == null && key instanceof String) {
            String path = (String)key;
            if (path.toLowerCase().endsWith(PNG_ENDS_WITH)) {
                System.out.print("+" + path);
                obj = Resource.createImage(path);
                h_res.put(path, obj);
                System.out.println(" ok");
            } else if (path.toLowerCase().endsWith(ANIM_ENDS_WITH)) {
                System.out.print("+" + path);
                Animation anim = Resource.createAnimation(path);
                obj = anim;
                h_res.put(path, obj);
                System.out.println(" ok");
            } else if (path.toLowerCase().endsWith(G9I_ENDS_WITH)) {
                int index = (Integer)args[0];
                System.out.print("+" + path);
                obj = Resource.createG9Image(path, index);
                h_res.put(path, obj);
                System.out.println(" ok");
            } else {
                Debug.println("error " + key);
            }
        }
        return obj;
    }

    public static final Animation getAnim(String key) {
        return (Animation)h_res.get(key);
    }

    public static final Animation loadAnim(String key) {
        return (Animation)Resource.load(key, null);
    }

    public static final void load(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            Resource.load(keys[i], null);
            ++i;
        }
    }

    public static final void release(String key) {
        try {
            h_res.remove(key);
            System.out.println("-" + key);
        }
        catch (NullPointerException e) {
            System.out.println("-*" + key);
        }
    }

    public static final void release(String[] keys) {
        int i = 0;
        while (i < keys.length) {
            Resource.release(keys[i]);
            ++i;
        }
        System.gc();
    }

    public static void releaseAll() {
        h_res.clear();
    }

    public static final Image loadG9Image(String key, int index) {
        return (Image)Resource.load(key, new Object[]{new Integer(index)});
    }

    public static final Image loadImage(String key) {
        return (Image)Resource.load(key, null);
    }

    public static final Image getImage(String key) {
        return (Image)h_res.get(key);
    }

    public static final Image createImage(String path) {
        try {
            Debug.println("ccreateImage " + path);
            return Image.createImage((String)path);
        }
        catch (Exception e) {
            Debug.println(e, "can't load " + path);
            return null;
        }
    }

    public static final Animation createAnimation(String path) {
        try {
            Animation anim = new Animation();
            anim.read(path);
            return anim;
        }
        catch (Exception e) {
            Debug.println(e, "can't load " + path);
            return null;
        }
    }

    public static final Image createG9Image(String path, int index) {
        try {
            DataInputStream dis = new DataInputStream(path.getClass().getResourceAsStream(path));
            int fileNum = dis.readUnsignedByte();
            int fileSize = dis.readInt();
            byte[] imgData = new byte[fileSize];
            int headSize = dis.readInt();
            int plteSize = dis.readUnsignedShort();
            int tRNSSize = dis.readUnsignedShort();
            int i = 0;
            while (i < tRNSSize) {
                imgData[i + headSize + plteSize] = dis.readByte();
                ++i;
            }
            dis.skip(index * plteSize);
            i = 0;
            while (i < plteSize) {
                imgData[i + headSize] = dis.readByte();
                ++i;
            }
            dis.skip((fileNum - index - 1) * plteSize);
            i = 0;
            while (i < headSize) {
                imgData[i] = dis.readByte();
                ++i;
            }
            int idatSize = dis.readInt();
            int i2 = 0;
            while (i2 < idatSize) {
                imgData[i2 + headSize + plteSize + tRNSSize] = dis.readByte();
                ++i2;
            }
            dis.close();
            Debug.println("ccreateImage " + path);
            return Image.createImage((byte[])imgData, (int)0, (int)imgData.length);
        }
        catch (Exception e) {
            Debug.println(e, "can't load " + path);
            return null;
        }
    }
}

