/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.rms;

import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class GameDB {
    RecordStore recordStore = null;
    String dbName;

    public GameDB(String dbName) throws RecordStoreException {
        this.dbName = dbName;
        this.recordStore = RecordStore.openRecordStore((String)dbName, (boolean)true);
    }

    public synchronized void close() {
        try {
            this.recordStore.closeRecordStore();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized int addData(byte[] data) throws RecordStoreFullException {
        int r = -1;
        try {
            r = this.recordStore.addRecord(data, 0, data.length);
        }
        catch (RecordStoreFullException rsfe) {
            throw rsfe;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return r;
    }

    public int getSize() {
        int ret = -1;
        try {
            ret = this.recordStore.getSize();
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public synchronized void setRecored(byte[] data, int recordID) throws RecordStoreFullException {
        try {
            this.recordStore.setRecord(recordID, data, 0, data.length);
        }
        catch (RecordStoreFullException rsfe) {
            throw rsfe;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void deleteRecord(int recordID) {
        try {
            if (this.recordStore.getRecordSize(recordID) > 0) {
                this.recordStore.deleteRecord(recordID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized int[] enumerate() {
        RecordEnumeration rEnum = null;
        int len = 0;
        try {
            rEnum = this.recordStore.enumerateRecords(null, null, false);
        }
        catch (RecordStoreNotOpenException ex) {
            ex.printStackTrace();
        }
        len = rEnum.numRecords();
        int[] rIDs = new int[len];
        int i = 0;
        while (i < len) {
            try {
                rIDs[i] = rEnum.nextRecordId();
            }
            catch (InvalidRecordIDException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
        return rIDs;
    }

    public byte[] getRecord(int recordID) {
        byte[] b = null;
        try {
            b = this.recordStore.getRecord(recordID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public int getNumRecords() {
        int ret = -1;
        try {
            ret = this.recordStore.getNumRecords();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int getNextRecordID() {
        int ret = -1;
        try {
            ret = this.recordStore.getNextRecordID();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

