/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.util;

public abstract class MathFp {
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int MIN_VALUE = -2147483647;
    public static final int E = 11134;
    public static final int PI = 12868;
    private static final int[] SIN_TABLE;

    static {
        int[] nArray = new int[91];
        nArray[1] = 71;
        nArray[2] = 142;
        nArray[3] = 214;
        nArray[4] = 285;
        nArray[5] = 357;
        nArray[6] = 428;
        nArray[7] = 499;
        nArray[8] = 570;
        nArray[9] = 641;
        nArray[10] = 711;
        nArray[11] = 781;
        nArray[12] = 851;
        nArray[13] = 921;
        nArray[14] = 990;
        nArray[15] = 1060;
        nArray[16] = 1128;
        nArray[17] = 1197;
        nArray[18] = 1265;
        nArray[19] = 1333;
        nArray[20] = 1400;
        nArray[21] = 1468;
        nArray[22] = 1534;
        nArray[23] = 1600;
        nArray[24] = 1665;
        nArray[25] = 1730;
        nArray[26] = 1795;
        nArray[27] = 1859;
        nArray[28] = 1922;
        nArray[29] = 1985;
        nArray[30] = 2048;
        nArray[31] = 2109;
        nArray[32] = 2170;
        nArray[33] = 2230;
        nArray[34] = 2290;
        nArray[35] = 2349;
        nArray[36] = 2407;
        nArray[37] = 2464;
        nArray[38] = 2521;
        nArray[39] = 2577;
        nArray[40] = 2632;
        nArray[41] = 2686;
        nArray[42] = 2740;
        nArray[43] = 2793;
        nArray[44] = 2845;
        nArray[45] = 2896;
        nArray[46] = 2946;
        nArray[47] = 2995;
        nArray[48] = 3043;
        nArray[49] = 3091;
        nArray[50] = 3137;
        nArray[51] = 3183;
        nArray[52] = 3227;
        nArray[53] = 3271;
        nArray[54] = 3313;
        nArray[55] = 3355;
        nArray[56] = 3395;
        nArray[57] = 3434;
        nArray[58] = 3473;
        nArray[59] = 3510;
        nArray[60] = 3547;
        nArray[61] = 3582;
        nArray[62] = 3616;
        nArray[63] = 3649;
        nArray[64] = 3681;
        nArray[65] = 3712;
        nArray[66] = 3741;
        nArray[67] = 3770;
        nArray[68] = 3797;
        nArray[69] = 3823;
        nArray[70] = 3849;
        nArray[71] = 3872;
        nArray[72] = 3895;
        nArray[73] = 3917;
        nArray[74] = 3937;
        nArray[75] = 3956;
        nArray[76] = 3974;
        nArray[77] = 3991;
        nArray[78] = 4006;
        nArray[79] = 4020;
        nArray[80] = 4033;
        nArray[81] = 4045;
        nArray[82] = 4056;
        nArray[83] = 4065;
        nArray[84] = 4073;
        nArray[85] = 4080;
        nArray[86] = 4086;
        nArray[87] = 4090;
        nArray[88] = 4093;
        nArray[89] = 4095;
        nArray[90] = 4096;
        SIN_TABLE = nArray;
    }

    private MathFp() {
    }

    public static int toFP(int i) {
        return i << 12;
    }

    public static int toFP(String s) {
        int i = 0;
        if (s.charAt(0) == '-') {
            i = 1;
        }
        String s1 = "-1";
        int j = s.indexOf(46);
        if (j >= 0) {
            s1 = s.substring(j + 1, s.length());
            while (s1.length() < 4) {
                s1 = String.valueOf(s1) + "0";
            }
            if (s1.length() > 4) {
                s1 = s1.substring(0, 4);
            }
        } else {
            j = s.length();
        }
        int k = Integer.parseInt(s.substring(i, j));
        int l = Integer.parseInt(s1) + 1;
        int i1 = (k << 12) + (l << 12) / 10000;
        if (i == 1) {
            i1 = -i1;
        }
        return i1;
    }

    public static String toString(int i) {
        boolean flag = false;
        if (i < 0) {
            flag = true;
            i = -i;
        }
        int j = i >> 12;
        int k = 10000 * (i & 0xFFF) >> 12;
        String s = Integer.toString(k);
        while (s.length() < 4) {
            s = "0" + s;
        }
        return String.valueOf(flag ? "-" : "") + Integer.toString(j) + "." + s;
    }

    public static String toString(int i, int j) {
        String s = MathFp.toString(MathFp.round(i, j));
        return s.substring(0, s.length() - 4 + j);
    }

    public static int round(int i, int j) {
        int k = 0;
        if (j < 0 || j > 4) {
            j = 4;
        }
        if (j == 0) {
            k = 2048;
            j = -1;
        }
        if (j == 1) {
            k = 205;
        }
        if (j == 2) {
            k = 20;
        }
        if (j == 3) {
            k = 2;
        }
        if (i < 0) {
            k = -k;
        }
        return i + k;
    }

    public static int toInt(int i) {
        i = i >= 0 ? (i += 2048) : (i -= 2048);
        return i >> 12;
    }

    public static int div(int i, int j) {
        boolean flag = false;
        if (j == 4096) {
            return i;
        }
        if ((j & 0xFFF) == 0) {
            return i / (j >> 12);
        }
        if (i < 0) {
            i = -i;
            flag = true;
        }
        if (j < 0) {
            j = -j;
            flag = !flag;
        }
        int byte0 = 0;
        if (i > 413695) {
            byte0 = 3;
        }
        if (i > 4100095) {
            byte0 = 4;
        }
        if (i > 0x7DFFFF) {
            byte0 = 6;
        }
        if (i > 0x1F4FFFF) {
            byte0 = 8;
        }
        if (i > 0x7DFFFFF) {
            byte0 = 10;
        }
        if (byte0 > 0) {
            int k = 2 << byte0 - 1;
            i += k;
            j += k;
        }
        int l = (i << 12 - byte0) / (j >> byte0);
        return flag ? -l : l;
    }

    public static int mul(int i, int j) {
        boolean flag = false;
        if ((i & 0xFFF) == 0) {
            return (i >> 12) * j;
        }
        if ((j & 0xFFF) == 0) {
            return i * (j >> 12);
        }
        if (i < 0 && j > 0 || i > 0 && j < 0) {
            flag = true;
        }
        if (i < 0) {
            i = -i;
        }
        if (j < 0) {
            j = -j;
        }
        int byte0 = 0;
        if (i > 413695 || j > 413695) {
            byte0 = 2;
        }
        if (i > 4100095 || j > 4100095) {
            byte0 = 4;
        }
        if (i > 41025535 || j > 41025535) {
            byte0 = 6;
        }
        if (byte0 > 0) {
            int k = 2 << byte0 - 1;
            i += k;
            j += k;
        }
        int l = (i >> 12) * (j >> 12) << 12;
        int i1 = (i & 0xFFF) * (j & 0xFFF) >> 12;
        if ((l = l + (i1 += ((i & 0xFFFFF000) >> byte0) * ((j & 0xFFF) >> byte0) >> 12 - (byte0 << 1)) + (((i & 0xFFF) >> byte0) * ((j & 0xFFFFF000) >> byte0) >> 12 - (byte0 << 1))) < 0) {
            throw new ArithmeticException("Overflow");
        }
        return flag ? -l : l;
    }

    public static int add(int i, int j) {
        return i + j;
    }

    public static int sub(int i, int j) {
        return i - j;
    }

    public static int abs(int i) {
        if (i < 0) {
            return -i;
        }
        return i;
    }

    public static int sqrt(int i, int j) {
        if (i < 0) {
            throw new ArithmeticException("Input Error");
        }
        if (i == 0) {
            return 0;
        }
        int k = i + 4096 >> 1;
        int l = 0;
        while (l < j) {
            k = k + MathFp.div(i, k) >> 1;
            ++l;
        }
        if (k < 0) {
            throw new ArithmeticException("Overflow");
        }
        return k;
    }

    public static int sqrt(int i) {
        int byte0 = 8;
        if (i > 409600) {
            byte0 = 12;
        }
        if (i > 4096000) {
            byte0 = 16;
        }
        return MathFp.sqrt(i, byte0);
    }

    public static int sin(int i) {
        int j = 0;
        while (i < 0) {
            i += 25736;
        }
        if (i > 25736) {
            i %= 25736;
        }
        int k = i * 10 / 714;
        if (i != 0 && i != 6434 && i != 12868 && i != 19302 && i != 25736) {
            j = i * 100 / 714 - k * 10;
        }
        if (k <= 90) {
            return MathFp.sin_lookup(k, j);
        }
        if (k <= 180) {
            return MathFp.sin_lookup(180 - k, j);
        }
        if (k <= 270) {
            return -MathFp.sin_lookup(k - 180, j);
        }
        return -MathFp.sin_lookup(360 - k, j);
    }

    private static int sin_lookup(int i, int j) {
        if (j > 0 && j < 10 && i < 90) {
            return SIN_TABLE[i] + (SIN_TABLE[i + 1] - SIN_TABLE[i]) / 10 * j;
        }
        return SIN_TABLE[i];
    }

    public static int cos(int i) {
        return MathFp.sin(i + 6435);
    }

    public static int tan(int i) {
        int j = MathFp.div(MathFp.sin(i), MathFp.cos(i));
        return j;
    }

    public static int cot(int i) {
        int j = MathFp.div(MathFp.toFP(1), MathFp.tan(i));
        return j;
    }

    public static int min(int i, int j) {
        return j >= i ? i : j;
    }

    public static int max(int i, int j) {
        return i >= j ? i : j;
    }

    public static int asin(int i) {
        boolean flag = false;
        if (i < 0) {
            flag = true;
        }
        if (MathFp.abs(i) > 4096) {
            throw new ArithmeticException("Input error");
        }
        i = MathFp.abs(i);
        int j = 0;
        int k = SIN_TABLE.length;
        int l = 0;
        while (l < SIN_TABLE.length) {
            int i1 = MathFp.abs(i - SIN_TABLE[l]);
            if (i1 < k) {
                k = i1;
                j = l;
            }
            ++l;
        }
        if (flag) {
            return -(j * 72);
        }
        return j * 72;
    }

    public static int acos(int i) {
        return 6434 - MathFp.asin(i);
    }

    public static int exp(int i) {
        int j = MathFp.abs(i) >> 12;
        if (j > 13) {
            throw new ArithmeticException("Overflow");
        }
        int[] ai = new int[]{4096, 11134, 30266, 82270, 223634, 607900, 1652444, 4491809, 12210004, 33190232, 90220404, 245244484, 666643625, 1812125254};
        int k = ai[j];
        int l = MathFp.abs(i) & 0xFFF;
        if (l > 0) {
            int i1 = 0;
            int j1 = 4096;
            int k1 = 1;
            int l1 = 0;
            while (l1 < 6) {
                i1 += j1 / k1;
                j1 = MathFp.mul(j1, l);
                k1 *= l1 + 1;
                ++l1;
            }
            k = MathFp.mul(k, i1);
        }
        if (i < 0) {
            return MathFp.div(4096, k);
        }
        return k;
    }

    public static int log(int i) {
        if (i <= 0) {
            throw new ArithmeticException("Input error");
        }
        int j = 0;
        boolean flag = false;
        int l = 0;
        while (i > 8192) {
            i >>= 1;
            ++l;
        }
        int i1 = l * 2839;
        int j1 = 0;
        i -= 4096;
        int k1 = 1;
        while (k1 < 11) {
            int k = j == 0 ? i : MathFp.mul(j, i);
            if (k == 0) break;
            j1 += (k1 % 2 != 0 ? 1 : -1) * k / k1;
            j = k;
            ++k1;
        }
        return i1 + j1;
    }

    public static int pow(int i, int j) {
        boolean flag = false;
        int k = 1;
        if (j < 0) {
            flag = true;
            j = -j;
        }
        if (MathFp.abs(i) < 4096 && j > 12288) {
            k = MathFp.exp(MathFp.mul(MathFp.log(i), j));
        } else {
            k = MathFp.pow_int(i, j >> 12);
            if ((j & 0xFFF) != 0) {
                k = MathFp.mul(k, MathFp.exp(MathFp.mul(MathFp.log(i), j & 0xFFF)));
            }
        }
        if (flag) {
            return MathFp.div(4096, k);
        }
        return k;
    }

    public static int hypot(int fa, int fb) {
        try {
            return MathFp.sqrt(MathFp.add(MathFp.pow(fa, MathFp.toFP(2)), MathFp.pow(fb, MathFp.toFP(2))));
        }
        catch (Exception e) {
            return 0;
        }
    }

    private static int pow_int(int i, int j) {
        int k = 4096;
        if (i == 0) {
            return 0;
        }
        int l = 0;
        while (l < j) {
            k = MathFp.mul(k, i);
            ++l;
        }
        if (k < 0) {
            throw new ArithmeticException("Overflow");
        }
        return k;
    }
}

