/*
 * Decompiled with CFR 0.152.
 */
package cn.g9.j2me.util;

import cn.g9.j2me.util.Debug;
import cn.g9.j2me.util.Scriptable;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Stack;

public class Script {
    private Scriptable scriptable;
    public static boolean IsPause;
    public static final int STATUS_STOP = 0;
    public static final int STATUS_RUN = 1;
    public static final int STATUS_WHAT = 2;
    private int status = 0;
    private int runingCount = 0;
    private Stack stack_call;
    public short[] var;
    private short curInsId = (short)-1;
    private String[] str;
    public int curPoint;
    private int curfunPoint;
    private int[][][] fun;
    private int[][] curFun;
    private String file;
    private static final int NUMBER_ERROR = 0x7F7F7F7F;
    private static byte FALSE;
    private static byte TRUE;
    boolean isSleep = false;
    private int sleepTime;
    public static final byte TOKEN_IDENTIFIER = -10;
    public static final byte TOKEN_IDENTIFER_VAR = -11;
    public static final byte TOKEN_IDENTIFER_CON = -12;
    public static final byte TOKEN_CIDEN_IDENTIFER = -13;
    public static final byte TOKEN_INTEGER = -14;
    public static final byte TOKEN_STRING = -15;
    public static final byte TOKEN_BOOLEAN = -16;
    public static final byte TOKEN_OSYMBOL = -17;
    public static final byte T_OSYMBOL_GT = -10;
    public static final byte T_OSYMBOL_LT = -11;
    public static final byte T_OSYMBOL_EQ = -12;
    public static final byte T_OSYMBOL_LE = -13;
    public static final byte T_OSYMBOL_GE = -14;
    public static final byte T_OSYMBOL_NE = -15;
    public static final byte T_OSYMBOL_SC_AND = -16;
    public static final byte T_OSYMBOL_SC_OR = -17;
    public static final byte T_ASYMBOL_PLUS = -18;
    public static final byte T_ASYMBOL_MINUS = -19;
    public static final byte T_ASYMBOL_STAR = -20;
    public static final byte T_ASYMBOL_SLASH = 21;
    public static final byte T_OSYMBOL_REM = -22;
    public static final short ID_IF = -1;
    public static final short ID_GOTO = -2;
    public static final short ID_BREAK = -3;
    public static final short ID_RETURN = -4;
    public static final short ID_WHILE = -5;
    public static final short ID_CALL = -6;
    public static final short ID_SETVAR = -7;
    public static final short ID_LOAD = -8;
    public static final short ID_RELEASE = -9;
    public static final short ID_RUN_SCRIPT_FILE = -10;
    public static final short ID_SLEEP = -11;
    public boolean isLoad;

    static {
        FALSE = 0;
        TRUE = 1;
    }

    public Script(Scriptable scriptable) {
        this.scriptable = scriptable;
    }

    public void loadData(String file, boolean saveVar) {
        try {
            this.isLoad = true;
            this.file = file;
            System.out.println("scriptFile " + file);
            DataInputStream dis = new DataInputStream(file.getClass().getResourceAsStream(file));
            if (saveVar) {
                this.var = this.readVar(dis, 0);
            }
            this.release();
            this.fun = this.readFun(dis, 0);
            this.str = this.readString(dis, 0);
            dis.close();
            this.sleepTime = 0;
            this.curInsId = (short)-1;
            this.stack_call = new Stack();
            this.call(0, 0, false);
            this.run();
            this.isLoad = false;
        }
        catch (IOException e) {
            Debug.println(e, "no " + file);
            e.printStackTrace();
        }
    }

    public void release() {
        this.curFun = null;
        this.fun = null;
        this.str = null;
        System.gc();
    }

    public String getFile() {
        return this.file;
    }

    private short[] readVar(DataInputStream dis, int spik) throws IOException {
        if (spik > 0) {
            dis.skip(spik);
        }
        int varCount = dis.readUnsignedShort();
        short[] var = new short[varCount];
        int i = 0;
        while (i < varCount) {
            var[i] = dis.readShort();
            ++i;
        }
        return var;
    }

    private int[][][] readFun(DataInputStream dis, int spik) throws IOException {
        if (spik > 0) {
            dis.skip(spik);
        }
        int funCount = dis.readUnsignedShort();
        int[][][] fun = new int[funCount][][];
        int i = 0;
        while (i < funCount) {
            int insCount = dis.readUnsignedShort();
            fun[i] = new int[insCount][];
            int j = 0;
            while (j < insCount) {
                int parCount = dis.readUnsignedByte();
                fun[i][j] = new int[parCount];
                int k = 0;
                while (k < parCount) {
                    int newValue;
                    byte flag = dis.readByte();
                    short value = dis.readShort();
                    fun[i][j][k] = newValue = flag << 16 | value & 0xFFFF;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return fun;
    }

    private String[] readString(DataInputStream dis, int spik) throws IOException {
        if (spik > 0) {
            dis.skip(spik);
        }
        int strCount = dis.readUnsignedShort();
        String[] str = new String[strCount];
        int i = 0;
        while (i < strCount) {
            int len = dis.readShort();
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < len) {
                sb.append(dis.readChar());
                ++j;
            }
            str[i] = sb.toString();
            ++i;
        }
        return str;
    }

    /*
     * Unable to fully structure code
     */
    private void runFun() {
        if (this.curFun != null) ** GOTO lbl6
        return;
        while (this.curFun != null && !Script.IsPause) {
            this.runCommand(this.curFun, this.curPoint);
            ++this.curPoint;
lbl6:
            // 2 sources

            if (this.curPoint < this.curFun.length && this.status == 2) continue;
        }
        if (!Script.IsPause) {
            if (!this.stack_call.isEmpty()) {
                fAndP = (int[])this.stack_call.pop();
                this.call(fAndP[0], fAndP[1], false);
                this.runFun();
            } else if (this.status == 2) {
                this.curPoint = 0;
                this.call(1, 0, false);
            }
        }
    }

    public void run() {
        if (this.isLoad || IsPause) {
            return;
        }
        this.runFun();
        if (this.sleepTime > 0) {
            --this.sleepTime;
            if (this.sleepTime <= 0) {
                this.toWaitStatus();
                this.sleepTime = 0;
            }
        }
    }

    public void runCommand(int[][] curFun, int curPoint) {
        this.curInsId = (short)curFun[curPoint][0];
        switch (this.curInsId) {
            case -1: {
                int gotoP = this.getValue(curPoint, this.getCurFunParSize() - 1);
                if (this.ifStatement(curPoint) != FALSE) break;
                this.curPoint = gotoP;
                break;
            }
            case -2: {
                curPoint = this.getValue(curPoint, this.getCurFunParSize() - 1);
                break;
            }
            case -3: {
                break;
            }
            case -4: {
                break;
            }
            case -5: {
                this.whileStatement();
                break;
            }
            case -6: {
                this.call(this.getShortValue(curPoint, 1), curPoint, true);
                --curPoint;
                --this.curPoint;
                break;
            }
            case -7: {
                short result = this.getCurFunParSize() > 3 ? this.operationExpression(this.getValue(curPoint, 2), (byte)this.getValue(curPoint, 4), this.getValue(curPoint, 3)) : (short)this.getValue(curPoint, 2);
                if (this.isVar(curPoint, 1)) {
                    this.setVar(this.getShortValue(curPoint, 1), result);
                    break;
                }
                this.scriptable.script_setCiden(this.getShortValue(curPoint, 1), result);
                break;
            }
            case -8: {
                this.scriptable.open(this.getValue(1), this.getBooean(2), this.getStringValue(3), this.getBooean(4));
                curPoint = -1;
                return;
            }
            case -9: {
                this.release();
                break;
            }
            case -10: {
                break;
            }
            case -11: {
                this.sleepTime = this.getShortValue(curPoint, 1);
                this.toRunStatus();
                break;
            }
            default: {
                this.scriptable.scriptFunction(this.curInsId);
            }
        }
    }

    public void call(int funId, int curPoint, boolean isPush) {
        if (isPush) {
            this.stack_call.push(new int[]{this.curfunPoint, this.curPoint + 1});
            this.curPoint = 0;
        } else {
            this.curPoint = curPoint;
        }
        this.curfunPoint = funId;
        this.curFun = this.fun[funId];
        this.status = 2;
    }

    private short operationExpression(int l, byte op, int r) {
        switch (op) {
            case -18: {
                return (short)(l + r);
            }
            case -19: {
                return (short)(l - r);
            }
            case -20: {
                return (short)(l * r);
            }
            case 21: {
                return (short)(l / r);
            }
            case -22: {
                return (short)(l % r);
            }
        }
        return (short)l;
    }

    private void whileStatement() {
    }

    private byte ifStatement(int curPoint) {
        int size = this.getCurFunParSize() >> 2;
        byte[] stack_tmp = new byte[size - 1];
        byte[][] stack_exp = new byte[size][2];
        byte result = 1;
        int i = 0;
        while (i < size) {
            short l = (short)this.getValue(curPoint, 1 + (i << 2));
            short r = (short)this.getValue(curPoint, 2 + (i << 2));
            byte op = (byte)this.getValue(curPoint, 3 + (i << 2));
            byte token = (byte)this.getValue(curPoint, 4 + (i << 2));
            stack_exp[i][0] = result = Script.comp(l, op, r);
            stack_exp[i][1] = token;
            if (i > 0) {
                int tmpCount = i >> 1;
                stack_tmp[tmpCount] = Script.comPcondition(stack_exp[i - 1][0], stack_exp[i - 1][1], result);
                if (stack_exp[i - 1][1] == -17 && stack_tmp[tmpCount] == TRUE || result == TRUE) {
                    result = TRUE;
                    break;
                }
                result = (byte)(result & stack_tmp[tmpCount]);
            }
            ++i;
        }
        return result;
    }

    private static byte comPcondition(int l, byte op, int r) {
        switch (op) {
            case -16: {
                return l == TRUE && r == TRUE ? TRUE : FALSE;
            }
            case -17: {
                return l == TRUE || r == TRUE ? TRUE : FALSE;
            }
        }
        return FALSE;
    }

    private static byte comp(short l, byte op, short r) {
        switch (op) {
            case -10: {
                return l > r ? TRUE : FALSE;
            }
            case -11: {
                return l < r ? TRUE : FALSE;
            }
            case -12: {
                return l == r ? TRUE : FALSE;
            }
            case -13: {
                return l <= r ? TRUE : FALSE;
            }
            case -14: {
                return l >= r ? TRUE : FALSE;
            }
            case -15: {
                return l != r ? TRUE : FALSE;
            }
        }
        return FALSE;
    }

    public int getCurInsId() {
        return this.curInsId;
    }

    public boolean getBooean(int index) {
        return this.getShortValue(index) == TRUE;
    }

    private String getStringValue(int curPoint, int index) {
        int value = this.getValue(curPoint, index);
        if (value == 0x7F7F7F7F) {
            return this.str[this.getShortValue(curPoint, index)];
        }
        return "";
    }

    public String getStringValue(int index) {
        return this.getStringValue(this.curPoint, index);
    }

    private int getValue(int curPoint, int index) {
        if (this.isVar(curPoint, index)) {
            return this.var[this.getShortValue(curPoint, index)];
        }
        if (this.isCIden(curPoint, index)) {
            return this.scriptable.script_getCiden(this.getShortValue(curPoint, index));
        }
        if (this.isInt(curPoint, index) || this.isOsymbol(curPoint, index) || this.isBoolean(curPoint, index)) {
            return this.getShortValue(curPoint, index);
        }
        return 0x7F7F7F7F;
    }

    public void setVar(int index, short value) {
        this.var[index] = value;
    }

    public int getValue(int index) {
        return this.getValue(this.curPoint, index);
    }

    public int getShortValue(int index) {
        return this.getShortValue(this.curPoint, index);
    }

    public int getCurFunParSize() {
        return this.curFun[this.curPoint].length;
    }

    private short getShortValue(int curPoint, int index) {
        return (short)this.curFun[curPoint][index];
    }

    private byte getToken(int curPoint, int i) {
        return (byte)(this.curFun[curPoint][i] >> 16);
    }

    private boolean isVar(int curPoint, int i) {
        return this.getToken(curPoint, i) == -11;
    }

    private boolean isInt(int curPoint, int i) {
        return this.getToken(curPoint, i) == -14;
    }

    private boolean isOsymbol(int curPoint, int i) {
        return this.getToken(curPoint, i) == -17;
    }

    private boolean isBoolean(int curPoint, int i) {
        return this.getToken(curPoint, i) == -16;
    }

    private boolean isCIden(int curPoint, int i) {
        return this.getToken(curPoint, i) == -13;
    }

    public void toStopStatus() {
        this.status = 0;
    }

    public void toWaitStatus() {
        --this.runingCount;
        if (this.runingCount <= 0) {
            this.runingCount = 0;
            this.status = 2;
        }
    }

    public void toRunStatus() {
        ++this.runingCount;
        this.status = 1;
    }

    public int[][] getFun(int fPoi) {
        return this.fun[fPoi];
    }
}

